# Theory Manual

The Theory Manual exists to explain some of the underlying concepts behind OpenMDAO in more detail. It is not intended to show you how to use any specific features of OpenMDAO, but rather to understand why you might choose to use a feature. It provides information in a more theoretical and mathematical manner to help users gain a deeper understanding of how the framework operates.


- [OpenMDAO Class Structure](class_structure.ipynb)
- [Understanding How Variables Work](implicit_transformation_of_vars.ipynb)
- [The System Setup Stack: Understanding When to Use setup and configure](setup_stack.ipynb)
- [OpenMDAO Solvers](solver_api.ipynb)
- [Scaling Variables in OpenMDAO](scaling.ipynb)
- [Determining How Many Times a System was Executed](iter_count.ipynb)
- [Using OpenMDAO with MPI](mpi.ipynb)

## Total Derivatives Theory

- [How Total Derivatives are Computed](total_derivs_theory.ipynb)
- [Setting Up a Model for Efficient Linear Solves](setup_linear_solvers.ipynb)
- [Advanced Linear Solver Algorithms for Special Cases](advanced_linear_solvers_special_cases/advanced_linear_solvers_special_cases.md)
