/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.ExportAction;
import net.sf.sdedit.editor.Shortcuts;
import net.sf.sdedit.editor.TabAction;
import net.sf.sdedit.editor.TabActivator;
import net.sf.sdedit.multipage.MultipageExporter;
import net.sf.sdedit.ui.Tab;
import net.sf.sdedit.ui.UserInterface;
import net.sf.sdedit.ui.components.buttons.Activator;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.impl.DiagramTab;
import net.sf.sdedit.ui.impl.DiagramTextTab;
import net.sf.sdedit.ui.impl.SequenceDiagramTextTab;
import net.sf.sdedit.util.Utilities;

public final class Actions
implements Constants {
    private Editor editor;
    private UserInterface ui;
    public final Activator canConfigureActivator;
    public final Activator nonEmptyDiagramActivator;
    public final Activator noDiagramErrorActivator;
    public final Activator canNarrowActivator;
    public final Activator textTabActivator;
    public final Activator diagramTabActivator;
    public final Activator verticalSplitPossibleActivator;
    public final Activator horizontalSplitPossibleActivator;
    public final Activator supportsFullScreenActivator;
    public final Activator canCloseActivator;
    public final Activator nextActivator;
    public final Activator previousActivator;
    public final Activator homeActivator;
    final Action clearAction;
    final Action configureGloballyAction;
    final Action configureDiagramAction;
    final Action helpAction;
    final Action tutorialAction;
    final Action helpOnMultithreadingAction;
    final Action asyncNotesAction;
    final Action newSequenceDiagramAction;
    final Action closeAllAction;
    final Action closeTabAction;
    final Action quitAction;
    final Action redrawAction;
    final Action widenAction;
    final Action narrowAction;
    final Action redoAction;
    final Action undoAction;
    final Action showAboutDialogAction;
    final Action fullScreenAction;
    final Action filterAction;
    final Action serverAction;
    final Action splitLeftRightAction;
    final Action splitTopBottomAction;
    final Action copyBitmapToClipBoardAction;
    final Action copyVectorGraphicsToClipBoardAction;
    final Action previousAction;
    final Action nextAction;
    final Action homeAction;
    public final Activator exportMapFileActivator;

    Actions(Editor _editor) {
        this.editor = _editor;
        this.ui = this.editor.getUI();
        if (this.ui == null) {
            throw new IllegalStateException("ui reference must not be null");
        }
        this.canConfigureActivator = new TabActivator<DiagramTab>(DiagramTab.class, this.ui){

            @Override
            protected boolean _isEnabled(DiagramTab tab) {
                return tab.getConfiguration() != null;
            }
        };
        this.canCloseActivator = new TabActivator<Tab>(Tab.class, this.ui){

            @Override
            protected boolean _isEnabled(Tab tab) {
                return tab.canClose();
            }
        };
        this.exportMapFileActivator = new TabActivator<SequenceDiagramTextTab>(SequenceDiagramTextTab.class, this.ui){

            @Override
            protected boolean _isEnabled(SequenceDiagramTextTab tab) {
                return !tab.isEmpty() && tab.getFile() != null;
            }
        };
        this.nonEmptyDiagramActivator = new TabActivator<DiagramTab>(DiagramTab.class, this.ui){

            @Override
            protected boolean _isEnabled(DiagramTab tab) {
                return !tab.isEmpty();
            }
        };
        this.noDiagramErrorActivator = new TabActivator<DiagramTab>(DiagramTab.class, this.ui){

            @Override
            protected boolean _isEnabled(DiagramTab tab) {
                return !tab.isEmpty() && tab.getDiagramError() == null;
            }
        };
        this.canNarrowActivator = new TabActivator<DiagramTab>(DiagramTab.class, this.ui){

            @Override
            protected boolean _isEnabled(DiagramTab tab) {
                if (tab.getConfiguration().getDataObject().isA(SequenceConfiguration.class)) {
                    SequenceConfiguration conf = tab.getConfiguration().getDataObject().cast(SequenceConfiguration.class);
                    return conf.getGlue() > 0;
                }
                return false;
            }
        };
        this.textTabActivator = new TabActivator<DiagramTextTab>(DiagramTextTab.class, this.ui){

            @Override
            protected boolean _isEnabled(DiagramTextTab tab) {
                return true;
            }
        };
        this.diagramTabActivator = new TabActivator<DiagramTab>(DiagramTab.class, this.ui){

            @Override
            protected boolean _isEnabled(DiagramTab tab) {
                return true;
            }
        };
        this.verticalSplitPossibleActivator = new TabActivator<DiagramTextTab>(DiagramTextTab.class, this.ui){

            @Override
            protected boolean _isEnabled(DiagramTextTab tab) {
                return !tab.getConfiguration().getDataObject().isVerticallySplit();
            }
        };
        this.horizontalSplitPossibleActivator = new TabActivator<DiagramTextTab>(DiagramTextTab.class, this.ui){

            @Override
            protected boolean _isEnabled(DiagramTextTab tab) {
                return tab.getConfiguration().getDataObject().isVerticallySplit();
            }
        };
        this.supportsFullScreenActivator = new TabActivator<Tab>(Tab.class, this.ui){

            @Override
            protected boolean _isEnabled(Tab tab) {
                return tab.supportsFullScreen();
            }
        };
        this.nextActivator = new TabActivator<Tab>(Tab.class, this.ui){

            @Override
            protected boolean _isEnabled(Tab tab) {
                return this.ui.getTabContainer().nextTabExists();
            }
        };
        this.previousActivator = new TabActivator<Tab>(Tab.class, this.ui){

            @Override
            protected boolean _isEnabled(Tab tab) {
                return this.ui.getTabContainer().previousTabExists();
            }
        };
        this.homeActivator = new TabActivator<Tab>(Tab.class, this.ui){

            @Override
            protected boolean _isEnabled(Tab tab) {
                return tab.canGoHome();
            }
        };
        this.clearAction = new TabAction<DiagramTextTab>(DiagramTextTab.class, this.ui){
            {
                this.putValue("IconName", "eraser");
                this.putValue("ShortDescription", "Erase the source code");
                this.putValue("Name", Shortcuts.getShortcut(0) + "&Erase code");
            }

            @Override
            protected void _actionPerformed(DiagramTextTab tab, ActionEvent e) {
                tab.getTextArea().setText("");
            }
        };
        this.configureGloballyAction = new AbstractAction(){
            {
                this.putValue("IconName", "globalsettings");
                this.putValue("ActionID", "GLOBAL_SETTINGS");
                this.putValue("ShortDescription", "Edit global preferences");
                this.putValue("Name", Shortcuts.getShortcut(1) + "&Global preferences...");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.editor.getUI().configure(null);
            }
        };
        this.configureDiagramAction = new TabAction<DiagramTab>(DiagramTab.class, this.ui){
            {
                this.putValue("IconName", "configure");
                this.putValue("ActionID", "LOCAL_SETTINGS");
                this.putValue("ShortDescription", "Edit diagram preferences");
                this.putValue("Name", Shortcuts.getShortcut(2) + "&Diagram preferences...");
            }

            @Override
            protected void _actionPerformed(DiagramTab tab, ActionEvent e) {
                Actions.this.editor.getUI().configure(tab.getConfiguration());
            }
        };
        this.helpAction = new AbstractAction(){
            {
                this.putValue("IconName", "help");
                this.putValue("ActionID", "HELP");
                this.putValue("ShortDescription", "Display a comprehensive help page");
                this.putValue("Name", Shortcuts.getShortcut(3) + "&Help");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.editor.getUI().help("Help", "help", true);
            }
        };
        this.tutorialAction = new AbstractAction(){
            {
                this.putValue("IconName", "help");
                this.putValue("ShortDescription", "Display a tutorial");
                this.putValue("Name", "&Tutorial");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.editor.getUI().help("Tutorial", "tutorial", true);
            }
        };
        this.helpOnMultithreadingAction = new AbstractAction(){
            {
                this.putValue("IconName", "help");
                this.putValue("ShortDescription", "Show a help page dedicated to multithreading");
                this.putValue("Name", "&Multithreading help");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.editor.getUI().help("Multithreading help", "multithreading_help", false);
            }
        };
        this.asyncNotesAction = new AbstractAction(){
            {
                this.putValue("IconName", "help");
                this.putValue("ShortDescription", "Show a help page containing notes on asynchronous messages");
                this.putValue("Name", "&Notes on asynchronous messages");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.editor.getUI().help("Notes on asynchronous messages", "async", false);
            }
        };
        this.newSequenceDiagramAction = new AbstractAction(){
            {
                this.putValue("IconName", "new");
                this.putValue("ActionID", "NEW_DIAGRAM");
                this.putValue("Name", Shortcuts.getShortcut(5) + "&New diagram");
                this.putValue("ShortDescription", "Add a tab for a new sequence diagram");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Bean<SequenceConfiguration> conf = ConfigurationManager.createNewDefaultConfiguration(SequenceConfiguration.class);
                Actions.this.editor.getUI().addSequenceDiagramTextTab("untitled", conf, true);
            }
        };
        this.closeAllAction = new AbstractAction(){
            {
                this.putValue("IconName", "close");
                this.putValue("Name", Shortcuts.getShortcut(6) + "Close All");
                this.putValue("ShortDescription", "Close all tabs");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.editor.closeAll();
            }
        };
        this.closeTabAction = new TabAction<Tab>(Tab.class, this.ui){
            {
                this.putValue("IconName", "close");
                this.putValue("Name", Shortcuts.getShortcut(7) + "&Close");
                this.putValue("ShortDescription", "Close the current tab");
            }

            @Override
            protected void _actionPerformed(Tab tab, ActionEvent e) {
                tab.close(true);
            }
        };
        this.quitAction = new AbstractAction(){
            {
                this.putValue("IconName", "exit");
                this.putValue("ShortDescription", "Quit the application");
                this.putValue("Name", Shortcuts.getShortcut(8) + "&Quit");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.editor.quit();
            }
        };
        this.redrawAction = new TabAction<DiagramTab>(DiagramTab.class, this.ui){
            {
                this.putValue("IconName", "reload");
                this.putValue("ActionID", "RELOAD");
                this.putValue("Name", Shortcuts.getShortcut(21) + "Re&draw");
                this.putValue("ShortDescription", "Redraw the diagram");
            }

            @Override
            protected void _actionPerformed(DiagramTab tab, ActionEvent e) {
                tab.refresh(true);
            }
        };
        this.widenAction = new TabAction<DiagramTab>(DiagramTab.class, this.ui){
            {
                this.putValue("IconName", "widen");
                this.putValue("ShortDescription", "Widen the diagram");
                this.putValue("Name", Shortcuts.getShortcut(12) + "&Widen");
            }

            @Override
            protected void _actionPerformed(DiagramTab tab, ActionEvent e) {
                SequenceConfiguration conf = tab.getConfiguration().getDataObject().cast(SequenceConfiguration.class);
                if (conf != null) {
                    conf.setGlue(conf.getGlue() + ConfigurationManager.getGlobalConfiguration().getGlueChangeAmount());
                }
            }
        };
        this.narrowAction = new TabAction<DiagramTab>(DiagramTab.class, this.ui){
            {
                this.putValue("IconName", "narrow");
                this.putValue("ShortDescription", "Narrow the diagram");
                this.putValue("Name", Shortcuts.getShortcut(13) + "&Narrow");
            }

            @Override
            protected void _actionPerformed(DiagramTab tab, ActionEvent e) {
                SequenceConfiguration conf = tab.getConfiguration().getDataObject().cast(SequenceConfiguration.class);
                if (conf != null) {
                    int glue = Math.max(0, conf.getGlue() - ConfigurationManager.getGlobalConfiguration().getGlueChangeAmount());
                    conf.setGlue(glue);
                }
            }
        };
        this.redoAction = new TabAction<DiagramTextTab>(DiagramTextTab.class, this.ui){
            {
                this.putValue("Name", Shortcuts.getShortcut(15) + "&Redo");
                this.putValue("ShortDescription", "Redo the typing that has most recently been undone");
                this.putValue("IconName", "redo");
            }

            @Override
            protected void _actionPerformed(DiagramTextTab tab, ActionEvent evt) {
                tab.redo();
            }
        };
        this.undoAction = new TabAction<DiagramTextTab>(DiagramTextTab.class, this.ui){
            {
                this.putValue("Name", Shortcuts.getShortcut(14) + "&Undo");
                this.putValue("ShortDescription", "Undo the typing that has most recently been done");
                this.putValue("IconName", "undo");
            }

            @Override
            protected void _actionPerformed(DiagramTextTab tab, ActionEvent evt) {
                tab.undo();
            }
        };
        this.showAboutDialogAction = new AbstractAction(){
            {
                this.putValue("Name", "About");
                this.putValue("IconName", "help");
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                Actions.this.editor.getUI().showAboutDialog(Utilities.getResource("about.html"));
            }
        };
        this.fullScreenAction = new TabAction<Tab>(Tab.class, this.ui){
            {
                this.putValue("Name", Shortcuts.getShortcut(16) + "&Full screen");
                this.putValue("IconName", "fullscreen");
                this.putValue("ActionID", "FULL_SCREEN");
                this.putValue("ShortDescription", "Display the diagram in full-screen mode");
            }

            @Override
            protected void _actionPerformed(Tab tab, ActionEvent evt) {
                if (tab.supportsFullScreen()) {
                    tab.fullScreen();
                }
            }
        };
        this.filterAction = new TabAction<DiagramTextTab>(DiagramTextTab.class, this.ui){
            {
                this.putValue("Name", Shortcuts.getShortcut(17) + "&Filter...");
                this.putValue("IconName", "filter");
                this.putValue("ShortDescription", "Filter the (selected) text through a command");
            }

            @Override
            protected void _actionPerformed(DiagramTextTab tab, ActionEvent evt) {
                tab.toggleFilterMode();
            }
        };
        this.serverAction = new AbstractAction(){
            {
                this.putValue("Name", "Start/stop &RT server...");
                this.putValue("IconName", "server");
                this.putValue("ShortDescription", "Start or stop a server that receives diagram specifications through sockets");
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (Actions.this.editor.isServerRunning()) {
                    if (Actions.this.editor.getUI().confirmOrCancel("Stop real-time diagram server?") == 1) {
                        Actions.this.editor.shutDownServer();
                    }
                    return;
                }
                String port = String.valueOf(ConfigurationManager.getGlobalConfiguration().getRealtimeServerPort());
                port = Actions.this.editor.getUI().getString("Enter the port where the real-time diagram\nserver should listen (0 for any free port):", port);
                if (port == null || port.equals("")) {
                    return;
                }
                try {
                    int p = Integer.parseInt(port);
                    int actualPort = Actions.this.editor.startRealtimeServer(p);
                    ConfigurationManager.getGlobalConfiguration().setRealtimeServerPort(p);
                    Actions.this.editor.getUI().message("Started real-time diagram server@localhost:" + actualPort);
                }
                catch (Exception e) {
                    Actions.this.editor.getUI().errorMessage(e, null, "The real-time diagram server could not be started.");
                }
            }
        };
        this.splitLeftRightAction = new TabAction<DiagramTextTab>(DiagramTextTab.class, this.ui){
            {
                this.putValue("Name", Shortcuts.getShortcut(18) + "Editor on left");
                this.putValue("ActionID", "SPLIT_LEFT_RIGHT");
                this.putValue("IconName", "view_left_right");
                this.putValue("ShortDescription", "Editor on left");
            }

            @Override
            protected void _actionPerformed(DiagramTextTab tab, ActionEvent evt) {
                tab.layout(0);
            }
        };
        this.splitTopBottomAction = new TabAction<DiagramTextTab>(DiagramTextTab.class, this.ui){
            {
                this.putValue("Name", Shortcuts.getShortcut(19) + "Editor on bottom");
                this.putValue("ActionID", "SPLIT_TOP_BOTTOM");
                this.putValue("IconName", "view_top_bottom");
                this.putValue("ShortDescription", "Editor on bottom");
            }

            @Override
            protected void _actionPerformed(DiagramTextTab tab, ActionEvent evt) {
                tab.layout(1);
            }
        };
        this.copyBitmapToClipBoardAction = new TabAction<DiagramTab>(DiagramTab.class, this.ui){
            {
                this.putValue("Name", "Copy diagram (as bitmap)");
                this.putValue("ActionID", "COPY_BITMAP_TO_CLIPBOARD");
                this.putValue("IconName", "image");
                this.putValue("ShortDescription", "Copy diagram (as bitmap)");
            }

            @Override
            protected void _actionPerformed(DiagramTab tab, ActionEvent evt) {
                tab.copyToClipboard(DataFlavor.imageFlavor);
            }
        };
        this.copyVectorGraphicsToClipBoardAction = new TabAction<DiagramTab>(DiagramTab.class, this.ui){
            {
                this.putValue("Name", "Copy diagram (as vector graphics)");
                this.putValue("ActionID", "COPY_VG_TO_CLIPBOARD");
                this.putValue("IconName", "image");
                this.putValue("ShortDescription", "Copy diagram (as vector graphics)");
            }

            @Override
            protected void _actionPerformed(DiagramTab tab, ActionEvent evt) {
                tab.copyToClipboard(DiagramTab.EMF_FLAVOR);
            }
        };
        this.nextAction = new TabAction<Tab>(Tab.class, this.ui){
            {
                this.putValue("Name", Shortcuts.getShortcut(24) + "Go to next tab");
                this.putValue("ActionID", "GO_TO_NEXT_TAB");
                this.putValue("IconName", "next");
                this.putValue("ShortDescription", "Go to next tab");
            }

            @Override
            protected void _actionPerformed(Tab tab, ActionEvent evt) {
                this.ui.getTabContainer().goToNextTab();
            }
        };
        this.previousAction = new TabAction<Tab>(Tab.class, this.ui){
            {
                this.putValue("Name", Shortcuts.getShortcut(25) + "Go to previous tab");
                this.putValue("ActionID", "GO_TO_PREVIOUS_TAB");
                this.putValue("IconName", "previous");
                this.putValue("ShortDescription", "Go to previous tab");
            }

            @Override
            protected void _actionPerformed(Tab tab, ActionEvent evt) {
                this.ui.getTabContainer().goToPreviousTab();
            }
        };
        this.homeAction = new TabAction<Tab>(Tab.class, this.ui){
            {
                this.putValue("Name", "Go home");
                this.putValue("ActionID", "GO_HOME");
                this.putValue("IconName", "gohome");
                this.putValue("ShortDescription", "Go home");
            }

            @Override
            protected void _actionPerformed(Tab tab, ActionEvent evt) {
                tab.goHome();
            }
        };
    }

    final Action getExampleAction(final String name, final String file) {
        return new AbstractAction(){
            {
                this.putValue("Name", name);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = this.getClass().getResource("/net/sf/sdedit/examples/" + file);
                    DiagramTextTab tab = (DiagramTextTab)Actions.this.editor.load(url);
                    if (tab != null) {
                        tab.setFile(null);
                        tab.setTitle(file);
                    }
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception ex) {
                    Actions.this.editor.getUI().errorMessage(ex, null, "Loading example from classpath failed");
                }
            }
        };
    }

    final Action getRecentFileAction(final String fileName) {
        return new AbstractAction(){
            {
                this.putValue("Name", new File(fileName).getName());
                this.putValue("ShortDescription", new File(fileName).getAbsolutePath());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Actions.this.editor.load(new File(fileName).toURI().toURL());
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception ex) {
                    Editor.getEditor().getUI().errorMessage(ex, null, null);
                }
            }
        };
    }

    final Action getExportAction() {
        return new ExportAction(this.editor);
    }

    final Action getPrintAction(final String filetype) {
        if (!MultipageExporter.isAvailable()) {
            return null;
        }
        return new TabAction<DiagramTab>(DiagramTab.class, this.ui){
            {
                super(tabClass, ui);
                this.putValue("IconName", filetype);
                this.putValue("ActionID", "MULTI_PAGE_EXPORT");
                this.putValue("ShortDescription", "Prints or exports the diagram in multi-page " + filetype.toUpperCase() + " format");
                this.putValue("Name", Shortcuts.getShortcut(20) + "&Print/export multi-page " + filetype.toUpperCase() + "...");
            }

            @Override
            protected void _actionPerformed(DiagramTab tab, ActionEvent e) {
                this.ui.showPrintDialog(filetype, tab);
            }
        };
    }
}

