# SPDX-License-Identifier: GPL-2.0-or-later
# CAP: Categories, Algorithms, Programming
#
# Declarations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecord.gi

#! @Chapter Add Functions

#! @Section Available Add functions

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `AdditionForMorphisms`.
#! $F: ( a, b ) \mapsto \mathtt{AdditionForMorphisms}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddAdditionForMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddAdditionForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddAdditionForMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddAdditionForMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `AdditiveGenerators`.
#! $F: (  ) \mapsto \mathtt{AdditiveGenerators}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddAdditiveGenerators",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddAdditiveGenerators",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddAdditiveGenerators",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddAdditiveGenerators",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `AdditiveInverseForMorphisms`.
#! $F: ( a ) \mapsto \mathtt{AdditiveInverseForMorphisms}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddAdditiveInverseForMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddAdditiveInverseForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddAdditiveInverseForMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddAdditiveInverseForMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `AstrictionToCoimage`.
#! $F: ( alpha ) \mapsto \mathtt{AstrictionToCoimage}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddAstrictionToCoimage",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddAstrictionToCoimage",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddAstrictionToCoimage",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddAstrictionToCoimage",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `AstrictionToCoimageWithGivenCoimageObject`.
#! $F: ( alpha, C ) \mapsto \mathtt{AstrictionToCoimageWithGivenCoimageObject}(alpha, C)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddAstrictionToCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddAstrictionToCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddAstrictionToCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddAstrictionToCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `BasisOfExternalHom`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{BasisOfExternalHom}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddBasisOfExternalHom",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddBasisOfExternalHom",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddBasisOfExternalHom",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddBasisOfExternalHom",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CanonicalIdentificationFromCoimageToImageObject`.
#! $F: ( alpha ) \mapsto \mathtt{CanonicalIdentificationFromCoimageToImageObject}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCanonicalIdentificationFromCoimageToImageObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCanonicalIdentificationFromCoimageToImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCanonicalIdentificationFromCoimageToImageObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCanonicalIdentificationFromCoimageToImageObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CanonicalIdentificationFromImageObjectToCoimage`.
#! $F: ( alpha ) \mapsto \mathtt{CanonicalIdentificationFromImageObjectToCoimage}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCanonicalIdentificationFromImageObjectToCoimage",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCanonicalIdentificationFromImageObjectToCoimage",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCanonicalIdentificationFromImageObjectToCoimage",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCanonicalIdentificationFromImageObjectToCoimage",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoastrictionToImage`.
#! $F: ( alpha ) \mapsto \mathtt{CoastrictionToImage}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoastrictionToImage",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoastrictionToImage",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoastrictionToImage",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoastrictionToImage",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoastrictionToImageWithGivenImageObject`.
#! $F: ( alpha, I ) \mapsto \mathtt{CoastrictionToImageWithGivenImageObject}(alpha, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoastrictionToImageWithGivenImageObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoastrictionToImageWithGivenImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoastrictionToImageWithGivenImageObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoastrictionToImageWithGivenImageObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoefficientsOfMorphismWithGivenBasisOfExternalHom`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{CoefficientsOfMorphismWithGivenBasisOfExternalHom}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoefficientsOfMorphismWithGivenBasisOfExternalHom",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoefficientsOfMorphismWithGivenBasisOfExternalHom",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoefficientsOfMorphismWithGivenBasisOfExternalHom",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoefficientsOfMorphismWithGivenBasisOfExternalHom",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Coequalizer`.
#! $F: ( arg2 ) \mapsto \mathtt{Coequalizer}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoequalizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoequalizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoequalizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoequalizerFunctorial`.
#! $F: ( morphisms, mu, morphismsp ) \mapsto \mathtt{CoequalizerFunctorial}(morphisms, mu, morphismsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoequalizerFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoequalizerFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoequalizerFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoequalizerFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoequalizerFunctorialWithGivenCoequalizers`.
#! $F: ( P, morphisms, mu, morphismsp, Pp ) \mapsto \mathtt{CoequalizerFunctorialWithGivenCoequalizers}(P, morphisms, mu, morphismsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoequalizerFunctorialWithGivenCoequalizers",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoequalizerFunctorialWithGivenCoequalizers",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoequalizerFunctorialWithGivenCoequalizers",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoequalizerFunctorialWithGivenCoequalizers",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoimageObject`.
#! $F: ( arg2 ) \mapsto \mathtt{CoimageObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoimageObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoimageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoimageObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoimageObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoimageProjection`.
#! $F: ( alpha ) \mapsto \mathtt{CoimageProjection}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoimageProjection",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoimageProjection",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoimageProjection",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoimageProjection",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoimageProjectionWithGivenCoimageObject`.
#! $F: ( alpha, C ) \mapsto \mathtt{CoimageProjectionWithGivenCoimageObject}(alpha, C)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoimageProjectionWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoimageProjectionWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoimageProjectionWithGivenCoimageObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoimageProjectionWithGivenCoimageObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelColift`.
#! $F: ( alpha, T, tau ) \mapsto \mathtt{CokernelColift}(alpha, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelColift",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCokernelColift",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCokernelColift",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCokernelColift",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelColiftWithGivenCokernelObject`.
#! $F: ( alpha, T, tau, P ) \mapsto \mathtt{CokernelColiftWithGivenCokernelObject}(alpha, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelColiftWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCokernelColiftWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCokernelColiftWithGivenCokernelObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCokernelColiftWithGivenCokernelObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelObject`.
#! $F: ( arg2 ) \mapsto \mathtt{CokernelObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCokernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCokernelObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCokernelObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelObjectFunctorial`.
#! $F: ( alpha, mu, alphap ) \mapsto \mathtt{CokernelObjectFunctorial}(alpha, mu, alphap)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCokernelObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCokernelObjectFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCokernelObjectFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelObjectFunctorialWithGivenCokernelObjects`.
#! $F: ( P, alpha, mu, alphap, Pp ) \mapsto \mathtt{CokernelObjectFunctorialWithGivenCokernelObjects}(P, alpha, mu, alphap, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelObjectFunctorialWithGivenCokernelObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCokernelObjectFunctorialWithGivenCokernelObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCokernelObjectFunctorialWithGivenCokernelObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCokernelObjectFunctorialWithGivenCokernelObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelProjection`.
#! $F: ( alpha ) \mapsto \mathtt{CokernelProjection}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelProjection",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCokernelProjection",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCokernelProjection",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCokernelProjection",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelProjectionWithGivenCokernelObject`.
#! $F: ( alpha, P ) \mapsto \mathtt{CokernelProjectionWithGivenCokernelObject}(alpha, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelProjectionWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCokernelProjectionWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCokernelProjectionWithGivenCokernelObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCokernelProjectionWithGivenCokernelObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Colift`.
#! $F: ( alpha, beta ) \mapsto \mathtt{Colift}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddColift",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddColift",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddColift",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddColift",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ColiftAlongEpimorphism`.
#! $F: ( epsilon, tau ) \mapsto \mathtt{ColiftAlongEpimorphism}(epsilon, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddColiftAlongEpimorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddColiftAlongEpimorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddColiftAlongEpimorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddColiftAlongEpimorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ColiftOrFail`.
#! $F: ( alpha, beta ) \mapsto \mathtt{ColiftOrFail}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddColiftOrFail",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddColiftOrFail",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddColiftOrFail",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddColiftOrFail",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ComponentOfMorphismFromDirectSum`.
#! $F: ( alpha, S, i ) \mapsto \mathtt{ComponentOfMorphismFromDirectSum}(alpha, S, i)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddComponentOfMorphismFromDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddComponentOfMorphismFromDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddComponentOfMorphismFromDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddComponentOfMorphismFromDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ComponentOfMorphismIntoDirectSum`.
#! $F: ( alpha, S, i ) \mapsto \mathtt{ComponentOfMorphismIntoDirectSum}(alpha, S, i)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddComponentOfMorphismIntoDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddComponentOfMorphismIntoDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddComponentOfMorphismIntoDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddComponentOfMorphismIntoDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Coproduct`.
#! $F: ( arg2 ) \mapsto \mathtt{Coproduct}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoproduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoproduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoproduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoproductFunctorial`.
#! $F: ( objects, L, objectsp ) \mapsto \mathtt{CoproductFunctorial}(objects, L, objectsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoproductFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoproductFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoproductFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoproductFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoproductFunctorialWithGivenCoproducts`.
#! $F: ( P, objects, L, objectsp, Pp ) \mapsto \mathtt{CoproductFunctorialWithGivenCoproducts}(P, objects, L, objectsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoproductFunctorialWithGivenCoproducts",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddCoproductFunctorialWithGivenCoproducts",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddCoproductFunctorialWithGivenCoproducts",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddCoproductFunctorialWithGivenCoproducts",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectProduct`.
#! $F: ( arg2 ) \mapsto \mathtt{DirectProduct}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddDirectProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddDirectProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectProductFunctorial`.
#! $F: ( objects, L, objectsp ) \mapsto \mathtt{DirectProductFunctorial}(objects, L, objectsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectProductFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddDirectProductFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddDirectProductFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddDirectProductFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectProductFunctorialWithGivenDirectProducts`.
#! $F: ( P, objects, L, objectsp, Pp ) \mapsto \mathtt{DirectProductFunctorialWithGivenDirectProducts}(P, objects, L, objectsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectProductFunctorialWithGivenDirectProducts",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddDirectProductFunctorialWithGivenDirectProducts",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddDirectProductFunctorialWithGivenDirectProducts",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddDirectProductFunctorialWithGivenDirectProducts",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectSum`.
#! $F: ( arg2 ) \mapsto \mathtt{DirectSum}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectSumCodiagonalDifference`.
#! $F: ( D ) \mapsto \mathtt{DirectSumCodiagonalDifference}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectSumCodiagonalDifference",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddDirectSumCodiagonalDifference",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddDirectSumCodiagonalDifference",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddDirectSumCodiagonalDifference",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectSumDiagonalDifference`.
#! $F: ( D ) \mapsto \mathtt{DirectSumDiagonalDifference}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectSumDiagonalDifference",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddDirectSumDiagonalDifference",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddDirectSumDiagonalDifference",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddDirectSumDiagonalDifference",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectSumFunctorial`.
#! $F: ( objects, L, objectsp ) \mapsto \mathtt{DirectSumFunctorial}(objects, L, objectsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectSumFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddDirectSumFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddDirectSumFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddDirectSumFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectSumFunctorialWithGivenDirectSums`.
#! $F: ( P, objects, L, objectsp, Pp ) \mapsto \mathtt{DirectSumFunctorialWithGivenDirectSums}(P, objects, L, objectsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectSumFunctorialWithGivenDirectSums",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddDirectSumFunctorialWithGivenDirectSums",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddDirectSumFunctorialWithGivenDirectSums",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddDirectSumFunctorialWithGivenDirectSums",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectSumProjectionInPushout`.
#! $F: ( D ) \mapsto \mathtt{DirectSumProjectionInPushout}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectSumProjectionInPushout",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddDirectSumProjectionInPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddDirectSumProjectionInPushout",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddDirectSumProjectionInPushout",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DistinguishedObjectOfHomomorphismStructure`.
#! $F: (  ) \mapsto \mathtt{DistinguishedObjectOfHomomorphismStructure}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDistinguishedObjectOfHomomorphismStructure",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddDistinguishedObjectOfHomomorphismStructure",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddDistinguishedObjectOfHomomorphismStructure",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddDistinguishedObjectOfHomomorphismStructure",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EmbeddingOfEqualizer`.
#! $F: ( morphisms ) \mapsto \mathtt{EmbeddingOfEqualizer}(morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEmbeddingOfEqualizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddEmbeddingOfEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddEmbeddingOfEqualizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddEmbeddingOfEqualizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EmbeddingOfEqualizerWithGivenEqualizer`.
#! $F: ( morphisms, P ) \mapsto \mathtt{EmbeddingOfEqualizerWithGivenEqualizer}(morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEmbeddingOfEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddEmbeddingOfEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddEmbeddingOfEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddEmbeddingOfEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EpimorphismFromSomeProjectiveObject`.
#! $F: ( A ) \mapsto \mathtt{EpimorphismFromSomeProjectiveObject}(A)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEpimorphismFromSomeProjectiveObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddEpimorphismFromSomeProjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddEpimorphismFromSomeProjectiveObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddEpimorphismFromSomeProjectiveObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject`.
#! $F: ( A, P ) \mapsto \mathtt{EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject}(A, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddEpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddEpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddEpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Equalizer`.
#! $F: ( arg2 ) \mapsto \mathtt{Equalizer}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEqualizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddEqualizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddEqualizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EqualizerFunctorial`.
#! $F: ( morphisms, mu, morphismsp ) \mapsto \mathtt{EqualizerFunctorial}(morphisms, mu, morphismsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEqualizerFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddEqualizerFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddEqualizerFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddEqualizerFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EqualizerFunctorialWithGivenEqualizers`.
#! $F: ( P, morphisms, mu, morphismsp, Pp ) \mapsto \mathtt{EqualizerFunctorialWithGivenEqualizers}(P, morphisms, mu, morphismsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEqualizerFunctorialWithGivenEqualizers",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddEqualizerFunctorialWithGivenEqualizers",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddEqualizerFunctorialWithGivenEqualizers",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddEqualizerFunctorialWithGivenEqualizers",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `FiberProduct`.
#! $F: ( arg2 ) \mapsto \mathtt{FiberProduct}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddFiberProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddFiberProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddFiberProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `FiberProductEmbeddingInDirectSum`.
#! $F: ( D ) \mapsto \mathtt{FiberProductEmbeddingInDirectSum}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddFiberProductEmbeddingInDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddFiberProductEmbeddingInDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddFiberProductEmbeddingInDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddFiberProductEmbeddingInDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `FiberProductFunctorial`.
#! $F: ( morphisms, L, morphismsp ) \mapsto \mathtt{FiberProductFunctorial}(morphisms, L, morphismsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddFiberProductFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddFiberProductFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddFiberProductFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddFiberProductFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `FiberProductFunctorialWithGivenFiberProducts`.
#! $F: ( P, morphisms, L, morphismsp, Pp ) \mapsto \mathtt{FiberProductFunctorialWithGivenFiberProducts}(P, morphisms, L, morphismsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddFiberProductFunctorialWithGivenFiberProducts",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddFiberProductFunctorialWithGivenFiberProducts",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddFiberProductFunctorialWithGivenFiberProducts",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddFiberProductFunctorialWithGivenFiberProducts",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HomologyObject`.
#! $F: ( alpha, beta ) \mapsto \mathtt{HomologyObject}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHomologyObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddHomologyObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddHomologyObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddHomologyObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HomologyObjectFunctorialWithGivenHomologyObjects`.
#! $F: ( H_1, L, H_2 ) \mapsto \mathtt{HomologyObjectFunctorialWithGivenHomologyObjects}(H_1, L, H_2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHomologyObjectFunctorialWithGivenHomologyObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddHomologyObjectFunctorialWithGivenHomologyObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddHomologyObjectFunctorialWithGivenHomologyObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddHomologyObjectFunctorialWithGivenHomologyObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HomomorphismStructureOnMorphisms`.
#! $F: ( alpha, beta ) \mapsto \mathtt{HomomorphismStructureOnMorphisms}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHomomorphismStructureOnMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddHomomorphismStructureOnMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddHomomorphismStructureOnMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddHomomorphismStructureOnMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HomomorphismStructureOnMorphismsWithGivenObjects`.
#! $F: ( source, alpha, beta, range ) \mapsto \mathtt{HomomorphismStructureOnMorphismsWithGivenObjects}(source, alpha, beta, range)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHomomorphismStructureOnMorphismsWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddHomomorphismStructureOnMorphismsWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddHomomorphismStructureOnMorphismsWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddHomomorphismStructureOnMorphismsWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HomomorphismStructureOnObjects`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{HomomorphismStructureOnObjects}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHomomorphismStructureOnObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddHomomorphismStructureOnObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddHomomorphismStructureOnObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddHomomorphismStructureOnObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HorizontalPostCompose`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{HorizontalPostCompose}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHorizontalPostCompose",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddHorizontalPostCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddHorizontalPostCompose",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddHorizontalPostCompose",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HorizontalPreCompose`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{HorizontalPreCompose}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHorizontalPreCompose",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddHorizontalPreCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddHorizontalPreCompose",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddHorizontalPreCompose",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IdentityMorphism`.
#! $F: ( a ) \mapsto \mathtt{IdentityMorphism}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIdentityMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIdentityMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIdentityMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIdentityMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IdentityTwoCell`.
#! $F: ( arg2 ) \mapsto \mathtt{IdentityTwoCell}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIdentityTwoCell",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIdentityTwoCell",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIdentityTwoCell",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIdentityTwoCell",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ImageEmbedding`.
#! $F: ( alpha ) \mapsto \mathtt{ImageEmbedding}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddImageEmbedding",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddImageEmbedding",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddImageEmbedding",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddImageEmbedding",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ImageEmbeddingWithGivenImageObject`.
#! $F: ( alpha, I ) \mapsto \mathtt{ImageEmbeddingWithGivenImageObject}(alpha, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddImageEmbeddingWithGivenImageObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddImageEmbeddingWithGivenImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddImageEmbeddingWithGivenImageObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddImageEmbeddingWithGivenImageObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ImageObject`.
#! $F: ( arg2 ) \mapsto \mathtt{ImageObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddImageObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddImageObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddImageObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InitialObject`.
#! $F: (  ) \mapsto \mathtt{InitialObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInitialObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInitialObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInitialObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInitialObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InitialObjectFunctorial`.
#! $F: (  ) \mapsto \mathtt{InitialObjectFunctorial}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInitialObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInitialObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInitialObjectFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInitialObjectFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InitialObjectFunctorialWithGivenInitialObjects`.
#! $F: ( P, Pp ) \mapsto \mathtt{InitialObjectFunctorialWithGivenInitialObjects}(P, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInitialObjectFunctorialWithGivenInitialObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInitialObjectFunctorialWithGivenInitialObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInitialObjectFunctorialWithGivenInitialObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInitialObjectFunctorialWithGivenInitialObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfCoproduct`.
#! $F: ( objects, k ) \mapsto \mathtt{InjectionOfCofactorOfCoproduct}(objects, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfCoproduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInjectionOfCofactorOfCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfCoproduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfCoproduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfCoproductWithGivenCoproduct`.
#! $F: ( objects, k, P ) \mapsto \mathtt{InjectionOfCofactorOfCoproductWithGivenCoproduct}(objects, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInjectionOfCofactorOfCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfDirectSum`.
#! $F: ( objects, k ) \mapsto \mathtt{InjectionOfCofactorOfDirectSum}(objects, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInjectionOfCofactorOfDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfDirectSumWithGivenDirectSum`.
#! $F: ( objects, k, P ) \mapsto \mathtt{InjectionOfCofactorOfDirectSumWithGivenDirectSum}(objects, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInjectionOfCofactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfPushout`.
#! $F: ( morphisms, k ) \mapsto \mathtt{InjectionOfCofactorOfPushout}(morphisms, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfPushout",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInjectionOfCofactorOfPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfPushout",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfPushout",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfPushoutWithGivenPushout`.
#! $F: ( morphisms, k, P ) \mapsto \mathtt{InjectionOfCofactorOfPushoutWithGivenPushout}(morphisms, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInjectionOfCofactorOfPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfPushoutWithGivenPushout",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInjectionOfCofactorOfPushoutWithGivenPushout",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectiveColift`.
#! $F: ( alpha, beta ) \mapsto \mathtt{InjectiveColift}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectiveColift",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInjectiveColift",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInjectiveColift",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInjectiveColift",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectiveDimension`.
#! $F: ( arg2 ) \mapsto \mathtt{InjectiveDimension}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectiveDimension",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInjectiveDimension",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInjectiveDimension",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInjectiveDimension",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure`.
#! $F: ( alpha ) \mapsto \mathtt{InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects`.
#! $F: ( source, alpha, range ) \mapsto \mathtt{InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects}(source, alpha, range)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism`.
#! $F: ( arg2, arg3, arg4 ) \mapsto \mathtt{InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism}(arg2, arg3, arg4)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InverseForMorphisms`.
#! $F: ( alpha ) \mapsto \mathtt{InverseForMorphisms}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInverseForMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInverseForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInverseForMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInverseForMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InverseMorphismFromCoimageToImageWithGivenObjects`.
#! $F: ( C, alpha, I ) \mapsto \mathtt{InverseMorphismFromCoimageToImageWithGivenObjects}(C, alpha, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInverseMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddInverseMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddInverseMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddInverseMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsAutomorphism`.
#! $F: ( arg2 ) \mapsto \mathtt{IsAutomorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsAutomorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsAutomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsAutomorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsAutomorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsBijectiveObject`.
#! $F: ( arg2 ) \mapsto \mathtt{IsBijectiveObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsBijectiveObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsBijectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsBijectiveObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsBijectiveObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsCodominating`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsCodominating}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsCodominating",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsCodominating",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsCodominating",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsCodominating",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsColiftable`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsColiftable}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsColiftable",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsColiftable",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsColiftable",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsColiftable",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsColiftableAlongEpimorphism`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsColiftableAlongEpimorphism}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsColiftableAlongEpimorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsColiftableAlongEpimorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsColiftableAlongEpimorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsColiftableAlongEpimorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsCongruentForMorphisms`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsCongruentForMorphisms}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsCongruentForMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsCongruentForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsCongruentForMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsCongruentForMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsDominating`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsDominating}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsDominating",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsDominating",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsDominating",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsDominating",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEndomorphism`.
#! $F: ( arg2 ) \mapsto \mathtt{IsEndomorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEndomorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsEndomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsEndomorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsEndomorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEpimorphism`.
#! $F: ( arg2 ) \mapsto \mathtt{IsEpimorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEpimorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsEpimorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsEpimorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsEpimorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualAsFactorobjects`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualAsFactorobjects}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualAsFactorobjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsEqualAsFactorobjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsEqualAsFactorobjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsEqualAsFactorobjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualAsSubobjects`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualAsSubobjects}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualAsSubobjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsEqualAsSubobjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsEqualAsSubobjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsEqualAsSubobjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualForCacheForMorphisms`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualForCacheForMorphisms}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualForCacheForMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsEqualForCacheForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsEqualForCacheForMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsEqualForCacheForMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualForCacheForObjects`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualForCacheForObjects}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualForCacheForObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsEqualForCacheForObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsEqualForCacheForObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsEqualForCacheForObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualForMorphisms`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualForMorphisms}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualForMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsEqualForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsEqualForMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsEqualForMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualForMorphismsOnMor`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualForMorphismsOnMor}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualForMorphismsOnMor",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsEqualForMorphismsOnMor",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsEqualForMorphismsOnMor",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsEqualForMorphismsOnMor",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualForObjects`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualForObjects}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualForObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsEqualForObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsEqualForObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsEqualForObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualToIdentityMorphism`.
#! $F: ( arg2 ) \mapsto \mathtt{IsEqualToIdentityMorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualToIdentityMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsEqualToIdentityMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsEqualToIdentityMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsEqualToIdentityMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualToZeroMorphism`.
#! $F: ( arg2 ) \mapsto \mathtt{IsEqualToZeroMorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualToZeroMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsEqualToZeroMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsEqualToZeroMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsEqualToZeroMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsHomSetInhabited`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsHomSetInhabited}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsHomSetInhabited",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsHomSetInhabited",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsHomSetInhabited",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsHomSetInhabited",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsIdempotent`.
#! $F: ( arg2 ) \mapsto \mathtt{IsIdempotent}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsIdempotent",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsIdempotent",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsIdempotent",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsIdempotent",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsInitial`.
#! $F: ( arg2 ) \mapsto \mathtt{IsInitial}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsInitial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsInitial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsInitial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsInitial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsInjective`.
#! $F: ( arg2 ) \mapsto \mathtt{IsInjective}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsInjective",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsInjective",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsInjective",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsInjective",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsIsomorphism`.
#! $F: ( arg2 ) \mapsto \mathtt{IsIsomorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsIsomorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsIsomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsIsomorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsIsomorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsLiftable`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsLiftable}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsLiftable",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsLiftable",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsLiftable",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsLiftable",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsLiftableAlongMonomorphism`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsLiftableAlongMonomorphism}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsLiftableAlongMonomorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsLiftableAlongMonomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsLiftableAlongMonomorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsLiftableAlongMonomorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsMonomorphism`.
#! $F: ( arg2 ) \mapsto \mathtt{IsMonomorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsMonomorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsMonomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsMonomorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsMonomorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsOne`.
#! $F: ( arg2 ) \mapsto \mathtt{IsOne}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsOne",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsOne",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsOne",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsOne",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsProjective`.
#! $F: ( arg2 ) \mapsto \mathtt{IsProjective}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsProjective",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsProjective",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsProjective",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsProjective",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsSplitEpimorphism`.
#! $F: ( arg2 ) \mapsto \mathtt{IsSplitEpimorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsSplitEpimorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsSplitEpimorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsSplitEpimorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsSplitEpimorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsSplitMonomorphism`.
#! $F: ( arg2 ) \mapsto \mathtt{IsSplitMonomorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsSplitMonomorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsSplitMonomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsSplitMonomorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsSplitMonomorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsTerminal`.
#! $F: ( arg2 ) \mapsto \mathtt{IsTerminal}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsTerminal",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsTerminal",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsTerminal",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsTerminal",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsWellDefinedForMorphisms`.
#! $F: ( arg2 ) \mapsto \mathtt{IsWellDefinedForMorphisms}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsWellDefinedForMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsWellDefinedForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsWellDefinedForMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsWellDefinedForMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsWellDefinedForObjects`.
#! $F: ( arg2 ) \mapsto \mathtt{IsWellDefinedForObjects}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsWellDefinedForObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsWellDefinedForObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsWellDefinedForObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsWellDefinedForObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsWellDefinedForTwoCells`.
#! $F: ( arg2 ) \mapsto \mathtt{IsWellDefinedForTwoCells}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsWellDefinedForTwoCells",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsWellDefinedForTwoCells",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsWellDefinedForTwoCells",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsWellDefinedForTwoCells",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsZeroForMorphisms`.
#! $F: ( arg2 ) \mapsto \mathtt{IsZeroForMorphisms}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsZeroForMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsZeroForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsZeroForMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsZeroForMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsZeroForObjects`.
#! $F: ( arg2 ) \mapsto \mathtt{IsZeroForObjects}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsZeroForObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsZeroForObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsZeroForObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsZeroForObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromCoequalizerOfCoproductDiagramToPushout`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromCoequalizerOfCoproductDiagramToPushout}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromCoequalizerOfCoproductDiagramToPushout",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromCoequalizerOfCoproductDiagramToPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromCoequalizerOfCoproductDiagramToPushout",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromCoequalizerOfCoproductDiagramToPushout",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromCoimageToCokernelOfKernel`.
#! $F: ( alpha ) \mapsto \mathtt{IsomorphismFromCoimageToCokernelOfKernel}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromCoimageToCokernelOfKernel",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromCoimageToCokernelOfKernel",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromCoimageToCokernelOfKernel",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromCoimageToCokernelOfKernel",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromCokernelOfDiagonalDifferenceToPushout`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromCokernelOfDiagonalDifferenceToPushout}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromCokernelOfDiagonalDifferenceToPushout",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromCokernelOfDiagonalDifferenceToPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromCokernelOfDiagonalDifferenceToPushout",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromCokernelOfDiagonalDifferenceToPushout",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromCokernelOfKernelToCoimage`.
#! $F: ( alpha ) \mapsto \mathtt{IsomorphismFromCokernelOfKernelToCoimage}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromCokernelOfKernelToCoimage",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromCokernelOfKernelToCoimage",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromCokernelOfKernelToCoimage",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromCokernelOfKernelToCoimage",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromCoproductToDirectSum`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromCoproductToDirectSum}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromCoproductToDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromCoproductToDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromCoproductToDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromCoproductToDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromDirectProductToDirectSum`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromDirectProductToDirectSum}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromDirectProductToDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromDirectProductToDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromDirectProductToDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromDirectProductToDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromDirectSumToCoproduct`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromDirectSumToCoproduct}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromDirectSumToCoproduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromDirectSumToCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromDirectSumToCoproduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromDirectSumToCoproduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromDirectSumToDirectProduct`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromDirectSumToDirectProduct}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromDirectSumToDirectProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromDirectSumToDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromDirectSumToDirectProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromDirectSumToDirectProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromFiberProductToEqualizerOfDirectProductDiagram`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromFiberProductToEqualizerOfDirectProductDiagram}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromFiberProductToEqualizerOfDirectProductDiagram",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromFiberProductToEqualizerOfDirectProductDiagram",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromFiberProductToEqualizerOfDirectProductDiagram",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromFiberProductToEqualizerOfDirectProductDiagram",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromFiberProductToKernelOfDiagonalDifference`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromFiberProductToKernelOfDiagonalDifference}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromFiberProductToKernelOfDiagonalDifference",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromFiberProductToKernelOfDiagonalDifference",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromFiberProductToKernelOfDiagonalDifference",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromFiberProductToKernelOfDiagonalDifference",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromHomologyObjectToItsConstructionAsAnImageObject`.
#! $F: ( alpha, beta ) \mapsto \mathtt{IsomorphismFromHomologyObjectToItsConstructionAsAnImageObject}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromHomologyObjectToItsConstructionAsAnImageObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromHomologyObjectToItsConstructionAsAnImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromHomologyObjectToItsConstructionAsAnImageObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromHomologyObjectToItsConstructionAsAnImageObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromImageObjectToKernelOfCokernel`.
#! $F: ( alpha ) \mapsto \mathtt{IsomorphismFromImageObjectToKernelOfCokernel}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromImageObjectToKernelOfCokernel",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromImageObjectToKernelOfCokernel",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromImageObjectToKernelOfCokernel",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromImageObjectToKernelOfCokernel",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromInitialObjectToZeroObject`.
#! $F: (  ) \mapsto \mathtt{IsomorphismFromInitialObjectToZeroObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromInitialObjectToZeroObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromInitialObjectToZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromInitialObjectToZeroObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromInitialObjectToZeroObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromItsConstructionAsAnImageObjectToHomologyObject`.
#! $F: ( alpha, beta ) \mapsto \mathtt{IsomorphismFromItsConstructionAsAnImageObjectToHomologyObject}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromItsConstructionAsAnImageObjectToHomologyObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromItsConstructionAsAnImageObjectToHomologyObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromItsConstructionAsAnImageObjectToHomologyObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromItsConstructionAsAnImageObjectToHomologyObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromKernelOfCokernelToImageObject`.
#! $F: ( alpha ) \mapsto \mathtt{IsomorphismFromKernelOfCokernelToImageObject}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromKernelOfCokernelToImageObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromKernelOfCokernelToImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromKernelOfCokernelToImageObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromKernelOfCokernelToImageObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromKernelOfDiagonalDifferenceToFiberProduct`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromKernelOfDiagonalDifferenceToFiberProduct}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromKernelOfDiagonalDifferenceToFiberProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromKernelOfDiagonalDifferenceToFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromKernelOfDiagonalDifferenceToFiberProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromKernelOfDiagonalDifferenceToFiberProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromPushoutToCoequalizerOfCoproductDiagram`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromPushoutToCoequalizerOfCoproductDiagram}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromPushoutToCoequalizerOfCoproductDiagram",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromPushoutToCoequalizerOfCoproductDiagram",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromPushoutToCoequalizerOfCoproductDiagram",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromPushoutToCoequalizerOfCoproductDiagram",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromPushoutToCokernelOfDiagonalDifference`.
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromPushoutToCokernelOfDiagonalDifference}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromPushoutToCokernelOfDiagonalDifference",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromPushoutToCokernelOfDiagonalDifference",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromPushoutToCokernelOfDiagonalDifference",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromPushoutToCokernelOfDiagonalDifference",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromTerminalObjectToZeroObject`.
#! $F: (  ) \mapsto \mathtt{IsomorphismFromTerminalObjectToZeroObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromTerminalObjectToZeroObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromTerminalObjectToZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromTerminalObjectToZeroObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromTerminalObjectToZeroObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromZeroObjectToInitialObject`.
#! $F: (  ) \mapsto \mathtt{IsomorphismFromZeroObjectToInitialObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromZeroObjectToInitialObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromZeroObjectToInitialObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromZeroObjectToInitialObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromZeroObjectToInitialObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromZeroObjectToTerminalObject`.
#! $F: (  ) \mapsto \mathtt{IsomorphismFromZeroObjectToTerminalObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromZeroObjectToTerminalObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromZeroObjectToTerminalObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromZeroObjectToTerminalObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromZeroObjectToTerminalObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelEmbedding`.
#! $F: ( alpha ) \mapsto \mathtt{KernelEmbedding}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelEmbedding",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddKernelEmbedding",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddKernelEmbedding",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddKernelEmbedding",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelEmbeddingWithGivenKernelObject`.
#! $F: ( alpha, P ) \mapsto \mathtt{KernelEmbeddingWithGivenKernelObject}(alpha, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelEmbeddingWithGivenKernelObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddKernelEmbeddingWithGivenKernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddKernelEmbeddingWithGivenKernelObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddKernelEmbeddingWithGivenKernelObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelLift`.
#! $F: ( alpha, T, tau ) \mapsto \mathtt{KernelLift}(alpha, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelLift",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddKernelLift",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddKernelLift",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddKernelLift",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelLiftWithGivenKernelObject`.
#! $F: ( alpha, T, tau, P ) \mapsto \mathtt{KernelLiftWithGivenKernelObject}(alpha, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelLiftWithGivenKernelObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddKernelLiftWithGivenKernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddKernelLiftWithGivenKernelObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddKernelLiftWithGivenKernelObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelObject`.
#! $F: ( arg2 ) \mapsto \mathtt{KernelObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddKernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddKernelObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddKernelObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelObjectFunctorial`.
#! $F: ( alpha, mu, alphap ) \mapsto \mathtt{KernelObjectFunctorial}(alpha, mu, alphap)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddKernelObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddKernelObjectFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddKernelObjectFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelObjectFunctorialWithGivenKernelObjects`.
#! $F: ( P, alpha, mu, alphap, Pp ) \mapsto \mathtt{KernelObjectFunctorialWithGivenKernelObjects}(P, alpha, mu, alphap, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelObjectFunctorialWithGivenKernelObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddKernelObjectFunctorialWithGivenKernelObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddKernelObjectFunctorialWithGivenKernelObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddKernelObjectFunctorialWithGivenKernelObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Lift`.
#! $F: ( alpha, beta ) \mapsto \mathtt{Lift}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLift",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLift",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLift",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLift",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LiftAlongMonomorphism`.
#! $F: ( iota, tau ) \mapsto \mathtt{LiftAlongMonomorphism}(iota, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLiftAlongMonomorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLiftAlongMonomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLiftAlongMonomorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLiftAlongMonomorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LiftOrFail`.
#! $F: ( alpha, beta ) \mapsto \mathtt{LiftOrFail}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLiftOrFail",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLiftOrFail",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLiftOrFail",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLiftOrFail",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MereExistenceOfSolutionOfLinearSystemInAbCategory`.
#! $F: ( arg2, arg3, arg4 ) \mapsto \mathtt{MereExistenceOfSolutionOfLinearSystemInAbCategory}(arg2, arg3, arg4)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMereExistenceOfSolutionOfLinearSystemInAbCategory",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMereExistenceOfSolutionOfLinearSystemInAbCategory",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMereExistenceOfSolutionOfLinearSystemInAbCategory",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMereExistenceOfSolutionOfLinearSystemInAbCategory",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MonomorphismIntoSomeInjectiveObject`.
#! $F: ( A ) \mapsto \mathtt{MonomorphismIntoSomeInjectiveObject}(A)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMonomorphismIntoSomeInjectiveObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMonomorphismIntoSomeInjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMonomorphismIntoSomeInjectiveObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMonomorphismIntoSomeInjectiveObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject`.
#! $F: ( A, I ) \mapsto \mathtt{MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject}(A, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismBetweenDirectSums`.
#! $F: ( source_diagram, mat, range_diagram ) \mapsto \mathtt{MorphismBetweenDirectSums}(source_diagram, mat, range_diagram)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismBetweenDirectSums",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismBetweenDirectSums",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismBetweenDirectSums",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismBetweenDirectSums",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismBetweenDirectSumsWithGivenDirectSums`.
#! $F: ( S, source_diagram, mat, range_diagram, T ) \mapsto \mathtt{MorphismBetweenDirectSumsWithGivenDirectSums}(S, source_diagram, mat, range_diagram, T)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismBetweenDirectSumsWithGivenDirectSums",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismBetweenDirectSumsWithGivenDirectSums",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismBetweenDirectSumsWithGivenDirectSums",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismBetweenDirectSumsWithGivenDirectSums",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismConstructor`.
#! $F: ( arg2, arg3, arg4 ) \mapsto \mathtt{MorphismConstructor}(arg2, arg3, arg4)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismConstructor",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismConstructor",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismConstructor",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismConstructor",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismDatum`.
#! $F: ( arg2 ) \mapsto \mathtt{MorphismDatum}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismDatum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismDatum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismDatum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismDatum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromCoimageToImageWithGivenObjects`.
#! $F: ( C, alpha, I ) \mapsto \mathtt{MorphismFromCoimageToImageWithGivenObjects}(C, alpha, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromEqualizerToSink`.
#! $F: ( morphisms ) \mapsto \mathtt{MorphismFromEqualizerToSink}(morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromEqualizerToSink",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromEqualizerToSink",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromEqualizerToSink",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromEqualizerToSink",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromEqualizerToSinkWithGivenEqualizer`.
#! $F: ( morphisms, P ) \mapsto \mathtt{MorphismFromEqualizerToSinkWithGivenEqualizer}(morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromEqualizerToSinkWithGivenEqualizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromEqualizerToSinkWithGivenEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromEqualizerToSinkWithGivenEqualizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromEqualizerToSinkWithGivenEqualizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromFiberProductToSink`.
#! $F: ( morphisms ) \mapsto \mathtt{MorphismFromFiberProductToSink}(morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromFiberProductToSink",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromFiberProductToSink",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromFiberProductToSink",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromFiberProductToSink",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromFiberProductToSinkWithGivenFiberProduct`.
#! $F: ( morphisms, P ) \mapsto \mathtt{MorphismFromFiberProductToSinkWithGivenFiberProduct}(morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromFiberProductToSinkWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromFiberProductToSinkWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromFiberProductToSinkWithGivenFiberProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromFiberProductToSinkWithGivenFiberProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromKernelObjectToSink`.
#! $F: ( alpha ) \mapsto \mathtt{MorphismFromKernelObjectToSink}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromKernelObjectToSink",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromKernelObjectToSink",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromKernelObjectToSink",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromKernelObjectToSink",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromKernelObjectToSinkWithGivenKernelObject`.
#! $F: ( alpha, P ) \mapsto \mathtt{MorphismFromKernelObjectToSinkWithGivenKernelObject}(alpha, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromKernelObjectToSinkWithGivenKernelObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromKernelObjectToSinkWithGivenKernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromKernelObjectToSinkWithGivenKernelObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromKernelObjectToSinkWithGivenKernelObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToCoequalizer`.
#! $F: ( morphisms ) \mapsto \mathtt{MorphismFromSourceToCoequalizer}(morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToCoequalizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromSourceToCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToCoequalizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToCoequalizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToCoequalizerWithGivenCoequalizer`.
#! $F: ( morphisms, P ) \mapsto \mathtt{MorphismFromSourceToCoequalizerWithGivenCoequalizer}(morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromSourceToCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToCokernelObject`.
#! $F: ( alpha ) \mapsto \mathtt{MorphismFromSourceToCokernelObject}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToCokernelObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromSourceToCokernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToCokernelObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToCokernelObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToCokernelObjectWithGivenCokernelObject`.
#! $F: ( alpha, P ) \mapsto \mathtt{MorphismFromSourceToCokernelObjectWithGivenCokernelObject}(alpha, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToCokernelObjectWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromSourceToCokernelObjectWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToCokernelObjectWithGivenCokernelObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToCokernelObjectWithGivenCokernelObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToPushout`.
#! $F: ( morphisms ) \mapsto \mathtt{MorphismFromSourceToPushout}(morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToPushout",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromSourceToPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToPushout",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToPushout",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToPushoutWithGivenPushout`.
#! $F: ( morphisms, P ) \mapsto \mathtt{MorphismFromSourceToPushoutWithGivenPushout}(morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromSourceToPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToPushoutWithGivenPushout",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromSourceToPushoutWithGivenPushout",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MultiplyWithElementOfCommutativeRingForMorphisms`.
#! $F: ( r, a ) \mapsto \mathtt{MultiplyWithElementOfCommutativeRingForMorphisms}(r, a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMultiplyWithElementOfCommutativeRingForMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMultiplyWithElementOfCommutativeRingForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMultiplyWithElementOfCommutativeRingForMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMultiplyWithElementOfCommutativeRingForMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ObjectConstructor`.
#! $F: ( arg2 ) \mapsto \mathtt{ObjectConstructor}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddObjectConstructor",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddObjectConstructor",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddObjectConstructor",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddObjectConstructor",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ObjectDatum`.
#! $F: ( arg2 ) \mapsto \mathtt{ObjectDatum}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddObjectDatum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddObjectDatum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddObjectDatum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddObjectDatum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PostCompose`.
#! $F: ( beta, alpha ) \mapsto \mathtt{PostCompose}(beta, alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPostCompose",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddPostCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddPostCompose",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddPostCompose",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PostComposeList`.
#! $F: ( list_of_morphisms ) \mapsto \mathtt{PostComposeList}(list_of_morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPostComposeList",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddPostComposeList",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddPostComposeList",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddPostComposeList",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PreCompose`.
#! $F: ( alpha, beta ) \mapsto \mathtt{PreCompose}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPreCompose",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddPreCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddPreCompose",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddPreCompose",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PreComposeList`.
#! $F: ( list_of_morphisms ) \mapsto \mathtt{PreComposeList}(list_of_morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPreComposeList",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddPreComposeList",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddPreComposeList",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddPreComposeList",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfDirectProduct`.
#! $F: ( objects, k ) \mapsto \mathtt{ProjectionInFactorOfDirectProduct}(objects, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfDirectProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddProjectionInFactorOfDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfDirectProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfDirectProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfDirectProductWithGivenDirectProduct`.
#! $F: ( objects, k, P ) \mapsto \mathtt{ProjectionInFactorOfDirectProductWithGivenDirectProduct}(objects, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddProjectionInFactorOfDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfDirectSum`.
#! $F: ( objects, k ) \mapsto \mathtt{ProjectionInFactorOfDirectSum}(objects, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddProjectionInFactorOfDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfDirectSumWithGivenDirectSum`.
#! $F: ( objects, k, P ) \mapsto \mathtt{ProjectionInFactorOfDirectSumWithGivenDirectSum}(objects, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddProjectionInFactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfFiberProduct`.
#! $F: ( morphisms, k ) \mapsto \mathtt{ProjectionInFactorOfFiberProduct}(morphisms, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfFiberProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddProjectionInFactorOfFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfFiberProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfFiberProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfFiberProductWithGivenFiberProduct`.
#! $F: ( morphisms, k, P ) \mapsto \mathtt{ProjectionInFactorOfFiberProductWithGivenFiberProduct}(morphisms, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddProjectionInFactorOfFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddProjectionInFactorOfFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionOntoCoequalizer`.
#! $F: ( morphisms ) \mapsto \mathtt{ProjectionOntoCoequalizer}(morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionOntoCoequalizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddProjectionOntoCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddProjectionOntoCoequalizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddProjectionOntoCoequalizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionOntoCoequalizerWithGivenCoequalizer`.
#! $F: ( morphisms, P ) \mapsto \mathtt{ProjectionOntoCoequalizerWithGivenCoequalizer}(morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionOntoCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddProjectionOntoCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddProjectionOntoCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddProjectionOntoCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectiveDimension`.
#! $F: ( arg2 ) \mapsto \mathtt{ProjectiveDimension}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectiveDimension",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddProjectiveDimension",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddProjectiveDimension",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddProjectiveDimension",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectiveLift`.
#! $F: ( alpha, beta ) \mapsto \mathtt{ProjectiveLift}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectiveLift",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddProjectiveLift",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddProjectiveLift",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddProjectiveLift",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Pushout`.
#! $F: ( arg2 ) \mapsto \mathtt{Pushout}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPushout",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddPushout",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddPushout",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PushoutFunctorial`.
#! $F: ( morphisms, L, morphismsp ) \mapsto \mathtt{PushoutFunctorial}(morphisms, L, morphismsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPushoutFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddPushoutFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddPushoutFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddPushoutFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PushoutFunctorialWithGivenPushouts`.
#! $F: ( P, morphisms, L, morphismsp, Pp ) \mapsto \mathtt{PushoutFunctorialWithGivenPushouts}(P, morphisms, L, morphismsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPushoutFunctorialWithGivenPushouts",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddPushoutFunctorialWithGivenPushouts",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddPushoutFunctorialWithGivenPushouts",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddPushoutFunctorialWithGivenPushouts",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismByInteger`.
#! $F: ( n ) \mapsto \mathtt{RandomMorphismByInteger}(n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismByInteger",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRandomMorphismByInteger",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRandomMorphismByInteger",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRandomMorphismByInteger",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismByList`.
#! $F: ( L ) \mapsto \mathtt{RandomMorphismByList}(L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismByList",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRandomMorphismByList",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRandomMorphismByList",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRandomMorphismByList",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedRangeByInteger`.
#! $F: ( B, n ) \mapsto \mathtt{RandomMorphismWithFixedRangeByInteger}(B, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedRangeByInteger",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRandomMorphismWithFixedRangeByInteger",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedRangeByInteger",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedRangeByInteger",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedRangeByList`.
#! $F: ( B, L ) \mapsto \mathtt{RandomMorphismWithFixedRangeByList}(B, L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedRangeByList",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRandomMorphismWithFixedRangeByList",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedRangeByList",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedRangeByList",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedSourceAndRangeByInteger`.
#! $F: ( A, B, n ) \mapsto \mathtt{RandomMorphismWithFixedSourceAndRangeByInteger}(A, B, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByInteger",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByInteger",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByInteger",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByInteger",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedSourceAndRangeByList`.
#! $F: ( A, B, L ) \mapsto \mathtt{RandomMorphismWithFixedSourceAndRangeByList}(A, B, L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByList",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByList",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByList",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByList",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedSourceByInteger`.
#! $F: ( A, n ) \mapsto \mathtt{RandomMorphismWithFixedSourceByInteger}(A, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedSourceByInteger",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceByInteger",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceByInteger",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceByInteger",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedSourceByList`.
#! $F: ( A, L ) \mapsto \mathtt{RandomMorphismWithFixedSourceByList}(A, L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedSourceByList",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceByList",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceByList",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRandomMorphismWithFixedSourceByList",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomObjectByInteger`.
#! $F: ( n ) \mapsto \mathtt{RandomObjectByInteger}(n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomObjectByInteger",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRandomObjectByInteger",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRandomObjectByInteger",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRandomObjectByInteger",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomObjectByList`.
#! $F: ( L ) \mapsto \mathtt{RandomObjectByList}(L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomObjectByList",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRandomObjectByList",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRandomObjectByList",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRandomObjectByList",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyEndo`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyEndo}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyEndo",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifyEndo",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifyEndo",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifyEndo",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyEndo_IsoFromInputObject`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyEndo_IsoFromInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyEndo_IsoFromInputObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifyEndo_IsoFromInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifyEndo_IsoFromInputObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifyEndo_IsoFromInputObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyEndo_IsoToInputObject`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyEndo_IsoToInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyEndo_IsoToInputObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifyEndo_IsoToInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifyEndo_IsoToInputObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifyEndo_IsoToInputObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyMorphism`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyMorphism}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifyMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifyMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifyMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyObject`.
#! $F: ( A, n ) \mapsto \mathtt{SimplifyObject}(A, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifyObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifyObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifyObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyObject_IsoFromInputObject`.
#! $F: ( A, n ) \mapsto \mathtt{SimplifyObject_IsoFromInputObject}(A, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyObject_IsoFromInputObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifyObject_IsoFromInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifyObject_IsoFromInputObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifyObject_IsoFromInputObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyObject_IsoToInputObject`.
#! $F: ( A, n ) \mapsto \mathtt{SimplifyObject_IsoToInputObject}(A, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyObject_IsoToInputObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifyObject_IsoToInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifyObject_IsoToInputObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifyObject_IsoToInputObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyRange`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyRange}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyRange",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifyRange",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifyRange",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifyRange",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyRange_IsoFromInputObject`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyRange_IsoFromInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyRange_IsoFromInputObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifyRange_IsoFromInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifyRange_IsoFromInputObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifyRange_IsoFromInputObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyRange_IsoToInputObject`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyRange_IsoToInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyRange_IsoToInputObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifyRange_IsoToInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifyRange_IsoToInputObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifyRange_IsoToInputObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySource`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySource}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySource",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifySource",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifySource",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifySource",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySourceAndRange`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySourceAndRange}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySourceAndRange",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifySourceAndRange",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifySourceAndRange",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifySourceAndRange",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySourceAndRange_IsoFromInputRange`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySourceAndRange_IsoFromInputRange}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputRange",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputRange",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputRange",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputRange",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySourceAndRange_IsoFromInputSource`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySourceAndRange_IsoFromInputSource}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputSource",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputSource",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputSource",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputSource",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySourceAndRange_IsoToInputRange`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySourceAndRange_IsoToInputRange}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySourceAndRange_IsoToInputRange",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoToInputRange",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoToInputRange",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoToInputRange",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySourceAndRange_IsoToInputSource`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySourceAndRange_IsoToInputSource}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySourceAndRange_IsoToInputSource",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoToInputSource",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoToInputSource",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifySourceAndRange_IsoToInputSource",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySource_IsoFromInputObject`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySource_IsoFromInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySource_IsoFromInputObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifySource_IsoFromInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifySource_IsoFromInputObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifySource_IsoFromInputObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySource_IsoToInputObject`.
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySource_IsoToInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySource_IsoToInputObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSimplifySource_IsoToInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSimplifySource_IsoToInputObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSimplifySource_IsoToInputObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SolveLinearSystemInAbCategory`.
#! $F: ( arg2, arg3, arg4 ) \mapsto \mathtt{SolveLinearSystemInAbCategory}(arg2, arg3, arg4)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSolveLinearSystemInAbCategory",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSolveLinearSystemInAbCategory",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSolveLinearSystemInAbCategory",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSolveLinearSystemInAbCategory",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SolveLinearSystemInAbCategoryOrFail`.
#! $F: ( arg2, arg3, arg4 ) \mapsto \mathtt{SolveLinearSystemInAbCategoryOrFail}(arg2, arg3, arg4)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSolveLinearSystemInAbCategoryOrFail",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSolveLinearSystemInAbCategoryOrFail",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSolveLinearSystemInAbCategoryOrFail",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSolveLinearSystemInAbCategoryOrFail",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SomeInjectiveObject`.
#! $F: ( arg2 ) \mapsto \mathtt{SomeInjectiveObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSomeInjectiveObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSomeInjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSomeInjectiveObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSomeInjectiveObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SomeProjectiveObject`.
#! $F: ( arg2 ) \mapsto \mathtt{SomeProjectiveObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSomeProjectiveObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSomeProjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSomeProjectiveObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSomeProjectiveObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SomeReductionBySplitEpiSummand`.
#! $F: ( alpha ) \mapsto \mathtt{SomeReductionBySplitEpiSummand}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSomeReductionBySplitEpiSummand",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSomeReductionBySplitEpiSummand",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSomeReductionBySplitEpiSummand",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSomeReductionBySplitEpiSummand",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SomeReductionBySplitEpiSummand_MorphismFromInputRange`.
#! $F: ( alpha ) \mapsto \mathtt{SomeReductionBySplitEpiSummand_MorphismFromInputRange}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismFromInputRange",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismFromInputRange",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismFromInputRange",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismFromInputRange",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SomeReductionBySplitEpiSummand_MorphismToInputRange`.
#! $F: ( alpha ) \mapsto \mathtt{SomeReductionBySplitEpiSummand_MorphismToInputRange}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismToInputRange",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismToInputRange",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismToInputRange",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismToInputRange",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SubtractionForMorphisms`.
#! $F: ( a, b ) \mapsto \mathtt{SubtractionForMorphisms}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSubtractionForMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddSubtractionForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddSubtractionForMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddSubtractionForMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TerminalObject`.
#! $F: (  ) \mapsto \mathtt{TerminalObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTerminalObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddTerminalObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddTerminalObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddTerminalObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TerminalObjectFunctorial`.
#! $F: (  ) \mapsto \mathtt{TerminalObjectFunctorial}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTerminalObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddTerminalObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddTerminalObjectFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddTerminalObjectFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TerminalObjectFunctorialWithGivenTerminalObjects`.
#! $F: ( P, Pp ) \mapsto \mathtt{TerminalObjectFunctorialWithGivenTerminalObjects}(P, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTerminalObjectFunctorialWithGivenTerminalObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddTerminalObjectFunctorialWithGivenTerminalObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddTerminalObjectFunctorialWithGivenTerminalObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddTerminalObjectFunctorialWithGivenTerminalObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromCoequalizer`.
#! $F: ( morphisms, T, tau ) \mapsto \mathtt{UniversalMorphismFromCoequalizer}(morphisms, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromCoequalizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromCoequalizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromCoequalizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromCoequalizerWithGivenCoequalizer`.
#! $F: ( morphisms, T, tau, P ) \mapsto \mathtt{UniversalMorphismFromCoequalizerWithGivenCoequalizer}(morphisms, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromCoproduct`.
#! $F: ( objects, T, tau ) \mapsto \mathtt{UniversalMorphismFromCoproduct}(objects, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromCoproduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromCoproduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromCoproduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromCoproductWithGivenCoproduct`.
#! $F: ( objects, T, tau, P ) \mapsto \mathtt{UniversalMorphismFromCoproductWithGivenCoproduct}(objects, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromDirectSum`.
#! $F: ( objects, T, tau ) \mapsto \mathtt{UniversalMorphismFromDirectSum}(objects, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromDirectSumWithGivenDirectSum`.
#! $F: ( objects, T, tau, P ) \mapsto \mathtt{UniversalMorphismFromDirectSumWithGivenDirectSum}(objects, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromImage`.
#! $F: ( alpha, tau ) \mapsto \mathtt{UniversalMorphismFromImage}(alpha, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromImage",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromImage",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromImage",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromImage",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromImageWithGivenImageObject`.
#! $F: ( alpha, tau, I ) \mapsto \mathtt{UniversalMorphismFromImageWithGivenImageObject}(alpha, tau, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromImageWithGivenImageObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromImageWithGivenImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromImageWithGivenImageObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromImageWithGivenImageObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromInitialObject`.
#! $F: ( T ) \mapsto \mathtt{UniversalMorphismFromInitialObject}(T)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromInitialObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromInitialObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromInitialObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromInitialObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromInitialObjectWithGivenInitialObject`.
#! $F: ( T, P ) \mapsto \mathtt{UniversalMorphismFromInitialObjectWithGivenInitialObject}(T, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromInitialObjectWithGivenInitialObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromInitialObjectWithGivenInitialObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromInitialObjectWithGivenInitialObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromInitialObjectWithGivenInitialObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromPushout`.
#! $F: ( morphisms, T, tau ) \mapsto \mathtt{UniversalMorphismFromPushout}(morphisms, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromPushout",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromPushout",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromPushout",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromPushoutWithGivenPushout`.
#! $F: ( morphisms, T, tau, P ) \mapsto \mathtt{UniversalMorphismFromPushoutWithGivenPushout}(morphisms, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromPushoutWithGivenPushout",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromPushoutWithGivenPushout",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromZeroObject`.
#! $F: ( T ) \mapsto \mathtt{UniversalMorphismFromZeroObject}(T)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromZeroObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromZeroObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromZeroObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromZeroObjectWithGivenZeroObject`.
#! $F: ( T, P ) \mapsto \mathtt{UniversalMorphismFromZeroObjectWithGivenZeroObject}(T, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismFromZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismFromZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoCoimage`.
#! $F: ( alpha, tau ) \mapsto \mathtt{UniversalMorphismIntoCoimage}(alpha, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoCoimage",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoCoimage",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoCoimage",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoCoimage",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoCoimageWithGivenCoimageObject`.
#! $F: ( alpha, tau, C ) \mapsto \mathtt{UniversalMorphismIntoCoimageWithGivenCoimageObject}(alpha, tau, C)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoDirectProduct`.
#! $F: ( objects, T, tau ) \mapsto \mathtt{UniversalMorphismIntoDirectProduct}(objects, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoDirectProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoDirectProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoDirectProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoDirectProductWithGivenDirectProduct`.
#! $F: ( objects, T, tau, P ) \mapsto \mathtt{UniversalMorphismIntoDirectProductWithGivenDirectProduct}(objects, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoDirectSum`.
#! $F: ( objects, T, tau ) \mapsto \mathtt{UniversalMorphismIntoDirectSum}(objects, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoDirectSumWithGivenDirectSum`.
#! $F: ( objects, T, tau, P ) \mapsto \mathtt{UniversalMorphismIntoDirectSumWithGivenDirectSum}(objects, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoEqualizer`.
#! $F: ( morphisms, T, tau ) \mapsto \mathtt{UniversalMorphismIntoEqualizer}(morphisms, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoEqualizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoEqualizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoEqualizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoEqualizerWithGivenEqualizer`.
#! $F: ( morphisms, T, tau, P ) \mapsto \mathtt{UniversalMorphismIntoEqualizerWithGivenEqualizer}(morphisms, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoFiberProduct`.
#! $F: ( morphisms, T, tau ) \mapsto \mathtt{UniversalMorphismIntoFiberProduct}(morphisms, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoFiberProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoFiberProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoFiberProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoFiberProductWithGivenFiberProduct`.
#! $F: ( morphisms, T, tau, P ) \mapsto \mathtt{UniversalMorphismIntoFiberProductWithGivenFiberProduct}(morphisms, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoTerminalObject`.
#! $F: ( T ) \mapsto \mathtt{UniversalMorphismIntoTerminalObject}(T)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoTerminalObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoTerminalObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoTerminalObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoTerminalObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoTerminalObjectWithGivenTerminalObject`.
#! $F: ( T, P ) \mapsto \mathtt{UniversalMorphismIntoTerminalObjectWithGivenTerminalObject}(T, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoTerminalObjectWithGivenTerminalObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoTerminalObjectWithGivenTerminalObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoTerminalObjectWithGivenTerminalObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoTerminalObjectWithGivenTerminalObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoZeroObject`.
#! $F: ( T ) \mapsto \mathtt{UniversalMorphismIntoZeroObject}(T)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoZeroObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoZeroObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoZeroObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoZeroObjectWithGivenZeroObject`.
#! $F: ( T, P ) \mapsto \mathtt{UniversalMorphismIntoZeroObjectWithGivenZeroObject}(T, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalMorphismIntoZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalMorphismIntoZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `VerticalPostCompose`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{VerticalPostCompose}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddVerticalPostCompose",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddVerticalPostCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddVerticalPostCompose",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddVerticalPostCompose",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `VerticalPreCompose`.
#! $F: ( arg2, arg3 ) \mapsto \mathtt{VerticalPreCompose}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddVerticalPreCompose",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddVerticalPreCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddVerticalPreCompose",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddVerticalPreCompose",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ZeroMorphism`.
#! $F: ( a, b ) \mapsto \mathtt{ZeroMorphism}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddZeroMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddZeroMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddZeroMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddZeroMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ZeroObject`.
#! $F: (  ) \mapsto \mathtt{ZeroObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddZeroObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddZeroObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddZeroObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ZeroObjectFunctorial`.
#! $F: (  ) \mapsto \mathtt{ZeroObjectFunctorial}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddZeroObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddZeroObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddZeroObjectFunctorial",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddZeroObjectFunctorial",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ZeroObjectFunctorialWithGivenZeroObjects`.
#! $F: ( P, Pp ) \mapsto \mathtt{ZeroObjectFunctorialWithGivenZeroObjects}(P, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddZeroObjectFunctorialWithGivenZeroObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddZeroObjectFunctorialWithGivenZeroObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddZeroObjectFunctorialWithGivenZeroObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddZeroObjectFunctorialWithGivenZeroObjects",
                  [ IsCapCategory, IsList ] );
