# SPDX-License-Identifier: GPL-2.0-or-later
# CAP: Categories, Algorithms, Programming
#
# Implementations
#

InstallGlobalFunction( "CAP_INTERNAL_GENERATE_CONVENIENCE_METHODS_FOR_LIMITS",
  function ( package_name, method_name_record, limits )
    local output_string, generate_universal_morphism_convenience, generate_functorial_convenience_method, number_of_diagram_arguments, functorial_record, filter_list, input_type, replaced_filter_list, arguments_string, source_diagram_arguments_string, range_diagram_arguments_string, source_diagram_input_type, range_diagram_input_type, limit, output_path;
    
    output_string :=
"""# SPDX-License-Identifier: GPL-2.0-or-later
# CAP: Categories, Algorithms, Programming
#
# Implementations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE LimitConvenience.gi""";
    
    #### helper functions
    generate_universal_morphism_convenience := function( limit, universal_morphism_name, object_name, diagram_position )
      local current_string, test_object_position, diagram_filter_list_string, tau_filter, list_selector;
        
        if not diagram_position in [ "Source", "Range" ] then
            
            Error( "diagram_position must be \"Source\" or \"Range\"" );
            
        fi;
        
        if limit.number_of_unbound_morphisms = 0 then
            
            # diagram can be derived from morphism(s) via diagram_position
            
            if limit.number_of_targets = 1 then
                
                Error( "this case is currently not supported" );
                
            elif limit.number_of_targets > 1 then
                
                # derive diagram from morphisms via diagram_position
                current_string := Concatenation(
                    "\n",
                    "##\n",
                    "InstallMethod( ", universal_morphism_name, ",\n",
                    "               [ IsList ],\n",
                    "               \n",
                    "  function( list )\n",
                    "    #% CAP_JIT_RESOLVE_FUNCTION\n",
                    "    \n",
                    "    return ", universal_morphism_name, "( CapCategory( list[1] ), list );\n",
                    "    \n",
                    "end );\n",
                    "\n",
                    "##\n",
                    "InstallOtherMethod( ", universal_morphism_name, ",\n",
                    "               [ IsCapCategory, IsList ],\n",
                    "               \n",
                    "  function( cat, list )\n",
                    "    #% CAP_JIT_RESOLVE_FUNCTION\n",
                    "    \n",
                    "    return ", universal_morphism_name, "( cat, List( list, ", diagram_position, " ), list );\n",
                    "    \n",
                    "end );\n",
                    "\n",
                    "##\n",
                    "InstallOtherMethod( ", universal_morphism_name, ",\n",
                    "               [ IsCapCategoryObject, IsList ],\n",
                    "               \n",
                    "  function( test_object, list )\n",
                    "    #% CAP_JIT_RESOLVE_FUNCTION\n",
                    "    \n",
                    "    return ", universal_morphism_name, "( CapCategory( test_object ), test_object, list );\n",
                    "    \n",
                    "end );\n",
                    "\n",
                    "##\n",
                    "InstallOtherMethod( ", universal_morphism_name, ",\n",
                    "               [ IsCapCategory, IsCapCategoryObject, IsList ],\n",
                    "               \n",
                    "  function( cat, test_object, list )\n",
                    "    #% CAP_JIT_RESOLVE_FUNCTION\n",
                    "    \n",
                    "    return ", universal_morphism_name, "( cat, List( list, ", diagram_position, " ), test_object, list );\n",
                    "    \n",
                    "end );\n"
                );
                
                output_string := Concatenation( output_string, current_string );
                
            fi;
            
        fi;
        
        # derive test object
        if IsOperation( ValueGlobal( universal_morphism_name ) ) then
            
            if Length( limit.diagram_filter_list ) <> 1 then
                
                Error( "this case is not implemented" );
                
            fi;
            
            if diagram_position = "Source" then
                
                test_object_position := "Range";
                
            elif diagram_position = "Range" then
                
                test_object_position := "Source";
                
            else
                
                Error( "this should never happen" );
                
            fi;
            
            diagram_filter_list_string := NameFunction( CAP_INTERNAL_REPLACE_STRINGS_WITH_FILTERS( limit.diagram_filter_list )[1] );
            
            if limit.number_of_targets = 1 then
                
                tau_filter := "IsCapCategoryMorphism";
                list_selector := "";
                
            else
                
                tau_filter := "IsList";
                list_selector := "[1]";
                
            fi;
            
            current_string := Concatenation(
                "\n",
                "InstallOtherMethod( ", universal_morphism_name, ",\n",
                "                    [ ", diagram_filter_list_string, ", ", tau_filter, " ],\n",
                "                    \n",
                "    function( diagram, tau )\n",
                "        #% CAP_JIT_RESOLVE_FUNCTION\n",
                "        \n",
                "        return ", universal_morphism_name, "( diagram, ", test_object_position, "( tau", list_selector, " ), tau );\n",
                "        \n",
                "end );\n",
                "\n",
                "InstallOtherMethod( ", universal_morphism_name, ",\n",
                "                    [ IsCapCategory, ", diagram_filter_list_string, ", ", tau_filter, " ],\n",
                "                    \n",
                "    function( cat, diagram, tau )\n",
                "        #% CAP_JIT_RESOLVE_FUNCTION\n",
                "        \n",
                "        return ", universal_morphism_name, "( cat, diagram, ", test_object_position, "( tau", list_selector, " ), tau );\n",
                "        \n",
                "end );\n",
                "\n",
                "InstallOtherMethod( ", universal_morphism_name, "WithGiven", object_name, ",\n",
                "                    [ ", diagram_filter_list_string, ", ", tau_filter, ", IsCapCategoryObject ],\n",
                "                    \n",
                "    function( diagram, tau, P )\n",
                "        #% CAP_JIT_RESOLVE_FUNCTION\n",
                "        \n",
                "        return ", universal_morphism_name, "WithGiven", object_name, "( diagram, ", test_object_position, "( tau", list_selector, " ), tau, P );\n",
                "        \n",
                "end );\n",
                "\n",
                "InstallOtherMethod( ", universal_morphism_name, "WithGiven", object_name, ",\n",
                "                    [ IsCapCategory, ", diagram_filter_list_string, ", ", tau_filter, ", IsCapCategoryObject ],\n",
                "                    \n",
                "    function( cat, diagram, tau, P )\n",
                "        #% CAP_JIT_RESOLVE_FUNCTION\n",
                "        \n",
                "        return ", universal_morphism_name, "WithGiven", object_name, "( cat, diagram, ", test_object_position, "( tau", list_selector, " ), tau, P );\n",
                "        \n",
                "end );\n"
            );
            
            output_string := Concatenation( output_string, current_string );

        fi;
        
    end;
    
    generate_functorial_convenience_method := function( limit, limit_colimit, object_name, functorial_name, functorial_with_given_name )
      local functorial_with_given_record, filter_list, input_type, arguments_string, source_diagram_arguments_string, range_diagram_arguments_string, replaced_filter_list, current_string, input_arguments_names, source_argument_name, range_argument_name, source_diagram_arguments_names, range_diagram_arguments_names, test_string, test_arguments, universal_morphism_with_given_name, call_arguments;
        
        Assert( 0, limit_colimit in [ "limit", "colimit" ] );
        
        functorial_with_given_record := method_name_record.( limit.limit_functorial_with_given_name );
        
        if Length( limit.diagram_filter_list ) > 0 and limit.number_of_unbound_morphisms = 0 and (limit.limit_object_name <> limit.colimit_object_name or limit_colimit = "limit") then
            
            # convenience: derive diagrams from arguments
            filter_list := limit.diagram_morphism_filter_list;
            input_type := limit.diagram_morphism_input_type;
            
            Assert( 0, Length( filter_list ) = 1 );
            Assert( 0, Length( input_type ) = 1 );
            
            arguments_string := JoinStringsWithSeparator( input_type, ", " );
            
            if limit.number_of_targets = 1 then
                source_diagram_arguments_string := Concatenation( "Source( ", arguments_string, " )" );
                range_diagram_arguments_string := Concatenation( "Range( ", arguments_string, " )" );
            else
                source_diagram_arguments_string := Concatenation( "List( ", arguments_string, ", Source )" );
                range_diagram_arguments_string := Concatenation( "List( ", arguments_string, ", Range )" );
            fi;
            
            replaced_filter_list := List( CAP_INTERNAL_REPLACE_STRINGS_WITH_FILTERS( filter_list ), NameFunction );
            
            current_string := ReplacedStringViaRecord( """
##
InstallOtherMethod( functorial_name,
                    [ filter_list ],
               
  function( input_arguments )
    
    return functorial_name( source_diagram_arguments, input_arguments, range_diagram_arguments );
    
end );
""",
                rec(
                    functorial_name := functorial_name,
                    filter_list := replaced_filter_list,
                    input_arguments := input_type,
                    source_diagram_arguments := source_diagram_arguments_string,
                    range_diagram_arguments := range_diagram_arguments_string,
                )
            );
            
            output_string := Concatenation( output_string, current_string );
            
            # it is safe to use InstallOtherMethodForCompilerForCAP because there is no other two-argument convenience method for functorials
            current_string := ReplacedStringViaRecord( """
##
InstallOtherMethodForCompilerForCAP( functorial_name,
                                     [ IsCapCategory, filter_list ],
                    
  function( cat, input_arguments )
    
    return functorial_name( cat, source_diagram_arguments, input_arguments, range_diagram_arguments );
    
end );
""",
                rec(
                    functorial_name := functorial_name,
                    filter_list := replaced_filter_list,
                    input_arguments := input_type,
                    source_diagram_arguments := source_diagram_arguments_string,
                    range_diagram_arguments := range_diagram_arguments_string,
                )
            );
            
            output_string := Concatenation( output_string, current_string );
            
            current_string := ReplacedStringViaRecord( """
##
InstallOtherMethod( functorial_with_given_name,
               [ IsCapCategoryObject, filter_list, IsCapCategoryObject ],
               
  function( source, input_arguments, range )
    
    return functorial_with_given_name( source, source_diagram_arguments, input_arguments, range_diagram_arguments, range );
    
end );
""",
                rec(
                    functorial_with_given_name := functorial_with_given_name,
                    filter_list := replaced_filter_list,
                    input_arguments := input_type,
                    source_diagram_arguments := source_diagram_arguments_string,
                    range_diagram_arguments := range_diagram_arguments_string,
                )
            );
            
            output_string := Concatenation( output_string, current_string );
            
            # it is safe to use InstallOtherMethodForCompilerForCAP because there is no other four-argument convenience method for with given functorials
            current_string := ReplacedStringViaRecord( """
##
InstallOtherMethodForCompilerForCAP( functorial_with_given_name,
                                     [ IsCapCategory, IsCapCategoryObject, filter_list, IsCapCategoryObject ],
               
  function( cat, source, input_arguments, range )
    
    return functorial_with_given_name( cat, source, source_diagram_arguments, input_arguments, range_diagram_arguments, range );
    
end );
""",
                rec(
                    functorial_with_given_name := functorial_with_given_name,
                    filter_list := replaced_filter_list,
                    input_arguments := input_type,
                    source_diagram_arguments := source_diagram_arguments_string,
                    range_diagram_arguments := range_diagram_arguments_string,
                )
            );
            
            output_string := Concatenation( output_string, current_string );
            
        fi;
        
        # derive functorials from the universality of the limit/colimit
        Assert( 0, Length( limit.diagram_morphism_filter_list ) <= 1 );
        Assert( 0, Length( limit.diagram_morphism_input_type ) <= 1 );
        
        input_arguments_names := Concatenation( [ "cat" ], functorial_with_given_record.io_type[1] );
        
        source_argument_name := input_arguments_names[2];
        range_argument_name := Last( input_arguments_names );
        
        source_diagram_arguments_names := limit.functorial_source_diagram_arguments_names;
        range_diagram_arguments_names := limit.functorial_range_diagram_arguments_names;
        
        if Length( limit.diagram_filter_list ) > 0 then
            
            if limit.number_of_targets = 1 then
                
                Assert( 0, limit.diagram_morphism_input_type = [ "mu" ] );
                
                if limit_colimit = "limit" then
                    
                    test_string := ReplacedStringViaRecord(
                        "PreCompose( cat, projection_with_given( cat, source_diagram, source_object ), mu )",
                        rec(
                            projection_with_given := limit.limit_projection_with_given_name,
                            source_diagram := source_diagram_arguments_names,
                            source_object := source_argument_name,
                        )
                    );
                    
                elif limit_colimit = "colimit" then
                    
                    test_string := ReplacedStringViaRecord(
                        "PreCompose( cat, mu, injection_with_given( cat, range_diagram, range_object ) )",
                        rec(
                            injection_with_given := limit.colimit_injection_with_given_name,
                            range_diagram := range_diagram_arguments_names,
                            range_object := range_argument_name,
                        )
                    );
                    
                else
                    
                    Error( "this should never happen" );
                    
                fi;
                
            else
                
                Assert( 0, limit.diagram_morphism_input_type = [ "L" ] );
                
                if limit_colimit = "limit" then
                    
                    test_string := ReplacedStringViaRecord(
                        "List( [ 1 .. Length( L ) ], i -> PreCompose( cat, projection_with_given( cat, source_diagram, i, source_object ), L[i] ) )",
                        rec(
                            projection_with_given := limit.limit_projection_with_given_name,
                            source_diagram := source_diagram_arguments_names,
                            source_object := source_argument_name,
                        )
                    );
                    
                elif limit_colimit = "colimit" then
                    
                    test_string := ReplacedStringViaRecord(
                        "List( [ 1 .. Length( L ) ], i -> PreCompose( cat, L[i], injection_with_given( cat, range_diagram, i, range_object ) ) )",
                        rec(
                            injection_with_given := limit.colimit_injection_with_given_name,
                            range_diagram := range_diagram_arguments_names,
                            range_object := range_argument_name,
                        )
                    );
                    
                else
                    
                    Error( "this should never happen" );
                    
                fi;
                
            fi;
            
            test_arguments := [ test_string ];
            
        else
            
            Assert( 0, limit.diagram_morphism_input_type = [ ] );
            
            test_arguments := [ ];
            
        fi;
        
        if limit_colimit = "limit" then
            
            universal_morphism_with_given_name := limit.limit_universal_morphism_with_given_name;
            call_arguments := Concatenation( [ "cat" ], range_diagram_arguments_names, [ source_argument_name ], test_arguments, [ range_argument_name ] );
            
        elif limit_colimit = "colimit" then
            
            universal_morphism_with_given_name := limit.colimit_universal_morphism_with_given_name;
            call_arguments := Concatenation( [ "cat" ], source_diagram_arguments_names, [ range_argument_name ], test_arguments, [ source_argument_name ] );
            
        else
            
            Error( "this should never happen" );
            
        fi;
        
        
        current_string := ReplacedStringViaRecord( """
##
AddDerivationToCAP( functorial_with_given_name,
                    
  function( input_arguments )
    
    return universal_morphism_with_given( call_arguments );
    
end : Description := "functorial_with_given_name using the universality of the limit_colimit" );
""",
            rec(
                functorial_with_given_name := functorial_with_given_name,
                input_arguments := input_arguments_names,
                universal_morphism_with_given := universal_morphism_with_given_name,
                call_arguments := call_arguments,
                limit_colimit := limit_colimit,
            )
        );
        
        output_string := Concatenation( output_string, current_string );
        
        # derive functorial of empty limits from IdentityMorphism
        if Length( limit.diagram_filter_list ) = 0 and (limit.limit_object_name <> limit.colimit_object_name or limit_colimit = "limit") then
            
            current_string := ReplacedStringViaRecord( """
##
AddDerivationToCAP( functorial_name,
                    
  function( cat )
    
    return IdentityMorphism( cat, object_name( cat ) );
    
end : Description := "functorial_name by taking the identity morphism of object_name" );
""",
                rec(
                    functorial_name := functorial_name,
                    object_name := object_name,
                )
            );
            
            output_string := Concatenation( output_string, current_string );
            
        fi;
        
    end;
    
    for limit in limits do
        
        number_of_diagram_arguments := Length( limit.diagram_filter_list );
        
        if number_of_diagram_arguments > 0 then
            
            #### universal morphism convenience
            generate_universal_morphism_convenience( limit, limit.limit_universal_morphism_name, limit.limit_object_name, "Range" );
            generate_universal_morphism_convenience( limit, limit.colimit_universal_morphism_name, limit.colimit_object_name, "Source" );
            
        fi;
        
        #### functorial convenience method
        generate_functorial_convenience_method( limit, "limit", limit.limit_object_name, limit.limit_functorial_name, limit.limit_functorial_with_given_name );
        generate_functorial_convenience_method( limit, "colimit", limit.colimit_object_name, limit.colimit_functorial_name, limit.colimit_functorial_with_given_name );
        
    od;
    
    if not IsExistingFileInPackageForHomalg( package_name, "LimitConvenienceOutput.gi" ) or output_string <> ReadFileFromPackageForHomalg( package_name, "LimitConvenienceOutput.gi" ) then
        
        output_path := Filename( DirectoryTemporary( ), "LimitConvenienceOutput.gi" );
        
        WriteFileForHomalg( output_path, output_string );
        
        Display( Concatenation(
            "WARNING: The file LimitConvenienceOutput.gi differs from the automatically generated one. ",
            "You can view the automatically generated file at the following path: ",
            output_path
        ) );
        
    fi;
    
end );

CAP_INTERNAL_GENERATE_CONVENIENCE_METHODS_FOR_LIMITS( "CAP", CAP_INTERNAL_METHOD_NAME_RECORD, CAP_INTERNAL_METHOD_NAME_RECORD_LIMITS );
