#############################################################################
##
#W  trsstatuspos.g              GAP4 Package `RCWA'               Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing list of
##  transitivity stati, as far as known.
##
##  Given an index i, the entry trsstatus[i] provides information on what is
##  known about whether the group grps[i] acts transitively on the nonnega-
##  tive integers in its support or not. trsstatuspos[i] is a "translation"
##  of this to an integer. -- E.g. trsstatuspos[i] = 5 says that grps[i] is
##  finite, while trsstatuspos[i] = 7 says that grps[i] acts transitively on
##  the nonnegative integers in its support. This "translation" is defined
##  by the entry of the list 'trsstatusset' at the respective position, i.e.
##  5 or 7 on the above examples.
##
#############################################################################

return
[5,5,5,5,5,1,5,5,3,5,3,1,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,15,3,5,5,5,15,5,15,15,3,3,3,5,5,15,5,3,5,15,5,
16,16,5,5,3,3,3,11,15,15,11,15,15,11,15,15,15,15,11,5,
5,5,5,3,5,5,18,5,18,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,16,16,5,5,5,5,5,3,3,3,3,3,5,5,15,5,15,5,5,5,15,
3,3,3,15,3,3,15,15,15,15,11,15,15,11,11,11,15,15,5,5,5,
7,5,5,7,5,7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,7,7,
5,5,5,7,5,7,7,7,7,7,5,5,7,5,7,5,7,5,7,7,7,7,7,7,7,
6,6,6,6,6,7,7,7,6,7,7,7,5,5,3,5,5,15,5,15,3,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,5,15,3,
1,5,5,15,5,15,5,5,5,15,15,5,5,15,3,1,11,11,11,11,11,
11,11,11,11,11,11,11,5,7,5,5,7,5,7,7,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,16,3,5,5,5,15,5,15,15,3,3,3,5,5,16,
5,3,5,15,5,3,3,3,3,3,3,3,3,15,15,3,15,15,3,15,15,15,
15,3,7,5,5,7,5,7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
16,3,5,5,5,15,5,15,15,3,3,3,5,5,16,5,3,5,15,5,3,3,3,
3,3,3,3,3,15,15,3,15,15,3,15,15,15,15,3,3,7,7,7,7,3,
1,3,3,1,3,3,1,1,7,3,1,3,3,1,3,3,7,3,1,1,7,7,7,3,3,
3,7,3,1,1,7,1,7,7,7,7,1,1,3,3,7,7,3,3,7,7,3,7,2,17,
2,7,2,2,17,5,15,5,15,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,15,15,5,5,5,5,5,5,5,15,3,1,5,5,15,5,15,5,5,5,15,
15,5,5,15,3,1,11,11,11,11,11,11,11,11,11,11,11,11,7,5,
7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,3,5,5,5,15,
5,15,15,3,3,3,5,5,16,5,3,5,15,5,3,3,3,3,3,3,3,3,15,
15,3,15,15,3,15,15,15,15,3,7,15,7,16,16,18,3,3,7,16,3,
3,3,15,18,16,15,16,18,18,18,3,3,7,3,7,3,3,7,7,7,15,3,
16,3,16,7,3,7,18,7,7,7,16,7,7,16,16,16,16,17,7,7,16,
17,16,7,7,7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,3,
5,5,5,15,5,15,15,3,3,3,5,5,16,5,3,5,15,5,3,3,3,3,3,
3,3,3,15,15,3,15,15,3,15,15,15,15,3,7,16,16,18,3,3,7,
16,3,3,3,15,18,16,15,16,18,18,18,3,3,7,3,7,3,3,7,7,7,
15,3,16,3,16,7,3,7,18,7,7,7,16,7,7,16,16,16,16,17,7,7,
16,17,16,7,7,1,3,3,1,3,3,1,1,7,3,1,3,3,1,3,3,7,3,1,
1,7,7,7,3,3,3,7,3,1,1,7,1,7,7,7,7,1,1,3,3,7,7,3,3,
7,7,3,7,2,17,2,7,2,2,17,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,16,16,5,5,5,15,5,5,5,16,3,1,5,5,16,5,16,5,15,5,
15,15,15,15,16,3,1,15,13,13,15,12,12,13,12,12,12,12,13,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,16,5,5,5,5,5,15,15,
16,1,3,5,5,15,5,16,5,5,5,16,16,15,15,16,1,3,13,15,15,
13,13,13,15,12,13,12,13,15,5,5,5,5,5,5,5,5,5,5,5,5,5,
16,16,5,5,5,15,5,15,15,15,3,3,5,5,16,5,16,5,15,5,16,
16,15,15,16,3,3,15,15,15,15,13,13,15,15,13,15,13,15,5,5,
5,5,5,5,5,5,5,5,5,5,16,16,5,5,5,15,5,15,15,15,1,1,5,
5,15,5,3,5,15,5,15,16,5,5,3,1,1,12,13,13,12,15,15,13,
13,15,13,15,13,5,5,5,5,5,5,5,5,5,5,5,15,16,5,5,5,15,
5,15,15,16,1,3,5,5,16,5,3,5,15,5,16,16,15,15,3,1,3,13,
15,15,13,15,15,15,13,15,13,15,15,5,5,5,5,5,5,5,5,5,5,
16,16,5,5,5,5,5,1,1,16,3,3,5,5,16,5,3,5,5,5,15,15,15,
15,3,3,3,14,15,15,14,14,14,15,14,14,14,14,15,5,5,5,5,5,
5,5,5,5,15,15,5,5,5,15,5,5,5,15,3,1,5,5,16,5,16,5,15,
5,16,15,15,15,16,3,1,12,12,12,12,13,13,12,15,13,15,13,
12,5,5,5,5,5,5,5,5,16,16,5,5,5,15,5,15,15,16,3,1,5,5,
16,5,3,5,15,5,16,16,15,15,3,3,1,15,13,13,15,15,15,13,
15,15,15,15,13,5,5,5,5,5,5,5,16,16,5,5,5,15,5,15,15,
16,3,3,5,5,16,5,3,5,15,5,16,16,5,5,3,3,3,14,14,14,14,
15,15,14,14,15,14,15,14,5,5,5,5,5,5,16,16,5,5,5,16,5,
15,15,16,3,3,5,5,16,5,3,5,16,5,16,16,16,16,3,3,3,19,
16,16,19,16,16,16,19,16,19,16,16,5,5,5,5,5,15,15,5,5,5,
5,5,5,5,15,3,3,5,5,15,5,15,5,5,5,15,15,5,5,15,3,3,11,
11,11,11,11,11,11,11,11,11,11,11,5,5,5,5,16,16,5,5,5,5,
5,3,3,3,3,3,5,5,15,5,15,5,5,5,15,3,3,3,15,3,3,15,15,
15,15,11,15,15,11,11,11,15,15,5,5,5,16,16,5,5,5,5,5,3,
3,3,3,3,5,5,15,5,15,5,5,5,15,3,3,3,15,3,3,15,15,15,
15,11,15,15,11,11,11,15,15,5,5,15,15,5,5,5,5,5,5,5,15,
3,3,5,5,15,5,15,5,5,5,15,15,5,5,15,3,3,11,11,11,11,11,
11,11,11,11,11,11,11,5,16,16,5,5,5,5,5,3,3,3,3,3,5,5,
15,5,15,5,5,5,15,3,3,3,15,3,3,15,15,15,15,11,15,15,11,
11,11,15,15,16,16,5,5,5,5,5,3,3,3,3,3,5,5,15,5,15,5,
5,5,15,3,3,3,15,3,3,15,15,15,15,11,15,15,11,11,11,15,
15,16,15,15,15,15,15,15,15,16,7,3,15,15,15,15,16,15,15,
15,16,7,3,3,16,7,3,16,16,16,16,15,16,16,15,15,15,16,16,
3,3,3,3,3,3,3,3,3,7,15,3,16,3,16,3,3,3,15,3,7,7,16,
3,7,16,16,16,16,15,16,16,15,15,15,16,16,5,5,15,5,15,15,
3,3,3,5,5,15,5,3,5,15,5,16,16,5,5,3,3,3,11,15,15,11,
15,15,11,15,15,15,15,11,5,15,5,15,15,3,3,3,5,5,15,5,3,
5,15,5,16,16,5,5,3,3,3,11,15,15,11,15,15,11,15,15,15,
15,11,3,5,5,5,16,3,3,5,5,16,5,3,5,3,5,15,3,15,15,3,3,
3,15,11,11,15,15,11,15,15,15,15,11,15,3,15,15,3,3,3,5,
15,15,15,7,3,5,3,7,3,3,3,7,3,3,16,13,13,16,15,18,12,
15,15,15,18,12,5,5,16,3,3,5,5,16,5,3,5,3,5,15,3,15,15,
3,3,3,15,11,11,15,15,11,15,15,15,15,11,15,5,3,7,3,5,15,
15,15,3,5,15,5,3,3,3,3,3,7,3,13,15,15,13,18,15,16,12,
18,12,15,16,3,7,3,5,15,15,15,3,5,15,5,3,3,3,3,3,7,3,
13,15,15,13,18,15,16,12,18,12,15,16,3,7,15,3,16,3,3,16,
3,16,3,3,3,3,3,3,7,16,15,15,16,16,3,16,16,16,16,3,16,
3,3,3,3,3,3,3,3,3,3,7,3,3,3,3,3,3,7,7,3,3,7,3,3,3,
3,7,3,3,3,3,3,3,3,3,3,3,3,9,9,3,3,3,3,3,3,3,3,3,7,
3,3,3,3,7,5,15,5,15,5,5,5,15,15,5,5,15,3,3,11,11,11,
11,11,11,11,11,11,11,11,11,15,5,3,5,15,5,16,16,5,5,3,3,
3,11,15,15,11,15,15,11,15,15,15,15,11,15,6,16,15,16,15,
3,3,3,6,3,3,16,15,15,16,16,15,16,16,16,16,15,16,3,5,15,
5,16,16,5,5,3,3,3,11,15,15,11,15,15,11,15,15,15,15,11,
3,7,3,6,3,3,3,15,3,3,16,18,18,16,7,3,3,16,7,16,3,3,3,
5,15,3,15,15,3,3,3,15,11,11,15,15,11,15,15,15,15,11,15,
3,7,3,3,3,7,3,3,16,13,13,16,15,18,12,15,15,15,18,12,15,
3,15,15,3,3,3,15,11,11,15,15,11,15,15,15,15,11,15,16,15,
15,6,3,3,15,16,16,15,16,16,15,16,16,16,16,15,3,3,3,7,3,
3,16,16,3,16,16,3,16,16,16,16,3,5,3,3,9,15,16,16,15,12,
12,15,16,12,16,12,15,3,3,9,15,16,16,15,12,12,15,16,12,
16,12,15,3,3,16,18,18,16,7,3,3,16,7,16,3,3,3,3,7,7,3,
3,7,3,3,3,3,7,3,3,3,3,3,3,3,7,3,3,3,3,7,15,15,11,15,
3,3,15,15,15,3,17,11,15,15,15,15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,3,17,15,15,15,3,17,15,15,15,11,
15,15,15,15,15,15,15,11,15,15,15,15,15,11,15,11,15,15,15,
15,15,15,15,15,5,5,5,5,16,5,5,16,5,3,3,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,3,3,5,5,5,15,5,15,3,3,15,3,5,5,15,
5,15,5,15,5,15,15,3,3,3,3,3,15,11,11,11,15,11,15,11,11,
15,11,11,5,5,5,16,5,5,16,5,3,3,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,3,3,5,5,5,15,5,15,3,3,15,3,5,5,15,5,15,
5,15,5,15,15,3,3,3,3,3,15,11,11,11,15,11,15,11,11,15,
11,11,5,5,1,5,5,5,5,5,1,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,15,3,5,5,5,15,5,15,15,3,3,3,5,5,5,5,15,5,5,5,
15,15,5,5,3,5,3,11,15,11,11,15,11,11,5,11,11,5,11,5,16,
5,5,5,5,3,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,3,
5,5,5,15,5,15,15,3,15,3,5,5,15,5,5,5,15,5,5,5,15,15,
3,15,3,11,11,11,15,11,11,15,11,5,11,5,11,15,5,5,15,5,3,
3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,3,5,5,5,16,5,
16,15,3,3,3,5,5,5,5,5,5,5,5,5,5,15,15,3,3,1,3,15,15,
11,11,15,3,5,5,15,5,15,15,16,16,16,3,1,15,15,16,15,16,
16,15,16,16,16,15,15,15,15,16,16,15,16,15,15,16,16,16,16,
15,16,16,3,15,15,15,15,15,15,15,15,15,15,16,16,7,3,7,16,
16,3,3,16,16,16,15,15,16,15,16,5,16,5,3,15,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,3,5,5,5,15,5,15,5,3,15,3,5,
5,15,5,15,5,15,5,15,15,5,5,3,5,3,11,11,5,11,11,15,11,
11,5,15,11,11,16,5,3,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,3,5,5,5,16,5,16,5,3,15,1,5,5,15,5,15,5,15,5,15,
15,15,15,3,5,3,15,15,5,3,15,11,11,15,5,15,5,3,7,3,3,
15,5,15,15,15,15,15,15,15,15,5,15,15,3,3,3,3,3,5,3,3,
15,3,15,3,3,16,3,15,15,5,3,15,3,5,3,18,18,3,3,4,3,3,
16,15,5,12,13,15,13,15,4,16,3,3,3,15,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,16,5,5,5,16,5,16,5,16,16,3,5,5,5,
5,5,5,5,5,5,5,5,5,3,15,3,16,15,5,15,15,15,15,5,11,15,
11,16,3,15,15,15,5,15,15,15,15,3,16,5,3,3,3,15,15,5,3,
5,3,15,3,15,3,5,3,3,3,15,15,3,3,3,15,3,15,3,3,3,3,3,
15,3,13,12,4,15,13,3,3,3,5,16,15,15,15,15,16,15,15,15,
16,16,16,16,15,1,1,1,15,15,1,16,15,1,15,16,15,16,1,16,
7,7,1,1,3,15,3,1,3,1,1,1,1,1,7,15,3,3,7,2,16,16,16,
16,15,16,16,15,16,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,
5,5,5,15,5,15,5,1,16,3,5,5,5,5,5,5,5,5,15,15,15,15,3,
5,3,13,12,5,13,11,11,12,5,5,11,5,12,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,15,1,5,5,5,15,5,15,15,1,3,3,5,5,5,5,15,
5,5,5,5,5,15,15,3,15,3,11,13,11,11,12,12,13,5,5,11,5,
13,5,5,5,5,5,5,5,5,5,5,5,5,5,15,1,5,5,5,3,5,3,15,1,
3,3,5,5,15,5,5,5,15,5,5,5,15,15,3,15,1,13,13,11,15,13,
13,15,5,5,13,5,13,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,5,5,
15,5,15,5,1,16,1,5,5,5,5,5,5,5,5,15,15,5,5,1,5,3,11,
11,5,11,13,13,11,5,11,12,11,11,5,5,5,5,5,5,5,5,5,5,5,
15,3,5,5,5,16,5,16,15,3,3,3,5,5,5,5,15,5,5,5,5,5,5,
5,3,5,3,13,15,11,13,15,13,13,5,11,13,11,15,5,5,5,5,5,
5,5,5,5,5,5,16,5,5,5,16,5,16,5,16,3,3,5,5,5,5,5,5,5,
5,5,5,5,5,3,5,3,14,14,11,13,13,13,14,5,5,14,5,14,5,5,
5,5,5,5,5,5,5,5,1,5,5,5,15,5,15,5,1,16,3,5,5,15,5,
15,5,15,5,15,15,15,15,3,5,1,11,11,5,11,11,11,11,11,5,
13,5,11,5,5,5,5,5,5,5,5,5,1,5,5,5,16,5,16,5,1,16,3,
5,5,15,5,15,5,15,5,15,15,5,5,3,5,3,13,13,5,13,13,15,
13,11,11,15,11,13,5,5,5,5,5,5,5,5,16,5,5,5,18,5,18,5,
16,16,3,5,5,5,5,5,5,5,5,5,5,5,5,3,15,3,14,13,5,13,14,
14,14,5,11,13,11,13,5,5,5,5,5,5,15,3,5,5,5,16,5,16,15,
3,15,3,5,5,5,5,15,5,5,5,15,15,15,15,3,15,3,13,15,12,
12,15,13,13,5,12,12,12,15,5,5,5,5,5,5,3,5,5,5,15,5,15,
5,3,15,3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,11,11,5,11,
11,11,11,5,5,11,5,11,5,5,5,5,3,3,5,5,5,15,5,15,3,3,
15,3,5,5,5,5,5,5,5,5,5,5,15,15,3,3,3,15,11,11,11,11,
11,15,5,5,11,11,11,5,5,5,3,3,5,5,5,15,5,15,3,3,15,3,
5,5,5,5,5,5,5,5,5,5,15,15,3,3,3,15,11,11,11,11,11,15,
5,5,11,11,11,5,5,15,3,5,5,5,15,5,15,15,3,3,3,5,5,5,5,
5,5,5,5,15,15,5,5,3,3,3,11,15,11,11,11,15,11,5,5,11,
11,11,5,5,7,5,5,5,7,5,7,5,7,3,3,5,5,5,5,5,5,5,5,5,
5,5,5,3,5,3,15,15,5,15,15,15,15,5,5,3,5,3,5,7,5,5,5,
7,5,7,5,7,3,3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,15,15,
5,15,15,15,15,5,5,3,5,3,3,5,15,5,15,5,15,5,3,3,3,5,5,
5,5,5,5,5,5,3,3,3,3,3,3,3,12,18,12,11,11,12,18,5,5,
11,12,11,3,3,7,7,7,7,3,3,3,7,3,3,3,15,15,3,3,3,3,3,
3,3,3,15,7,4,3,15,4,3,3,4,15,15,3,15,7,5,5,15,5,15,5,
3,15,3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,11,11,5,11,11,
11,11,5,5,11,5,11,5,15,5,15,15,3,3,3,5,5,5,5,5,5,5,5,
15,15,5,5,3,3,3,11,15,11,11,11,15,11,5,5,11,11,11,7,5,
7,5,7,3,3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,15,15,5,15,
15,15,15,5,5,3,5,3,7,15,15,7,6,3,15,15,15,15,15,15,15,
15,15,15,15,15,7,15,3,16,16,15,3,16,16,3,15,15,16,15,16,
7,5,7,3,3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,15,15,5,15,
15,15,15,5,5,3,5,3,15,7,6,3,15,15,15,15,15,15,15,15,15,
15,15,15,7,15,3,16,16,15,3,16,16,3,15,15,16,15,16,3,3,
3,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,12,18,12,11,11,12,18,
5,5,11,12,11,3,7,3,3,3,15,15,3,3,3,3,3,3,3,3,15,7,4,
3,15,4,3,3,4,15,15,3,15,7,3,15,15,15,15,15,15,15,15,18,
18,15,15,3,3,3,16,7,3,3,16,16,3,15,15,16,15,15,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,3,3,7,1,1,3,3,3,5,
15,5,15,5,15,5,15,15,5,5,3,5,3,11,11,5,11,15,11,11,11,
11,15,5,11,15,5,15,5,15,5,15,15,5,5,3,5,3,11,11,5,11,
15,11,11,11,11,15,5,11,5,15,3,5,3,15,15,3,3,3,5,3,11,
11,5,16,12,11,11,12,12,18,5,11,3,5,5,5,5,5,5,5,3,15,3,
11,11,11,11,11,11,11,11,11,11,11,11,3,15,3,15,15,3,3,3,
3,3,11,11,11,15,15,11,11,15,3,15,11,15,3,5,5,5,15,15,3,
5,3,11,11,5,15,11,11,11,11,11,11,5,15,3,15,15,3,3,3,5,
3,11,11,5,16,12,11,11,12,12,18,5,11,5,5,15,15,3,5,3,11,
11,5,15,11,11,11,11,11,11,5,15,5,5,5,3,3,3,12,13,5,12,
13,13,11,15,5,12,15,11,5,5,3,3,3,12,13,5,12,13,13,11,
15,5,12,15,11,5,3,3,3,13,11,15,13,11,11,12,15,5,12,5,
13,3,3,3,13,11,15,13,11,11,12,15,5,12,5,13,3,3,3,7,3,
3,7,3,3,3,3,7,3,3,3,15,15,3,11,11,15,15,11,11,11,15,
11,4,3,1,3,3,3,4,3,3,3,1,7,15,13,11,19,15,3,11,11,19,
13,16,12,19,15,15,15,11,11,15,13,14,11,11,13,12,11,10,11,
5,11,15,19,15,13,13,3,11,3,11,19,13,12,15,11,15,15,11,
11,15,12,19,11,11,19,13,11,5,12,10,13,13,10,12,11,3,11,
5,5,5,16,5,5,16,5,3,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,3,3,5,5,5,15,5,15,3,3,15,3,5,5,15,5,15,5,15,5,15,
15,3,3,3,3,3,15,11,11,11,15,11,15,11,11,15,11,11,5,5,3,
5,5,15,5,15,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,
5,5,5,5,5,5,3,15,5,3,5,5,15,5,15,5,5,5,15,5,3,15,15,
3,15,15,11,15,11,11,5,11,11,11,11,11,5,5,16,5,5,15,5,1,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,
15,3,15,15,3,5,5,15,5,15,5,15,5,15,15,3,15,3,3,5,11,5,
11,11,15,11,11,15,11,11,11,5,3,5,5,15,5,3,3,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,15,5,5,3,3,5,3,5,
5,3,5,3,5,15,5,3,5,3,3,1,1,3,15,5,11,15,11,5,15,15,
15,15,15,5,5,16,16,15,3,3,15,5,15,15,15,3,15,15,16,16,
15,5,15,3,3,3,3,3,15,3,3,16,3,5,3,3,15,3,5,15,15,3,
16,3,16,3,15,5,3,3,3,3,3,16,4,3,3,16,15,13,15,15,13,
12,5,5,16,5,16,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,
15,5,5,5,5,5,15,3,5,5,3,5,5,15,5,15,5,5,5,15,15,3,5,
15,3,15,11,5,11,5,11,11,15,11,11,11,15,11,16,5,15,3,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,15,3,
5,15,3,5,5,16,5,16,5,15,5,16,15,3,5,3,3,5,15,5,3,5,
15,15,11,11,15,15,3,5,1,16,3,16,16,16,15,16,16,15,16,15,
16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,15,15,7,
15,15,16,15,16,15,15,15,16,15,16,15,6,7,3,16,15,16,15,
16,15,16,16,16,16,7,3,16,7,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,16,5,15,3,5,5,16,5,3,5,5,5,16,
5,16,5,3,3,5,15,11,15,5,15,5,15,15,16,16,15,11,3,16,15,
16,15,16,15,16,16,16,15,15,15,15,15,15,15,15,15,15,16,16,
1,15,15,16,15,3,7,15,15,16,16,6,16,1,15,16,15,16,15,16,
3,15,16,15,16,15,16,3,3,16,16,16,16,15,15,15,15,5,15,1,
15,15,15,15,3,5,3,3,3,3,3,3,15,15,15,3,3,3,3,5,3,4,5,
15,3,15,3,15,3,3,3,3,3,5,3,3,15,4,3,15,4,13,5,13,12,
3,16,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,
5,15,5,5,1,15,5,3,5,5,15,5,16,5,15,5,15,5,1,15,16,3,
15,13,5,12,11,11,5,12,11,11,11,11,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,15,15,5,5,5,5,5,5,1,5,5,1,5,5,15,5,16,5,5,
5,15,5,1,5,16,3,5,11,11,13,5,12,5,13,11,12,11,12,11,5,
5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,1,15,5,3,
5,5,16,5,16,5,5,5,16,5,1,15,15,1,15,15,11,15,11,13,5,
13,13,13,13,13,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
15,5,15,1,5,15,3,5,5,15,5,15,5,15,5,15,15,1,5,3,3,15,
11,5,11,5,13,11,11,12,13,12,13,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,15,1,5,5,3,5,5,3,5,3,5,5,5,3,15,1,
5,3,3,15,13,11,13,5,13,11,15,13,15,13,15,11,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,18,5,15,3,5,5,16,5,3,5,5,
5,16,5,18,5,3,3,5,13,11,14,5,13,5,14,14,13,14,13,11,5,
5,5,5,5,5,5,5,5,15,15,5,5,5,15,5,5,1,5,5,3,5,5,15,5,
16,5,15,5,15,5,1,5,16,1,5,11,5,11,5,11,5,11,13,11,13,
11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,15,3,15,15,3,5,
5,16,5,16,5,15,5,16,15,3,15,3,3,5,13,5,13,5,15,11,13,
15,13,13,13,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,
3,5,5,16,5,3,5,5,5,16,5,16,5,3,3,5,13,5,14,5,14,11,
13,13,14,13,14,5,5,5,5,5,5,5,15,15,5,5,5,15,5,15,1,5,
15,3,5,5,3,5,3,5,15,5,3,15,1,5,3,3,15,12,12,13,5,13,
12,15,12,15,13,15,12,5,5,5,5,5,15,15,5,5,5,5,5,5,3,3,
5,3,5,5,15,5,15,5,5,5,15,5,3,3,15,3,3,15,5,11,11,11,
5,15,11,11,11,11,11,5,5,5,5,5,5,5,5,5,5,5,5,3,5,5,3,
5,5,15,5,15,5,5,5,15,5,3,5,15,3,5,11,5,11,5,11,5,11,
11,11,11,11,5,5,5,5,15,15,5,5,5,5,5,5,3,3,5,3,5,5,15,
5,15,5,5,5,15,5,3,3,15,3,3,15,5,11,11,11,5,15,11,11,
11,11,11,5,5,15,15,5,5,5,5,5,3,3,5,3,3,5,5,15,5,15,5,
5,5,15,3,3,5,15,3,5,11,11,15,5,11,11,11,11,11,11,15,5,
5,15,15,5,5,5,5,5,3,3,5,3,3,5,5,15,5,15,5,5,5,15,3,
3,5,15,3,5,11,11,15,5,11,11,11,11,11,11,15,5,5,5,5,5,
5,5,5,5,15,5,3,3,5,5,15,5,15,5,5,5,15,5,15,5,15,3,3,
11,11,11,11,11,11,11,11,11,11,11,11,5,5,5,5,5,5,3,3,3,
3,3,5,5,15,5,15,5,5,5,15,3,3,3,15,3,3,13,15,12,15,11,
5,13,12,11,12,13,5,5,5,5,5,5,3,3,3,3,3,5,5,15,5,15,5,
5,5,15,3,3,3,15,3,3,13,15,12,15,11,5,13,12,11,12,13,5,
5,5,15,5,15,3,5,15,3,5,5,15,5,15,5,15,5,15,15,3,5,3,
3,5,11,11,11,5,15,11,11,11,11,15,11,5,5,5,5,5,7,5,5,3,
5,5,7,5,3,5,5,5,7,5,7,5,3,3,5,15,5,15,5,15,5,15,15,
15,15,15,5,5,5,5,7,5,5,3,5,5,7,5,3,5,5,5,7,5,7,5,3,
3,5,15,5,15,5,15,5,15,15,15,15,15,5,15,15,3,3,15,3,5,
15,15,5,18,5,5,15,15,15,3,3,3,3,3,12,5,11,15,13,15,11,
12,13,13,11,5,5,3,15,5,3,5,5,15,5,3,5,15,5,15,5,3,15,
15,3,15,11,5,11,11,11,5,11,15,15,11,11,11,3,5,15,3,5,
15,15,5,15,5,15,5,15,5,3,5,3,3,5,11,12,12,5,18,12,11,
11,11,12,15,5,3,15,7,3,3,7,7,3,7,3,3,7,3,3,3,3,7,15,
4,15,4,15,3,15,4,3,3,3,4,15,5,3,5,5,15,5,3,5,3,15,15,
5,3,5,15,3,15,18,5,11,12,11,5,12,16,11,11,11,12,3,5,15,
15,5,15,5,15,5,15,15,15,5,3,3,3,11,3,15,12,15,15,11,11,
11,15,15,11,3,3,3,3,3,3,3,3,3,3,7,3,3,3,3,7,3,3,3,3,
3,7,3,3,3,7,3,5,15,5,15,5,5,5,15,5,3,5,15,3,5,11,5,
11,5,11,5,11,11,11,11,11,5,15,5,15,5,15,5,15,15,3,5,3,
3,5,11,11,11,5,15,11,11,11,11,15,11,5,7,6,7,15,15,15,
15,7,15,6,3,15,16,15,16,15,16,15,3,16,7,16,3,15,3,5,5,
5,7,5,7,5,3,3,5,15,5,15,5,15,5,15,15,15,15,15,5,3,18,
3,6,15,3,3,15,3,3,16,15,16,16,16,15,3,16,7,16,3,3,5,5,
7,5,7,5,3,3,5,15,5,15,5,15,5,15,15,15,15,15,5,15,15,
15,3,3,3,3,3,12,5,11,15,13,15,11,12,13,13,11,5,15,5,3,
15,15,3,15,11,5,11,11,11,5,11,15,15,11,11,11,15,7,15,6,
3,15,16,15,16,15,16,15,3,16,7,16,3,15,3,5,3,3,5,11,12,
12,5,18,12,11,11,11,12,15,5,3,3,7,15,4,15,4,15,3,15,4,
3,3,3,4,15,15,3,15,18,5,11,12,11,5,12,16,11,11,11,12,3,
15,16,16,15,15,7,3,3,16,3,16,3,15,3,3,3,3,1,3,3,4,3,
3,3,7,1,15,11,11,3,11,11,15,15,15,11,11,15,11,15,12,19,
11,15,15,15,19,15,13,12,10,13,5,11,11,11,13,13,10,11,15,
13,11,19,19,15,3,11,11,11,13,13,13,11,11,5,12,19,15,11,
15,15,11,11,11,11,13,12,10,15,15,19,15,12,15,11,19,13,16,
14,12,15,11,11,5,5,3,5,5,3,5,15,1,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,3,15,5,5,5,5,5,5,15,15,3,15,5,5,5,5,3,
5,3,5,5,3,15,3,15,3,3,11,15,15,15,11,12,11,12,15,11,12,
12,5,16,5,5,15,5,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,3,15,5,5,5,15,5,15,15,15,16,15,5,5,15,5,16,5,16,5,
15,16,15,3,15,3,3,11,12,3,3,11,15,11,15,12,11,12,12,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,5,5,
5,5,15,5,5,16,16,5,5,5,5,5,5,5,5,15,5,15,15,5,3,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,3,3,3,15,15,5,16,5,
15,15,5,15,5,15,15,5,3,5,3,3,5,15,5,5,15,5,15,3,3,6,
15,15,5,15,3,6,5,15,3,15,15,5,3,3,3,3,13,3,3,3,15,15,
13,15,3,15,3,3,5,16,5,3,3,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,3,5,5,5,5,15,5,15,5,5,16,15,5,5,15,5,16,5,16,5,
15,16,5,3,15,3,3,11,12,12,12,11,15,11,15,12,11,3,3,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,3,5,5,5,5,5,
16,5,5,5,5,5,5,16,5,5,5,15,5,5,15,3,3,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,3,3,3,16,5,5,16,5,16,16,5,16,5,15,15,
5,3,5,3,3,3,15,5,5,15,5,15,3,3,6,15,15,5,15,3,6,5,15,
3,15,15,3,3,3,3,3,13,3,3,3,15,15,13,15,3,15,3,3,15,3,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,5,5,5,5,5,5,
5,3,5,5,5,5,5,3,5,16,5,5,16,5,16,5,3,3,11,15,15,15,5,
15,5,15,15,11,15,15,5,16,16,5,15,5,15,16,5,15,5,3,3,5,
15,5,15,3,3,15,5,5,5,5,15,15,15,3,3,15,5,15,15,3,5,3,
15,5,3,3,3,15,7,7,3,15,15,15,13,3,3,3,15,13,15,15,15,
15,5,5,5,16,15,5,16,5,3,3,5,15,5,15,3,3,15,5,5,15,5,
3,15,15,3,3,15,5,3,15,3,5,3,15,15,3,3,3,15,7,7,3,3,
15,15,13,3,3,3,3,13,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,1,15,5,5,5,5,5,5,15,15,15,15,5,5,5,5,15,5,16,5,5,
16,15,1,15,15,15,11,5,12,12,11,11,11,11,5,11,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,1,15,5,5,5,5,5,5,15,15,16,15,
5,5,5,5,16,5,3,5,5,3,15,1,15,15,15,11,12,12,12,11,5,
11,5,12,11,12,12,5,5,5,5,5,5,5,5,5,5,5,5,5,1,15,5,5,
5,5,5,5,15,15,5,5,5,5,5,5,5,5,15,5,5,15,15,1,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,
5,5,5,5,15,5,15,5,5,15,15,5,5,15,5,15,5,16,5,15,16,5,
3,15,16,16,11,12,5,5,11,12,11,12,12,11,12,12,5,5,5,5,5,
5,5,5,5,5,5,1,5,5,5,5,5,5,15,15,15,5,5,5,5,15,5,5,5,
15,5,5,15,5,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,16,5,5,5,5,5,5,5,5,5,16,15,5,5,5,5,16,
5,18,5,5,18,5,16,15,16,16,5,16,16,16,5,13,11,13,16,5,
16,16,5,5,5,5,5,5,5,5,5,1,5,5,5,5,15,5,15,5,5,15,15,
5,5,15,5,15,5,16,5,15,16,5,1,15,15,15,11,5,11,11,11,12,
11,12,5,11,5,5,5,5,5,5,5,5,5,5,1,5,5,5,5,15,5,15,5,
5,5,5,5,5,15,5,5,5,15,5,15,15,5,1,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,5,5,5,5,5,5,5,15,
15,5,5,5,5,15,5,16,5,5,16,5,16,15,16,16,5,16,12,12,11,
16,5,16,16,5,16,16,5,5,5,5,5,5,1,15,5,5,5,15,5,5,5,5,
5,5,5,5,5,5,5,5,16,5,15,16,15,1,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,3,3,5,5,5,5,5,5,15,15,5,16,5,5,
5,5,5,5,15,5,5,15,3,3,5,3,3,15,5,11,11,5,5,15,5,5,5,
11,11,5,5,5,5,3,3,5,5,5,5,5,5,15,15,5,16,5,5,5,5,5,
5,15,5,5,15,3,3,5,3,3,15,5,11,11,5,5,15,5,5,5,11,11,
5,5,5,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,
15,5,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,7,5,5,5,5,
5,5,5,5,5,3,5,5,5,5,5,3,5,7,5,5,7,5,7,5,3,3,5,15,
15,15,5,3,5,3,15,5,15,15,5,3,15,5,5,5,5,5,15,5,5,5,5,
5,5,15,5,5,5,15,5,5,15,15,3,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,7,5,5,5,5,5,5,5,5,5,3,5,5,5,5,5,3,5,7,5,5,7,
5,7,5,3,3,5,15,15,15,5,3,5,3,15,5,15,15,3,3,3,15,3,3,
3,3,3,3,15,3,3,3,7,3,3,7,7,3,7,3,3,15,7,7,15,3,7,7,
15,3,15,3,3,15,9,9,5,5,5,5,5,3,3,3,5,15,5,5,3,5,5,
15,15,5,5,15,5,3,5,3,3,12,5,3,3,5,5,12,5,5,5,5,5,5,
5,15,5,15,5,5,15,5,5,5,15,5,15,5,15,5,15,15,5,3,16,5,
5,5,11,5,5,15,11,5,11,11,15,5,5,5,3,5,5,15,15,5,5,5,
5,5,5,5,5,15,5,3,15,5,3,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,15,5,5,5,5,5,5,15,5,5,15,5,15,15,5,
5,11,5,5,5,11,5,11,5,5,11,5,5,3,15,3,3,15,5,15,5,15,
5,15,5,15,5,5,15,5,3,15,5,5,5,5,5,5,12,15,5,15,5,12,
5,5,5,15,15,5,5,5,5,5,5,5,5,15,5,3,15,5,3,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,12,5,15,5,5,5,12,15,15,5,15,
15,3,3,16,5,5,5,11,5,5,15,11,5,11,11,15,5,5,5,5,16,5,
5,5,5,5,5,15,5,3,15,3,3,5,12,12,15,5,11,11,5,5,15,5,
5,5,11,11,5,16,5,5,5,5,5,5,15,5,3,15,3,3,5,12,12,15,
5,11,11,5,5,15,5,5,5,11,11,5,15,5,12,3,5,5,6,3,15,6,
5,3,3,3,3,5,3,3,3,15,16,5,15,3,15,3,3,5,5,5,5,5,5,
15,5,5,15,15,15,3,3,3,16,5,15,15,11,5,16,5,5,11,15,15,
5,15,5,15,5,15,5,15,15,5,3,16,5,5,5,11,5,5,15,11,5,11,
11,15,5,5,5,5,5,5,15,5,5,15,5,3,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,12,15,15,5,15,15,3,3,16,5,5,5,11,5,5,15,
11,5,11,11,15,5,5,3,5,7,5,5,7,5,7,5,3,3,5,15,15,15,5,
3,5,3,15,5,15,15,5,6,3,15,6,5,3,3,3,3,5,3,3,3,15,15,
5,16,3,15,3,3,15,5,5,15,15,3,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,7,15,15,15,7,15,3,3,15,7,3,3,15,6,15,6,7,15,
3,3,5,7,5,7,5,3,3,5,15,15,15,5,3,5,3,15,5,15,15,15,5,
3,15,5,5,5,5,5,5,12,15,5,15,5,12,5,5,15,7,15,3,3,15,
7,3,3,15,6,15,6,7,15,3,3,3,5,3,3,12,5,3,3,5,5,12,5,
5,5,5,5,15,7,7,15,3,7,7,15,3,15,3,3,15,9,9,5,5,11,15,
5,5,15,15,11,15,15,16,5,5,5,3,3,3,3,5,3,3,3,3,5,3,3,
3,3,3,3,5,3,3,3,3,5,3,3,5,11,11,11,5,5,5,5,11,12,12,
15,15,12,5,5,5,5,11,15,15,5,5,3,12,3,15,5,5,5,5,3,12,
3,15,5,5,5,11,10,11,12,5,5,5,5,5,5,12,3,3,5,5,11,11,
11,5,12,3,3,11,15,15,5,5,5,5,7,5,5,5,5,3,3,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,15,5,15,15,1,15,
3,5,5,5,5,3,5,15,5,3,5,15,1,3,3,3,11,11,15,3,15,11,
11,11,11,5,5,5,7,5,5,5,5,3,3,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,15,15,5,5,5,15,5,15,15,1,15,3,5,5,5,5,3,5,
15,5,3,5,15,1,3,3,3,11,11,15,3,15,11,11,11,11,5,5,5,3,
3,3,3,3,3,1,3,3,1,1,3,1,1,3,16,1,3,3,1,1,3,3,15,1,
1,3,3,7,15,3,3,4,3,1,1,3,1,7,16,16,3,1,1,16,3,7,3,3,
3,4,7,3,7,3,3,3,7,1,1,1,5,15,5,15,3,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,5,15,3,1,5,5,15,
5,15,5,5,5,15,15,5,5,15,3,1,11,11,11,11,11,11,11,11,11,
11,11,11,3,5,5,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,
15,5,5,5,5,5,15,5,15,3,3,5,5,15,5,3,5,15,5,5,15,15,5,
3,15,3,3,15,11,11,11,5,5,5,15,11,11,11,3,15,3,15,5,15,
5,15,15,15,5,15,5,5,15,5,5,15,15,15,15,5,5,5,5,5,5,15,
15,3,3,15,5,5,5,16,5,5,5,15,5,5,5,16,3,3,12,13,11,11,
11,11,11,11,13,15,3,3,5,7,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,15,15,5,5,5,5,5,15,5,15,3,3,5,5,15,5,3,5,15,5,
5,15,15,5,3,15,3,3,15,11,11,11,5,5,5,15,11,11,11,3,5,
15,15,5,5,5,15,5,5,5,5,15,15,5,5,15,15,15,5,5,5,15,5,
5,5,15,3,3,15,5,15,5,15,5,5,5,5,5,15,15,16,3,3,11,11,
13,12,13,3,3,15,11,11,11,11,1,3,1,1,3,3,1,1,3,16,1,3,
1,1,3,3,16,3,1,1,3,3,16,3,1,15,3,3,1,1,3,1,7,7,3,3,
1,1,3,3,7,4,3,3,7,4,3,7,1,1,1,7,3,3,3,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,5,15,5,15,5,5,
15,5,15,5,15,5,5,5,5,15,16,5,15,13,12,12,13,11,5,5,5,
11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,
5,5,15,15,15,15,5,5,5,5,16,5,5,5,15,15,15,15,15,15,15,
11,13,13,11,12,5,11,5,12,5,5,11,5,5,5,5,5,5,5,5,5,5,
5,5,5,16,15,5,5,5,5,5,5,15,15,15,16,5,5,15,5,16,5,15,
5,15,5,15,15,16,15,16,15,13,15,13,13,5,11,5,12,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,15,5,15,15,15,15,
15,5,5,15,5,15,5,5,5,5,15,5,5,15,15,16,11,11,11,11,13,
11,5,5,13,5,11,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,
15,5,15,15,15,15,15,5,5,5,5,15,5,5,5,5,5,5,5,15,15,15,
13,15,13,12,15,11,5,5,13,5,5,11,5,5,5,5,5,5,5,5,5,5,
15,15,5,5,5,5,5,15,15,15,15,16,5,5,5,5,16,5,5,5,5,15,
5,5,16,5,16,12,15,15,12,13,5,11,5,12,5,5,11,5,5,5,5,5,
5,5,5,5,15,15,5,5,5,15,5,5,5,15,5,16,5,5,15,5,15,5,
15,5,15,5,15,5,15,5,15,11,11,11,11,11,5,5,11,11,11,5,5,
5,5,5,5,5,5,5,5,15,15,5,5,5,15,5,5,5,15,15,16,5,5,5,
5,16,5,15,5,15,15,5,5,16,15,16,12,13,12,12,13,5,5,11,
15,5,11,5,5,5,5,5,5,5,5,15,15,5,5,5,15,5,5,5,15,5,16,
5,5,15,5,15,5,15,5,5,15,5,5,15,15,16,13,12,12,13,15,11,
5,5,15,5,11,5,5,5,5,5,5,5,15,15,5,5,5,16,5,15,15,15,
5,16,5,5,15,5,16,5,15,5,15,15,15,5,16,5,16,19,16,16,15,
16,5,5,5,16,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,5,15,
5,1,5,5,5,5,15,5,5,5,5,5,5,5,15,5,1,11,11,11,11,11,5,
11,5,11,5,5,11,5,5,5,5,15,15,5,5,5,5,5,5,3,15,5,3,5,
5,5,5,15,5,5,5,5,5,3,15,15,3,15,15,11,15,11,11,5,11,5,
11,5,11,5,5,5,5,16,15,5,5,5,5,5,5,15,15,15,15,5,5,5,
5,15,5,5,5,5,5,15,3,15,3,3,11,11,15,15,11,11,11,5,11,
5,5,5,5,5,15,15,5,5,5,5,5,5,5,15,3,15,5,5,5,5,15,5,
5,5,5,15,5,5,15,3,15,11,11,11,11,11,11,5,5,11,5,11,5,
5,15,16,5,5,5,5,5,3,5,15,3,3,5,5,5,5,15,5,5,5,5,5,5,
5,15,15,15,15,15,11,11,11,5,5,5,11,5,11,11,15,15,5,5,5,
5,5,15,5,15,3,15,5,5,5,5,15,5,5,5,5,5,5,5,15,5,3,11,
15,11,15,11,11,5,5,11,5,5,11,15,15,15,15,15,15,15,15,15,
3,15,15,15,15,15,15,15,15,15,15,3,16,3,15,16,15,15,16,
16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,3,15,3,15,
16,15,15,15,15,16,15,15,15,15,15,15,15,16,15,7,16,15,15,
16,15,15,16,15,15,15,15,15,5,5,15,5,15,15,15,3,15,5,5,
5,5,15,5,5,5,15,15,5,5,3,5,15,11,15,11,11,15,11,5,5,
11,11,5,5,5,15,5,15,15,15,15,15,5,5,5,5,15,5,5,5,16,5,
5,5,3,3,15,11,11,15,11,15,11,5,11,11,5,5,5,15,5,5,5,
15,5,15,5,5,15,5,16,5,15,5,5,5,5,5,1,5,16,15,11,11,15,
15,5,11,5,15,11,5,5,3,15,15,3,3,16,5,5,5,5,16,15,5,15,
5,5,5,15,3,5,3,12,12,12,16,15,15,5,11,13,11,5,5,5,5,
16,5,16,5,5,15,5,16,5,15,5,5,5,5,5,16,5,16,15,11,11,
15,15,5,5,5,15,5,5,5,5,15,12,15,5,5,5,5,16,5,5,5,16,
5,5,5,3,5,15,12,15,13,12,15,11,5,5,16,5,5,15,15,12,3,
5,5,5,5,16,5,5,5,3,5,3,15,3,3,15,12,13,15,12,16,11,15,
5,16,5,11,5,15,7,15,15,15,15,15,15,16,15,15,15,15,15,16,
15,16,16,15,15,16,15,15,15,15,15,15,15,16,3,5,3,5,5,3,
5,5,5,15,16,5,5,3,3,3,11,4,15,3,15,3,5,5,12,3,3,3,15,
15,3,15,16,16,16,16,15,15,16,15,1,3,1,3,16,16,16,16,15,
16,15,16,3,3,4,5,15,5,15,5,5,5,15,5,5,5,15,5,15,11,11,
11,11,11,5,5,11,11,11,5,5,5,5,3,5,15,5,5,16,5,5,15,15,
15,11,15,11,11,11,5,5,5,15,11,11,5,5,16,16,5,15,15,5,3,
5,16,5,16,16,12,12,12,13,5,5,11,19,16,5,15,3,5,15,5,15,
15,5,5,15,3,15,11,11,15,11,11,5,5,11,15,5,11,5,16,16,1,
16,3,15,3,15,3,1,16,16,16,16,16,15,15,16,7,15,3,3,15,5,
5,5,15,5,16,5,16,15,11,11,15,15,5,5,5,15,5,5,5,3,5,3,
5,3,16,15,3,12,12,12,16,13,5,5,11,15,5,15,5,5,5,5,15,
16,5,16,15,11,11,15,15,5,5,11,15,5,5,11,15,5,5,16,3,15,
12,12,16,12,16,5,5,16,13,11,5,5,5,5,16,3,15,12,19,13,
12,16,11,5,5,16,5,16,5,5,15,3,16,15,16,16,13,11,5,11,5,
11,5,5,5,15,3,16,13,16,16,15,11,5,11,15,11,5,5,11,3,16,
16,16,16,16,7,3,3,15,16,16,15,15,3,3,15,4,11,12,3,3,3,
15,5,3,5,16,16,16,3,16,3,3,3,16,15,15,16,15,15,11,15,
11,11,11,15,13,12,13,11,15,15,11,11,11,15,12,13,12,15,15,
13,12,12,15,11,11,11,15,12,13,13,15,11,11,11,12,12,13,11,
11,11,11,5,5,11,10,11,10,5,11,11,10,11,11,11,10,11,13,
12,12,5,5,5,7,5,5,5,5,3,3,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,15,15,5,5,5,15,5,15,15,1,15,3,5,5,5,5,3,5,15,
5,3,5,15,1,3,3,3,11,11,15,3,15,11,11,11,11,5,5,5,15,
15,15,15,7,3,16,3,15,16,3,16,15,16,16,16,16,15,16,3,15,
3,3,15,15,3,16,16,7,15,3,3,16,16,16,15,15,15,16,16,16,
15,16,16,16,15,3,7,3,15,3,7,7,16,16,16,16,16,15,15,15,
5,15,5,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,5,5,
5,15,5,15,15,5,15,3,5,5,15,5,15,5,15,5,15,15,1,15,15,
3,3,5,5,11,11,11,15,3,15,5,11,11,11,15,5,7,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,3,5,5,5,15,5,15,15,5,15,3,
5,5,15,5,15,5,15,5,15,15,1,15,15,3,3,5,5,11,11,11,15,
3,15,5,11,11,11,3,3,3,15,5,5,5,15,15,15,15,15,5,5,15,
5,5,5,15,5,5,5,5,5,15,5,15,16,5,15,3,15,15,5,5,15,5,
15,5,15,15,15,15,3,3,3,11,11,11,11,11,12,13,13,11,15,3,
3,3,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
15,5,15,15,5,15,3,5,5,5,5,3,5,15,5,5,5,15,15,3,15,3,
11,11,11,11,11,11,11,11,11,11,11,11,3,3,1,1,3,3,1,1,1,
3,15,3,1,1,3,3,1,3,3,1,1,3,16,16,3,15,1,7,3,1,1,3,3,
3,7,1,1,15,3,3,16,4,3,4,1,1,3,4,4,7,3,7,1,3,3,3,15,
5,15,5,15,15,15,5,15,5,15,5,15,5,5,5,15,15,15,5,5,15,
5,16,15,5,3,3,5,5,5,15,3,5,15,5,5,5,15,15,15,15,3,3,
3,13,12,13,11,11,11,15,11,11,11,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,15,15,5,5,5,15,5,15,15,15,15,15,5,5,5,5,5,5,
15,5,15,5,15,15,15,15,15,11,5,12,13,11,11,12,11,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,15,5,15,15,
5,15,15,5,5,5,5,15,5,15,5,5,5,15,15,5,15,5,5,11,13,11,
12,12,13,11,5,5,5,11,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,
5,5,5,15,5,15,15,15,15,15,5,5,5,5,5,5,15,5,15,5,16,15,
5,16,15,11,5,13,15,12,13,15,12,5,5,5,11,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,15,5,15,15,5,15,5,5,5,5,5,5,5,
15,5,5,15,15,15,15,15,15,5,5,11,11,13,13,11,12,11,5,11,
5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,15,5,16,15,5,15,
15,5,5,5,5,5,5,15,5,5,15,15,15,15,15,5,5,11,15,13,13,
15,13,13,5,5,11,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,15,
5,15,15,5,16,15,5,5,5,5,15,5,15,5,5,5,15,15,15,16,5,5,
11,15,12,12,13,15,13,5,5,5,11,5,5,5,5,5,5,5,5,5,5,15,
5,5,5,15,5,15,15,5,15,15,5,5,15,5,15,5,15,5,15,15,15,
15,15,15,5,5,5,11,11,11,11,11,13,5,11,5,5,5,5,5,5,5,5,
5,5,5,15,5,5,5,16,5,15,15,5,16,5,5,5,15,5,15,5,16,5,
15,15,15,15,15,15,5,5,5,13,12,15,13,12,15,11,11,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,15,5,15,15,5,16,15,5,5,5,5,5,
5,15,5,15,15,15,15,15,16,15,5,5,12,13,15,15,12,13,11,5,
11,5,5,5,5,5,5,5,16,15,5,5,5,15,5,15,15,5,16,5,5,5,5,
5,5,5,15,5,15,15,15,15,5,16,5,5,5,16,19,16,16,16,19,5,
5,5,5,5,5,5,5,5,15,3,5,5,5,15,5,15,15,3,15,3,5,5,15,
5,5,5,15,5,5,5,15,15,5,15,3,11,5,11,3,11,11,3,11,5,5,
5,11,5,5,5,5,5,5,5,5,5,15,5,15,15,5,15,3,5,5,5,5,5,
5,15,5,5,5,15,15,5,1,5,11,5,11,11,11,11,11,11,5,5,11,
5,5,5,5,3,15,5,5,5,15,5,15,15,15,15,15,5,5,5,5,15,5,
15,5,5,5,15,16,5,3,3,11,5,3,3,11,11,11,11,11,5,5,5,5,
5,15,5,5,5,5,15,5,15,15,5,3,5,5,5,5,5,5,5,15,5,5,3,
15,15,5,3,5,5,11,15,11,11,15,11,11,5,5,11,5,5,5,15,5,
5,5,15,5,16,15,5,15,15,5,5,5,5,5,5,15,5,5,15,15,15,15,
15,5,5,5,11,11,11,15,15,11,5,11,11,5,5,5,5,5,5,15,5,
15,15,15,1,5,5,5,5,5,5,5,15,5,15,15,15,15,5,15,3,5,11,
11,15,15,15,11,15,5,5,5,11,5,5,15,5,15,5,15,15,15,3,12,
5,5,15,15,5,15,15,5,5,3,15,3,5,3,3,11,15,15,16,12,12,
13,12,5,5,11,5,5,5,15,15,5,3,15,3,15,13,5,5,15,15,5,
15,15,5,5,5,15,16,15,16,3,11,5,13,16,12,12,15,12,5,5,5,
5,5,5,15,5,15,15,5,15,5,5,5,5,5,5,5,15,5,5,5,15,15,3,
15,5,5,11,11,11,11,11,11,11,5,11,5,5,5,15,5,15,16,5,15,
15,5,5,5,5,5,5,15,5,3,5,15,15,3,3,5,11,11,15,11,15,11,
11,11,5,5,5,5,15,5,15,15,5,15,16,5,5,5,5,5,5,15,5,15,
5,15,15,3,15,5,11,5,11,11,15,11,15,11,5,11,5,5,16,15,
15,3,6,15,15,15,15,15,15,15,15,15,15,15,15,15,16,15,15,
15,15,15,15,16,16,15,15,15,16,15,15,15,15,15,16,5,5,5,5,
5,5,5,15,5,15,15,15,15,5,15,5,5,5,11,15,15,15,11,15,5,
5,5,5,15,15,16,15,15,15,15,15,15,15,15,15,15,15,15,15,3,
16,15,15,15,15,15,16,16,15,15,15,15,15,15,15,16,3,15,15,
15,15,15,15,15,15,3,15,3,15,15,16,15,15,15,16,15,15,15,
16,15,15,15,16,15,16,3,15,5,5,5,12,5,15,5,15,15,15,15,
3,15,3,15,5,12,15,16,12,12,13,11,5,5,11,15,15,15,15,15,
15,15,15,15,16,15,16,15,3,1,3,15,3,16,15,16,16,16,16,15,
15,15,15,5,5,3,5,5,5,15,5,15,5,16,15,3,3,3,3,5,3,3,
15,12,16,11,5,3,4,3,5,15,5,16,5,15,5,15,15,15,15,3,15,
5,5,5,11,11,15,11,11,15,11,11,5,5,15,5,15,5,16,5,15,15,
15,15,15,15,15,5,5,11,11,11,15,11,15,5,11,5,11,15,16,3,
15,5,15,15,3,15,3,16,12,5,5,12,13,12,12,16,15,11,15,5,
11,3,5,15,5,5,5,15,15,5,16,5,5,5,15,15,11,11,15,15,11,
5,11,5,5,16,3,15,15,15,7,3,3,3,5,5,3,4,15,11,12,16,3,
15,3,3,15,5,5,5,16,15,5,16,5,5,5,15,15,11,11,15,15,5,
5,5,5,16,16,15,15,7,15,15,7,15,15,15,16,15,15,15,16,16,
15,15,16,5,5,15,16,5,15,3,5,5,11,15,11,11,11,15,15,5,5,
15,5,15,15,12,15,5,5,5,12,12,15,13,12,16,5,11,5,5,15,
15,12,3,5,5,11,12,12,13,15,12,15,5,11,15,5,15,15,7,15,
16,15,16,15,15,15,16,15,15,15,15,15,15,16,16,15,15,15,16,
15,15,15,16,16,15,15,15,3,5,3,4,11,12,4,15,3,15,3,3,5,
5,3,4,3,3,15,16,15,16,16,15,15,16,15,3,3,12,4,11,15,3,
15,3,5,5,3,5,13,12,13,11,11,11,5,11,11,10,12,12,13,11,
11,11,5,11,10,10,3,15,15,11,15,12,11,11,11,15,15,3,15,
13,11,11,11,11,15,15,12,11,11,11,15,15,11,13,12,12,15,11,
12,13,12,11,12,12,13,10,10,11,5,5,5,5,5,5,5,3,3,15,15,
5,15,5,5,5,5,15,5,15,15,5,15,5,15,15,5,15,5,15,16,5,5,
15,3,15,3,5,5,15,15,15,5,5,15,3,5,5,15,3,3,3,12,12,3,
3,3,12,12,12,12,5,5,5,5,7,5,15,15,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,15,5,5,5,5,15,5,5,15,15,3,3,5,5,15,5,
15,5,5,5,15,15,5,15,15,15,3,11,11,5,5,5,11,11,11,11,15,
15,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,
5,5,5,15,5,15,15,15,5,5,5,5,15,5,5,5,15,5,5,15,15,15,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,7,3,3,15,16,5,16,5,15,
15,5,15,5,5,15,5,15,5,15,15,15,15,5,15,15,5,5,3,3,3,
15,15,5,5,15,15,5,15,15,3,5,15,3,3,3,3,12,12,5,5,5,12,
12,12,12,3,3,3,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,15,5,5,5,5,15,5,5,15,15,3,3,5,5,15,5,15,5,5,5,15,
15,5,15,15,15,3,11,11,5,5,5,11,11,11,11,15,15,3,5,15,
15,5,5,5,15,15,5,15,5,15,15,5,5,5,15,3,15,15,5,5,15,5,
3,15,15,3,3,15,5,15,15,3,5,5,5,5,5,15,3,15,15,3,3,3,
12,12,12,3,3,15,15,12,12,12,15,15,5,5,5,15,15,5,15,5,
15,15,5,5,5,15,3,15,15,5,5,15,5,3,15,15,3,3,15,5,15,
15,3,5,5,5,5,5,15,3,15,15,3,3,3,12,12,12,3,3,15,15,12,
12,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,15,
5,5,15,15,5,15,5,5,5,5,5,5,5,5,15,5,15,15,15,15,15,11,
5,11,11,11,5,11,11,11,5,5,11,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,16,15,5,5,5,15,5,15,16,15,15,15,5,5,5,5,15,5,5,5,
15,5,15,15,15,15,15,11,11,11,11,11,11,11,5,5,5,11,11,5,
5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,15,5,5,15,15,5,
5,5,5,5,5,5,5,5,5,5,5,15,16,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,16,5,15,
15,15,15,5,5,5,5,5,5,5,15,5,5,15,5,15,15,15,15,5,11,
11,11,11,11,5,11,11,11,11,11,5,5,5,5,5,5,5,5,5,5,5,15,
5,5,5,5,15,5,15,16,15,5,5,5,5,5,5,5,5,5,5,5,5,5,16,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
15,5,5,5,5,15,5,5,15,15,15,15,5,5,5,5,15,5,5,5,15,15,
15,15,15,5,5,12,12,15,12,12,12,12,5,5,5,11,11,5,5,5,5,
5,5,5,5,5,15,5,5,5,5,15,5,5,15,15,5,15,5,5,15,5,15,5,
15,5,16,5,5,15,15,15,15,11,5,11,11,11,5,11,11,11,11,11,
5,5,5,5,5,5,5,5,5,15,5,5,5,5,15,5,5,15,16,5,5,5,5,5,
5,5,5,15,5,15,15,5,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,15,5,5,5,5,15,5,15,15,15,15,15,5,5,15,
5,15,5,5,5,15,5,5,15,15,15,15,5,12,12,5,15,12,5,12,12,
11,11,11,5,5,5,5,5,5,16,5,5,5,5,16,5,5,16,16,5,5,5,5,
5,5,5,5,5,5,15,15,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,15,15,5,5,5,15,5,5,15,3,5,3,5,5,5,5,5,5,
5,5,5,5,15,15,5,15,15,3,5,11,11,5,5,3,5,5,11,5,11,5,
5,5,5,15,15,5,5,5,15,5,5,3,3,5,3,5,5,5,5,5,5,5,5,5,
5,15,15,15,15,15,15,5,11,11,5,5,15,5,5,11,11,5,5,5,5,
3,5,5,5,5,15,5,5,16,16,5,5,5,5,5,5,5,5,5,5,15,5,5,3,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,5,5,15,5,
15,15,15,3,5,5,5,5,5,5,5,5,5,5,15,5,15,5,15,5,5,15,
11,5,11,15,5,5,5,5,11,11,5,15,15,5,5,5,15,5,15,15,15,
5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,3,5,5,5,5,15,5,15,15,15,3,5,5,5,5,5,5,5,5,5,
5,15,5,15,15,5,15,5,3,5,11,11,3,5,5,5,5,11,11,15,15,
16,15,16,7,15,15,3,3,15,15,15,15,15,15,15,15,15,3,3,15,
3,3,4,3,15,16,15,15,15,16,15,15,15,15,15,15,5,5,15,15,
5,3,15,3,5,3,5,5,5,5,5,5,5,5,5,5,5,15,15,15,15,12,5,
15,15,5,5,12,5,5,5,5,5,5,5,16,5,15,15,15,3,5,5,5,5,5,
5,5,5,5,5,5,5,15,15,5,15,5,15,11,5,11,15,5,5,5,11,5,
11,5,16,5,5,15,3,5,5,5,5,5,5,5,5,5,5,3,5,5,3,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,15,3,5,3,5,5,5,5,5,
5,5,5,5,5,5,15,15,15,5,15,5,5,11,11,5,15,5,5,11,11,5,
7,15,16,7,3,15,15,15,15,15,15,15,15,15,15,15,15,16,15,
15,15,15,16,15,15,15,16,15,15,15,15,15,15,5,7,7,5,5,5,
5,5,5,5,5,5,5,7,5,5,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,15,15,15,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,12,15,
5,15,12,5,5,5,5,5,5,16,15,3,15,15,15,15,15,15,15,15,3,
15,3,3,15,15,15,3,15,15,15,15,15,3,15,15,15,15,15,15,3,
15,15,15,15,15,15,15,15,3,15,3,3,3,3,4,3,15,15,15,15,
15,3,15,15,15,15,15,5,5,5,5,5,5,5,5,5,5,15,5,15,3,3,
3,5,7,15,3,15,7,5,5,5,3,3,3,5,5,5,5,5,5,5,5,5,5,15,
15,3,3,3,7,5,3,3,3,5,7,5,5,3,3,3,5,15,5,3,5,15,5,3,
5,5,3,15,15,5,5,5,5,11,11,5,5,15,15,11,11,5,5,5,5,5,
15,5,5,15,5,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,
15,5,15,3,5,3,3,15,15,15,5,5,5,5,5,5,5,12,12,15,15,5,
3,5,15,5,15,5,5,3,15,15,15,5,5,11,11,5,5,5,15,15,11,
11,5,5,3,3,3,5,5,3,3,3,3,5,5,3,3,3,5,5,7,7,15,15,3,
5,5,5,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,3,15,
5,3,15,15,15,5,5,5,15,15,5,5,12,12,5,5,5,15,5,5,16,5,
15,15,5,5,11,11,5,5,5,3,3,11,5,11,5,5,7,13,12,12,5,5,
11,12,13,5,5,3,3,13,11,12,5,15,15,15,5,5,12,5,5,5,12,
5,5,5,15,15,15,15,5,15,15,12,5,15,15,15,5,12,5,5,5,5,
5,15,3,15,15,15,15,15,15,15,15,3,3,15,15,15,5,5,3,3,5,
15,15,3,3,15,15,15,15,5,5,3,3,15,15,5,3,3,15,15,15,15,
5,3,3,15,15,5,3,3,3,3,15,5,15,5,11,12,12,5,5,5,5,12,
12,11,12,11,11,5,5,5,5,12,11,12,5,5,12,11,11,11,5,5,5,
5,11,12,12,12,5,5,5,11,12,12,12,5,5,5,5,5,5,12,11,12,
5,5,12,12,11,5,11,12,11,11,12,11,5,5,5,15,15,5,3,3,15,
5,5,15,5,5,5,15,5,5,15,5,5,5,5,5,5,5,15,5,5,15,5,5,
5,15,15,3,5,15,15,15,15,5,15,5,15,15,15,5,3,3,3,11,11,
3,3,15,12,13,13,11,11,11,11,5,3,3,3,15,5,5,15,5,15,15,
5,15,5,15,15,5,5,5,15,5,5,15,5,5,15,5,15,3,3,15,3,15,
5,15,15,15,5,15,5,15,15,3,5,3,3,3,12,12,3,3,15,12,12,
12,12,15,3,3,3,3,3,15,5,5,15,5,15,15,5,15,5,15,15,5,5,
5,15,5,5,15,5,5,15,5,15,3,3,15,3,15,5,15,15,15,5,15,5,
15,15,3,5,3,3,3,12,12,3,3,15,12,12,12,12,15,3,3,3,3,
15,5,5,15,15,5,5,15,5,5,15,5,5,5,15,5,5,15,15,5,5,15,
5,15,5,15,15,3,5,5,15,15,15,5,5,5,5,5,5,5,3,3,3,12,
13,3,3,15,11,11,11,13,11,11,11,3,1,1,1,1,3,3,1,1,4,1,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,7,4,3,3,4,4,4,3,3,
3,3,3,3,3,4,7,4,3,3,4,4,7,4,7,4,3,3,3,3,1,3,1,1,3,
1,1,1,1,3,1,1,1,1,1,1,3,1,1,1,1,1,1,1,3,1,4,3,1,1,
3,1,7,1,3,1,1,1,1,1,7,4,3,3,7,7,3,7,3,3,3,7,3,3,3,
15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,
15,15,15,15,15,15,16,16,15,15,15,16,16,15,15,16,15,15,15,
16,4,3,1,16,16,1,1,16,16,16,16,15,15,15,15,15,15,15,15,
15,5,5,15,15,5,15,5,5,5,15,5,15,15,5,15,15,5,15,15,13,
14,5,5,5,15,15,15,15,15,5,5,16,15,4,3,1,16,13,1,3,4,
15,13,12,12,5,5,11,15,5,15,5,5,5,5,15,15,5,5,5,5,15,
15,15,5,15,15,5,5,15,15,13,15,5,5,15,16,16,5,15,15,15,
5,15,15,3,3,1,12,12,1,3,16,13,12,13,13,15,15,15,15,15,
15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,15,15,15,
16,16,16,15,15,15,16,16,15,15,15,15,16,15,15,3,3,1,16,
15,1,1,16,16,16,15,16,15,16,15,15,15,5,15,5,16,5,5,15,
5,15,15,5,15,5,5,16,5,15,15,15,15,13,5,5,5,16,14,5,5,
15,5,5,5,5,3,3,1,13,13,1,1,3,12,13,13,12,15,5,15,5,5,
15,5,15,5,5,5,15,5,15,15,15,5,5,16,15,15,15,16,16,16,5,
5,5,16,14,5,5,5,5,5,5,5,3,4,1,12,13,1,3,16,12,13,16,
13,5,5,11,15,15,5,15,5,15,5,5,5,5,5,15,5,5,15,5,5,16,
15,13,16,15,15,15,15,16,15,15,15,15,15,15,15,4,4,1,16,
13,4,1,15,16,16,13,13,12,5,5,5,5,15,5,5,5,5,15,5,5,15,
5,15,16,5,5,15,16,16,16,15,5,5,15,16,5,15,15,15,15,15,
5,3,3,1,13,12,3,1,16,12,12,12,12,15,5,5,15,15,5,5,5,
15,5,15,5,15,5,5,16,15,5,5,15,16,16,5,5,15,16,14,5,15,
5,5,5,15,15,3,4,1,12,13,4,4,16,16,13,16,14,12,12,5,15,
15,5,15,5,5,16,5,15,5,15,16,5,5,16,16,16,15,15,5,15,15,
16,5,5,15,15,15,15,15,3,3,1,13,13,16,16,16,13,13,13,13,
5,5,5,15,15,15,15,15,15,15,15,15,15,16,15,15,15,15,15,3,
15,15,15,15,15,15,15,15,15,15,16,16,3,3,3,16,15,3,3,15,
15,16,15,15,15,15,16,15,5,5,5,5,5,15,5,5,15,5,5,3,3,
12,3,5,5,5,15,13,15,15,15,5,5,16,16,3,3,3,13,11,3,3,
15,11,13,12,12,5,11,5,5,5,5,3,5,15,5,5,15,5,5,3,3,11,
15,5,5,15,15,15,5,5,15,5,5,5,16,3,3,3,12,11,3,3,15,11,
12,12,12,5,5,5,5,5,15,5,15,15,5,15,5,5,5,15,3,12,15,
15,5,15,13,5,5,5,16,16,5,5,3,3,3,11,13,3,3,3,12,11,12,
13,5,11,5,15,5,15,15,5,15,15,5,15,5,15,15,15,5,5,5,15,
11,5,5,5,5,5,5,5,3,3,3,12,12,3,3,15,12,12,11,11,15,5,
15,5,5,15,5,15,16,15,15,5,15,3,13,5,5,5,15,11,5,5,5,5,
5,5,5,3,3,3,12,13,3,3,3,13,13,11,11,5,5,11,5,15,15,5,
15,5,5,15,15,3,12,3,3,5,3,15,15,3,3,3,3,15,3,3,3,3,
11,16,4,3,3,12,13,3,3,5,11,5,15,5,15,15,5,15,5,15,11,
12,5,5,5,15,11,5,5,5,5,5,5,5,3,3,3,12,11,15,15,15,11,
12,11,11,15,5,5,15,15,15,15,15,15,15,16,15,15,15,15,15,
15,15,15,15,15,15,15,15,7,3,3,15,16,3,3,16,16,15,15,15,
16,15,15,5,15,5,5,15,3,15,11,15,5,5,15,15,5,5,5,16,15,
5,5,3,3,3,11,12,3,3,3,12,11,12,12,5,5,5,15,15,5,5,16,
13,16,5,5,5,15,12,5,5,5,5,5,5,5,3,3,3,13,13,3,3,16,
12,12,11,11,11,5,5,16,15,15,16,16,16,15,15,15,15,15,15,
15,15,15,15,15,15,4,3,3,15,16,3,3,16,16,15,15,15,16,15,
15,5,5,16,15,15,5,5,5,15,11,5,5,5,5,5,5,5,3,3,3,12,
12,3,3,3,12,12,11,11,5,5,5,5,15,12,11,5,5,5,15,11,5,5,
5,5,5,5,5,3,3,3,11,12,15,15,15,12,11,11,11,5,5,15,3,
12,3,3,5,3,3,15,3,15,3,3,3,3,3,3,3,3,12,13,4,3,3,11,
16,4,4,5,11,5,15,4,3,15,3,1,15,3,15,3,3,3,3,3,3,3,4,
16,15,3,3,3,15,16,4,4,15,15,16,15,13,15,12,15,15,11,12,
11,16,16,11,11,4,3,3,12,4,3,3,16,16,13,13,12,15,15,15,
12,11,3,15,15,15,15,13,12,12,16,16,3,3,3,3,13,3,3,16,
12,16,12,13,3,3,3,15,15,15,16,5,15,5,15,5,5,5,3,3,3,
11,12,3,3,16,12,11,13,13,11,5,5,5,15,15,5,15,5,15,15,5,
5,3,3,3,11,12,3,3,15,12,11,12,12,15,15,5,3,16,3,15,3,
15,15,3,3,3,3,3,13,11,3,3,15,12,13,15,3,15,11,5,7,15,
3,15,15,15,15,15,3,7,3,15,15,7,3,15,15,15,16,16,15,16,
15,15,16,3,16,15,15,3,3,7,3,13,13,7,3,16,12,12,16,7,15,
15,15,5,15,5,5,15,16,3,3,3,12,11,16,16,15,11,12,12,12,
5,5,5,3,15,15,5,3,3,3,3,12,11,16,16,15,11,12,15,3,15,
5,5,5,5,15,15,3,3,3,13,11,3,3,15,11,12,12,13,5,5,11,
15,5,5,3,3,3,11,16,3,3,15,15,11,16,13,12,5,5,5,5,3,3,
3,11,16,3,3,16,15,11,13,13,15,15,5,16,3,3,3,16,11,16,
16,15,11,16,13,13,5,15,15,3,3,3,16,11,3,7,15,11,15,16,
13,5,5,12,3,3,4,4,3,3,7,2,4,4,4,3,3,3,3,4,4,7,3,3,
4,4,4,2,3,3,3,3,4,3,3,3,4,2,4,4,3,3,3,12,4,3,15,12,
12,12,12,12,11,12,4,4,3,12,11,12,12,12,11,11,3,3,4,4,3,
3,3,3,3,3,4,3,4,4,3,3,3,16,16,16,16,15,15,15,12,12,11,
12,11,11,12,12,11,11,12,12,11,11,12,12,12,11,5,5,5,15,5,
7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,5,5,5,15,5,
15,15,5,15,3,5,5,15,5,15,5,15,5,15,15,1,15,15,3,3,5,5,
11,11,11,15,3,15,5,11,11,11,7,15,3,16,16,16,15,3,3,16,
16,3,16,15,15,15,15,15,16,15,15,16,3,3,16,7,15,3,3,16,
7,15,15,15,3,16,16,16,3,16,16,3,3,16,3,7,16,15,15,15,
15,16,7,16,3,16,7,7,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,15,5,5,5,5,15,5,5,15,15,3,3,5,5,15,5,15,5,5,5,
15,15,5,15,15,15,3,11,11,5,5,5,11,11,11,11,15,15,3,15,
16,15,16,3,15,3,15,3,16,16,15,16,15,15,15,15,15,16,3,15,
3,16,16,3,15,3,3,7,15,3,16,16,16,7,3,3,15,3,3,16,16,
16,7,15,15,16,16,3,7,7,16,15,16,16,7,15,5,5,5,15,15,15,
15,15,5,15,5,5,5,5,5,5,15,15,15,5,5,5,15,5,5,3,3,5,5,
15,15,3,5,5,5,15,15,5,5,15,15,3,3,3,11,11,11,11,11,11,
15,13,12,13,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,
5,15,5,5,5,15,5,15,5,5,15,5,15,5,5,5,15,15,15,15,16,5,
15,11,5,5,11,5,11,12,11,5,11,11,12,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,15,5,5,5,5,5,5,15,15,15,15,15,5,5,15,5,16,
5,5,5,15,15,15,5,15,15,15,5,11,11,5,5,12,13,11,5,11,12,
13,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,5,5,
15,15,5,5,15,5,16,5,5,5,15,15,15,15,15,15,16,5,11,5,11,
5,12,13,12,5,12,13,15,5,5,5,5,5,5,5,5,5,5,5,5,15,15,
5,5,5,15,5,15,5,5,15,15,5,5,15,5,15,5,15,5,15,15,5,5,
15,15,16,5,5,5,5,11,13,11,12,11,12,13,11,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,15,15,5,5,15,5,16,5,
5,5,15,15,15,5,15,15,15,5,5,11,5,5,13,15,12,11,13,15,
13,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,5,5,5,5,15,15,15,
5,5,15,5,16,5,5,5,15,15,15,15,16,5,16,5,11,11,5,5,12,
15,13,5,13,13,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,15,5,16,5,5,15,5,15,5,15,5,15,15,5,15,15,5,15,5,5,5,
5,5,11,11,13,5,13,11,11,5,5,5,5,5,5,5,5,5,15,5,5,5,
15,5,15,5,15,15,16,5,5,15,5,16,5,15,5,15,16,5,15,15,15,
16,5,5,5,5,11,15,13,13,5,15,13,12,5,5,5,5,5,5,5,15,5,
5,5,5,5,5,15,15,5,5,16,5,5,15,5,16,5,5,5,15,15,5,5,
15,15,16,5,5,5,5,11,15,12,12,11,13,15,12,5,5,5,5,5,5,
15,15,5,5,5,15,5,15,15,15,5,16,5,5,15,5,16,5,5,5,15,
15,15,15,16,5,16,5,5,5,5,5,16,16,15,5,19,16,16,5,5,5,
5,5,5,15,5,5,5,5,5,5,5,15,5,1,5,5,15,5,15,5,5,5,15,
15,5,5,15,5,1,11,5,5,11,5,11,11,11,5,11,11,11,5,5,5,5,
15,15,5,5,5,5,5,15,3,5,5,3,5,5,15,5,15,5,5,5,15,15,3,
5,15,3,15,11,5,11,5,5,11,3,11,5,11,3,11,5,5,5,16,5,5,
5,5,5,5,5,5,5,15,15,5,5,15,5,15,5,5,5,15,15,5,3,15,3,
3,11,11,5,5,5,11,11,11,5,11,3,3,5,5,15,5,5,5,5,5,5,5,
5,5,3,15,5,5,15,5,15,5,5,5,15,15,5,5,15,3,15,5,11,11,
5,5,11,11,11,5,11,11,11,5,5,16,5,5,5,5,5,3,15,5,3,3,
5,5,15,5,15,5,5,5,15,15,15,5,15,15,15,5,5,11,11,5,3,3,
11,5,11,11,11,15,15,5,5,5,5,5,5,5,5,3,15,5,5,15,5,15,
5,5,5,15,15,5,15,15,5,3,5,11,5,11,5,3,11,11,5,11,11,3,
15,5,5,5,5,5,5,5,5,3,16,5,5,15,5,15,5,5,5,15,3,5,3,
15,4,3,5,16,11,5,5,13,16,12,5,12,19,15,5,5,5,5,5,3,16,
3,3,4,5,5,15,5,15,5,5,5,15,15,5,5,15,15,3,11,5,5,16,
5,16,16,12,5,12,12,13,5,5,15,5,15,5,5,15,15,5,5,15,5,
15,5,15,5,15,15,5,5,3,5,15,5,11,5,5,11,15,11,11,5,15,
11,11,5,5,5,5,15,5,15,15,5,5,15,5,15,5,5,5,16,15,5,5,
15,15,15,5,11,5,5,5,11,11,11,11,15,15,11,5,5,5,5,15,5,
1,5,5,15,5,16,5,5,5,15,15,15,15,1,5,16,11,5,5,5,11,11,
15,15,5,15,11,15,3,15,5,3,15,15,5,15,15,5,15,5,5,5,15,
15,5,5,16,5,15,5,5,5,5,11,16,11,13,5,15,16,11,5,5,16,
5,16,5,5,15,5,16,5,5,5,15,15,15,15,16,5,16,5,5,5,5,5,
11,15,15,5,15,11,15,5,5,16,3,5,15,15,5,15,5,15,5,15,15,
15,5,3,12,16,5,11,11,5,15,15,16,12,5,12,13,16,5,5,3,5,
5,15,15,15,5,5,5,3,15,3,5,15,13,16,5,5,11,5,5,13,15,
12,15,12,15,16,5,3,5,5,15,5,16,15,5,15,15,15,5,5,3,5,
4,16,5,5,11,5,12,13,12,15,16,12,19,3,5,15,15,5,15,5,15,
5,15,16,5,15,3,3,3,5,3,3,3,15,16,11,12,5,15,3,3,15,15,
16,15,16,16,15,16,16,16,16,16,1,3,1,3,15,3,4,3,16,7,16,
15,16,16,16,5,15,5,15,5,5,5,15,15,5,5,15,5,15,5,5,5,5,
11,11,11,11,11,11,11,11,15,5,15,5,15,5,15,16,5,5,15,15,
15,5,5,11,5,11,15,11,15,5,11,11,11,15,16,16,15,15,15,15,
3,16,6,15,15,15,15,15,15,15,15,15,16,16,16,15,15,3,5,5,
5,15,15,5,5,15,16,15,5,5,11,5,5,11,11,15,11,11,15,11,
16,15,1,6,16,3,3,15,3,1,15,15,15,15,15,16,16,16,3,16,
15,16,5,5,15,15,15,15,16,5,16,5,5,5,5,5,11,15,15,5,15,
11,15,3,15,15,15,3,16,5,3,5,5,5,15,11,15,11,15,11,13,
16,11,15,15,15,15,16,5,1,5,5,5,11,5,11,15,15,11,15,11,
15,15,15,15,16,15,16,15,15,15,15,16,15,15,16,16,16,15,15,
15,15,16,3,15,15,15,15,15,15,16,15,15,15,15,16,15,5,16,
3,16,11,5,15,11,5,12,15,16,5,12,12,13,16,5,16,5,15,5,
11,5,12,13,16,5,12,12,15,15,16,15,15,15,15,3,16,16,16,
15,16,16,16,3,3,3,3,5,5,3,3,15,15,12,16,11,4,3,15,3,
15,16,16,16,3,16,16,7,5,10,11,11,11,11,11,5,12,13,13,11,
10,10,11,11,11,5,13,13,12,5,5,13,12,13,10,11,11,11,5,13,
13,12,11,11,11,11,12,12,13,11,11,11,11,3,15,11,15,11,3,
15,11,15,3,11,11,11,15,15,13,12,12,15,15,3,3,3,3,15,5,
5,15,5,15,15,5,15,5,15,15,5,5,5,15,5,5,15,5,5,15,5,15,
3,3,15,3,15,5,15,15,15,5,15,5,15,15,3,5,3,3,3,12,12,3,
3,15,12,12,12,12,15,3,3,5,7,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,15,15,5,5,5,5,5,15,5,15,3,3,5,5,15,5,3,5,15,
5,5,15,15,5,3,15,3,3,15,11,11,11,5,5,5,15,11,11,11,5,
5,15,5,15,5,15,15,5,5,5,5,15,5,15,5,15,5,3,15,5,15,5,
5,15,5,15,3,3,15,5,16,15,3,5,15,15,5,15,3,5,15,3,15,5,
5,12,12,12,3,3,3,5,12,12,12,15,16,5,16,5,15,15,5,15,5,
15,15,5,15,5,15,5,3,15,5,15,15,5,3,5,5,3,3,5,5,15,15,
3,5,15,15,15,15,15,15,15,15,3,3,3,12,12,12,5,5,5,3,12,
12,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,5,5,5,
15,5,15,15,15,5,5,15,5,15,5,15,5,5,15,15,15,15,5,15,11,
11,5,11,11,11,11,11,5,11,5,11,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,15,5,5,5,5,5,5,15,15,5,15,15,5,5,15,5,15,5,15,
5,5,15,16,15,5,15,5,11,11,11,11,5,11,11,11,11,5,11,11,
5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,16,5,5,5,
5,5,5,16,5,5,5,16,5,5,15,16,15,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,15,5,
16,15,5,15,15,5,5,15,5,15,5,15,5,15,16,15,5,15,15,15,5,
11,11,5,11,11,11,11,11,11,11,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,16,15,5,5,5,5,5,16,5,5,5,16,5,5,15,15,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,15,5,5,5,5,5,15,15,15,15,15,5,5,15,5,15,5,15,5,5,
15,15,5,15,15,15,11,11,12,12,5,12,15,5,11,5,12,12,5,5,
5,5,5,5,5,5,5,5,15,5,5,5,15,5,15,5,5,15,15,5,5,16,5,
15,5,15,5,15,15,15,5,15,5,5,5,5,5,11,11,11,11,11,11,11,
5,11,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,15,5,5,5,5,5,5,
15,5,5,5,16,5,15,16,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,15,15,5,5,5,15,5,15,5,5,5,15,5,5,
15,5,5,5,15,5,5,15,15,5,15,15,15,5,11,12,5,12,15,12,12,
11,12,12,5,5,5,5,5,5,5,15,15,5,5,5,15,5,16,5,5,5,5,5,
5,16,5,5,5,16,5,5,16,16,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,3,5,5,5,5,5,15,5,15,15,15,5,5,15,5,
5,5,15,5,5,15,15,15,5,5,3,11,11,5,3,5,5,11,11,5,5,5,
3,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,15,5,5,15,5,15,5,
15,5,5,15,3,5,5,3,5,11,5,3,5,5,11,11,5,11,5,3,5,5,5,
5,15,5,5,5,5,5,5,15,5,5,5,5,5,5,15,5,5,5,15,5,5,15,
15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,
5,5,15,15,5,15,5,5,5,15,5,5,5,15,5,5,3,3,5,5,3,5,5,
11,15,5,5,11,11,5,11,5,15,5,5,5,15,5,5,5,5,5,3,5,5,5,
5,5,5,15,5,5,5,15,5,5,16,16,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,3,5,5,5,5,5,15,5,15,15,15,5,5,15,5,15,5,15,
5,5,15,15,15,5,5,3,11,11,5,15,5,11,5,11,5,5,5,15,5,5,
5,5,5,5,15,5,5,15,15,5,5,15,15,5,5,15,5,5,3,3,3,5,15,
5,15,15,12,5,5,5,5,5,15,5,12,5,5,5,5,5,5,3,5,3,12,13,
5,3,15,5,12,7,7,3,5,3,3,3,5,5,3,13,11,5,3,5,11,13,12,
12,5,5,3,5,5,15,5,16,5,5,15,15,5,5,15,5,15,5,15,5,15,
15,15,5,3,5,5,11,11,5,5,15,11,5,11,5,15,5,5,5,5,5,15,
15,5,5,5,5,5,15,5,5,5,15,5,15,15,15,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,3,5,5,15,15,5,5,15,5,5,5,15,5,
15,15,15,5,3,5,5,11,11,5,5,3,5,11,11,5,3,5,5,15,16,5,
3,15,5,15,5,15,5,15,5,15,5,5,15,15,5,15,5,5,5,5,5,5,
12,15,15,15,5,12,5,5,15,5,15,5,5,5,5,15,5,5,5,15,5,5,
15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,15,3,15,
16,16,15,15,7,16,15,15,15,3,15,3,15,15,15,15,15,15,16,
15,15,15,15,16,15,15,5,5,15,5,5,15,15,5,5,15,5,3,15,3,
5,5,3,5,5,5,12,5,5,15,15,5,5,5,12,5,15,15,5,5,15,5,
15,5,15,15,5,15,15,5,5,5,3,15,15,5,12,5,5,5,5,5,5,5,
12,5,15,5,15,5,5,5,15,15,15,15,15,15,3,3,3,15,15,3,3,
15,15,5,15,5,15,3,3,5,5,15,15,5,5,15,5,15,15,15,15,3,
3,3,15,15,3,3,3,5,15,15,5,3,3,3,5,16,5,15,5,15,5,15,
15,15,5,3,5,5,11,5,5,5,15,11,5,11,11,15,5,5,16,5,5,5,
15,5,5,15,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,7,
15,15,15,16,7,15,3,15,15,15,15,15,15,16,15,15,15,15,16,
15,15,15,5,15,5,5,15,3,5,5,3,5,5,11,15,5,5,5,11,11,11,
5,15,5,5,15,15,15,15,3,15,3,3,3,15,5,3,3,15,15,5,15,
15,15,3,3,7,5,5,7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,3,15,15,3,3,15,15,3,15,15,15,3,15,15,15,15,15,15,15,
3,5,15,15,15,5,5,3,11,5,5,15,5,11,5,11,11,5,5,15,15,
15,5,15,5,5,5,5,5,5,12,15,5,15,5,12,5,5,16,15,15,3,15,
15,15,3,15,15,15,15,15,15,15,3,15,15,15,3,15,15,15,3,15,
15,15,15,15,15,15,3,15,5,5,15,5,5,5,12,5,5,15,15,5,5,
5,12,5,5,3,3,5,5,7,15,3,15,3,7,5,5,5,3,15,7,5,5,3,3,
3,15,5,7,5,3,3,5,7,5,3,3,3,3,5,5,7,5,11,12,12,5,5,5,
5,12,11,12,12,11,11,5,5,5,5,11,12,11,5,5,11,12,12,11,5,
5,5,5,12,11,12,12,5,5,5,12,11,11,12,5,5,5,5,5,5,12,11,
12,5,5,11,12,11,5,11,12,12,12,11,12,5,5,5,3,7,3,1,3,4,
1,1,3,1,1,16,3,1,3,3,1,1,3,3,3,1,1,3,7,3,1,7,3,4,1,
1,15,1,4,15,3,3,1,16,1,7,3,7,3,4,3,1,1,1,3,3,3,4,7,
7,3,3,16,15,15,4,3,1,16,1,1,3,15,15,16,15,15,15,16,15,
1,1,1,1,1,3,1,3,4,7,15,1,15,1,16,1,1,1,16,3,1,3,16,
4,7,16,16,16,16,3,7,7,16,3,16,7,7,1,3,3,4,1,1,1,3,1,
1,3,3,3,3,3,3,3,3,4,3,3,4,3,3,3,3,7,4,3,3,3,3,4,3,
4,3,3,3,3,4,4,7,4,4,4,3,3,3,3,3,3,7,4,4,7,15,15,15,
15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,
15,16,15,16,16,16,15,15,15,16,15,15,15,16,15,15,16,15,4,
3,15,16,15,16,15,16,15,16,15,16,4,4,15,5,5,15,15,15,15,
5,5,15,5,15,15,15,15,15,5,5,5,5,5,5,16,15,16,16,15,5,
5,5,16,5,5,5,15,5,15,15,15,7,4,15,13,12,5,5,13,12,16,
13,16,4,1,15,5,15,15,5,15,5,5,15,5,15,5,15,15,15,5,5,
5,5,5,5,16,5,14,14,15,5,5,15,16,5,5,15,15,5,16,16,16,
3,3,12,12,15,5,15,12,12,13,12,16,1,3,5,15,15,15,15,5,5,
15,15,5,5,15,5,5,15,5,5,15,15,15,16,5,16,14,15,15,5,5,
13,5,15,15,15,15,5,15,1,4,4,16,12,5,11,12,13,12,16,13,
16,1,4,15,15,5,15,5,15,15,5,5,5,15,15,5,5,5,15,15,5,
15,15,15,14,15,15,5,5,15,14,5,5,5,16,5,15,5,1,3,3,12,
12,5,15,5,12,12,12,12,3,1,1,15,15,15,15,15,16,15,15,15,
16,15,15,15,15,15,15,15,15,16,16,16,16,16,15,15,15,16,15,
15,15,16,15,15,15,1,4,7,15,16,16,15,15,16,16,16,16,4,1,
1,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,
15,16,16,15,15,15,15,16,15,15,16,16,15,16,15,16,4,4,16,
16,15,15,15,15,16,16,15,16,4,4,15,5,5,15,5,5,5,15,5,5,
15,5,15,15,5,5,16,5,16,14,15,5,5,5,16,5,15,15,16,15,15,
5,1,3,3,12,13,15,15,15,12,13,12,12,16,3,1,15,15,15,15,
15,15,15,15,15,15,15,15,15,15,15,16,15,16,16,16,15,15,15,
16,15,15,15,15,15,16,16,1,3,4,16,16,15,15,16,16,16,15,
16,4,1,1,5,15,5,15,5,15,15,15,15,5,15,15,5,5,16,15,14,
15,15,5,5,15,14,5,15,5,16,15,15,5,1,3,3,12,12,5,5,5,
12,12,12,12,16,16,16,15,15,15,15,15,16,16,5,5,5,5,5,5,
3,3,13,3,15,5,5,5,12,5,5,5,15,15,5,5,15,3,3,12,12,5,
11,5,13,13,11,11,15,3,3,15,15,15,15,15,15,15,15,15,15,
15,15,16,15,15,7,15,15,15,15,15,15,15,15,16,15,16,15,15,
7,3,16,15,16,15,15,15,16,15,15,16,7,3,15,5,15,16,15,5,
5,5,5,5,15,3,3,15,15,15,5,5,5,11,5,5,5,15,5,5,3,15,3,
3,12,12,5,5,5,12,12,11,11,15,3,3,15,15,15,5,5,5,5,5,5,
3,3,3,3,13,15,5,5,5,12,5,5,5,15,3,5,3,15,3,3,12,13,
11,5,5,13,13,11,11,15,3,3,15,15,15,5,5,5,5,5,3,3,3,3,
3,15,5,5,5,11,5,5,5,15,5,5,5,15,3,3,12,12,15,15,5,12,
12,11,11,15,3,3,15,15,15,15,15,15,15,3,1,3,3,15,15,15,
15,15,15,15,15,15,15,3,15,3,15,3,7,15,16,15,16,15,16,15,
15,15,15,3,3,15,5,5,5,5,5,3,3,3,3,19,15,5,5,5,12,5,5,
5,15,3,5,3,15,7,3,15,16,12,5,5,13,14,11,11,15,3,3,5,5,
5,5,5,3,3,3,3,3,15,5,5,5,12,5,5,5,15,3,3,3,15,3,3,
15,13,15,15,5,13,19,11,11,15,3,3,5,5,15,15,15,3,3,16,
11,15,15,5,5,13,5,5,15,15,15,5,3,3,3,3,11,13,5,5,11,
12,11,12,13,16,3,3,15,5,5,5,16,5,11,15,15,5,5,15,15,5,
5,5,16,5,15,5,3,3,3,12,11,5,5,5,11,12,12,12,3,3,3,5,
5,5,16,5,11,3,15,5,5,15,13,15,5,5,16,5,16,5,3,3,3,13,
11,5,5,11,11,13,12,12,3,3,3,16,15,3,3,15,12,15,15,5,5,
16,5,15,16,15,15,5,3,3,3,3,11,13,5,5,12,16,11,15,14,16,
3,3,5,3,15,15,11,15,5,5,5,15,5,15,15,15,5,5,15,3,3,3,
11,12,5,5,5,12,11,12,12,3,3,3,3,3,16,3,15,5,5,5,12,5,
15,5,15,15,5,5,3,3,3,12,3,5,12,15,15,13,12,11,15,3,3,
3,3,7,16,15,15,15,16,16,3,15,16,15,16,15,3,4,3,16,4,16,
15,15,15,16,16,15,3,7,3,15,3,15,5,5,5,16,5,3,5,15,15,
5,15,3,3,3,16,3,5,11,5,15,11,13,11,3,3,4,3,15,15,11,
12,15,11,16,13,15,16,12,15,3,3,4,13,3,3,3,15,16,12,12,
13,16,3,3,15,11,11,13,15,15,11,12,16,15,16,12,3,7,3,4,
12,4,3,3,13,7,13,12,3,7,3,15,15,15,16,15,15,15,15,15,
15,15,16,3,3,15,15,15,15,16,15,15,16,16,16,3,3,5,5,15,
5,15,15,15,15,5,3,3,3,3,11,12,5,15,15,12,11,12,12,15,3,
3,15,12,15,5,5,15,5,16,5,15,3,3,11,11,15,5,5,11,11,12,
12,15,15,15,3,15,5,5,16,5,5,5,3,3,3,13,11,11,5,5,11,
12,12,13,3,3,3,15,16,3,16,12,3,3,16,3,3,12,12,15,15,15,
13,13,16,4,16,3,3,5,5,16,5,16,5,3,3,3,12,11,5,5,5,11,
12,12,12,16,16,15,16,15,15,5,3,3,3,3,11,13,5,15,15,13,
11,15,19,16,3,3,15,5,5,15,3,3,3,11,12,5,11,5,13,11,13,
13,3,3,3,15,16,15,16,3,3,15,15,15,15,15,15,16,16,16,16,
3,3,5,3,3,3,3,12,3,5,5,15,15,12,11,11,15,16,16,5,3,3,
3,16,11,15,5,15,11,16,13,13,3,3,3,3,3,3,13,3,5,11,5,
15,11,15,12,3,3,4,3,3,15,15,15,15,3,4,4,16,2,16,3,3,3,
4,4,3,3,3,4,2,4,4,3,7,3,4,2,3,3,3,4,4,4,4,3,3,7,12,
12,11,11,12,12,12,12,16,3,4,11,11,11,12,11,12,12,16,4,3,
5,5,11,12,12,11,15,3,3,5,12,11,11,11,15,3,3,11,11,11,
12,15,3,3,12,12,11,15,4,3,12,12,4,3,4,12,16,4,4,3,4,4,
3,3,3,15,5,15,15,5,15,5,15,5,5,5,5,15,5,5,5,15,5,5,5,
15,5,5,5,5,15,15,3,3,15,5,15,5,3,5,5,5,15,5,15,5,15,
15,3,11,11,11,11,11,3,3,15,11,13,12,13,3,3,15,16,16,16,
16,3,16,16,16,3,15,3,16,15,16,16,15,15,15,15,16,16,16,
15,7,3,16,3,6,15,3,7,7,16,3,3,3,3,16,16,16,7,7,3,16,
16,15,15,15,16,16,16,16,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,15,5,5,5,5,5,15,5,15,15,15,5,5,5,5,15,5,5,5,15,5,
15,15,15,16,15,15,12,5,11,5,5,5,5,13,13,13,12,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,5,5,15,15,15,16,5,5,
5,5,5,15,5,15,5,5,15,15,15,15,16,5,12,15,11,5,5,5,11,
5,12,13,12,15,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,
5,5,5,15,5,15,15,5,5,5,5,15,5,5,5,5,15,15,15,15,16,15,
13,12,5,5,5,12,5,11,12,13,15,13,5,5,5,5,5,5,5,5,5,5,
5,5,15,5,5,5,5,15,5,15,15,5,16,15,5,5,15,5,5,5,15,5,
5,15,5,15,5,16,15,13,12,5,5,11,11,5,5,15,12,15,12,5,5,
5,5,5,5,5,5,5,5,5,5,15,5,5,5,15,5,15,15,15,16,15,5,5,
15,5,15,5,5,5,15,5,15,5,15,16,15,15,13,5,11,5,5,5,12,
12,15,13,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
15,15,5,5,5,5,15,5,5,5,5,5,5,5,15,15,5,11,13,11,5,5,
5,11,5,12,12,11,13,5,5,5,5,5,5,5,5,5,5,15,5,5,5,15,5,
5,15,5,16,15,5,5,15,5,15,5,15,5,15,5,5,5,15,16,15,13,
13,5,5,5,5,5,11,12,15,12,13,5,5,5,5,5,5,5,5,15,5,5,5,
5,15,5,15,5,5,16,15,5,5,5,5,15,5,15,5,15,15,5,5,15,15,
15,13,15,11,12,5,5,5,5,13,13,12,12,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,15,15,
15,12,11,5,5,11,11,5,5,13,11,13,11,5,5,5,5,5,5,15,15,
5,5,5,15,5,5,5,5,16,5,5,5,5,5,5,5,5,5,15,15,15,5,5,
16,5,15,13,5,5,5,5,5,5,13,15,13,13,5,5,5,5,5,5,16,5,
5,5,15,5,15,5,16,15,3,5,5,5,5,5,5,5,5,5,5,5,5,5,15,
3,3,11,5,11,5,5,11,5,11,11,11,3,5,5,5,5,5,5,5,5,5,5,
5,5,16,5,15,3,5,5,15,5,5,5,5,5,15,5,16,5,5,1,5,15,11,
11,5,5,5,11,5,15,15,15,11,5,5,5,16,5,5,5,5,5,5,5,5,5,
15,5,5,5,5,5,15,5,5,5,5,15,5,16,5,15,15,11,11,5,5,5,
11,5,11,11,11,15,15,5,5,16,5,5,5,5,5,5,5,5,5,3,5,5,5,
5,5,5,5,15,5,5,16,5,15,5,3,5,11,15,11,5,5,11,5,5,11,
11,15,11,5,5,16,5,5,5,5,5,16,5,15,3,3,5,5,5,5,5,5,5,
5,5,5,5,5,15,15,15,3,3,5,11,11,5,5,5,11,11,11,11,5,5,
5,5,5,5,5,5,5,5,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,3,
11,11,5,11,5,11,5,5,11,11,11,11,5,5,5,5,5,5,5,5,5,3,
5,5,15,5,5,15,5,5,5,5,16,5,16,5,16,5,11,16,11,5,5,15,
5,5,13,12,16,16,15,5,5,5,15,16,5,16,3,3,5,5,5,5,5,5,
5,5,5,5,5,5,15,15,3,16,16,5,15,13,5,11,5,12,13,12,12,
5,5,16,5,16,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,3,15,
5,15,15,5,5,11,11,5,5,11,15,11,15,5,5,5,5,16,5,15,15,
5,5,15,5,15,5,5,5,16,5,5,5,15,15,5,11,11,5,5,5,5,11,
11,11,15,15,11,5,5,5,5,5,15,3,5,5,5,5,5,5,5,5,5,5,5,
5,3,15,5,15,11,5,5,15,5,15,5,11,15,11,11,16,16,5,16,16,
15,5,5,5,5,5,5,5,5,5,5,5,5,4,15,3,13,12,5,5,11,15,11,
5,12,16,12,16,15,5,16,16,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
15,5,15,15,5,5,5,5,5,5,11,15,11,15,5,5,16,3,5,5,5,5,
5,5,5,5,5,5,5,5,3,15,15,16,16,5,13,15,11,5,5,12,12,12,
13,5,15,3,15,5,5,5,15,15,5,5,16,5,16,5,15,16,5,12,12,
11,5,5,5,15,13,13,16,16,12,16,3,5,5,5,5,5,5,5,5,5,5,
5,5,5,15,13,16,13,5,11,5,5,15,5,12,12,12,16,3,15,3,15,
15,3,15,3,15,15,15,15,16,3,1,3,16,3,3,4,15,16,15,15,15,
16,16,16,5,5,5,5,5,5,5,5,15,5,3,5,3,3,3,4,12,3,3,3,
5,3,5,11,15,15,3,5,16,5,3,5,5,5,16,5,15,5,16,15,5,11,
11,5,5,11,5,5,11,15,15,11,11,5,5,3,5,16,5,5,16,5,5,5,
15,15,11,15,11,11,5,5,5,5,15,11,11,11,5,13,16,5,5,16,5,
16,5,15,16,5,12,12,5,5,15,5,5,11,16,15,13,12,3,5,5,5,
5,5,5,5,5,15,5,11,11,11,5,5,5,5,11,11,11,11,11,5,3,3,
3,5,3,3,3,3,3,12,11,4,3,3,5,5,3,4,15,15,3,5,5,15,5,
16,5,5,16,5,15,11,5,5,5,5,5,5,15,15,15,11,16,5,16,5,
16,5,16,3,11,16,13,15,5,5,5,11,16,12,13,16,5,5,5,16,5,
15,16,11,11,5,11,5,5,5,11,15,11,11,15,5,5,5,3,3,5,13,
12,5,5,11,5,13,15,12,16,16,12,5,5,5,3,15,12,16,15,5,5,
11,5,5,16,11,15,13,5,15,3,5,16,12,15,5,11,5,11,5,16,13,
12,12,5,3,4,12,13,5,11,5,13,5,15,16,11,15,16,15,5,4,3,
5,5,3,3,3,15,15,16,11,12,15,15,15,3,15,15,15,15,15,16,
15,16,16,3,3,5,3,5,4,3,3,15,11,12,16,3,12,12,13,11,11,
11,15,15,15,3,12,13,12,11,11,11,15,15,15,11,5,5,10,10,
11,13,11,11,11,5,11,10,11,13,11,11,11,10,11,10,12,11,11,
11,5,5,11,12,12,13,5,11,13,12,12,11,12,13,12,15,11,15,
15,15,15,15,15,5,5,5,15,15,5,15,5,15,15,5,5,5,15,3,15,
15,5,5,15,5,3,15,15,3,3,15,5,15,15,3,5,5,5,5,5,15,3,
15,15,3,3,3,12,12,12,3,3,15,15,12,12,12,15,15,15,15,15,
15,5,5,5,15,15,15,5,5,15,15,15,5,5,5,16,15,16,5,15,4,
4,15,15,15,5,15,5,15,15,5,5,15,15,16,13,16,12,5,15,13,
16,4,4,16,5,16,13,13,15,15,15,15,15,15,15,15,15,15,15,
15,15,16,16,15,15,15,15,15,15,15,15,15,4,3,16,15,16,15,
15,15,15,15,15,16,15,15,16,16,16,15,16,16,16,16,1,1,16,
15,16,15,16,5,5,5,15,5,5,5,15,15,5,5,5,15,15,15,5,5,
15,15,5,15,5,5,3,3,15,5,16,15,15,5,5,15,5,5,16,15,16,
16,16,15,5,12,12,12,3,1,15,5,12,12,12,15,5,15,15,15,15,
5,15,5,5,15,15,5,5,5,5,5,16,15,15,5,5,3,4,15,15,15,5,
1,15,15,15,5,15,15,15,13,14,15,5,5,16,12,13,1,3,4,11,
15,13,12,15,15,5,15,5,5,15,5,15,5,16,5,5,5,5,5,5,5,15,
15,5,3,3,16,5,16,15,1,5,5,15,5,15,16,5,13,15,14,15,5,
12,13,12,1,3,16,15,13,12,12,15,5,15,15,5,15,5,5,5,16,5,
5,5,15,5,15,5,5,5,15,4,3,15,5,16,5,1,15,15,5,5,15,16,
15,16,16,13,12,12,16,16,13,3,1,4,5,13,14,14,15,15,15,15,
16,15,15,15,16,15,15,15,15,15,15,15,15,15,15,3,4,15,15,
16,15,15,15,16,16,15,15,15,15,16,16,16,15,15,16,15,16,1,
1,16,15,16,16,15,15,5,5,16,5,5,5,16,5,15,15,5,15,15,5,
15,5,15,3,3,15,5,16,5,1,5,15,15,15,15,15,15,15,13,16,
15,15,13,13,13,1,1,3,15,12,13,13,5,5,15,5,5,5,16,5,5,
5,15,5,5,5,15,15,5,4,3,15,5,16,5,1,15,5,5,15,15,16,5,
15,16,14,5,5,12,16,13,1,3,15,11,12,13,13,15,15,5,15,5,
15,15,15,15,5,15,15,5,16,5,15,3,3,15,5,16,5,1,5,15,15,
5,15,16,5,15,16,16,5,5,13,13,13,16,16,16,5,13,13,13,15,
15,15,15,15,5,15,5,5,5,5,5,3,5,3,3,3,15,5,15,5,15,5,
5,5,5,3,3,3,12,13,3,11,5,12,12,11,3,3,15,5,11,13,13,
15,15,15,15,15,15,15,15,15,15,15,15,15,15,3,7,15,15,16,
15,16,15,15,15,15,15,15,15,15,3,15,16,15,16,15,15,3,3,
15,15,15,16,15,15,5,15,15,15,5,5,5,5,5,5,5,5,3,3,15,5,
15,5,15,5,5,5,5,3,3,3,11,3,3,15,15,12,12,11,3,3,15,5,
11,12,12,15,15,16,16,5,5,5,5,5,5,5,5,3,3,15,5,15,5,15,
5,5,5,5,3,3,5,12,3,13,5,11,13,12,11,3,3,15,5,11,13,13,
15,15,16,5,5,5,5,5,3,5,5,3,3,15,5,15,5,15,5,5,5,5,3,
3,5,11,15,15,5,5,12,12,11,3,3,15,5,11,12,12,15,15,15,
15,15,15,15,15,15,15,7,3,15,15,15,15,16,15,15,15,15,15,
15,15,15,15,7,15,16,15,16,15,7,3,16,15,15,15,16,15,5,5,
5,5,5,3,5,3,3,3,15,5,15,5,15,5,5,5,5,3,3,3,12,3,3,
15,15,15,13,11,3,3,15,5,11,16,13,5,5,5,5,5,3,5,3,3,3,
15,5,15,5,15,5,5,5,5,3,3,3,12,16,3,12,5,15,16,11,3,3,
15,5,11,16,13,5,5,16,15,15,5,5,3,3,15,15,15,5,3,5,16,
15,5,5,15,15,3,12,13,5,11,11,13,13,3,3,3,5,12,11,12,15,
5,5,5,15,5,3,3,15,5,15,15,3,5,5,5,15,5,15,5,15,15,11,
15,5,12,11,12,3,3,15,15,12,12,11,5,5,5,5,5,3,3,15,5,
16,15,3,15,5,5,15,5,15,5,3,13,12,11,5,12,11,13,3,3,3,
5,13,13,11,15,3,5,3,3,3,16,5,3,5,3,5,16,15,5,15,15,5,
16,11,15,5,15,11,13,16,16,15,16,15,16,11,13,15,5,15,3,3,
15,5,15,5,3,5,16,15,5,15,15,5,15,11,15,5,5,11,12,12,16,
15,16,5,12,11,12,5,15,3,3,15,15,15,5,3,5,3,15,5,15,15,
15,3,12,15,5,11,11,15,15,4,3,3,5,12,13,15,5,3,3,15,5,
15,15,3,5,5,5,15,5,15,5,11,12,11,5,5,12,11,11,15,15,15,
15,11,12,11,3,3,15,15,15,5,3,5,3,15,5,5,15,15,3,12,4,
15,12,12,15,13,3,3,3,5,12,11,15,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,7,3,3,4,4,4,7,3,3,3,4,4,2,3,3,3,3,3,3,3,
3,3,3,4,3,3,4,3,3,3,2,4,4,3,7,3,3,4,4,4,15,15,15,16,
15,16,15,15,15,15,15,16,15,15,15,15,15,15,16,3,3,16,16,
16,15,15,15,5,3,5,16,15,5,15,3,5,15,11,15,5,5,11,12,12,
3,3,3,5,12,11,12,15,16,16,3,15,15,15,16,15,16,16,15,15,
15,15,15,16,3,3,16,16,16,15,15,3,15,5,5,5,5,16,5,13,16,
11,5,5,13,11,13,3,3,16,11,12,12,11,3,3,3,15,3,3,3,16,
3,3,15,15,15,15,2,3,3,16,3,16,4,4,5,5,5,5,16,5,15,15,
11,5,5,12,11,12,3,3,3,5,12,12,11,15,5,3,3,3,16,11,3,5,
5,11,16,15,3,3,7,12,16,11,13,5,15,3,15,13,11,3,5,5,11,
13,12,3,3,3,11,12,11,13,5,15,5,12,11,11,15,5,11,11,12,
15,15,15,5,12,11,11,3,15,12,3,15,5,11,12,15,13,4,3,3,5,
11,15,15,3,15,4,3,16,15,16,15,15,3,3,3,15,15,16,15,15,
12,16,15,5,11,15,12,16,15,16,5,12,11,15,15,15,15,15,12,
12,4,3,3,16,15,16,13,13,3,3,3,3,13,13,3,3,16,15,12,16,
12,3,4,12,4,12,7,3,3,3,13,13,7,5,11,11,11,3,3,15,5,11,
12,11,11,12,11,3,3,15,5,12,11,12,12,12,4,3,16,11,12,12,
11,12,3,4,16,11,12,12,12,4,4,3,12,12,11,12,3,3,3,4,4,
3,3,3,4,3,4,15,16,16,4,11,11,11,12,12,12,15,15,15,15,
15,15,15,15,15,15,15,15,15,15,15,15,16,16,15,15,15,15,16,
15,15,4,1,15,15,15,16,3,15,15,16,15,15,15,16,16,16,16,1,
4,16,16,16,15,15,15,4,16,16,16,15,5,5,15,15,15,15,5,15,
15,15,5,5,5,15,15,15,5,5,5,5,16,15,5,4,1,5,15,5,15,4,
15,15,15,5,5,15,15,14,16,13,4,1,13,16,13,5,12,11,4,16,
13,12,15,5,15,15,5,15,5,15,15,5,5,5,5,15,15,15,5,15,15,
5,16,5,5,3,1,5,5,5,15,3,5,5,15,5,5,15,15,14,16,16,1,
3,12,12,12,15,15,15,15,13,12,12,5,15,15,15,15,5,15,5,5,
15,5,5,5,16,15,15,5,15,5,15,5,5,7,1,5,5,15,15,4,5,15,
5,15,15,5,5,16,16,16,1,4,12,16,13,12,5,5,16,16,13,12,
15,15,5,15,5,15,5,5,5,5,15,5,15,15,5,15,15,5,15,15,5,
3,1,15,5,15,15,3,5,5,5,5,15,15,5,15,14,14,3,1,12,12,
12,5,5,15,16,12,12,12,15,15,15,15,16,15,15,15,15,15,16,
16,15,15,15,16,15,15,15,15,3,1,15,15,15,15,4,15,16,15,
15,15,15,15,16,16,16,4,1,16,16,16,15,16,15,16,16,16,16,
15,15,15,16,15,15,15,15,15,15,16,15,15,15,15,15,15,15,15,
4,1,15,15,16,16,3,15,16,15,16,15,15,15,16,16,16,1,4,16,
16,15,15,15,16,16,16,16,16,15,5,15,5,5,15,5,15,5,16,15,
5,5,16,5,15,5,5,3,1,5,5,5,15,3,5,16,15,15,15,5,5,14,
13,16,1,1,13,12,12,15,15,5,3,12,12,13,15,15,15,15,15,15,
15,16,15,15,15,15,15,15,16,15,15,3,1,15,15,16,15,7,15,
15,15,15,15,16,15,16,16,16,4,1,16,16,16,16,15,15,16,16,
16,16,15,15,5,15,5,15,15,16,15,5,15,15,5,15,5,5,3,1,5,
5,15,15,3,5,5,5,15,15,15,15,15,14,14,16,16,12,12,12,5,
5,5,16,12,12,12,15,15,15,15,15,15,15,15,15,15,15,15,16,
15,15,3,3,15,15,15,15,3,15,15,15,15,15,15,15,15,15,3,3,
3,15,16,15,15,16,15,16,15,15,16,15,5,5,5,3,3,15,5,5,5,
5,3,3,5,3,3,5,5,3,15,3,15,3,15,5,5,15,5,11,3,13,3,3,
13,12,11,5,11,5,3,11,13,13,5,5,5,3,3,15,5,5,5,5,15,5,
5,3,3,5,5,5,15,3,5,3,15,5,5,15,15,11,15,15,3,3,12,12,
11,5,15,15,15,11,12,12,5,5,15,3,15,15,5,5,5,3,3,5,3,3,
15,15,3,15,3,5,15,5,5,15,5,5,13,3,12,3,3,13,11,13,11,
5,5,3,12,12,11,15,5,16,15,5,15,15,5,16,5,5,3,3,5,5,5,
15,3,5,5,5,5,5,5,5,15,11,15,3,3,11,12,12,5,5,5,15,12,
11,12,5,16,15,5,15,5,15,15,5,15,3,3,5,5,5,15,3,5,5,5,
5,5,5,5,13,12,3,3,3,11,13,12,11,5,5,15,12,11,13,3,15,
5,5,5,5,15,1,5,3,3,15,5,15,15,3,5,15,5,15,3,3,3,15,
16,12,15,16,15,11,12,5,15,5,16,12,15,11,16,15,16,16,16,
16,15,15,3,4,15,3,15,15,3,3,3,3,3,3,3,3,16,15,4,3,3,
2,16,16,15,15,15,16,15,15,15,15,15,16,15,16,15,15,7,3,
15,15,15,15,3,15,15,15,15,15,15,15,7,15,15,3,7,15,15,16,
16,15,15,16,16,15,15,5,5,5,3,15,5,3,3,15,5,15,15,3,5,
5,5,15,15,5,5,15,15,11,3,3,12,11,12,15,5,15,15,12,12,
11,16,15,16,5,5,3,3,5,5,5,15,3,5,5,5,5,5,5,5,3,11,13,
3,3,11,13,13,5,11,5,15,12,11,12,16,16,5,16,3,3,5,5,5,
15,3,5,5,5,15,5,5,5,16,12,3,3,3,11,13,16,16,15,5,15,
16,11,13,16,5,15,3,3,5,5,5,15,3,5,5,5,5,5,5,5,15,11,
15,16,16,11,12,12,5,5,5,15,12,11,12,3,15,4,3,3,3,3,15,
3,3,15,15,3,3,3,3,7,15,16,3,7,2,16,16,16,15,15,16,16,
15,15,5,3,3,5,15,15,15,3,5,5,5,3,3,3,3,16,16,12,3,3,
4,12,13,5,15,11,16,13,15,11,3,3,5,5,5,15,3,5,5,5,5,5,
5,5,11,11,12,15,15,11,12,11,15,5,5,15,11,11,12,3,3,3,3,
3,3,3,3,3,3,7,3,3,7,3,3,3,7,4,4,2,3,3,3,3,4,4,4,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,3,4,3,3,3,3,4,4,
2,15,15,15,3,5,5,5,16,16,5,5,15,13,12,3,3,12,11,13,5,
5,11,16,13,12,11,3,15,3,5,15,5,15,16,5,5,15,15,11,3,3,
12,11,12,5,5,5,3,12,12,11,15,3,3,3,5,3,3,3,3,15,15,16,
3,3,4,13,11,5,5,11,16,16,15,11,7,15,15,15,15,15,15,15,
15,16,15,3,3,16,15,15,15,15,16,16,15,16,15,3,3,3,3,3,3,
3,3,4,3,3,3,4,4,4,3,3,3,7,4,2,4,3,15,5,5,16,15,11,
15,15,3,3,12,12,11,5,5,5,3,11,12,12,3,15,3,3,3,12,15,
3,3,3,15,16,11,5,5,11,4,13,15,12,5,5,16,16,12,13,16,3,
3,13,13,11,5,5,11,15,11,12,12,15,5,5,16,3,12,3,3,13,11,
19,15,5,15,3,15,13,11,5,5,19,3,12,3,3,13,11,14,12,5,5,
3,15,16,11,15,12,3,16,3,3,16,15,11,5,12,5,3,11,13,14,
11,3,3,3,3,13,15,11,5,15,15,3,11,13,19,15,15,3,7,13,13,
7,15,15,15,16,16,12,12,15,3,3,4,12,12,15,15,15,16,13,16,
13,3,3,13,3,13,3,3,3,16,12,12,16,3,4,3,4,3,3,3,3,4,4,
3,4,4,3,3,3,3,3,3,4,4,12,12,11,11,12,3,12,12,11,12,11,
12,12,16,12,12,12,12,11,12,16,12,11,12,5,5,15,12,11,11,
5,15,12,11,12,15,11,12,11,16,16,15,12,12,12,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,15,15,5,15,5,5,
15,5,15,5,15,5,15,5,15,15,15,15,15,11,11,11,11,5,5,11,
13,5,13,5,11,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,
5,5,5,15,15,5,15,5,5,15,5,15,5,15,5,15,5,15,15,15,15,
15,11,11,11,11,5,5,11,13,5,13,5,11,5,5,5,5,5,5,5,5,5,
5,5,5,5,15,5,5,5,15,5,15,5,15,15,15,5,5,5,5,15,5,5,5,
5,15,5,15,15,15,15,11,11,11,11,11,11,11,5,11,5,11,11,5,
5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,5,15,15,15,15,15,5,
5,5,5,15,5,5,5,5,5,5,15,15,5,15,12,11,11,12,5,5,11,5,
5,5,5,11,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,5,15,15,
15,15,15,5,5,5,5,15,5,5,5,5,5,5,15,15,5,15,12,11,11,
12,5,5,11,5,5,5,5,11,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,
5,5,5,15,15,15,5,5,15,5,15,5,15,5,15,5,5,15,15,15,15,
11,5,5,11,5,5,5,11,5,11,5,5,5,5,5,5,5,5,5,5,5,15,5,
5,5,15,5,5,5,15,5,15,5,5,5,5,5,5,15,5,15,15,5,15,15,
5,15,11,5,5,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,
5,5,5,15,5,5,5,15,15,15,5,5,5,5,5,5,5,5,5,15,15,15,
15,15,15,11,5,5,11,12,12,5,5,12,5,12,5,5,5,5,5,5,5,15,
15,5,5,5,15,5,5,5,15,15,15,5,5,5,5,5,5,5,5,5,15,15,
15,15,15,15,11,5,5,11,12,12,5,5,12,5,12,5,5,5,5,5,5,5,
15,5,5,5,5,5,5,5,15,5,1,5,5,5,5,5,5,5,5,5,5,15,15,
15,5,1,13,5,5,13,5,5,12,5,5,5,5,12,5,5,5,5,15,15,5,5,
5,5,5,5,15,15,5,1,5,5,5,5,5,5,5,5,5,5,15,15,15,3,15,
13,5,12,11,5,5,12,5,5,5,11,5,5,5,5,16,15,5,5,5,5,5,5,
15,15,5,15,5,5,5,5,5,5,5,5,5,5,15,16,15,15,15,11,5,11,
11,5,5,11,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,5,15,3,15,
5,5,5,5,5,5,5,5,5,15,5,15,15,3,15,11,12,12,11,5,11,5,
5,5,5,11,5,5,15,16,5,5,5,5,5,16,5,15,15,15,5,5,5,5,5,
5,5,5,5,5,5,15,15,15,15,11,11,11,11,5,5,5,5,5,5,11,11,
5,15,5,5,5,5,5,15,5,15,3,15,5,5,5,5,5,5,5,5,5,15,5,
15,15,5,3,11,12,5,13,5,12,5,5,5,5,5,12,15,5,5,5,5,5,
5,5,15,4,15,5,5,5,5,5,5,5,5,5,1,15,1,15,16,15,11,15,
16,11,5,12,15,5,5,5,13,5,15,15,15,15,15,1,15,1,15,16,
15,15,15,15,15,15,15,15,15,15,15,15,16,15,1,16,15,15,16,
15,16,16,15,15,16,15,15,5,5,15,5,15,5,15,16,15,5,5,5,5,
5,5,5,5,15,15,5,15,1,5,15,11,12,5,11,11,11,5,5,5,11,5,
5,5,5,5,5,16,15,15,15,5,5,5,5,5,5,5,5,16,5,5,15,15,
15,15,11,11,5,11,5,11,11,5,5,11,11,5,15,5,5,15,15,5,3,
5,5,5,5,5,5,5,5,5,5,5,15,3,5,15,13,5,5,11,12,5,12,5,
5,12,5,5,16,15,5,1,16,15,15,5,15,5,5,5,15,5,5,5,5,15,
16,5,15,12,5,5,12,16,16,5,5,5,13,5,5,5,5,16,5,15,5,5,
5,5,15,5,5,5,15,5,5,15,15,5,15,12,5,5,12,12,5,5,12,12,
5,5,5,5,15,16,15,5,5,5,5,5,5,5,5,15,5,5,15,3,5,15,12,
13,5,12,16,16,5,5,5,12,12,15,15,12,4,5,5,5,5,5,5,5,5,
1,5,1,15,15,15,15,12,12,16,12,5,5,16,5,5,5,13,5,15,1,
15,15,15,15,15,15,15,15,15,15,15,15,16,15,16,16,15,15,16,
15,16,15,15,15,16,15,16,15,5,15,5,5,15,5,15,5,5,16,5,
16,1,4,1,12,4,19,14,16,15,5,5,12,16,16,14,15,15,16,15,
15,15,15,16,15,15,16,15,1,1,1,1,15,15,16,15,15,4,15,15,
16,16,15,5,15,5,16,5,15,5,15,5,5,15,16,5,15,11,5,5,11,
11,5,5,11,11,11,5,5,5,5,15,5,16,5,5,16,5,15,15,5,15,
11,5,11,11,11,11,5,11,5,11,5,5,5,16,16,5,15,15,5,1,15,
15,5,15,12,5,5,13,12,5,5,16,12,16,5,5,1,5,5,5,5,5,15,
15,15,3,15,11,5,12,11,5,5,5,12,12,5,13,5,15,16,4,15,15,
5,4,16,3,1,12,5,16,14,16,5,5,16,4,16,16,16,15,5,5,5,
16,15,15,15,15,12,5,5,11,5,5,5,5,12,12,12,5,16,5,16,15,
1,16,15,3,12,5,5,16,5,5,5,16,13,5,5,5,15,5,5,16,15,5,
16,15,5,5,15,12,5,5,19,16,5,5,13,15,5,15,16,5,15,12,11,
5,12,13,5,5,16,5,16,5,5,5,15,15,3,15,12,12,5,12,5,16,
5,5,5,5,16,5,15,15,1,15,13,5,16,11,5,5,16,15,15,5,12,
15,15,15,16,15,15,15,16,15,15,15,16,16,15,16,16,15,15,16,
15,15,16,4,16,15,16,16,16,15,15,15,16,14,4,11,5,14,16,
14,14,5,4,5,16,15,15,1,15,16,15,15,16,15,15,16,11,12,15,
12,11,11,11,12,12,12,12,12,12,11,5,5,5,5,12,12,12,11,5,
11,12,12,11,5,5,5,12,12,12,12,12,11,11,11,12,11,11,12,
11,5,5,5,11,5,11,12,11,5,5,12,11,12,11,12,11,11,12,13,
12,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,
5,15,15,5,15,5,5,15,5,15,5,15,5,15,5,15,15,15,15,15,11,
11,11,11,5,5,11,13,5,13,5,11,5,5,5,5,5,5,5,5,5,5,5,5,
15,5,5,5,5,15,5,15,15,5,15,5,5,5,5,5,15,5,5,5,5,15,
15,5,5,15,15,5,11,11,5,11,11,11,5,11,5,11,11,5,5,5,5,
5,5,5,5,5,5,5,15,5,5,5,5,15,5,15,15,5,15,5,5,5,5,5,
15,5,5,5,5,15,15,5,5,15,15,5,11,11,5,11,11,11,5,11,5,
11,11,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,5,5,5,15,5,15,
15,5,5,5,5,15,5,5,5,5,5,15,5,15,15,15,5,11,11,5,5,5,
11,5,5,5,5,11,5,5,5,5,5,5,5,5,5,15,5,5,5,5,5,5,5,15,
5,15,15,5,5,15,5,15,5,15,5,15,5,15,5,15,15,15,5,11,11,
5,11,11,11,11,11,11,11,11,5,5,5,5,5,5,5,5,15,5,5,5,5,
15,5,5,15,5,15,15,5,5,5,5,15,5,15,5,15,15,15,5,15,15,
5,5,12,12,5,11,11,12,5,11,5,11,12,5,5,5,5,5,5,5,15,5,
5,5,5,15,5,5,15,5,15,15,5,5,5,5,15,5,15,5,15,15,15,5,
15,15,5,5,12,12,5,11,11,12,5,11,5,11,12,5,5,5,5,5,5,
15,5,5,5,5,15,5,5,15,5,5,5,5,5,5,5,15,5,5,5,5,15,15,
5,5,15,5,5,11,11,5,5,5,11,5,5,5,5,11,5,5,5,5,5,15,15,
5,5,5,5,5,5,15,15,5,3,5,5,5,5,15,5,5,5,5,5,15,15,5,
15,3,11,11,11,11,5,5,13,5,5,5,5,13,5,5,5,5,15,15,5,5,
5,5,5,5,15,5,5,1,5,5,5,5,15,5,5,5,5,5,15,5,5,1,5,11,
11,13,5,5,5,13,5,5,5,12,11,5,5,5,16,15,5,5,5,5,5,5,
15,15,5,15,5,5,5,5,15,5,5,5,5,5,15,16,5,15,15,11,11,
11,11,5,5,11,5,11,5,11,11,5,5,15,5,5,5,5,5,5,15,15,5,
1,5,5,5,5,5,15,5,5,5,5,15,15,5,5,1,5,5,13,13,5,5,12,
11,5,5,5,12,11,5,15,15,5,5,5,5,5,16,15,5,15,15,5,5,5,
5,15,5,5,5,5,15,15,5,5,15,5,11,11,11,5,5,11,11,5,5,5,
11,11,15,5,5,5,5,5,5,5,15,5,1,5,5,5,5,5,15,5,5,5,5,
5,15,5,5,15,3,5,13,11,12,5,12,11,5,5,5,5,13,15,15,15,
15,15,15,15,15,15,3,15,15,15,15,15,16,15,15,15,15,1,15,
1,15,16,15,15,15,16,15,15,15,15,16,15,15,16,15,5,5,5,5,
5,1,15,1,5,14,5,5,5,5,15,5,5,5,5,5,15,15,5,15,1,15,
12,11,16,5,5,12,5,5,5,5,12,5,5,15,5,15,15,5,3,5,5,5,
5,5,15,5,5,5,5,5,15,5,3,15,5,5,13,11,5,12,12,11,5,5,
11,5,11,5,15,5,15,16,5,15,5,5,5,5,5,15,5,5,5,15,5,15,
5,15,15,5,5,11,11,5,11,11,11,5,5,5,5,11,5,5,5,15,5,5,
16,5,5,5,5,15,5,5,5,15,5,15,5,3,15,5,12,11,11,5,12,5,
13,5,5,12,5,11,16,15,15,1,4,5,5,5,5,5,15,5,5,15,5,5,
15,5,16,15,5,5,12,12,5,16,16,12,5,12,13,5,12,5,15,16,
15,15,5,5,5,5,15,5,5,5,5,5,15,5,5,15,5,5,12,11,5,5,5,
12,12,5,12,5,12,15,5,14,5,5,5,5,5,15,5,5,5,5,5,15,5,
4,15,5,5,13,11,5,16,15,11,5,5,12,15,11,15,15,3,15,15,
15,15,16,15,15,15,1,15,1,15,15,16,15,15,15,16,15,15,15,
15,15,15,16,16,15,5,4,5,5,15,5,16,15,5,15,15,15,15,5,
16,15,15,16,12,12,15,5,5,12,15,11,5,5,13,15,5,15,15,5,
15,5,15,5,12,16,15,15,1,1,3,5,1,14,14,16,4,13,5,5,16,
16,15,5,5,16,5,15,15,5,15,5,5,16,15,3,1,4,4,12,14,16,
14,5,15,12,5,16,14,16,5,15,5,16,5,5,5,15,5,15,5,15,15,
5,5,11,11,5,12,5,11,11,12,11,5,11,5,5,15,5,16,5,5,16,
15,5,15,15,5,5,11,11,11,11,5,11,5,11,11,11,11,15,16,16,
5,15,15,5,1,15,15,15,5,5,12,12,11,5,5,12,16,12,16,5,12,
3,5,15,5,5,15,15,15,5,3,5,5,11,13,5,5,5,11,12,12,5,12,
11,15,16,1,15,16,15,4,16,1,1,15,16,16,16,16,15,16,16,1,
16,16,16,5,5,5,5,16,5,5,15,5,5,11,12,5,5,5,12,12,5,5,
5,11,16,5,1,15,1,16,15,3,5,12,12,16,5,5,12,16,13,12,15,
12,5,5,15,16,5,15,16,5,11,11,13,5,5,15,16,13,12,5,15,5,
15,5,16,15,5,5,13,12,5,13,5,12,16,12,16,5,12,15,5,12,4,
5,5,13,12,5,12,15,12,5,15,5,16,12,15,15,1,15,16,15,16,
15,15,15,16,15,15,16,15,15,5,15,16,15,12,12,16,5,5,11,
16,5,5,5,12,15,5,16,13,12,5,4,19,14,16,14,16,5,12,15,
16,15,1,15,15,16,16,15,15,15,4,15,15,14,11,4,5,14,16,14,
14,5,5,16,11,12,11,12,5,11,5,5,11,12,12,15,12,12,11,15,
11,11,12,12,15,11,11,12,15,12,12,11,11,15,5,12,12,12,11,
5,5,11,12,12,11,12,5,5,11,11,5,5,11,12,12,12,11,12,12,
15,5,12,11,12,12,12,12,5,12,11,5,5,5,5,5,5,5,5,5,5,5,
5,15,15,5,5,5,15,5,15,5,5,15,15,5,5,5,5,5,5,5,5,5,15,
15,15,15,15,15,5,11,11,5,12,12,11,5,12,5,12,11,5,5,5,5,
5,5,5,5,5,5,5,15,15,5,5,5,5,5,15,15,5,5,5,5,5,5,5,5,
5,5,5,5,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,15,15,5,5,5,15,5,15,5,5,15,15,5,5,5,
5,5,5,5,5,5,15,15,15,15,15,15,5,11,11,5,12,12,11,5,12,
5,12,11,5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,5,5,5,
15,5,5,15,5,15,5,15,5,15,5,15,15,15,5,5,5,5,5,5,5,5,
5,11,5,11,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,15,5,15,15,
5,5,5,5,5,5,5,5,5,15,5,15,15,15,15,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,5,5,
5,15,5,5,5,5,5,5,5,5,5,5,15,15,15,15,5,5,5,5,5,11,11,
5,5,11,5,11,5,5,5,5,5,5,5,15,15,5,5,5,15,5,15,15,5,5,
5,5,5,5,5,5,5,15,5,15,15,15,15,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,15,16,5,5,5,5,5,5,15,16,5,16,5,
5,5,5,5,5,15,5,5,5,15,15,15,15,16,13,5,11,15,5,5,15,5,
5,5,5,13,5,5,5,5,15,15,5,5,5,5,5,5,16,15,5,16,5,5,5,
5,5,5,5,5,5,5,16,15,5,16,15,15,11,15,11,5,5,13,5,5,5,
13,5,5,5,5,15,15,5,5,5,5,5,5,15,15,5,5,5,5,5,5,5,5,
5,5,5,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,
15,5,5,5,5,5,5,5,5,16,5,5,5,5,5,15,5,5,5,5,16,15,15,
5,16,5,11,15,13,5,5,13,5,5,5,5,12,11,5,15,15,5,5,5,5,
5,15,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,15,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,5,5,5,5,16,5,5,5,5,
5,5,5,5,5,5,15,15,15,5,5,16,5,13,5,13,11,15,5,11,5,11,
11,12,15,15,15,15,15,15,15,15,15,16,15,15,15,15,15,15,15,
15,15,15,1,15,1,15,16,15,15,16,16,15,15,16,15,16,15,15,
15,15,15,15,15,15,15,1,15,1,15,16,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,16,16,15,15,15,16,15,15,15,15,16,15,
16,5,5,16,5,15,5,5,16,15,5,5,15,5,5,5,5,5,5,5,15,15,
16,5,5,5,13,5,11,13,12,11,5,5,12,5,5,5,15,5,5,15,5,5,
5,5,5,5,5,5,5,5,5,15,5,15,15,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,15,5,15,5,15,15,15,5,5,5,5,15,5,5,5,15,5,15,
15,15,5,15,13,5,5,5,15,11,12,11,11,13,5,5,16,1,5,1,16,
15,5,5,5,5,15,5,5,5,5,15,15,15,13,5,15,5,5,5,5,12,15,
15,5,5,12,5,5,5,5,16,5,5,5,5,5,5,5,5,5,5,15,5,15,15,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,13,11,5,5,5,5,5,
5,15,5,5,5,15,15,16,15,5,5,12,5,5,15,12,11,12,5,5,5,5,
15,5,16,5,5,5,5,5,5,5,5,1,15,1,15,12,16,11,15,5,12,11,
5,5,15,5,5,12,12,5,15,16,5,5,5,5,15,5,5,5,5,5,15,15,
5,11,16,15,5,11,12,11,5,15,5,5,12,5,13,5,5,5,5,15,5,5,
5,5,15,15,15,15,3,3,3,5,16,14,14,13,16,15,5,5,15,14,14,
5,5,15,15,5,5,12,15,15,5,16,15,3,1,1,16,5,14,14,16,15,
16,15,15,16,16,14,5,16,5,16,5,5,5,15,5,15,15,16,5,5,11,
5,11,5,12,5,5,12,13,12,5,11,5,5,5,5,15,5,5,15,15,15,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,13,16,15,5,16,5,1,15,
16,15,5,5,5,5,5,5,11,11,12,12,16,5,5,16,5,15,5,5,5,15,
15,5,16,5,5,5,12,5,11,5,5,13,15,5,12,5,5,14,16,15,5,
16,16,16,1,1,5,5,14,14,14,5,5,16,16,16,14,14,15,5,5,15,
16,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,15,15,1,5,
5,16,5,5,5,15,5,5,11,12,12,5,5,5,5,5,15,16,5,5,16,5,
5,5,12,11,11,5,15,13,11,5,12,5,15,15,13,5,12,5,5,5,5,
12,5,5,16,5,12,5,11,15,15,5,16,5,5,12,5,5,5,12,5,5,11,
5,15,15,15,16,16,15,16,15,16,15,15,15,16,16,16,16,16,15,
15,15,16,15,15,15,16,15,16,15,16,15,15,15,16,5,5,14,13,
5,5,15,16,14,16,16,16,15,5,5,19,14,16,15,5,16,14,16,16,
15,16,5,14,19,15,16,15,16,19,16,16,15,5,16,5,11,12,11,5,
5,5,5,11,12,11,12,11,11,5,5,5,5,12,11,11,5,5,11,12,11,
11,5,5,5,5,11,11,11,11,5,5,5,12,11,12,12,5,5,5,5,5,5,
12,12,11,5,5,11,11,12,5,15,12,11,12,12,11,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,15,5,5,5,5,15,5,15,15,5,15,5,5,5,5,
5,15,5,5,5,5,15,15,5,5,15,15,5,11,11,5,11,11,11,5,11,
5,11,11,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,15,5,15,5,5,
15,15,5,5,5,5,5,5,5,5,5,15,15,15,15,15,15,5,11,11,5,
12,12,11,5,12,5,12,11,5,5,5,5,5,5,5,5,5,5,15,5,5,5,
15,5,15,5,15,15,15,5,5,15,5,15,5,15,5,15,15,5,15,15,5,
15,13,5,5,13,11,11,5,11,11,11,11,5,5,5,5,5,5,5,5,5,5,
15,5,5,5,15,5,15,5,15,15,15,5,5,15,5,15,5,15,5,15,15,
5,15,15,5,15,13,5,5,13,11,11,5,11,11,11,11,5,5,5,5,5,
5,5,5,5,5,5,5,5,15,5,15,5,5,15,15,5,5,5,5,15,5,5,5,
5,15,5,5,15,15,15,5,5,5,5,11,11,5,5,11,5,11,5,5,5,5,
5,5,5,15,5,5,5,5,15,5,15,5,5,15,5,5,5,5,5,5,5,5,5,5,
15,15,5,5,5,15,5,5,5,5,11,11,5,5,11,5,11,5,5,5,5,5,5,
5,15,5,5,5,15,5,15,5,15,15,1,5,5,5,5,5,5,5,5,5,15,5,
5,5,5,1,11,5,5,11,11,11,11,5,11,5,11,11,5,5,5,5,5,5,
5,5,5,15,5,15,15,5,15,3,5,5,5,5,5,5,5,5,5,15,15,5,5,
3,15,11,5,11,5,11,11,11,5,11,5,13,5,5,5,5,15,5,5,5,5,
15,5,15,5,5,15,15,5,5,5,5,5,5,5,5,5,15,5,16,5,15,15,
11,11,5,5,11,11,11,11,11,5,11,11,5,5,15,5,5,5,5,15,5,
15,15,5,1,5,5,5,5,5,5,5,5,5,5,15,5,5,5,1,15,5,11,11,
5,11,13,5,5,11,5,13,5,5,5,16,5,5,5,15,5,15,15,5,15,15,
5,5,5,5,5,5,5,5,5,15,15,5,5,15,15,5,5,11,5,11,11,11,
5,11,5,11,5,15,5,5,5,5,15,5,15,5,15,3,5,5,5,5,5,5,5,
15,5,5,15,5,15,5,5,3,5,12,5,12,11,13,5,5,11,5,11,12,5,
5,15,5,15,5,15,5,5,4,12,5,5,15,5,5,5,5,5,5,1,5,1,5,
16,16,5,16,15,5,12,12,11,5,12,5,13,15,5,5,15,15,5,1,5,
1,15,16,5,5,15,5,5,5,5,5,5,15,5,5,5,12,1,16,5,5,16,
12,12,13,5,12,5,13,12,5,5,15,5,15,5,5,16,5,5,5,5,5,5,
5,5,5,15,15,5,5,1,5,15,5,11,5,5,13,13,5,5,11,12,11,5,
5,15,5,15,16,5,15,5,5,5,5,5,5,5,5,5,16,15,5,5,15,15,
15,5,11,11,5,11,11,5,5,11,11,11,5,15,5,15,5,5,15,16,5,
5,5,5,5,5,5,5,5,15,5,5,1,5,15,12,5,5,5,13,11,12,5,11,
12,11,5,16,15,15,1,16,15,15,15,15,15,15,15,15,15,15,15,
15,15,16,15,16,16,15,15,15,16,16,15,15,15,16,15,15,15,5,
16,15,5,5,5,15,5,5,5,5,5,5,15,5,5,15,5,15,5,5,5,12,
12,12,5,5,11,5,11,5,15,15,16,15,15,15,15,15,15,15,15,15,
15,15,15,15,3,15,16,16,16,15,15,16,16,15,15,15,15,15,15,
5,15,4,5,5,5,5,5,5,5,5,1,15,1,5,5,14,15,12,15,15,5,
12,11,16,5,12,5,12,5,15,3,5,5,15,5,5,5,15,15,5,15,5,5,
16,15,16,15,5,5,16,12,12,5,11,12,5,12,12,15,15,15,15,15,
15,15,15,15,15,15,15,15,1,1,1,15,4,15,15,16,16,15,15,16,
16,16,15,5,5,16,5,5,5,5,5,5,15,16,16,3,1,1,1,5,19,16,
14,12,16,5,12,16,14,14,5,15,5,16,5,15,5,15,15,5,5,3,5,
15,5,5,5,5,13,11,5,12,13,12,11,5,15,5,15,5,15,5,15,16,
5,5,15,5,15,5,11,5,5,11,11,5,11,11,11,11,11,5,15,16,5,
15,15,15,1,5,4,5,16,5,5,5,15,12,12,5,16,13,16,12,11,3,
5,5,5,5,15,5,5,5,16,15,5,5,12,5,11,11,5,12,13,5,13,5,
5,16,1,15,15,5,4,4,3,1,5,5,14,14,16,11,5,15,1,16,14,
14,5,5,5,15,16,5,15,15,15,12,5,5,12,12,11,5,5,12,5,12,
5,16,15,15,5,1,15,15,4,5,5,5,16,11,11,5,16,13,15,11,5,
5,15,15,15,15,5,16,12,5,5,16,15,11,5,13,15,5,11,13,15,
5,5,14,5,15,5,5,5,5,13,11,5,16,12,15,11,5,15,15,15,3,
16,15,15,15,16,15,16,15,15,15,15,15,15,5,5,4,15,13,5,16,
5,12,12,16,5,12,5,12,11,5,15,16,12,15,5,16,12,12,5,16,
12,5,12,13,15,15,16,14,5,12,1,14,14,16,16,4,13,5,15,16,
16,4,5,12,14,16,14,15,5,15,5,15,15,15,1,16,16,16,16,16,
15,16,16,5,11,12,12,11,5,5,12,12,12,12,11,11,12,11,5,5,
11,12,12,12,5,11,12,11,12,12,5,11,5,12,12,11,12,12,5,11,
5,15,12,12,15,11,15,11,11,11,15,12,15,12,5,11,12,12,11,
11,12,12,11,12,15,12,11,5,11,5,5,5,5,5,5,5,5,5,5,5,15,
5,5,5,5,5,15,15,15,15,15,5,5,5,5,15,5,5,5,5,5,5,15,
15,5,15,12,11,11,12,5,5,11,5,5,5,5,11,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,15,15,5,5,15,5,5,15,5,15,5,15,5,15,
5,5,5,15,15,15,5,5,5,5,11,11,5,12,11,12,11,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,15,5,15,15,5,5,5,5,5,5,5,5,5,15,5,
15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,15,15,5,5,15,5,5,15,5,15,5,15,5,15,
5,5,5,15,15,15,5,5,5,5,11,11,5,12,11,12,11,5,5,5,5,5,
5,5,15,5,5,5,5,15,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,
15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
15,5,5,5,5,5,15,15,16,15,16,5,5,5,5,15,5,5,5,5,5,5,5,
5,5,16,12,11,5,13,11,5,13,5,5,5,11,15,5,5,5,5,5,5,5,
5,5,5,5,15,15,5,5,16,5,5,5,5,5,5,5,5,5,15,16,5,5,16,
5,13,5,13,5,5,11,15,5,11,5,15,11,5,5,5,15,5,5,5,5,5,
5,15,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,15,5,15,15,5,16,5,
5,5,5,5,5,5,5,5,5,15,15,5,5,16,5,5,13,15,5,11,15,11,
5,5,5,13,5,5,5,15,5,5,5,5,5,15,15,5,5,5,5,5,5,5,5,5,
5,5,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,
5,5,15,5,15,15,15,16,15,5,5,5,5,15,5,5,5,15,5,5,5,5,
5,16,11,12,5,15,5,13,5,5,5,11,5,13,5,15,15,5,15,5,15,
15,5,16,5,5,5,5,5,5,5,5,5,15,1,5,1,5,15,12,5,15,12,5,
11,15,5,5,5,5,13,5,5,5,5,5,5,1,15,1,11,12,5,5,5,15,5,
5,5,15,5,15,5,5,5,15,15,11,11,5,15,5,5,12,11,5,5,5,15,
5,5,16,5,16,15,5,16,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,
5,5,15,11,5,15,13,5,5,11,13,5,11,5,15,5,15,15,5,5,5,5,
5,5,5,5,5,5,5,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,15,15,5,5,16,5,5,5,5,5,5,15,5,5,5,5,15,16,5,5,
15,5,5,11,13,5,13,11,5,15,5,5,16,15,15,1,15,15,5,5,15,
5,15,5,5,15,5,5,5,15,16,5,5,5,15,11,11,12,15,5,5,5,12,
5,5,15,15,16,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,15,15,16,15,15,15,15,15,15,15,15,
15,15,15,15,15,16,15,15,15,15,15,16,15,15,15,15,15,16,15,
15,15,15,16,15,15,15,15,15,15,15,15,1,15,1,15,15,16,15,
16,15,16,15,15,15,16,16,15,15,15,15,15,16,5,5,5,5,5,5,
5,5,5,5,15,5,12,5,14,15,15,5,12,5,5,5,5,15,5,5,12,5,
5,5,5,5,5,5,5,15,15,15,5,5,3,1,1,15,15,14,16,14,16,5,
5,5,14,14,14,5,5,12,5,5,5,5,5,5,5,16,5,1,3,3,16,15,
14,14,14,5,16,5,15,14,14,14,5,16,5,16,5,5,5,16,5,5,5,
15,15,15,5,11,5,5,13,5,11,13,15,12,11,5,15,5,5,5,15,5,
5,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,13,15,5,5,
1,5,1,5,16,15,5,5,5,5,5,5,5,5,12,12,15,15,15,16,5,5,
5,15,5,15,5,15,16,15,11,5,13,5,5,5,5,15,13,11,12,5,5,
13,15,15,12,5,16,3,1,3,5,5,14,16,14,5,5,16,16,16,14,14,
5,5,5,5,16,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,15,
15,1,5,5,16,11,5,5,15,5,11,5,12,12,5,5,5,15,5,15,16,5,
15,16,11,5,5,13,5,5,5,13,12,11,5,12,5,5,5,13,11,5,5,5,
5,11,12,5,5,15,15,12,11,5,15,5,5,16,5,5,13,15,5,5,12,
11,5,5,5,15,5,5,15,15,15,12,5,15,5,5,11,12,11,5,5,15,
5,5,5,13,5,5,11,11,5,5,5,15,5,11,5,12,5,5,14,14,5,5,
16,14,14,13,14,16,15,15,5,14,14,16,5,5,14,14,16,14,15,
16,5,16,14,5,16,5,14,14,16,14,5,5,16,5,11,12,12,5,5,5,
5,11,12,11,12,11,11,5,5,5,5,12,11,12,5,5,11,12,11,11,5,
5,5,5,12,11,11,11,5,5,5,12,11,11,12,5,5,5,5,5,5,11,12,
11,5,5,11,11,12,5,12,11,11,11,11,11,5,5,5,5,5,5,5,5,5,
5,5,5,15,5,5,5,5,15,5,5,5,5,15,15,5,5,15,5,15,5,15,5,
15,15,15,5,15,15,5,5,12,12,5,5,5,12,11,5,11,5,12,5,5,
5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,15,15,5,5,5,5,5,5,
15,5,15,15,5,5,15,5,5,5,11,11,5,5,5,11,5,5,5,5,11,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,15,5,
5,5,5,5,5,5,15,15,15,5,11,11,5,11,11,11,5,11,5,11,11,
5,5,5,5,5,5,15,5,5,5,5,15,5,5,5,5,15,15,5,5,15,5,15,
5,15,5,15,15,15,5,15,15,5,5,12,12,5,5,5,12,11,5,11,5,
12,5,5,5,5,5,5,16,5,5,5,5,5,15,5,15,15,3,5,5,5,5,5,
5,5,5,5,5,5,5,15,5,3,12,11,11,12,5,5,13,5,5,5,5,13,5,
5,5,5,5,5,5,5,5,5,5,5,16,5,15,3,5,5,5,5,5,5,5,5,5,
5,16,5,15,1,5,12,11,13,5,5,5,13,5,5,5,12,11,5,5,5,16,
5,5,5,5,5,5,5,5,5,15,15,5,5,5,5,15,5,5,5,5,15,5,16,
15,5,5,5,12,12,12,5,12,11,5,5,5,12,12,5,5,16,5,5,5,5,
5,5,5,5,5,3,15,5,5,5,5,5,5,5,5,5,16,5,15,15,3,5,5,
13,13,5,5,12,11,5,5,5,12,11,5,5,16,5,5,5,15,5,16,5,15,
15,15,5,5,5,5,5,5,5,5,5,5,5,5,15,5,15,12,12,11,12,12,
12,12,5,5,5,5,12,5,5,5,5,5,5,5,5,5,5,1,15,5,5,5,5,5,
5,5,5,5,5,5,5,15,5,4,5,15,11,12,5,12,11,5,5,5,5,15,5,
5,5,5,5,5,5,5,5,3,15,5,15,5,5,12,5,5,15,5,15,5,16,15,
16,5,5,16,13,5,5,15,12,12,12,5,16,16,15,5,5,5,15,16,5,
16,15,15,5,5,5,5,5,5,5,5,5,5,5,5,15,5,1,12,12,11,16,
11,15,13,5,5,5,5,12,5,5,16,5,16,5,5,16,15,5,5,5,5,5,
5,5,5,5,5,5,5,3,5,5,5,13,11,5,12,12,11,5,5,12,5,11,5,
5,5,5,16,5,15,15,5,5,5,5,15,5,5,5,16,5,15,5,15,15,5,
12,11,12,5,12,5,12,5,12,5,5,11,5,5,5,5,5,15,16,5,5,5,
5,5,5,5,5,5,5,5,5,1,5,5,12,11,11,5,12,5,15,5,5,13,5,
11,16,16,5,16,15,16,5,5,5,5,5,5,5,5,5,5,5,5,16,5,15,
12,13,11,5,12,16,13,5,5,13,5,13,15,5,16,15,15,5,5,5,5,
5,5,5,5,5,5,5,5,15,5,15,12,11,11,11,11,11,11,5,5,11,5,
11,5,5,16,15,5,5,5,5,5,5,5,5,5,5,5,5,3,5,12,15,13,11,
11,15,12,12,5,5,15,5,12,5,15,3,15,5,5,5,15,5,5,5,16,5,
15,5,16,16,5,15,11,13,5,5,5,16,5,5,5,13,11,16,1,5,5,5,
5,5,5,5,5,5,5,5,5,16,5,19,16,13,12,12,5,11,13,5,5,5,
5,13,15,15,15,15,15,15,15,15,15,15,15,15,15,1,1,1,15,1,
16,16,15,16,15,15,15,15,15,16,15,15,16,15,15,15,15,15,15,
15,16,15,1,1,1,4,15,16,15,16,15,16,15,15,16,15,16,5,16,
5,15,5,5,5,16,5,15,5,3,5,5,5,11,11,5,12,5,11,12,12,12,
5,11,5,5,15,5,16,5,5,15,5,5,15,15,15,5,12,12,5,5,5,11,
5,12,5,5,12,5,16,16,5,5,16,5,16,5,1,5,5,16,11,13,5,5,
5,13,15,13,16,11,11,1,5,5,5,5,5,5,5,15,16,5,5,11,15,5,
5,5,11,13,12,5,12,11,15,16,3,16,5,16,3,1,1,3,12,13,16,
16,16,5,13,16,4,14,15,15,5,5,15,5,16,5,15,5,5,11,11,11,
5,11,5,11,11,11,11,5,11,16,5,15,5,16,15,13,3,5,13,13,
15,5,5,12,13,12,5,5,16,5,15,5,15,15,15,16,5,19,19,13,5,
12,11,12,13,5,12,19,5,5,5,16,15,5,13,12,13,5,12,5,13,
16,5,13,5,12,5,5,15,3,5,5,13,13,12,5,12,11,15,5,5,16,
13,5,16,3,5,13,12,16,5,12,5,13,15,5,12,15,12,15,5,16,5,
11,12,12,5,11,11,16,13,5,15,13,15,15,16,16,16,15,1,15,
16,15,16,4,15,16,5,16,19,1,5,12,16,19,16,16,5,16,12,14,
16,11,4,5,15,14,14,14,5,5,16,12,12,12,11,11,12,5,11,11,
11,11,15,12,12,12,15,11,12,12,12,15,12,12,12,15,12,12,11,
12,15,11,11,12,11,11,5,11,12,13,12,12,13,5,5,11,12,5,5,
12,13,12,11,11,12,12,15,5,12,12,11,12,12,12,5,11,12,5,5,
5,5,5,5,5,5,5,15,5,5,5,15,5,15,5,15,15,15,5,5,15,5,
15,5,15,5,15,15,5,15,15,5,15,13,5,5,13,11,11,5,11,11,
11,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,5,5,15,5,
5,15,5,15,5,15,5,15,5,5,5,15,15,15,5,5,5,5,11,11,5,12,
11,12,11,5,5,5,5,5,5,5,15,5,5,5,5,15,5,5,5,5,15,15,5,
5,15,5,15,5,15,5,15,15,15,5,15,15,5,5,12,12,5,5,5,12,
11,5,11,5,12,5,5,5,5,5,5,15,5,5,5,5,5,5,5,15,5,1,5,
5,15,5,15,5,15,5,15,5,15,15,15,5,1,11,5,5,11,5,5,11,
11,5,11,5,11,5,5,5,5,15,15,5,5,5,5,5,5,15,5,5,1,5,5,
15,5,15,5,15,5,15,5,15,5,15,1,5,11,5,11,5,5,5,11,11,5,
11,11,5,5,5,5,16,5,5,5,5,5,5,5,5,5,5,15,5,5,15,5,15,
5,15,5,15,5,5,16,15,15,15,11,5,11,11,5,11,11,11,5,11,5,
5,5,5,15,5,5,5,5,5,5,5,5,5,3,15,5,5,15,5,15,5,15,5,
15,15,5,5,15,3,5,5,11,11,5,5,11,5,11,5,11,11,5,5,5,16,
5,5,5,5,5,15,5,5,15,15,5,5,15,5,15,5,15,5,15,5,5,5,
15,15,5,11,11,11,5,11,5,5,11,5,11,11,5,5,5,5,5,5,15,5,
5,5,5,3,15,5,5,15,5,15,5,15,5,15,5,5,5,15,5,1,5,12,5,
13,5,12,5,11,5,11,5,12,15,5,5,5,5,5,5,5,5,3,15,5,5,
15,15,15,5,15,5,15,1,5,1,15,16,15,5,16,16,5,5,5,5,12,
5,12,12,5,5,5,5,5,5,1,15,1,5,16,5,5,15,5,15,15,15,15,
15,5,5,5,15,5,3,16,5,5,16,5,5,13,12,5,12,11,5,5,5,15,
5,15,5,5,16,15,5,5,15,5,15,5,15,5,15,15,5,5,1,5,5,5,
11,5,5,11,11,5,11,5,13,5,5,5,5,5,5,16,5,15,15,5,5,15,
5,15,5,15,5,16,15,5,5,15,15,5,5,11,5,5,5,11,5,11,11,
11,11,5,5,5,15,5,5,5,16,5,5,15,5,15,5,15,5,15,5,15,5,
3,5,5,13,5,5,5,12,5,12,11,5,13,5,5,15,15,5,1,16,15,15,
15,15,5,15,5,15,5,15,15,5,15,16,5,5,5,12,5,15,16,16,5,
11,15,12,5,15,5,5,15,15,15,5,5,15,5,15,5,15,5,15,5,5,
15,15,5,15,12,12,5,5,5,5,5,11,5,12,5,12,5,5,15,15,5,
15,15,5,15,5,15,5,15,5,5,5,4,12,5,5,13,5,5,16,16,5,12,
5,12,11,5,5,5,3,5,5,15,15,15,5,15,5,1,5,1,5,15,16,5,
12,12,16,5,5,5,16,12,15,12,13,5,5,1,5,5,15,5,15,5,15,
15,15,5,15,5,16,5,16,16,5,5,16,5,5,12,13,5,12,5,12,15,
5,15,15,5,15,5,15,5,15,16,5,15,1,4,3,5,4,14,14,15,15,
5,11,5,16,14,14,15,15,16,15,15,15,15,15,16,15,16,16,1,1,
1,1,15,16,16,15,15,16,16,15,16,16,16,5,15,5,16,5,15,5,
15,5,5,5,16,5,5,5,5,5,5,11,5,5,13,11,13,5,5,15,5,15,
5,16,5,15,15,5,5,15,5,5,5,5,5,5,11,11,5,11,5,11,5,5,
15,16,15,15,15,15,15,1,15,16,15,15,16,15,16,15,15,15,15,
16,15,16,15,15,3,5,15,5,15,5,5,5,15,16,5,5,5,12,5,5,5,
5,13,12,11,12,5,15,16,1,16,15,15,4,15,1,1,15,15,16,15,
16,15,15,16,1,16,16,16,15,5,15,5,16,5,15,5,15,5,5,5,12,
5,5,12,12,5,12,5,12,16,15,16,15,1,15,16,4,15,16,15,16,
15,15,15,16,16,15,15,16,15,5,5,16,16,5,3,5,5,5,19,5,5,
12,15,13,15,5,16,15,15,15,16,15,15,16,15,16,15,15,15,15,
16,15,16,15,15,5,5,15,4,5,5,13,12,5,15,15,5,12,5,11,16,
5,15,15,3,5,13,5,16,5,5,5,16,12,5,12,5,5,15,15,16,5,5,
5,16,5,5,5,15,5,12,5,13,15,15,16,15,15,15,4,15,15,16,
15,16,15,15,15,16,16,1,5,5,19,16,14,14,12,15,12,16,16,5,
1,5,16,16,13,16,12,5,4,11,11,12,11,5,11,11,5,12,12,12,
12,11,11,5,5,11,5,12,12,13,11,5,11,12,12,11,11,5,5,5,
11,11,12,11,11,5,11,11,11,12,11,11,5,5,5,11,5,12,11,11,
12,5,12,11,12,11,15,12,12,12,12,12,11,12,5,5,5,5,5,5,5,
5,15,5,5,5,5,15,5,5,15,5,15,15,5,5,5,5,15,5,15,5,15,
15,15,5,15,15,5,5,12,12,5,11,11,12,5,11,5,11,12,5,5,5,
5,5,5,15,15,5,5,5,15,5,15,15,5,5,5,5,5,5,5,5,5,15,5,
15,15,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,15,5,5,5,15,5,5,5,16,5,16,5,5,5,5,5,5,15,5,15,15,5,
5,5,5,16,12,5,5,12,5,11,12,5,11,11,5,13,5,5,5,5,5,5,
5,5,5,15,5,5,15,15,5,16,5,5,5,5,5,5,15,5,15,15,16,5,
15,16,5,12,5,12,5,11,5,13,11,5,5,13,5,5,5,5,15,5,5,5,
5,15,5,5,5,5,5,5,5,5,5,5,5,5,15,5,15,15,5,15,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,5,5,15,5,5,5,5,
16,5,5,5,5,5,5,5,15,5,15,16,5,5,5,16,15,5,12,13,5,5,
13,5,5,11,11,15,5,5,5,15,5,5,5,15,5,15,5,5,5,5,5,5,5,
5,5,5,15,5,15,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,15,5,5,5,5,16,5,5,5,5,5,5,5,15,5,15,15,5,
15,15,15,15,5,12,5,13,5,12,11,5,5,5,5,15,5,5,15,5,15,
15,15,5,5,16,5,5,5,5,15,5,5,15,5,15,1,15,1,5,15,5,5,
15,12,5,5,5,5,5,15,5,12,11,5,5,15,15,5,1,5,1,5,13,5,
5,5,5,12,15,15,5,15,15,5,5,15,15,15,12,5,5,16,5,5,12,
5,12,5,5,5,5,5,16,5,15,5,5,16,5,5,5,15,5,15,5,15,5,
15,15,5,5,16,5,5,5,13,5,5,13,15,5,11,5,15,11,5,5,15,5,
5,15,5,5,5,5,5,5,5,5,5,15,5,15,15,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,15,5,5,15,5,5,16,5,5,15,5,15,5,15,5,
15,15,15,5,16,15,15,13,5,11,11,12,5,15,5,5,13,5,11,16,
16,15,1,15,16,15,15,15,15,15,15,15,15,15,15,15,15,16,15,
16,16,16,15,16,16,16,15,15,15,15,15,16,5,5,16,5,5,5,5,
5,5,5,5,15,5,15,15,5,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,16,12,15,15,15,5,11,5,15,5,15,15,5,5,16,5,5,12,
12,5,5,15,12,5,11,5,15,5,5,5,15,16,5,5,5,5,5,5,15,5,
1,15,1,15,11,12,5,5,5,11,12,11,5,15,5,5,5,12,5,15,15,
5,5,5,5,5,5,15,5,15,15,5,15,15,5,13,16,5,11,12,11,5,5,
5,5,5,5,12,5,15,5,11,5,5,5,15,5,15,16,5,5,1,3,1,15,
16,16,16,14,16,5,15,5,19,14,16,15,5,5,5,5,5,15,5,15,15,
13,5,3,3,1,16,15,16,16,14,5,16,5,5,14,14,16,5,16,5,16,
5,15,5,16,15,5,15,16,5,5,5,5,5,5,15,11,5,15,13,13,5,5,
15,5,5,5,15,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,16,15,15,5,15,15,1,5,15,15,15,12,5,5,5,15,11,11,12,
13,15,5,5,16,5,15,5,15,15,5,5,5,16,5,11,11,15,11,5,5,
11,13,12,5,13,5,5,16,16,16,15,15,16,1,3,1,15,5,16,16,
19,15,15,16,16,14,19,16,15,5,15,15,16,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,16,15,15,15,1,15,15,16,15,15,16,15,15,
15,15,16,16,15,15,15,15,15,5,16,15,5,16,11,5,11,15,5,5,
11,12,12,5,5,13,15,15,15,16,15,15,16,15,15,15,16,15,16,
16,16,15,15,15,15,15,15,16,15,15,16,16,16,15,16,15,15,15,
15,16,15,5,15,16,15,12,5,15,5,15,5,12,5,5,5,5,5,12,5,
14,5,5,5,12,12,5,5,16,5,5,5,12,5,5,16,16,15,15,16,14,
16,14,14,16,5,15,5,15,14,16,5,15,14,14,14,14,5,16,5,16,
14,5,16,5,14,14,13,14,5,5,16,5,12,15,11,5,5,5,5,11,11,
12,12,12,11,5,5,5,5,12,11,12,5,5,11,12,12,11,5,5,5,5,
11,12,12,12,5,5,5,12,11,11,12,5,5,5,5,5,5,11,12,11,5,
5,12,11,12,5,12,11,11,11,12,11,5,5,5,5,5,5,5,5,5,15,
15,5,5,5,15,5,5,5,15,15,15,5,5,5,5,5,5,5,5,5,15,15,
15,15,15,15,11,5,5,11,12,12,5,5,12,5,12,5,5,5,5,5,5,5,
16,5,5,5,15,5,15,5,16,5,3,5,5,5,5,5,5,5,5,5,5,5,5,
15,15,3,12,5,5,12,11,11,12,5,11,5,11,12,5,5,5,5,5,5,5,
5,5,5,5,5,16,5,5,3,5,5,5,5,5,5,5,5,15,5,16,5,15,3,5,
12,5,12,5,11,11,12,5,11,5,13,5,5,5,5,16,5,5,5,5,5,5,
5,5,5,15,15,5,5,5,5,15,5,5,5,5,15,5,16,15,15,15,5,5,
5,5,11,12,5,5,12,5,12,12,5,5,16,5,5,5,5,5,5,5,5,5,3,
15,5,5,5,5,5,5,15,5,5,16,5,5,15,3,5,5,12,12,5,11,13,
5,5,11,5,13,5,5,5,16,5,5,5,15,5,16,5,5,15,15,5,5,5,5,
5,5,5,5,5,5,5,5,15,15,15,5,5,5,5,12,12,12,5,11,12,11,
12,5,5,5,5,5,5,5,5,5,5,1,15,5,5,5,5,5,5,5,5,5,5,5,
5,15,15,1,5,12,5,13,11,15,5,5,11,5,11,12,5,5,5,5,5,5,
5,5,5,3,15,5,15,5,5,5,5,5,15,5,16,5,16,15,16,5,5,16,
12,15,12,13,5,11,13,5,13,5,5,5,5,5,15,16,5,16,15,16,5,
5,5,5,5,5,5,5,5,5,5,5,16,15,3,12,5,5,16,13,13,12,5,
11,13,11,5,5,5,15,5,16,5,5,16,15,5,5,5,5,5,5,5,5,5,5,
5,5,3,15,5,5,12,5,5,13,13,5,5,11,12,11,5,5,5,5,5,16,
5,5,15,5,5,15,5,15,5,5,5,15,5,15,5,15,15,5,5,5,12,5,
12,11,12,12,12,12,12,5,5,5,5,5,5,5,16,5,5,5,5,5,5,5,
5,5,5,5,5,1,15,5,13,5,5,5,15,11,12,5,11,12,11,5,15,16,
5,16,15,16,5,5,5,5,5,5,5,5,5,5,5,5,16,15,15,12,15,5,
15,13,16,12,5,11,13,11,5,5,5,16,5,15,5,5,5,5,5,5,5,5,
5,5,5,5,15,15,15,11,5,5,11,11,11,12,5,11,11,11,11,5,5,
16,16,5,5,5,5,5,5,5,5,5,5,5,5,3,15,15,5,13,5,5,16,13,
5,5,12,15,12,5,5,5,3,15,5,5,5,12,15,5,5,16,5,16,5,15,
16,5,15,5,12,5,12,11,16,11,11,15,13,5,5,1,5,5,5,5,5,5,
5,5,5,5,5,5,16,15,16,15,11,5,15,13,13,5,5,12,16,12,13,
15,5,5,5,5,5,5,5,15,5,16,5,12,1,1,1,5,1,16,16,19,15,
12,5,12,16,19,16,15,15,16,15,15,15,15,15,15,15,16,15,1,
1,1,4,15,15,15,16,16,16,15,16,16,16,15,5,16,5,3,5,5,5,
16,5,5,5,16,15,5,5,5,5,5,13,11,5,12,13,12,11,5,5,5,5,
5,16,5,5,16,5,5,15,15,15,5,12,12,5,11,12,5,12,12,5,12,
5,5,19,16,5,5,16,5,16,5,15,16,5,5,5,12,5,13,11,5,12,
13,16,13,5,3,5,5,5,5,5,5,5,15,15,5,5,5,12,5,11,11,5,
12,15,5,15,5,15,16,1,1,5,15,3,1,1,3,5,5,15,14,14,11,5,
4,1,14,16,14,5,5,15,5,16,5,15,15,5,11,5,12,5,11,11,11,
11,11,11,11,5,16,5,16,5,16,15,15,3,5,15,11,16,11,12,5,
12,13,5,12,13,5,15,5,16,15,15,3,5,12,12,13,11,19,5,13,
19,5,19,13,5,5,5,15,15,5,5,5,15,5,13,11,11,16,12,12,12,
5,5,5,15,3,13,5,16,15,12,11,13,5,5,16,5,16,12,5,15,1,
5,13,5,16,5,13,12,12,5,13,11,13,5,15,15,16,5,5,5,12,11,
13,5,16,16,5,13,12,15,15,15,16,15,15,1,15,16,15,16,16,
16,15,15,15,15,4,15,16,16,15,16,16,15,16,15,14,15,5,4,
13,16,16,16,15,12,12,4,5,12,11,12,11,5,5,11,11,12,11,12,
12,12,12,5,11,12,11,11,12,5,12,12,12,11,12,11,12,5,11,
12,12,11,11,5,11,5,15,12,12,15,12,15,11,12,12,15,12,15,
12,11,11,11,12,12,12,13,12,11,12,15,12,12,11,12,5,5,5,5,
5,15,16,5,5,5,15,5,5,15,15,5,16,5,5,5,5,5,5,5,5,5,15,
15,15,15,5,15,13,11,5,12,11,5,12,5,5,5,12,15,5,5,5,5,
15,15,5,5,5,15,5,5,16,5,15,16,5,5,5,5,5,5,5,5,5,15,
16,5,15,16,15,12,5,12,5,5,12,15,5,11,5,15,12,5,5,5,16,
5,5,5,5,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,15,15,15,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,5,5,15,5,
5,5,5,16,5,5,5,5,5,5,5,5,5,5,16,15,5,5,16,5,5,12,15,
5,12,15,12,5,5,5,12,5,5,15,16,5,5,5,15,5,16,5,5,5,5,
5,5,5,5,5,5,15,5,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,15,5,5,5,5,15,5,5,5,5,16,5,5,5,5,5,5,5,5,5,5,
15,15,15,5,15,16,11,13,5,15,5,12,5,5,5,11,5,12,15,15,
15,15,15,15,15,15,15,16,15,15,15,15,15,16,15,15,15,15,1,
15,1,15,15,16,15,16,15,15,15,15,15,15,16,15,16,16,5,5,
15,15,5,1,5,1,12,15,5,15,15,5,5,15,15,5,5,15,15,5,15,
5,16,16,5,5,16,15,12,13,5,5,5,5,5,5,5,16,5,15,5,5,16,
15,5,5,5,5,15,5,5,5,15,15,15,5,16,15,5,5,15,12,5,15,
12,5,5,12,12,5,11,5,15,5,5,16,5,5,5,5,5,5,5,5,5,5,5,
16,15,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,15,15,
15,5,16,5,5,15,5,15,5,5,5,15,15,15,5,16,5,15,15,5,5,
11,12,5,12,11,5,15,5,5,15,16,15,1,16,15,15,15,15,15,15,
15,15,15,15,15,15,15,16,15,15,15,15,15,15,16,16,16,15,15,
15,15,15,5,5,15,5,5,5,5,5,5,5,5,5,5,15,15,15,15,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,13,5,15,5,5,5,12,5,5,
15,5,15,15,5,16,5,5,11,12,5,5,16,12,5,11,11,15,5,5,5,
5,16,5,5,5,5,5,5,5,15,1,15,1,5,5,14,12,15,5,13,12,5,
5,16,5,5,11,13,11,5,16,5,5,5,5,15,5,5,5,15,15,15,5,12,
5,13,16,5,11,12,11,5,5,5,5,5,5,12,5,5,5,5,15,5,5,5,5,
5,15,15,5,3,3,1,5,16,16,14,16,16,15,15,5,19,16,16,15,5,
12,5,5,5,5,5,15,15,16,5,1,3,3,16,5,14,14,14,5,16,15,5,
14,14,14,5,15,5,15,5,15,5,16,15,15,5,16,5,5,5,12,5,5,
12,5,11,12,15,13,11,5,5,5,5,5,16,5,5,16,15,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,13,15,5,5,1,15,1,5,16,5,15,
5,5,5,5,5,11,11,12,12,16,5,5,16,5,15,5,5,15,15,5,5,16,
5,11,5,12,5,5,5,5,15,12,11,13,5,5,16,16,16,16,15,16,3,
1,1,5,15,16,14,14,5,15,16,16,14,14,16,15,5,5,15,15,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,16,15,1,5,5,16,5,
12,15,16,5,5,5,15,13,15,5,15,5,15,15,16,5,5,16,5,12,5,
12,5,5,5,12,13,5,12,13,15,15,15,15,12,5,5,5,12,5,13,5,
15,15,5,16,5,5,15,15,15,16,16,15,16,15,15,15,15,15,15,
16,15,16,16,15,15,16,15,15,15,16,15,16,15,16,15,15,15,15,
15,5,5,16,15,5,5,16,5,15,5,16,15,5,12,13,5,5,14,14,5,
15,16,14,14,14,14,16,5,5,5,19,16,16,15,15,16,16,14,16,5,
16,5,14,14,5,16,15,16,14,14,16,5,15,16,5,11,12,12,5,5,
5,5,12,11,12,13,11,12,5,5,5,5,11,12,12,5,5,12,13,11,12,
5,5,5,5,12,11,12,11,5,5,5,13,12,11,13,5,5,5,5,5,5,11,
13,12,5,5,11,12,13,5,12,12,11,11,13,12,5,5,5,5,5,5,5,
3,3,5,5,5,5,5,5,3,3,5,3,5,5,5,5,5,5,5,5,5,5,3,3,5,
3,3,15,5,11,11,5,5,3,5,5,5,11,11,5,5,5,3,3,5,5,5,5,
5,5,3,3,5,3,5,5,5,5,5,5,5,5,5,5,3,3,5,3,3,15,5,11,
11,5,5,3,5,5,5,11,11,5,5,15,3,5,5,5,5,5,5,5,15,3,3,
5,5,5,5,5,5,5,5,5,15,5,5,5,3,3,11,11,11,11,5,11,11,5,
5,5,11,11,5,5,7,5,5,5,5,5,3,5,3,3,3,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,3,11,11,5,15,5,11,11,5,5,5,5,3,5,7,5,
5,5,5,5,3,5,3,3,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,11,
11,5,15,5,11,11,5,5,5,5,3,3,5,5,5,5,5,5,5,15,3,3,5,
5,5,5,5,5,5,5,5,3,3,3,5,3,3,11,15,12,11,5,5,16,5,5,
5,12,11,3,15,3,3,3,3,15,3,3,3,15,3,15,15,15,3,3,3,15,
3,3,3,15,15,7,3,3,15,4,15,3,4,15,15,15,15,7,5,5,15,5,
15,5,3,15,3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,11,11,5,
11,11,11,11,5,5,11,5,11,5,5,5,5,15,3,5,3,5,5,5,5,5,5,
5,5,15,5,5,5,5,5,15,11,5,5,11,5,5,11,5,5,5,5,11,3,5,
5,5,7,5,3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,15,5,5,11,
11,5,15,5,5,11,5,11,3,15,5,3,15,3,5,5,5,5,5,5,5,5,5,
5,5,5,3,5,3,16,5,5,11,12,15,11,5,5,12,5,11,5,5,7,5,3,
5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,15,5,5,11,11,5,15,5,5,
11,5,11,5,3,15,3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,11,
12,5,11,15,12,11,5,5,5,5,15,3,5,3,5,5,5,5,5,5,5,5,3,
5,3,3,5,11,15,12,5,11,11,5,5,16,5,5,5,11,11,15,7,3,15,
3,15,15,3,15,3,3,15,3,3,3,15,3,4,15,15,3,3,15,4,15,15,
3,15,4,3,5,5,5,5,5,5,5,5,5,11,5,5,3,3,3,11,3,11,15,
11,15,11,5,5,11,11,15,3,15,3,3,3,3,15,3,3,15,3,3,3,3,
3,3,1,3,4,3,1,7,1,1,3,3,3,5,15,5,15,5,5,5,15,5,5,5,
15,5,3,11,5,5,11,11,5,11,11,11,11,5,11,5,5,5,5,15,5,5,
15,5,5,5,5,3,11,5,5,11,5,5,11,5,5,5,5,11,5,15,3,5,3,
15,5,3,3,15,5,3,11,5,5,16,5,5,11,12,12,15,5,11,3,5,5,
5,5,5,5,5,5,15,3,11,5,11,11,5,5,11,11,11,5,11,11,3,11,
3,15,5,3,3,15,3,3,11,5,11,15,11,5,11,15,3,12,11,15,3,
5,5,5,15,15,5,5,3,11,5,5,15,5,5,11,11,11,5,5,15,3,5,
15,3,3,5,5,3,11,5,5,16,5,5,11,11,11,5,5,11,5,5,15,15,
5,5,3,11,5,5,15,5,5,11,11,11,5,5,15,5,5,5,11,5,15,12,
5,5,11,11,5,11,15,5,11,5,11,5,5,5,3,3,11,11,5,12,5,11,
11,5,5,5,15,11,5,5,3,3,13,5,15,13,5,5,12,15,5,5,5,13,
5,3,3,13,5,15,13,5,5,12,15,5,5,5,13,5,3,15,11,5,11,3,
11,15,12,11,15,5,11,3,15,11,3,11,5,11,15,11,11,5,15,11,
4,3,1,3,1,3,3,3,3,1,1,7,11,13,11,13,11,3,11,11,13,12,
4,11,13,10,5,11,5,5,11,10,12,11,5,10,12,11,10,5,5,11,
11,12,4,13,13,11,11,3,10,12,10,11,5,5,11,11,5,5,10,11,
13,11,11,13,13,11,5,11,10,13,10,10,12,5,11,11,5,5,5,3,
3,5,5,5,5,5,5,3,3,5,3,5,5,5,5,5,5,5,5,5,5,3,3,5,3,
3,15,5,11,11,5,5,3,5,5,5,11,11,5,5,15,15,5,5,5,5,5,3,
3,5,3,3,5,5,5,5,5,5,5,5,5,3,3,5,5,3,5,11,11,15,5,5,
11,11,5,5,5,3,5,5,15,15,5,5,5,5,5,3,3,5,3,3,5,5,5,5,
5,5,5,5,5,3,3,5,5,3,5,11,11,15,5,5,11,11,5,5,5,3,5,
5,5,5,5,5,5,5,5,15,5,3,3,5,5,5,5,5,5,5,5,5,5,15,5,
5,3,3,11,11,11,11,5,11,11,5,5,5,11,11,5,5,5,5,5,5,3,
3,3,3,3,5,5,5,5,5,5,5,5,5,3,3,3,5,3,3,13,15,12,15,5,
5,13,5,5,5,13,5,5,5,5,5,5,3,3,3,3,3,5,5,5,5,5,5,5,
5,5,3,3,3,5,3,3,13,15,12,15,5,5,13,5,5,5,13,5,5,5,15,
5,15,3,5,15,3,5,5,5,5,5,5,5,5,5,5,15,5,3,3,5,11,11,
11,5,11,11,11,5,5,11,11,5,5,5,5,5,7,5,5,3,5,5,5,5,5,
5,5,5,3,5,3,5,3,3,5,15,5,11,5,11,5,15,5,5,11,11,5,5,
5,5,7,5,5,3,5,5,5,5,5,5,5,5,3,5,3,5,3,3,5,15,5,11,
5,11,5,15,5,5,11,11,5,15,15,3,3,15,3,5,5,5,5,5,5,5,5,
5,5,15,5,11,15,5,12,5,11,5,11,15,11,5,5,11,11,5,5,3,
15,5,3,5,5,5,5,5,5,5,5,5,5,15,5,5,15,5,11,5,11,5,5,
5,11,5,5,5,11,5,3,5,15,3,5,5,5,5,5,5,5,5,5,5,15,5,3,
3,5,11,12,11,5,15,12,11,5,5,5,16,5,3,15,7,3,15,3,3,15,
3,15,15,3,15,3,15,3,3,15,4,15,3,15,3,15,4,15,15,3,4,
15,5,3,5,5,5,5,5,5,5,5,5,5,15,5,5,15,11,16,5,11,11,5,
5,12,5,5,5,11,11,3,5,5,5,5,5,5,5,5,5,11,15,5,3,3,3,
11,3,15,12,12,15,11,5,5,11,15,11,3,15,3,3,3,3,15,3,3,
15,7,3,3,3,3,7,3,3,3,3,3,7,3,3,3,7,3,5,15,5,15,5,5,
5,15,5,3,5,15,3,5,11,5,11,5,11,5,11,11,11,11,11,5,5,5,
5,5,15,5,5,15,3,5,5,3,5,11,5,11,5,5,5,11,5,5,5,11,5,
3,15,3,5,5,15,5,3,5,15,3,5,11,5,16,5,5,5,11,12,12,15,
11,5,3,5,5,5,5,5,7,5,5,3,5,11,5,15,5,5,5,11,11,11,5,
15,5,3,11,3,15,5,3,3,15,3,3,11,5,15,11,11,5,11,15,3,
11,15,11,5,5,5,5,7,5,5,3,5,11,5,15,5,5,5,11,11,11,5,
15,5,15,5,15,3,3,5,3,3,11,5,11,15,5,5,11,11,11,5,11,5,
5,5,3,15,5,3,15,11,5,11,11,5,5,11,11,11,5,11,11,5,3,5,
15,3,5,16,5,11,5,12,5,11,15,5,12,11,5,3,5,5,3,5,11,11,
12,5,5,11,11,5,5,5,15,5,3,15,7,15,4,15,4,15,15,15,3,3,
3,15,4,15,5,3,15,16,5,11,12,5,5,11,15,5,5,11,12,3,5,
15,11,11,5,3,11,15,11,11,15,11,5,3,3,3,3,1,1,3,4,3,3,
1,7,1,15,11,11,3,5,11,15,11,11,5,11,15,11,15,12,12,11,
15,11,11,13,15,13,12,10,10,5,11,5,5,11,13,10,11,11,13,
11,13,12,11,3,11,5,11,13,10,10,5,11,5,11,13,10,10,5,11,
5,11,5,5,10,12,10,11,11,12,4,12,5,10,12,10,11,13,11,11,
5,11,5,5,7,5,5,5,5,5,5,5,5,5,3,5,5,5,5,5,5,5,5,5,5,
3,5,3,5,3,3,5,15,11,11,5,3,5,5,5,5,11,11,5,3,15,5,5,
5,5,5,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,7,5,5,5,5,5,5,5,5,5,3,5,5,5,
5,5,5,5,5,5,5,3,5,3,5,3,3,5,15,11,11,5,3,5,5,5,5,11,
11,3,3,3,15,3,3,3,3,3,3,15,15,3,15,3,15,15,3,3,15,3,
15,3,15,4,4,15,3,3,3,15,3,15,15,15,15,3,3,5,5,5,5,5,
3,3,3,5,15,5,5,5,5,5,5,5,5,5,5,5,15,5,3,3,12,5,15,
15,5,5,12,5,5,5,5,5,5,5,15,5,15,5,5,15,5,5,5,5,5,5,
5,5,5,5,5,5,15,15,5,5,5,11,5,5,11,11,5,5,5,11,5,5,5,
3,5,5,15,15,5,5,5,5,5,5,5,5,5,5,3,5,5,3,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,5,5,5,5,
5,5,5,15,15,5,5,11,5,5,5,11,5,11,5,5,11,5,5,3,15,3,3,
15,5,5,5,5,5,5,5,5,5,5,5,5,15,11,5,5,5,5,5,5,11,15,
5,5,5,11,5,5,5,15,15,5,5,5,5,5,5,5,5,5,5,3,5,5,3,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,11,5,5,5,5,5,5,5,5,
5,5,5,5,15,15,5,5,5,11,5,5,15,11,5,5,5,5,5,5,5,5,3,
5,5,5,5,5,5,5,5,3,5,3,3,5,11,11,3,5,11,11,5,5,3,5,5,
5,11,11,5,3,5,5,5,5,5,5,5,5,3,5,3,3,5,11,11,3,5,11,
11,5,5,3,5,5,5,11,11,5,5,5,5,5,5,5,5,5,5,15,5,15,3,
3,3,5,3,15,15,11,15,5,5,5,11,15,15,5,5,5,5,5,5,5,5,5,
5,15,15,3,3,3,3,5,15,15,11,5,16,5,5,11,15,15,5,15,5,
15,5,5,5,15,5,5,3,15,5,5,5,5,5,5,11,5,5,11,11,11,5,5,
5,5,5,5,15,5,5,15,5,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,11,15,5,5,15,5,3,3,15,5,5,5,5,5,5,5,5,5,11,11,15,
5,5,3,5,3,5,5,5,5,7,5,15,15,5,5,11,11,5,5,5,3,15,5,
11,11,5,15,3,15,5,5,3,15,3,3,5,5,15,15,11,5,5,16,3,11,
15,15,5,5,5,5,15,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,
5,15,5,3,5,3,3,5,5,15,15,5,5,5,12,12,5,5,5,5,5,5,7,
5,15,15,5,5,11,11,5,5,5,3,15,5,11,11,5,5,3,11,5,5,5,
5,5,5,11,5,5,15,5,11,5,5,5,3,5,3,3,5,12,5,5,5,12,5,
5,5,5,15,15,3,5,3,3,12,5,15,15,5,5,12,5,5,5,5,5,15,4,
4,15,15,3,3,15,15,15,3,3,15,3,3,5,5,11,11,5,5,15,11,
11,11,11,15,5,5,5,3,3,3,3,5,3,3,3,15,5,15,15,3,3,3,3,
5,3,3,3,15,5,15,15,5,11,11,10,5,5,5,5,11,12,12,12,12,
10,5,5,5,5,10,11,11,5,5,11,12,12,11,5,5,5,5,11,12,12,
11,5,5,5,10,10,10,10,5,5,5,5,5,5,10,12,12,5,5,10,11,
11,5,10,11,11,10,12,12,5,5,5,5,15,15,5,5,5,5,5,3,3,5,
3,3,5,5,5,5,5,5,5,5,5,3,3,5,5,3,5,11,11,15,5,5,11,
11,5,5,5,3,5,7,5,5,5,5,5,5,5,5,5,3,5,5,5,5,5,5,5,5,
5,5,3,5,3,5,3,3,5,15,11,11,5,3,5,5,5,5,11,11,15,15,
15,15,15,15,15,15,15,7,15,15,15,15,15,15,15,15,15,15,7,
15,3,15,7,3,15,16,16,3,15,16,15,15,15,15,16,16,5,5,5,5,
5,3,3,3,3,3,5,5,5,5,5,5,5,5,5,15,5,5,5,3,3,12,11,11,
15,5,11,12,5,5,5,16,5,5,5,15,5,15,15,5,3,5,5,5,5,5,5,
5,5,5,3,3,5,5,3,3,5,5,15,11,5,11,15,5,5,5,11,11,5,5,
15,5,15,15,5,3,5,5,5,5,5,5,5,5,5,3,3,5,5,3,3,5,5,15,
11,5,11,15,5,5,5,11,11,5,5,5,5,5,5,3,15,5,5,5,5,5,5,
5,5,5,15,5,5,3,3,5,11,11,11,5,11,11,11,5,5,11,11,5,3,
15,15,3,3,5,5,5,5,5,5,5,5,5,5,15,5,5,11,15,5,5,12,11,
5,11,15,5,5,5,11,11,5,5,5,15,3,5,5,5,5,5,5,5,5,5,5,
15,5,5,5,15,5,5,11,11,5,5,11,5,5,5,5,11,5,5,5,3,3,5,
5,5,5,5,5,5,5,3,3,3,5,3,3,5,5,13,13,5,15,12,15,5,5,
5,13,5,5,3,3,5,5,5,5,5,5,5,5,3,3,3,5,3,3,5,5,13,13,
5,15,12,15,5,5,5,13,5,3,3,5,5,5,5,5,5,5,5,5,15,5,5,
5,15,11,15,11,11,11,5,12,5,5,5,5,11,11,3,3,3,15,3,3,
15,3,3,3,7,15,3,3,3,3,3,7,3,3,3,7,3,3,3,3,3,3,5,5,
5,5,5,5,5,5,5,15,11,5,3,3,3,3,11,15,12,11,11,15,5,5,
11,15,11,5,15,5,15,5,5,5,15,3,5,5,15,3,5,5,11,11,5,11,
11,5,11,11,11,11,5,5,5,3,5,15,5,5,7,5,5,5,3,5,5,11,
15,5,5,11,5,11,11,5,15,5,5,11,15,5,5,15,3,3,5,15,3,5,
5,11,12,5,5,11,5,11,11,15,11,5,3,5,15,5,5,7,5,5,5,3,
5,5,11,15,5,5,11,5,11,11,5,15,5,5,3,3,15,3,5,3,15,3,
3,5,11,15,11,11,11,5,15,3,12,15,12,5,5,5,3,15,5,5,3,5,
5,11,11,5,5,11,5,5,5,5,11,5,3,5,3,5,3,5,3,3,5,11,11,
15,5,11,5,12,12,5,15,5,5,3,5,15,5,3,15,5,11,11,11,5,
11,5,11,11,5,11,11,3,5,5,15,3,5,5,16,11,5,12,11,5,15,
5,12,11,5,3,3,15,7,15,15,4,4,15,15,3,15,3,3,15,4,15,5,
5,3,5,11,11,16,5,5,11,11,5,5,5,12,5,5,3,15,5,16,11,12,
5,11,5,15,5,5,11,12,3,5,11,15,11,5,3,15,12,12,11,15,11,
5,3,3,3,7,3,3,3,3,3,3,3,7,3,12,15,11,3,5,15,11,11,11,
5,11,15,11,13,11,11,11,5,5,5,11,13,10,11,13,13,15,11,11,
11,12,15,12,11,11,15,12,12,13,11,15,11,5,13,10,11,11,5,
11,5,12,10,10,11,5,11,5,11,11,11,13,11,13,5,5,11,13,11,
5,11,13,11,10,12,10,11,5,11,5,7,5,5,5,5,5,3,5,3,3,3,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,11,11,5,15,5,11,11,5,
5,5,5,3,15,5,5,5,5,5,15,5,5,3,3,5,5,5,5,5,5,5,5,5,
3,3,3,5,15,5,15,15,12,5,5,5,5,5,5,5,12,5,15,15,15,15,
15,7,15,3,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,
15,3,16,16,15,3,15,18,18,15,15,15,15,3,5,5,15,5,7,5,5,
15,15,5,5,5,5,5,5,5,5,5,5,5,5,3,5,5,11,11,5,5,15,11,
11,5,5,3,5,5,5,5,5,3,15,5,5,5,5,5,5,5,5,5,5,5,15,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,7,5,5,15,15,
5,5,5,5,5,5,5,5,5,5,5,5,3,5,5,11,11,5,5,15,11,11,5,
5,3,5,5,3,3,5,3,15,15,5,5,5,5,5,5,5,5,5,5,5,5,15,5,
5,5,5,5,5,12,15,15,5,5,12,5,5,3,5,15,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,3,4,
4,3,3,3,15,15,3,15,15,3,3,3,15,3,15,15,3,3,15,15,3,3,
3,15,15,3,15,15,5,3,3,5,5,5,5,5,5,5,5,3,3,3,5,5,15,
5,5,5,12,5,5,15,15,5,5,5,12,5,3,3,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,15,15,15,5,12,5,5,5,5,5,5,5,12,5,5,5,5,5,
5,5,5,5,5,11,11,5,3,3,3,3,3,3,3,15,15,15,5,5,3,3,3,
5,5,5,5,5,5,5,5,5,11,11,5,3,3,3,3,3,3,3,15,15,15,5,
5,3,3,3,5,15,5,15,5,5,5,15,5,5,5,15,5,5,5,5,5,5,11,
5,5,11,11,11,5,5,3,5,5,5,15,5,5,15,15,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,11,3,5,5,15,3,3,5,15,5,5,5,5,5,
5,5,5,5,11,11,15,5,5,15,5,5,5,5,5,5,5,5,15,5,5,5,11,
5,5,5,5,11,11,5,11,5,5,11,15,15,5,5,15,15,3,3,5,5,11,
11,11,5,5,15,15,11,11,11,15,5,5,15,15,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,3,5,15,15,3,5,5,3,5,5,5,3,5,5,5,11,
11,5,5,5,5,5,5,15,5,5,15,5,5,5,11,5,5,5,11,11,5,5,11,
5,5,5,11,5,5,5,5,5,5,11,5,5,15,5,11,5,5,5,5,5,3,5,
11,11,3,5,5,11,11,5,5,5,3,5,5,5,3,5,11,11,3,5,5,11,
11,5,5,5,3,5,5,5,11,5,5,5,11,5,5,5,15,5,5,5,11,5,5,
15,15,5,5,3,15,15,11,11,15,5,5,5,15,15,3,5,5,15,15,11,
11,5,16,5,15,15,5,3,5,15,15,11,11,5,5,16,5,12,11,11,5,
5,5,5,12,11,12,12,11,11,5,5,5,5,12,11,12,5,5,11,11,10,
10,5,5,5,5,12,12,11,10,5,5,5,12,12,10,10,5,5,5,5,5,5,
11,12,11,5,5,11,12,11,5,10,10,10,10,10,10,5,5,5,5,5,5,
5,5,5,5,5,5,3,5,5,5,5,5,5,5,5,5,5,3,5,3,5,15,3,5,
15,12,12,5,3,5,5,5,5,12,12,5,5,5,5,5,3,5,3,3,3,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,3,12,12,5,3,5,12,12,5,5,5,5,
3,5,5,7,5,15,5,15,3,5,5,5,5,5,5,5,5,5,5,5,5,5,3,5,
3,5,15,5,11,11,15,5,5,5,11,5,11,5,5,5,5,15,5,3,5,5,5,
5,5,5,5,5,5,15,5,5,5,5,5,15,5,11,5,11,5,11,5,5,5,5,
5,11,5,5,5,5,5,3,15,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,
11,11,5,11,11,11,11,5,5,11,5,11,7,3,5,3,3,5,5,5,5,5,
5,5,5,5,5,5,5,5,15,5,3,5,3,5,12,12,3,5,5,5,12,5,12,
15,5,15,3,5,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,5,15,5,11,
11,15,5,5,5,11,5,11,5,5,3,3,5,5,5,5,5,5,5,5,5,5,5,5,
3,5,3,15,13,5,13,15,13,5,5,5,5,5,13,5,3,3,5,5,5,5,5,
5,5,5,15,5,15,5,5,11,15,5,12,11,11,5,11,15,5,5,5,11,
11,3,3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,15,13,5,13,15,
13,5,5,5,5,5,13,3,3,3,15,3,3,15,3,3,3,3,15,3,3,3,3,
1,3,3,3,3,7,1,1,1,3,3,4,5,5,5,5,5,5,5,5,5,5,11,5,3,
3,3,3,11,11,15,11,11,15,5,5,11,11,15,5,15,5,15,5,5,5,
15,5,5,5,15,5,3,5,11,5,11,11,11,5,11,11,11,5,11,5,5,3,
5,7,5,5,15,5,15,5,5,3,5,11,5,15,5,11,5,11,11,5,5,15,
5,11,15,5,5,15,5,15,5,15,5,3,5,11,5,12,5,11,5,11,11,
15,5,11,3,5,5,5,5,5,5,5,5,15,3,5,11,11,11,5,11,5,11,
11,5,11,11,5,3,3,15,3,5,3,15,3,3,5,11,11,15,11,11,5,
15,3,11,11,15,5,5,5,5,15,5,5,5,3,5,11,5,11,5,11,5,5,
5,5,5,11,7,5,3,5,3,5,5,3,5,12,5,3,5,12,5,12,12,5,5,
16,5,15,5,15,5,5,3,5,11,5,15,5,11,5,11,11,5,5,15,5,5,
5,11,5,15,5,12,5,11,11,11,5,15,5,11,5,11,5,5,5,3,3,5,
13,5,13,5,12,5,15,5,5,15,12,5,5,3,3,11,11,15,11,5,11,
11,5,5,5,5,12,5,3,3,5,13,5,13,5,12,5,15,5,5,15,12,5,
3,11,15,5,11,3,15,11,11,11,15,5,11,3,12,15,3,11,5,15,
11,11,12,5,15,11,3,3,3,7,3,7,3,3,3,3,3,7,11,10,12,10,
11,5,5,5,10,11,13,12,15,12,3,11,11,11,13,13,11,11,5,13,
10,11,10,5,5,11,11,15,13,13,12,11,11,15,13,11,11,10,5,5,
11,11,11,11,12,12,4,5,5,10,10,12,5,10,10,12,10,11,13,5,
11,11,5,5,5,5,5,3,3,3,3,3,5,5,5,5,5,5,5,5,5,3,3,3,
5,3,3,13,15,12,15,5,5,13,5,5,5,13,5,15,5,15,5,15,5,5,
3,5,5,5,5,5,5,5,5,5,3,3,5,3,15,11,5,5,16,11,5,11,12,
5,5,5,11,11,5,5,5,3,15,15,3,3,5,5,5,5,5,5,5,5,5,3,3,
5,3,11,11,5,5,15,11,5,11,15,5,5,5,11,11,5,5,5,5,5,5,
3,15,5,5,5,5,5,5,5,5,5,15,5,15,15,11,5,11,15,11,5,11,
5,12,5,5,11,11,5,3,15,15,3,3,5,5,5,5,5,5,5,5,5,3,3,
5,3,11,11,5,5,15,11,5,11,15,5,5,5,11,11,5,5,5,15,3,5,
5,5,5,5,5,5,5,5,3,3,5,3,5,11,5,5,15,11,5,5,5,5,5,5,
5,11,5,15,5,3,3,5,5,5,5,5,5,5,5,3,3,3,3,15,13,5,15,
15,12,5,15,12,5,5,5,5,13,5,3,3,3,5,5,5,5,5,5,5,5,3,
3,3,3,3,3,3,12,18,12,11,11,12,18,5,5,11,12,11,3,3,5,5,
5,5,5,5,5,5,3,3,3,3,5,12,11,15,15,12,11,5,5,15,5,5,5,
12,11,3,3,3,15,3,3,15,3,3,3,7,15,3,3,7,3,3,7,4,3,3,
3,3,3,3,3,4,3,5,5,5,5,5,5,5,5,5,15,13,15,3,3,3,3,15,
14,12,11,5,15,5,5,11,14,16,5,15,5,15,5,5,5,15,3,5,3,
15,11,5,5,15,11,5,11,5,5,12,11,11,11,5,5,15,3,5,15,5,
5,3,5,3,5,15,5,5,15,12,5,5,5,5,5,15,5,12,5,5,12,15,5,
5,15,3,3,3,15,11,5,5,15,11,5,5,5,5,11,11,15,11,5,3,5,
5,3,5,3,5,3,5,3,3,5,15,13,15,5,5,5,13,13,5,13,5,5,3,
3,15,3,5,3,15,3,3,5,15,15,12,11,5,5,15,3,12,14,16,5,5,
5,3,15,3,5,11,5,5,15,11,5,5,5,5,5,5,5,11,5,3,5,3,5,
3,5,3,3,5,15,13,15,5,5,5,13,13,5,13,5,5,3,5,3,5,15,
15,5,15,11,11,5,5,5,15,11,5,11,11,3,5,3,12,11,5,5,16,
11,5,12,5,5,15,5,12,11,5,3,3,15,7,3,15,7,3,3,15,3,15,
3,3,15,7,3,3,5,3,3,12,15,16,15,5,5,12,5,5,5,11,5,15,
4,4,15,3,3,3,15,3,15,3,3,15,3,3,11,5,11,16,11,5,15,12,
11,12,11,15,11,5,4,16,16,4,11,11,4,3,3,16,11,7,15,12,
15,3,3,5,3,3,3,12,5,3,15,15,12,11,10,5,15,5,5,11,12,
11,16,15,15,16,15,15,15,16,16,15,3,11,13,11,12,12,11,12,
11,5,13,13,13,11,5,11,5,11,10,11,10,5,11,5,5,5,5,11,13,
13,5,5,10,12,13,15,11,12,13,10,12,11,11,5,3,5,15,15,5,
3,5,3,15,15,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,12,11,5,
15,11,11,12,5,5,16,5,5,5,5,5,3,15,3,5,11,5,5,5,5,5,5,
5,5,15,5,5,5,5,5,15,11,5,5,15,5,5,11,5,5,5,5,5,5,3,
3,5,3,15,18,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,13,5,5,15,
12,15,12,5,5,13,5,5,3,3,5,3,15,18,5,5,5,5,5,5,5,5,5,
5,5,5,3,5,3,13,5,5,15,12,15,12,5,5,13,5,5,3,5,3,5,15,
5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,12,5,5,15,15,5,12,5,5,
5,5,5,3,3,4,4,3,3,3,15,15,3,3,3,3,3,3,3,3,15,3,3,3,
15,3,3,3,3,15,15,3,15,3,3,3,3,5,5,5,5,5,5,5,5,3,3,3,
3,5,13,15,12,5,12,15,5,15,16,5,5,5,13,5,3,4,3,3,3,15,
15,3,3,3,3,3,3,3,3,15,4,4,3,15,4,3,3,4,15,15,3,15,3,
16,5,5,5,5,5,5,5,5,5,11,5,5,3,3,3,3,3,12,16,12,15,15,
5,5,3,3,3,11,11,11,11,11,11,11,11,12,12,15,13,3,3,4,3,
3,16,16,16,11,16,11,11,3,3,4,5,15,5,15,5,5,5,15,5,5,5,
15,5,3,11,5,5,15,11,5,11,11,11,12,5,5,3,5,5,15,15,5,5,
15,5,5,5,5,3,11,5,5,3,5,5,11,5,5,5,5,5,5,12,3,3,3,
15,3,3,3,15,5,3,11,5,5,16,5,5,11,12,12,15,5,5,15,5,5,
5,5,5,5,5,5,15,3,11,5,11,15,5,5,11,11,11,5,12,5,11,11,
15,15,5,5,15,15,3,3,11,5,11,15,11,5,11,15,15,12,11,12,
5,3,5,15,15,3,5,5,3,11,5,5,16,5,5,11,11,11,5,5,5,3,5,
15,15,3,5,5,3,11,5,5,16,5,5,11,11,11,5,5,5,5,5,5,15,
5,5,3,11,5,5,15,5,5,11,11,11,5,5,12,5,5,5,12,5,15,11,
5,5,15,11,5,11,15,5,11,5,5,15,5,5,3,3,12,11,5,15,5,11,
12,5,5,5,16,5,3,5,3,3,12,5,3,3,5,5,12,5,5,5,5,5,5,3,
3,13,5,15,15,5,5,12,15,5,5,5,12,5,3,15,12,5,15,3,16,
14,12,11,15,5,5,3,19,16,3,15,5,12,19,11,12,5,15,5,4,3,
3,7,3,3,4,3,3,3,3,3,16,12,16,12,11,12,11,11,12,12,13,
11,16,11,5,11,5,5,13,13,13,15,5,11,12,11,11,5,5,5,15,
16,15,15,16,15,15,3,11,12,11,10,5,5,5,18,5,5,13,13,13,
11,11,13,12,13,5,11,11,11,10,11,11,5,5,5,5,15,5,15,15,
5,3,5,5,5,5,5,5,5,5,5,3,3,5,5,3,3,5,5,15,11,5,11,15,
5,5,5,11,11,5,15,5,7,5,5,15,15,5,5,5,5,5,5,5,5,5,5,
5,5,3,5,5,11,11,5,5,15,11,11,5,5,3,5,5,7,15,15,3,6,
15,15,15,15,15,15,15,15,15,15,15,15,15,7,15,3,15,16,15,
3,16,16,15,15,15,16,15,16,15,5,15,3,5,5,5,5,5,5,5,5,5,
5,5,5,5,3,5,3,5,15,5,11,11,15,5,5,5,11,5,11,15,15,16,
3,15,15,15,15,15,15,15,15,15,15,15,15,7,15,15,16,16,15,
15,16,16,3,15,15,16,15,15,5,3,3,5,5,5,5,5,5,5,5,3,3,
3,5,3,3,5,5,16,12,5,11,11,15,5,5,11,12,5,3,3,5,5,5,5,
5,5,5,5,5,5,5,5,3,5,3,15,11,5,12,11,16,5,5,5,11,5,12,
15,15,15,15,15,15,15,15,15,18,18,15,15,3,3,3,15,7,3,3,
16,16,15,15,15,15,16,15,5,5,5,5,5,5,5,5,5,5,11,5,3,3,
3,3,11,11,11,15,11,15,5,5,15,11,11,5,15,5,15,5,15,5,15,
15,5,5,3,5,5,5,11,5,5,15,11,5,11,11,15,5,5,15,5,15,5,
15,5,15,15,5,5,3,5,5,5,11,5,5,15,11,5,11,11,15,5,5,5,
11,3,5,5,15,15,3,5,3,5,5,5,11,5,5,12,11,5,11,11,16,5,
5,3,5,5,5,5,5,5,5,3,15,5,5,11,11,5,11,11,5,11,11,11,
11,5,5,15,3,15,15,5,3,3,3,3,5,11,11,11,15,11,5,15,3,
15,11,11,5,5,5,5,15,5,3,5,5,5,11,5,5,11,11,5,5,5,11,
5,5,3,15,15,5,3,3,5,3,5,11,5,15,11,11,5,12,12,16,5,5,
5,5,5,15,3,5,15,5,11,5,11,11,11,5,11,11,11,5,11,5,5,5,
3,3,5,5,13,5,5,13,13,5,15,5,12,15,5,5,5,3,3,5,5,13,5,
5,13,13,5,15,5,12,15,5,5,3,3,5,11,11,15,5,11,11,11,5,
5,12,5,5,15,5,11,5,11,5,11,11,11,5,15,5,11,5,11,3,3,3,
7,3,3,7,3,3,3,3,7,3,3,5,11,15,3,5,11,15,12,11,11,11,
15,5,11,15,5,3,11,15,11,11,11,11,5,15,11,10,10,13,11,5,
5,5,13,10,11,12,12,15,15,11,11,11,15,13,13,5,11,13,11,
11,10,11,5,5,11,13,10,11,11,11,5,5,11,13,13,12,15,11,11,
11,11,11,15,12,12,5,5,13,10,10,5,12,10,11,13,10,10,11,
11,5,5,5,5,7,5,5,3,5,5,5,5,5,5,5,5,3,5,3,5,3,3,5,
15,5,11,5,11,5,15,5,5,11,11,5,3,15,15,3,3,5,5,5,5,5,
5,5,5,5,3,3,5,3,11,11,5,5,15,11,5,11,15,5,5,5,11,11,
5,5,15,15,5,5,5,5,5,5,5,5,5,5,3,5,5,3,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,15,5,15,5,5,5,5,5,5,5,5,5,15,5,5,
5,3,3,5,5,12,15,5,15,12,5,5,5,5,5,5,15,15,3,15,15,15,
15,15,15,15,15,7,15,3,15,16,16,15,3,15,16,15,16,15,3,15,
15,16,16,15,5,3,5,5,5,5,5,5,5,5,15,5,5,5,5,5,11,3,5,
5,11,5,5,5,5,5,5,5,11,5,5,5,5,5,5,5,5,5,15,15,5,5,3,
3,3,5,3,15,11,15,3,5,5,5,15,15,11,5,5,5,5,5,5,5,5,15,
5,15,5,3,3,3,3,5,15,11,15,5,3,5,5,15,15,11,5,15,5,3,
5,5,5,7,5,5,5,15,15,5,5,5,11,5,11,5,5,15,15,11,11,5,
5,5,5,5,15,5,3,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,15,15,3,5,5,3,5,3,5,15,15,5,5,5,5,5,5,5,5,12,12,15,
15,5,3,5,5,5,7,5,5,5,15,15,5,5,5,11,5,11,5,5,15,15,
11,11,5,5,11,3,3,5,5,3,3,3,3,5,5,15,11,15,5,5,3,3,15,
15,11,5,5,3,5,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,
3,15,5,3,5,5,15,5,5,5,15,5,5,5,11,11,5,5,5,3,5,5,15,
5,5,15,5,5,5,11,5,5,5,11,11,5,5,11,3,3,3,4,4,15,15,
15,3,15,3,15,15,3,3,3,3,15,5,5,3,3,5,5,12,5,5,5,12,5,
5,5,15,15,5,5,3,3,5,12,5,15,5,15,5,12,5,5,5,5,5,5,5,
11,5,5,5,11,5,5,5,3,5,5,5,11,5,5,3,3,3,5,3,3,3,15,
15,15,15,5,5,3,3,3,5,3,3,3,15,15,15,15,5,11,11,5,15,5,
11,11,11,11,5,5,15,5,12,10,12,5,5,5,5,12,12,10,11,10,
11,5,5,5,5,12,12,10,5,5,12,11,11,12,5,5,5,5,11,10,10,
11,5,5,5,12,11,11,12,5,5,5,5,5,5,11,11,10,5,5,12,12,
10,5,12,12,11,11,11,10,5,5,5,3,3,5,3,15,18,5,5,5,5,5,
5,5,5,5,5,5,5,3,5,3,13,5,5,15,12,15,12,5,5,13,5,5,5,
5,7,5,3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,15,5,5,11,11,
5,15,5,5,11,5,11,5,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,
3,5,5,12,12,5,5,16,12,12,5,5,3,5,5,5,5,3,5,5,5,5,5,
5,5,5,3,5,3,5,3,3,5,16,5,12,5,12,5,3,5,5,12,12,5,5,
3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,3,3,5,5,12,12,5,3,5,
5,12,5,12,15,5,5,5,5,5,5,5,5,5,11,5,5,3,3,3,11,3,11,
11,15,15,11,5,5,15,11,11,15,15,15,15,15,15,15,15,18,15,
18,15,3,3,3,7,15,16,15,16,15,16,15,15,3,3,3,5,7,5,15,
5,5,5,15,5,15,5,3,5,5,11,5,5,5,15,5,11,11,11,15,5,5,
5,5,5,5,15,5,5,15,5,5,3,5,5,11,5,5,5,11,5,11,5,5,11,
5,5,5,15,7,5,5,3,5,3,5,3,5,5,12,5,5,5,3,5,12,12,12,
3,5,5,3,5,5,5,5,5,5,5,3,15,5,11,5,11,5,11,5,11,11,11,
11,11,5,15,11,3,15,5,15,3,3,3,3,11,5,11,11,15,5,11,15,
3,15,11,11,5,5,15,5,15,5,3,5,5,11,5,5,5,15,5,11,11,11,
15,5,5,15,5,15,5,15,3,5,3,11,5,5,15,11,5,11,11,11,11,
5,5,5,5,5,15,3,5,15,11,5,5,11,11,5,11,11,11,11,5,11,5,
5,5,3,3,5,13,5,15,5,13,5,13,15,5,13,5,5,5,5,3,3,5,11,
11,5,5,12,11,11,5,5,11,15,5,5,3,3,5,13,5,15,5,13,5,13,
15,5,13,5,5,15,5,11,11,5,5,11,11,5,11,15,5,11,5,11,3,
3,3,3,1,1,3,3,3,3,3,7,1,1,5,15,11,3,5,11,11,15,11,11,
11,15,5,15,11,5,3,11,11,15,11,11,11,5,15,11,13,13,15,11,
15,11,11,15,12,12,10,10,13,5,11,5,5,12,10,10,5,11,10,12,
10,11,11,5,5,11,11,12,10,11,11,5,5,12,15,12,13,3,11,11,
11,5,5,13,10,10,11,11,15,13,13,5,13,11,11,12,10,10,11,
11,5,3,15,7,3,15,3,3,15,15,15,15,3,3,3,3,15,3,4,15,4,
15,3,15,3,3,3,15,15,15,3,15,3,15,3,16,3,15,15,15,15,15,
15,15,15,15,15,15,15,7,15,3,15,16,15,3,16,16,3,15,15,16,
15,15,3,3,3,5,5,5,5,5,5,5,5,3,3,3,3,11,12,5,5,15,12,
5,11,15,15,5,5,11,12,5,3,3,3,3,3,15,15,3,3,3,3,3,3,3,
4,15,4,3,3,15,3,3,3,3,15,15,3,15,3,15,15,15,15,15,15,
15,15,15,15,15,15,15,4,3,3,15,7,3,3,16,6,15,15,15,16,
15,15,5,5,5,5,5,5,5,5,5,5,12,5,3,3,3,3,5,11,16,19,15,
16,5,5,14,11,12,15,15,5,18,5,5,3,15,15,5,3,3,5,3,5,5,
5,15,13,15,5,12,13,13,5,5,15,5,15,5,15,5,5,15,5,5,15,
5,5,5,5,5,5,12,15,5,15,5,12,5,5,5,13,3,15,3,15,15,3,
3,3,5,3,5,5,5,5,12,15,5,12,12,15,5,15,3,5,5,5,5,5,5,
5,11,15,5,5,5,11,5,11,15,5,11,12,11,11,5,5,18,3,15,15,
5,3,3,3,3,5,5,11,15,19,15,5,16,3,19,11,12,5,5,5,5,15,
5,11,5,5,5,5,5,5,11,15,5,5,5,11,5,5,3,15,15,5,3,3,5,
3,5,5,5,15,13,15,5,12,13,13,5,5,5,5,5,15,15,5,15,5,5,
5,11,11,15,5,11,16,11,5,11,15,5,3,15,5,5,5,5,5,5,12,
15,5,15,5,12,5,5,5,5,13,15,5,5,11,5,5,13,16,5,15,5,12,
15,5,5,12,15,5,11,5,15,5,11,15,11,5,5,11,5,5,12,5,11,
5,5,5,11,12,15,5,15,15,12,5,11,11,4,3,4,11,11,4,16,16,
16,3,7,11,15,5,11,12,15,5,11,15,11,11,12,11,15,5,3,3,5,
3,3,16,12,12,3,3,5,15,5,11,13,12,15,15,5,5,13,11,13,11,
13,13,16,5,5,5,13,11,13,5,11,15,10,11,10,11,5,5,3,15,
11,11,13,11,5,5,16,12,12,12,12,11,11,15,15,15,16,16,15,
5,5,12,11,11,15,12,10,11,12,11,13,11,3,5,5,15,15,5,5,5,
5,5,5,5,5,5,5,5,5,5,3,5,3,5,12,5,15,15,12,5,5,5,5,5,
5,15,5,3,5,5,5,5,5,5,5,5,3,5,3,3,5,11,5,5,5,11,5,5,
5,15,5,5,5,11,5,15,3,15,15,15,15,15,15,15,15,15,15,15,
15,16,15,16,16,15,15,18,18,15,3,15,15,16,15,16,5,5,5,5,
5,5,5,5,5,5,11,5,5,3,3,3,5,7,11,15,15,7,5,5,5,15,11,
15,5,5,5,5,5,5,5,5,5,5,11,5,3,3,3,7,5,11,15,15,5,7,
5,5,15,11,15,5,15,5,3,5,3,5,15,5,5,15,15,5,15,5,5,5,
11,11,5,5,15,15,11,5,11,5,5,5,5,15,5,5,15,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,15,3,5,15,15,5,3,15,15,5,
15,5,5,5,5,5,5,5,12,12,15,5,15,3,5,5,5,5,5,5,5,5,15,
5,5,5,11,5,5,5,5,11,11,5,11,5,5,15,3,3,5,5,3,3,3,3,
5,5,11,15,15,5,5,7,7,15,11,15,5,5,5,5,15,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,3,3,15,5,3,3,5,3,5,5,5,15,15,5,
5,12,12,5,5,5,15,5,5,15,15,5,15,5,5,5,11,11,5,5,15,15,
11,5,11,5,5,5,11,5,11,5,5,5,11,11,5,5,16,5,11,5,11,5,
5,5,15,5,5,11,5,5,5,11,5,5,5,5,15,5,5,5,15,5,11,5,15,
5,5,5,11,5,5,5,5,5,11,5,11,5,5,5,11,11,5,5,16,5,11,5,
11,5,5,15,15,5,3,3,15,15,15,15,15,5,15,5,11,11,15,5,5,
11,11,11,11,5,15,5,15,15,5,3,3,15,15,15,15,15,5,15,5,
10,11,11,5,5,5,5,12,10,12,10,12,12,5,5,5,5,11,10,11,5,
5,11,10,11,11,5,5,5,5,12,12,12,12,5,5,5,12,12,12,12,5,
5,5,5,5,5,12,10,12,5,5,11,10,11,5,12,11,12,12,10,12,5,
5,5,5,3,3,5,5,5,5,5,5,5,5,3,3,3,5,3,3,5,5,13,13,5,
15,12,15,5,5,5,13,5,3,3,5,5,5,5,5,5,5,5,5,5,5,5,3,5,
3,15,13,5,13,15,13,5,5,5,5,5,13,4,11,11,11,11,11,11,11,
11,13,15,12,11,3,3,3,11,4,16,16,16,16,15,11,11,16,16,16,
5,5,5,5,5,5,5,5,5,3,11,5,3,3,3,3,3,12,12,16,3,15,5,
5,3,3,3,15,15,5,15,5,15,5,15,5,5,5,3,5,5,5,11,5,5,15,
11,5,11,11,12,5,5,5,5,11,3,15,5,15,15,3,5,3,5,5,5,11,
5,5,15,11,5,11,11,15,5,5,5,11,3,15,5,15,15,3,5,3,5,5,
5,11,5,5,15,11,5,11,11,15,5,5,15,5,5,5,5,5,5,5,3,15,
5,5,11,11,5,15,11,5,11,11,5,12,5,5,12,15,15,15,5,15,3,
3,3,5,11,11,11,15,11,5,15,15,12,11,11,3,5,5,5,15,5,3,
5,5,5,11,5,5,15,11,5,5,5,5,5,5,3,15,15,3,3,3,5,3,5,
11,5,15,15,11,5,12,12,15,5,5,5,5,5,15,3,5,15,5,11,5,
11,15,11,5,11,11,5,5,12,15,5,5,3,3,5,5,12,15,5,15,12,
5,15,5,12,5,5,3,5,3,3,5,11,12,12,5,18,12,11,11,11,12,
15,5,5,3,3,5,11,12,15,5,15,12,11,5,5,5,15,5,15,5,12,5,
11,5,11,15,11,5,15,5,5,5,11,3,3,3,4,3,3,7,4,3,3,3,3,
3,3,5,16,19,3,5,15,14,12,11,12,5,15,5,13,15,5,3,15,14,
16,11,11,5,5,15,3,11,11,16,11,5,5,5,13,13,13,12,13,16,
12,11,11,11,14,12,12,5,15,12,11,10,11,5,15,5,15,12,11,
11,11,5,5,15,16,16,16,16,16,15,15,3,11,11,13,11,13,5,5,
13,13,13,5,11,10,11,11,11,10,5,5,5,5,3,5,5,5,5,5,5,5,
5,3,5,3,3,5,11,11,3,5,11,11,5,5,3,5,5,5,11,11,3,5,5,
5,5,5,5,5,5,15,13,15,5,3,3,3,5,3,14,11,12,3,15,5,5,
16,19,12,3,15,3,3,3,3,15,3,3,15,7,3,3,3,3,3,3,4,3,3,
3,7,3,3,3,4,3,5,15,15,3,5,5,5,3,5,3,5,15,15,5,5,5,
12,5,11,5,15,11,16,11,12,5,5,5,5,5,15,5,3,15,3,5,5,11,
5,5,5,11,5,5,5,15,5,5,5,11,5,5,3,3,5,5,3,5,3,5,15,
18,5,5,5,13,5,5,5,15,12,13,15,12,5,3,3,5,5,3,5,3,5,
15,18,5,5,5,13,5,5,5,15,12,13,15,12,5,3,12,3,3,5,3,3,
3,3,3,5,5,14,11,16,5,15,3,3,12,15,11,5,5,3,5,3,5,5,
15,5,5,5,12,5,5,5,15,15,5,5,12,5,15,3,15,3,3,5,11,15,
5,5,11,15,5,5,15,11,11,5,11,5,3,5,3,15,5,11,15,5,5,11,
11,5,5,15,11,12,5,11,11,3,3,3,4,4,15,3,15,3,15,3,15,3,
3,3,3,3,15,3,5,3,3,5,5,12,12,5,5,12,15,5,5,15,15,5,3,
3,4,15,4,15,4,15,3,15,4,3,3,3,4,15,5,11,12,15,5,11,12,
5,5,15,15,5,5,11,12,16,5,3,3,3,5,3,12,16,12,15,15,15,
5,11,4,3,3,11,3,16,16,16,16,11,16,11,12,11,11,15,5,11,
16,11,11,5,11,15,5,13,11,13,5,3,5,5,13,13,11,12,10,12,
15,15,5,5,13,12,11,11,16,12,16,12,13,11,12,11,5,11,15,
10,11,5,11,5,11,15,11,13,5,11,5,15,5,5,11,12,10,15,15,
16,16,15,15,11,12,11,12,12,10,16,5,11,3,5,5,5,5,5,5,5,
5,5,11,5,5,3,3,3,15,3,11,19,16,3,5,5,5,12,11,15,3,15,
3,3,3,3,15,3,3,15,3,3,3,3,4,7,3,3,4,3,3,7,3,3,3,3,
4,5,15,5,3,5,3,15,15,5,5,5,15,5,15,15,5,5,12,11,5,5,
16,11,11,5,12,5,5,5,5,15,5,5,15,5,5,5,5,11,15,5,5,11,
5,5,5,5,5,5,5,11,5,3,3,3,5,15,5,3,15,15,5,18,15,5,5,
13,5,5,5,13,13,15,5,12,3,5,5,5,5,5,5,5,5,15,11,15,5,
11,11,5,5,5,12,11,5,11,11,3,13,3,3,5,3,3,3,3,3,15,5,
11,19,12,5,5,3,3,16,11,14,3,3,5,5,15,5,5,5,15,15,5,5,
12,5,5,5,5,15,5,5,12,3,3,15,3,3,3,5,3,15,5,5,16,15,5,
5,13,12,5,5,12,15,5,3,15,15,5,18,15,5,5,13,5,5,5,13,
13,15,5,12,5,5,15,11,5,12,15,5,5,12,11,5,5,16,5,11,5,
12,5,5,5,15,12,15,11,5,11,5,11,5,5,5,5,15,11,3,5,15,
13,15,5,15,12,5,5,12,5,15,5,5,13,15,3,15,18,5,11,12,11,
5,12,16,11,11,11,12,5,16,15,12,5,3,3,3,3,3,12,15,5,16,
11,16,11,15,11,5,11,12,11,12,5,15,11,16,16,11,3,3,3,3,
3,16,11,11,16,15,15,16,16,15,3,15,15,15,15,16,10,12,11,
15,5,5,5,11,10,12,11,5,11,11,11,10,5,5,11,18,12,13,12,
12,11,11,12,13,13,13,11,5,5,11,5,5,5,13,11,12,5,5,13,
11,13,15,13,11,12,11,11,12,5,16,11,5,5,5,5,5,5,5,5,5,
11,11,5,3,3,3,3,3,3,3,15,15,15,5,5,3,3,3,15,15,5,15,
5,15,5,15,15,5,5,3,3,3,5,3,11,11,15,15,5,11,11,15,11,
11,11,3,5,5,16,3,15,16,5,3,3,3,3,5,3,3,3,15,15,5,15,
3,15,3,3,5,11,15,15,5,15,12,15,5,3,3,3,5,15,11,11,12,
15,5,11,11,15,11,12,3,5,3,5,5,15,5,5,3,3,3,5,3,15,11,
11,15,5,11,11,11,15,12,5,16,3,15,16,5,3,3,3,3,5,3,3,3,
15,15,5,15,3,15,3,3,5,5,5,11,15,5,3,3,3,5,15,11,11,11,
15,5,5,5,11,11,11,3,15,16,5,3,3,3,3,5,3,12,16,12,15,5,
16,3,15,3,3,5,15,5,15,3,3,3,5,3,11,15,11,15,5,11,11,
11,11,15,18,5,5,3,3,3,5,3,12,11,19,16,5,15,5,19,16,12,
11,3,3,7,3,11,7,16,16,16,16,11,11,15,16,16,16,5,3,3,3,
11,15,16,11,11,15,11,5,5,11,12,12,3,3,3,5,4,12,14,11,
15,5,15,5,11,16,19,3,3,3,4,3,3,4,7,3,3,3,4,3,3,3,3,
7,7,3,3,7,3,3,3,3,7,3,3,7,3,4,3,4,3,3,3,3,3,4,3,12,
12,12,15,5,5,5,13,13,13,4,4,4,7,3,3,3,4,4,3,15,15,4,
13,13,13,3,3,3,15,4,13,13,12,3,3,3,16,13,13,12,15,15,
15,15,15,15,16,16,16,5,5,12,12,13,5,12,12,13,13,13,13,
15,15,15,5,3,5,15,15,5,5,15,5,15,5,3,3,3,3,5,11,12,15,
5,15,11,11,15,11,11,5,5,5,5,15,5,5,15,11,5,3,3,3,15,5,
11,11,11,5,15,5,5,11,11,11,3,4,4,3,3,3,5,4,3,3,3,3,3,
5,3,3,3,5,15,3,3,16,12,12,3,3,5,5,5,5,15,5,3,3,3,3,
5,15,11,11,5,15,11,11,11,15,11,5,11,3,15,5,16,3,3,3,3,
3,5,15,15,15,5,15,15,3,15,15,15,11,3,15,5,16,3,3,3,3,
3,5,15,15,15,5,15,15,3,15,15,15,15,5,15,12,15,3,3,3,15,
5,12,16,11,5,15,11,11,11,11,12,5,5,15,15,3,3,3,3,5,11,
15,11,5,15,11,11,11,11,15,5,18,5,3,3,3,3,5,16,12,14,5,
16,15,5,15,12,11,11,5,3,3,3,15,11,11,12,11,11,15,5,5,
11,15,11,3,3,4,3,7,11,16,16,16,11,16,11,15,16,4,16,3,3,
3,4,5,15,14,11,5,16,15,5,11,12,14,3,3,4,3,3,3,7,3,7,
3,3,4,3,3,3,4,3,7,3,3,3,4,3,3,3,4,3,3,3,3,3,3,3,7,
3,3,3,3,7,3,4,3,4,3,7,3,3,4,4,4,13,13,13,5,15,5,5,
12,12,12,15,15,12,16,12,13,3,3,3,15,13,16,12,13,3,3,3,
12,16,13,13,3,3,3,15,5,5,13,13,13,15,15,4,4,4,5,13,13,
13,12,12,13,15,15,15,15,5,15,5,15,5,15,15,5,5,3,5,5,5,
11,5,5,15,11,5,11,11,15,5,5,15,16,7,15,15,15,15,3,15,6,
15,15,16,15,15,15,16,15,3,16,16,16,15,15,3,5,5,5,7,5,5,
5,15,15,5,5,5,11,5,11,5,5,15,15,11,11,5,15,18,3,6,15,
15,3,15,3,3,15,15,15,15,16,15,15,16,7,16,3,3,5,5,15,5,
15,5,3,5,5,11,5,5,5,15,5,11,11,11,15,5,5,3,15,15,5,3,
3,5,3,5,5,5,15,13,15,5,12,13,13,5,5,15,5,5,15,15,5,15,
5,5,5,11,11,5,5,15,15,11,5,11,15,15,15,16,3,15,15,15,
16,15,16,15,15,16,7,16,3,15,5,5,3,3,5,5,12,5,5,15,12,
5,11,11,11,15,5,5,3,3,5,12,5,15,5,11,5,12,11,11,16,5,
5,15,5,11,5,5,5,11,11,5,5,16,11,11,5,11,15,15,15,16,15,
15,7,3,3,16,16,16,15,15,5,11,11,3,5,11,11,11,15,15,11,
15,5,12,11,5,3,11,11,11,15,15,11,5,15,5,10,11,13,5,5,
11,11,12,11,10,11,10,13,5,5,11,11,13,10,10,5,11,10,10,
13,13,11,5,5,11,11,10,12,13,11,5,5,12,12,15,11,15,11,11,
5,11,11,13,11,10,11,11,13,10,11,15,11,13,13,15,12,12,11,
11,5,5,11,3,15,5,15,15,3,5,3,5,5,5,11,5,5,15,11,5,11,
11,15,5,5,3,5,15,5,5,7,5,5,5,3,5,5,11,15,5,5,11,5,11,
11,5,15,5,5,16,3,15,16,5,3,3,3,3,5,3,3,3,15,15,5,15,
3,15,3,3,15,5,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,7,15,15,15,3,15,15,3,15,18,15,3,15,16,15,16,18,15,15,
3,5,15,5,15,5,5,3,5,11,5,15,5,11,5,11,11,5,5,15,15,5,
5,15,5,5,5,5,5,5,12,15,5,15,5,12,5,5,15,15,15,3,15,15,
3,3,15,15,18,15,18,3,15,3,15,5,5,3,5,11,5,3,5,5,5,11,
5,5,5,5,5,5,5,15,5,5,5,12,5,15,5,15,5,5,5,12,5,5,11,
15,5,5,3,15,11,15,15,3,5,5,5,11,15,3,5,5,15,11,15,15,
5,3,5,11,15,5,3,5,15,11,15,15,5,5,3,5,10,10,11,5,5,5,
5,10,11,10,11,12,12,5,5,5,5,11,12,11,5,5,12,10,12,11,5,
5,5,5,12,10,12,12,5,5,5,11,10,11,12,5,5,5,5,5,5,12,11,
12,5,5,11,10,10,5,12,11,12,11,12,11,5,5,5,3,3,5,5,3,5,
3,5,15,18,5,5,5,13,5,5,5,15,12,13,15,12,5,4,15,3,16,
11,4,3,16,3,3,11,11,16,16,16,11,15,16,4,16,16,16,3,3,3,
15,7,15,3,15,15,3,15,15,15,3,15,3,3,3,3,15,15,3,15,15,
3,3,3,5,3,11,11,5,16,12,11,11,12,12,18,5,11,15,5,3,15,
15,5,18,15,5,5,13,5,5,5,13,13,15,5,12,15,3,15,16,3,15,
15,15,15,15,16,15,3,16,3,16,3,15,3,5,3,3,5,5,12,5,5,
15,12,5,11,11,15,15,5,3,3,3,15,3,15,3,15,3,15,3,3,3,3,
3,15,15,5,13,5,5,5,12,5,5,15,16,12,15,5,12,15,15,16,15,
15,15,7,3,3,16,15,6,15,15,5,12,11,3,5,5,11,16,19,15,15,
16,5,16,11,5,3,5,11,12,19,14,15,5,16,5,13,13,13,5,5,11,
3,16,11,11,11,11,11,5,5,11,11,15,10,11,5,5,11,13,12,12,
15,15,5,5,11,13,12,12,15,5,15,11,13,13,13,16,5,5,5,11,
11,16,10,11,3,11,15,11,11,12,16,12,13,16,11,13,15,15,5,
3,3,3,3,3,3,3,3,3,3,3,3,7,3,3,3,3,7,7,3,3,3,5,5,5,
5,7,5,5,3,5,11,5,15,5,5,5,11,11,11,5,15,5,3,5,3,5,3,
5,3,3,5,15,13,15,5,5,5,13,13,5,13,5,5,5,5,7,5,15,15,
5,5,11,11,5,5,5,3,15,5,11,11,5,5,5,15,15,5,5,5,12,5,
12,5,5,16,3,12,12,5,5,5,5,3,5,5,12,15,5,5,12,5,12,12,
5,3,5,5,5,3,5,12,5,3,5,5,5,12,12,12,5,3,5,5,15,15,5,
5,12,12,5,5,5,3,3,5,12,12,15,5,11,11,11,5,3,11,11,15,
15,15,11,5,15,3,3,7,15,15,15,15,15,16,15,16,15,11,11,11,
3,5,11,11,15,15,5,11,15,5,12,10,11,5,5,11,11,11,13,10,
12,10,10,5,5,11,11,11,13,11,11,11,13,13,15,15,11,15,11,
5,10,11,13,13,5,11,5,10,10,13,12,5,11,5,5,11,11,10,12,
10,11,11,11,12,10,15,12,15,13,13,11,13,11,5,11,11,3,15,
5,16,3,3,3,3,3,5,15,15,15,5,15,15,3,15,15,15,3,15,16,
11,7,3,3,3,11,3,16,16,16,11,11,16,3,16,3,4,3,3,3,7,3,
3,3,1,1,3,3,3,1,1,7,3,3,3,3,15,15,3,16,3,3,15,15,16,
15,16,15,15,6,3,16,3,3,5,3,3,3,3,5,3,3,3,15,15,5,15,
3,12,15,12,3,3,3,3,3,5,15,12,12,5,16,15,3,3,3,3,3,3,
3,3,3,3,4,3,3,3,7,7,3,3,4,3,3,16,16,16,15,7,3,3,16,
7,16,3,3,3,3,3,4,3,3,3,3,4,4,3,7,3,3,3,3,4,3,3,3,4,
7,3,3,7,5,13,13,13,5,5,15,3,13,12,12,13,13,13,5,5,15,
3,12,12,12,15,15,12,12,16,4,15,3,3,15,12,12,16,4,15,3,
3,12,12,16,4,15,3,3,5,15,3,13,13,13,15,3,13,13,13,7,16,
4,4,4,4,4,15,15,15,3,5,15,15,3,5,5,3,11,5,5,16,5,5,
11,11,11,5,5,5,5,5,15,15,5,5,3,11,5,5,15,5,5,11,11,11,
5,5,15,5,15,5,15,5,5,5,5,5,5,12,5,15,15,5,12,5,5,15,
5,5,3,5,5,11,5,5,5,11,5,5,5,5,15,5,15,15,3,15,3,15,
16,15,15,15,18,18,3,15,3,15,5,5,15,5,5,5,12,5,5,15,15,
5,5,5,12,5,5,15,11,5,5,7,11,15,15,15,7,5,5,5,15,11,7,
5,5,11,15,15,15,5,7,5,15,11,5,7,5,11,15,15,15,5,5,7,5,
12,11,12,5,5,5,5,12,12,12,10,10,11,5,5,5,5,11,11,10,5,
5,10,11,11,12,5,5,5,5,10,12,12,11,5,5,5,10,12,12,12,5,
5,5,5,5,5,11,10,10,5,5,12,12,11,5,12,12,11,12,12,12,5,
5,5,15,3,15,7,15,15,7,15,3,15,7,15,3,15,4,3,15,15,7,
15,5,3,13,5,15,5,5,5,15,12,15,5,16,12,12,5,5,15,3,15,
3,3,15,3,3,3,15,16,15,16,3,15,3,3,3,5,3,3,12,5,15,15,
5,5,12,11,11,5,5,15,15,3,7,15,3,3,4,15,3,15,4,3,15,3,
3,5,3,11,12,5,15,3,16,11,14,14,3,5,5,3,11,15,3,15,5,
12,11,14,19,5,3,5,3,3,3,7,3,3,3,4,4,3,3,7,5,11,15,11,
5,5,11,11,10,11,11,11,16,11,5,5,11,18,13,13,13,15,5,11,
10,12,13,5,15,5,15,16,16,16,16,15,15,3,11,10,12,12,15,5,
5,5,16,11,13,13,13,11,11,11,11,11,12,11,13,14,12,12,16,
5,5,5,5,5,15,11,5,15,5,5,5,11,11,5,5,16,12,11,5,11,5,
15,5,3,3,5,11,5,16,5,11,5,11,11,5,15,11,15,5,3,3,11,5,
15,11,5,5,11,11,11,5,5,16,15,3,16,15,15,16,16,15,15,15,
7,7,15,3,16,5,15,11,11,5,11,3,11,11,15,15,15,5,11,15,
11,11,3,11,5,11,11,15,15,5,15,11,15,16,15,7,15,3,3,3,
15,15,15,16,5,10,13,11,5,5,11,11,10,11,12,10,13,11,5,5,
11,11,10,10,12,11,5,10,10,12,13,5,5,11,11,12,12,15,15,
11,11,15,10,10,12,13,5,5,11,5,11,11,11,10,13,11,11,11,
10,13,3,13,13,15,12,12,15,5,11,11,5,5,3,3,5,5,13,5,5,
13,13,5,15,5,12,15,5,5,3,3,5,13,5,15,5,13,5,13,15,5,
13,5,5,11,5,11,5,5,5,11,11,5,5,16,5,11,5,11,4,11,16,
16,11,11,4,16,16,16,4,16,15,11,5,3,3,3,5,3,12,12,16,3,
3,15,5,12,11,5,15,11,11,11,16,12,11,5,15,5,13,11,12,5,
5,15,5,12,13,10,13,11,12,5,5,15,5,12,13,11,5,3,11,11,
16,13,11,5,5,11,11,11,15,11,11,5,5,12,13,16,13,12,11,11,
5,15,5,12,11,10,15,5,12,11,10,3,16,15,15,13,13,11,3,11,
5,5,5,3,5,11,11,3,5,5,11,11,5,5,5,3,5,5,3,3,5,13,5,
13,5,12,5,15,5,5,15,12,3,5,11,14,5,5,3,14,11,12,16,3,
15,5,3,3,4,3,3,3,4,3,3,3,3,7,3,12,14,5,3,5,15,11,12,
16,5,15,3,11,11,11,11,11,5,5,5,11,15,10,13,12,13,12,11,
11,3,12,16,11,5,5,13,11,13,13,5,3,5,5,12,11,13,13,5,15,
15,12,10,12,13,15,15,5,11,18,11,12,16,12,5,5,11,15,10,5,
11,15,11,11,15,11,15,5,15,5,3,3,13,5,15,13,5,5,12,15,5,
5,5,13,3,5,14,11,15,5,3,11,19,16,12,3,5,5,3,4,3,7,3,
3,3,4,3,3,3,7,3,19,11,15,3,5,11,19,15,12,5,5,3,11,16,
12,12,11,12,11,3,12,14,12,16,11,10,5,11,5,5,11,11,11,15,
15,15,16,16,16,15,3,15,5,10,12,11,11,5,5,15,10,12,11,11,
15,5,5,11,5,5,11,11,10,18,11,12,13,11,5,13,13,13,13,13,
13,5,5,5,5,11,11,11,5,11,15,11,11,16,12,15,5,11,4,3,3,
3,3,5,12,12,16,3,5,15,3,16,16,11,4,11,16,16,16,4,11,15,
16,5,12,12,11,5,15,15,5,11,13,12,13,13,11,15,5,15,5,10,
12,12,3,5,11,11,16,13,5,5,11,11,12,12,16,14,11,11,12,10,
11,15,11,5,5,11,5,15,5,11,11,12,15,5,11,11,12,3,16,16,
16,11,13,16,5,11,3,5,3,3,3,5,3,3,3,15,15,15,15,5,15,
15,5,3,3,15,15,15,15,15,5,15,15,13,13,4,3,3,15,15,16,
12,12,13,13,4,3,3,15,15,16,12,12,5,3,12,12,12,13,15,5,
5,3,12,12,13,13,15,5,5,4,4,4,4,7,3,3,15,15,3,4,13,13,
15,3,4,13,13,15,16,13,13,16,12,12,15,15,5,3,3,3,3,5,3,
3,3,15,5,15,15,15,4,12,12,3,3,3,15,13,4,13,4,12,13,3,
3,3,15,13,4,13,3,3,4,3,4,4,3,7,3,5,13,13,13,12,5,15,
5,13,13,13,12,5,15,5,15,15,15,12,16,12,15,15,13,16,13,
15,12,16,12,13,16,13,15,5,15,15,13,3,13,3,3,3,15,12,13,
16,13,4,13,3,3,3,15,12,12,16,3,5,12,12,12,13,5,5,15,3,
4,4,4,4,3,3,7,12,13,12,13,5,5,15,15,15,3,13,13,4,15,3,
13,13,4,3,13,13,4,13,12,16,5,15,15,12,11,11,5,5,5,5,12,
11,12,11,12,11,11,11,12,11,11,11,11,11,12,11,11,11,11,12,
11,12,11,12,12,11,11,5,5,5,11,11,11,5,5,12,12,11,5,11,
11,11,12,12,12,12,12,12,12,11,12,11,11,11,11,12,11,12,11,
11,11,12,11,11,11,11,11,11,12,11,11,11,5,5,5,12,11,12,5,
5,11,11,11,5,11,11,11,11,12,11,12,11,11,5,11,12,12,11,5,
5,5,12,11,11,12,5,5,5,11,12,11,11,11,11,11,11,11,12,11,
11,11,12,11,11,11,11,5,5,5,12,12,12,12,5,5,5,12,12,11,
11,11,12,12,11,11,11,11,12,11,11,12,11,11,12,5,5,5,12,
11,11,12,11,11,12,11,11,11,11,12,11,11,11,12,11,11,5,5,
5,5,5,11,12,11,5,12,11,12,11,11,11,11,12,12,5,12,12,11,
11,11,11,12,11,11,11,12,11,12,12,11,11,12,12,5];

#############################################################################
##
#E  trsstatuspos.g . . . . . . . . . . . . . . . . . . . . . . . .  ends here
