import API from '../utils/api.js';
import type { TypeScriptServiceConfiguration } from '../utils/configuration.js';
import type { Logger } from '../utils/logger.js';
export declare const enum TypeScriptVersionSource {
    Bundled = "bundled",
    UserSetting = "user-setting",
    Workspace = "workspace"
}
export declare class TypeScriptVersion {
    readonly source: TypeScriptVersionSource;
    readonly path: string;
    private readonly logger;
    private readonly _pathLabel?;
    private _api;
    constructor(source: TypeScriptVersionSource, path: string, logger: Logger, _pathLabel?: string | undefined);
    get tscPath(): string;
    get tsServerPath(): string;
    get pathLabel(): string;
    get isValid(): boolean;
    get version(): API | null;
    get versionString(): string | null;
    private getTypeScriptVersion;
}
export declare const MODULE_FOLDERS: string[];
export declare class TypeScriptVersionProvider {
    private configuration;
    private logger;
    constructor(configuration: TypeScriptServiceConfiguration, logger: Logger);
    getUserSettingVersion(): TypeScriptVersion | null;
    getWorkspaceVersion(workspaceFolders: string[]): TypeScriptVersion | null;
    bundledVersion(): TypeScriptVersion | null;
}
//# sourceMappingURL=versionProvider.d.ts.map