/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ks extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TO = "\u0679\u0648\u0646\u065b\u06af\u0627";
        final String metaValue_ae = "\u0627\u064e\u0648\u06cc\u0633\u062a\u064e\u0646";
        final String metaValue_bo = "\u062a\u0650\u0628\u062a\u06cc";
        final String metaValue_ka = "\u062c\u0627\u0631\u062c\u0650\u06cc\u064e\u0646";
        final String metaValue_ko = "\u06a9\u0648\u0631\u06cc\u064e\u0646";
        final String metaValue_lo = "\u0644\u0627\u0648";
        final String metaValue_ru = "\u0631\u0648\u0657\u0633\u06cc";
        final String metaValue_si = "\u0633\u0650\u0646\u06c1\u0627\u0644\u0627";
        final String metaValue_su = "\u0633\u064e\u0646\u0688\u064e\u0646\u06cc\u0656\u0632";
        final String metaValue_ta = "\u062a\u064e\u0645\u0650\u0644";
        final String metaValue_te = "\u062a\u06cc\u0644\u06af\u0648\u0657";
        final String metaValue_th = "\u062a\u06be\u0627\u06d2";
        final String metaValue_chr = "\u0686\u06cc\u065a\u0631\u0648\u06a9\u06cc";
        final String metaValue_cop = "\u06a9\u0627\u067e\u0679\u0650\u06a9";
        final String metaValue_got = "\u06af\u0648\u062a\u06be\u0650\u06a9";
        final String metaValue_nqo = "\u0627\u06cc\u065a\u0646 \u06a9\u0648";
        final String metaValue_peo = "\u067e\u0631\u0648\u0646 \u0641\u0627\u0631\u0633\u06cc";
        final String metaValue_vai = "\u0648\u0627\u06d2";
        final Object[][] data = new Object[][] {
            { "Ogam", "\u0627\u0648\u06af\u06c1\u0627\u0645" },
            { "mwl", "\u0645\u0650\u0631\u0627\u0646\u062f\u06cc\u0656\u0632" },
            { "cch", "\u0627\u062a\u0633\u064e\u0645" },
            { "mwr", "\u0645\u0627\u0631\u0648\u0627\u0691\u06cc" },
            { "Tagb", "\u062a\u064e\u06af\u0628\u064e\u0646\u0648\u0627" },
            { "%%NJIVA", "\u0646\u06cc\u062c\u0650\u0648\u0627 \u0628\u0648\u0657\u0644\u06cd" },
            { "egy", "\u0642\u062f\u06cc\u0656\u0645\u06cc \u0645\u0650\u0635\u0631\u06cc" },
            { "raj", "\u0631\u0627\u062c\u0650\u0633\u062a\u06be\u0672\u0646\u06cd" },
            { "Phag", "\u067e\u06be\u0627\u06af\u0633 \u067e\u0627" },
            { "tem", "\u0679\u0650\u0645\u0646\u06cc\u06d2" },
            { "rap", "\u0631\u064e\u067e\u0627\u0646\u0648\u06cc" },
            { "ter", "\u0679\u06cc\u065a\u0631\u06cc\u065a\u0646\u0648" },
            { "rar", "\u0631\u064e\u0631\u0648\u0679\u0648\u0646\u065b\u06af\u064e\u0646" },
            { "tet", "\u0679\u06cc\u0679\u064e\u0645" },
            { "AD", "\u0627\u066e\u06ea\u0646\u0691\u0648\u0631\u0627" },
            { "AE", "\u0645\u064f\u062a\u062d\u062f\u06c1 \u0639\u0631\u064e\u0628 \u0627\u0645\u0627\u0631\u0627\u062a" },
            { "nl_BE", "\u0641\u0644\u06cc\u065a\u0645\u0650\u0634" },
            { "AF", "\u0627\u064e\u0641\u063a\u0627\u0646\u064e\u0633\u062a\u0627\u0646" },
            { "AG", "\u0627\u066e\u06ea\u0646\u0679\u0650\u06af\u064f\u0648\u0627 \u062a\u06c1\u0655 \u0628\u0627\u0631\u0628\u0648\u0691\u0627" },
            { "AI", "\u0627\u0646\u06af\u0648\u0626\u06cc\u0644\u0627" },
            { "AL", "\u0627\u066e\u06ea\u0644\u0628\u0627\u0646\u0650\u06cc\u0627" },
            { "AM", "\u0627\u064e\u0631\u0645\u0627\u0646\u0650\u06cc\u0627" },
            { "Teng", "\u062a\u06cc\u065a\u0646\u06af\u0648\u0627\u0631" },
            { "AO", "\u0627\u0646\u06af\u0648\u0644\u0627" },
            { "AQ", "\u0627\u06cc\u0646\u0679\u0627\u0631\u0679\u0650\u06a9\u0627" },
            { "AR", "\u0623\u0631\u062c\u064e\u0646\u0679\u06cc\u0646\u0627" },
            { "AS", "\u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u064e\u0646 \u0633\u064e\u0645\u0648\u0627" },
            { "AT", "\u0622\u0633\u0679\u0650\u06cc\u0627" },
            { "AU", "\u0622\u0633\u0679\u0631\u06cc\u0644\u0650\u06cc\u0627" },
            { "AW", "\u0627\u064e\u0631\u0648\u0657\u0628\u0627" },
            { "en_US", "\u06cc\u0648\u0657 \u0627\u06cc\u065a\u0633 \u0627\u064e\u0646\u065b\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "AX", "\u0627\u06cc\u0644\u06cc\u0646\u065b\u0691 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "AZ", "\u0622\u0632\u064e\u0631\u0628\u0627\u062c\u0627\u0646" },
            { "%%AREVELA", "\u0645\u064e\u0634\u0631\u0650\u0642\u06cc \u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u0627" },
            { "BA", "\u0628\u0648\u0633\u0646\u0650\u06cc\u0627 \u062a\u06c1\u0655 \u06c1\u064e\u0631\u0632\u0650\u06af\u0648\u0648\u0650\u0646\u0627" },
            { "BB", "\u0628\u0627\u0631\u0628\u06cc\u0688\u0627\u0633" },
            { "ceb", "\u0633\u06cc\u0628\u0627\u0648\u0646\u0648" },
            { "BD", "\u0628\u064e\u0646\u065b\u06af\u0644\u0627\u062f\u06cc\u0634" },
            { "kum", "\u06a9\u064f\u0645\u0650\u06a9" },
            { "BE", "\u0628\u06cc\u065b\u0644\u062c\u0650\u06cc\u064e\u0645" },
            { "gmh", "\u0648\u064e\u0633\u0637\u06cc \u06c1\u0627\u06d2 \u062c\u0654\u0631\u0645\u064e\u0646" },
            { "BF", "\u0628\u064f\u0631\u06a9\u0650\u0646\u0627 \u0641\u06cc\u0633\u0648" },
            { "BG", "\u0628\u064e\u0644\u062c\u06cc\u0631\u0650\u06cc\u0627" },
            { "BH", "\u0628\u062d\u0631\u06cc\u0656\u0646" },
            { "BI", "\u0628\u0648\u0631\u064e\u0646\u0688\u0650" },
            { "BJ", "\u0628\u0650\u0646\u0650\u0646" },
            { "BL", "\u0633\u06cc\u0646\u065b\u0679 \u0628\u0627\u0631\u062a\u064e\u06be\u06cc\u0644\u0645\u06cc" },
            { "BM", "\u0628\u0654\u0631\u0645\u06cc\u0648\u0688\u0627" },
            { "kut", "\u06a9\u064f\u062a\u06cc\u0646\u064e\u06d2" },
            { "myv", "\u0627\u06cc\u065a\u0631\u0632\u0650\u06cc\u0627" },
            { "BN", "\u0628\u064f\u0631\u0646\u0654\u06d2" },
            { "BO", "\u0628\u0648\u0644\u0650\u0648\u0650\u06cc\u0627" },
            { "BQ", "\u0628\u0631\u0637\u0627\u0646\u0648\u06cc \u0642\u064f\u0637\u0628\u06c1\u0650 \u062c\u064e\u0646\u0648\u0657\u0628\u06cc \u0639\u0644\u0627\u0642\u06c1\u0655" },
            { "BR", "\u0628\u0631\u065b\u0627\u0632\u0650\u0644" },
            { "BS", "\u0628\u064e\u06c1\u0627\u0645\u064e\u0633" },
            { "BT", "\u0628\u0648\u0657\u0679\u0627\u0646" },
            { "BV", "\u0628\u0648\u0648\u064e\u0679 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "BW", "\u0628\u0648\u062a\u064e\u0633\u0648\u0627\u0646\u0627" },
            { "BY", "\u0628\u06cc\u0644\u0627\u0631\u0648\u0657\u0633" },
            { "BZ", "\u0628\u06cc\u0644\u0650\u062c" },
            { "Visp", "\u0648\u0650\u0632\u0650\u0628\u0655\u0644 \u0633\u067e\u06cc\u0656\u0686" },
            { "CA", "\u06a9\u06cc\u0646\u064e\u0691\u0627" },
            { "CC", "\u06a9\u0648\u06a9\u064e\u0633 \u06a9\u06cc\u0656\u0644\u0650\u0646\u065b\u06af \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "CD", "\u06a9\u0648\u0646\u065b\u06af\u0648 \u06a9\u0650\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u0645\u0631\u06a9\u0654\u0632\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u06cc \u062c\u0645\u0648\u0657\u0631\u06cc\u064e\u062a" },
            { "CG", "\u06a9\u0648\u0646\u065b\u06af\u0648 \u0628\u0654\u0631\u065b\u0632\u0627\u0648\u0650\u0644\u06cc" },
            { "CH", "\u0633\u064f\u0648\u0650\u0632\u064e\u0631\u0644\u06cc\u0646\u065b\u0691" },
            { "CI", "\u0627\u064e\u06cc\u0648\u0655\u0631\u06cc \u06a9\u0648\u0633\u0679" },
            { "CK", "\u06a9\u064f\u06a9 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "CL", "\u0686\u0650\u0644\u06cc" },
            { "CM", "\u06a9\u06cc\u065a\u0645\u0650\u0631\u0648\u0657\u0646" },
            { "CN", "\u0686\u06cc\u0656\u0646" },
            { "CO", "\u06a9\u0648\u0644\u064e\u0645\u0628\u0650\u06cc\u0627" },
            { "CR", "\u06a9\u0648\u0633\u0679\u0627 \u0631\u0650\u06a9\u0627" },
            { "CU", "\u06a9\u06cc\u0648\u0657\u0628\u0627" },
            { "CV", "\u06a9\u06cc\u067e \u0624\u0631\u0691\u06cc" },
            { "CX", "\u06a9\u0631\u0650\u0633\u0645\u064e\u0633 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "CY", "\u0633\u0627\u06cc\u0641\u0631\u065b\u0633" },
            { "CZ", "\u0686\u06cc\u06a9 \u062c\u064e\u0645\u0648\u0657\u0631\u0650\u06cc\u064e\u062a" },
            { "eka", "\u0627\u06cc\u065a\u06a9\u0627\u062c\u064f\u06a9" },
            { "DE", "\u062c\u0631\u0645\u0654\u0646\u06cc" },
            { "goh", "\u067e\u0631\u0648\u0646 \u06c1\u0627\u06d2 \u062c\u0654\u0631\u0645\u064e\u0646" },
            { "ace", "\u0627\u064e\u0686\u064e\u06d2\u0646\u06cc\u0656\u0632" },
            { "DJ", "\u062c\u0650\u0628\u0648\u0657\u062a\u06cc" },
            { "DK", "\u0688\u06cc\u0646\u065b\u0645\u0627\u0631\u0655\u06a9" },
            { "ach", "\u0627\u064e\u06a9\u0648\u0644\u06cc" },
            { "gon", "\u06af\u0648\u0646\u062f\u06cc" },
            { "Brai", "\u0628\u0631\u06cc\u0644" },
            { "Brah", "\u0628\u0631\u065b\u0627\u06c1\u0645\u06cc" },
            { "DM", "\u0688\u0648\u0645\u0650\u0646\u0650\u06a9\u0627" },
            { "DO", "\u0688\u0648\u0645\u0650\u0646\u0650\u06a9\u064e\u0646 \u062c\u0645\u0648\u0657\u0631\u0650\u06cc\u064e\u062a" },
            { "gor", "\u06af\u0648\u0631\u06cc\u0646\u0679\u06cc\u0644\u0648" },
            { "got", metaValue_got },
            { "Mtei", "\u0645\u06cc\u062a\u06cc \u0645\u0627\u06cc\u064e\u06a9" },
            { "zun", "\u0632\u0648\u0657\u0646\u06cc" },
            { "tig", "\u0679\u0627\u06d2\u06af\u0631\u06cc\u06d2" },
            { "DZ", "\u0627\u066e\u06ea\u0644\u062c\u06cc\u0631\u0650\u06cc\u0627" },
            { "pag", "\u067e\u064e\u0646\u065b\u06af\u0627\u0633\u0650\u0646\u064e\u0646" },
            { "pal", "\u067e\u064e\u06c1\u0644\u064e\u0648\u06cc" },
            { "chb", "\u0686\u06cc\u0656\u0628\u0686\u0627" },
            { "pam", "\u067e\u064e\u0645\u067e\u064e\u0646\u065b\u06af\u0627" },
            { "EC", "\u0627\u0650\u06a9\u0648\u0627\u0691\u0648\u0631" },
            { "pap", "\u067e\u064e\u067e\u0650\u06cc\u0627\u0645\u06cc\u065a\u0646\u0679\u0648" },
            { "ada", "\u0627\u064e\u062f\u064e\u0646\u065b\u06af\u0645\u06cc\u06d2" },
            { "EE", "\u0627\u06cc\u0633\u0679\u0648\u0646\u0650\u06cc\u0627" },
            { "tiv", "\u062a\u06cc\u0656\u0648" },
            { "EG", "\u0645\u0650\u0633\u0654\u0631" },
            { "EH", "\u0645\u0634\u0631\u0650\u0642\u06cc \u0633\u064e\u06c1\u0627\u0631\u0627" },
            { "chg", "\u0686\u06be\u064e\u06af\u062a\u0627\u06d2" },
            { "pau", "\u067e\u064e\u0644\u0627\u0627\u064f\u0648\u0627\u06ba" },
            { "chk", "\u0686\u064f\u06a9\u06cc\u0656\u0632" },
            { "chn", "\u0686\u0650\u0646\u0648\u0657\u06a9 \u062c\u0627\u0631\u06af\u064e\u0646" },
            { "chm", "\u0645\u0627\u0631\u06cc" },
            { "chp", "\u0634\u06cc\u067e\u0648\u06cc\u0627\u0646" },
            { "cho", "\u0686\u0648\u06a9\u062a\u064e\u0648" },
            { "chr", metaValue_chr },
            { "ER", "\u0627\u0650\u0631\u0655\u0679\u0650\u06cc\u0627" },
            { "ES", "\u0633\u0655\u067e\u06cc\u0646" },
            { "ET", "\u0627\u0650\u062a\u06be\u0648\u067e\u0650\u06cc\u0627" },
            { "elx", "\u0627\u06cc\u065a\u0644\u0627\u0645\u0627\u06cc\u0650\u0679" },
            { "type.ca.gregorian", "\u06af\u0631\u06af\u0648\u0631\u06cc\u064e\u0646 \u06a9\u06cc\u0644\u0646\u0691\u064e\u0631" },
            { "chy", "\u0634\u06cc\u06cc\u0648\u0646" },
            { "Inds", "\u0627\u0650\u0646\u0688\u064e\u0633" },
            { "ady", "\u0627\u064e\u062f\u064e\u06cc\u0656\u06af\u06cc\u06d2" },
            { "FI", "\u0641\u0650\u0646\u0644\u06cc\u0646\u065b\u0691" },
            { "FJ", "\u0641\u0650\u062c\u06cc" },
            { "FK", "\u0641\u0655\u0644\u0627\u06a9\u0644\u06cc\u0646\u065b\u0691 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "Taml", metaValue_ta },
            { "FR", "\u0641\u0631\u065b\u0627\u0646\u0633" },
            { "tkl", "\u0679\u0648\u06a9\u06cc\u0656\u0644\u0627\u0648" },
            { "grb", "\u06af\u0631\u0650\u0628\u0648" },
            { "root", "\u0631\u0648\u0657\u0679" },
            { "grc", "\u0642\u062f\u06cc\u0656\u0645 \u06cc\u0648\u0657\u0646\u0672\u0646\u06cc" },
            { "GA", "\u06af\u06cc\u0628\u0627\u0646" },
            { "vot", "\u0648\u0648\u062a\u0650\u06a9" },
            { "GB", "\u06cc\u064f\u0646\u0627\u06cc\u0679\u0650\u0691 \u06a9\u0650\u0646\u065b\u06af\u0688\u064e\u0645" },
            { "GD", "\u06af\u0631\u065b\u0646\u06cc\u0691\u0627" },
            { "GE", "\u062c\u0627\u0631\u062c\u0650\u06cc\u0627" },
            { "GF", "\u0641\u0631\u065b\u0627\u0646\u0633\u0650\u0633\u06cc \u06af\u0650\u0627\u0646\u0627" },
            { "GG", "\u06af\u06cc\u0648\u064e\u0646\u064e\u0631\u0633\u06d2" },
            { "GH", "\u06af\u0627\u0646\u0627" },
            { "Tale", "\u062a\u064e\u06cc\u0644\u06cc\u06d2" },
            { "GI", "\u062c\u0650\u0628\u0631\u0627\u0644\u0679\u064e\u0631" },
            { "afh", "\u0627\u064e\u0641\u0631\u0650\u06c1\u0650\u0644\u06cc" },
            { "GL", "\u06af\u0631\u06cc\u0656\u0646\u0644\u06cc\u0646\u065b\u0691" },
            { "enm", "\u0648\u064e\u0633\u0637\u06cc \u0627\u064e\u0646\u065b\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "GM", "\u06af\u064e\u0645\u0628\u0650\u06cc\u0627" },
            { "GN", "\u06af\u0650\u0646\u06cc" },
            { "GP", "\u06af\u064e\u0648\u0627\u0691\u06cc\u0644\u0648\u067e" },
            { "GQ", "\u0627\u0650\u06a9\u0648\u0650\u0679\u0648\u0631\u0650\u06cc\u064e\u0644 \u06af\u0650\u0646\u06cc" },
            { "GR", "\u06af\u0631\u06cc\u0656\u0633" },
            { "GS", "\u062c\u0646\u0648\u0657\u0628\u06cc \u062c\u0627\u0631\u062c\u0650\u06cc\u0627 \u062a\u06c1\u0655 \u062c\u0646\u0648\u0657\u0628\u06cc \u0633\u06cc\u0646\u065b\u0691\u0648\u0655\u0686 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "GT", "\u06af\u0648\u062a\u06cc\u062f\u0627\u0644\u0627" },
            { "GU", "\u06af\u064f\u0648\u0627\u0645" },
            { "GW", "\u06af\u06cc\u0656\u0646\u06cc \u0628\u0650\u0633\u0627\u0648" },
            { "tli", "\u0679\u0650\u0644\u0650\u0646\u06af\u0650\u062a" },
            { "tlh", "\u06a9\u0650\u0644\u0650\u0646\u06af\u0648\u0646" },
            { "Talu", "\u0646\u0648\u065a\u0648 \u062a\u06cc\u0644\u0648" },
            { "GY", "\u06af\u064f\u06cc\u0627\u0646\u0627" },
            { "zxx", "\u06a9\u0627\u0646\u065b\u06c1\u06c1 \u062a\u06c1\u0650 \u0644\u0650\u0633\u0627\u0646\u06cc\u0627\u062a\u06cc \u0645\u0648\u0627\u062f \u0646\u06c1\u0655" },
            { "de_AT", "\u0622\u0633\u0679\u0631\u0650\u06cc\u064e\u0646 \u062c\u0654\u0631\u0645\u064e\u0646" },
            { "Vaii", metaValue_vai },
            { "HK", "\u06c1\u0627\u0646\u065b\u06af \u06a9\u0627\u0646\u065b\u06af \u0627\u06cc\u0633 \u0627\u06d2 \u0622\u0631 \u0686\u06cc\u0656\u0646" },
            { "HM", "\u06c1\u064e\u0631\u0655\u0691 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655 \u062a\u06c1\u0655 \u0645\u066e\u06ea\u06a9\u0688\u0648\u0646\u0627\u0644\u0691\u0655 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "HN", "\u06c1\u0627\u0646\u065b\u0688\u0648\u0657\u0631\u0650\u0633" },
            { "HR", "\u06a9\u0631\u065b\u0648\u0634\u0650\u06cc\u0627" },
            { "gsw", "\u0633\u0655\u0648\u0650\u0633 \u062c\u0654\u0631\u0645\u064e\u0646" },
            { "HT", "\u06c1\u0627\u06cc\u062a\u06cc" },
            { "HU", "\u06c1\u064e\u0646\u065b\u06af\u0631\u06cc" },
            { "tmh", "\u062a\u0627\u0645\u0627\u0634\u06cc\u06a9" },
            { "peo", metaValue_peo },
            { "ID", "\u0627\u0650\u0646\u0691\u0648\u0646\u06cc\u0634\u0650\u06cc\u0627" },
            { "IE", "\u0627\u064e\u06cc\u064e\u0631\u0644\u06cc\u0646\u065b\u0691" },
            { "nap", "\u0646\u06cc\u0656\u067e\u0627\u0644\u06cc\u0679\u064e\u0646" },
            { "zza", "\u0632\u0627\u0632\u0627" },
            { "IL", "\u0627\u0650\u0633\u0631\u0627\u06cc\u0656\u0644" },
            { "IM", "\u0622\u06cc\u0650\u0644 \u0622\u0641 \u0645\u06cc\u065b\u0646" },
            { "IN", "\u06c1\u0650\u0646\u065b\u062f\u0648\u0633\u062a\u0627\u0646" },
            { "IO", "\u0628\u0631\u0637\u0627\u0646\u0648\u06cc \u0628\u062d\u0631\u0650 \u06c1\u0650\u0646\u065b\u062f\u06cd \u0639\u0644\u0627\u0642\u06c1\u0655" },
            { "IQ", "\u0627\u06cc\u0656\u0631\u0627\u0642" },
            { "IR", "\u0627\u06cc\u0656\u0631\u0627\u0646" },
            { "IS", "\u0627\u064e\u06cc\u0650\u0633\u0644\u06cc\u0646\u065b\u0691" },
            { "IT", "\u0627\u0650\u0679\u0644\u06cc" },
            { "%%POSIX", "\u06a9\u064e\u0645\u067e\u06cc\u0648\u0657\u0679\u064e\u0631" },
            { "JE", "\u062c\u0654\u0631\u0633\u06cc" },
            { "type.ca.islamic", "\u0627\u0650\u0633\u0644\u0672\u0645\u06cc \u06a9\u06cc\u0644\u0646\u0691\u064e\u0631" },
            { "JM", "\u062c\u064e\u0645\u0627\u06cc\u06a9\u0627" },
            { "Beng", "\u0628\u06cc\u065a\u0646\u06af\u0672\u0644\u06cd" },
            { "JP", "\u062c\u0627\u067e\u0627\u0646" },
            { "%%1606NICT", "\u0628\u0639\u062f \u0648\u064e\u0642\u062a \u0648\u064e\u0633\u0637\u06cc \u0641\u0631\u065b\u0627\u0646\u0633 \u067e\u066e\u06ea\u0679\u06be \u06f1\u06f6\u0660\u06f6 \u062a\u0627\u0645" },
            { "ain", "\u0627\u06cc\u0646\u0648\u0657" },
            { "tog", "\u0646\u06cc\u0627\u0633\u0627 \u0679\u0648\u0646\u065b\u06af\u0627" },
            { "Kali", "\u06a9\u0627\u06cc\u0627 \u0644\u06cc" },
            { "de_CH", "\u0633\u0655\u0648\u0650\u0633 \u06c1\u0627\u06d2\u062c\u0654\u0631\u0645\u064e\u0646" },
            { "type.ca.buddhist", "\u0628\u064f\u062f\u064e\u0646 \u06c1\u064f\u0646\u065b\u062f \u06a9\u06cc\u0644\u0646\u0691\u064e\u0631" },
            { "KE", "\u06a9\u0650\u0646\u065b\u06cc\u0627" },
            { "419", "\u0644\u0627\u0637\u06cc\u0656\u0646\u06cc \u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u0627 \u062a\u06c1\u0655 \u06a9\u06cc\u0631\u064e\u0628\u06cc\u0656\u0646" },
            { "KG", "\u06a9\u0650\u0631\u06af\u0650\u0633\u062a\u0627\u0646" },
            { "KH", "\u06a9\u064e\u0645\u0628\u0648\u0691\u0650\u06cc\u0627" },
            { "KI", "\u06a9\u0650\u0631\u0655\u0628\u0627\u062a\u06cc" },
            { "KM", "\u06a9\u064e\u0645\u0648\u0631\u064e\u0633" },
            { "KN", "\u0633\u06cc\u0646\u065b\u0679 \u06a9\u0650\u0679\u064e\u0633 \u062a\u06c1\u0655 \u0646\u06cc\u0648\u0650\u0633" },
            { "Knda", "\u06a9\u064e\u0646\u064e\u0691\u0627" },
            { "fr_CA", "\u06a9\u064e\u0646\u06cc\u0688\u06cc\u064e\u0646 \u0641\u0631\u06cc\u065a\u0646\u0686" },
            { "KP", "\u0634\u064f\u0645\u0672\u0644\u06cc \u06a9\u0648\u0631\u0650\u06cc\u0627" },
            { "KR", "\u062c\u0646\u0648\u0657\u0628\u06cc \u06a9\u0648\u0631\u0650\u06cc\u0627" },
            { "Plrd", "\u067e\u0648\u0644\u0627\u0691 \u067e\u06be\u0648\u0646\u0650\u0679\u0650\u06a9" },
            { "fr_CH", "\u0633\u0655\u0648\u0655\u0633 \u0641\u0631\u06cc\u065a\u0646\u0686" },
            { "KW", "\u06a9\u064f\u0648\u06cc\u062a" },
            { "tpi", "\u0679\u0627\u06a9 \u067e\u0650\u0633\u0650\u0646" },
            { "KY", "\u06a9\u06cc\u0645\u064e\u0646 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "KZ", "\u06a9\u064e\u0632\u0627\u06a9\u0650\u0633\u062a\u0627\u0646" },
            { "Cyrl", "\u0633\u064e\u06cc\u0631\u0650\u0644\u0650\u06a9" },
            { "LA", "\u0644\u0627\u0633" },
            { "LB", "\u0644\u066e\u06ea\u0628\u0646\u0627\u0646" },
            { "LC", "\u0633\u06cc\u0646\u065b\u0679 \u0644\u0648\u0657\u0633\u0650\u06cc\u0627" },
            { "phn", "\u0641\u0648\u0646\u06cc\u0656\u0634\u06cc\u064e\u0646" },
            { "Cyrs", "\u067e\u0631\u0648\u0646 \u0686\u0654\u0631\u0686\u0633\u0644\u06cc\u0648\u0648\u0646\u0650\u06a9 \u0633\u064e\u06cc\u0631\u0650\u0644\u0650\u06a9" },
            { "gwi", "\u06af\u064f\u0648\u0650\u0686 \u0627\u0650\u0646" },
            { "nds", "\u0628\u0648\u065a\u0646\u0650\u0645 \u062c\u0654\u0631\u0645\u064e\u0646" },
            { "LI", "\u0644\u0650\u06a9\u0679\u06cc\u065b\u0633\u0679\u06cc\u0656\u0646" },
            { "LK", "\u0633\u0650\u0631\u06cc\u0656\u0644\u064e\u0646\u065b\u06a9\u0627" },
            { "akk", "\u0627\u064e\u06a9\u0627\u062f\u0650\u06cc\u064e\u0646" },
            { "cop", metaValue_cop },
            { "LR", "\u0644\u0627\u06cc\u0628\u06cc\u0631\u0650\u06cc\u0627" },
            { "LS", "\u0644\u06cc\u0633\u0648\u062a\u06be\u0648" },
            { "Phlv", "\u0628\u0648\u0657\u06a9 \u067e\u064e\u06c1\u064e\u0644\u0648\u06cc" },
            { "LT", "\u0644\u0650\u062a\u06be\u064f\u0648\u0627\u0646\u0650\u06cc\u0627" },
            { "LU", "\u0644\u064e\u06a9\u0633\u064e\u0645\u0628\u0654\u0631\u0655\u06af" },
            { "LV", "\u0644\u06cc\u065b\u0679\u0648\u0650\u06cc\u0627" },
            { "Kana", "\u06a9\u064e\u062a\u0627\u06a9\u0627\u0646\u0627" },
            { "LY", "\u0644\u0650\u0628\u06cc\u0627" },
            { "lad", "\u0644\u06cc\u0688\u0650\u0646\u0648" },
            { "lah", "\u0644\u064e\u06c1\u064e\u0646\u062f\u0627" },
            { "Thaa", "\u062a\u06be\u0627\u0646\u0627" },
            { "MA", "\u0645\u0648\u0631\u0648\u06a9\u0648" },
            { "MC", "\u0645\u0648\u0646\u06cc\u065a\u06a9\u0648" },
            { "MD", "\u0645\u0648\u0644\u0691\u0627\u0648\u0650\u06cc\u0627" },
            { "ME", "\u0645\u0648\u0679\u0648\u0646\u06cc\u065b\u06af\u0650\u0631\u06cc\u0648" },
            { "MF", "\u0633\u06cc\u0646\u065b\u0679 \u0645\u0627\u0631\u0679\u0650\u0646" },
            { "lam", "\u0644\u064e\u0645\u0628\u0627" },
            { "MG", "\u0645\u06cc\u0691\u0627\u06af\u0627\u0633\u06a9\u0627\u0631" },
            { "Thai", metaValue_th },
            { "MH", "\u0645\u0627\u0631\u0634\u064e\u0644 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "ale", "\u0627\u064e\u0644\u0648\u06cc\u062a\u06cc" },
            { "MK", "\u0645\u066e\u06ea\u0633\u0648\u0691\u0648\u0646\u0650\u06cc\u0627" },
            { "ML", "\u0645\u0627\u0644\u06cc" },
            { "MM", "\u0645\u064e\u06cc\u064e\u0646\u0645\u0627 \u0628\u0654\u0631\u0645\u0627" },
            { "MN", "\u0645\u064e\u0646\u065b\u06af\u0648\u0644\u0650\u06cc\u0627" },
            { "new", "\u0646\u06cc\u065a\u0648\u0627\u0631\u06cc" },
            { "MO", "\u0645\u064e\u06a9\u0627\u0648\u0648 \u0627\u06cc\u0633 \u0627\u06d2 \u0622\u0631 \u0686\u06cc\u0656\u0646" },
            { "MP", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0645\u0627\u0631\u0650\u06cc\u0627\u0646\u0627 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "MQ", "\u0645\u0627\u0631\u0679\u0650\u0646\u0650\u06a9" },
            { "MR", "\u0645\u0627\u0631\u0655\u0679\u0627\u0646\u0650\u06cc\u0627" },
            { "MS", "\u0645\u0627\u0646\u065b\u0679\u0633\u06cc\u0631\u0627\u0679" },
            { "MT", "\u0645\u0627\u0644\u0679\u0627" },
            { "MU", "\u0645\u0648\u0631\u0650\u0634\u064e\u0633" },
            { "alt", "\u062c\u0646\u0648\u0657\u0628\u06cc \u0627\u064e\u0644\u062a\u0627\u06cc\u06cc" },
            { "MV", "\u0645\u0627\u0644\u062f\u06cc\u0656\u0648" },
            { "MW", "\u0645\u0644\u0627\u0648\u06cc" },
            { "MX", "\u0645\u066e\u06ea\u06a9\u0633\u0650\u06a9\u0648" },
            { "type.ca.japanese", "\u062c\u0627\u067e\u0672\u0646\u06cd \u06a9\u06cc\u0644\u0646\u0691\u064e\u0631" },
            { "MY", "\u0645\u064e\u0644\u06cc\u0634\u0650\u06cc\u0627" },
            { "MZ", "\u0645\u0648\u0632\u064e\u0645\u0628\u0650\u06a9" },
            { "NA", "\u0646\u0627\u0645\u0650\u0628\u0650\u06cc\u0627" },
            { "type.ca.hebrew", "\u06c1\u0650\u0628\u0631\u0650\u0648 \u06a9\u06cc\u0644\u0646\u0691\u064e\u0631" },
            { "NC", "\u0646\u0650\u0648 \u06a9\u06cc\u0644\u0650\u0691\u0648\u0646\u0650\u06cc\u0627" },
            { "NE", "\u0646\u0627\u06cc\u062c\u064e\u0631" },
            { "NF", "\u0646\u0627\u0631\u0641\u0627\u06a9 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "NG", "\u0646\u0627\u06cc\u062c\u06cc\u0631\u0650\u06cc\u0627" },
            { "NI", "\u0646\u0627\u06a9\u0627\u0631\u0627\u06af\u064f\u0648\u0627" },
            { "Hmng", "\u067e\u064e\u06c1\u0627\u0648 \u0645\u0627\u0646\u065b\u06af" },
            { "NL", "\u0646\u06cc\u0656\u062f\u064e\u0631\u0644\u06cc\u0646\u065b\u0691" },
            { "NO", "\u0646\u0627\u0631\u0648\u06d2" },
            { "NP", "\u0646\u06cc\u067e\u0627\u0644" },
            { "NR", "\u0646\u0627\u0631\u0648\u0648\u0657" },
            { "NU", "\u0646\u06cc\u0648\u0657" },
            { "Phnx", "\u067e\u06be\u0648\u0646\u0650\u0634\u0650\u06cc\u064e\u0646" },
            { "tsi", "\u0698\u06be\u0650\u0645\u0634\u0650\u06cc\u0627\u0646" },
            { "NZ", "\u0646\u06cc\u0648\u0657\u0632\u0650\u0644\u06cc\u0646\u065b\u0691" },
            { "rom", "\u0631\u0648\u0645\u064e\u0646\u06cc" },
            { "Mero", "\u0645\u0650\u0631\u0627\u06cc\u0679\u0650\u06a9" },
            { "crh", "\u06a9\u0631\u0655\u0645\u06cc\u0656\u0646 \u062a\u064f\u0631\u06a9\u06cc" },
            { "ang", "\u067e\u0631\u0648\u0646 \u0627\u064e\u0646\u065b\u06af\u0631\u06cc\u0656\u0632\u06cc" },
            { "OM", "\u0627\u0648\u0645\u0627\u0646" },
            { "anp", "\u0627\u064e\u0646\u065b\u06af\u0650\u06a9\u0627" },
            { "Xpeo", metaValue_peo },
            { "PA", "\u067e\u064e\u0646\u0627\u0645\u0627" },
            { "type.ca.islamic-civil", "\u0627\u0650\u0633\u0644\u0672\u0645\u06cc \u0627\u0650\u062c\u062a\u0645\u0672\u06cc\u06cc \u06a9\u06cc\u0644\u0646\u0691\u064e\u0631" },
            { "csb", "\u06a9\u064e\u0634\u0648\u0657\u0628\u0650\u06cc\u064e\u0646" },
            { "en_GB", "\u0628\u064e\u0631\u0637\u0627\u0646\u0648\u06cc \u0627\u064e\u0646\u065b\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "PE", "\u067e\u06cc\u0656\u0631\u0648\u0657" },
            { "PF", "\u0641\u0631\u065b\u0627\u0646\u0633\u06cc \u067e\u0648\u0644\u0650\u0646\u06cc\u0634\u0650\u06cc\u0627" },
            { "PG", "\u067e\u0627\u067e\u064f\u0648\u0627 \u0646\u06cc\u0648\u0657 \u06af\u06cc\u0656\u0646\u06cc" },
            { "PH", "\u0641\u0650\u0644\u0650\u067e\u0650\u06cc\u0646\u0633" },
            { "PK", "\u067e\u0627\u06a9\u0650\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u0648\u0644\u06cc\u0646\u065b\u0691" },
            { "ewo", "\u0627\u06cc\u065a\u0648\u0648\u0646\u0688\u0648" },
            { "PM", "\u0633\u06cc\u0646\u065b\u0679 \u067e\u06cc\u0656\u0631\u06cc \u062a\u06c1\u0655 \u0645\u0648\u06a9\u06cc\u0644\u0650\u06cc\u064e\u0646" },
            { "PN", "\u067e\u0650\u0679\u06a9\u06cc\u0631\u0655\u0646\u06cd \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "PR", "\u067e\u0654\u0631\u0679\u0648 \u0631\u0650\u06a9\u0648" },
            { "PS", "\u0641\u064e\u0644\u064e\u0633\u062a\u06cc\u0656\u0646" },
            { "Bali", "\u0628\u0627\u0644\u064e\u0646\u06cc\u0656\u0632" },
            { "PT", "\u067e\u064f\u0631\u062a\u0650\u06af\u0627\u0644" },
            { "PW", "\u067e\u064e\u0644\u0627\u0648" },
            { "nia", "\u0646\u0650\u06cc\u0627\u0633" },
            { "PY", "\u067e\u064e\u0631\u0627\u06af\u064f\u06d2" },
            { "tum", "\u062a\u064f\u0645\u0628\u064f\u06a9\u0627" },
            { "Hebr", "\u06c1\u0650\u0628\u0631\u0650\u0648" },
            { "QA", "\u0642\u064e\u0637\u0650\u0631" },
            { "%%SCOTLAND", "\u0633\u064f\u06a9\u0627\u0679\u0650\u0634 \u0645\u064e\u06cc\u0639\u0672\u0631\u06cc \u0627\u064e\u0646\u065b\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "niu", "\u0646\u0650\u06cc\u0648\u06cc\u064e\u0646" },
            { "QO", "\u0622\u0648\u064f\u0679\u0644\u0627\u06cc\u0646\u0650\u06af \u0627\u0648\u0634\u06cc\u0646\u0650\u06cc\u0627" },
            { "lez", "\u0644\u06cc\u0632\u06af\u0650\u06cc\u064e\u0646" },
            { "%%FONUPA", "\u06cc\u0648\u0657 \u067e\u06cc \u0627\u06d2 \u0622\u0648\u0627\u0632\u0650\u06cc\u0627\u062a" },
            { "tvl", "\u062a\u064f\u0648\u0627\u0644\u0648\u0657" },
            { "001", "\u062f\u064f\u0646\u06cc\u0627" },
            { "002", "\u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "003", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u0627" },
            { "RE", "\u0631\u0650\u06cc\u0648\u0657\u0646\u0650\u06cc\u064e\u0646" },
            { "005", "\u062c\u064e\u0646\u0648\u0657\u0646\u06cc \u0627\u064e\u0645\u0631\u0656\u06cc\u0656\u06a9\u0627" },
            { "jbo", "\u0644\u0648\u062c\u0628\u0627\u0646" },
            { "Rjng", "\u0631\u06cc\u062c\u064e\u0646\u065b\u06af" },
            { "009", "\u0627\u0648\u0634\u064e\u0646\u06cc\u0627" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u0650\u06cc\u0627" },
            { "RS", "\u0633\u064e\u0631\u0628\u0650\u06cc\u0627" },
            { "RU", "\u0631\u0648\u0657\u0633" },
            { "RW", "\u0631\u0648\u0657\u0648\u0627\u0646\u065b\u0688\u0627" },
            { "Mani", "\u0645\u0627\u0646\u06cc\u0634\u06cc\u06cc\u064e\u0646" },
            { "Ugar", "\u0627\u064f\u06af\u0627\u0631\u0650\u0679\u0650\u06a9" },
            { "Khar", "\u062e\u064e\u0631\u0648\u0634\u062a\u06be\u06cc" },
            { "SA", "\u0633\u0648\u0657\u062f\u06cc \u0639\u0631\u0628\u0650\u06cc\u06c1" },
            { "pon", "\u067e\u0627\u0646\u067e\u06cc\u065a\u06cc\u064e\u0646" },
            { "Mand", "\u0645\u064e\u0646\u062f\u06cc\u06cc\u064e\u0646" },
            { "SB", "\u0633\u0648\u0644\u0627\u0645\u0627\u0646 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "011", "\u0645\u064e\u063a\u0631\u06cc\u0656\u0628\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "SC", "\u0633\u06cc\u0634\u064e\u0644\u0650\u0633" },
            { "SD", "\u0633\u0648\u0657\u0688\u0627\u0646" },
            { "013", "\u0645\u0631\u06a9\u0654\u0632\u06cc \u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u0627" },
            { "SE", "\u0633\u064f\u0648\u0650\u0688\u064e\u0646" },
            { "014", "\u0645\u064e\u0634\u0631\u0650\u0642\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "arc", "\u0627\u064e\u0631\u064e\u0645\u06cc\u06a9" },
            { "015", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "SG", "\u065b\u0633\u0650\u0646\u065b\u06af\u0627\u067e\u0648\u0657\u0631" },
            { "SH", "\u0633\u06cc\u0646\u065b\u0679 \u06c1\u066e\u06ea\u0644\u0650\u0646\u0627" },
            { "017", "\u0648\u0633\u0637\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "SI", "\u0633\u064e\u0644\u0648\u0648\u06cc\u0646\u0650\u06cc\u0627" },
            { "018", "\u062c\u0646\u0648\u0657\u0628\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "SJ", "\u0633\u064e\u0648\u0627\u0644\u0628\u0631\u06cc\u0691 \u062a\u06c1\u0655 \u062c\u0627\u0646 \u0645\u0627\u06cc\u06cc\u0691" },
            { "019", "\u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u064e\u0633" },
            { "SK", "\u0633\u064e\u0644\u0648\u0648\u0627\u06a9\u0650\u06cc\u0627" },
            { "SL", "\u0633\u06cc\u0656\u0631\u0627\u0644\u06cc\u0648\u0648\u0646" },
            { "SM", "\u0633\u06cc\u0646 \u0645\u06cc\u0631\u0650\u0646\u0648" },
            { "SN", "\u0633\u06cc\u0646\u06cc\u06af\u064e\u0644" },
            { "SO", "\u0633\u0648\u0645\u0627\u0644\u0650\u06cc\u0627" },
            { "arn", "\u0627\u06cc\u0631\u0648 \u06a9\u0648\u0646\u0650\u06cc\u064e\u0646" },
            { "arp", "\u0627\u064e\u0631\u0627\u067e\u0627\u06c1\u0648" },
            { "SR", "\u0633\u064f\u0631\u0650\u0646\u0627\u0645" },
            { "ST", "\u0633\u0627\u0648 \u062a\u0648\u0645 \u062a\u06c1\u0655 \u067e\u0631\u065b\u0646\u0633\u0650\u067e\u06cc" },
            { "SV", "\u0627\u066e\u06ea\u0644 \u0633\u064e\u0644\u0648\u0627\u0691\u0648\u0631" },
            { "SY", "\u0634\u0627\u0645" },
            { "yao", "\u06cc\u0627\u0648" },
            { "SZ", "\u0633\u064f\u0648\u0632\u0650\u0644\u06cc\u0646\u065b\u0691" },
            { "arw", "\u0627\u064e\u0631\u0627\u0648\u064e\u06a9" },
            { "yap", "\u06cc\u064e\u067e\u06cc\u0656\u0632" },
            { "021", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u0627 \u062e\u0655\u0637\u06c1\u0655" },
            { "TC", "\u062a\u064f\u0631\u064f\u06a9 \u062a\u06c1\u0655 \u06a9\u06cc\u06a9\u0648\u0633 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "TD", "\u0686\u0627\u0691" },
            { "TF", "\u0641\u0631\u065b\u0627\u0646\u0633\u0650\u0633\u06cc \u062c\u064e\u0646\u0648\u0657\u0628\u06cc \u0639\u064e\u0644\u0627\u0642\u06c1\u0655" },
            { "TG", "\u0679\u0648\u06af\u0648" },
            { "TH", "\u062a\u06be\u0627\u06cc\u0644\u06cc\u0646\u065b\u0691" },
            { "TJ", "\u062a\u0627\u062c\u06a9\u0650\u0633\u062a\u0627\u0646" },
            { "029", "\u06a9\u064e\u0631\u0650\u0628\u0628\u06cc\u0656\u0646" },
            { "TK", "\u062a\u0648\u06a9\u06cc\u0644\u0627\u0648" },
            { "TL", "\u0645\u064e\u0634\u0631\u0650\u0642\u06cc \u062a\u0627\u06cc\u0645\u0648\u0631" },
            { "TM", "\u062a\u064f\u0631\u0645\u0650\u0646\u0650\u0633\u062a\u0627\u0646" },
            { "TN", "\u0679\u0648\u0646\u06cc\u0634\u0650\u06cc\u0627" },
            { "TO", metaValue_TO },
            { "TR", "\u062a\u064f\u0631\u06a9\u06cc" },
            { "TT", "\u0679\u0631\u065b\u0646\u0650\u0646\u062f\u0627\u062f \u062a\u06c1\u0655 \u0679\u0648\u0628\u06cc\u06af\u0648" },
            { "TV", "\u062a\u0648\u0657\u0648\u0627\u0644\u0648\u0657" },
            { "TW", "\u062a\u0627\u06cc\u0648\u0627\u0646" },
            { "ast", "\u0627\u06cc\u0633\u0679\u0648\u0657\u0631\u06cc\u064e\u0646" },
            { "Orkh", "\u0627\u0648\u0631\u06a9\u06be\u0648\u0646" },
            { "TZ", "\u062a\u064e\u0646\u062c\u0627\u0646\u0650\u06cc\u0627" },
            { "Zzzz", "\u0627\u064e\u0646 \u0632\u0672\u0646\u06cd \u06cc\u0627 \u0646\u0627 \u0644\u064e\u06af\u06c1\u0655 \u06c1\u0627\u0631 \u0631\u064e\u0633\u0645\u064f\u0644 \u062e\u0638" },
            { "UA", "\u06cc\u0648\u0657\u0631\u0650\u06a9\u06cc\u0646" },
            { "rup", "\u0627\u064e\u0631\u0648\u0645\u0627\u0646\u06cc" },
            { "030", "\u0645\u064e\u0634\u0631\u0650\u0642\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "tyv", "\u062a\u064f\u0648\u06cc\u0656\u0646\u06cc\u064e\u0646" },
            { "034", "\u062c\u0646\u0648\u0657\u0628\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "hai", "\u06c1\u064e\u06cc\u062f\u0627" },
            { "035", "\u062c\u0646\u0648\u0657\u0628\u06c1\u0650 \u0645\u064e\u0634\u0631\u0650\u0642\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "UG", "\u06cc\u0648\u0657\u06af\u0627\u0646\u065b\u0691\u0627" },
            { "type.co.pinyin", "\u0622\u0633\u0627\u0646 \u0628\u064e\u0646\u0627\u0648\u0646\u06c1\u0655 \u0622\u0645\u064f\u062a \u0686\u06cc\u0656\u0646\u06cc \u067e\u06cc\u0656\u0646\u06cc\u064e\u0646 \u062a\u064e\u0631\u062a\u06cc\u0656\u0628" },
            { "039", "\u062c\u0646\u0648\u0657\u0628\u06cc \u06cc\u0648\u0657\u0631\u064e\u067e" },
            { "Sinh", metaValue_si },
            { "UM", "\u06cc\u0648\u0657\u0646\u0627\u06cc\u0679\u0650\u0691 \u0633\u0650\u0679\u06cc\u0679\u0650\u0633 \u0645\u0627\u06cc\u0646\u064e\u0631 \u0622\u0648\u064f\u0679\u0644\u06cc\u06cc\u0650\u0646\u065b\u06af \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "US", "\u06cc\u0648\u0657\u0646\u0627\u06cc\u0679\u0650\u0691 \u0633\u0650\u0679\u06cc\u0679\u0650\u0633" },
            { "haw", "\u06c1\u0648\u0627\u06cc\u0650\u06cc\u064e\u0646" },
            { "UY", "\u06cc\u0648\u0657\u0631\u0648\u06af\u06d2" },
            { "UZ", "\u0627\u064f\u0632\u0628\u0650\u06a9\u0650\u0633\u062a\u0627\u0646" },
            { "type.co.stroke", "\u0631\u066e\u06ea\u0648\u0672\u062a\u06cc \u0686\u06cc\u0656\u0646\u06cc \u0633\u0679\u0631\u0648\u06a9 \u062a\u064e\u0631\u062a\u06cc\u0656\u0628" },
            { "VA", "\u0648\u06cc\u0679\u0650\u06a9\u064e\u0646 \u0633\u0650\u0679\u06cc" },
            { "pro", "\u067e\u0631\u0648\u0646 \u067e\u0631\u0648\u0648\u06cc\u065a\u0646\u0686\u064e\u0644" },
            { "VC", "\u0633\u06cc\u0646\u065b\u0679 \u0648\u06cc\u0646\u0633\u066e\u06ea\u0679 \u062a\u06c1\u0655 \u06af\u0631\u065b\u06cc\u0646\u0627\u0691\u0627\u06cc\u0646\u0655\u0632" },
            { "VE", "\u0648\u06cc\u0646\u0627\u0632\u0648\u0657\u0644\u0627" },
            { "VG", "\u0628\u064e\u0631\u0637\u0627\u0646\u0648\u06cc \u0624\u0631\u062c\u0650\u0646 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "VI", "\u06cc\u0648\u0657 \u0627\u06cc\u0633 \u0624\u0631\u062c\u0650\u0646 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655" },
            { "VN", "\u0648\u06cc\u0679\u0650\u0646\u0627\u0645" },
            { "VU", "\u0648\u0627\u0646\u0648\u0657\u062a\u0648\u0657" },
            { "nog", "\u0646\u0648\u06af\u0627\u06d2" },
            { "non", "\u067e\u0631\u0648\u0646 \u0646\u0627\u0631\u0633\u06cc" },
            { "053", "\u0622\u0633\u0679\u0631\u06cc\u0644\u06cc\u0627 \u062a\u06c1\u0655 \u0646\u0650\u0648\u0632\u0650\u0644\u06cc\u0646\u065b\u0691" },
            { "054", "\u0645\u066e\u06ea\u0644\u064e\u0646\u06cc\u0656\u0634\u0650\u06cc\u0627" },
            { "WF", "\u0648\u0627\u0644\u0650\u0633 \u062a\u06c1\u0655 \u0641\u06cc\u0648\u0657\u0686\u0648\u0657\u0646\u0627" },
            { "type.co.traditional", "\u0631\u066e\u06ea\u0648\u0672\u062a\u06cc \u062a\u064e\u0631\u062a\u06cc\u0656\u0628" },
            { "057", "\u0645\u064e\u06cc\u06a9\u0631\u0648\u0646\u064e\u06cc\u0634\u0650\u06cc\u064e\u0646 \u062e\u0655\u0637\u06c1\u0655" },
            { "WS", "\u0633\u06cc\u0645\u0648\u0648\u0627" },
            { "wal", "\u0648\u0627\u0644\u0627\u0645\u0648" },
            { "was", "\u0648\u0627\u0634\u0648" },
            { "war", "\u0648\u064e\u0631\u06cc\u06d2" },
            { "awa", "\u0627\u064e\u0648\u064e\u062f\u06cc" },
            { "061", "\u067e\u0627\u0644\u0646\u06cc\u0634\u0650\u06cc\u0627" },
            { "Gujr", "\u06af\u0631\u06cc\u0656\u06a9" },
            { "Zxxx", "\u0644\u06cc\u065a\u06a9\u06be\u0646\u064e\u06d2" },
            { "Olck", "\u0627\u0648\u0644 \u0686\u0650\u06a9\u06cc" },
            { "Batk", "\u0628\u0627\u062a\u064e\u06a9" },
            { "Blis", "\u0628\u0650\u0644\u0650\u0633 \u0633\u0650\u0645\u0628\u0644\u0632" },
            { "YE", "\u06cc\u064e\u0645\u064e\u0646" },
            { "nqo", metaValue_nqo },
            { "fan", "\u0641\u06cc\u0646\u065b\u06af" },
            { "%%ROZAJ", metaValue_ru },
            { "fat", "\u0641\u0627\u0646\u0679\u06cc" },
            { "Sgnw", "\u0627\u0650\u0634\u0627\u0631\u0672\u062a\u06cc \u0644\u0650\u06a9\u06be\u0672\u06d2" },
            { "YT", "\u0645\u064e\u06cc\u06cc\u0679" },
            { "ZA", "\u062c\u064e\u0646\u0648\u0657\u0628\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627" },
            { "Deva", "\u062f\u06cc\u0648\u0646\u0627\u06af\u0631\u06cc" },
            { "Hira", "\u06c1\u06cc\u0656\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "ZM", "\u062c\u0627\u0645\u0628\u0650\u06cc\u0627" },
            { "ZW", "\u0632\u0650\u0645\u0628\u0627\u0628\u06d2" },
            { "ZZ", "\u0646\u0627\u0645\u0639\u0644\u0648\u0657\u0645 \u062a\u06c1\u0655 \u0646\u0627\u0644\u064e\u06af\u06c1\u0627\u0631 \u0639\u064e\u0644\u0627\u0642\u06c1\u0655" },
            { "Runr", "\u0631\u064e\u0646\u0650\u06a9" },
            { "lol", "\u0645\u0648\u0646\u065b\u06af\u0648" },
            { "nso", "\u0634\u0645\u0627\u0644\u06cc \u0633\u062a\u06be\u0648" },
            { "loz", "\u0644\u0648\u0632\u06cc" },
            { "hil", "\u06c1\u0650\u0644\u06cc\u0656\u06af\u06cc\u0646\u064e\u0646" },
            { "dak", "\u0688\u06a9\u0648\u0679\u0627" },
            { "hit", "\u06c1\u0650\u062a\u0627\u06cc\u0650\u062a" },
            { "dar", "\u062f\u064e\u0631\u06af\u0648\u0627" },
            { "Maya", "\u0645\u0627\u06cc\u064e\u0646 \u06c1\u06cc\u0656\u0631\u0648\u06af\u0644\u0650\u067e\u06be" },
            { "Copt", metaValue_cop },
            { "nwc", "\u06a9\u0644\u0627\u0633\u0650\u06a9\u064e\u0644 \u0646\u06cc\u0648\u0627\u0631\u06cc" },
            { "udm", "\u0627\u064f\u062f\u0645\u064f\u0631\u062a" },
            { "Khmr", "\u06a9\u06be\u0655\u0645\u06cc\u0631" },
            { "Limb", "\u0644\u0650\u0645\u0628\u0648\u0657" },
            { "sad", "\u0633\u064e\u0646\u062f\u064e\u0648\u06cc\u06d2" },
            { "sah", "\u06cc\u0627\u06a9\u064f\u062a" },
            { "sam", "\u0633\u064e\u0645\u0627\u0631\u0650\u062a\u064e\u0646 \u0627\u064e\u0631\u0627\u0645\u06cc\u06a9" },
            { "%%SCOUSE", "\u0633\u0650\u06a9\u0648\u0633" },
            { "sas", "\u0633\u064e\u0633\u064e\u06a9" },
            { "sat", "\u0633\u064e\u0646\u062a\u0627\u0644\u06cc" },
            { "Tfng", "\u062a\u0650\u0641\u0650\u0646\u0627\u06af" },
            { "jpr", "\u062c\u0648\u0688\u06cc\u0648 \u0641\u0627\u0631\u0633\u06cc" },
            { "Guru", "\u06af\u064f\u062c\u0631\u0672\u062a\u06cd" },
            { "lua", "\u0644\u0648\u0657\u0628\u0627 \u0644\u0648\u0657\u0644\u064f\u0648\u0627" },
            { "lui", "\u0644\u0648\u06cc\u0650\u0633\u06cc\u0646\u0648" },
            { "nyn", "\u0646\u0650\u06cc\u064e\u0646\u06a9\u0648\u0644" },
            { "nym", "\u0646\u0650\u06cc\u064e\u0645\u0648\u06cc\u065a\u0632\u06cc" },
            { "lun", "\u0644\u064f\u0646\u062f\u0627" },
            { "nyo", "\u0646\u0650\u06cc\u0648\u0631\u0648" },
            { "luo", "\u0644\u064f\u0648\u0648" },
            { "fil", "\u0641\u0650\u0644\u0650\u067e\u06cc\u0656\u0646\u0648" },
            { "hmn", "\u06c1\u0645\u0648\u0646\u065b\u06af" },
            { "del", "\u0688\u06cc\u065a\u0644\u0648\u06cc\u06cc\u064e\u0631" },
            { "lus", "\u0644\u064f\u0633\u06c1\u0627\u06d2" },
            { "bal", "\u0628\u064e\u0644\u0648\u0657\u0686\u06cc" },
            { "den", "\u0633\u0644\u06cc\u0648" },
            { "ban", "\u0628\u0627\u0644\u0650\u0646\u06cc\u0656\u0632" },
            { "uga", "\u0627\u064f\u06af\u0627\u0631\u062a\u0650\u06a9" },
            { "bas", "\u0628\u0627\u0633\u0627" },
            { "jrb", "\u062c\u0648\u0688\u06cc\u0648 \u0639\u0631\u0628\u06cc" },
            { "es_ES", "\u0644\u0650\u0628\u06cc\u0631\u06cc\u064e\u0646 \u0633\u067e\u06cc\u0646\u0650\u0634" },
            { "nzi", "\u0646\u064e\u0638\u06cc\u0656\u0645\u0627" },
            { "sco", "\u0633\u06a9\u0627\u0679\u0633" },
            { "scn", "\u0633\u0650\u0686\u0650\u0644\u0650\u06cc\u064e\u0646" },
            { "aa", "\u0627\u064e\u0641\u0627\u0631" },
            { "ab", "\u0627\u064e\u0628\u062e\u0627\u0632\u0650\u06cc\u0627\u0646" },
            { "ae", metaValue_ae },
            { "af", "\u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u0627\u0646\u065b\u0632" },
            { "ak", "\u0627\u064e\u06a9\u0627\u0646" },
            { "am", "\u0627\u064e\u0645\u06c1\u0627\u0631\u06cc" },
            { "an", "\u0627\u064e\u0631\u0627\u06af\u0648\u0646\u06cc" },
            { "Arab", "\u0627\u064e\u0631\u0628\u06cc" },
            { "%%SOLBA", "\u062b\u0679\u0648\u0644\u0648\u0650\u0632\u0627/\u0633\u0648\u0644\u0628\u0650\u06a9\u0627 \u0628\u0648\u0657\u0644\u06cd" },
            { "Jpan", "\u062c\u06cc\u065a\u067e\u064e\u0646\u06cc\u0656\u0632" },
            { "ar", "\u0639\u0631\u0628\u06cc" },
            { "Hrkt", "\u06a9\u064e\u0679\u0627\u06a9\u0627\u0646\u0627 \u06cc\u0627 \u06c1\u0650\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "as", "\u0627\u0633\u0672\u0645\u06cd" },
            { "Lina", "\u0644\u06cc\u0656\u0646\u06cc\u064e\u0631 \u0627\u06d2" },
            { "av", "\u0627\u064e\u0648\u0627\u0631\u0650\u06a9" },
            { "Linb", "\u0644\u06cc\u0656\u0646\u06cc\u064e\u0631 \u0628\u06cc" },
            { "ay", "\u0627\u06cc\u0645\u0627\u0631\u0627" },
            { "az", "\u0627\u064e\u0632\u064e\u0631\u0628\u06cc\u062c\u0627\u0646\u06cc" },
            { "%%OSOJS", "\u0627\u064f\u0634\u06cc\u06a9\u0648/\u0627\u0648\u0633\u0648\u062c\u06cc\u0646 \u0628\u0648\u0657\u0644\u06cd" },
            { "ba", "\u0628\u064e\u0634\u06a9\u06cc\u0656\u0631" },
            { "be", "\u0628\u06cc\u0644\u064e\u0631\u0648\u0657\u0634\u06cc\u064e\u0646" },
            { "bg", "\u0628\u06cc\u0646\u0627" },
            { "bi", "\u0628\u0650\u0633\u0644\u0627\u0645\u0627" },
            { "bm", "\u0628\u064e\u0645\u0628\u0627\u0631\u0627" },
            { "bn", "\u0628\u064e\u0646\u065b\u06af\u0672\u0644\u06cd" },
            { "bo", metaValue_bo },
            { "dgr", "\u0688\u0627\u06af\u0631\u0650\u0628" },
            { "br", "\u0628\u0631\u06cc\u0679\u064e\u0646" },
            { "bs", "\u0628\u0648\u0633\u0646\u0650\u06cc\u064e\u0646" },
            { "Mymr", "\u0645\u064e\u06cc\u064e\u0646\u0645\u0627\u0631" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u0633\u06cc\u065a\u0644\u06a9\u064f\u067e" },
            { "ca", "\u06a9\u064e\u062a\u0644\u0627\u0646" },
            { "ce", "\u0686\u06cc\u0686\u064e\u0646" },
            { "ch", "\u06a9\u064e\u0645\u0648\u0631\u0648" },
            { "%%REVISED", "\u062f\u064f\u0628\u0627\u0631\u0655 \u062f\u06c4\u06c1\u0631\u0627\u0648\u0646\u06c1\u0655 \u0622\u0645\u064f\u062a \u0639\u0650\u0644\u0645\u06c1\u0650 \u06c1\u0650\u062c\u0627" },
            { "co", "\u06a9\u0627\u0631\u0633\u0650\u06a9\u064e\u0646" },
            { "Orya", "\u0627\u0648\u0631\u0650\u06cc\u0627" },
            { "cr", "\u06a9\u0631\u06cc" },
            { "cs", "\u0686\u06cc\u065a\u06a9" },
            { "cu", "\u0686\u0654\u0631\u0686 \u0633\u0644\u0627\u0648\u0650\u06a9" },
            { "cv", "\u0686\u064f\u0648\u0627\u0634" },
            { "cy", "\u0648\u06cc\u065a\u0644\u0634" },
            { "Yiii", "\u06cc\u0656\u06cc" },
            { "da", "\u0688\u06cc\u0646\u0650\u0634" },
            { "pt_PT", "\u0644\u0650\u0628\u06cc\u0631\u06cc\u064e\u0646 \u067e\u064f\u0631\u062a\u064e\u06af\u06cc\u0656\u0632" },
            { "de", "\u062c\u0654\u0631\u0645\u064e\u0646" },
            { "bej", "\u0628\u06cc\u062c\u0627" },
            { "din", "\u0688\u0650\u0646\u06a9\u0627" },
            { "Bugi", "\u0628\u064f\u06af\u0650\u0646\u06cc\u0656\u0632" },
            { "bem", "\u0628\u06cc\u065a\u0645\u0628\u0627" },
            { "sga", "\u067e\u0631\u0648\u0646 \u0627\u06cc\u0631\u0650\u0634" },
            { "dv", "\u062f\u0650\u0648\u06cc\u06c1\u06cc" },
            { "es_419", "\u0644\u06cc\u0679\u0655\u0646 \u0627\u0645\u0631\u06cc\u0656\u06a9\u06cc \u0633\u067e\u06cc\u0646\u0650\u0634" },
            { "dz", "\u0632\u0648\u0646\u065b\u06af\u06a9\u06be\u0627" },
            { "type.ca.chinese", "\u0686\u06cc\u0656\u0646\u06cc \u06a9\u06cc\u0644\u064e\u0646\u0691\u064e\u0631" },
            { "ee", "\u0627\u06cc\u0656\u0648" },
            { "ro_MD", "\u0645\u0648\u0644\u062f\u0627\u0648\u0650\u06cc\u064e\u0646" },
            { "el", "\u06cc\u0648\u0657\u0646\u0672\u0646\u06cc" },
            { "en", "\u0627\u064e\u0646\u065b\u06af\u06cc\u0656\u0632\u06cd" },
            { "eo", "\u0627\u06cc\u065a\u0633\u067e\u064e\u0631\u06cc\u0646\u0679\u0648" },
            { "type.co.big5han", "\u0631\u066e\u06ea\u0648\u0672\u062a\u06cc \u0686\u06cc\u0656\u0646\u06cc \u062a\u0650\u0631\u062a\u06cc\u0656\u0628" },
            { "es", "\u0633\u067e\u06cc\u0646\u0650\u0634" },
            { "et", "\u0627\u06cc\u065a\u0633\u0679\u0648\u0646\u06cc\u064e\u0646" },
            { "eu", "\u0628\u0627\u0633\u06a9" },
            { "Buhd", "\u0628\u064f\u06c1\u0650\u062f" },
            { "Hang", "\u06c1\u0627\u0646\u065b\u06af\u064f\u0644" },
            { "Samr", "\u0633\u064e\u0645\u0627\u0631\u0650\u0679\u064e\u0646" },
            { "hsb", "\u06c1\u06cc\u065a\u0631\u0650\u0645 \u0633\u0627\u0631\u0628\u0650\u06cc\u064e\u0646" },
            { "Hani", "\u06c1\u0627\u0646" },
            { "shn", "\u0634\u0627\u0646" },
            { "Hano", "\u06c1\u0627\u0646\u064f\u0646\u0648\u0657" },
            { "fa", "\u0641\u0627\u0631\u0633\u06cc" },
            { "Hans", "\u0633\u0650\u0645\u067e\u0644\u0650\u0641\u0627\u06cc\u0650\u0691 \u06c1\u0627\u0646" },
            { "Hant", "\u0679\u0631\u06cc\u0691\u0650\u0634\u064e\u0646\u064e\u0644" },
            { "ff", "\u0641\u064f\u0644\u0627\u06c1" },
            { "fi", "\u0641\u0650\u0646\u0650\u0634" },
            { "fj", "\u0641\u0650\u062c\u06cc\u064e\u0646" },
            { "fon", "\u0641\u0648\u0646" },
            { "fo", "\u0641\u064e\u0631\u0648\u0633" },
            { "umb", "\u06cc\u064f\u0645\u0628\u064f\u0646\u062f\u0648\u0657" },
            { "fr", "\u0641\u0631\u06cc\u065a\u0646\u0686" },
            { "sid", "\u0633\u0650\u062f\u0627\u0645\u0648" },
            { "fy", "\u0645\u063a\u0631\u0628\u06cc \u0641\u0631\u0650\u0634\u06cc\u064e\u0646" },
            { "ga", "\u0627\u064e\u06cc\u0631\u0650\u0634" },
            { "gd", "\u0633\u06a9\u0648\u0679\u0650\u0634 \u06af\u06cc\u06d2\u0644\u0650\u06a9" },
            { "gl", "\u06af\u06cc\u0644\u0650\u0634\u0650\u06cc\u064e\u0646" },
            { "gn", "\u06af\u064f\u0648\u0627\u0631\u064e\u0646\u06cc" },
            { "bho", "\u0628\u0648\u062c\u067e\u0648\u0657\u0631\u06cc" },
            { "und", "\u0627\u064e\u0646\u0632\u0672\u0646\u06cd \u06cc\u0627 \u0646\u064e\u06c1 \u0644\u064e\u06af\u06c1\u0655\u06c1\u0627\u0631 \u0632\u0628\u0627\u0646" },
            { "gu", "\u06af\u064f\u062c\u0631\u0672\u062a\u06cc" },
            { "gv", "\u0645\u06cc\u0646\u065b\u06a9\u0633" },
            { "ha", "\u06c1\u0627\u0648\u0633\u0627" },
            { "he", "\u0639\u0628\u0631\u0672\u0646\u06cd" },
            { "hi", "\u06c1\u0650\u0646\u062f\u06cc" },
            { "hup", "\u06c1\u064f\u067e\u0627" },
            { "bik", "\u0628\u0650\u06a9\u0648\u0644" },
            { "bin", "\u0628\u0650\u0646\u06cc" },
            { "ho", "\u06c1\u0650\u0631\u06cc \u0645\u0648\u062a\u0648\u0657" },
            { "hr", "\u06a9\u0631\u0648\u0634\u0650\u06cc\u064e\u0646" },
            { "ht", "\u06c1\u06cc\u062a\u0650\u06cc\u0627\u06ba" },
            { "hu", "\u06c1\u064e\u0646\u065b\u06af\u06cc\u0631\u06cc\u064e\u0646" },
            { "hy", "\u0627\u064e\u0631\u0645\u06cc\u0646\u06cc\u064e\u0646" },
            { "hz", "\u06c1\u06cc\u065a\u0631\u06cc\u0656\u0631\u0648" },
            { "%%FONIPA", "\u0622\u0648\u0627\u0632\u06cc\u0627\u062a" },
            { "ia", "\u0627\u0650\u0646\u0679\u064e\u0631\u0644\u0650\u0646\u065b\u06af\u0648\u0627" },
            { "id", "\u0627\u0650\u0646\u0688\u0648\u0646\u06cc\u0634\u06cc\u0627" },
            { "ie", "\u0627\u0650\u0646\u0679\u064e\u0631 \u0644\u0650\u0646\u065b\u0646\u06af\u0648\u06cc\u06d2" },
            { "ig", "\u0627\u0650\u06af\u0628\u0648" },
            { "ii", "\u0633\u0650\u0686\u0648\u0627\u0646 \u06cc\u0656\u06cc" },
            { "frm", "\u0648\u0633\u0637\u06cc \u0641\u0631\u06cc\u065a\u0646\u0686" },
            { "ik", "\u0627\u0650\u0646\u064f\u067e\u0650\u06cc\u0627\u06a9" },
            { "fro", "\u067e\u0631\u0648\u0646 \u0641\u0631\u06cc\u065a\u0646\u0686" },
            { "io", "\u0627\u0650\u0688\u0648" },
            { "frs", "\u0645\u0634\u0631\u0650\u0642\u06cc \u0641\u0631\u0650\u0634\u06cc\u064e\u0646" },
            { "frr", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0641\u0631\u0650\u0634\u06cc\u064e\u0646" },
            { "is", "\u0622\u06cc\u0650\u0633\u0644\u06cc\u0646\u0688\u0650\u06a9" },
            { "it", "\u0627\u0650\u0679\u06cc\u0644\u06cc\u064e\u0646" },
            { "iu", "\u0627\u0650\u0646\u064f\u06a9\u062a\u0650\u062a\u0648\u0657" },
            { "ja", "\u062c\u0627\u067e\u0672\u0646\u06cd" },
            { "Mlym", "\u0645\u064e\u0644\u06cc\u0627\u0644\u064e\u0645" },
            { "Sara", "\u0633\u064e\u0631\u0627\u062a\u06cc" },
            { "doi", "\u0688\u0648\u06af\u0631\u06cc" },
            { "sma", "\u062c\u0646\u0648\u0657\u0628\u06cc \u0633\u064e\u0645\u06cc" },
            { "jv", "\u062c\u064e\u0648\u064e\u0646\u06cc\u0656\u0632" },
            { "Shaw", "\u0634\u0627\u0648\u06cc\u064e\u0646" },
            { "mad", "\u0645\u064e\u062f\u064f\u0631\u06cc\u0656\u0632" },
            { "smj", "\u0644\u0648\u0644\u06cc\u06d2 \u0633\u064e\u0645\u06cc" },
            { "mag", "\u0645\u064e\u06af\u0627\u06d2" },
            { "mai", "\u0645\u06cc\u062a\u064e\u06be\u0644\u06cc" },
            { "smn", "\u0627\u0650\u0646\u0627\u0631\u06cc \u0633\u064e\u0645\u06cc" },
            { "ka", metaValue_ka },
            { "bla", "\u0633\u0650\u06a9\u0633\u0650\u06a9\u0627" },
            { "mak", "\u0645\u064e\u06a9\u064e\u0633\u0627\u0631" },
            { "sms", "\u0633\u06a9\u0648\u0644\u0679 \u0633\u064e\u0645\u06cc" },
            { "man", "\u0645\u064e\u0646\u062f\u0650\u0646\u065b\u06af\u0648" },
            { "kg", "\u06a9\u0648\u0646\u065b\u06af\u0648" },
            { "Goth", metaValue_got },
            { "ki", "\u06a9\u0650\u06a9\u064f\u06cc\u0648\u0657" },
            { "mas", "\u0645\u064e\u0633\u0627\u06d2" },
            { "kj", "\u06a9\u064f\u0648\u0627\u0646\u06cc\u0627\u0645\u0627" },
            { "kk", "\u06a9\u0627\u0632\u064e\u062e" },
            { "kl", "\u06a9\u064e\u0644\u0627\u0644\u0650\u0633\u064f\u062a" },
            { "km", "\u062e\u064e\u0645\u06cc\u0631" },
            { "kn", "\u06a9\u064e\u0646\u064e\u0691" },
            { "ko", metaValue_ko },
            { "kr", "\u06a9\u064e\u0646\u0648\u0657\u0631\u06cc" },
            { "ks", "\u06a9\u0672\u0634\u064f\u0631" },
            { "Cirt", "\u06a9\u0650\u0631\u062a\u06be" },
            { "Lepc", "\u0644\u06cc\u065a\u067e\u06a9\u0627" },
            { "Avst", metaValue_ae },
            { "ku", "\u06a9\u064f\u0631\u062f\u0650\u0634" },
            { "kv", "\u06a9\u0648\u0645\u06cc" },
            { "kw", "\u06a9\u0648\u0631\u0646\u0650\u0634" },
            { "ky", "\u06a9\u0650\u0631\u06af\u0650\u0632" },
            { "snk", "\u0633\u0648\u0646\u0650\u0646\u06a9\u06cc\u06d2" },
            { "la", "\u0644\u0627\u062a\u06cc\u0656\u0646\u06cc" },
            { "lb", "\u0644\u064f\u06a9\u06be\u0632\u06cc\u0645\u0628\u0648\u0631\u06af\u0650\u0634" },
            { "lg", "\u06af\u0627\u0646\u062f\u0627" },
            { "Roro", "\u0631\u0648\u0646\u065b\u06af\u0648 \u0631\u0648\u0646\u065b\u06af\u0648" },
            { "li", "\u0644\u0650\u0645\u0628\u0654\u0631\u06af\u0650\u0634" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0644\u0650\u0646\u06af\u0627\u0644\u0627" },
            { "fur", "\u0641\u0631\u0648\u0657\u0644\u0650\u06cc\u064e\u0646" },
            { "lo", metaValue_lo },
            { "lt", "\u0644\u0650\u062a\u06be\u0648\u0627\u0646\u0650\u06cc\u064e\u0646" },
            { "lu", "\u0644\u0648\u064f\u0628\u0627 \u06a9\u064e\u062a\u064e\u0646\u065b\u06af\u0627" },
            { "lv", "\u0644\u064e\u062a\u0648\u0650\u06cc\u064e\u0646" },
            { "sog", "\u0633\u0648\u06af\u0688\u0650\u06cc\u064e\u0646" },
            { "mg", "\u0645\u064e\u0644\u0627\u06af\u064e\u0633\u06cc" },
            { "mh", "\u0645\u0627\u0631\u0634\u064e\u0644\u06cc\u0656\u0632" },
            { "mi", "\u0645\u0627\u0648\u0631\u06cc" },
            { "mk", "\u0645\u06cc\u06a9\u064e\u0688\u0648\u0646\u06cc\u064e\u0646" },
            { "ml", "\u0645\u0654\u0644\u06cc\u0627\u0644\u064e\u0645" },
            { "mn", "\u0645\u064e\u0646\u065b\u06af\u0648\u0644\u06cc" },
            { "mr", "\u0645\u064e\u0631\u0672\u0679\u06be\u06cd" },
            { "ms", "\u0645\u064e\u0644\u064e\u06d2" },
            { "mt", "\u0645\u064e\u0644\u062a\u06cc\u0656\u0633" },
            { "my", "\u0628\u0654\u0645\u06cc\u0656\u0632" },
            { "Saur", "\u0633\u0648\u0631\u0627\u0634\u0679\u0631\u0627" },
            { "Armn", "\u0627\u064e\u0631\u0645\u0627\u0646\u06cc\u064e\u0646" },
            { "mdf", "\u0645\u0648\u06a9\u0634\u0627" },
            { "dsb", "\u0628\u0648\u065a\u0646\u0650\u0645 \u0633\u0627\u0631\u0628\u0650\u06cc\u064e\u0646" },
            { "na", "\u0646\u0627\u0648\u0631\u064f" },
            { "nb", "\u0646\u0627\u0631\u0648\u06cc\u06cc\u064e\u0646 \u0628\u0648\u06a9\u0645\u0627\u0644" },
            { "nd", "\u0634\u064f\u0645\u0627\u0644 \u0688\u064e\u0628\u06cc\u0644" },
            { "ne", "\u0646\u06cc\u065a\u067e\u0672\u0644\u06cd" },
            { "ng", "\u0688\u0648\u0646\u065b\u06af\u0627" },
            { "mdr", "\u0645\u064e\u0646\u062f\u064e\u0631" },
            { "nl", "\u0688\u064e\u0686" },
            { "nn", "\u0646\u0627\u0631\u0648\u06cc\u06cc\u064e\u0646 \u0646\u064e\u06d2 \u0646\u0648\u0631\u0633\u06a9" },
            { "no", "\u0646\u0627\u0631\u0648\u06cc\u06cc\u064e\u0646" },
            { "nr", "\u062c\u0646\u0648\u0628 \u0688\u06cc\u065a\u0628\u06cc\u0644" },
            { "nv", "\u0646\u064e\u0648\u0627\u062c\u0648" },
            { "kaa", "\u06a9\u0627\u0631\u0627 \u06a9\u064e\u0644\u067e\u064e\u06a9" },
            { "ny", "\u0646\u0650\u06cc\u064e\u0646\u062c\u0627" },
            { "kac", "\u06a9\u0627\u0686\u0650\u0646" },
            { "kab", "\u06a9\u064e\u0628\u0627\u06cc\u0650\u0644" },
            { "%%POLYTON", "\u0648\u0627\u0631\u06cc\u0627\u06c1 \u0644\u06c1\u062c\u06c1\u0655 \u0648\u0627\u062c\u066e\u06ea\u0646 \u0632\u064e\u0628\u0627\u0646" },
            { "oc", "\u0627\u0648\u06a9\u0633\u06cc\u0656\u0679\u064e\u0646" },
            { "kaj", "\u062c\u064f\u0648\u0657" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627" },
            { "men", "\u0645\u06cc\u0646\u062f\u06cc\u06d2" },
            { "oj", "\u0627\u0648\u062c\u0650\u0628\u0648\u0627" },
            { "om", "\u0627\u0648\u065a\u0631\u0648\u0645\u0648" },
            { "kaw", "\u06a9\u064e\u0648\u06cc" },
            { "or", "\u0627\u0648\u065a\u0631\u0650\u06cc\u0627" },
            { "os", "\u0627\u0648\u065a\u0633\u06cc\u065a\u0679\u0650\u06a9" },
            { "kbd", "\u06a9\u064e\u0628\u0627\u0631\u0688\u0650\u06cc\u064e\u0646" },
            { "srn", "\u0633\u0631\u065b\u0627\u0646\u064e\u0646 \u0679\u0648\u0646\u065b\u06af\u0648" },
            { "pa", "\u067e\u064e\u0646\u062c\u0672\u0628\u06cd" },
            { "dua", "\u062f\u064f\u0648\u0627\u0644\u0627" },
            { "srr", "\u0633\u06cc\u065a\u0631\u06cc\u0631" },
            { "%%LIPAW", "\u0631\u0648\u0657\u0633\u06cc \u0632\u064e\u0628\u0627\u0646\u06c1\u0650 \u06c1\u0650\u0646\u065b\u0632 \u0644\u0650\u067e\u0648\u0648\u0627\u0632 \u0628\u0648\u0657\u0644\u06cd" },
            { "pi", "\u067e\u0627\u0644\u06cc" },
            { "pl", "\u067e\u0627\u0644\u0650\u0634" },
            { "dum", "\u0648\u064e\u0633\u062a\u06cc \u067e\u064f\u0631\u062a\u064f\u06af\u0627\u0644\u06cc" },
            { "ps", "\u067e\u064e\u0634\u062a\u0648\u0657" },
            { "pt", "\u067e\u064f\u0631\u062a\u064e\u06af\u06cc\u0656\u0632" },
            { "mga", "\u0648\u064e\u0633\u062a\u06cc \u0627\u06cc\u0631\u0650\u0634" },
            { "pt_BR", "\u0628\u0631\u0627\u0632\u06cc\u0656\u0644\u06cc \u067e\u064f\u062a\u064e\u06af\u06cc\u0656\u0632" },
            { "kcg", "\u062a\u064e\u06cc\u064e\u067e" },
            { "bra", "\u0628\u0631\u065b\u062c" },
            { "key.ca", "\u06a9\u06cc\u0644\u0646\u0691\u0631" },
            { "Laoo", metaValue_lo },
            { "qu", "\u06a9\u064f\u0648\u06cc\u0634\u064f\u0648\u0627" },
            { "zap", "\u0632\u064e\u067e\u0648\u062a\u06cc\u065a\u06a9" },
            { "Lana", "\u0644\u0627\u0646\u0627" },
            { "Ethi", "\u0627\u0650\u062a\u06be\u06cc\u0648\u067e\u0650\u06a9" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u0634" },
            { "rn", "\u0631\u064f\u0646\u062f\u06cc" },
            { "key.cu", "\u0636\u064e\u0631\u0628" },
            { "ro", "\u0631\u0648\u0645\u0672\u0646\u06cc" },
            { "%%SAAHO", "\u0633\u0648\u06c1\u0648" },
            { "ru", metaValue_ru },
            { "rw", "\u06a9\u0650\u0646\u06cc\u0627\u0648\u0650\u0646\u062f\u0627" },
            { "mic", "\u0645\u0650\u06a9\u0645\u06cc\u06a9" },
            { "suk", "\u0633\u064f\u06a9\u064f\u0645\u0627" },
            { "en_AU", "\u0622\u0633\u0679\u0631\u06cc\u0644\u06cc\u064e\u0646 \u0627\u064e\u0646\u065b\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "sa", "\u0633\u064e\u0646\u0633\u06a9\u0631\u0655\u062a" },
            { "sc", "\u0633\u0631\u0627\u0688\u06cc\u0656\u0646\u06cc" },
            { "sus", "\u0633\u064f\u0633\u0648\u0657" },
            { "sd", "\u0633\u0650\u0646\u062f\u06cc" },
            { "se", "\u0634\u064f\u0645\u0672\u0644\u06cc \u0633\u064e\u0645\u06cc" },
            { "min", "\u0645\u0650\u0646\u064e\u0646\u065b\u06af\u06a9\u064e\u0628\u0627\u0648" },
            { "sg", "\u0633\u064e\u0646\u06af\u0648" },
            { "sh", "\u0633\u06cc\u065a\u0631\u0628\u0648 \u06a9\u0631\u0648\u0634\u0650\u06cc\u064e\u0646" },
            { "si", metaValue_si },
            { "sux", "\u0633\u064f\u0645\u06cc\u0631\u06cc\u064e\u0646" },
            { "sk", "\u0633\u0644\u0648\u0648\u064e\u06a9" },
            { "sl", "\u0633\u0644\u0648\u0648\u06cc\u0646\u06cc\u064e\u0646" },
            { "sm", "\u0633\u064e\u0645\u0648\u0627\u064e\u0646" },
            { "sn", "\u0634\u0648\u0646\u0627" },
            { "so", "\u0633\u0648\u0645\u0672\u0644\u06cc" },
            { "sq", "\u0627\u0644\u0628\u0627\u0646\u0650\u06cc\u064e\u0646" },
            { "sr", "\u0633\u0654\u0631\u0628\u0650\u06cc\u064e\u0646" },
            { "ss", "\u0633\u0648\u0627\u062a\u06cc" },
            { "st", "\u062c\u0646\u0648\u0628\u06cc \u0633\u062a\u06be\u0648" },
            { "Java", "\u062c\u0627\u0648\u064e\u0646\u06cc\u0656\u0632" },
            { "su", metaValue_su },
            { "%%NEDIS", "\u0646\u066e\u06ea\u0679\u0650\u0633\u0648\u0646 \u0628\u0648\u0657\u0644\u06cd" },
            { "sv", "\u0633\u0648\u06cc\u0656\u0688\u0650\u0634" },
            { "sw", "\u0633\u0648\u0627\u06c1\u0650\u0644\u06cc" },
            { "iba", "\u0627\u0650\u0628\u0627\u0646" },
            { "ta", metaValue_ta },
            { "142", "\u0627\u06cc\u0634\u06cc\u0627" },
            { "bua", "\u0628\u064f\u0631\u0650\u06cc\u064e\u062a" },
            { "143", "\u0645\u0631\u06a9\u0654\u0632\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "te", metaValue_te },
            { "145", "\u0645\u064e\u063a\u0631\u0650\u0628\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "tg", "\u062a\u0627\u062c\u0650\u06a9" },
            { "th", metaValue_th },
            { "ti", "\u0679\u0650\u06af\u0631\u0650\u0646\u06cc\u0627" },
            { "bug", "\u0628\u064e\u06af\u0646\u06cc\u0656\u0632" },
            { "kfo", "\u06a9\u0648\u0631\u0648" },
            { "en_CA", "\u06a9\u06cc\u0646\u064e\u0688\u0650\u06cc\u0672\u06cc\u06cc \u0627\u064e\u0646\u065b\u06af\u0631\u06cc\u0656\u0632\u06cd" },
            { "tk", "\u062a\u064f\u0631\u06a9\u0645\u06cc\u0646" },
            { "tl", "\u062a\u064e\u0645\u0627\u0634\u06cc\u06a9" },
            { "tn", "\u0633\u0648\u0627\u0646\u0627" },
            { "to", metaValue_TO },
            { "tr", "\u062a\u064f\u0631\u06a9\u0650\u0634" },
            { "ts", "\u0698\u0648\u0646\u065b\u06af\u0627" },
            { "tt", "\u062a\u064e\u062a\u0627\u0631" },
            { "dyu", "\u0688\u0650\u06cc\u0648\u0657\u0644\u0627" },
            { "tw", "\u062a\u0648\u06cc" },
            { "ty", "\u062a\u0627\u06c1\u06cc\u0634\u0650\u06cc\u064e\u0646" },
            { "%%BISKE", "\u0633\u06cc\u0646 \u062c\u0627\u0631\u062c\u0650\u06cc\u0648/\u0628\u0650\u0644\u0627 \u0628\u0648\u0657\u0644\u06cd" },
            { "150", "\u06cc\u0648\u0657\u0631\u064e\u067e" },
            { "151", "\u0645\u0634\u0631\u0650\u0642\u06cc \u06cc\u0648\u0657\u0631\u064e\u067e" },
            { "154", "\u0634\u064f\u0645\u0672\u0644\u06cc \u06cc\u0648\u0657\u0631\u064e\u067e" },
            { "155", "\u0645\u063a\u0631\u0650\u0628\u06cc \u06cc\u0648\u0657\u0631\u064e\u067e" },
            { "Kore", metaValue_ko },
            { "Ital", "\u0627\u0648\u0644\u0688 \u0627\u0650\u0679\u06cc\u0644\u0650\u06a9" },
            { "Zyyy", "\u0639\u0627\u0645" },
            { "uk", "\u06cc\u0648\u0657\u06a9\u0631\u06cc\u0646\u06cc\u0672\u06cc\u06cc" },
            { "ur", "\u0627\u064f\u0631\u062f\u0648\u0657" },
            { "%%1994", "\u0645\u064e\u06cc\u0639\u0672\u0631\u06cc \u0631\u0648\u0657\u0633\u06cc \u0639\u0650\u0644\u0645\u06c1\u0650 \u06c1\u0650\u062c\u0627" },
            { "xal", "\u06a9\u0627\u0644\u0645\u0650\u06a9" },
            { "zen", "\u0632\u06cc\u0646\u0627\u06af\u0627" },
            { "uz", "\u0627\u064f\u0632\u0628\u06cc\u06a9" },
            { "kha", "\u06a9\u06be\u0627\u0633\u06cc" },
            { "%%1996", "\u062c\u0654\u0631\u0645\u064e\u0646 \u0639\u0650\u0644\u0645\u06c1\u0650 \u06c1\u0650\u062c\u0627 \u06f1\u06f9\u06f9\u06f6\u0633\u064f\u06a9" },
            { "Sylo", "\u0633\u06cc\u0644\u0648\u062a\u06cc \u0646\u0627\u06af\u0631\u06cc" },
            { "ve", "\u0648\u06cc\u0646\u062f\u0627" },
            { "type.ca.roc", "\u062c\u0645\u0648\u0657\u0631\u06cc\u0672\u062a\u06cc \u0686\u06cc\u0656\u0646\u06cc \u06a9\u06cc\u0644\u064e\u0646\u0691\u064e\u0631" },
            { "vi", "\u0648\u0650\u06cc\u064e\u062a\u0646\u064e\u0645\u06cc\u0656\u0632" },
            { "kho", "\u06a9\u06be\u0648\u062a\u064e\u0646\u06cc\u0656\u0632" },
            { "%%TARASK", "\u062a\u0627\u0631\u0627\u0633\u06a9\u06cc\u0656\u0648\u0650\u06a9\u0627 \u0639\u0644\u0645\u06c1 \u06c1\u0650\u062c\u0627\u0650" },
            { "vo", "\u0648\u0648\u0644\u064e\u067e\u064f\u06a9" },
            { "Osma", "\u0627\u0648\u0633\u0645\u0627\u0646\u06cc\u0627" },
            { "gaa", "\u06af\u0627" },
            { "wa", "\u0648\u064e\u0644\u0648\u0657\u0646" },
            { "syr", "\u0633\u06cc\u0656\u0631\u06cc\u0672\u06cc\u06cc" },
            { "Grek", "\u06af\u0631\u064e\u0646\u062a\u06be\u0627" },
            { "Lydi", "\u0644\u06cc\u062f\u0650\u06cc\u064e\u0646" },
            { "Xsux", "\u0633\u064f\u0645\u06cc\u0631\u0648 \u0627\u06a9\u0627\u062f\u06cc\u064e\u0646 \u06a9\u0648\u0657\u0646\u0650\u0641\u0627\u0645" },
            { "wo", "\u0648\u0648\u0644\u0648\u0641" },
            { "Cans", "\u06cc\u064f\u0646\u0650\u0641\u0627\u06cc\u0650\u0691 \u06a9\u0646\u06cc\u0691\u0650\u06cc\u064e\u0646 \u0627\u06cc\u065a\u0628 \u0622\u0631\u062c\u0650\u0646\u064e\u0644 \u0633\u0650\u0644\u06cc\u0628\u0650\u06a9" },
            { "gay", "\u06af\u06cc\u06d2\u06cc\u0648" },
            { "Mong", "\u0645\u064e\u0646\u065b\u06af\u0648\u0644\u06cc\u064e\u0646" },
            { "mnc", "\u0645\u0627\u0646\u065b\u0686\u0648\u0657" },
            { "Latf", "\u0641\u0631\u065b\u06a9\u062a\u064f\u0631 \u0644\u06cc\u0679\u0650\u0646" },
            { "gba", "\u06af\u0628\u0627\u06cc\u0627" },
            { "mni", "\u0645\u064e\u0646\u06cc\u067e\u0648\u0657\u0631\u06cc" },
            { "Latn", "\u0644\u06cc\u0679\u0650\u0646" },
            { "Latg", "\u06af\u06cc\u0644\u0650\u06a9 \u0644\u06cc\u0679\u064e\u0646" },
            { "xh", "\u06a9\u06be\u0648\u0633\u0627" },
            { "byn", "\u0628\u0655\u0644\u0650\u0646" },
            { "Lyci", "\u0644\u06cc\u0633\u0650\u06cc\u064e\u0646" },
            { "osa", "\u0627\u0648\u065a\u0633\u06cc\u062c" },
            { "Moon", "\u0645\u0648\u0657\u0646" },
            { "moh", "\u0645\u0648\u06c1\u0627\u06a9" },
            { "yi", "\u06cc\u0650\u062f\u0650\u0634" },
            { "mos", "\u0645\u0648\u0633\u06cc" },
            { "Syrc", "\u0633\u06cc\u0656\u0631\u0650\u06cc\u064e\u06a9" },
            { "Dsrt", "\u0688\u06cc\u065a\u0633\u0654\u0631\u06cc\u065a\u0679" },
            { "yo", "\u06cc\u0648\u0631\u064f\u0628\u0627" },
            { "Syrj", "\u0645\u063a\u0631\u0650\u0628\u06cc \u0633\u06cc\u0656\u0631\u06cc\u064e\u06a9" },
            { "ota", "\u0627\u0648\u0679\u0648\u0645\u064e\u0646 \u062a\u064f\u0631\u06a9\u0650\u0634" },
            { "Syre", "\u0627\u06cc\u065a\u0633\u0679\u0631\u06cc\u0646\u062c\u0650\u0644\u0648 \u0633\u06cc\u0656\u0631\u0650\u06cc\u064e\u06a9" },
            { "vai", metaValue_vai },
            { "za", "\u0632\u064f\u06c1\u0627\u0646\u065b\u06af" },
            { "Cari", "\u06a9\u0627\u0631\u06cc\u064e\u0646" },
            { "zh", "\u0686\u06cc\u0656\u0646\u06cc" },
            { "Bopo", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648" },
            { "Perm", "\u0627\u0648\u0644\u0688 \u067e\u0654\u0631\u0645\u0650\u06a9" },
            { "zu", "\u0632\u064f\u0644\u0648\u0657" },
            { "type.co.phonebook", "\u0641\u0648\u0646 \u0628\u064f\u06a9 \u062a\u064e\u0631\u062a\u06cc\u0656\u0628" },
            { "%%MONOTON", "\u0627\u064e\u06a9\u0654\u06d2 \u0644\u06c1\u062c\u06c1\u0655 \u0648\u0627\u062c\u066e\u06ea\u0646 \u0632\u064e\u0628\u0627\u0646" },
            { "Geor", metaValue_ka },
            { "kmb", "\u06a9\u0650\u0645\u0628\u064f\u0646\u062f\u0648\u0657" },
            { "Cham", "\u0686\u064e\u0645" },
            { "gez", "\u06af\u06cc\u0656\u0632" },
            { "Syrn", "\u0645\u0634\u0631\u064e\u0642\u06cc \u0633\u06cc\u0656\u0631\u06cc\u064e\u06a9" },
            { "Tglg", "\u062a\u064e\u06af\u064e\u0644\u0648\u06af" },
            { "Egyd", "\u0627\u0650\u062c\u067e\u0634\u0650\u06cc\u064e\u0646 \u0688\u0650\u0645\u0627\u0679\u0650\u06a9" },
            { "Egyh", "\u0627\u0650\u062c\u0650\u067e\u0634\u064e\u0646 \u06c1\u064e\u06cc\u0631\u06cc\u0679\u0650\u06a9" },
            { "Egyp", "\u0627\u0650\u062c\u0650\u067e\u0634\u064e\u0646 \u06c1\u064e\u06cc\u0631\u0648\u06af\u0644\u0650\u067e\u06be\u0633" },
            { "Geok", "\u062c\u0627\u0631\u062c\u0650\u06cc\u064e\u0646 \u06a9\u06be\u062a\u0633\u0648\u0631\u06cc" },
            { "zh_Hans", "\u0633\u06cc\u065a\u0648\u062f \u0686\u06cc\u0656\u0646\u06cc" },
            { "Hung", "\u067e\u0631\u0648\u0646 \u06c1\u064e\u0646\u06af\u06cc\u0631\u06cc\u064e\u0646" },
            { "kok", "\u06a9\u0648\u0646\u06a9\u064e\u0646\u06cc" },
            { "%%1901", "\u0631\u066e\u06ea\u0648\u0672\u062a\u06cc \u062c\u0654\u0631\u0645\u064e\u0646 \u0639\u0650\u0644\u0645\u06c1\u0650 \u06c1\u0650\u062c\u0627" },
            { "kos", "\u06a9\u0648\u0633\u0631\u06cc\u06cc\u064e\u0646" },
            { "zh_Hant", "\u0631\u0650\u0648\u0672\u062c\u06cc \u0686\u06cc\u0656\u0646\u06cc" },
            { "Sund", metaValue_su },
            { "kpe", "\u06a9\u064e\u067e\u06cc\u0644\u06cc" },
            { "ilo", "\u0627\u0650\u0644\u0648\u06a9\u0648" },
            { "Cprt", "\u06a9\u0650\u067e\u0631\u0627\u06cc\u0650\u0679" },
            { "%%BAKU1926", "\u062c\u0654\u0645\u0639 \u06a9\u0654\u0631\u0650\u062a\u06be \u062a\u064f\u0631\u06a9\u06cc \u0644\u0627\u0637\u06cc\u0656\u0646\u06cc \u0627\u064e\u0686\u06be\u0631" },
            { "mul", "\u0648\u0627\u0631\u06cc\u0627\u06c1 \u0632\u0628\u0627\u0646" },
            { "cad", "\u06a9\u0627\u0688\u0648" },
            { "mus", "\u06a9\u0631\u06cc\u0656\u06a9" },
            { "Glag", "\u06af\u0644\u06cc\u06af\u0648\u0644\u0650\u0679\u0650\u06a9" },
            { "gil", "\u06af\u0650\u0644\u0628\u0654\u0631\u0679\u06cc\u0656\u0632" },
            { "Cher", metaValue_chr },
            { "car", "\u06a9\u0627\u0631\u0650\u0628" },
            { "krc", "\u06a9\u0631\u0627\u0686\u06cc\u06d2 \u0628\u064e\u0644\u06a9\u0627\u0631" },
            { "inh", "\u0627\u0650\u0646\u065b\u06af\u064f\u0634" },
            { "krl", "\u06a9\u064e\u0631\u06cc\u0644\u0650\u06cc\u064e\u0646" },
            { "efi", "\u0627\u06cc\u065a\u0641\u0650\u06a9" },
            { "kru", "\u06a9\u064f\u0631\u064f\u06a9\u06be" },
            { "Telu", metaValue_te },
        };
        return data;
    }
}
