/* DesktopHelper.c generated by valac 0.56.3, the Vala compiler
 * generated from DesktopHelper.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "icontasklistapplet.h"
#include <gio/gio.h>
#include <libwnck/libwnck.h>
#include <gtk/gtk.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>

enum  {
	DESKTOP_HELPER_0_PROPERTY,
	DESKTOP_HELPER_NUM_PROPERTIES
};
static GParamSpec* desktop_helper_properties[DESKTOP_HELPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DesktopHelperPrivate {
	GSettings* settings;
	WnckScreen* screen;
	GtkBox* icon_layout;
};

static gint DesktopHelper_private_offset;
static gpointer desktop_helper_parent_class = NULL;
static GType desktop_helper_type_id = 0;

static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void desktop_helper_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const GtkTargetEntry DESKTOP_HELPER_targets[3] = {{"application/x-icon-tasklist-launcher-id", (guint) 0, (guint) 0}, {"text/uri-list", (guint) 0, (guint) 0}, {"application/x-desktop", (guint) 0, (guint) 0}};

static inline gpointer
desktop_helper_get_instance_private (DesktopHelper* self)
{
	return G_STRUCT_MEMBER_P (self, DesktopHelper_private_offset);
}

/**
 * Handle initial bootstrap of the desktop helper
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DesktopHelper*
desktop_helper_construct (GType object_type,
                          GSettings* settings,
                          GtkBox* icon_layout)
{
	DesktopHelper * self = NULL;
	GSettings* _tmp0_;
	GtkBox* _tmp1_;
	WnckScreen* _tmp2_;
	WnckScreen* _tmp3_;
	self = (DesktopHelper*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = _g_object_ref0 (icon_layout);
	_g_object_unref0 (self->priv->icon_layout);
	self->priv->icon_layout = _tmp1_;
	_tmp2_ = wnck_screen_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->screen);
	self->priv->screen = _tmp3_;
	return self;
}

DesktopHelper*
desktop_helper_new (GSettings* settings,
                    GtkBox* icon_layout)
{
	return desktop_helper_construct (TYPE_DESKTOP_HELPER, settings, icon_layout);
}

/**
 * Using our icon_layout, update the per-instance "pinned-launchers" key
 * Keeping with pinned internally for compatibility.
 */
static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
desktop_helper_update_pinned (DesktopHelper* self)
{
	gchar** buttons = NULL;
	gchar** _tmp0_;
	gint buttons_length1;
	gint _buttons_size_;
	GtkBox* _tmp1_;
	GList* _tmp2_;
	GSettings* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	buttons = _tmp0_;
	buttons_length1 = 0;
	_buttons_size_ = buttons_length1;
	_tmp1_ = self->priv->icon_layout;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
		widget_collection = _tmp2_;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			GtkWidget* _tmp3_;
			GtkWidget* widget = NULL;
			_tmp3_ = _g_object_ref0 ((GtkWidget*) widget_it->data);
			widget = _tmp3_;
			{
				IconButton* button = NULL;
				GtkWidget* _tmp4_;
				IconButton* _tmp5_;
				IconButton* _tmp6_;
				IconButton* _tmp7_;
				_tmp4_ = widget;
				_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_BUTTON_WRAPPER, ButtonWrapper)->button;
				_tmp6_ = _g_object_ref0 (_tmp5_);
				button = _tmp6_;
				_tmp7_ = button;
				if (icon_button_is_pinned (_tmp7_)) {
					IconButton* _tmp8_;
					GDesktopAppInfo* _tmp9_;
					GDesktopAppInfo* _tmp10_;
					gboolean _tmp11_;
					_tmp8_ = button;
					_tmp9_ = icon_button_get_appinfo (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_ != NULL;
					_g_object_unref0 (_tmp10_);
					if (_tmp11_) {
						gchar* id = NULL;
						IconButton* _tmp12_;
						GDesktopAppInfo* _tmp13_;
						GDesktopAppInfo* _tmp14_;
						const gchar* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						const gchar* _tmp18_;
						gchar** _tmp19_;
						gint _tmp19__length1;
						const gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp12_ = button;
						_tmp13_ = icon_button_get_appinfo (_tmp12_);
						_tmp14_ = _tmp13_;
						_tmp15_ = g_app_info_get_id ((GAppInfo*) _tmp14_);
						_tmp16_ = g_strdup (_tmp15_);
						_tmp17_ = _tmp16_;
						_g_object_unref0 (_tmp14_);
						id = _tmp17_;
						_tmp18_ = id;
						_tmp19_ = buttons;
						_tmp19__length1 = buttons_length1;
						if (_vala_string_array_contains (_tmp19_, _tmp19__length1, _tmp18_)) {
							_g_free0 (id);
							_g_object_unref0 (button);
							_g_object_unref0 (widget);
							continue;
						}
						_tmp20_ = id;
						_tmp21_ = g_strdup (_tmp20_);
						_vala_array_add1 (&buttons, &buttons_length1, &_buttons_size_, _tmp21_);
						_g_free0 (id);
					}
				}
				_g_object_unref0 (button);
				_g_object_unref0 (widget);
			}
		}
		(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
	}
	_tmp22_ = self->priv->settings;
	_tmp23_ = buttons;
	_tmp23__length1 = buttons_length1;
	g_settings_set_strv (_tmp22_, "pinned-launchers", _tmp23_);
	buttons = (_vala_array_free (buttons, buttons_length1, (GDestroyNotify) g_free), NULL);
}

/**
 * Return the currently active window
 */
WnckWindow*
desktop_helper_get_active_window (DesktopHelper* self)
{
	WnckScreen* _tmp0_;
	WnckWindow* _tmp1_;
	WnckWindow* _tmp2_;
	WnckWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->screen;
	_tmp1_ = wnck_screen_get_active_window (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/**
 * Return the currently active workspace
 */
WnckWorkspace*
desktop_helper_get_active_workspace (DesktopHelper* self)
{
	WnckScreen* _tmp0_;
	WnckWorkspace* _tmp1_;
	WnckWorkspace* _tmp2_;
	WnckWorkspace* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->screen;
	_tmp1_ = wnck_screen_get_active_workspace (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/**
 * get_app_launcher will return the last past of an app_id string. Useful when handling the full path to a DesktopAppInfo
 */
gchar*
desktop_helper_get_app_launcher (DesktopHelper* self,
                                 const gchar* app_id)
{
	gchar** parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint parts_length1;
	gint _parts_size_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (app_id != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (app_id, "/", 0);
	parts = _tmp1_;
	parts_length1 = _vala_array_length (_tmp0_);
	_parts_size_ = parts_length1;
	_tmp2_ = parts[parts_length1 - 1];
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
desktop_helper_class_init (DesktopHelperClass * klass,
                           gpointer klass_data)
{
	desktop_helper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DesktopHelper_private_offset);
	G_OBJECT_CLASS (klass)->finalize = desktop_helper_finalize;
}

static void
desktop_helper_instance_init (DesktopHelper * self,
                              gpointer klass)
{
	self->priv = desktop_helper_get_instance_private (self);
	self->priv->settings = NULL;
	self->priv->screen = NULL;
	self->priv->icon_layout = NULL;
	self->panel_size = 40;
	self->icon_size = 32;
	self->orientation = GTK_ORIENTATION_HORIZONTAL;
	self->panel_position = BUDGIE_PANEL_POSITION_BOTTOM;
	self->lock_icons = FALSE;
}

static void
desktop_helper_finalize (GObject * obj)
{
	DesktopHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DESKTOP_HELPER, DesktopHelper);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->screen);
	_g_object_unref0 (self->priv->icon_layout);
	G_OBJECT_CLASS (desktop_helper_parent_class)->finalize (obj);
}

/**
 * Trivial helper for IconTasklist - i.e. desktop lookups
 */
GType
desktop_helper_get_type (void)
{
	return desktop_helper_type_id;
}

GType
desktop_helper_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (DesktopHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopHelper), 0, (GInstanceInitFunc) desktop_helper_instance_init, NULL };
	desktop_helper_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "DesktopHelper", &g_define_type_info, 0);
	DesktopHelper_private_offset = sizeof (DesktopHelperPrivate);
	return desktop_helper_type_id;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

