/* IndicatorWindow.c generated by valac 0.56.3, the Vala compiler
 * generated from IndicatorWindow.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2017-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include "nightlightapplet.h"

#define NIGHT_LIGHT_TYPE_INDICATOR_WINDOW (night_light_indicator_window_get_type ())
#define NIGHT_LIGHT_INDICATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIGHT_LIGHT_TYPE_INDICATOR_WINDOW, NightLightIndicatorWindow))
#define NIGHT_LIGHT_INDICATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIGHT_LIGHT_TYPE_INDICATOR_WINDOW, NightLightIndicatorWindowClass))
#define NIGHT_LIGHT_IS_INDICATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIGHT_LIGHT_TYPE_INDICATOR_WINDOW))
#define NIGHT_LIGHT_IS_INDICATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIGHT_LIGHT_TYPE_INDICATOR_WINDOW))
#define NIGHT_LIGHT_INDICATOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIGHT_LIGHT_TYPE_INDICATOR_WINDOW, NightLightIndicatorWindowClass))

typedef struct _NightLightIndicatorWindow NightLightIndicatorWindow;
typedef struct _NightLightIndicatorWindowClass NightLightIndicatorWindowClass;
typedef struct _NightLightIndicatorWindowPrivate NightLightIndicatorWindowPrivate;
enum  {
	NIGHT_LIGHT_INDICATOR_WINDOW_0_PROPERTY,
	NIGHT_LIGHT_INDICATOR_WINDOW_NUM_PROPERTIES
};
static GParamSpec* night_light_indicator_window_properties[NIGHT_LIGHT_INDICATOR_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _NightLightIndicatorWindow {
	BudgiePopover parent_instance;
	NightLightIndicatorWindowPrivate * priv;
};

struct _NightLightIndicatorWindowClass {
	BudgiePopoverClass parent_class;
};

struct _NightLightIndicatorWindowPrivate {
	GtkSwitch* nightlight_switch;
	GtkGrid* item_grid;
	GtkSpinButton* temperature_spinbutton;
	GtkComboBoxText* schedule_combobox;
	GSettings* settings;
};

static gint NightLightIndicatorWindow_private_offset;
static gpointer night_light_indicator_window_parent_class = NULL;
static GType night_light_indicator_window_type_id = 0;

GType night_light_indicator_window_register_type (GTypeModule * module);
VALA_EXTERN GType night_light_indicator_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NightLightIndicatorWindow* night_light_indicator_window_new (GtkWidget* window_parent);
VALA_EXTERN NightLightIndicatorWindow* night_light_indicator_window_construct (GType object_type,
                                                                   GtkWidget* window_parent);
static void __lambda4_ (NightLightIndicatorWindow* self);
static void ___lambda4__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
VALA_EXTERN void night_light_indicator_window_toggle_nightlight (NightLightIndicatorWindow* self);
static void night_light_indicator_window_schedule_mode_changed (NightLightIndicatorWindow* self);
static void _night_light_indicator_window_schedule_mode_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                gpointer self);
static void night_light_indicator_window_open_settings (NightLightIndicatorWindow* self);
static void _night_light_indicator_window_open_settings_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void night_light_indicator_window_finalize (GObject * obj);

static inline gpointer
night_light_indicator_window_get_instance_private (NightLightIndicatorWindow* self)
{
	return G_STRUCT_MEMBER_P (self, NightLightIndicatorWindow_private_offset);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
__lambda4_ (NightLightIndicatorWindow* self)
{
	GtkComboBoxText* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = self->priv->schedule_combobox;
	_tmp1_ = self->priv->settings;
	_tmp2_ = bool_to_string (g_settings_get_boolean (_tmp1_, "night-light-schedule-automatic"));
	_tmp3_ = _tmp2_;
	gtk_combo_box_set_active_id ((GtkComboBox*) _tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}

static void
___lambda4__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda4_ ((NightLightIndicatorWindow*) self);
}

NightLightIndicatorWindow*
night_light_indicator_window_construct (GType object_type,
                                        GtkWidget* window_parent)
{
	NightLightIndicatorWindow * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkSwitch* _tmp2_;
	GSettings* _tmp3_;
	GtkGrid* _tmp4_;
	GSettings* _tmp5_;
	GtkSpinButton* _tmp6_;
	GSettings* _tmp7_;
	GtkComboBoxText* _tmp8_;
	GSettings* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	self = (NightLightIndicatorWindow*) g_object_new (object_type, "relative-to", window_parent, NULL);
	_tmp0_ = g_settings_new ("org.gnome.settings-daemon.plugins.color");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = self->priv->nightlight_switch;
	g_settings_bind (_tmp1_, "night-light-enabled", (GObject*) _tmp2_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->item_grid;
	g_settings_bind (_tmp3_, "night-light-enabled", (GObject*) _tmp4_, "sensitive", G_SETTINGS_BIND_DEFAULT);
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->temperature_spinbutton;
	g_settings_bind (_tmp5_, "night-light-temperature", (GObject*) _tmp6_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = self->priv->settings;
	g_signal_connect_object (_tmp7_, "changed::night-light-schedule-automatic", (GCallback) ___lambda4__g_settings_changed, self, 0);
	_tmp8_ = self->priv->schedule_combobox;
	_tmp9_ = self->priv->settings;
	_tmp10_ = bool_to_string (g_settings_get_boolean (_tmp9_, "night-light-schedule-automatic"));
	_tmp11_ = _tmp10_;
	gtk_combo_box_set_active_id ((GtkComboBox*) _tmp8_, _tmp11_);
	_g_free0 (_tmp11_);
	return self;
}

NightLightIndicatorWindow*
night_light_indicator_window_new (GtkWidget* window_parent)
{
	return night_light_indicator_window_construct (NIGHT_LIGHT_TYPE_INDICATOR_WINDOW, window_parent);
}

void
night_light_indicator_window_toggle_nightlight (NightLightIndicatorWindow* self)
{
	gboolean enabled = FALSE;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	enabled = g_settings_get_boolean (_tmp0_, "night-light-enabled");
	_tmp1_ = self->priv->settings;
	g_settings_set_boolean (_tmp1_, "night-light-enabled", !enabled);
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
night_light_indicator_window_schedule_mode_changed (NightLightIndicatorWindow* self)
{
	GSettings* _tmp0_;
	GtkComboBoxText* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->schedule_combobox;
	_tmp2_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp1_);
	g_settings_set_boolean (_tmp0_, "night-light-schedule-automatic", bool_parse (_tmp2_));
}

static void
_night_light_indicator_window_schedule_mode_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                           gpointer self)
{
	night_light_indicator_window_schedule_mode_changed ((NightLightIndicatorWindow*) self);
}

static void
night_light_indicator_window_open_settings (NightLightIndicatorWindow* self)
{
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_desktop_app_info_new ("budgie-display-panel.desktop");
	app_info = _tmp0_;
	_tmp1_ = app_info;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (app_info);
		return;
	}
	{
		GDesktopAppInfo* _tmp2_;
		gtk_widget_hide ((GtkWidget*) self);
		_tmp2_ = app_info;
		g_app_info_launch ((GAppInfo*) _tmp2_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_message ("IndicatorWindow.vala:67: Unable to launch budgie-display-panel.desktop" \
": %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (app_info);
}

static void
_night_light_indicator_window_open_settings_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	night_light_indicator_window_open_settings ((NightLightIndicatorWindow*) self);
}

static void
night_light_indicator_window_class_init (NightLightIndicatorWindowClass * klass,
                                         gpointer klass_data)
{
	night_light_indicator_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NightLightIndicatorWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = night_light_indicator_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/budgie-desktop/night-light/indicator_window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "nightlight_switch", FALSE, NightLightIndicatorWindow_private_offset + G_STRUCT_OFFSET (NightLightIndicatorWindowPrivate, nightlight_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "item_grid", FALSE, NightLightIndicatorWindow_private_offset + G_STRUCT_OFFSET (NightLightIndicatorWindowPrivate, item_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "temperature_spinbutton", FALSE, NightLightIndicatorWindow_private_offset + G_STRUCT_OFFSET (NightLightIndicatorWindowPrivate, temperature_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "schedule_combobox", FALSE, NightLightIndicatorWindow_private_offset + G_STRUCT_OFFSET (NightLightIndicatorWindowPrivate, schedule_combobox));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "schedule_mode_changed", G_CALLBACK(_night_light_indicator_window_schedule_mode_changed_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "open_settings", G_CALLBACK(_night_light_indicator_window_open_settings_gtk_button_clicked));
}

static void
night_light_indicator_window_instance_init (NightLightIndicatorWindow * self,
                                            gpointer klass)
{
	self->priv = night_light_indicator_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
night_light_indicator_window_finalize (GObject * obj)
{
	NightLightIndicatorWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIGHT_LIGHT_TYPE_INDICATOR_WINDOW, NightLightIndicatorWindow);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (night_light_indicator_window_parent_class)->finalize (obj);
}

GType
night_light_indicator_window_get_type (void)
{
	return night_light_indicator_window_type_id;
}

GType
night_light_indicator_window_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NightLightIndicatorWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) night_light_indicator_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NightLightIndicatorWindow), 0, (GInstanceInitFunc) night_light_indicator_window_instance_init, NULL };
	night_light_indicator_window_type_id = g_type_module_register_type (module, budgie_popover_get_type (), "NightLightIndicatorWindow", &g_define_type_info, 0);
	NightLightIndicatorWindow_private_offset = sizeof (NightLightIndicatorWindowPrivate);
	return night_light_indicator_window_type_id;
}

