/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.sound;

import java.io.File;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.sound.SoundPlayer;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.util.test.FreeColTestCase;

public class SoundTest
extends FreeColTestCase {
    private SoundPlayer soundPlayer = null;

    @Override
    public void setUp() {
        ClientOptions co = new ClientOptions();
        co.load(FreeColDirectories.getBaseClientOptionsFile());
        AudioMixerOption amo = co.getOption("model.option.audioMixer", AudioMixerOption.class);
        PercentageOption po = co.getOption("model.option.audioVolume", PercentageOption.class);
        po.setValue(10);
        try {
            this.soundPlayer = new SoundPlayer(amo, po);
        }
        catch (Exception e) {
            SoundTest.fail((String)("Could not construct sound player: " + e.getMessage()));
        }
        File baseDirectory = FreeColDirectories.getBaseDirectory();
        FreeColDataFile baseData = null;
        try {
            baseData = new FreeColDataFile(baseDirectory);
        }
        catch (Exception e) {
            SoundTest.fail((String)("Could not load base data: " + e.getMessage()));
        }
        ResourceManager.setBaseData(baseData);
        ResourceManager.prepare();
    }

    @Override
    public void tearDown() {
        this.soundPlayer = null;
    }

    private void playSound(String id) {
        File file = ResourceManager.getAudio(id);
        SoundTest.assertNotNull((String)("No sound resource: " + id), (Object)file);
        try {
            this.soundPlayer.playOnce(file);
            Utils.delay(100L, null);
            this.soundPlayer.stop();
            Utils.delay(50L, null);
        }
        catch (Exception e) {
            SoundTest.fail((String)("Could not play " + id + ": " + e.getMessage()));
        }
    }

    public void testSound() {
        this.playSound("sound.intro.general");
    }

    public void testClassic() {
        FreeColTcFile tcData = FreeColTcFile.getFreeColTcFile("classic");
        ResourceManager.setTcData(tcData);
        ResourceManager.prepare();
        this.playSound("sound.intro.model.nation.english");
        this.playSound("sound.intro.model.nation.dutch");
        this.playSound("sound.intro.model.nation.french");
        this.playSound("sound.intro.model.nation.spanish");
        this.playSound("sound.anthem.model.nation.dutch");
        this.playSound("sound.anthem.model.nation.english");
        this.playSound("sound.anthem.model.nation.french");
        this.playSound("sound.anthem.model.nation.spanish");
        this.playSound("sound.attack.artillery");
        this.playSound("sound.attack.mounted");
        this.playSound("sound.attack.naval");
        this.playSound("sound.event.meet.model.nation.aztec");
        this.playSound("sound.event.meet.model.nation.sioux");
        this.playSound("sound.event.illegalMove");
        this.playSound("sound.event.buildingComplete");
        this.playSound("sound.event.captureColony");
        this.playSound("sound.event.fountainOfYouth");
        this.playSound("sound.event.loadCargo");
        this.playSound("sound.event.missionEstablished");
        this.playSound("sound.event.sellCargo");
        this.playSound("sound.event.shipSunk");
    }
}

