# Fish shell completion for gum
# Generated by gum completion

# disable file completion unless explicitly enabled
complete -c gum -f

# gum
complete -c gum -f -s h -l help -d 'Show context-sensitive help.'
complete -c gum -f -s v -l version -d 'Print the version number'

# choose
complete -c gum -f -n '__fish_use_subcommand' -a choose -d 'Choose an option from a list of choices'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l limit -d 'Maximum number of options to pick'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l no-limit -d 'Pick unlimited number of options (ignores limit)'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l height -d 'Height of the list'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor -d 'Prefix to show on item that corresponds to the cursor position'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor-prefix -d 'Prefix to show on the cursor item (hidden if limit is 1)'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected-prefix -d 'Prefix to show on selected items (hidden if limit is 1)'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l unselected-prefix -d 'Prefix to show on unselected items (hidden if limit is 1)'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected -d 'Options that should start as selected'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'none hidden normal rounded thick double' -l cursor.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'left center right bottom middle top' -l cursor.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l cursor.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l cursor.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l cursor.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l cursor.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l cursor.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'none hidden normal rounded thick double' -l item.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'left center right bottom middle top' -l item.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l item.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l item.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l item.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l item.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l item.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'none hidden normal rounded thick double' -l selected.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'left center right bottom middle top' -l selected.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l selected.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l selected.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l selected.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l selected.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l selected.underline -d 'Underline text'

# confirm
complete -c gum -f -n '__fish_use_subcommand' -a confirm -d 'Ask a user to confirm an action'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l affirmative -d 'The title of the affirmative action'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l negative -d 'The title of the negative action'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l default -d 'Default confirmation action'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l timeout -d 'Timeout for confirmation'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'none hidden normal rounded thick double' -l prompt.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'left center right bottom middle top' -l prompt.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l prompt.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l prompt.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l prompt.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l prompt.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l prompt.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'none hidden normal rounded thick double' -l selected.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'left center right bottom middle top' -l selected.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l selected.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l selected.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l selected.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l selected.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l selected.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'none hidden normal rounded thick double' -l unselected.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'left center right bottom middle top' -l unselected.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l unselected.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l unselected.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l unselected.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l unselected.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l unselected.underline -d 'Underline text'

# filter
complete -c gum -f -n '__fish_use_subcommand' -a filter -d 'Filter items from a list'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator -d 'Character for selection'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l indicator.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l indicator.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l indicator.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l indicator.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l indicator.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l indicator.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l indicator.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l limit -d 'Maximum number of options to pick'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l no-limit -d 'Pick unlimited number of options (ignores limit)'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-prefix -d 'Character to indicate selected items (hidden if limit is 1)'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l selected-indicator.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l selected-indicator.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l selected-indicator.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l selected-indicator.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l selected-indicator.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l selected-indicator.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l selected-indicator.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix -d 'Character to indicate unselected items (hidden if limit is 1)'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l unselected-prefix.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l unselected-prefix.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l unselected-prefix.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l unselected-prefix.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l unselected-prefix.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l unselected-prefix.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l unselected-prefix.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l text.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l text.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l text.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l text.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l text.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l text.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l text.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l match.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l match.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l match.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l match.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l match.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l match.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l match.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l placeholder -d 'Placeholder value'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt -d 'Prompt to display'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l prompt.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l prompt.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l prompt.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l prompt.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l prompt.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l prompt.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l prompt.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l width -d 'Input width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l height -d 'Input height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l value -d 'Initial filter value'

# format
complete -c gum -f -n '__fish_use_subcommand' -a format -d 'Format a string using a template'
complete -c gum -f -n '__fish_seen_subcommand_from format' -xa 'markdown template code emoji' -s t -l type -d 'Format to use (markdown,template,code,emoji)'

# input
complete -c gum -f -n '__fish_use_subcommand' -a input -d 'Prompt for some input'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l placeholder -d 'Placeholder value'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt -d 'Prompt to display'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'none hidden normal rounded thick double' -l prompt.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'left center right bottom middle top' -l prompt.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l prompt.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l prompt.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l prompt.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l prompt.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l prompt.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'none hidden normal rounded thick double' -l cursor.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'left center right bottom middle top' -l cursor.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l cursor.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l cursor.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l cursor.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l cursor.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l cursor.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l value -d 'Initial value (can also be passed via stdin)'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l char-limit -d 'Maximum value length (0 for no limit)'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l width -d 'Input width'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l password -d 'Mask input characters'

# join
complete -c gum -f -n '__fish_use_subcommand' -a join -d 'Join text vertically or horizontally'
complete -c gum -f -n '__fish_seen_subcommand_from join' -xa 'left center right bottom middle top' -l align -d 'Text alignment'
complete -c gum -f -n '__fish_seen_subcommand_from join' -l horizontal -d 'Join (potentially multi-line) strings horizontally'
complete -c gum -f -n '__fish_seen_subcommand_from join' -l vertical -d 'Join (potentially multi-line) strings vertically'

# spin
complete -c gum -f -n '__fish_use_subcommand' -a spin -d 'Display spinner while running a command'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l show-output -d 'Show output of command'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'line dot minidot jump pulse points globe moon monkey meter hamburger' -s s -l spinner -d 'Spinner type'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'none hidden normal rounded thick double' -l spinner.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'left center right bottom middle top' -l spinner.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l spinner.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l spinner.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l spinner.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l spinner.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l spinner.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title -d 'Text to display to user while spinning'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'none hidden normal rounded thick double' -l title.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'left center right bottom middle top' -l title.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l title.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l title.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l title.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l title.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l title.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'left right' -s a -l align -d 'Alignment of spinner with regard to the title'

# style
complete -c gum -f -n '__fish_use_subcommand' -a style -d 'Apply coloring, borders, spacing to text'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from style' -xa 'none hidden normal rounded thick double' -l border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from style' -xa 'left center right bottom middle top' -l align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from style' -l bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from style' -l faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from style' -l italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from style' -l strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from style' -l underline -d 'Underline text'

# write
complete -c gum -f -n '__fish_use_subcommand' -a write -d 'Prompt for long-form text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l width -d 'Text area width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l height -d 'Text area height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder -d 'Placeholder value'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt -d 'Prompt to display'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l show-cursor-line -d 'Show cursor line'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l show-line-numbers -d 'Show line numbers'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l value -d 'Initial value (can be passed via stdin)'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l char-limit -d 'Maximum value length (0 for no limit)'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l base.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l base.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l base.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l base.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l base.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l base.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l base.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l cursor-line-number.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l cursor-line-number.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line-number.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line-number.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line-number.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line-number.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line-number.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l cursor-line.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l cursor-line.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l cursor.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l cursor.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l end-of-buffer.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l end-of-buffer.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l end-of-buffer.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l end-of-buffer.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l end-of-buffer.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l end-of-buffer.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l end-of-buffer.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l line-number.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l line-number.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l line-number.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l line-number.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l line-number.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l line-number.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l line-number.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l placeholder.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l placeholder.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l placeholder.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l placeholder.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l placeholder.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l placeholder.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l placeholder.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l prompt.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l prompt.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l prompt.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l prompt.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l prompt.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l prompt.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l prompt.underline -d 'Underline text'

