/* BackgroundUtils.c generated by valac 0.56.2, the Vala compiler
 * generated from BackgroundUtils.vala, do not modify */

/*
 * Copyright (c) 2011-2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */
/*
 *   The method for calculating the background information and the classes that are
 *   related to it are copied from Gala.DBus.
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <glib-object.h>
#include <string.h>
#include <gio/gio.h>
#include <meta/meta-plugin.h>
#include <meta/meta-background-actor.h>
#include <stdlib.h>
#include <cogl/cogl.h>

#define BACKGROUND_UTILS_SATURATION_WEIGHT 1.5
#define BACKGROUND_UTILS_WEIGHT_THRESHOLD 1.0
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT (background_utils_dummy_offscreen_effect_get_type ())
#define BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, BackgroundUtilsDummyOffscreenEffect))
#define BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, BackgroundUtilsDummyOffscreenEffectClass))
#define BACKGROUND_UTILS_IS_DUMMY_OFFSCREEN_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT))
#define BACKGROUND_UTILS_IS_DUMMY_OFFSCREEN_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT))
#define BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, BackgroundUtilsDummyOffscreenEffectClass))

typedef struct _BackgroundUtilsDummyOffscreenEffect BackgroundUtilsDummyOffscreenEffect;
typedef struct _BackgroundUtilsDummyOffscreenEffectClass BackgroundUtilsDummyOffscreenEffectClass;
typedef struct _BackgroundUtilsDummyOffscreenEffectPrivate BackgroundUtilsDummyOffscreenEffectPrivate;
enum  {
	BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_0_PROPERTY,
	BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_PROPERTIES
};
static GParamSpec* background_utils_dummy_offscreen_effect_properties[BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_PROPERTIES];
enum  {
	BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_DONE_PAINTING_SIGNAL,
	BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_SIGNALS
};
static guint background_utils_dummy_offscreen_effect_signals[BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_SIGNALS] = {0};

#define BACKGROUND_UTILS_TYPE_COLOR_INFORMATION (background_utils_color_information_get_type ())
typedef struct _BackgroundUtilsColorInformation BackgroundUtilsColorInformation;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER (greeter_compositor_window_manager_get_type ())
#define GREETER_COMPOSITOR_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))

typedef struct _GreeterCompositorWindowManager GreeterCompositorWindowManager;
typedef struct _GreeterCompositorWindowManagerClass GreeterCompositorWindowManagerClass;
typedef struct _Block2Data Block2Data;

#define GREETER_TYPE_SYSTEM_BACKGROUND (greeter_system_background_get_type ())
#define GREETER_SYSTEM_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_SYSTEM_BACKGROUND, GreeterSystemBackground))
#define GREETER_SYSTEM_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_SYSTEM_BACKGROUND, GreeterSystemBackgroundClass))
#define GREETER_IS_SYSTEM_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_SYSTEM_BACKGROUND))
#define GREETER_IS_SYSTEM_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_SYSTEM_BACKGROUND))
#define GREETER_SYSTEM_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_SYSTEM_BACKGROUND, GreeterSystemBackgroundClass))

typedef struct _GreeterSystemBackground GreeterSystemBackground;
typedef struct _GreeterSystemBackgroundClass GreeterSystemBackgroundClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cogl_object_unref0(var) ((var == NULL) ? NULL : (var = (cogl_object_unref (var), NULL)))
typedef struct _BackgroundUtilsGetBackgroundColorInformationData BackgroundUtilsGetBackgroundColorInformationData;

struct _BackgroundUtilsDummyOffscreenEffect {
	ClutterOffscreenEffect parent_instance;
	BackgroundUtilsDummyOffscreenEffectPrivate * priv;
};

struct _BackgroundUtilsDummyOffscreenEffectClass {
	ClutterOffscreenEffectClass parent_class;
};

struct _BackgroundUtilsColorInformation {
	gdouble average_red;
	gdouble average_green;
	gdouble average_blue;
	gdouble mean_luminance;
	gdouble luminance_variance;
	gdouble mean_acutance;
};

struct _Block2Data {
	int _ref_count_;
	MetaBackgroundActor* background;
	BackgroundUtilsDummyOffscreenEffect* effect;
	gint x_start;
	gint y_start;
	gint width;
	gint height;
	gdouble mean_acutance;
	gdouble variance;
	gdouble mean;
	gdouble r_total;
	gdouble g_total;
	gdouble b_total;
	gulong paint_signal_handler;
	gpointer _async_data_;
};

struct _BackgroundUtilsGetBackgroundColorInformationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GreeterCompositorWindowManager* wm;
	gint reference_x;
	gint reference_y;
	gint reference_width;
	gint reference_height;
	BackgroundUtilsColorInformation result;
	Block2Data* _data2_;
	GreeterSystemBackground* _tmp0_;
	GreeterSystemBackground* _tmp1_;
	MetaBackgroundActor* _tmp2_;
	MetaBackgroundActor* _tmp3_;
	MetaBackgroundActor* _tmp4_;
	BackgroundUtilsDummyOffscreenEffect* _tmp5_;
	MetaBackgroundActor* _tmp6_;
	BackgroundUtilsDummyOffscreenEffect* _tmp7_;
	gint bg_actor_width;
	MetaBackgroundActor* _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	gint bg_actor_height;
	MetaBackgroundActor* _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	BackgroundUtilsDummyOffscreenEffect* _tmp21_;
	gulong _tmp22_;
	MetaBackgroundActor* _tmp23_;
	BackgroundUtilsColorInformation _tmp24_;
	GError* _inner_error0_;
};

static gpointer background_utils_dummy_offscreen_effect_parent_class = NULL;

VALA_EXTERN GType background_utils_dummy_offscreen_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundUtilsDummyOffscreenEffect, g_object_unref)
static void background_utils_dummy_offscreen_effect_real_post_paint (ClutterEffect* base,
                                                              ClutterPaintNode* node,
                                                              ClutterPaintContext* context);
static gboolean __lambda46_ (BackgroundUtilsDummyOffscreenEffect* self);
static gboolean ___lambda46__gsource_func (gpointer self);
VALA_EXTERN BackgroundUtilsDummyOffscreenEffect* background_utils_dummy_offscreen_effect_new (void);
VALA_EXTERN BackgroundUtilsDummyOffscreenEffect* background_utils_dummy_offscreen_effect_construct (GType object_type);
static GType background_utils_dummy_offscreen_effect_get_type_once (void);
VALA_EXTERN GType background_utils_color_information_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BackgroundUtilsColorInformation* background_utils_color_information_dup (const BackgroundUtilsColorInformation* self);
VALA_EXTERN void background_utils_color_information_free (BackgroundUtilsColorInformation* self);
static void background_utils_get_background_color_information_data_free (gpointer _data);
VALA_EXTERN GType greeter_compositor_window_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWindowManager, g_object_unref)
VALA_EXTERN void background_utils_get_background_color_information (GreeterCompositorWindowManager* wm,
                                                        gint reference_x,
                                                        gint reference_y,
                                                        gint reference_width,
                                                        gint reference_height,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
VALA_EXTERN void background_utils_get_background_color_information_finish (GAsyncResult* _res_,
                                                               BackgroundUtilsColorInformation* result,
                                                               GError** error);
static gboolean background_utils_get_background_color_information_co (BackgroundUtilsGetBackgroundColorInformationData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN GType greeter_system_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterSystemBackground, g_object_unref)
VALA_EXTERN GreeterSystemBackground* greeter_compositor_window_manager_get_system_background (GreeterCompositorWindowManager* self);
VALA_EXTERN MetaBackgroundActor* greeter_system_background_get_background_actor (GreeterSystemBackground* self);
static void __lambda47_ (Block2Data* _data2_);
static void ___lambda47__background_utils_dummy_offscreen_effect_done_painting (BackgroundUtilsDummyOffscreenEffect* _sender,
                                                                         gpointer self);

static gboolean
__lambda46_ (BackgroundUtilsDummyOffscreenEffect* self)
{
	gboolean result;
	g_signal_emit (self, background_utils_dummy_offscreen_effect_signals[BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_DONE_PAINTING_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda46__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda46_ ((BackgroundUtilsDummyOffscreenEffect*) self);
	return result;
}

static void
background_utils_dummy_offscreen_effect_real_post_paint (ClutterEffect* base,
                                                         ClutterPaintNode* node,
                                                         ClutterPaintContext* context)
{
	BackgroundUtilsDummyOffscreenEffect * self;
	self = (BackgroundUtilsDummyOffscreenEffect*) base;
	g_return_if_fail (node != NULL);
	g_return_if_fail (context != NULL);
	CLUTTER_EFFECT_CLASS (background_utils_dummy_offscreen_effect_parent_class)->post_paint ((ClutterEffect*) G_TYPE_CHECK_INSTANCE_CAST (self, clutter_offscreen_effect_get_type (), ClutterOffscreenEffect), node, context);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda46__gsource_func, g_object_ref (self), g_object_unref);
}

BackgroundUtilsDummyOffscreenEffect*
background_utils_dummy_offscreen_effect_construct (GType object_type)
{
	BackgroundUtilsDummyOffscreenEffect * self = NULL;
	self = (BackgroundUtilsDummyOffscreenEffect*) g_object_new (object_type, NULL);
	return self;
}

BackgroundUtilsDummyOffscreenEffect*
background_utils_dummy_offscreen_effect_new (void)
{
	return background_utils_dummy_offscreen_effect_construct (BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT);
}

static void
background_utils_dummy_offscreen_effect_class_init (BackgroundUtilsDummyOffscreenEffectClass * klass,
                                                    gpointer klass_data)
{
	background_utils_dummy_offscreen_effect_parent_class = g_type_class_peek_parent (klass);
	((ClutterEffectClass *) klass)->post_paint = (void (*) (ClutterEffect*, ClutterPaintNode*, ClutterPaintContext*)) background_utils_dummy_offscreen_effect_real_post_paint;
	background_utils_dummy_offscreen_effect_signals[BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_DONE_PAINTING_SIGNAL] = g_signal_new ("done-painting", BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
background_utils_dummy_offscreen_effect_instance_init (BackgroundUtilsDummyOffscreenEffect * self,
                                                       gpointer klass)
{
}

static GType
background_utils_dummy_offscreen_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackgroundUtilsDummyOffscreenEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_utils_dummy_offscreen_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackgroundUtilsDummyOffscreenEffect), 0, (GInstanceInitFunc) background_utils_dummy_offscreen_effect_instance_init, NULL };
	GType background_utils_dummy_offscreen_effect_type_id;
	background_utils_dummy_offscreen_effect_type_id = g_type_register_static (clutter_offscreen_effect_get_type (), "BackgroundUtilsDummyOffscreenEffect", &g_define_type_info, 0);
	return background_utils_dummy_offscreen_effect_type_id;
}

GType
background_utils_dummy_offscreen_effect_get_type (void)
{
	static volatile gsize background_utils_dummy_offscreen_effect_type_id__once = 0;
	if (g_once_init_enter (&background_utils_dummy_offscreen_effect_type_id__once)) {
		GType background_utils_dummy_offscreen_effect_type_id;
		background_utils_dummy_offscreen_effect_type_id = background_utils_dummy_offscreen_effect_get_type_once ();
		g_once_init_leave (&background_utils_dummy_offscreen_effect_type_id__once, background_utils_dummy_offscreen_effect_type_id);
	}
	return background_utils_dummy_offscreen_effect_type_id__once;
}

BackgroundUtilsColorInformation*
background_utils_color_information_dup (const BackgroundUtilsColorInformation* self)
{
	BackgroundUtilsColorInformation* dup;
	dup = g_new0 (BackgroundUtilsColorInformation, 1);
	memcpy (dup, self, sizeof (BackgroundUtilsColorInformation));
	return dup;
}

void
background_utils_color_information_free (BackgroundUtilsColorInformation* self)
{
	g_free (self);
}

static GType
background_utils_color_information_get_type_once (void)
{
	GType background_utils_color_information_type_id;
	background_utils_color_information_type_id = g_boxed_type_register_static ("BackgroundUtilsColorInformation", (GBoxedCopyFunc) background_utils_color_information_dup, (GBoxedFreeFunc) background_utils_color_information_free);
	return background_utils_color_information_type_id;
}

GType
background_utils_color_information_get_type (void)
{
	static volatile gsize background_utils_color_information_type_id__once = 0;
	if (g_once_init_enter (&background_utils_color_information_type_id__once)) {
		GType background_utils_color_information_type_id;
		background_utils_color_information_type_id = background_utils_color_information_get_type_once ();
		g_once_init_leave (&background_utils_color_information_type_id__once, background_utils_color_information_type_id);
	}
	return background_utils_color_information_type_id__once;
}

static void
background_utils_get_background_color_information_data_free (gpointer _data)
{
	BackgroundUtilsGetBackgroundColorInformationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->wm);
	g_slice_free (BackgroundUtilsGetBackgroundColorInformationData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
background_utils_get_background_color_information (GreeterCompositorWindowManager* wm,
                                                   gint reference_x,
                                                   gint reference_y,
                                                   gint reference_width,
                                                   gint reference_height,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	BackgroundUtilsGetBackgroundColorInformationData* _data_;
	GreeterCompositorWindowManager* _tmp0_;
	g_return_if_fail (wm != NULL);
	_data_ = g_slice_new0 (BackgroundUtilsGetBackgroundColorInformationData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, background_utils_get_background_color_information_data_free);
	_tmp0_ = _g_object_ref0 (wm);
	_g_object_unref0 (_data_->wm);
	_data_->wm = _tmp0_;
	_data_->reference_x = reference_x;
	_data_->reference_y = reference_y;
	_data_->reference_width = reference_width;
	_data_->reference_height = reference_height;
	background_utils_get_background_color_information_co (_data_);
}

void
background_utils_get_background_color_information_finish (GAsyncResult* _res_,
                                                          BackgroundUtilsColorInformation* result,
                                                          GError** error)
{
	BackgroundUtilsGetBackgroundColorInformationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	*result = _data_->result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->effect);
		_g_object_unref0 (_data2_->background);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_cogl_object_ref0 (gpointer self)
{
	return self ? cogl_object_ref (self) : NULL;
}

static void
__lambda47_ (Block2Data* _data2_)
{
	BackgroundUtilsDummyOffscreenEffect* _tmp0_;
	MetaBackgroundActor* _tmp1_;
	BackgroundUtilsDummyOffscreenEffect* _tmp2_;
	CoglTexture* texture = NULL;
	BackgroundUtilsDummyOffscreenEffect* _tmp3_;
	CoglHandle* _tmp4_;
	CoglTexture* _tmp5_;
	guint texture_width = 0U;
	CoglTexture* _tmp6_;
	guint texture_height = 0U;
	CoglTexture* _tmp7_;
	guint8* pixels = NULL;
	guint8* _tmp8_;
	gint pixels_length1;
	gint _pixels_size_;
	gdouble* pixel_lums = NULL;
	gdouble* _tmp9_;
	gint pixel_lums_length1;
	gint _pixel_lums_size_;
	CoglTexture* _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	gint size = 0;
	gdouble mean_squares = 0.0;
	gdouble pixel = 0.0;
	gdouble max = 0.0;
	gdouble min = 0.0;
	gdouble score = 0.0;
	gdouble delta = 0.0;
	gdouble score_total = 0.0;
	gdouble r_total2 = 0.0;
	gdouble g_total2 = 0.0;
	gdouble b_total2 = 0.0;
	gdouble max_val = 0.0;
	_tmp0_ = _data2_->effect;
	g_signal_handler_disconnect (_tmp0_, _data2_->paint_signal_handler);
	_tmp1_ = _data2_->background;
	_tmp2_ = _data2_->effect;
	clutter_actor_remove_effect ((ClutterActor*) _tmp1_, (ClutterEffect*) _tmp2_);
	_tmp3_ = _data2_->effect;
	_tmp4_ = clutter_offscreen_effect_get_texture ((ClutterOffscreenEffect*) _tmp3_);
	_tmp5_ = _cogl_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, cogl_texture_get_gtype (), CoglTexture));
	texture = _tmp5_;
	_tmp6_ = texture;
	texture_width = cogl_texture_get_width (_tmp6_);
	_tmp7_ = texture;
	texture_height = cogl_texture_get_height (_tmp7_);
	_tmp8_ = g_new0 (guint8, (texture_width * texture_height) * 4);
	pixels = _tmp8_;
	pixels_length1 = (texture_width * texture_height) * 4;
	_pixels_size_ = pixels_length1;
	_tmp9_ = g_new0 (gdouble, texture_width * texture_height);
	pixel_lums = _tmp9_;
	pixel_lums_length1 = texture_width * texture_height;
	_pixel_lums_size_ = pixel_lums_length1;
	_tmp10_ = texture;
	_tmp11_ = pixels;
	_tmp11__length1 = pixels_length1;
	cogl_texture_get_data (_tmp10_, COGL_PIXEL_FORMAT_BGRA_8888_PRE, (guint) 0, _tmp11_);
	size = _data2_->width * _data2_->height;
	mean_squares = (gdouble) 0;
	pixel = (gdouble) 0;
	score_total = (gdouble) 0;
	r_total2 = (gdouble) 0;
	g_total2 = (gdouble) 0;
	b_total2 = (gdouble) 0;
	{
		gint y = 0;
		y = _data2_->y_start;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = y;
					y = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(y < (_data2_->y_start + _data2_->height))) {
					break;
				}
				{
					gint x = 0;
					x = _data2_->x_start;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							gint i = 0;
							guint8 b = 0U;
							guint8* _tmp16_;
							gint _tmp16__length1;
							guint8 _tmp17_;
							guint8 g = 0U;
							guint8* _tmp18_;
							gint _tmp18__length1;
							guint8 _tmp19_;
							guint8 r = 0U;
							guint8* _tmp20_;
							gint _tmp20__length1;
							guint8 _tmp21_;
							gdouble* _tmp22_;
							gint _tmp22__length1;
							gdouble _tmp23_ = 0.0;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = x;
								x = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							if (!(x < (_data2_->x_start + _data2_->width))) {
								break;
							}
							i = ((y * ((gint) texture_width)) * 4) + (x * 4);
							_tmp16_ = pixels;
							_tmp16__length1 = pixels_length1;
							_tmp17_ = _tmp16_[i];
							b = _tmp17_;
							_tmp18_ = pixels;
							_tmp18__length1 = pixels_length1;
							_tmp19_ = _tmp18_[i + 1];
							g = _tmp19_;
							_tmp20_ = pixels;
							_tmp20__length1 = pixels_length1;
							_tmp21_ = _tmp20_[i + 2];
							r = _tmp21_;
							pixel = ((0.3 * r) + (0.59 * g)) + (0.11 * b);
							_tmp22_ = pixel_lums;
							_tmp22__length1 = pixel_lums_length1;
							_tmp22_[(y * _data2_->width) + x] = pixel;
							min = (gdouble) MIN (r, MIN (g, b));
							max = (gdouble) MAX (r, MAX (g, b));
							delta = max - min;
							if (delta == ((gdouble) 0)) {
								_tmp23_ = 0.0;
							} else {
								_tmp23_ = delta / max;
							}
							score = BACKGROUND_UTILS_SATURATION_WEIGHT * _tmp23_;
							_data2_->r_total += score * r;
							_data2_->g_total += score * g;
							_data2_->b_total += score * b;
							score_total += score;
							_data2_->r_total += (gdouble) r;
							_data2_->g_total += (gdouble) g;
							_data2_->b_total += (gdouble) b;
							_data2_->mean += pixel;
							mean_squares += pixel * pixel;
						}
					}
				}
			}
		}
	}
	{
		gint y = 0;
		y = _data2_->y_start + 1;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = y;
					y = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(y < ((_data2_->y_start + _data2_->height) - 1))) {
					break;
				}
				{
					gint x = 0;
					x = _data2_->x_start + 1;
					{
						gboolean _tmp26_ = FALSE;
						_tmp26_ = TRUE;
						while (TRUE) {
							gdouble acutance = 0.0;
							gdouble* _tmp28_;
							gint _tmp28__length1;
							gdouble _tmp29_;
							gdouble* _tmp30_;
							gint _tmp30__length1;
							gdouble _tmp31_;
							gdouble* _tmp32_;
							gint _tmp32__length1;
							gdouble _tmp33_;
							gdouble* _tmp34_;
							gint _tmp34__length1;
							gdouble _tmp35_;
							gdouble* _tmp36_;
							gint _tmp36__length1;
							gdouble _tmp37_;
							gdouble _tmp38_ = 0.0;
							if (!_tmp26_) {
								gint _tmp27_;
								_tmp27_ = x;
								x = _tmp27_ + 1;
							}
							_tmp26_ = FALSE;
							if (!(x < ((_data2_->x_start + _data2_->width) - 1))) {
								break;
							}
							_tmp28_ = pixel_lums;
							_tmp28__length1 = pixel_lums_length1;
							_tmp29_ = _tmp28_[(y * _data2_->width) + x];
							_tmp30_ = pixel_lums;
							_tmp30__length1 = pixel_lums_length1;
							_tmp31_ = _tmp30_[((y * _data2_->width) + x) - 1];
							_tmp32_ = pixel_lums;
							_tmp32__length1 = pixel_lums_length1;
							_tmp33_ = _tmp32_[((y * _data2_->width) + x) + 1];
							_tmp34_ = pixel_lums;
							_tmp34__length1 = pixel_lums_length1;
							_tmp35_ = _tmp34_[((y - 1) * _data2_->width) + x];
							_tmp36_ = pixel_lums;
							_tmp36__length1 = pixel_lums_length1;
							_tmp37_ = _tmp36_[((y + 1) * _data2_->width) + x];
							acutance = (_tmp29_ * 4) - (((_tmp31_ + _tmp33_) + _tmp35_) + _tmp37_);
							if (acutance > ((gdouble) 0)) {
								_tmp38_ = acutance;
							} else {
								_tmp38_ = -acutance;
							}
							_data2_->mean_acutance += _tmp38_;
						}
					}
				}
			}
		}
	}
	score_total /= (gdouble) size;
	_data2_->b_total /= (gdouble) size;
	_data2_->g_total /= (gdouble) size;
	_data2_->r_total /= (gdouble) size;
	if (score_total > 0.0) {
		_data2_->b_total /= score_total;
		_data2_->g_total /= score_total;
		_data2_->r_total /= score_total;
	}
	b_total2 /= (gdouble) (size * G_MAXUINT8);
	g_total2 /= (gdouble) (size * G_MAXUINT8);
	r_total2 /= (gdouble) (size * G_MAXUINT8);
	if (score_total <= BACKGROUND_UTILS_WEIGHT_THRESHOLD) {
		gdouble f = 0.0;
		gdouble rf = 0.0;
		f = (1.0 / BACKGROUND_UTILS_WEIGHT_THRESHOLD) * score_total;
		rf = 1.0 - f;
		_data2_->b_total = (_data2_->b_total * f) + (b_total2 * rf);
		_data2_->g_total = (_data2_->g_total * f) + (g_total2 * rf);
		_data2_->r_total = (_data2_->r_total * f) + (r_total2 * rf);
	}
	max_val = MAX (_data2_->r_total, MAX (_data2_->g_total, _data2_->b_total));
	if (max_val > 1.0) {
		_data2_->b_total /= max_val;
		_data2_->g_total /= max_val;
		_data2_->r_total /= max_val;
	}
	_data2_->mean /= (gdouble) size;
	mean_squares = mean_squares / size;
	_data2_->variance = mean_squares - (_data2_->mean * _data2_->mean);
	_data2_->mean_acutance /= (gdouble) ((_data2_->width - 2) * (_data2_->height - 2));
	background_utils_get_background_color_information_co (_data2_->_async_data_);
	pixel_lums = (g_free (pixel_lums), NULL);
	pixels = (g_free (pixels), NULL);
	_cogl_object_unref0 (texture);
}

static void
___lambda47__background_utils_dummy_offscreen_effect_done_painting (BackgroundUtilsDummyOffscreenEffect* _sender,
                                                                    gpointer self)
{
	__lambda47_ (self);
}

static gboolean
background_utils_get_background_color_information_co (BackgroundUtilsGetBackgroundColorInformationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = greeter_compositor_window_manager_get_system_background (_data_->wm);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = greeter_system_background_get_background_actor (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->_data2_->background = _data_->_tmp4_;
	_data_->_tmp5_ = background_utils_dummy_offscreen_effect_new ();
	g_object_ref_sink (_data_->_tmp5_);
	_data_->_data2_->effect = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->_data2_->background;
	_data_->_tmp7_ = _data_->_data2_->effect;
	clutter_actor_add_effect ((ClutterActor*) _data_->_tmp6_, (ClutterEffect*) _data_->_tmp7_);
	_data_->_tmp8_ = _data_->_data2_->background;
	_data_->_tmp9_ = clutter_actor_get_width ((ClutterActor*) _data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->bg_actor_width = (gint) _data_->_tmp10_;
	_data_->_tmp11_ = _data_->_data2_->background;
	_data_->_tmp12_ = clutter_actor_get_height ((ClutterActor*) _data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->bg_actor_height = (gint) _data_->_tmp13_;
	_data_->_data2_->x_start = _data_->reference_x;
	if (_data_->_data2_->x_start < 2) {
		_data_->_data2_->x_start = 2;
	}
	_data_->_data2_->y_start = _data_->reference_y;
	if (_data_->_data2_->y_start < 2) {
		_data_->_data2_->y_start = 2;
	}
	_data_->_data2_->width = MIN ((_data_->bg_actor_width - 2) - _data_->reference_x, _data_->reference_width);
	_data_->_data2_->height = MIN ((_data_->bg_actor_height - 2) - _data_->reference_y, _data_->reference_height);
	if (_data_->_data2_->x_start > _data_->bg_actor_width) {
		_data_->_tmp16_ = TRUE;
	} else {
		_data_->_tmp16_ = _data_->_data2_->y_start > _data_->bg_actor_height;
	}
	if (_data_->_tmp16_) {
		_data_->_tmp15_ = TRUE;
	} else {
		_data_->_tmp15_ = _data_->_data2_->width <= 0;
	}
	if (_data_->_tmp15_) {
		_data_->_tmp14_ = TRUE;
	} else {
		_data_->_tmp14_ = _data_->_data2_->height <= 0;
	}
	if (_data_->_tmp14_) {
		_data_->_tmp17_ = g_strdup_printf ("Invalid rectangle specified: %i, %i, %i, %i", _data_->_data2_->x_start, _data_->_data2_->y_start, _data_->_data2_->width, _data_->_data2_->height);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, _data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_g_free0 (_data_->_tmp18_);
		_data_->_inner_error0_ = _data_->_tmp20_;
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_data2_->mean_acutance = (gdouble) 0;
	_data_->_data2_->variance = (gdouble) 0;
	_data_->_data2_->mean = (gdouble) 0;
	_data_->_data2_->r_total = (gdouble) 0;
	_data_->_data2_->g_total = (gdouble) 0;
	_data_->_data2_->b_total = (gdouble) 0;
	_data_->_data2_->paint_signal_handler = (gulong) 0;
	_data_->_tmp21_ = _data_->_data2_->effect;
	_data_->_tmp22_ = g_signal_connect_data (_data_->_tmp21_, "done-painting", (GCallback) ___lambda47__background_utils_dummy_offscreen_effect_done_painting, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
	_data_->_data2_->paint_signal_handler = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->_data2_->background;
	clutter_actor_queue_redraw ((ClutterActor*) _data_->_tmp23_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	memset (&_data_->_tmp24_, 0, sizeof (BackgroundUtilsColorInformation));
	_data_->_tmp24_.average_red = _data_->_data2_->r_total;
	_data_->_tmp24_.average_green = _data_->_data2_->g_total;
	_data_->_tmp24_.average_blue = _data_->_data2_->b_total;
	_data_->_tmp24_.mean_luminance = _data_->_data2_->mean;
	_data_->_tmp24_.luminance_variance = _data_->_data2_->variance;
	_data_->_tmp24_.mean_acutance = _data_->_data2_->mean_acutance;
	_data_->result = _data_->_tmp24_;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

