/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.atom;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class AtomSprite
extends AbstractAtom
implements Atom {
    private final Sprite sprite;
    private final double scale;
    private final Url url;
    private final HColor color;
    private final ColorMapper colorMapper;

    public AtomSprite(HColor newColor, double scale, FontConfiguration fontConfiguration, Sprite sprite, Url url, ColorMapper colorMapper) {
        this.colorMapper = colorMapper;
        this.scale = scale;
        this.sprite = sprite;
        this.url = url;
        this.color = newColor == null ? fontConfiguration.getColor() : newColor;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.sprite.asTextBlock(this.color, this.scale, this.colorMapper).calculateDimension(stringBounder);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.sprite.asTextBlock(this.color, this.scale, this.colorMapper).drawU(ug);
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

