/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class TextBlockMarged
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final TextBlock textBlock;
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;

    TextBlockMarged(TextBlock textBlock, double top, double right, double bottom, double left) {
        this.textBlock = textBlock;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    TextBlockMarged(TextBlock textBlock, ClockwiseTopRightBottomLeft margins) {
        this.textBlock = textBlock;
        this.top = margins.getTop();
        this.right = margins.getRight();
        this.bottom = margins.getBottom();
        this.left = margins.getLeft();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dim, this.left + this.right, this.top + this.bottom);
    }

    @Override
    public void drawU(UGraphic ug) {
        Dimension2D dim = this.calculateDimension(ug.getStringBounder());
        if (dim.getWidth() > 0.0) {
            ug.draw(new UEmpty(dim));
            UTranslate translate = new UTranslate(this.left, this.top);
            this.textBlock.drawU(ug.apply(translate));
        }
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        Rectangle2D parent = this.textBlock.getInnerPosition(member, stringBounder, strategy);
        if (parent == null) {
            return null;
        }
        UTranslate translate = new UTranslate(this.left, this.top);
        return translate.apply(parent);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        return ((WithPorts)((Object)this.textBlock)).getPorts(stringBounder).translateY(this.top);
    }
}

