/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.salt.element.AbstractElementText;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class ElementDroplist
extends AbstractElementText
implements Element {
    private final int box = 12;
    private final TextBlock openDrop;

    public ElementDroplist(String text, UFont font, ISkinSimple spriteContainer) {
        super(ElementDroplist.extract(text), font, true, spriteContainer);
        StringTokenizer st = new StringTokenizer(text, "^");
        ArrayList<String> drop = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            drop.add(st.nextToken());
        }
        if (drop.size() > 0) {
            drop.remove(0);
        }
        this.openDrop = drop.size() == 0 ? null : Display.create(drop).create(this.getConfig(), HorizontalAlignment.LEFT, spriteContainer);
    }

    private static String extract(String text) {
        int idx = text.indexOf(94);
        if (idx == -1) {
            return text;
        }
        return text.substring(0, idx);
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        Dimension2D dim = this.getTextDimensionAt(stringBounder, x + 2.0);
        return Dimension2DDouble.delta(dim, 16.0, 4.0);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        Dimension2D dim = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        ug = ug.apply(this.getBlack());
        if (zIndex == 0) {
            ug.apply(this.getColorEE().bg()).draw(new URectangle(dim.getWidth() - 1.0, dim.getHeight() - 1.0));
            this.drawText(ug, 2.0, 2.0);
            double xline = dim.getWidth() - 12.0;
            ug.apply(UTranslate.dx(xline)).draw(ULine.vline(dim.getHeight() - 1.0));
            UPolygon poly = new UPolygon();
            poly.addPoint(0.0, 0.0);
            poly.addPoint(6.0, 0.0);
            Dimension2D dimText = this.getPureTextDimension(ug.getStringBounder());
            poly.addPoint(3.0, dimText.getHeight() - 8.0);
            ug.apply(HColors.changeBack(ug)).apply(new UTranslate(xline + 3.0, 6.0)).draw(poly);
        }
        if (this.openDrop != null) {
            Dimension2D dimOpen = Dimension2DDouble.atLeast(this.openDrop.calculateDimension(ug.getStringBounder()), dim.getWidth() - 1.0, 0.0);
            ug = ug.apply(UTranslate.dy(dim.getHeight() - 1.0));
            ug.apply(this.getColorEE().bg()).draw(new URectangle(dimOpen.getWidth() - 1.0, dimOpen.getHeight() - 1.0));
            this.openDrop.drawU(ug);
        }
    }
}

