from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.StepData import *
from OCC.Core.StepRepr import *
from OCC.Core.TCollection import *
from OCC.Core.StepBasic import *
from OCC.Core.TColStd import *

#the following typedef cannot be wrapped as is
StepGeom_Array2OfCartesianPoint = NewType('StepGeom_Array2OfCartesianPoint', Any)
#the following typedef cannot be wrapped as is
StepGeom_Array2OfSurfacePatch = NewType('StepGeom_Array2OfSurfacePatch', Any)

class StepGeom_Array1OfBoundaryCurve:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepGeom_Array1OfCartesianPoint:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepGeom_Array1OfCompositeCurveSegment:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepGeom_Array1OfCurve:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepGeom_Array1OfPcurveOrSurface:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> StepGeom_PcurveOrSurface: ...
    def __setitem__(self, index: int, value: StepGeom_PcurveOrSurface) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[StepGeom_PcurveOrSurface]: ...
    def next(self) -> StepGeom_PcurveOrSurface: ...
    __next__ = next
    def Init(self, theValue: StepGeom_PcurveOrSurface) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> StepGeom_PcurveOrSurface: ...
    def Last(self) -> StepGeom_PcurveOrSurface: ...
    def Value(self, theIndex: int) -> StepGeom_PcurveOrSurface: ...
    def SetValue(self, theIndex: int, theValue: StepGeom_PcurveOrSurface) -> None: ...

class StepGeom_Array1OfSurfaceBoundary:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> StepGeom_SurfaceBoundary: ...
    def __setitem__(self, index: int, value: StepGeom_SurfaceBoundary) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[StepGeom_SurfaceBoundary]: ...
    def next(self) -> StepGeom_SurfaceBoundary: ...
    __next__ = next
    def Init(self, theValue: StepGeom_SurfaceBoundary) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> StepGeom_SurfaceBoundary: ...
    def Last(self) -> StepGeom_SurfaceBoundary: ...
    def Value(self, theIndex: int) -> StepGeom_SurfaceBoundary: ...
    def SetValue(self, theIndex: int, theValue: StepGeom_SurfaceBoundary) -> None: ...

class StepGeom_Array1OfTrimmingSelect:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> StepGeom_TrimmingSelect: ...
    def __setitem__(self, index: int, value: StepGeom_TrimmingSelect) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[StepGeom_TrimmingSelect]: ...
    def next(self) -> StepGeom_TrimmingSelect: ...
    __next__ = next
    def Init(self, theValue: StepGeom_TrimmingSelect) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> StepGeom_TrimmingSelect: ...
    def Last(self) -> StepGeom_TrimmingSelect: ...
    def Value(self, theIndex: int) -> StepGeom_TrimmingSelect: ...
    def SetValue(self, theIndex: int, theValue: StepGeom_TrimmingSelect) -> None: ...

class StepGeom_KnotType(IntEnum):
    StepGeom_ktUniformKnots: int = ...
    StepGeom_ktUnspecified: int = ...
    StepGeom_ktQuasiUniformKnots: int = ...
    StepGeom_ktPiecewiseBezierKnots: int = ...

StepGeom_ktUniformKnots = StepGeom_KnotType.StepGeom_ktUniformKnots
StepGeom_ktUnspecified = StepGeom_KnotType.StepGeom_ktUnspecified
StepGeom_ktQuasiUniformKnots = StepGeom_KnotType.StepGeom_ktQuasiUniformKnots
StepGeom_ktPiecewiseBezierKnots = StepGeom_KnotType.StepGeom_ktPiecewiseBezierKnots

class StepGeom_BSplineSurfaceForm(IntEnum):
    StepGeom_bssfPlaneSurf: int = ...
    StepGeom_bssfCylindricalSurf: int = ...
    StepGeom_bssfConicalSurf: int = ...
    StepGeom_bssfSphericalSurf: int = ...
    StepGeom_bssfToroidalSurf: int = ...
    StepGeom_bssfSurfOfRevolution: int = ...
    StepGeom_bssfRuledSurf: int = ...
    StepGeom_bssfGeneralisedCone: int = ...
    StepGeom_bssfQuadricSurf: int = ...
    StepGeom_bssfSurfOfLinearExtrusion: int = ...
    StepGeom_bssfUnspecified: int = ...

StepGeom_bssfPlaneSurf = StepGeom_BSplineSurfaceForm.StepGeom_bssfPlaneSurf
StepGeom_bssfCylindricalSurf = StepGeom_BSplineSurfaceForm.StepGeom_bssfCylindricalSurf
StepGeom_bssfConicalSurf = StepGeom_BSplineSurfaceForm.StepGeom_bssfConicalSurf
StepGeom_bssfSphericalSurf = StepGeom_BSplineSurfaceForm.StepGeom_bssfSphericalSurf
StepGeom_bssfToroidalSurf = StepGeom_BSplineSurfaceForm.StepGeom_bssfToroidalSurf
StepGeom_bssfSurfOfRevolution = StepGeom_BSplineSurfaceForm.StepGeom_bssfSurfOfRevolution
StepGeom_bssfRuledSurf = StepGeom_BSplineSurfaceForm.StepGeom_bssfRuledSurf
StepGeom_bssfGeneralisedCone = StepGeom_BSplineSurfaceForm.StepGeom_bssfGeneralisedCone
StepGeom_bssfQuadricSurf = StepGeom_BSplineSurfaceForm.StepGeom_bssfQuadricSurf
StepGeom_bssfSurfOfLinearExtrusion = StepGeom_BSplineSurfaceForm.StepGeom_bssfSurfOfLinearExtrusion
StepGeom_bssfUnspecified = StepGeom_BSplineSurfaceForm.StepGeom_bssfUnspecified

class StepGeom_BSplineCurveForm(IntEnum):
    StepGeom_bscfPolylineForm: int = ...
    StepGeom_bscfCircularArc: int = ...
    StepGeom_bscfEllipticArc: int = ...
    StepGeom_bscfParabolicArc: int = ...
    StepGeom_bscfHyperbolicArc: int = ...
    StepGeom_bscfUnspecified: int = ...

StepGeom_bscfPolylineForm = StepGeom_BSplineCurveForm.StepGeom_bscfPolylineForm
StepGeom_bscfCircularArc = StepGeom_BSplineCurveForm.StepGeom_bscfCircularArc
StepGeom_bscfEllipticArc = StepGeom_BSplineCurveForm.StepGeom_bscfEllipticArc
StepGeom_bscfParabolicArc = StepGeom_BSplineCurveForm.StepGeom_bscfParabolicArc
StepGeom_bscfHyperbolicArc = StepGeom_BSplineCurveForm.StepGeom_bscfHyperbolicArc
StepGeom_bscfUnspecified = StepGeom_BSplineCurveForm.StepGeom_bscfUnspecified

class StepGeom_TrimmingPreference(IntEnum):
    StepGeom_tpCartesian: int = ...
    StepGeom_tpParameter: int = ...
    StepGeom_tpUnspecified: int = ...

StepGeom_tpCartesian = StepGeom_TrimmingPreference.StepGeom_tpCartesian
StepGeom_tpParameter = StepGeom_TrimmingPreference.StepGeom_tpParameter
StepGeom_tpUnspecified = StepGeom_TrimmingPreference.StepGeom_tpUnspecified

class StepGeom_PreferredSurfaceCurveRepresentation(IntEnum):
    StepGeom_pscrCurve3d: int = ...
    StepGeom_pscrPcurveS1: int = ...
    StepGeom_pscrPcurveS2: int = ...

StepGeom_pscrCurve3d = StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrCurve3d
StepGeom_pscrPcurveS1 = StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrPcurveS1
StepGeom_pscrPcurveS2 = StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrPcurveS2

class StepGeom_TransitionCode(IntEnum):
    StepGeom_tcDiscontinuous: int = ...
    StepGeom_tcContinuous: int = ...
    StepGeom_tcContSameGradient: int = ...
    StepGeom_tcContSameGradientSameCurvature: int = ...

StepGeom_tcDiscontinuous = StepGeom_TransitionCode.StepGeom_tcDiscontinuous
StepGeom_tcContinuous = StepGeom_TransitionCode.StepGeom_tcContinuous
StepGeom_tcContSameGradient = StepGeom_TransitionCode.StepGeom_tcContSameGradient
StepGeom_tcContSameGradientSameCurvature = StepGeom_TransitionCode.StepGeom_tcContSameGradientSameCurvature

class StepGeom_Axis2Placement(StepData_SelectType):
    def __init__(self) -> None: ...
    def Axis2Placement2d(self) -> StepGeom_Axis2Placement2d: ...
    def Axis2Placement3d(self) -> StepGeom_Axis2Placement3d: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...

class StepGeom_CompositeCurveSegment(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aTransition: StepGeom_TransitionCode, aSameSense: bool, aParentCurve: StepGeom_Curve) -> None: ...
    def ParentCurve(self) -> StepGeom_Curve: ...
    def SameSense(self) -> bool: ...
    def SetParentCurve(self, aParentCurve: StepGeom_Curve) -> None: ...
    def SetSameSense(self, aSameSense: bool) -> None: ...
    def SetTransition(self, aTransition: StepGeom_TransitionCode) -> None: ...
    def Transition(self) -> StepGeom_TransitionCode: ...

class StepGeom_CurveOnSurface(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def CompositeCurveOnSurface(self) -> StepGeom_CompositeCurveOnSurface: ...
    def Pcurve(self) -> StepGeom_Pcurve: ...
    def SurfaceCurve(self) -> StepGeom_SurfaceCurve: ...

class StepGeom_GeomRepContextAndGlobUnitAssCtxAndGlobUncertaintyAssCtx(StepRepr_RepresentationContext):
    def __init__(self) -> None: ...
    def CoordinateSpaceDimension(self) -> int: ...
    def GeometricRepresentationContext(self) -> StepGeom_GeometricRepresentationContext: ...
    def GlobalUncertaintyAssignedContext(self) -> StepRepr_GlobalUncertaintyAssignedContext: ...
    def GlobalUnitAssignedContext(self) -> StepRepr_GlobalUnitAssignedContext: ...
    @overload
    def Init(self, aContextIdentifier: TCollection_HAsciiString, aContextType: TCollection_HAsciiString, aGeometricRepresentationCtx: StepGeom_GeometricRepresentationContext, aGlobalUnitAssignedCtx: StepRepr_GlobalUnitAssignedContext, aGlobalUncertaintyAssignedCtx: StepRepr_GlobalUncertaintyAssignedContext) -> None: ...
    @overload
    def Init(self, aContextIdentifier: TCollection_HAsciiString, aContextType: TCollection_HAsciiString, aCoordinateSpaceDimension: int, aUnits: StepBasic_HArray1OfNamedUnit, anUncertainty: StepBasic_HArray1OfUncertaintyMeasureWithUnit) -> None: ...
    def NbUncertainty(self) -> int: ...
    def NbUnits(self) -> int: ...
    def SetCoordinateSpaceDimension(self, aCoordinateSpaceDimension: int) -> None: ...
    def SetGeometricRepresentationContext(self, aGeometricRepresentationContext: StepGeom_GeometricRepresentationContext) -> None: ...
    def SetGlobalUncertaintyAssignedContext(self, aGlobalUncertaintyAssignedCtx: StepRepr_GlobalUncertaintyAssignedContext) -> None: ...
    def SetGlobalUnitAssignedContext(self, aGlobalUnitAssignedContext: StepRepr_GlobalUnitAssignedContext) -> None: ...
    def SetUncertainty(self, aUncertainty: StepBasic_HArray1OfUncertaintyMeasureWithUnit) -> None: ...
    def SetUnits(self, aUnits: StepBasic_HArray1OfNamedUnit) -> None: ...
    def Uncertainty(self) -> StepBasic_HArray1OfUncertaintyMeasureWithUnit: ...
    def UncertaintyValue(self, num: int) -> StepBasic_UncertaintyMeasureWithUnit: ...
    def Units(self) -> StepBasic_HArray1OfNamedUnit: ...
    def UnitsValue(self, num: int) -> StepBasic_NamedUnit: ...

class StepGeom_GeometricRepresentationContext(StepRepr_RepresentationContext):
    def __init__(self) -> None: ...
    def CoordinateSpaceDimension(self) -> int: ...
    def Init(self, aContextIdentifier: TCollection_HAsciiString, aContextType: TCollection_HAsciiString, aCoordinateSpaceDimension: int) -> None: ...
    def SetCoordinateSpaceDimension(self, aCoordinateSpaceDimension: int) -> None: ...

class StepGeom_GeometricRepresentationContextAndGlobalUnitAssignedContext(StepRepr_RepresentationContext):
    def __init__(self) -> None: ...
    def CoordinateSpaceDimension(self) -> int: ...
    def GeometricRepresentationContext(self) -> StepGeom_GeometricRepresentationContext: ...
    def GlobalUnitAssignedContext(self) -> StepRepr_GlobalUnitAssignedContext: ...
    @overload
    def Init(self, aContextIdentifier: TCollection_HAsciiString, aContextType: TCollection_HAsciiString, aGeometricRepresentationContext: StepGeom_GeometricRepresentationContext, aGlobalUnitAssignedContext: StepRepr_GlobalUnitAssignedContext) -> None: ...
    @overload
    def Init(self, aContextIdentifier: TCollection_HAsciiString, aContextType: TCollection_HAsciiString, aCoordinateSpaceDimension: int, aUnits: StepBasic_HArray1OfNamedUnit) -> None: ...
    def NbUnits(self) -> int: ...
    def SetCoordinateSpaceDimension(self, aCoordinateSpaceDimension: int) -> None: ...
    def SetGeometricRepresentationContext(self, aGeometricRepresentationContext: StepGeom_GeometricRepresentationContext) -> None: ...
    def SetGlobalUnitAssignedContext(self, aGlobalUnitAssignedContext: StepRepr_GlobalUnitAssignedContext) -> None: ...
    def SetUnits(self, aUnits: StepBasic_HArray1OfNamedUnit) -> None: ...
    def Units(self) -> StepBasic_HArray1OfNamedUnit: ...
    def UnitsValue(self, num: int) -> StepBasic_NamedUnit: ...

class StepGeom_GeometricRepresentationContextAndParametricRepresentationContext(StepRepr_RepresentationContext):
    def __init__(self) -> None: ...
    def CoordinateSpaceDimension(self) -> int: ...
    def GeometricRepresentationContext(self) -> StepGeom_GeometricRepresentationContext: ...
    @overload
    def Init(self, aContextIdentifier: TCollection_HAsciiString, aContextType: TCollection_HAsciiString, aGeometricRepresentationContext: StepGeom_GeometricRepresentationContext, aParametricRepresentationContext: StepRepr_ParametricRepresentationContext) -> None: ...
    @overload
    def Init(self, aContextIdentifier: TCollection_HAsciiString, aContextType: TCollection_HAsciiString, aCoordinateSpaceDimension: int) -> None: ...
    def ParametricRepresentationContext(self) -> StepRepr_ParametricRepresentationContext: ...
    def SetCoordinateSpaceDimension(self, aCoordinateSpaceDimension: int) -> None: ...
    def SetGeometricRepresentationContext(self, aGeometricRepresentationContext: StepGeom_GeometricRepresentationContext) -> None: ...
    def SetParametricRepresentationContext(self, aParametricRepresentationContext: StepRepr_ParametricRepresentationContext) -> None: ...

class StepGeom_GeometricRepresentationItem(StepRepr_RepresentationItem):
    def __init__(self) -> None: ...

class StepGeom_PcurveOrSurface(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def Pcurve(self) -> StepGeom_Pcurve: ...
    def Surface(self) -> StepGeom_Surface: ...

class StepGeom_SurfaceBoundary(StepData_SelectType):
    def __init__(self) -> None: ...
    def BoundaryCurve(self) -> StepGeom_BoundaryCurve: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def DegeneratePcurve(self) -> StepGeom_DegeneratePcurve: ...

class StepGeom_SurfacePatch(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aParentSurface: StepGeom_BoundedSurface, aUTransition: StepGeom_TransitionCode, aVTransition: StepGeom_TransitionCode, aUSense: bool, aVSense: bool) -> None: ...
    def ParentSurface(self) -> StepGeom_BoundedSurface: ...
    def SetParentSurface(self, aParentSurface: StepGeom_BoundedSurface) -> None: ...
    def SetUSense(self, aUSense: bool) -> None: ...
    def SetUTransition(self, aUTransition: StepGeom_TransitionCode) -> None: ...
    def SetVSense(self, aVSense: bool) -> None: ...
    def SetVTransition(self, aVTransition: StepGeom_TransitionCode) -> None: ...
    def USense(self) -> bool: ...
    def UTransition(self) -> StepGeom_TransitionCode: ...
    def VSense(self) -> bool: ...
    def VTransition(self) -> StepGeom_TransitionCode: ...

class StepGeom_TrimmingMember(StepData_SelectReal):
    def __init__(self) -> None: ...
    def HasName(self) -> bool: ...
    def Name(self) -> str: ...
    def SetName(self, name: str) -> bool: ...

class StepGeom_TrimmingSelect(StepData_SelectType):
    def __init__(self) -> None: ...
    def CartesianPoint(self) -> StepGeom_CartesianPoint: ...
    def CaseMem(self, ent: StepData_SelectMember) -> int: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def NewMember(self) -> StepData_SelectMember: ...
    def ParameterValue(self) -> float: ...
    def SetParameterValue(self, aParameterValue: float) -> None: ...

class StepGeom_VectorOrDirection(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def Direction(self) -> StepGeom_Direction: ...
    def Vector(self) -> StepGeom_Vector: ...

class StepGeom_CartesianTransformationOperator(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Axis1(self) -> StepGeom_Direction: ...
    def Axis2(self) -> StepGeom_Direction: ...
    def HasAxis1(self) -> bool: ...
    def HasAxis2(self) -> bool: ...
    def HasScale(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasAaxis1: bool, aAxis1: StepGeom_Direction, hasAaxis2: bool, aAxis2: StepGeom_Direction, aLocalOrigin: StepGeom_CartesianPoint, hasAscale: bool, aScale: float) -> None: ...
    def LocalOrigin(self) -> StepGeom_CartesianPoint: ...
    def Scale(self) -> float: ...
    def SetAxis1(self, aAxis1: StepGeom_Direction) -> None: ...
    def SetAxis2(self, aAxis2: StepGeom_Direction) -> None: ...
    def SetLocalOrigin(self, aLocalOrigin: StepGeom_CartesianPoint) -> None: ...
    def SetScale(self, aScale: float) -> None: ...
    def UnSetAxis1(self) -> None: ...
    def UnSetAxis2(self) -> None: ...
    def UnSetScale(self) -> None: ...

class StepGeom_Curve(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...

class StepGeom_Direction(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def DirectionRatios(self) -> TColStd_HArray1OfReal: ...
    def DirectionRatiosValue(self, num: int) -> float: ...
    def Init(self, aName: TCollection_HAsciiString, aDirectionRatios: TColStd_HArray1OfReal) -> None: ...
    def NbDirectionRatios(self) -> int: ...
    def SetDirectionRatios(self, aDirectionRatios: TColStd_HArray1OfReal) -> None: ...

class StepGeom_Placement(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aLocation: StepGeom_CartesianPoint) -> None: ...
    def Location(self) -> StepGeom_CartesianPoint: ...
    def SetLocation(self, aLocation: StepGeom_CartesianPoint) -> None: ...

class StepGeom_Point(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...

class StepGeom_ReparametrisedCompositeCurveSegment(StepGeom_CompositeCurveSegment):
    def __init__(self) -> None: ...
    def Init(self, aTransition: StepGeom_TransitionCode, aSameSense: bool, aParentCurve: StepGeom_Curve, aParamLength: float) -> None: ...
    def ParamLength(self) -> float: ...
    def SetParamLength(self, aParamLength: float) -> None: ...

class StepGeom_Surface(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...

class StepGeom_Vector(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aOrientation: StepGeom_Direction, aMagnitude: float) -> None: ...
    def Magnitude(self) -> float: ...
    def Orientation(self) -> StepGeom_Direction: ...
    def SetMagnitude(self, aMagnitude: float) -> None: ...
    def SetOrientation(self, aOrientation: StepGeom_Direction) -> None: ...

class StepGeom_Axis1Placement(StepGeom_Placement):
    def __init__(self) -> None: ...
    def Axis(self) -> StepGeom_Direction: ...
    def HasAxis(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, aLocation: StepGeom_CartesianPoint, hasAaxis: bool, aAxis: StepGeom_Direction) -> None: ...
    def SetAxis(self, aAxis: StepGeom_Direction) -> None: ...
    def UnSetAxis(self) -> None: ...

class StepGeom_Axis2Placement2d(StepGeom_Placement):
    def __init__(self) -> None: ...
    def HasRefDirection(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, aLocation: StepGeom_CartesianPoint, hasArefDirection: bool, aRefDirection: StepGeom_Direction) -> None: ...
    def RefDirection(self) -> StepGeom_Direction: ...
    def SetRefDirection(self, aRefDirection: StepGeom_Direction) -> None: ...
    def UnSetRefDirection(self) -> None: ...

class StepGeom_Axis2Placement3d(StepGeom_Placement):
    def __init__(self) -> None: ...
    def Axis(self) -> StepGeom_Direction: ...
    def HasAxis(self) -> bool: ...
    def HasRefDirection(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, aLocation: StepGeom_CartesianPoint, hasAaxis: bool, aAxis: StepGeom_Direction, hasArefDirection: bool, aRefDirection: StepGeom_Direction) -> None: ...
    def RefDirection(self) -> StepGeom_Direction: ...
    def SetAxis(self, aAxis: StepGeom_Direction) -> None: ...
    def SetRefDirection(self, aRefDirection: StepGeom_Direction) -> None: ...
    def UnSetAxis(self) -> None: ...
    def UnSetRefDirection(self) -> None: ...

class StepGeom_BoundedCurve(StepGeom_Curve):
    def __init__(self) -> None: ...

class StepGeom_BoundedSurface(StepGeom_Surface):
    def __init__(self) -> None: ...

class StepGeom_CartesianPoint(StepGeom_Point):
    def __init__(self) -> None: ...
    def Coordinates(self) -> TColStd_HArray1OfReal: ...
    def CoordinatesValue(self, num: int) -> float: ...
    def Init(self, aName: TCollection_HAsciiString, aCoordinates: TColStd_HArray1OfReal) -> None: ...
    def Init2D(self, aName: TCollection_HAsciiString, X: float, Y: float) -> None: ...
    def Init3D(self, aName: TCollection_HAsciiString, X: float, Y: float, Z: float) -> None: ...
    def NbCoordinates(self) -> int: ...
    def SetCoordinates(self, aCoordinates: TColStd_HArray1OfReal) -> None: ...

class StepGeom_CartesianTransformationOperator2d(StepGeom_CartesianTransformationOperator):
    def __init__(self) -> None: ...

class StepGeom_CartesianTransformationOperator3d(StepGeom_CartesianTransformationOperator):
    def __init__(self) -> None: ...
    def Axis3(self) -> StepGeom_Direction: ...
    def HasAxis3(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasAaxis1: bool, aAxis1: StepGeom_Direction, hasAaxis2: bool, aAxis2: StepGeom_Direction, aLocalOrigin: StepGeom_CartesianPoint, hasAscale: bool, aScale: float, hasAaxis3: bool, aAxis3: StepGeom_Direction) -> None: ...
    def SetAxis3(self, aAxis3: StepGeom_Direction) -> None: ...
    def UnSetAxis3(self) -> None: ...

class StepGeom_Conic(StepGeom_Curve):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement) -> None: ...
    def Position(self) -> StepGeom_Axis2Placement: ...
    def SetPosition(self, aPosition: StepGeom_Axis2Placement) -> None: ...

class StepGeom_CurveReplica(StepGeom_Curve):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aParentCurve: StepGeom_Curve, aTransformation: StepGeom_CartesianTransformationOperator) -> None: ...
    def ParentCurve(self) -> StepGeom_Curve: ...
    def SetParentCurve(self, aParentCurve: StepGeom_Curve) -> None: ...
    def SetTransformation(self, aTransformation: StepGeom_CartesianTransformationOperator) -> None: ...
    def Transformation(self) -> StepGeom_CartesianTransformationOperator: ...

class StepGeom_DegeneratePcurve(StepGeom_Point):
    def __init__(self) -> None: ...
    def BasisSurface(self) -> StepGeom_Surface: ...
    def Init(self, aName: TCollection_HAsciiString, aBasisSurface: StepGeom_Surface, aReferenceToCurve: StepRepr_DefinitionalRepresentation) -> None: ...
    def ReferenceToCurve(self) -> StepRepr_DefinitionalRepresentation: ...
    def SetBasisSurface(self, aBasisSurface: StepGeom_Surface) -> None: ...
    def SetReferenceToCurve(self, aReferenceToCurve: StepRepr_DefinitionalRepresentation) -> None: ...

class StepGeom_ElementarySurface(StepGeom_Surface):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement3d) -> None: ...
    def Position(self) -> StepGeom_Axis2Placement3d: ...
    def SetPosition(self, aPosition: StepGeom_Axis2Placement3d) -> None: ...

class StepGeom_Line(StepGeom_Curve):
    def __init__(self) -> None: ...
    def Dir(self) -> StepGeom_Vector: ...
    def Init(self, aName: TCollection_HAsciiString, aPnt: StepGeom_CartesianPoint, aDir: StepGeom_Vector) -> None: ...
    def Pnt(self) -> StepGeom_CartesianPoint: ...
    def SetDir(self, aDir: StepGeom_Vector) -> None: ...
    def SetPnt(self, aPnt: StepGeom_CartesianPoint) -> None: ...

class StepGeom_OffsetCurve3d(StepGeom_Curve):
    def __init__(self) -> None: ...
    def BasisCurve(self) -> StepGeom_Curve: ...
    def Distance(self) -> float: ...
    def Init(self, aName: TCollection_HAsciiString, aBasisCurve: StepGeom_Curve, aDistance: float, aSelfIntersect: StepData_Logical, aRefDirection: StepGeom_Direction) -> None: ...
    def RefDirection(self) -> StepGeom_Direction: ...
    def SelfIntersect(self) -> StepData_Logical: ...
    def SetBasisCurve(self, aBasisCurve: StepGeom_Curve) -> None: ...
    def SetDistance(self, aDistance: float) -> None: ...
    def SetRefDirection(self, aRefDirection: StepGeom_Direction) -> None: ...
    def SetSelfIntersect(self, aSelfIntersect: StepData_Logical) -> None: ...

class StepGeom_OffsetSurface(StepGeom_Surface):
    def __init__(self) -> None: ...
    def BasisSurface(self) -> StepGeom_Surface: ...
    def Distance(self) -> float: ...
    def Init(self, aName: TCollection_HAsciiString, aBasisSurface: StepGeom_Surface, aDistance: float, aSelfIntersect: StepData_Logical) -> None: ...
    def SelfIntersect(self) -> StepData_Logical: ...
    def SetBasisSurface(self, aBasisSurface: StepGeom_Surface) -> None: ...
    def SetDistance(self, aDistance: float) -> None: ...
    def SetSelfIntersect(self, aSelfIntersect: StepData_Logical) -> None: ...

class StepGeom_OrientedSurface(StepGeom_Surface):
    def __init__(self) -> None: ...
    def Init(self, aRepresentationItem_Name: TCollection_HAsciiString, aOrientation: bool) -> None: ...
    def Orientation(self) -> bool: ...
    def SetOrientation(self, Orientation: bool) -> None: ...

class StepGeom_Pcurve(StepGeom_Curve):
    def __init__(self) -> None: ...
    def BasisSurface(self) -> StepGeom_Surface: ...
    def Init(self, aName: TCollection_HAsciiString, aBasisSurface: StepGeom_Surface, aReferenceToCurve: StepRepr_DefinitionalRepresentation) -> None: ...
    def ReferenceToCurve(self) -> StepRepr_DefinitionalRepresentation: ...
    def SetBasisSurface(self, aBasisSurface: StepGeom_Surface) -> None: ...
    def SetReferenceToCurve(self, aReferenceToCurve: StepRepr_DefinitionalRepresentation) -> None: ...

class StepGeom_PointOnCurve(StepGeom_Point):
    def __init__(self) -> None: ...
    def BasisCurve(self) -> StepGeom_Curve: ...
    def Init(self, aName: TCollection_HAsciiString, aBasisCurve: StepGeom_Curve, aPointParameter: float) -> None: ...
    def PointParameter(self) -> float: ...
    def SetBasisCurve(self, aBasisCurve: StepGeom_Curve) -> None: ...
    def SetPointParameter(self, aPointParameter: float) -> None: ...

class StepGeom_PointOnSurface(StepGeom_Point):
    def __init__(self) -> None: ...
    def BasisSurface(self) -> StepGeom_Surface: ...
    def Init(self, aName: TCollection_HAsciiString, aBasisSurface: StepGeom_Surface, aPointParameterU: float, aPointParameterV: float) -> None: ...
    def PointParameterU(self) -> float: ...
    def PointParameterV(self) -> float: ...
    def SetBasisSurface(self, aBasisSurface: StepGeom_Surface) -> None: ...
    def SetPointParameterU(self, aPointParameterU: float) -> None: ...
    def SetPointParameterV(self, aPointParameterV: float) -> None: ...

class StepGeom_PointReplica(StepGeom_Point):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aParentPt: StepGeom_Point, aTransformation: StepGeom_CartesianTransformationOperator) -> None: ...
    def ParentPt(self) -> StepGeom_Point: ...
    def SetParentPt(self, aParentPt: StepGeom_Point) -> None: ...
    def SetTransformation(self, aTransformation: StepGeom_CartesianTransformationOperator) -> None: ...
    def Transformation(self) -> StepGeom_CartesianTransformationOperator: ...

class StepGeom_SurfaceCurve(StepGeom_Curve):
    def __init__(self) -> None: ...
    def AssociatedGeometry(self) -> StepGeom_HArray1OfPcurveOrSurface: ...
    def AssociatedGeometryValue(self, num: int) -> StepGeom_PcurveOrSurface: ...
    def Curve3d(self) -> StepGeom_Curve: ...
    def Init(self, aName: TCollection_HAsciiString, aCurve3d: StepGeom_Curve, aAssociatedGeometry: StepGeom_HArray1OfPcurveOrSurface, aMasterRepresentation: StepGeom_PreferredSurfaceCurveRepresentation) -> None: ...
    def MasterRepresentation(self) -> StepGeom_PreferredSurfaceCurveRepresentation: ...
    def NbAssociatedGeometry(self) -> int: ...
    def SetAssociatedGeometry(self, aAssociatedGeometry: StepGeom_HArray1OfPcurveOrSurface) -> None: ...
    def SetCurve3d(self, aCurve3d: StepGeom_Curve) -> None: ...
    def SetMasterRepresentation(self, aMasterRepresentation: StepGeom_PreferredSurfaceCurveRepresentation) -> None: ...

class StepGeom_SurfaceReplica(StepGeom_Surface):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aParentSurface: StepGeom_Surface, aTransformation: StepGeom_CartesianTransformationOperator3d) -> None: ...
    def ParentSurface(self) -> StepGeom_Surface: ...
    def SetParentSurface(self, aParentSurface: StepGeom_Surface) -> None: ...
    def SetTransformation(self, aTransformation: StepGeom_CartesianTransformationOperator3d) -> None: ...
    def Transformation(self) -> StepGeom_CartesianTransformationOperator3d: ...

class StepGeom_SweptSurface(StepGeom_Surface):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aSweptCurve: StepGeom_Curve) -> None: ...
    def SetSweptCurve(self, aSweptCurve: StepGeom_Curve) -> None: ...
    def SweptCurve(self) -> StepGeom_Curve: ...

class StepGeom_BSplineCurve(StepGeom_BoundedCurve):
    def __init__(self) -> None: ...
    def ClosedCurve(self) -> StepData_Logical: ...
    def ControlPointsList(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def ControlPointsListValue(self, num: int) -> StepGeom_CartesianPoint: ...
    def CurveForm(self) -> StepGeom_BSplineCurveForm: ...
    def Degree(self) -> int: ...
    def Init(self, aName: TCollection_HAsciiString, aDegree: int, aControlPointsList: StepGeom_HArray1OfCartesianPoint, aCurveForm: StepGeom_BSplineCurveForm, aClosedCurve: StepData_Logical, aSelfIntersect: StepData_Logical) -> None: ...
    def NbControlPointsList(self) -> int: ...
    def SelfIntersect(self) -> StepData_Logical: ...
    def SetClosedCurve(self, aClosedCurve: StepData_Logical) -> None: ...
    def SetControlPointsList(self, aControlPointsList: StepGeom_HArray1OfCartesianPoint) -> None: ...
    def SetCurveForm(self, aCurveForm: StepGeom_BSplineCurveForm) -> None: ...
    def SetDegree(self, aDegree: int) -> None: ...
    def SetSelfIntersect(self, aSelfIntersect: StepData_Logical) -> None: ...

class StepGeom_BSplineSurface(StepGeom_BoundedSurface):
    def __init__(self) -> None: ...
    def ControlPointsList(self) -> StepGeom_HArray2OfCartesianPoint: ...
    def ControlPointsListValue(self, num1: int, num2: int) -> StepGeom_CartesianPoint: ...
    def Init(self, aName: TCollection_HAsciiString, aUDegree: int, aVDegree: int, aControlPointsList: StepGeom_HArray2OfCartesianPoint, aSurfaceForm: StepGeom_BSplineSurfaceForm, aUClosed: StepData_Logical, aVClosed: StepData_Logical, aSelfIntersect: StepData_Logical) -> None: ...
    def NbControlPointsListI(self) -> int: ...
    def NbControlPointsListJ(self) -> int: ...
    def SelfIntersect(self) -> StepData_Logical: ...
    def SetControlPointsList(self, aControlPointsList: StepGeom_HArray2OfCartesianPoint) -> None: ...
    def SetSelfIntersect(self, aSelfIntersect: StepData_Logical) -> None: ...
    def SetSurfaceForm(self, aSurfaceForm: StepGeom_BSplineSurfaceForm) -> None: ...
    def SetUClosed(self, aUClosed: StepData_Logical) -> None: ...
    def SetUDegree(self, aUDegree: int) -> None: ...
    def SetVClosed(self, aVClosed: StepData_Logical) -> None: ...
    def SetVDegree(self, aVDegree: int) -> None: ...
    def SurfaceForm(self) -> StepGeom_BSplineSurfaceForm: ...
    def UClosed(self) -> StepData_Logical: ...
    def UDegree(self) -> int: ...
    def VClosed(self) -> StepData_Logical: ...
    def VDegree(self) -> int: ...

class StepGeom_Circle(StepGeom_Conic):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement, aRadius: float) -> None: ...
    def Radius(self) -> float: ...
    def SetRadius(self, aRadius: float) -> None: ...

class StepGeom_CompositeCurve(StepGeom_BoundedCurve):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aSegments: StepGeom_HArray1OfCompositeCurveSegment, aSelfIntersect: StepData_Logical) -> None: ...
    def NbSegments(self) -> int: ...
    def Segments(self) -> StepGeom_HArray1OfCompositeCurveSegment: ...
    def SegmentsValue(self, num: int) -> StepGeom_CompositeCurveSegment: ...
    def SelfIntersect(self) -> StepData_Logical: ...
    def SetSegments(self, aSegments: StepGeom_HArray1OfCompositeCurveSegment) -> None: ...
    def SetSelfIntersect(self, aSelfIntersect: StepData_Logical) -> None: ...

class StepGeom_ConicalSurface(StepGeom_ElementarySurface):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement3d, aRadius: float, aSemiAngle: float) -> None: ...
    def Radius(self) -> float: ...
    def SemiAngle(self) -> float: ...
    def SetRadius(self, aRadius: float) -> None: ...
    def SetSemiAngle(self, aSemiAngle: float) -> None: ...

class StepGeom_CurveBoundedSurface(StepGeom_BoundedSurface):
    def __init__(self) -> None: ...
    def BasisSurface(self) -> StepGeom_Surface: ...
    def Boundaries(self) -> StepGeom_HArray1OfSurfaceBoundary: ...
    def ImplicitOuter(self) -> bool: ...
    def Init(self, aRepresentationItem_Name: TCollection_HAsciiString, aBasisSurface: StepGeom_Surface, aBoundaries: StepGeom_HArray1OfSurfaceBoundary, aImplicitOuter: bool) -> None: ...
    def SetBasisSurface(self, BasisSurface: StepGeom_Surface) -> None: ...
    def SetBoundaries(self, Boundaries: StepGeom_HArray1OfSurfaceBoundary) -> None: ...
    def SetImplicitOuter(self, ImplicitOuter: bool) -> None: ...

class StepGeom_CylindricalSurface(StepGeom_ElementarySurface):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement3d, aRadius: float) -> None: ...
    def Radius(self) -> float: ...
    def SetRadius(self, aRadius: float) -> None: ...

class StepGeom_Ellipse(StepGeom_Conic):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement, aSemiAxis1: float, aSemiAxis2: float) -> None: ...
    def SemiAxis1(self) -> float: ...
    def SemiAxis2(self) -> float: ...
    def SetSemiAxis1(self, aSemiAxis1: float) -> None: ...
    def SetSemiAxis2(self, aSemiAxis2: float) -> None: ...

class StepGeom_EvaluatedDegeneratePcurve(StepGeom_DegeneratePcurve):
    def __init__(self) -> None: ...
    def EquivalentPoint(self) -> StepGeom_CartesianPoint: ...
    def Init(self, aName: TCollection_HAsciiString, aBasisSurface: StepGeom_Surface, aReferenceToCurve: StepRepr_DefinitionalRepresentation, aEquivalentPoint: StepGeom_CartesianPoint) -> None: ...
    def SetEquivalentPoint(self, aEquivalentPoint: StepGeom_CartesianPoint) -> None: ...

class StepGeom_Hyperbola(StepGeom_Conic):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement, aSemiAxis: float, aSemiImagAxis: float) -> None: ...
    def SemiAxis(self) -> float: ...
    def SemiImagAxis(self) -> float: ...
    def SetSemiAxis(self, aSemiAxis: float) -> None: ...
    def SetSemiImagAxis(self, aSemiImagAxis: float) -> None: ...

class StepGeom_IntersectionCurve(StepGeom_SurfaceCurve):
    def __init__(self) -> None: ...

class StepGeom_Parabola(StepGeom_Conic):
    def __init__(self) -> None: ...
    def FocalDist(self) -> float: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement, aFocalDist: float) -> None: ...
    def SetFocalDist(self, aFocalDist: float) -> None: ...

class StepGeom_Plane(StepGeom_ElementarySurface):
    def __init__(self) -> None: ...

class StepGeom_Polyline(StepGeom_BoundedCurve):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPoints: StepGeom_HArray1OfCartesianPoint) -> None: ...
    def NbPoints(self) -> int: ...
    def Points(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def PointsValue(self, num: int) -> StepGeom_CartesianPoint: ...
    def SetPoints(self, aPoints: StepGeom_HArray1OfCartesianPoint) -> None: ...

class StepGeom_RectangularCompositeSurface(StepGeom_BoundedSurface):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aSegments: StepGeom_HArray2OfSurfacePatch) -> None: ...
    def NbSegmentsI(self) -> int: ...
    def NbSegmentsJ(self) -> int: ...
    def Segments(self) -> StepGeom_HArray2OfSurfacePatch: ...
    def SegmentsValue(self, num1: int, num2: int) -> StepGeom_SurfacePatch: ...
    def SetSegments(self, aSegments: StepGeom_HArray2OfSurfacePatch) -> None: ...

class StepGeom_RectangularTrimmedSurface(StepGeom_BoundedSurface):
    def __init__(self) -> None: ...
    def BasisSurface(self) -> StepGeom_Surface: ...
    def Init(self, aName: TCollection_HAsciiString, aBasisSurface: StepGeom_Surface, aU1: float, aU2: float, aV1: float, aV2: float, aUsense: bool, aVsense: bool) -> None: ...
    def SetBasisSurface(self, aBasisSurface: StepGeom_Surface) -> None: ...
    def SetU1(self, aU1: float) -> None: ...
    def SetU2(self, aU2: float) -> None: ...
    def SetUsense(self, aUsense: bool) -> None: ...
    def SetV1(self, aV1: float) -> None: ...
    def SetV2(self, aV2: float) -> None: ...
    def SetVsense(self, aVsense: bool) -> None: ...
    def U1(self) -> float: ...
    def U2(self) -> float: ...
    def Usense(self) -> bool: ...
    def V1(self) -> float: ...
    def V2(self) -> float: ...
    def Vsense(self) -> bool: ...

class StepGeom_SeamCurve(StepGeom_SurfaceCurve):
    def __init__(self) -> None: ...

class StepGeom_SphericalSurface(StepGeom_ElementarySurface):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement3d, aRadius: float) -> None: ...
    def Radius(self) -> float: ...
    def SetRadius(self, aRadius: float) -> None: ...

class StepGeom_SurfaceCurveAndBoundedCurve(StepGeom_SurfaceCurve):
    def __init__(self) -> None: ...
    def BoundedCurve(self) -> StepGeom_BoundedCurve: ...

class StepGeom_SurfaceOfLinearExtrusion(StepGeom_SweptSurface):
    def __init__(self) -> None: ...
    def ExtrusionAxis(self) -> StepGeom_Vector: ...
    def Init(self, aName: TCollection_HAsciiString, aSweptCurve: StepGeom_Curve, aExtrusionAxis: StepGeom_Vector) -> None: ...
    def SetExtrusionAxis(self, aExtrusionAxis: StepGeom_Vector) -> None: ...

class StepGeom_SurfaceOfRevolution(StepGeom_SweptSurface):
    def __init__(self) -> None: ...
    def AxisPosition(self) -> StepGeom_Axis1Placement: ...
    def Init(self, aName: TCollection_HAsciiString, aSweptCurve: StepGeom_Curve, aAxisPosition: StepGeom_Axis1Placement) -> None: ...
    def SetAxisPosition(self, aAxisPosition: StepGeom_Axis1Placement) -> None: ...

class StepGeom_ToroidalSurface(StepGeom_ElementarySurface):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement3d, aMajorRadius: float, aMinorRadius: float) -> None: ...
    def MajorRadius(self) -> float: ...
    def MinorRadius(self) -> float: ...
    def SetMajorRadius(self, aMajorRadius: float) -> None: ...
    def SetMinorRadius(self, aMinorRadius: float) -> None: ...

class StepGeom_TrimmedCurve(StepGeom_BoundedCurve):
    def __init__(self) -> None: ...
    def BasisCurve(self) -> StepGeom_Curve: ...
    def Init(self, aName: TCollection_HAsciiString, aBasisCurve: StepGeom_Curve, aTrim1: StepGeom_HArray1OfTrimmingSelect, aTrim2: StepGeom_HArray1OfTrimmingSelect, aSenseAgreement: bool, aMasterRepresentation: StepGeom_TrimmingPreference) -> None: ...
    def MasterRepresentation(self) -> StepGeom_TrimmingPreference: ...
    def NbTrim1(self) -> int: ...
    def NbTrim2(self) -> int: ...
    def SenseAgreement(self) -> bool: ...
    def SetBasisCurve(self, aBasisCurve: StepGeom_Curve) -> None: ...
    def SetMasterRepresentation(self, aMasterRepresentation: StepGeom_TrimmingPreference) -> None: ...
    def SetSenseAgreement(self, aSenseAgreement: bool) -> None: ...
    def SetTrim1(self, aTrim1: StepGeom_HArray1OfTrimmingSelect) -> None: ...
    def SetTrim2(self, aTrim2: StepGeom_HArray1OfTrimmingSelect) -> None: ...
    def Trim1(self) -> StepGeom_HArray1OfTrimmingSelect: ...
    def Trim1Value(self, num: int) -> StepGeom_TrimmingSelect: ...
    def Trim2(self) -> StepGeom_HArray1OfTrimmingSelect: ...
    def Trim2Value(self, num: int) -> StepGeom_TrimmingSelect: ...

class StepGeom_BSplineCurveWithKnots(StepGeom_BSplineCurve):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aDegree: int, aControlPointsList: StepGeom_HArray1OfCartesianPoint, aCurveForm: StepGeom_BSplineCurveForm, aClosedCurve: StepData_Logical, aSelfIntersect: StepData_Logical, aKnotMultiplicities: TColStd_HArray1OfInteger, aKnots: TColStd_HArray1OfReal, aKnotSpec: StepGeom_KnotType) -> None: ...
    def KnotMultiplicities(self) -> TColStd_HArray1OfInteger: ...
    def KnotMultiplicitiesValue(self, num: int) -> int: ...
    def KnotSpec(self) -> StepGeom_KnotType: ...
    def Knots(self) -> TColStd_HArray1OfReal: ...
    def KnotsValue(self, num: int) -> float: ...
    def NbKnotMultiplicities(self) -> int: ...
    def NbKnots(self) -> int: ...
    def SetKnotMultiplicities(self, aKnotMultiplicities: TColStd_HArray1OfInteger) -> None: ...
    def SetKnotSpec(self, aKnotSpec: StepGeom_KnotType) -> None: ...
    def SetKnots(self, aKnots: TColStd_HArray1OfReal) -> None: ...

class StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve(StepGeom_BSplineCurve):
    def __init__(self) -> None: ...
    def BSplineCurveWithKnots(self) -> StepGeom_BSplineCurveWithKnots: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aDegree: int, aControlPointsList: StepGeom_HArray1OfCartesianPoint, aCurveForm: StepGeom_BSplineCurveForm, aClosedCurve: StepData_Logical, aSelfIntersect: StepData_Logical, aBSplineCurveWithKnots: StepGeom_BSplineCurveWithKnots, aRationalBSplineCurve: StepGeom_RationalBSplineCurve) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aDegree: int, aControlPointsList: StepGeom_HArray1OfCartesianPoint, aCurveForm: StepGeom_BSplineCurveForm, aClosedCurve: StepData_Logical, aSelfIntersect: StepData_Logical, aKnotMultiplicities: TColStd_HArray1OfInteger, aKnots: TColStd_HArray1OfReal, aKnotSpec: StepGeom_KnotType, aWeightsData: TColStd_HArray1OfReal) -> None: ...
    def KnotMultiplicities(self) -> TColStd_HArray1OfInteger: ...
    def KnotMultiplicitiesValue(self, num: int) -> int: ...
    def KnotSpec(self) -> StepGeom_KnotType: ...
    def Knots(self) -> TColStd_HArray1OfReal: ...
    def KnotsValue(self, num: int) -> float: ...
    def NbKnotMultiplicities(self) -> int: ...
    def NbKnots(self) -> int: ...
    def NbWeightsData(self) -> int: ...
    def RationalBSplineCurve(self) -> StepGeom_RationalBSplineCurve: ...
    def SetBSplineCurveWithKnots(self, aBSplineCurveWithKnots: StepGeom_BSplineCurveWithKnots) -> None: ...
    def SetKnotMultiplicities(self, aKnotMultiplicities: TColStd_HArray1OfInteger) -> None: ...
    def SetKnotSpec(self, aKnotSpec: StepGeom_KnotType) -> None: ...
    def SetKnots(self, aKnots: TColStd_HArray1OfReal) -> None: ...
    def SetRationalBSplineCurve(self, aRationalBSplineCurve: StepGeom_RationalBSplineCurve) -> None: ...
    def SetWeightsData(self, aWeightsData: TColStd_HArray1OfReal) -> None: ...
    def WeightsData(self) -> TColStd_HArray1OfReal: ...
    def WeightsDataValue(self, num: int) -> float: ...

class StepGeom_BSplineSurfaceWithKnots(StepGeom_BSplineSurface):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aUDegree: int, aVDegree: int, aControlPointsList: StepGeom_HArray2OfCartesianPoint, aSurfaceForm: StepGeom_BSplineSurfaceForm, aUClosed: StepData_Logical, aVClosed: StepData_Logical, aSelfIntersect: StepData_Logical, aUMultiplicities: TColStd_HArray1OfInteger, aVMultiplicities: TColStd_HArray1OfInteger, aUKnots: TColStd_HArray1OfReal, aVKnots: TColStd_HArray1OfReal, aKnotSpec: StepGeom_KnotType) -> None: ...
    def KnotSpec(self) -> StepGeom_KnotType: ...
    def NbUKnots(self) -> int: ...
    def NbUMultiplicities(self) -> int: ...
    def NbVKnots(self) -> int: ...
    def NbVMultiplicities(self) -> int: ...
    def SetKnotSpec(self, aKnotSpec: StepGeom_KnotType) -> None: ...
    def SetUKnots(self, aUKnots: TColStd_HArray1OfReal) -> None: ...
    def SetUMultiplicities(self, aUMultiplicities: TColStd_HArray1OfInteger) -> None: ...
    def SetVKnots(self, aVKnots: TColStd_HArray1OfReal) -> None: ...
    def SetVMultiplicities(self, aVMultiplicities: TColStd_HArray1OfInteger) -> None: ...
    def UKnots(self) -> TColStd_HArray1OfReal: ...
    def UKnotsValue(self, num: int) -> float: ...
    def UMultiplicities(self) -> TColStd_HArray1OfInteger: ...
    def UMultiplicitiesValue(self, num: int) -> int: ...
    def VKnots(self) -> TColStd_HArray1OfReal: ...
    def VKnotsValue(self, num: int) -> float: ...
    def VMultiplicities(self) -> TColStd_HArray1OfInteger: ...
    def VMultiplicitiesValue(self, num: int) -> int: ...

class StepGeom_BSplineSurfaceWithKnotsAndRationalBSplineSurface(StepGeom_BSplineSurface):
    def __init__(self) -> None: ...
    def BSplineSurfaceWithKnots(self) -> StepGeom_BSplineSurfaceWithKnots: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aUDegree: int, aVDegree: int, aControlPointsList: StepGeom_HArray2OfCartesianPoint, aSurfaceForm: StepGeom_BSplineSurfaceForm, aUClosed: StepData_Logical, aVClosed: StepData_Logical, aSelfIntersect: StepData_Logical, aBSplineSurfaceWithKnots: StepGeom_BSplineSurfaceWithKnots, aRationalBSplineSurface: StepGeom_RationalBSplineSurface) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aUDegree: int, aVDegree: int, aControlPointsList: StepGeom_HArray2OfCartesianPoint, aSurfaceForm: StepGeom_BSplineSurfaceForm, aUClosed: StepData_Logical, aVClosed: StepData_Logical, aSelfIntersect: StepData_Logical, aUMultiplicities: TColStd_HArray1OfInteger, aVMultiplicities: TColStd_HArray1OfInteger, aUKnots: TColStd_HArray1OfReal, aVKnots: TColStd_HArray1OfReal, aKnotSpec: StepGeom_KnotType, aWeightsData: TColStd_HArray2OfReal) -> None: ...
    def KnotSpec(self) -> StepGeom_KnotType: ...
    def NbUKnots(self) -> int: ...
    def NbUMultiplicities(self) -> int: ...
    def NbVKnots(self) -> int: ...
    def NbVMultiplicities(self) -> int: ...
    def NbWeightsDataI(self) -> int: ...
    def NbWeightsDataJ(self) -> int: ...
    def RationalBSplineSurface(self) -> StepGeom_RationalBSplineSurface: ...
    def SetBSplineSurfaceWithKnots(self, aBSplineSurfaceWithKnots: StepGeom_BSplineSurfaceWithKnots) -> None: ...
    def SetKnotSpec(self, aKnotSpec: StepGeom_KnotType) -> None: ...
    def SetRationalBSplineSurface(self, aRationalBSplineSurface: StepGeom_RationalBSplineSurface) -> None: ...
    def SetUKnots(self, aUKnots: TColStd_HArray1OfReal) -> None: ...
    def SetUMultiplicities(self, aUMultiplicities: TColStd_HArray1OfInteger) -> None: ...
    def SetVKnots(self, aVKnots: TColStd_HArray1OfReal) -> None: ...
    def SetVMultiplicities(self, aVMultiplicities: TColStd_HArray1OfInteger) -> None: ...
    def SetWeightsData(self, aWeightsData: TColStd_HArray2OfReal) -> None: ...
    def UKnots(self) -> TColStd_HArray1OfReal: ...
    def UKnotsValue(self, num: int) -> float: ...
    def UMultiplicities(self) -> TColStd_HArray1OfInteger: ...
    def UMultiplicitiesValue(self, num: int) -> int: ...
    def VKnots(self) -> TColStd_HArray1OfReal: ...
    def VKnotsValue(self, num: int) -> float: ...
    def VMultiplicities(self) -> TColStd_HArray1OfInteger: ...
    def VMultiplicitiesValue(self, num: int) -> int: ...
    def WeightsData(self) -> TColStd_HArray2OfReal: ...
    def WeightsDataValue(self, num1: int, num2: int) -> float: ...

class StepGeom_BezierCurve(StepGeom_BSplineCurve):
    def __init__(self) -> None: ...

class StepGeom_BezierCurveAndRationalBSplineCurve(StepGeom_BSplineCurve):
    def __init__(self) -> None: ...
    def BezierCurve(self) -> StepGeom_BezierCurve: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aDegree: int, aControlPointsList: StepGeom_HArray1OfCartesianPoint, aCurveForm: StepGeom_BSplineCurveForm, aClosedCurve: StepData_Logical, aSelfIntersect: StepData_Logical, aBezierCurve: StepGeom_BezierCurve, aRationalBSplineCurve: StepGeom_RationalBSplineCurve) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aDegree: int, aControlPointsList: StepGeom_HArray1OfCartesianPoint, aCurveForm: StepGeom_BSplineCurveForm, aClosedCurve: StepData_Logical, aSelfIntersect: StepData_Logical, aWeightsData: TColStd_HArray1OfReal) -> None: ...
    def NbWeightsData(self) -> int: ...
    def RationalBSplineCurve(self) -> StepGeom_RationalBSplineCurve: ...
    def SetBezierCurve(self, aBezierCurve: StepGeom_BezierCurve) -> None: ...
    def SetRationalBSplineCurve(self, aRationalBSplineCurve: StepGeom_RationalBSplineCurve) -> None: ...
    def SetWeightsData(self, aWeightsData: TColStd_HArray1OfReal) -> None: ...
    def WeightsData(self) -> TColStd_HArray1OfReal: ...
    def WeightsDataValue(self, num: int) -> float: ...

class StepGeom_BezierSurface(StepGeom_BSplineSurface):
    def __init__(self) -> None: ...

class StepGeom_BezierSurfaceAndRationalBSplineSurface(StepGeom_BSplineSurface):
    def __init__(self) -> None: ...
    def BezierSurface(self) -> StepGeom_BezierSurface: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aUDegree: int, aVDegree: int, aControlPointsList: StepGeom_HArray2OfCartesianPoint, aSurfaceForm: StepGeom_BSplineSurfaceForm, aUClosed: StepData_Logical, aVClosed: StepData_Logical, aSelfIntersect: StepData_Logical, aBezierSurface: StepGeom_BezierSurface, aRationalBSplineSurface: StepGeom_RationalBSplineSurface) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aUDegree: int, aVDegree: int, aControlPointsList: StepGeom_HArray2OfCartesianPoint, aSurfaceForm: StepGeom_BSplineSurfaceForm, aUClosed: StepData_Logical, aVClosed: StepData_Logical, aSelfIntersect: StepData_Logical, aWeightsData: TColStd_HArray2OfReal) -> None: ...
    def NbWeightsDataI(self) -> int: ...
    def NbWeightsDataJ(self) -> int: ...
    def RationalBSplineSurface(self) -> StepGeom_RationalBSplineSurface: ...
    def SetBezierSurface(self, aBezierSurface: StepGeom_BezierSurface) -> None: ...
    def SetRationalBSplineSurface(self, aRationalBSplineSurface: StepGeom_RationalBSplineSurface) -> None: ...
    def SetWeightsData(self, aWeightsData: TColStd_HArray2OfReal) -> None: ...
    def WeightsData(self) -> TColStd_HArray2OfReal: ...
    def WeightsDataValue(self, num1: int, num2: int) -> float: ...

class StepGeom_CompositeCurveOnSurface(StepGeom_CompositeCurve):
    def __init__(self) -> None: ...

class StepGeom_DegenerateToroidalSurface(StepGeom_ToroidalSurface):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement3d, aMajorRadius: float, aMinorRadius: float, aSelectOuter: bool) -> None: ...
    def SelectOuter(self) -> bool: ...
    def SetSelectOuter(self, aSelectOuter: bool) -> None: ...

class StepGeom_QuasiUniformCurve(StepGeom_BSplineCurve):
    def __init__(self) -> None: ...

class StepGeom_QuasiUniformCurveAndRationalBSplineCurve(StepGeom_BSplineCurve):
    def __init__(self) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aDegree: int, aControlPointsList: StepGeom_HArray1OfCartesianPoint, aCurveForm: StepGeom_BSplineCurveForm, aClosedCurve: StepData_Logical, aSelfIntersect: StepData_Logical, aQuasiUniformCurve: StepGeom_QuasiUniformCurve, aRationalBSplineCurve: StepGeom_RationalBSplineCurve) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aDegree: int, aControlPointsList: StepGeom_HArray1OfCartesianPoint, aCurveForm: StepGeom_BSplineCurveForm, aClosedCurve: StepData_Logical, aSelfIntersect: StepData_Logical, aWeightsData: TColStd_HArray1OfReal) -> None: ...
    def NbWeightsData(self) -> int: ...
    def QuasiUniformCurve(self) -> StepGeom_QuasiUniformCurve: ...
    def RationalBSplineCurve(self) -> StepGeom_RationalBSplineCurve: ...
    def SetQuasiUniformCurve(self, aQuasiUniformCurve: StepGeom_QuasiUniformCurve) -> None: ...
    def SetRationalBSplineCurve(self, aRationalBSplineCurve: StepGeom_RationalBSplineCurve) -> None: ...
    def SetWeightsData(self, aWeightsData: TColStd_HArray1OfReal) -> None: ...
    def WeightsData(self) -> TColStd_HArray1OfReal: ...
    def WeightsDataValue(self, num: int) -> float: ...

class StepGeom_QuasiUniformSurface(StepGeom_BSplineSurface):
    def __init__(self) -> None: ...

class StepGeom_QuasiUniformSurfaceAndRationalBSplineSurface(StepGeom_BSplineSurface):
    def __init__(self) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aUDegree: int, aVDegree: int, aControlPointsList: StepGeom_HArray2OfCartesianPoint, aSurfaceForm: StepGeom_BSplineSurfaceForm, aUClosed: StepData_Logical, aVClosed: StepData_Logical, aSelfIntersect: StepData_Logical, aQuasiUniformSurface: StepGeom_QuasiUniformSurface, aRationalBSplineSurface: StepGeom_RationalBSplineSurface) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aUDegree: int, aVDegree: int, aControlPointsList: StepGeom_HArray2OfCartesianPoint, aSurfaceForm: StepGeom_BSplineSurfaceForm, aUClosed: StepData_Logical, aVClosed: StepData_Logical, aSelfIntersect: StepData_Logical, aWeightsData: TColStd_HArray2OfReal) -> None: ...
    def NbWeightsDataI(self) -> int: ...
    def NbWeightsDataJ(self) -> int: ...
    def QuasiUniformSurface(self) -> StepGeom_QuasiUniformSurface: ...
    def RationalBSplineSurface(self) -> StepGeom_RationalBSplineSurface: ...
    def SetQuasiUniformSurface(self, aQuasiUniformSurface: StepGeom_QuasiUniformSurface) -> None: ...
    def SetRationalBSplineSurface(self, aRationalBSplineSurface: StepGeom_RationalBSplineSurface) -> None: ...
    def SetWeightsData(self, aWeightsData: TColStd_HArray2OfReal) -> None: ...
    def WeightsData(self) -> TColStd_HArray2OfReal: ...
    def WeightsDataValue(self, num1: int, num2: int) -> float: ...

class StepGeom_RationalBSplineCurve(StepGeom_BSplineCurve):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aDegree: int, aControlPointsList: StepGeom_HArray1OfCartesianPoint, aCurveForm: StepGeom_BSplineCurveForm, aClosedCurve: StepData_Logical, aSelfIntersect: StepData_Logical, aWeightsData: TColStd_HArray1OfReal) -> None: ...
    def NbWeightsData(self) -> int: ...
    def SetWeightsData(self, aWeightsData: TColStd_HArray1OfReal) -> None: ...
    def WeightsData(self) -> TColStd_HArray1OfReal: ...
    def WeightsDataValue(self, num: int) -> float: ...

class StepGeom_RationalBSplineSurface(StepGeom_BSplineSurface):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aUDegree: int, aVDegree: int, aControlPointsList: StepGeom_HArray2OfCartesianPoint, aSurfaceForm: StepGeom_BSplineSurfaceForm, aUClosed: StepData_Logical, aVClosed: StepData_Logical, aSelfIntersect: StepData_Logical, aWeightsData: TColStd_HArray2OfReal) -> None: ...
    def NbWeightsDataI(self) -> int: ...
    def NbWeightsDataJ(self) -> int: ...
    def SetWeightsData(self, aWeightsData: TColStd_HArray2OfReal) -> None: ...
    def WeightsData(self) -> TColStd_HArray2OfReal: ...
    def WeightsDataValue(self, num1: int, num2: int) -> float: ...

class StepGeom_UniformCurve(StepGeom_BSplineCurve):
    def __init__(self) -> None: ...

class StepGeom_UniformCurveAndRationalBSplineCurve(StepGeom_BSplineCurve):
    def __init__(self) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aDegree: int, aControlPointsList: StepGeom_HArray1OfCartesianPoint, aCurveForm: StepGeom_BSplineCurveForm, aClosedCurve: StepData_Logical, aSelfIntersect: StepData_Logical, aUniformCurve: StepGeom_UniformCurve, aRationalBSplineCurve: StepGeom_RationalBSplineCurve) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aDegree: int, aControlPointsList: StepGeom_HArray1OfCartesianPoint, aCurveForm: StepGeom_BSplineCurveForm, aClosedCurve: StepData_Logical, aSelfIntersect: StepData_Logical, aWeightsData: TColStd_HArray1OfReal) -> None: ...
    def NbWeightsData(self) -> int: ...
    def RationalBSplineCurve(self) -> StepGeom_RationalBSplineCurve: ...
    def SetRationalBSplineCurve(self, aRationalBSplineCurve: StepGeom_RationalBSplineCurve) -> None: ...
    def SetUniformCurve(self, aUniformCurve: StepGeom_UniformCurve) -> None: ...
    def SetWeightsData(self, aWeightsData: TColStd_HArray1OfReal) -> None: ...
    def UniformCurve(self) -> StepGeom_UniformCurve: ...
    def WeightsData(self) -> TColStd_HArray1OfReal: ...
    def WeightsDataValue(self, num: int) -> float: ...

class StepGeom_UniformSurface(StepGeom_BSplineSurface):
    def __init__(self) -> None: ...

class StepGeom_UniformSurfaceAndRationalBSplineSurface(StepGeom_BSplineSurface):
    def __init__(self) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aUDegree: int, aVDegree: int, aControlPointsList: StepGeom_HArray2OfCartesianPoint, aSurfaceForm: StepGeom_BSplineSurfaceForm, aUClosed: StepData_Logical, aVClosed: StepData_Logical, aSelfIntersect: StepData_Logical, aUniformSurface: StepGeom_UniformSurface, aRationalBSplineSurface: StepGeom_RationalBSplineSurface) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aUDegree: int, aVDegree: int, aControlPointsList: StepGeom_HArray2OfCartesianPoint, aSurfaceForm: StepGeom_BSplineSurfaceForm, aUClosed: StepData_Logical, aVClosed: StepData_Logical, aSelfIntersect: StepData_Logical, aWeightsData: TColStd_HArray2OfReal) -> None: ...
    def NbWeightsDataI(self) -> int: ...
    def NbWeightsDataJ(self) -> int: ...
    def RationalBSplineSurface(self) -> StepGeom_RationalBSplineSurface: ...
    def SetRationalBSplineSurface(self, aRationalBSplineSurface: StepGeom_RationalBSplineSurface) -> None: ...
    def SetUniformSurface(self, aUniformSurface: StepGeom_UniformSurface) -> None: ...
    def SetWeightsData(self, aWeightsData: TColStd_HArray2OfReal) -> None: ...
    def UniformSurface(self) -> StepGeom_UniformSurface: ...
    def WeightsData(self) -> TColStd_HArray2OfReal: ...
    def WeightsDataValue(self, num1: int, num2: int) -> float: ...

class StepGeom_BoundaryCurve(StepGeom_CompositeCurveOnSurface):
    def __init__(self) -> None: ...

class StepGeom_OuterBoundaryCurve(StepGeom_BoundaryCurve):
    def __init__(self) -> None: ...

# harray1 classes

class StepGeom_HArray1OfCartesianPoint(StepGeom_Array1OfCartesianPoint, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepGeom_Array1OfCartesianPoint: ...


class StepGeom_HArray1OfPcurveOrSurface(StepGeom_Array1OfPcurveOrSurface, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepGeom_Array1OfPcurveOrSurface: ...


class StepGeom_HArray1OfSurfaceBoundary(StepGeom_Array1OfSurfaceBoundary, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepGeom_Array1OfSurfaceBoundary: ...


class StepGeom_HArray1OfBoundaryCurve(StepGeom_Array1OfBoundaryCurve, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepGeom_Array1OfBoundaryCurve: ...


class StepGeom_HArray1OfCompositeCurveSegment(StepGeom_Array1OfCompositeCurveSegment, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepGeom_Array1OfCompositeCurveSegment: ...


class StepGeom_HArray1OfCurve(StepGeom_Array1OfCurve, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepGeom_Array1OfCurve: ...


class StepGeom_HArray1OfTrimmingSelect(StepGeom_Array1OfTrimmingSelect, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepGeom_Array1OfTrimmingSelect: ...

# harray2 classes

class StepGeom_HArray2OfSurfacePatch(StepGeom_Array2OfSurfacePatch, Standard_Transient):
    @overload
    def __init__(self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int) -> None: ...
    @overload
    def __init__(self, theOther: StepGeom_Array2OfSurfacePatch) -> None: ...
    def Array2(self) -> StepGeom_Array2OfSurfacePatch: ...


class StepGeom_HArray2OfCartesianPoint(StepGeom_Array2OfCartesianPoint, Standard_Transient):
    @overload
    def __init__(self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int) -> None: ...
    @overload
    def __init__(self, theOther: StepGeom_Array2OfCartesianPoint) -> None: ...
    def Array2(self) -> StepGeom_Array2OfCartesianPoint: ...

# hsequence classes

