/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoRetrieval;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TaskRunner;
import us.fatehi.utility.scheduler.TaskRunners;

public final class RetrievalTaskRunner {
    private static final Logger LOGGER = Logger.getLogger(RetrievalTaskRunner.class.getName());
    private final TaskRunner taskRunner;
    private final SchemaInfoLevel infoLevel;
    private final List<TaskDefinition> taskDefinitions;

    public RetrievalTaskRunner(SchemaInfoLevel infoLevel, int maxThreads) {
        this.infoLevel = Objects.requireNonNull(infoLevel, "No info-level provided");
        this.taskRunner = TaskRunners.getTaskRunner(infoLevel.getTag(), maxThreads);
        this.taskDefinitions = new CopyOnWriteArrayList<TaskDefinition>();
    }

    public RetrievalTaskRunner add(SchemaInfoRetrieval retrieval, TaskDefinition.TaskRunnable function, SchemaInfoRetrieval ... additionalRetrievals) throws Exception {
        boolean shouldRun = this.shouldRun(retrieval) && this.shouldRun(additionalRetrievals);
        this.add(retrieval.name(), shouldRun, function);
        return this;
    }

    public RetrievalTaskRunner add(String retrievalName, TaskDefinition.TaskRunnable function, SchemaInfoRetrieval ... additionalRetrievals) throws Exception {
        boolean shouldRun = this.shouldRun(additionalRetrievals);
        this.add(retrievalName, shouldRun, function);
        return this;
    }

    public boolean isStopped() {
        return this.taskRunner.isStopped();
    }

    public void stopAndLogTime() throws ExecutionException {
        ExecutionException exception = null;
        try {
            this.taskRunner.stop();
        }
        catch (ExecutionException e) {
            exception = e;
        }
        LOGGER.log(Level.INFO, this.taskRunner.report());
        if (exception != null) {
            throw exception;
        }
    }

    public void submit() throws Exception {
        try {
            this.taskRunner.run(this.taskDefinitions.toArray(new TaskDefinition[this.taskDefinitions.size()]));
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                throw new ExecutionRuntimeException(cause);
            }
            throw e;
        }
        finally {
            this.taskDefinitions.clear();
        }
    }

    private void add(String retrievalName, boolean shouldRun, TaskDefinition.TaskRunnable function) throws Exception {
        if (this.taskRunner.isStopped()) {
            throw new IllegalStateException("Task runner is stopped");
        }
        if (shouldRun) {
            this.taskDefinitions.add(new TaskDefinition(retrievalName, function));
        } else {
            this.taskDefinitions.add(new TaskDefinition(retrievalName));
        }
    }

    private boolean shouldRun(SchemaInfoRetrieval ... additionalRetrievals) {
        boolean shouldRun = true;
        if (additionalRetrievals != null && additionalRetrievals.length > 0) {
            for (SchemaInfoRetrieval additionalRetrieval : additionalRetrievals) {
                shouldRun = shouldRun && this.infoLevel.is(additionalRetrieval);
            }
        }
        return shouldRun;
    }
}

