/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.scheduler;

import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import us.fatehi.utility.Utility;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TaskInfo;
import us.fatehi.utility.scheduler.TaskRunner;

abstract class AbstractTaskRunner
implements TaskRunner {
    private final String id;
    private final List<TaskInfo> tasks;

    public AbstractTaskRunner(String id) {
        this.id = Utility.requireNotBlank(id, "No id provided");
        this.tasks = new CopyOnWriteArrayList<TaskInfo>();
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public abstract boolean isStopped();

    @Override
    public final Supplier<String> report() {
        return () -> {
            BiFunction<Duration, Duration, Double> calculatePercentage = (duration, totalDuration) -> {
                long totalMillis = totalDuration.toMillis();
                if (totalMillis == 0L) {
                    return 0.0;
                }
                return (double)duration.toMillis() * 100.0 / (double)totalMillis;
            };
            DateTimeFormatter df = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 3, 3, true).toFormatter();
            Duration totalDuration2 = Duration.ofNanos(0L);
            for (TaskInfo task : this.tasks) {
                totalDuration2 = totalDuration2.plus(task.getDuration());
            }
            StringBuilder buffer = new StringBuilder(1024);
            LocalTime totalDurationLocal = LocalTime.ofNanoOfDay(totalDuration2.toNanos());
            buffer.append(String.format("Total time taken for <%s> - %s hours%n", this.id, totalDurationLocal.format(df)));
            for (TaskInfo task : this.tasks) {
                buffer.append(String.format("-%5.1f%% - %s%n", calculatePercentage.apply(task.getDuration(), totalDuration2), task));
            }
            return buffer.toString();
        };
    }

    @Override
    public abstract void run(TaskDefinition ... var1) throws Exception;

    @Override
    public abstract void stop() throws ExecutionException;

    List<TaskInfo> getTasks() {
        return this.tasks;
    }
}

