/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.scheduler;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public class TaskDefinition
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(TaskDefinition.class.getName());
    private final String taskName;
    private final TaskRunnable task;

    public TaskDefinition(String taskName) {
        this.taskName = Utility.toSnakeCase(Utility.requireNotBlank(taskName, "Task name not provided"));
        this.task = () -> LOGGER.log(Level.INFO, new StringFormat("Not running task <%s>", taskName));
    }

    public TaskDefinition(String taskName, TaskRunnable task) {
        Utility.requireNotBlank(taskName, "Task name not provided");
        this.taskName = Utility.toSnakeCase(taskName);
        this.task = Objects.requireNonNull(task, "Task not provided");
    }

    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void run() {
        LOGGER.log(Level.INFO, new StringFormat("Running <%s> on thread <%s>", this.taskName, Thread.currentThread().getName()));
        Exception ex = null;
        try {
            this.task.run();
        }
        catch (Exception e) {
            ex = e;
        }
        if (ex != null) {
            throw new RuntimeException(String.format("Exception running <%s> on thread <%s>: %s", this.taskName, Thread.currentThread().getName(), ex.getMessage()), ex);
        }
    }

    public String toString() {
        return this.taskName;
    }

    @FunctionalInterface
    public static interface TaskRunnable {
        public void run() throws Exception;
    }
}

