'''OpenGL extension OES.extended_matrix_palette

This module customises the behaviour of the 
OpenGL.raw.GLES1.OES.extended_matrix_palette to provide a more 
Python-friendly API

Overview (from the spec)
	
	The OES_matrix_palette extension added the ability to support vertex skinning 
	in OpenGL ES.  One issue with OES_matrix_palette is that the minimum size of 
	the matrix palette is very small.  This leads to applications having to break 
	geometry into smaller primitive sets called via. glDrawElements.  This has an 
	impact on the overall performance of the OpenGL ES implementation.  In general, 
	hardware implementations prefer primitive packets with as many triangles as 
	possible.  The default minimum size defined in OES_matrix_palette is not 
	sufficient to allow this.  The OES_extended_matrix_palette extension increases 
	this minimum from 9 to 32.  
	
	    Another issue is that it is very difficult for ISVs to handle different 
	    size matrix palettes as it affects how they store their geometry 
	    in the database - may require multiple representations which is
	    not really feasible.  So the minimum size is going to be what most ISVs
	    will use.
	
	    By extending the minimum size of the matrix palette, we remove this
	    fragmentation and allow applications to render geometry with minimal
	    number of calls to glDrawElements or glDrawArrays.  The OpenGL ES
	    implementation can support this without requiring any additional hardware
	    by breaking the primitive, plus it gives implementations the flexibility
	    to accelerate with a bigger matrix palette if they choose to do so.
	
	    Additionally, feedback has also been received to increase the number of
	    matrices that are blend per vertex from 3 to 4.  The OES_extended_matrix_palette
	    extension increases the minium number of matrices / vertex to 4.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/extended_matrix_palette.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES1 import _types, _glgets
from OpenGL.raw.GLES1.OES.extended_matrix_palette import *
from OpenGL.raw.GLES1.OES.extended_matrix_palette import _EXTENSION_NAME

def glInitExtendedMatrixPaletteOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION