/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.naming.NamingException;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.CredentialHandler;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.ThreadBindingListener;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.DefaultInstanceManager;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContextValve;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.ErrorPageSupport;
import org.apache.catalina.util.ExtensionValidator;
import org.apache.catalina.util.URLEncoder;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.InstanceManagerBindings;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.descriptor.web.ApplicationParameter;
import org.apache.tomcat.util.descriptor.web.ContextLocalEjb;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.Injectable;
import org.apache.tomcat.util.descriptor.web.InjectionTarget;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.MessageDestination;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.http.Rfc6265CookieProcessor;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;

public class StandardContext
extends ContainerBase
implements Context,
NotificationEmitter {
    private static final Log log = LogFactory.getLog(StandardContext.class);
    protected boolean allowCasualMultipartParsing = false;
    private boolean swallowAbortedUploads = true;
    private String altDDName = null;
    private InstanceManager instanceManager = null;
    private boolean antiResourceLocking = false;
    private String[] applicationListeners = new String[0];
    private final Object applicationListenersLock = new Object();
    private final Set<Object> noPluggabilityListeners = new HashSet<Object>();
    private List<Object> applicationEventListenersList = new CopyOnWriteArrayList<Object>();
    private Object[] applicationLifecycleListenersObjects = new Object[0];
    private Map<ServletContainerInitializer, Set<Class<?>>> initializers = new LinkedHashMap();
    private ApplicationParameter[] applicationParameters = new ApplicationParameter[0];
    private final Object applicationParametersLock = new Object();
    private NotificationBroadcasterSupport broadcaster = null;
    private CharsetMapper charsetMapper = null;
    private String charsetMapperClass = "org.apache.catalina.util.CharsetMapper";
    private URL configFile = null;
    private boolean configured = false;
    private volatile SecurityConstraint[] constraints = new SecurityConstraint[0];
    private final Object constraintsLock = new Object();
    protected ApplicationContext context = null;
    private NoPluggabilityServletContext noPluggabilityServletContext = null;
    private boolean cookies = true;
    private boolean crossContext = false;
    private String encodedPath = null;
    private String path = null;
    private boolean delegate = JreCompat.isGraalAvailable();
    private boolean denyUncoveredHttpMethods;
    private String displayName = null;
    private String defaultContextXml;
    private String defaultWebXml;
    private boolean distributable = false;
    private String docBase = null;
    private final ErrorPageSupport errorPageSupport = new ErrorPageSupport();
    private Map<String, ApplicationFilterConfig> filterConfigs = new HashMap<String, ApplicationFilterConfig>();
    private Map<String, FilterDef> filterDefs = new HashMap<String, FilterDef>();
    private final ContextFilterMaps filterMaps = new ContextFilterMaps();
    private boolean ignoreAnnotations = false;
    private Loader loader = null;
    private final ReadWriteLock loaderLock = new ReentrantReadWriteLock();
    private LoginConfig loginConfig = null;
    protected Manager manager = null;
    private final ReadWriteLock managerLock = new ReentrantReadWriteLock();
    private NamingContextListener namingContextListener = null;
    private NamingResourcesImpl namingResources = null;
    private HashMap<String, MessageDestination> messageDestinations = new HashMap();
    private Map<String, String> mimeMappings = new HashMap<String, String>();
    private final Map<String, String> parameters = new ConcurrentHashMap<String, String>();
    private volatile boolean paused = false;
    private String publicId = null;
    private boolean reloadable = false;
    private boolean unpackWAR = true;
    private boolean copyXML = false;
    private boolean override = false;
    private String originalDocBase = null;
    private boolean privileged = false;
    private boolean replaceWelcomeFiles = false;
    private Map<String, String> roleMappings = new HashMap<String, String>();
    private String[] securityRoles = new String[0];
    private final Object securityRolesLock = new Object();
    private Map<String, String> servletMappings = new HashMap<String, String>();
    private final Object servletMappingsLock = new Object();
    private int sessionTimeout = 30;
    private AtomicLong sequenceNumber = new AtomicLong(0L);
    private boolean swallowOutput = false;
    private long unloadDelay = 2000L;
    private String[] watchedResources = new String[0];
    private final Object watchedResourcesLock = new Object();
    private String[] welcomeFiles = new String[0];
    private final Object welcomeFilesLock = new Object();
    private String[] wrapperLifecycles = new String[0];
    private final Object wrapperLifecyclesLock = new Object();
    private String[] wrapperListeners = new String[0];
    private final Object wrapperListenersLock = new Object();
    private String workDir = null;
    private String wrapperClassName = StandardWrapper.class.getName();
    private Class<?> wrapperClass = null;
    private boolean useNaming = true;
    private String namingContextName = null;
    private WebResourceRoot resources;
    private final ReadWriteLock resourcesLock = new ReentrantReadWriteLock();
    private long startupTime;
    private long startTime;
    private long tldScanTime;
    private String j2EEApplication = "none";
    private String j2EEServer = "none";
    private boolean webXmlValidation = Globals.STRICT_SERVLET_COMPLIANCE;
    private boolean webXmlNamespaceAware = Globals.STRICT_SERVLET_COMPLIANCE;
    private boolean xmlBlockExternal = true;
    private boolean tldValidation = Globals.STRICT_SERVLET_COMPLIANCE;
    private String sessionCookieName;
    private boolean useHttpOnly = true;
    private String sessionCookieDomain;
    private String sessionCookiePath;
    private boolean sessionCookiePathUsesTrailingSlash = false;
    private JarScanner jarScanner = null;
    private boolean clearReferencesRmiTargets = true;
    private boolean clearReferencesStopThreads = false;
    private boolean clearReferencesStopTimerThreads = false;
    private boolean clearReferencesHttpClientKeepAliveThread = true;
    private boolean renewThreadsWhenStoppingContext = true;
    private boolean clearReferencesObjectStreamClassCaches = true;
    private boolean clearReferencesThreadLocals = true;
    private boolean skipMemoryLeakChecksOnJvmShutdown = false;
    private boolean logEffectiveWebXml = false;
    private int effectiveMajorVersion = 3;
    private int effectiveMinorVersion = 0;
    private JspConfigDescriptor jspConfigDescriptor = null;
    private Set<String> resourceOnlyServlets = new HashSet<String>();
    private String webappVersion = "";
    private boolean addWebinfClassesResources = false;
    private boolean fireRequestListenersOnForwards = false;
    private Set<Servlet> createdServlets = new HashSet<Servlet>();
    private boolean preemptiveAuthentication = false;
    private boolean sendRedirectBody = false;
    private boolean jndiExceptionOnFailedWrite = true;
    private Map<String, String> postConstructMethods = new HashMap<String, String>();
    private Map<String, String> preDestroyMethods = new HashMap<String, String>();
    private String containerSciFilter;
    private Boolean failCtxIfServletStartFails;
    protected static final ThreadBindingListener DEFAULT_NAMING_LISTENER = new ThreadBindingListener(){

        @Override
        public void bind() {
        }

        @Override
        public void unbind() {
        }
    };
    protected ThreadBindingListener threadBindingListener = DEFAULT_NAMING_LISTENER;
    private final Object namingToken = new Object();
    private CookieProcessor cookieProcessor;
    private boolean validateClientProvidedNewSessionId = true;
    private boolean mapperContextRootRedirectEnabled = true;
    private boolean mapperDirectoryRedirectEnabled = false;
    private boolean useRelativeRedirects = !Globals.STRICT_SERVLET_COMPLIANCE;
    private boolean dispatchersUseEncodedPaths = true;
    private String requestEncoding = null;
    private String responseEncoding = null;
    private boolean allowMultipleLeadingForwardSlashInPath = false;
    private final AtomicLong inProgressAsyncCount = new AtomicLong(0L);
    private boolean createUploadTargets = false;
    private boolean alwaysAccessSession = Globals.STRICT_SERVLET_COMPLIANCE;
    private boolean contextGetResourceRequiresSlash = Globals.STRICT_SERVLET_COMPLIANCE;
    private boolean dispatcherWrapsSameObject = Globals.STRICT_SERVLET_COMPLIANCE;
    private boolean parallelAnnotationScanning = false;
    private boolean useBloomFilterForArchives = false;
    private MBeanNotificationInfo[] notificationInfo;
    private String server = null;
    private String[] javaVMs = null;

    public StandardContext() {
        this.pipeline.setBasic(new StandardContextValve());
        this.broadcaster = new NotificationBroadcasterSupport();
        if (!Globals.STRICT_SERVLET_COMPLIANCE) {
            this.resourceOnlyServlets.add("jsp");
        }
    }

    @Override
    public void setCreateUploadTargets(boolean bl) {
        this.createUploadTargets = bl;
    }

    @Override
    public boolean getCreateUploadTargets() {
        return this.createUploadTargets;
    }

    @Override
    public void incrementInProgressAsyncCount() {
        this.inProgressAsyncCount.incrementAndGet();
    }

    @Override
    public void decrementInProgressAsyncCount() {
        this.inProgressAsyncCount.decrementAndGet();
    }

    public long getInProgressAsyncCount() {
        return this.inProgressAsyncCount.get();
    }

    @Override
    public void setAllowMultipleLeadingForwardSlashInPath(boolean bl) {
        this.allowMultipleLeadingForwardSlashInPath = bl;
    }

    @Override
    public boolean getAllowMultipleLeadingForwardSlashInPath() {
        return this.allowMultipleLeadingForwardSlashInPath;
    }

    @Override
    public boolean getAlwaysAccessSession() {
        return this.alwaysAccessSession;
    }

    @Override
    public void setAlwaysAccessSession(boolean bl) {
        this.alwaysAccessSession = bl;
    }

    @Override
    public boolean getContextGetResourceRequiresSlash() {
        return this.contextGetResourceRequiresSlash;
    }

    @Override
    public void setContextGetResourceRequiresSlash(boolean bl) {
        this.contextGetResourceRequiresSlash = bl;
    }

    @Override
    public boolean getDispatcherWrapsSameObject() {
        return this.dispatcherWrapsSameObject;
    }

    @Override
    public void setDispatcherWrapsSameObject(boolean bl) {
        this.dispatcherWrapsSameObject = bl;
    }

    @Override
    public String getRequestCharacterEncoding() {
        return this.requestEncoding;
    }

    @Override
    public void setRequestCharacterEncoding(String string) {
        this.requestEncoding = string;
    }

    @Override
    public String getResponseCharacterEncoding() {
        return this.responseEncoding;
    }

    @Override
    public void setResponseCharacterEncoding(String string) {
        this.responseEncoding = string == null ? null : new String(string);
    }

    @Override
    public void setDispatchersUseEncodedPaths(boolean bl) {
        this.dispatchersUseEncodedPaths = bl;
    }

    @Override
    public boolean getDispatchersUseEncodedPaths() {
        return this.dispatchersUseEncodedPaths;
    }

    @Override
    public void setUseRelativeRedirects(boolean bl) {
        this.useRelativeRedirects = bl;
    }

    @Override
    public boolean getUseRelativeRedirects() {
        return this.useRelativeRedirects;
    }

    @Override
    public void setMapperContextRootRedirectEnabled(boolean bl) {
        this.mapperContextRootRedirectEnabled = bl;
    }

    @Override
    public boolean getMapperContextRootRedirectEnabled() {
        return this.mapperContextRootRedirectEnabled;
    }

    @Override
    public void setMapperDirectoryRedirectEnabled(boolean bl) {
        this.mapperDirectoryRedirectEnabled = bl;
    }

    @Override
    public boolean getMapperDirectoryRedirectEnabled() {
        return this.mapperDirectoryRedirectEnabled;
    }

    @Override
    public void setValidateClientProvidedNewSessionId(boolean bl) {
        this.validateClientProvidedNewSessionId = bl;
    }

    @Override
    public boolean getValidateClientProvidedNewSessionId() {
        return this.validateClientProvidedNewSessionId;
    }

    @Override
    public void setCookieProcessor(CookieProcessor cookieProcessor) {
        if (cookieProcessor == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.cookieProcessor.null"));
        }
        this.cookieProcessor = cookieProcessor;
    }

    @Override
    public CookieProcessor getCookieProcessor() {
        return this.cookieProcessor;
    }

    @Override
    public Object getNamingToken() {
        return this.namingToken;
    }

    @Override
    public void setContainerSciFilter(String string) {
        this.containerSciFilter = string;
    }

    @Override
    public String getContainerSciFilter() {
        return this.containerSciFilter;
    }

    @Override
    public boolean getSendRedirectBody() {
        return this.sendRedirectBody;
    }

    @Override
    public void setSendRedirectBody(boolean bl) {
        this.sendRedirectBody = bl;
    }

    @Override
    public boolean getPreemptiveAuthentication() {
        return this.preemptiveAuthentication;
    }

    @Override
    public void setPreemptiveAuthentication(boolean bl) {
        this.preemptiveAuthentication = bl;
    }

    @Override
    public void setFireRequestListenersOnForwards(boolean bl) {
        this.fireRequestListenersOnForwards = bl;
    }

    @Override
    public boolean getFireRequestListenersOnForwards() {
        return this.fireRequestListenersOnForwards;
    }

    @Override
    public void setAddWebinfClassesResources(boolean bl) {
        this.addWebinfClassesResources = bl;
    }

    @Override
    public boolean getAddWebinfClassesResources() {
        return this.addWebinfClassesResources;
    }

    @Override
    public void setWebappVersion(String string) {
        this.webappVersion = null == string ? "" : string;
    }

    @Override
    public String getWebappVersion() {
        return this.webappVersion;
    }

    @Override
    public String getBaseName() {
        return new ContextName(this.path, this.webappVersion).getBaseName();
    }

    @Override
    public String getResourceOnlyServlets() {
        return StringUtils.join(this.resourceOnlyServlets);
    }

    @Override
    public void setResourceOnlyServlets(String string) {
        this.resourceOnlyServlets.clear();
        if (string == null) {
            return;
        }
        for (String string2 : string.split(",")) {
            if ((string2 = string2.trim()).length() <= 0) continue;
            this.resourceOnlyServlets.add(string2);
        }
    }

    @Override
    public boolean isResourceOnlyServlet(String string) {
        return this.resourceOnlyServlets.contains(string);
    }

    @Override
    public int getEffectiveMajorVersion() {
        return this.effectiveMajorVersion;
    }

    @Override
    public void setEffectiveMajorVersion(int n) {
        this.effectiveMajorVersion = n;
    }

    @Override
    public int getEffectiveMinorVersion() {
        return this.effectiveMinorVersion;
    }

    @Override
    public void setEffectiveMinorVersion(int n) {
        this.effectiveMinorVersion = n;
    }

    @Override
    public void setLogEffectiveWebXml(boolean bl) {
        this.logEffectiveWebXml = bl;
    }

    @Override
    public boolean getLogEffectiveWebXml() {
        return this.logEffectiveWebXml;
    }

    @Override
    public Authenticator getAuthenticator() {
        Pipeline pipeline = this.getPipeline();
        if (pipeline != null) {
            Valve valve = pipeline.getBasic();
            if (valve instanceof Authenticator) {
                return (Authenticator)((Object)valve);
            }
            for (Valve valve2 : pipeline.getValves()) {
                if (!(valve2 instanceof Authenticator)) continue;
                return (Authenticator)((Object)valve2);
            }
        }
        return null;
    }

    @Override
    public JarScanner getJarScanner() {
        if (this.jarScanner == null) {
            this.jarScanner = new StandardJarScanner();
        }
        return this.jarScanner;
    }

    @Override
    public void setJarScanner(JarScanner jarScanner) {
        this.jarScanner = jarScanner;
    }

    @Override
    public InstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    @Override
    public void setInstanceManager(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }

    @Override
    public String getEncodedPath() {
        return this.encodedPath;
    }

    @Override
    public void setAllowCasualMultipartParsing(boolean bl) {
        this.allowCasualMultipartParsing = bl;
    }

    @Override
    public boolean getAllowCasualMultipartParsing() {
        return this.allowCasualMultipartParsing;
    }

    @Override
    public void setSwallowAbortedUploads(boolean bl) {
        this.swallowAbortedUploads = bl;
    }

    @Override
    public boolean getSwallowAbortedUploads() {
        return this.swallowAbortedUploads;
    }

    @Override
    public void addServletContainerInitializer(ServletContainerInitializer servletContainerInitializer, Set<Class<?>> set) {
        this.initializers.put(servletContainerInitializer, set);
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean bl) {
        boolean bl2 = this.delegate;
        this.delegate = bl;
        this.support.firePropertyChange("delegate", bl2, this.delegate);
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean bl) {
        this.useNaming = bl;
    }

    @Override
    public Object[] getApplicationEventListeners() {
        return this.applicationEventListenersList.toArray();
    }

    @Override
    public void setApplicationEventListeners(Object[] objectArray) {
        this.applicationEventListenersList.clear();
        if (objectArray != null && objectArray.length > 0) {
            this.applicationEventListenersList.addAll(Arrays.asList(objectArray));
        }
    }

    public void addApplicationEventListener(Object object) {
        this.applicationEventListenersList.add(object);
    }

    @Override
    public Object[] getApplicationLifecycleListeners() {
        return this.applicationLifecycleListenersObjects;
    }

    @Override
    public void setApplicationLifecycleListeners(Object[] objectArray) {
        this.applicationLifecycleListenersObjects = objectArray;
    }

    public void addApplicationLifecycleListener(Object object) {
        int n = this.applicationLifecycleListenersObjects.length;
        Object[] objectArray = Arrays.copyOf(this.applicationLifecycleListenersObjects, n + 1);
        objectArray[n] = object;
        this.applicationLifecycleListenersObjects = objectArray;
    }

    public boolean getAntiResourceLocking() {
        return this.antiResourceLocking;
    }

    public void setAntiResourceLocking(boolean bl) {
        boolean bl2 = this.antiResourceLocking;
        this.antiResourceLocking = bl;
        this.support.firePropertyChange("antiResourceLocking", bl2, this.antiResourceLocking);
    }

    @Override
    public boolean getUseBloomFilterForArchives() {
        return this.useBloomFilterForArchives;
    }

    @Override
    public void setUseBloomFilterForArchives(boolean bl) {
        boolean bl2 = this.useBloomFilterForArchives;
        this.useBloomFilterForArchives = bl;
        this.support.firePropertyChange("useBloomFilterForArchives", bl2, this.useBloomFilterForArchives);
    }

    @Override
    public void setParallelAnnotationScanning(boolean bl) {
        boolean bl2 = this.parallelAnnotationScanning;
        this.parallelAnnotationScanning = bl;
        this.support.firePropertyChange("parallelAnnotationScanning", bl2, this.parallelAnnotationScanning);
    }

    @Override
    public boolean getParallelAnnotationScanning() {
        return this.parallelAnnotationScanning;
    }

    public CharsetMapper getCharsetMapper() {
        if (this.charsetMapper == null) {
            try {
                Class<?> clazz = Class.forName(this.charsetMapperClass);
                this.charsetMapper = (CharsetMapper)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.charsetMapper = new CharsetMapper();
            }
        }
        return this.charsetMapper;
    }

    public void setCharsetMapper(CharsetMapper charsetMapper) {
        CharsetMapper charsetMapper2 = this.charsetMapper;
        this.charsetMapper = charsetMapper;
        if (charsetMapper != null) {
            this.charsetMapperClass = charsetMapper.getClass().getName();
        }
        this.support.firePropertyChange("charsetMapper", charsetMapper2, this.charsetMapper);
    }

    @Override
    public String getCharset(Locale locale) {
        return this.getCharsetMapper().getCharset(locale);
    }

    @Override
    public URL getConfigFile() {
        return this.configFile;
    }

    @Override
    public void setConfigFile(URL uRL) {
        this.configFile = uRL;
    }

    @Override
    public boolean getConfigured() {
        return this.configured;
    }

    @Override
    public void setConfigured(boolean bl) {
        boolean bl2 = this.configured;
        this.configured = bl;
        this.support.firePropertyChange("configured", bl2, this.configured);
    }

    @Override
    public boolean getCookies() {
        return this.cookies;
    }

    @Override
    public void setCookies(boolean bl) {
        boolean bl2 = this.cookies;
        this.cookies = bl;
        this.support.firePropertyChange("cookies", bl2, this.cookies);
    }

    @Override
    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    @Override
    public void setSessionCookieName(String string) {
        String string2 = this.sessionCookieName;
        this.sessionCookieName = string;
        this.support.firePropertyChange("sessionCookieName", string2, string);
    }

    @Override
    public boolean getUseHttpOnly() {
        return this.useHttpOnly;
    }

    @Override
    public void setUseHttpOnly(boolean bl) {
        boolean bl2 = this.useHttpOnly;
        this.useHttpOnly = bl;
        this.support.firePropertyChange("useHttpOnly", bl2, this.useHttpOnly);
    }

    @Override
    public String getSessionCookieDomain() {
        return this.sessionCookieDomain;
    }

    @Override
    public void setSessionCookieDomain(String string) {
        String string2 = this.sessionCookieDomain;
        this.sessionCookieDomain = string;
        this.support.firePropertyChange("sessionCookieDomain", string2, string);
    }

    @Override
    public String getSessionCookiePath() {
        return this.sessionCookiePath;
    }

    @Override
    public void setSessionCookiePath(String string) {
        String string2 = this.sessionCookiePath;
        this.sessionCookiePath = string;
        this.support.firePropertyChange("sessionCookiePath", string2, string);
    }

    @Override
    public boolean getSessionCookiePathUsesTrailingSlash() {
        return this.sessionCookiePathUsesTrailingSlash;
    }

    @Override
    public void setSessionCookiePathUsesTrailingSlash(boolean bl) {
        this.sessionCookiePathUsesTrailingSlash = bl;
    }

    @Override
    public boolean getCrossContext() {
        return this.crossContext;
    }

    @Override
    public void setCrossContext(boolean bl) {
        boolean bl2 = this.crossContext;
        this.crossContext = bl;
        this.support.firePropertyChange("crossContext", bl2, this.crossContext);
    }

    public String getDefaultContextXml() {
        return this.defaultContextXml;
    }

    public void setDefaultContextXml(String string) {
        this.defaultContextXml = string;
    }

    public String getDefaultWebXml() {
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String string) {
        this.defaultWebXml = string;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public void setStartupTime(long l) {
        this.startupTime = l;
    }

    public long getTldScanTime() {
        return this.tldScanTime;
    }

    public void setTldScanTime(long l) {
        this.tldScanTime = l;
    }

    @Override
    public boolean getDenyUncoveredHttpMethods() {
        return this.denyUncoveredHttpMethods;
    }

    @Override
    public void setDenyUncoveredHttpMethods(boolean bl) {
        this.denyUncoveredHttpMethods = bl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getAltDDName() {
        return this.altDDName;
    }

    @Override
    public void setAltDDName(String string) {
        this.altDDName = string;
        if (this.context != null) {
            this.context.setAttribute("org.apache.catalina.deploy.alt_dd", string);
        }
    }

    @Override
    public void setDisplayName(String string) {
        String string2 = this.displayName;
        this.displayName = string;
        this.support.firePropertyChange("displayName", string2, this.displayName);
    }

    @Override
    public boolean getDistributable() {
        return this.distributable;
    }

    @Override
    public void setDistributable(boolean bl) {
        boolean bl2 = this.distributable;
        this.distributable = bl;
        this.support.firePropertyChange("distributable", bl2, this.distributable);
    }

    @Override
    public String getDocBase() {
        return this.docBase;
    }

    @Override
    public void setDocBase(String string) {
        this.docBase = string;
    }

    public String getJ2EEApplication() {
        return this.j2EEApplication;
    }

    public void setJ2EEApplication(String string) {
        this.j2EEApplication = string;
    }

    public String getJ2EEServer() {
        return this.j2EEServer;
    }

    public void setJ2EEServer(String string) {
        this.j2EEServer = string;
    }

    @Override
    public Loader getLoader() {
        Lock lock = this.loaderLock.readLock();
        lock.lock();
        try {
            Loader loader = this.loader;
            return loader;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoader(Loader loader) {
        Lock lock = this.loaderLock.writeLock();
        lock.lock();
        Loader loader2 = null;
        try {
            loader2 = this.loader;
            if (loader2 == loader) {
                return;
            }
            this.loader = loader;
            if (this.getState().isAvailable() && loader2 != null && loader2 instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)loader2)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardContext.setLoader.stop"), (Throwable)lifecycleException);
                }
            }
            if (loader != null) {
                loader.setContext(this);
            }
            if (this.getState().isAvailable() && loader != null && loader instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)loader)).start();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardContext.setLoader.start"), (Throwable)lifecycleException);
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.support.firePropertyChange("loader", loader2, loader);
    }

    @Override
    public Manager getManager() {
        Lock lock = this.managerLock.readLock();
        lock.lock();
        try {
            Manager manager = this.manager;
            return manager;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setManager(Manager manager) {
        Lock lock = this.managerLock.writeLock();
        lock.lock();
        Manager manager2 = null;
        try {
            manager2 = this.manager;
            if (manager2 == manager) {
                return;
            }
            this.manager = manager;
            if (manager2 instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)manager2)).stop();
                    ((Lifecycle)((Object)manager2)).destroy();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardContext.setManager.stop"), (Throwable)lifecycleException);
                }
            }
            if (manager != null) {
                manager.setContext(this);
            }
            if (this.getState().isAvailable() && manager instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)manager)).start();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardContext.setManager.start"), (Throwable)lifecycleException);
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.support.firePropertyChange("manager", manager2, manager);
    }

    @Override
    public boolean getIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    @Override
    public void setIgnoreAnnotations(boolean bl) {
        boolean bl2 = this.ignoreAnnotations;
        this.ignoreAnnotations = bl;
        this.support.firePropertyChange("ignoreAnnotations", bl2, this.ignoreAnnotations);
    }

    @Override
    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    @Override
    public void setLoginConfig(LoginConfig loginConfig) {
        String string;
        if (loginConfig == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.required"));
        }
        String string2 = loginConfig.getLoginPage();
        if (string2 != null && !string2.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.loginConfig.loginWarning", new Object[]{string2}));
                }
                loginConfig.setLoginPage("/" + string2);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.loginPage", new Object[]{string2}));
            }
        }
        if ((string = loginConfig.getErrorPage()) != null && !string.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.loginConfig.errorWarning", new Object[]{string}));
                }
                loginConfig.setErrorPage("/" + string);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.errorPage", new Object[]{string}));
            }
        }
        LoginConfig loginConfig2 = this.loginConfig;
        this.loginConfig = loginConfig;
        this.support.firePropertyChange("loginConfig", loginConfig2, this.loginConfig);
    }

    @Override
    public NamingResourcesImpl getNamingResources() {
        if (this.namingResources == null) {
            this.setNamingResources(new NamingResourcesImpl());
        }
        return this.namingResources;
    }

    @Override
    public void setNamingResources(NamingResourcesImpl namingResourcesImpl) {
        NamingResourcesImpl namingResourcesImpl2 = this.namingResources;
        this.namingResources = namingResourcesImpl;
        if (namingResourcesImpl != null) {
            namingResourcesImpl.setContainer(this);
        }
        this.support.firePropertyChange("namingResources", namingResourcesImpl2, this.namingResources);
        if (this.getState() == LifecycleState.NEW || this.getState() == LifecycleState.INITIALIZING || this.getState() == LifecycleState.INITIALIZED) {
            return;
        }
        if (namingResourcesImpl2 != null) {
            try {
                namingResourcesImpl2.stop();
                namingResourcesImpl2.destroy();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardContext.namingResource.destroy.fail"), (Throwable)lifecycleException);
            }
        }
        if (namingResourcesImpl != null) {
            try {
                namingResourcesImpl.init();
                namingResourcesImpl.start();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardContext.namingResource.init.fail"), (Throwable)lifecycleException);
            }
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String string) {
        boolean bl = false;
        if (string == null || string.equals("/")) {
            bl = true;
            this.path = "";
        } else if (string.isEmpty() || string.startsWith("/")) {
            this.path = string;
        } else {
            bl = true;
            this.path = "/" + string;
        }
        if (this.path.endsWith("/")) {
            bl = true;
            this.path = this.path.substring(0, this.path.length() - 1);
        }
        if (bl) {
            log.warn((Object)sm.getString("standardContext.pathInvalid", new Object[]{string, this.path}));
        }
        this.encodedPath = URLEncoder.DEFAULT.encode(this.path, StandardCharsets.UTF_8);
        if (this.getName() == null) {
            this.setName(this.path);
        }
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public void setPublicId(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting deployment descriptor public ID to '" + string + "'"));
        }
        String string2 = this.publicId;
        this.publicId = string;
        this.support.firePropertyChange("publicId", string2, string);
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public boolean getOverride() {
        return this.override;
    }

    public String getOriginalDocBase() {
        return this.originalDocBase;
    }

    public void setOriginalDocBase(String string) {
        this.originalDocBase = string;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.getPrivileged()) {
            return this.getClass().getClassLoader();
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public boolean getPrivileged() {
        return this.privileged;
    }

    @Override
    public void setPrivileged(boolean bl) {
        boolean bl2 = this.privileged;
        this.privileged = bl;
        this.support.firePropertyChange("privileged", bl2, this.privileged);
    }

    @Override
    public void setReloadable(boolean bl) {
        boolean bl2 = this.reloadable;
        this.reloadable = bl;
        this.support.firePropertyChange("reloadable", bl2, this.reloadable);
    }

    @Override
    public void setOverride(boolean bl) {
        boolean bl2 = this.override;
        this.override = bl;
        this.support.firePropertyChange("override", bl2, this.override);
    }

    public void setReplaceWelcomeFiles(boolean bl) {
        boolean bl2 = this.replaceWelcomeFiles;
        this.replaceWelcomeFiles = bl;
        this.support.firePropertyChange("replaceWelcomeFiles", bl2, this.replaceWelcomeFiles);
    }

    @Override
    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ApplicationContext(this);
            if (this.altDDName != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", this.altDDName);
            }
        }
        return this.context.getFacade();
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public void setSessionTimeout(int n) {
        int n2 = this.sessionTimeout;
        this.sessionTimeout = n == 0 ? -1 : n;
        this.support.firePropertyChange("sessionTimeout", n2, this.sessionTimeout);
    }

    @Override
    public boolean getSwallowOutput() {
        return this.swallowOutput;
    }

    @Override
    public void setSwallowOutput(boolean bl) {
        boolean bl2 = this.swallowOutput;
        this.swallowOutput = bl;
        this.support.firePropertyChange("swallowOutput", bl2, this.swallowOutput);
    }

    public long getUnloadDelay() {
        return this.unloadDelay;
    }

    public void setUnloadDelay(long l) {
        long l2 = this.unloadDelay;
        this.unloadDelay = l;
        this.support.firePropertyChange("unloadDelay", l2, this.unloadDelay);
    }

    public boolean getUnpackWAR() {
        return this.unpackWAR;
    }

    public void setUnpackWAR(boolean bl) {
        this.unpackWAR = bl;
    }

    public boolean getCopyXML() {
        return this.copyXML;
    }

    public void setCopyXML(boolean bl) {
        this.copyXML = bl;
    }

    @Override
    public String getWrapperClass() {
        return this.wrapperClassName;
    }

    @Override
    public void setWrapperClass(String string) {
        this.wrapperClassName = string;
        try {
            this.wrapperClass = Class.forName(string);
            if (!StandardWrapper.class.isAssignableFrom(this.wrapperClass)) {
                throw new IllegalArgumentException(sm.getString("standardContext.invalidWrapperClass", new Object[]{string}));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException.getMessage());
        }
    }

    @Override
    public WebResourceRoot getResources() {
        Lock lock = this.resourcesLock.readLock();
        lock.lock();
        try {
            WebResourceRoot webResourceRoot = this.resources;
            return webResourceRoot;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResources(WebResourceRoot webResourceRoot) {
        Lock lock = this.resourcesLock.writeLock();
        lock.lock();
        WebResourceRoot webResourceRoot2 = null;
        try {
            if (this.getState().isAvailable()) {
                throw new IllegalStateException(sm.getString("standardContext.resourcesStart"));
            }
            webResourceRoot2 = this.resources;
            if (webResourceRoot2 == webResourceRoot) {
                return;
            }
            this.resources = webResourceRoot;
            if (webResourceRoot2 != null) {
                webResourceRoot2.setContext(null);
            }
            if (webResourceRoot != null) {
                webResourceRoot.setContext(this);
            }
            this.support.firePropertyChange("resources", webResourceRoot2, webResourceRoot);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.jspConfigDescriptor;
    }

    @Override
    public void setJspConfigDescriptor(JspConfigDescriptor jspConfigDescriptor) {
        this.jspConfigDescriptor = jspConfigDescriptor;
    }

    @Override
    public ThreadBindingListener getThreadBindingListener() {
        return this.threadBindingListener;
    }

    @Override
    public void setThreadBindingListener(ThreadBindingListener threadBindingListener) {
        this.threadBindingListener = threadBindingListener;
    }

    public boolean getJndiExceptionOnFailedWrite() {
        return this.jndiExceptionOnFailedWrite;
    }

    public void setJndiExceptionOnFailedWrite(boolean bl) {
        this.jndiExceptionOnFailedWrite = bl;
    }

    public String getCharsetMapperClass() {
        return this.charsetMapperClass;
    }

    public void setCharsetMapperClass(String string) {
        String string2 = this.charsetMapperClass;
        this.charsetMapperClass = string;
        this.support.firePropertyChange("charsetMapperClass", string2, this.charsetMapperClass);
    }

    public String getWorkPath() {
        if (this.getWorkDir() == null) {
            return null;
        }
        File file = new File(this.getWorkDir());
        if (!file.isAbsolute()) {
            try {
                file = new File(this.getCatalinaBase().getCanonicalFile(), this.getWorkDir());
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("standardContext.workPath", new Object[]{this.getName()}), (Throwable)iOException);
            }
        }
        return file.getAbsolutePath();
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String string) {
        this.workDir = string;
        if (this.getState().isAvailable()) {
            this.postWorkDirectory();
        }
    }

    public boolean getClearReferencesRmiTargets() {
        return this.clearReferencesRmiTargets;
    }

    public void setClearReferencesRmiTargets(boolean bl) {
        boolean bl2 = this.clearReferencesRmiTargets;
        this.clearReferencesRmiTargets = bl;
        this.support.firePropertyChange("clearReferencesRmiTargets", bl2, this.clearReferencesRmiTargets);
    }

    public boolean getClearReferencesStopThreads() {
        return this.clearReferencesStopThreads;
    }

    public void setClearReferencesStopThreads(boolean bl) {
        boolean bl2 = this.clearReferencesStopThreads;
        this.clearReferencesStopThreads = bl;
        this.support.firePropertyChange("clearReferencesStopThreads", bl2, this.clearReferencesStopThreads);
    }

    public boolean getClearReferencesStopTimerThreads() {
        return this.clearReferencesStopTimerThreads;
    }

    public void setClearReferencesStopTimerThreads(boolean bl) {
        boolean bl2 = this.clearReferencesStopTimerThreads;
        this.clearReferencesStopTimerThreads = bl;
        this.support.firePropertyChange("clearReferencesStopTimerThreads", bl2, this.clearReferencesStopTimerThreads);
    }

    public boolean getClearReferencesHttpClientKeepAliveThread() {
        return this.clearReferencesHttpClientKeepAliveThread;
    }

    public void setClearReferencesHttpClientKeepAliveThread(boolean bl) {
        this.clearReferencesHttpClientKeepAliveThread = bl;
    }

    public boolean getRenewThreadsWhenStoppingContext() {
        return this.renewThreadsWhenStoppingContext;
    }

    public void setRenewThreadsWhenStoppingContext(boolean bl) {
        boolean bl2 = this.renewThreadsWhenStoppingContext;
        this.renewThreadsWhenStoppingContext = bl;
        this.support.firePropertyChange("renewThreadsWhenStoppingContext", bl2, this.renewThreadsWhenStoppingContext);
    }

    public boolean getClearReferencesObjectStreamClassCaches() {
        return this.clearReferencesObjectStreamClassCaches;
    }

    public void setClearReferencesObjectStreamClassCaches(boolean bl) {
        boolean bl2 = this.clearReferencesObjectStreamClassCaches;
        this.clearReferencesObjectStreamClassCaches = bl;
        this.support.firePropertyChange("clearReferencesObjectStreamClassCaches", bl2, this.clearReferencesObjectStreamClassCaches);
    }

    public boolean getClearReferencesThreadLocals() {
        return this.clearReferencesThreadLocals;
    }

    public void setClearReferencesThreadLocals(boolean bl) {
        boolean bl2 = this.clearReferencesThreadLocals;
        this.clearReferencesThreadLocals = bl;
        this.support.firePropertyChange("clearReferencesThreadLocals", bl2, this.clearReferencesThreadLocals);
    }

    public boolean getSkipMemoryLeakChecksOnJvmShutdown() {
        return this.skipMemoryLeakChecksOnJvmShutdown;
    }

    public void setSkipMemoryLeakChecksOnJvmShutdown(boolean bl) {
        this.skipMemoryLeakChecksOnJvmShutdown = bl;
    }

    public Boolean getFailCtxIfServletStartFails() {
        return this.failCtxIfServletStartFails;
    }

    public void setFailCtxIfServletStartFails(Boolean bl) {
        Boolean bl2 = this.failCtxIfServletStartFails;
        this.failCtxIfServletStartFails = bl;
        this.support.firePropertyChange("failCtxIfServletStartFails", bl2, bl);
    }

    protected boolean getComputedFailCtxIfServletStartFails() {
        if (this.failCtxIfServletStartFails != null) {
            return this.failCtxIfServletStartFails;
        }
        if (this.getParent() instanceof StandardHost) {
            return ((StandardHost)this.getParent()).isFailCtxIfServletStartFails();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationListener(String string) {
        Object object = this.applicationListenersLock;
        synchronized (object) {
            String[] stringArray = new String[this.applicationListeners.length + 1];
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (string.equals(this.applicationListeners[i])) {
                    log.info((Object)sm.getString("standardContext.duplicateListener", new Object[]{string}));
                    return;
                }
                stringArray[i] = this.applicationListeners[i];
            }
            stringArray[this.applicationListeners.length] = string;
            this.applicationListeners = stringArray;
        }
        this.fireContainerEvent("addApplicationListener", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationParameter(ApplicationParameter applicationParameter) {
        Object object = this.applicationParametersLock;
        synchronized (object) {
            String string = applicationParameter.getName();
            for (ApplicationParameter applicationParameter2 : this.applicationParameters) {
                if (!string.equals(applicationParameter2.getName()) || applicationParameter2.getOverride()) continue;
                return;
            }
            ApplicationParameter[] applicationParameterArray = Arrays.copyOf(this.applicationParameters, this.applicationParameters.length + 1);
            applicationParameterArray[this.applicationParameters.length] = applicationParameter;
            this.applicationParameters = applicationParameterArray;
        }
        this.fireContainerEvent("addApplicationParameter", applicationParameter);
    }

    @Override
    public void addChild(Container container) {
        Wrapper wrapper = null;
        if (!(container instanceof Wrapper)) {
            throw new IllegalArgumentException(sm.getString("standardContext.notWrapper"));
        }
        boolean bl = "jsp".equals(container.getName());
        if (bl && (wrapper = (Wrapper)this.findChild("jsp")) != null) {
            this.removeChild(wrapper);
        }
        super.addChild(container);
        if (bl && wrapper != null) {
            String[] stringArray = wrapper.findMappings();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                this.addServletMappingDecoded(stringArray[i], container.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConstraint(SecurityConstraint securityConstraint) {
        SecurityCollection[] securityCollectionArray;
        for (SecurityCollection securityCollection : securityCollectionArray = securityConstraint.findCollections()) {
            String[] stringArray = securityCollection.findPatterns();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.adjustURLPattern(stringArray[i]);
                if (this.validateURLPattern(stringArray[i])) continue;
                throw new IllegalArgumentException(sm.getString("standardContext.securityConstraint.pattern", new Object[]{stringArray[i]}));
            }
            if (securityCollection.findMethods().length <= 0 || securityCollection.findOmittedMethods().length <= 0) continue;
            throw new IllegalArgumentException(sm.getString("standardContext.securityConstraint.mixHttpMethod"));
        }
        Object object = this.constraintsLock;
        synchronized (object) {
            SecurityConstraint[] securityConstraintArray = Arrays.copyOf(this.constraints, this.constraints.length + 1);
            securityConstraintArray[this.constraints.length] = securityConstraint;
            this.constraints = securityConstraintArray;
        }
    }

    @Override
    public void addErrorPage(ErrorPage errorPage) {
        if (errorPage == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.errorPage.required"));
        }
        String string = errorPage.getLocation();
        if (string != null && !string.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.errorPage.warning", new Object[]{string}));
                }
                errorPage.setLocation("/" + string);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.errorPage.error", new Object[]{string}));
            }
        }
        this.errorPageSupport.add(errorPage);
        this.fireContainerEvent("addErrorPage", errorPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilterDef(FilterDef filterDef) {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            this.filterDefs.put(filterDef.getFilterName(), filterDef);
        }
        this.fireContainerEvent("addFilterDef", filterDef);
    }

    @Override
    public void addFilterMap(FilterMap filterMap) {
        this.validateFilterMap(filterMap);
        this.filterMaps.add(filterMap);
        this.fireContainerEvent("addFilterMap", filterMap);
    }

    @Override
    public void addFilterMapBefore(FilterMap filterMap) {
        this.validateFilterMap(filterMap);
        this.filterMaps.addBefore(filterMap);
        this.fireContainerEvent("addFilterMap", filterMap);
    }

    private void validateFilterMap(FilterMap filterMap) {
        String string = filterMap.getFilterName();
        String[] stringArray = filterMap.getServletNames();
        String[] stringArray2 = filterMap.getURLPatterns();
        if (this.findFilterDef(string) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.name", new Object[]{string}));
        }
        if (!filterMap.getMatchAllServletNames() && !filterMap.getMatchAllUrlPatterns() && stringArray.length == 0 && stringArray2.length == 0) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.either"));
        }
        for (String string2 : stringArray2) {
            if (this.validateURLPattern(string2)) continue;
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.pattern", new Object[]{string2}));
        }
    }

    @Override
    public void addLocaleEncodingMappingParameter(String string, String string2) {
        this.getCharsetMapper().addCharsetMappingFromDeploymentDescriptor(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDestination(MessageDestination messageDestination) {
        HashMap<String, MessageDestination> hashMap = this.messageDestinations;
        synchronized (hashMap) {
            this.messageDestinations.put(messageDestination.getName(), messageDestination);
        }
        this.fireContainerEvent("addMessageDestination", messageDestination.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMimeMapping(String string, String string2) {
        Map<String, String> map = this.mimeMappings;
        synchronized (map) {
            this.mimeMappings.put(string.toLowerCase(Locale.ENGLISH), string2);
        }
        this.fireContainerEvent("addMimeMapping", string);
    }

    @Override
    public void addParameter(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.required"));
        }
        String string3 = this.parameters.putIfAbsent(string, string2);
        if (string3 != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.duplicate", new Object[]{string}));
        }
        this.fireContainerEvent("addParameter", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoleMapping(String string, String string2) {
        Map<String, String> map = this.roleMappings;
        synchronized (map) {
            this.roleMappings.put(string, string2);
        }
        this.fireContainerEvent("addRoleMapping", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSecurityRole(String string) {
        Object object = this.securityRolesLock;
        synchronized (object) {
            String[] stringArray = Arrays.copyOf(this.securityRoles, this.securityRoles.length + 1);
            stringArray[this.securityRoles.length] = string;
            this.securityRoles = stringArray;
        }
        this.fireContainerEvent("addSecurityRole", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServletMappingDecoded(String string, String string2, boolean bl) {
        if (this.findChild(string2) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.name", new Object[]{string2}));
        }
        String string3 = this.adjustURLPattern(string);
        if (!this.validateURLPattern(string3)) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.pattern", new Object[]{string3}));
        }
        Object object = this.servletMappingsLock;
        synchronized (object) {
            String string4 = this.servletMappings.get(string3);
            if (string4 != null) {
                Wrapper wrapper = (Wrapper)this.findChild(string4);
                wrapper.removeMapping(string3);
            }
            this.servletMappings.put(string3, string2);
        }
        object = (Wrapper)this.findChild(string2);
        object.addMapping(string3);
        this.fireContainerEvent("addServletMapping", string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWatchedResource(String string) {
        Object object = this.watchedResourcesLock;
        synchronized (object) {
            String[] stringArray = Arrays.copyOf(this.watchedResources, this.watchedResources.length + 1);
            stringArray[this.watchedResources.length] = string;
            this.watchedResources = stringArray;
        }
        this.fireContainerEvent("addWatchedResource", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWelcomeFile(String string) {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            if (this.replaceWelcomeFiles) {
                this.fireContainerEvent("clearWelcomeFiles", null);
                this.welcomeFiles = new String[0];
                this.setReplaceWelcomeFiles(false);
            }
            String[] stringArray = Arrays.copyOf(this.welcomeFiles, this.welcomeFiles.length + 1);
            stringArray[this.welcomeFiles.length] = string;
            this.welcomeFiles = stringArray;
        }
        if (this.getState().equals((Object)LifecycleState.STARTED)) {
            this.fireContainerEvent("addWelcomeFile", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWrapperLifecycle(String string) {
        Object object = this.wrapperLifecyclesLock;
        synchronized (object) {
            String[] stringArray = Arrays.copyOf(this.wrapperLifecycles, this.wrapperLifecycles.length + 1);
            stringArray[this.wrapperLifecycles.length] = string;
            this.wrapperLifecycles = stringArray;
        }
        this.fireContainerEvent("addWrapperLifecycle", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWrapperListener(String string) {
        Object object = this.wrapperListenersLock;
        synchronized (object) {
            String[] stringArray = Arrays.copyOf(this.wrapperListeners, this.wrapperListeners.length + 1);
            stringArray[this.wrapperListeners.length] = string;
            this.wrapperListeners = stringArray;
        }
        this.fireContainerEvent("addWrapperListener", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Wrapper createWrapper() {
        Object object;
        Class<?> clazz;
        Wrapper wrapper = null;
        if (this.wrapperClass != null) {
            try {
                wrapper = (Wrapper)this.wrapperClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("standardContext.createWrapper.error"), throwable);
                return null;
            }
        } else {
            wrapper = new StandardWrapper();
        }
        Object object2 = this.wrapperLifecyclesLock;
        synchronized (object2) {
            for (String string : this.wrapperLifecycles) {
                try {
                    clazz = Class.forName(string);
                    object = (LifecycleListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    wrapper.addLifecycleListener((LifecycleListener)object);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.error((Object)sm.getString("standardContext.createWrapper.listenerError"), throwable);
                    return null;
                }
            }
        }
        object2 = this.wrapperListenersLock;
        synchronized (object2) {
            for (String string : this.wrapperListeners) {
                try {
                    clazz = Class.forName(string);
                    object = (ContainerListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    wrapper.addContainerListener((ContainerListener)object);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.error((Object)sm.getString("standardContext.createWrapper.containerListenerError"), throwable);
                    return null;
                }
            }
        }
        return wrapper;
    }

    @Override
    public String[] findApplicationListeners() {
        return this.applicationListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationParameter[] findApplicationParameters() {
        Object object = this.applicationParametersLock;
        synchronized (object) {
            return this.applicationParameters;
        }
    }

    @Override
    public SecurityConstraint[] findConstraints() {
        return this.constraints;
    }

    @Override
    public ErrorPage findErrorPage(int n) {
        return this.errorPageSupport.find(n);
    }

    @Override
    public ErrorPage findErrorPage(Throwable throwable) {
        return this.errorPageSupport.find(throwable);
    }

    @Override
    public ErrorPage[] findErrorPages() {
        return this.errorPageSupport.findAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterDef findFilterDef(String string) {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            return this.filterDefs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterDef[] findFilterDefs() {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            FilterDef[] filterDefArray = new FilterDef[this.filterDefs.size()];
            return this.filterDefs.values().toArray(filterDefArray);
        }
    }

    @Override
    public FilterMap[] findFilterMaps() {
        return this.filterMaps.asArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination findMessageDestination(String string) {
        HashMap<String, MessageDestination> hashMap = this.messageDestinations;
        synchronized (hashMap) {
            return this.messageDestinations.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination[] findMessageDestinations() {
        HashMap<String, MessageDestination> hashMap = this.messageDestinations;
        synchronized (hashMap) {
            MessageDestination[] messageDestinationArray = new MessageDestination[this.messageDestinations.size()];
            return this.messageDestinations.values().toArray(messageDestinationArray);
        }
    }

    @Override
    public String findMimeMapping(String string) {
        return this.mimeMappings.get(string.toLowerCase(Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findMimeMappings() {
        Map<String, String> map = this.mimeMappings;
        synchronized (map) {
            String[] stringArray = new String[this.mimeMappings.size()];
            return this.mimeMappings.keySet().toArray(stringArray);
        }
    }

    @Override
    public String findParameter(String string) {
        return this.parameters.get(string);
    }

    @Override
    public String[] findParameters() {
        return this.parameters.keySet().toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findRoleMapping(String string) {
        String string2 = null;
        Map<String, String> map = this.roleMappings;
        synchronized (map) {
            string2 = this.roleMappings.get(string);
        }
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findSecurityRole(String string) {
        Object object = this.securityRolesLock;
        synchronized (object) {
            for (String string2 : this.securityRoles) {
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findSecurityRoles() {
        Object object = this.securityRolesLock;
        synchronized (object) {
            return this.securityRoles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findServletMapping(String string) {
        Object object = this.servletMappingsLock;
        synchronized (object) {
            return this.servletMappings.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findServletMappings() {
        Object object = this.servletMappingsLock;
        synchronized (object) {
            String[] stringArray = new String[this.servletMappings.size()];
            return this.servletMappings.keySet().toArray(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findWelcomeFile(String string) {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            for (String string2 : this.welcomeFiles) {
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findWatchedResources() {
        Object object = this.watchedResourcesLock;
        synchronized (object) {
            return this.watchedResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findWelcomeFiles() {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            return this.welcomeFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findWrapperLifecycles() {
        Object object = this.wrapperLifecyclesLock;
        synchronized (object) {
            return this.wrapperLifecycles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findWrapperListeners() {
        Object object = this.wrapperListenersLock;
        synchronized (object) {
            return this.wrapperListeners;
        }
    }

    @Override
    public synchronized void reload() {
        if (!this.getState().isAvailable()) {
            throw new IllegalStateException(sm.getString("standardContext.notStarted", new Object[]{this.getName()}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardContext.reloadingStarted", new Object[]{this.getName()}));
        }
        this.setPaused(true);
        try {
            this.stop();
        }
        catch (LifecycleException lifecycleException) {
            log.error((Object)sm.getString("standardContext.stoppingContext", new Object[]{this.getName()}), (Throwable)lifecycleException);
        }
        try {
            this.start();
        }
        catch (LifecycleException lifecycleException) {
            log.error((Object)sm.getString("standardContext.startingContext", new Object[]{this.getName()}), (Throwable)lifecycleException);
        }
        this.setPaused(false);
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardContext.reloadingCompleted", new Object[]{this.getName()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationListener(String string) {
        Object object = this.applicationListenersLock;
        synchronized (object) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.applicationListeners.length; ++n) {
                if (!this.applicationListeners[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            n = 0;
            String[] stringArray = new String[this.applicationListeners.length - 1];
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.applicationListeners[i];
            }
            this.applicationListeners = stringArray;
        }
        this.fireContainerEvent("removeApplicationListener", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationParameter(String string) {
        Object object = this.applicationParametersLock;
        synchronized (object) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.applicationParameters.length; ++n) {
                if (!string.equals(this.applicationParameters[n].getName())) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            n = 0;
            ApplicationParameter[] applicationParameterArray = new ApplicationParameter[this.applicationParameters.length - 1];
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (i == n2) continue;
                applicationParameterArray[n++] = this.applicationParameters[i];
            }
            this.applicationParameters = applicationParameterArray;
        }
        this.fireContainerEvent("removeApplicationParameter", string);
    }

    @Override
    public void removeChild(Container container) {
        if (!(container instanceof Wrapper)) {
            throw new IllegalArgumentException(sm.getString("standardContext.notWrapper"));
        }
        super.removeChild(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConstraint(SecurityConstraint securityConstraint) {
        Object object = this.constraintsLock;
        synchronized (object) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.constraints.length; ++n) {
                if (!this.constraints[n].equals(securityConstraint)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            n = 0;
            SecurityConstraint[] securityConstraintArray = new SecurityConstraint[this.constraints.length - 1];
            for (int i = 0; i < this.constraints.length; ++i) {
                if (i == n2) continue;
                securityConstraintArray[n++] = this.constraints[i];
            }
            this.constraints = securityConstraintArray;
        }
        this.fireContainerEvent("removeConstraint", securityConstraint);
    }

    @Override
    public void removeErrorPage(ErrorPage errorPage) {
        this.errorPageSupport.remove(errorPage);
        this.fireContainerEvent("removeErrorPage", errorPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilterDef(FilterDef filterDef) {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            this.filterDefs.remove(filterDef.getFilterName());
        }
        this.fireContainerEvent("removeFilterDef", filterDef);
    }

    @Override
    public void removeFilterMap(FilterMap filterMap) {
        this.filterMaps.remove(filterMap);
        this.fireContainerEvent("removeFilterMap", filterMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDestination(String string) {
        HashMap<String, MessageDestination> hashMap = this.messageDestinations;
        synchronized (hashMap) {
            this.messageDestinations.remove(string);
        }
        this.fireContainerEvent("removeMessageDestination", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMimeMapping(String string) {
        Map<String, String> map = this.mimeMappings;
        synchronized (map) {
            this.mimeMappings.remove(string);
        }
        this.fireContainerEvent("removeMimeMapping", string);
    }

    @Override
    public void removeParameter(String string) {
        this.parameters.remove(string);
        this.fireContainerEvent("removeParameter", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoleMapping(String string) {
        Map<String, String> map = this.roleMappings;
        synchronized (map) {
            this.roleMappings.remove(string);
        }
        this.fireContainerEvent("removeRoleMapping", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSecurityRole(String string) {
        Object object = this.securityRolesLock;
        synchronized (object) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.securityRoles.length; ++n) {
                if (!string.equals(this.securityRoles[n])) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            n = 0;
            String[] stringArray = new String[this.securityRoles.length - 1];
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.securityRoles[i];
            }
            this.securityRoles = stringArray;
        }
        this.fireContainerEvent("removeSecurityRole", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServletMapping(String string) {
        String string2 = null;
        Object object = this.servletMappingsLock;
        synchronized (object) {
            string2 = this.servletMappings.remove(string);
        }
        object = (Wrapper)this.findChild(string2);
        if (object != null) {
            object.removeMapping(string);
        }
        this.fireContainerEvent("removeServletMapping", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWatchedResource(String string) {
        Object object = this.watchedResourcesLock;
        synchronized (object) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.watchedResources.length; ++n) {
                if (!this.watchedResources[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            n = 0;
            String[] stringArray = new String[this.watchedResources.length - 1];
            for (int i = 0; i < this.watchedResources.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.watchedResources[i];
            }
            this.watchedResources = stringArray;
        }
        this.fireContainerEvent("removeWatchedResource", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWelcomeFile(String string) {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.welcomeFiles.length; ++n) {
                if (!this.welcomeFiles[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            n = 0;
            String[] stringArray = new String[this.welcomeFiles.length - 1];
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.welcomeFiles[i];
            }
            this.welcomeFiles = stringArray;
        }
        if (this.getState().equals((Object)LifecycleState.STARTED)) {
            this.fireContainerEvent("removeWelcomeFile", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWrapperLifecycle(String string) {
        Object object = this.wrapperLifecyclesLock;
        synchronized (object) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.wrapperLifecycles.length; ++n) {
                if (!this.wrapperLifecycles[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            n = 0;
            String[] stringArray = new String[this.wrapperLifecycles.length - 1];
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.wrapperLifecycles[i];
            }
            this.wrapperLifecycles = stringArray;
        }
        this.fireContainerEvent("removeWrapperLifecycle", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWrapperListener(String string) {
        Object object = this.wrapperListenersLock;
        synchronized (object) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.wrapperListeners.length; ++n) {
                if (!this.wrapperListeners[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            n = 0;
            String[] stringArray = new String[this.wrapperListeners.length - 1];
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.wrapperListeners[i];
            }
            this.wrapperListeners = stringArray;
        }
        this.fireContainerEvent("removeWrapperListener", string);
    }

    public long getProcessingTime() {
        long l = 0L;
        Container[] containerArray = this.findChildren();
        if (containerArray != null) {
            for (Container container : containerArray) {
                l += ((StandardWrapper)container).getProcessingTime();
            }
        }
        return l;
    }

    public long getMaxTime() {
        long l = 0L;
        Container[] containerArray = this.findChildren();
        if (containerArray != null) {
            for (Container container : containerArray) {
                long l2 = ((StandardWrapper)container).getMaxTime();
                if (l2 <= l) continue;
                l = l2;
            }
        }
        return l;
    }

    public long getMinTime() {
        long l = -1L;
        Container[] containerArray = this.findChildren();
        if (containerArray != null) {
            for (Container container : containerArray) {
                long l2 = ((StandardWrapper)container).getMinTime();
                if (l >= 0L && l2 >= l) continue;
                l = l2;
            }
        }
        return l;
    }

    public int getRequestCount() {
        int n = 0;
        Container[] containerArray = this.findChildren();
        if (containerArray != null) {
            for (Container container : containerArray) {
                n += ((StandardWrapper)container).getRequestCount();
            }
        }
        return n;
    }

    public int getErrorCount() {
        int n = 0;
        Container[] containerArray = this.findChildren();
        if (containerArray != null) {
            for (Container container : containerArray) {
                n += ((StandardWrapper)container).getErrorCount();
            }
        }
        return n;
    }

    @Override
    public String getRealPath(String string) {
        if ("".equals(string)) {
            string = "/";
        }
        if (this.resources != null) {
            try {
                WebResource webResource = this.resources.getResource(string);
                String string2 = webResource.getCanonicalPath();
                if (string2 == null) {
                    return null;
                }
                if ((webResource.isDirectory() && !string2.endsWith(File.separator) || !webResource.exists()) && string.endsWith("/")) {
                    return string2 + File.separatorChar;
                }
                return string2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public void dynamicServletCreated(Servlet servlet) {
        this.createdServlets.add(servlet);
    }

    public boolean wasCreatedDynamicServlet(Servlet servlet) {
        return this.createdServlets.contains(servlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStart() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Starting filters");
        }
        boolean bl = true;
        Map<String, ApplicationFilterConfig> map = this.filterConfigs;
        synchronized (map) {
            this.filterConfigs.clear();
            for (Map.Entry<String, FilterDef> entry : this.filterDefs.entrySet()) {
                Serializable serializable;
                String string = entry.getKey();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(" Starting filter '" + string + "'"));
                }
                try {
                    serializable = new ApplicationFilterConfig(this, entry.getValue());
                    this.filterConfigs.put(string, (ApplicationFilterConfig)serializable);
                }
                catch (Throwable throwable) {
                    serializable = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                    ExceptionUtils.handleThrowable((Throwable)serializable);
                    this.getLogger().error((Object)sm.getString("standardContext.filterStart", new Object[]{string}), serializable);
                    bl = false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStop() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Stopping filters");
        }
        Map<String, ApplicationFilterConfig> map = this.filterConfigs;
        synchronized (map) {
            for (Map.Entry<String, ApplicationFilterConfig> entry : this.filterConfigs.entrySet()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(" Stopping filter '" + entry.getKey() + "'"));
                }
                ApplicationFilterConfig applicationFilterConfig = entry.getValue();
                applicationFilterConfig.release();
            }
            this.filterConfigs.clear();
        }
        return true;
    }

    public FilterConfig findFilterConfig(String string) {
        return this.filterConfigs.get(string);
    }

    public boolean listenerStart() {
        ArrayList<Object> arrayList;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring application event listeners");
        }
        String[] stringArray = this.findApplicationListeners();
        Object[] objectArray = new Object[stringArray.length];
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(" Configuring event listener class '" + stringArray[i] + "'"));
            }
            try {
                arrayList = stringArray[i];
                objectArray[i] = this.getInstanceManager().newInstance(arrayList);
                continue;
            }
            catch (Throwable throwable) {
                arrayList = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable(arrayList);
                this.getLogger().error((Object)sm.getString("standardContext.applicationListener", new Object[]{stringArray[i]}), arrayList);
                bl = false;
            }
        }
        if (!bl) {
            this.getLogger().error((Object)sm.getString("standardContext.applicationSkipped"));
            return false;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList = new ArrayList<Object>();
        for (Object objectArray2 : objectArray) {
            if (objectArray2 instanceof ServletContextAttributeListener || objectArray2 instanceof ServletRequestAttributeListener || objectArray2 instanceof ServletRequestListener || objectArray2 instanceof HttpSessionIdListener || objectArray2 instanceof HttpSessionAttributeListener) {
                arrayList2.add(objectArray2);
            }
            if (!(objectArray2 instanceof ServletContextListener) && !(objectArray2 instanceof HttpSessionListener)) continue;
            arrayList.add(objectArray2);
        }
        arrayList2.addAll(Arrays.asList(this.getApplicationEventListeners()));
        this.setApplicationEventListeners(arrayList2.toArray());
        for (Object object : this.getApplicationLifecycleListeners()) {
            arrayList.add(object);
            if (!(object instanceof ServletContextListener)) continue;
            this.noPluggabilityListeners.add(object);
        }
        this.setApplicationLifecycleListeners(arrayList.toArray());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Sending application start events");
        }
        this.getServletContext();
        this.context.setNewServletContextListenerAllowed(false);
        Object[] objectArray3 = this.getApplicationLifecycleListeners();
        if (objectArray3 == null || objectArray3.length == 0) {
            return bl;
        }
        ServletContextEvent servletContextEvent = new ServletContextEvent(this.getServletContext());
        ServletContextEvent servletContextEvent2 = null;
        if (this.noPluggabilityListeners.size() > 0) {
            this.noPluggabilityServletContext = new NoPluggabilityServletContext(this.getServletContext());
            servletContextEvent2 = new ServletContextEvent((ServletContext)this.noPluggabilityServletContext);
        }
        for (Object object : objectArray3) {
            if (!(object instanceof ServletContextListener)) continue;
            ServletContextListener servletContextListener = (ServletContextListener)object;
            try {
                this.fireContainerEvent("beforeContextInitialized", servletContextListener);
                if (this.noPluggabilityListeners.contains(servletContextListener)) {
                    servletContextListener.contextInitialized(servletContextEvent2);
                } else {
                    servletContextListener.contextInitialized(servletContextEvent);
                }
                this.fireContainerEvent("afterContextInitialized", servletContextListener);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.fireContainerEvent("afterContextInitialized", servletContextListener);
                this.getLogger().error((Object)sm.getString("standardContext.listenerStart", new Object[]{object.getClass().getName()}), throwable);
                bl = false;
            }
        }
        return bl;
    }

    public boolean listenerStop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending application stop events");
        }
        boolean bl = true;
        Object[] objectArray = this.getApplicationLifecycleListeners();
        if (objectArray != null && objectArray.length > 0) {
            ServletContextEvent servletContextEvent = new ServletContextEvent(this.getServletContext());
            ServletContextEvent servletContextEvent2 = null;
            if (this.noPluggabilityServletContext != null) {
                servletContextEvent2 = new ServletContextEvent((ServletContext)this.noPluggabilityServletContext);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                int n = objectArray.length - 1 - i;
                if (objectArray[n] == null) continue;
                if (objectArray[n] instanceof ServletContextListener) {
                    object = (ServletContextListener)objectArray[n];
                    try {
                        this.fireContainerEvent("beforeContextDestroyed", object);
                        if (this.noPluggabilityListeners.contains(object)) {
                            object.contextDestroyed(servletContextEvent2);
                        } else {
                            object.contextDestroyed(servletContextEvent);
                        }
                        this.fireContainerEvent("afterContextDestroyed", object);
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        this.fireContainerEvent("afterContextDestroyed", object);
                        this.getLogger().error((Object)sm.getString("standardContext.listenerStop", new Object[]{objectArray[n].getClass().getName()}), throwable);
                        bl = false;
                    }
                }
                try {
                    if (this.getInstanceManager() == null) continue;
                    this.getInstanceManager().destroyInstance(objectArray[n]);
                    continue;
                }
                catch (Throwable throwable) {
                    object = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                    ExceptionUtils.handleThrowable((Throwable)object);
                    this.getLogger().error((Object)sm.getString("standardContext.listenerStop", new Object[]{objectArray[n].getClass().getName()}), (Throwable)object);
                    bl = false;
                }
            }
        }
        if ((objectArray = this.getApplicationEventListeners()) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                int n = objectArray.length - 1 - i;
                if (objectArray[n] == null) continue;
                try {
                    if (this.getInstanceManager() == null) continue;
                    this.getInstanceManager().destroyInstance(objectArray[n]);
                    continue;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                    ExceptionUtils.handleThrowable((Throwable)throwable2);
                    this.getLogger().error((Object)sm.getString("standardContext.listenerStop", new Object[]{objectArray[n].getClass().getName()}), throwable2);
                    bl = false;
                }
            }
        }
        this.setApplicationEventListeners(null);
        this.setApplicationLifecycleListeners(null);
        this.noPluggabilityServletContext = null;
        this.noPluggabilityListeners.clear();
        return bl;
    }

    public void resourcesStart() throws LifecycleException {
        WebResource webResource;
        if (!this.resources.getState().isAvailable()) {
            this.resources.start();
        }
        if (this.effectiveMajorVersion >= 3 && this.addWebinfClassesResources && (webResource = this.resources.getResource("/WEB-INF/classes/META-INF/resources")).isDirectory()) {
            this.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", webResource.getURL(), "/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resourcesStop() {
        boolean bl = true;
        Lock lock = this.resourcesLock.writeLock();
        lock.lock();
        try {
            if (this.resources != null) {
                this.resources.stop();
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.error((Object)sm.getString("standardContext.resourcesStop"), throwable);
            bl = false;
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    public boolean loadOnStartup(Container[] containerArray) {
        TreeMap<Integer, ArrayList<Wrapper>> treeMap = new TreeMap<Integer, ArrayList<Wrapper>>();
        for (Container container : containerArray) {
            Wrapper wrapper = (Wrapper)container;
            int n = wrapper.getLoadOnStartup();
            if (n < 0) continue;
            Integer n2 = n;
            ArrayList<Wrapper> arrayList = (ArrayList<Wrapper>)treeMap.get(n2);
            if (arrayList == null) {
                arrayList = new ArrayList<Wrapper>();
                treeMap.put(n2, arrayList);
            }
            arrayList.add(wrapper);
        }
        for (ArrayList arrayList : treeMap.values()) {
            for (Container container : arrayList) {
                try {
                    container.load();
                }
                catch (ServletException servletException) {
                    this.getLogger().error((Object)sm.getString("standardContext.loadOnStartup.loadException", new Object[]{this.getName(), container.getName()}), StandardWrapper.getRootCause(servletException));
                    if (!this.getComputedFailCtxIfServletStartFails()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void startInternal() throws LifecycleException {
        Object object;
        Object object2;
        String string;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting " + this.getBaseName()));
        }
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.starting", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification(notification);
        }
        this.setConfigured(false);
        boolean bl = true;
        if (this.namingResources != null) {
            this.namingResources.start();
        }
        this.postWorkDirectory();
        if (this.getResources() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Configuring default Resources");
            }
            try {
                this.setResources(new StandardRoot(this));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error((Object)sm.getString("standardContext.resourcesInit"), (Throwable)illegalArgumentException);
                bl = false;
            }
        }
        if (bl) {
            this.resourcesStart();
        }
        if (this.getLoader() == null) {
            WebappLoader webappLoader = new WebappLoader();
            webappLoader.setDelegate(this.getDelegate());
            this.setLoader(webappLoader);
        }
        if (this.cookieProcessor == null) {
            this.cookieProcessor = new Rfc6265CookieProcessor();
        }
        this.getCharsetMapper();
        boolean bl2 = true;
        try {
            bl2 = ExtensionValidator.validateApplication(this.getResources(), this);
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("standardContext.extensionValidationError"), (Throwable)iOException);
            bl2 = false;
        }
        if (!bl2) {
            bl = false;
        }
        if ((string = System.getProperty("catalina.useNaming")) != null && string.equals("false")) {
            this.useNaming = false;
        }
        if (bl && this.isUseNaming() && this.getNamingContextListener() == null) {
            object2 = new NamingContextListener();
            ((NamingContextListener)object2).setName(this.getNamingContextName());
            ((NamingContextListener)object2).setExceptionOnFailedWrite(this.getJndiExceptionOnFailedWrite());
            this.addLifecycleListener((LifecycleListener)object2);
            this.setNamingContextListener((NamingContextListener)object2);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing standard container startup");
        }
        object2 = this.bindThread();
        try {
            if (bl) {
                Object object3;
                object = this.getLoader();
                if (object instanceof Lifecycle) {
                    ((Lifecycle)object).start();
                }
                if (object.getClassLoader() instanceof WebappClassLoaderBase) {
                    WebappClassLoaderBase object4 = (WebappClassLoaderBase)object.getClassLoader();
                    object4.setClearReferencesRmiTargets(this.getClearReferencesRmiTargets());
                    object4.setClearReferencesStopThreads(this.getClearReferencesStopThreads());
                    object4.setClearReferencesStopTimerThreads(this.getClearReferencesStopTimerThreads());
                    object4.setClearReferencesHttpClientKeepAliveThread(this.getClearReferencesHttpClientKeepAliveThread());
                    object4.setClearReferencesObjectStreamClassCaches(this.getClearReferencesObjectStreamClassCaches());
                    object4.setClearReferencesThreadLocals(this.getClearReferencesThreadLocals());
                }
                this.unbindThread((ClassLoader)object2);
                object2 = this.bindThread();
                this.logger = null;
                this.getLogger();
                Realm realm = this.getRealmInternal();
                if (null != realm) {
                    if (realm instanceof Lifecycle) {
                        ((Lifecycle)((Object)realm)).start();
                    }
                    object3 = new CredentialHandler(){

                        @Override
                        public boolean matches(String string, String string2) {
                            return StandardContext.this.getRealmInternal().getCredentialHandler().matches(string, string2);
                        }

                        @Override
                        public String mutate(String string) {
                            return StandardContext.this.getRealmInternal().getCredentialHandler().mutate(string);
                        }
                    };
                    this.context.setAttribute("org.apache.catalina.CredentialHandler", object3);
                }
                this.fireLifecycleEvent("configure_start", null);
                for (Container container : this.findChildren()) {
                    if (container.getState().isAvailable()) continue;
                    container.start();
                }
                if (this.pipeline instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.pipeline)).start();
                }
                object3 = null;
                Manager manager = this.getManager();
                if (manager == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("standardContext.cluster.noManager", new Object[]{this.getCluster() != null, this.distributable}));
                    }
                    if (this.getCluster() != null && this.distributable) {
                        try {
                            object3 = this.getCluster().createManager(this.getName());
                        }
                        catch (Exception exception) {
                            log.error((Object)sm.getString("standardContext.cluster.managerError"), (Throwable)exception);
                            bl = false;
                        }
                    } else {
                        object3 = new StandardManager();
                    }
                }
                if (object3 != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("standardContext.manager", new Object[]{object3.getClass().getName()}));
                    }
                    this.setManager((Manager)object3);
                }
                if (manager != null && this.getCluster() != null && this.distributable) {
                    this.getCluster().registerManager(manager);
                }
            }
            if (!this.getConfigured()) {
                log.error((Object)sm.getString("standardContext.configurationFail"));
                bl = false;
            }
            if (bl) {
                this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
                if (this.getInstanceManager() == null) {
                    this.setInstanceManager(this.createInstanceManager());
                }
                this.getServletContext().setAttribute(InstanceManager.class.getName(), (Object)this.getInstanceManager());
                InstanceManagerBindings.bind((ClassLoader)this.getLoader().getClassLoader(), (InstanceManager)this.getInstanceManager());
                this.getServletContext().setAttribute(JarScanner.class.getName(), (Object)this.getJarScanner());
                this.getServletContext().setAttribute("org.apache.catalina.webappVersion", (Object)this.getWebappVersion());
            }
            this.mergeParameters();
            for (Map.Entry entry : this.initializers.entrySet()) {
                try {
                    ((ServletContainerInitializer)entry.getKey()).onStartup((Set)entry.getValue(), this.getServletContext());
                }
                catch (ServletException servletException) {
                    log.error((Object)sm.getString("standardContext.sciFail"), (Throwable)servletException);
                    bl = false;
                    break;
                }
            }
            if (bl && !this.listenerStart()) {
                log.error((Object)sm.getString("standardContext.listenerFail"));
                bl = false;
            }
            if (bl) {
                this.checkConstraintsForUncoveredMethods(this.findConstraints());
            }
            try {
                object = this.getManager();
                if (object instanceof Lifecycle) {
                    ((Lifecycle)object).start();
                }
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("standardContext.managerFail"), (Throwable)exception);
                bl = false;
            }
            if (bl && !this.filterStart()) {
                log.error((Object)sm.getString("standardContext.filterFail"));
                bl = false;
            }
            if (bl && !this.loadOnStartup(this.findChildren())) {
                log.error((Object)sm.getString("standardContext.servletFail"));
                bl = false;
            }
            super.threadStart();
        }
        finally {
            this.unbindThread((ClassLoader)object2);
        }
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting completed");
            }
        } else {
            log.error((Object)sm.getString("standardContext.startFailed", new Object[]{this.getName()}));
        }
        this.startTime = System.currentTimeMillis();
        if (bl && this.getObjectName() != null) {
            object = new Notification("j2ee.state.running", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification((Notification)object);
        }
        this.getResources().gc();
        if (!bl) {
            this.setState(LifecycleState.FAILED);
            if (this.getObjectName() != null) {
                object = new Notification("j2ee.object.failed", this.getObjectName(), this.sequenceNumber.getAndIncrement());
                this.broadcaster.sendNotification((Notification)object);
            }
        } else {
            this.setState(LifecycleState.STARTING);
        }
    }

    private void checkConstraintsForUncoveredMethods(SecurityConstraint[] securityConstraintArray) {
        SecurityConstraint[] securityConstraintArray2;
        for (SecurityConstraint securityConstraint : securityConstraintArray2 = SecurityConstraint.findUncoveredHttpMethods((SecurityConstraint[])securityConstraintArray, (boolean)this.getDenyUncoveredHttpMethods(), (Log)this.getLogger())) {
            this.addConstraint(securityConstraint);
        }
    }

    @Override
    public InstanceManager createInstanceManager() {
        javax.naming.Context context = null;
        if (this.isUseNaming() && this.getNamingContextListener() != null) {
            context = this.getNamingContextListener().getEnvContext();
        }
        Map<String, Map<String, String>> map = this.buildInjectionMap(this.getIgnoreAnnotations() ? new NamingResourcesImpl() : this.getNamingResources());
        return new DefaultInstanceManager(context, map, this, this.getClass().getClassLoader());
    }

    private Map<String, Map<String, String>> buildInjectionMap(NamingResourcesImpl namingResourcesImpl) {
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        for (ContextLocalEjb contextLocalEjb : namingResourcesImpl.findLocalEjbs()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, hashMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResourcesImpl.findEjbs()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, hashMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResourcesImpl.findEnvironments()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, hashMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResourcesImpl.findMessageDestinationRefs()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, hashMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResourcesImpl.findResourceEnvRefs()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, hashMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResourcesImpl.findResources()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, hashMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResourcesImpl.findServices()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, hashMap);
        }
        return hashMap;
    }

    private void addInjectionTarget(Injectable injectable, Map<String, Map<String, String>> map) {
        List list = injectable.getInjectionTargets();
        if (list != null && list.size() > 0) {
            String string = injectable.getName();
            for (InjectionTarget injectionTarget : list) {
                String string2 = injectionTarget.getTargetClass();
                Map<String, String> map2 = map.get(string2);
                if (map2 == null) {
                    map2 = new HashMap<String, String>();
                    map.put(string2, map2);
                }
                map2.put(injectionTarget.getTargetName(), string);
            }
        }
    }

    private void mergeParameters() {
        ServletContext servletContext;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ServletContext servletContext2 = servletContext = this.findParameters();
        int n = ((String[])servletContext2).length;
        for (int i = 0; i < n; ++i) {
            String string = servletContext2[i];
            hashMap.put(string, this.findParameter(string));
        }
        for (String string : servletContext2 = this.findApplicationParameters()) {
            if (string.getOverride()) {
                if (hashMap.get(string.getName()) != null) continue;
                hashMap.put(string.getName(), string.getValue());
                continue;
            }
            hashMap.put(string.getName(), string.getValue());
        }
        ServletContext servletContext3 = this.getServletContext();
        for (Map.Entry entry : hashMap.entrySet()) {
            servletContext3.setInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        Object object;
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.stopping", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification(notification);
        }
        long l = System.currentTimeMillis() + this.unloadDelay;
        while (this.inProgressAsyncCount.get() > 0L && System.currentTimeMillis() < l) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                log.info((Object)sm.getString("standardContext.stop.asyncWaitInterrupted"), (Throwable)interruptedException);
                break;
            }
        }
        this.setState(LifecycleState.STOPPING);
        ClassLoader classLoader = this.bindThread();
        try {
            Loader loader;
            Realm realm;
            object = this.findChildren();
            this.threadStop();
            for (Container container : object) {
                container.stop();
            }
            this.filterStop();
            Manager manager = this.getManager();
            if (manager instanceof Lifecycle && ((Lifecycle)((Object)manager)).getState().isAvailable()) {
                ((Lifecycle)((Object)manager)).stop();
            }
            this.listenerStop();
            this.setCharsetMapper(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Processing standard container shutdown");
            }
            if (this.namingResources != null) {
                this.namingResources.stop();
            }
            this.fireLifecycleEvent("configure_stop", null);
            if (this.pipeline instanceof Lifecycle && ((Lifecycle)((Object)this.pipeline)).getState().isAvailable()) {
                ((Lifecycle)((Object)this.pipeline)).stop();
            }
            if (this.context != null) {
                this.context.clearAttributes();
            }
            if ((realm = this.getRealmInternal()) instanceof Lifecycle) {
                ((Lifecycle)((Object)realm)).stop();
            }
            if ((loader = this.getLoader()) instanceof Lifecycle) {
                ClassLoader classLoader2 = loader.getClassLoader();
                ((Lifecycle)((Object)loader)).stop();
                if (classLoader2 != null) {
                    InstanceManagerBindings.unbind((ClassLoader)classLoader2);
                }
            }
            this.resourcesStop();
        }
        finally {
            this.unbindThread(classLoader);
        }
        if (this.getObjectName() != null) {
            object = new Notification("j2ee.state.stopped", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification((Notification)object);
        }
        this.context = null;
        try {
            this.resetContext();
        }
        catch (Exception exception) {
            log.error((Object)("Error resetting context " + this + " " + exception), (Throwable)exception);
        }
        this.setInstanceManager(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping complete");
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        Manager manager;
        Object object;
        if (this.getObjectName() != null) {
            object = new Notification("j2ee.object.deleted", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification((Notification)object);
        }
        if (this.namingResources != null) {
            this.namingResources.destroy();
        }
        if ((object = this.getLoader()) instanceof Lifecycle) {
            ((Lifecycle)object).destroy();
        }
        if ((manager = this.getManager()) instanceof Lifecycle) {
            ((Lifecycle)((Object)manager)).destroy();
        }
        if (this.resources != null) {
            this.resources.destroy();
        }
        super.destroyInternal();
    }

    @Override
    public void backgroundProcess() {
        InstanceManager instanceManager;
        WebResourceRoot webResourceRoot;
        Manager manager;
        if (!this.getState().isAvailable()) {
            return;
        }
        Loader loader = this.getLoader();
        if (loader != null) {
            try {
                loader.backgroundProcess();
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("standardContext.backgroundProcess.loader", new Object[]{loader}), (Throwable)exception);
            }
        }
        if ((manager = this.getManager()) != null) {
            try {
                manager.backgroundProcess();
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("standardContext.backgroundProcess.manager", new Object[]{manager}), (Throwable)exception);
            }
        }
        if ((webResourceRoot = this.getResources()) != null) {
            try {
                webResourceRoot.backgroundProcess();
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("standardContext.backgroundProcess.resources", new Object[]{webResourceRoot}), (Throwable)exception);
            }
        }
        if ((instanceManager = this.getInstanceManager()) != null) {
            try {
                instanceManager.backgroundProcess();
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("standardContext.backgroundProcess.instanceManager", new Object[]{webResourceRoot}), (Throwable)exception);
            }
        }
        super.backgroundProcess();
    }

    private void resetContext() throws Exception {
        for (Container container : this.findChildren()) {
            this.removeChild(container);
        }
        this.startupTime = 0L;
        this.startTime = 0L;
        this.tldScanTime = 0L;
        this.distributable = false;
        this.applicationListeners = new String[0];
        this.applicationEventListenersList.clear();
        this.applicationLifecycleListenersObjects = new Object[0];
        this.jspConfigDescriptor = null;
        this.initializers.clear();
        this.createdServlets.clear();
        this.postConstructMethods.clear();
        this.preDestroyMethods.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("resetContext " + this.getObjectName()));
        }
    }

    protected String adjustURLPattern(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("/") || string.startsWith("*.")) {
            return string;
        }
        if (!this.isServlet22()) {
            return string;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("standardContext.urlPattern.patternWarning", new Object[]{string}));
        }
        return "/" + string;
    }

    @Override
    public boolean isServlet22() {
        return "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(this.publicId);
    }

    @Override
    public Set<String> addServletSecurity(ServletRegistration.Dynamic dynamic, ServletSecurityElement servletSecurityElement) {
        HashSet<String> hashSet = new HashSet<String>();
        Collection collection = dynamic.getMappings();
        for (String string : collection) {
            SecurityConstraint securityConstraint;
            int n;
            SecurityConstraint[] securityConstraintArray;
            boolean bl = false;
            SecurityConstraint[] securityConstraintArray2 = securityConstraintArray = this.findConstraints();
            int n2 = securityConstraintArray2.length;
            for (n = 0; n < n2; ++n) {
                SecurityConstraint securityConstraint2 = securityConstraintArray2[n];
                for (SecurityCollection securityCollection : securityConstraint = securityConstraint2.findCollections()) {
                    if (!securityCollection.findPattern(string)) continue;
                    if (securityCollection.isFromDescriptor()) {
                        bl = true;
                        hashSet.add(string);
                        break;
                    }
                    securityCollection.removePattern(string);
                    if (securityCollection.findPatterns().length != 0) continue;
                    securityConstraint2.removeCollection(securityCollection);
                }
                if (securityConstraint2.findCollections().length == 0) {
                    this.removeConstraint(securityConstraint2);
                }
                if (bl) break;
            }
            if (bl) continue;
            SecurityConstraint[] securityConstraintArray3 = securityConstraintArray2 = SecurityConstraint.createConstraints((ServletSecurityElement)servletSecurityElement, (String)string);
            n = securityConstraintArray3.length;
            for (int i = 0; i < n; ++i) {
                securityConstraint = securityConstraintArray3[i];
                this.addConstraint(securityConstraint);
            }
        }
        return hashSet;
    }

    protected ClassLoader bindThread() {
        ClassLoader classLoader = this.bind(false, null);
        if (this.isUseNaming()) {
            try {
                ContextBindings.bindThread(this, this.getNamingToken());
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return classLoader;
    }

    protected void unbindThread(ClassLoader classLoader) {
        if (this.isUseNaming()) {
            ContextBindings.unbindThread(this, this.getNamingToken());
        }
        this.unbind(false, classLoader);
    }

    public ClassLoader bind(boolean bl, ClassLoader classLoader) {
        Object object;
        Loader loader = this.getLoader();
        ClassLoader classLoader2 = null;
        if (loader != null) {
            classLoader2 = loader.getClassLoader();
        }
        if (classLoader == null) {
            if (bl) {
                object = new PrivilegedGetTccl();
                classLoader = (ClassLoader)AccessController.doPrivileged(object);
            } else {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
        }
        if (classLoader2 == null || classLoader2 == classLoader) {
            return null;
        }
        object = this.getThreadBindingListener();
        if (bl) {
            PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl(classLoader2);
            AccessController.doPrivileged(privilegedSetTccl);
        } else {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        if (object != null) {
            try {
                object.bind();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("standardContext.threadBindingListenerError", new Object[]{this.getName()}), throwable);
            }
        }
        return classLoader;
    }

    public void unbind(boolean bl, ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        if (this.threadBindingListener != null) {
            try {
                this.threadBindingListener.unbind();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("standardContext.threadBindingListenerError", new Object[]{this.getName()}), throwable);
            }
        }
        if (bl) {
            PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl(classLoader);
            AccessController.doPrivileged(privilegedSetTccl);
        } else {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private String getNamingContextName() {
        if (this.namingContextName == null) {
            Container container = this.getParent();
            if (container == null) {
                this.namingContextName = this.getName();
            } else {
                ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
                StringBuilder stringBuilder = new StringBuilder();
                while (container != null) {
                    arrayDeque.add(container.getName());
                    container = container.getParent();
                }
                while (!arrayDeque.isEmpty()) {
                    stringBuilder.append("/" + (String)arrayDeque.remove());
                }
                stringBuilder.append(this.getName());
                this.namingContextName = stringBuilder.toString();
            }
        }
        return this.namingContextName;
    }

    public NamingContextListener getNamingContextListener() {
        return this.namingContextListener;
    }

    public void setNamingContextListener(NamingContextListener namingContextListener) {
        this.namingContextListener = namingContextListener;
    }

    @Override
    public boolean getPaused() {
        return this.paused;
    }

    @Override
    public boolean fireRequestInitEvent(ServletRequest servletRequest) {
        Object[] objectArray = this.getApplicationEventListeners();
        if (objectArray != null && objectArray.length > 0) {
            ServletRequestEvent servletRequestEvent = new ServletRequestEvent(this.getServletContext(), servletRequest);
            for (Object object : objectArray) {
                if (object == null || !(object instanceof ServletRequestListener)) continue;
                ServletRequestListener servletRequestListener = (ServletRequestListener)object;
                try {
                    servletRequestListener.requestInitialized(servletRequestEvent);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    this.getLogger().error((Object)sm.getString("standardContext.requestListener.requestInit", new Object[]{object.getClass().getName()}), throwable);
                    servletRequest.setAttribute("jakarta.servlet.error.exception", (Object)throwable);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean fireRequestDestroyEvent(ServletRequest servletRequest) {
        Object[] objectArray = this.getApplicationEventListeners();
        if (objectArray != null && objectArray.length > 0) {
            ServletRequestEvent servletRequestEvent = new ServletRequestEvent(this.getServletContext(), servletRequest);
            for (int i = 0; i < objectArray.length; ++i) {
                int n = objectArray.length - 1 - i;
                if (objectArray[n] == null || !(objectArray[n] instanceof ServletRequestListener)) continue;
                ServletRequestListener servletRequestListener = (ServletRequestListener)objectArray[n];
                try {
                    servletRequestListener.requestDestroyed(servletRequestEvent);
                    continue;
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    this.getLogger().error((Object)sm.getString("standardContext.requestListener.requestInit", new Object[]{objectArray[n].getClass().getName()}), throwable);
                    servletRequest.setAttribute("jakarta.servlet.error.exception", (Object)throwable);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void addPostConstructMethod(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.postconstruct.required"));
        }
        if (this.postConstructMethods.get(string) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.postconstruct.duplicate", new Object[]{string}));
        }
        this.postConstructMethods.put(string, string2);
        this.fireContainerEvent("addPostConstructMethod", string);
    }

    @Override
    public void removePostConstructMethod(String string) {
        this.postConstructMethods.remove(string);
        this.fireContainerEvent("removePostConstructMethod", string);
    }

    @Override
    public void addPreDestroyMethod(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.predestroy.required"));
        }
        if (this.preDestroyMethods.get(string) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.predestroy.duplicate", new Object[]{string}));
        }
        this.preDestroyMethods.put(string, string2);
        this.fireContainerEvent("addPreDestroyMethod", string);
    }

    @Override
    public void removePreDestroyMethod(String string) {
        this.preDestroyMethods.remove(string);
        this.fireContainerEvent("removePreDestroyMethod", string);
    }

    @Override
    public String findPostConstructMethod(String string) {
        return this.postConstructMethods.get(string);
    }

    @Override
    public String findPreDestroyMethod(String string) {
        return this.preDestroyMethods.get(string);
    }

    @Override
    public Map<String, String> findPostConstructMethods() {
        return this.postConstructMethods;
    }

    @Override
    public Map<String, String> findPreDestroyMethods() {
        return this.preDestroyMethods;
    }

    protected void postWorkDirectory() {
        String string;
        Object object;
        String string2 = this.getWorkDir();
        if (string2 == null || string2.length() == 0) {
            Object object2;
            object = null;
            string = null;
            String string3 = null;
            Container container = this.getParent();
            if (container != null) {
                object = container.getName();
                if (container instanceof StandardHost) {
                    string3 = ((StandardHost)container).getWorkDir();
                }
                if ((object2 = container.getParent()) != null) {
                    string = object2.getName();
                }
            }
            if (object == null || ((String)object).length() < 1) {
                object = "_";
            }
            if (string == null || string.length() < 1) {
                string = "_";
            }
            if (((String)(object2 = this.getBaseName())).startsWith("/")) {
                object2 = ((String)object2).substring(1);
            }
            object2 = ((String)object2).replace('/', '_');
            if (((String)(object2 = ((String)object2).replace('\\', '_'))).length() < 1) {
                object2 = "ROOT";
            }
            string2 = string3 != null ? string3 + File.separator + (String)object2 : "work" + File.separator + string + File.separator + (String)object + File.separator + (String)object2;
            this.setWorkDir(string2);
        }
        if (!((File)(object = new File(string2))).isAbsolute()) {
            string = null;
            try {
                string = this.getCatalinaBase().getCanonicalPath();
                object = new File(string, string2);
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("standardContext.workCreateException", new Object[]{string2, string, this.getName()}), (Throwable)iOException);
            }
        }
        if (!((File)object).mkdirs() && !((File)object).isDirectory()) {
            log.warn((Object)sm.getString("standardContext.workCreateFail", new Object[]{object, this.getName()}));
        }
        if (this.context == null) {
            this.getServletContext();
        }
        this.context.setAttribute("jakarta.servlet.context.tempdir", object);
        this.context.setAttributeReadOnly("jakarta.servlet.context.tempdir");
    }

    private void setPaused(boolean bl) {
        this.paused = bl;
    }

    private boolean validateURLPattern(String string) {
        if (string == null) {
            return false;
        }
        if (string.indexOf(10) >= 0 || string.indexOf(13) >= 0) {
            return false;
        }
        if (string.equals("")) {
            return true;
        }
        if (string.startsWith("*.")) {
            if (string.indexOf(47) < 0) {
                this.checkUnusualURLPattern(string);
                return true;
            }
            return false;
        }
        if (string.startsWith("/") && !string.contains("*.")) {
            this.checkUnusualURLPattern(string);
            return true;
        }
        return false;
    }

    private void checkUnusualURLPattern(String string) {
        if (log.isInfoEnabled() && (string.endsWith("*") && (string.length() < 2 || string.charAt(string.length() - 2) != '/') || string.startsWith("*.") && string.length() > 2 && string.lastIndexOf(46) > 1)) {
            log.info((Object)sm.getString("standardContext.suspiciousUrl", new Object[]{string, this.getName()}));
        }
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder("j2eeType=WebModule,");
        stringBuilder.append(this.getObjectKeyPropertiesNameOnly());
        stringBuilder.append(",J2EEApplication=");
        stringBuilder.append(this.getJ2EEApplication());
        stringBuilder.append(",J2EEServer=");
        stringBuilder.append(this.getJ2EEServer());
        return stringBuilder.toString();
    }

    private String getObjectKeyPropertiesNameOnly() {
        StringBuilder stringBuilder = new StringBuilder("name=//");
        String string = this.getParent().getName();
        if (string == null) {
            stringBuilder.append("DEFAULT");
        } else {
            stringBuilder.append(string);
        }
        String string2 = this.getName();
        if (!string2.startsWith("/")) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.namingResources != null) {
            this.namingResources.init();
        }
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.object.created", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification(notification);
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notificationInfo == null) {
            this.notificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"j2ee.object.created"}, Notification.class.getName(), "web application is created"), new MBeanNotificationInfo(new String[]{"j2ee.state.starting"}, Notification.class.getName(), "change web application is starting"), new MBeanNotificationInfo(new String[]{"j2ee.state.running"}, Notification.class.getName(), "web application is running"), new MBeanNotificationInfo(new String[]{"j2ee.state.stopping"}, Notification.class.getName(), "web application start to stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.stopped"}, Notification.class.getName(), "web application is stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.deleted"}, Notification.class.getName(), "web application is deleted"), new MBeanNotificationInfo(new String[]{"j2ee.object.failed"}, Notification.class.getName(), "web application failed")};
        }
        return this.notificationInfo;
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener);
    }

    public String[] getWelcomeFiles() {
        return this.findWelcomeFiles();
    }

    @Override
    public boolean getXmlNamespaceAware() {
        return this.webXmlNamespaceAware;
    }

    @Override
    public void setXmlNamespaceAware(boolean bl) {
        this.webXmlNamespaceAware = bl;
    }

    @Override
    public void setXmlValidation(boolean bl) {
        this.webXmlValidation = bl;
    }

    @Override
    public boolean getXmlValidation() {
        return this.webXmlValidation;
    }

    @Override
    public void setXmlBlockExternal(boolean bl) {
        this.xmlBlockExternal = bl;
    }

    @Override
    public boolean getXmlBlockExternal() {
        return this.xmlBlockExternal;
    }

    @Override
    public void setTldValidation(boolean bl) {
        this.tldValidation = bl;
    }

    @Override
    public boolean getTldValidation() {
        return this.tldValidation;
    }

    public String getServer() {
        return this.server;
    }

    public String setServer(String string) {
        this.server = string;
        return this.server;
    }

    @Deprecated
    public String[] getJavaVMs() {
        return this.javaVMs;
    }

    @Deprecated
    public String[] setJavaVMs(String[] stringArray) {
        this.javaVMs = stringArray;
        return stringArray;
    }

    public long getStartTime() {
        return this.startTime;
    }

    private static class NoPluggabilityServletContext
    implements ServletContext {
        private final ServletContext sc;

        public NoPluggabilityServletContext(ServletContext servletContext) {
            this.sc = servletContext;
        }

        public String getContextPath() {
            return this.sc.getContextPath();
        }

        public ServletContext getContext(String string) {
            return this.sc.getContext(string);
        }

        public int getMajorVersion() {
            return this.sc.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.sc.getMinorVersion();
        }

        public int getEffectiveMajorVersion() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public int getEffectiveMinorVersion() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public String getMimeType(String string) {
            return this.sc.getMimeType(string);
        }

        public Set<String> getResourcePaths(String string) {
            return this.sc.getResourcePaths(string);
        }

        public URL getResource(String string) throws MalformedURLException {
            return this.sc.getResource(string);
        }

        public InputStream getResourceAsStream(String string) {
            return this.sc.getResourceAsStream(string);
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            return this.sc.getRequestDispatcher(string);
        }

        public RequestDispatcher getNamedDispatcher(String string) {
            return this.sc.getNamedDispatcher(string);
        }

        @Deprecated
        public Servlet getServlet(String string) throws ServletException {
            return this.sc.getServlet(string);
        }

        @Deprecated
        public Enumeration<Servlet> getServlets() {
            return this.sc.getServlets();
        }

        @Deprecated
        public Enumeration<String> getServletNames() {
            return this.sc.getServletNames();
        }

        public void log(String string) {
            this.sc.log(string);
        }

        @Deprecated
        public void log(Exception exception, String string) {
            this.sc.log(exception, string);
        }

        public void log(String string, Throwable throwable) {
            this.sc.log(string, throwable);
        }

        public String getRealPath(String string) {
            return this.sc.getRealPath(string);
        }

        public String getServerInfo() {
            return this.sc.getServerInfo();
        }

        public String getInitParameter(String string) {
            return this.sc.getInitParameter(string);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.sc.getInitParameterNames();
        }

        public boolean setInitParameter(String string, String string2) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public Object getAttribute(String string) {
            return this.sc.getAttribute(string);
        }

        public Enumeration<String> getAttributeNames() {
            return this.sc.getAttributeNames();
        }

        public void setAttribute(String string, Object object) {
            this.sc.setAttribute(string, object);
        }

        public void removeAttribute(String string) {
            this.sc.removeAttribute(string);
        }

        public String getServletContextName() {
            return this.sc.getServletContextName();
        }

        public ServletRegistration.Dynamic addServlet(String string, String string2) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public ServletRegistration.Dynamic addServlet(String string, Servlet servlet) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public ServletRegistration.Dynamic addServlet(String string, Class<? extends Servlet> clazz) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public ServletRegistration.Dynamic addJspFile(String string, String string2) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public ServletRegistration getServletRegistration(String string) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public FilterRegistration.Dynamic addFilter(String string, String string2) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public FilterRegistration.Dynamic addFilter(String string, Filter filter) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public FilterRegistration.Dynamic addFilter(String string, Class<? extends Filter> clazz) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public FilterRegistration getFilterRegistration(String string) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public SessionCookieConfig getSessionCookieConfig() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public void addListener(String string) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public <T extends EventListener> void addListener(T t) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public void addListener(Class<? extends EventListener> clazz) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public ClassLoader getClassLoader() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public void declareRoles(String ... stringArray) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public String getVirtualServerName() {
            return this.sc.getVirtualServerName();
        }

        public int getSessionTimeout() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public void setSessionTimeout(int n) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public String getRequestCharacterEncoding() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public void setRequestCharacterEncoding(String string) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public String getResponseCharacterEncoding() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public void setResponseCharacterEncoding(String string) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }
    }

    private static final class ContextFilterMaps {
        private final Object lock = new Object();
        private FilterMap[] array = new FilterMap[0];
        private int insertPoint = 0;

        private ContextFilterMaps() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FilterMap[] asArray() {
            Object object = this.lock;
            synchronized (object) {
                return this.array;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(FilterMap filterMap) {
            Object object = this.lock;
            synchronized (object) {
                FilterMap[] filterMapArray = Arrays.copyOf(this.array, this.array.length + 1);
                filterMapArray[this.array.length] = filterMap;
                this.array = filterMapArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addBefore(FilterMap filterMap) {
            Object object = this.lock;
            synchronized (object) {
                FilterMap[] filterMapArray = new FilterMap[this.array.length + 1];
                System.arraycopy(this.array, 0, filterMapArray, 0, this.insertPoint);
                System.arraycopy(this.array, this.insertPoint, filterMapArray, this.insertPoint + 1, this.array.length - this.insertPoint);
                filterMapArray[this.insertPoint] = filterMap;
                this.array = filterMapArray;
                ++this.insertPoint;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(FilterMap filterMap) {
            Object object = this.lock;
            synchronized (object) {
                int n = -1;
                for (int i = 0; i < this.array.length; ++i) {
                    if (this.array[i] != filterMap) continue;
                    n = i;
                    break;
                }
                if (n < 0) {
                    return;
                }
                FilterMap[] filterMapArray = new FilterMap[this.array.length - 1];
                System.arraycopy(this.array, 0, filterMapArray, 0, n);
                System.arraycopy(this.array, n + 1, filterMapArray, n, this.array.length - 1 - n);
                this.array = filterMapArray;
                if (n < this.insertPoint) {
                    --this.insertPoint;
                }
            }
        }
    }
}

