/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el;

import jakarta.el.ELContext;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueExpression;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.el.util.MessageFactory;
import org.apache.el.util.ReflectionUtil;

public final class ValueExpressionLiteral
extends ValueExpression
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Object value;
    private String valueString;
    private Class<?> expectedType;

    public ValueExpressionLiteral() {
    }

    public ValueExpressionLiteral(Object object, Class<?> clazz) {
        this.value = object;
        this.expectedType = clazz;
    }

    public Object getValue(ELContext eLContext) {
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        Object object = this.expectedType != null ? eLContext.convertToType(this.value, this.expectedType) : this.value;
        eLContext.notifyAfterEvaluation(this.getExpressionString());
        return object;
    }

    public void setValue(ELContext eLContext, Object object) {
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        throw new PropertyNotWritableException(MessageFactory.get("error.value.literal.write", this.value));
    }

    public boolean isReadOnly(ELContext eLContext) {
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        eLContext.notifyAfterEvaluation(this.getExpressionString());
        return true;
    }

    public Class<?> getType(ELContext eLContext) {
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        Class<?> clazz = this.value != null ? this.value.getClass() : null;
        eLContext.notifyAfterEvaluation(this.getExpressionString());
        return clazz;
    }

    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    public String getExpressionString() {
        if (this.valueString == null) {
            this.valueString = this.value != null ? this.value.toString() : null;
        }
        return this.valueString;
    }

    public boolean equals(Object object) {
        return object instanceof ValueExpressionLiteral && this.equals((ValueExpressionLiteral)object);
    }

    public boolean equals(ValueExpressionLiteral valueExpressionLiteral) {
        return valueExpressionLiteral != null && this.value != null && valueExpressionLiteral.value != null && (this.value == valueExpressionLiteral.value || this.value.equals(valueExpressionLiteral.value));
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public boolean isLiteralText() {
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.value);
        objectOutput.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.value = objectInput.readObject();
        String string = objectInput.readUTF();
        if (!string.isEmpty()) {
            this.expectedType = ReflectionUtil.forName(string);
        }
    }
}

