/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.apache.juli.ClassLoaderLogManager;
import org.apache.juli.OneLineFormatter;

public class FileHandler
extends Handler {
    public static final int DEFAULT_MAX_DAYS = -1;
    public static final int DEFAULT_BUFFER_SIZE = -1;
    private static final ExecutorService DELETE_FILES_SERVICE = Executors.newSingleThreadExecutor(new ThreadFactory("FileHandlerLogFilesCleaner-"));
    private volatile String date = null;
    private String directory;
    private String prefix;
    private String suffix;
    private Boolean rotatable;
    private Integer maxDays;
    private volatile PrintWriter writer = null;
    protected final ReadWriteLock writerLock = new ReentrantReadWriteLock();
    private Integer bufferSize;
    private Pattern pattern;

    public FileHandler() {
        this(null, null, null);
    }

    public FileHandler(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public FileHandler(String string, String string2, String string3, Integer n) {
        this(string, string2, string3, n, null, null);
    }

    public FileHandler(String string, String string2, String string3, Integer n, Boolean bl, Integer n2) {
        this.directory = string;
        this.prefix = string2;
        this.suffix = string3;
        this.maxDays = n;
        this.rotatable = bl;
        this.bufferSize = n2;
        this.configure();
        this.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        block19: {
            String string;
            Object object;
            if (!this.isLoggable(logRecord)) {
                return;
            }
            if (this.rotatable.booleanValue()) {
                object = new Timestamp(System.currentTimeMillis());
                string = ((Timestamp)object).toString().substring(0, 10);
            } else {
                string = "";
            }
            this.writerLock.readLock().lock();
            try {
                if (!string.equals(this.date)) {
                    this.writerLock.readLock().unlock();
                    this.writerLock.writeLock().lock();
                    try {
                        if (!string.equals(this.date)) {
                            this.closeWriter();
                            this.date = string;
                            this.openWriter();
                            this.clean();
                        }
                    }
                    finally {
                        this.writerLock.readLock().lock();
                        this.writerLock.writeLock().unlock();
                    }
                }
                object = null;
                try {
                    object = this.getFormatter().format(logRecord);
                }
                catch (Exception exception) {
                    this.reportError(null, exception, 5);
                    this.writerLock.readLock().unlock();
                    return;
                }
                try {
                    if (this.writer != null) {
                        this.writer.write((String)object);
                        if (this.bufferSize < 0) {
                            this.writer.flush();
                        }
                        break block19;
                    }
                    this.reportError("FileHandler is closed or not yet initialized, unable to log [" + (String)object + "]", null, 1);
                }
                catch (Exception exception) {
                    this.reportError(null, exception, 1);
                }
            }
            finally {
                this.writerLock.readLock().unlock();
            }
        }
    }

    @Override
    public void close() {
        this.closeWriter();
    }

    protected void closeWriter() {
        this.writerLock.writeLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.write(this.getFormatter().getTail(this));
            this.writer.flush();
            this.writer.close();
            this.writer = null;
            this.date = null;
        }
        catch (Exception exception) {
            this.reportError(null, exception, 3);
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
    }

    @Override
    public void flush() {
        this.writerLock.readLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.flush();
        }
        catch (Exception exception) {
            this.reportError(null, exception, 2);
        }
        finally {
            this.writerLock.readLock().unlock();
        }
    }

    private void configure() {
        String string;
        String string2;
        boolean bl;
        String string3 = this.getClass().getName();
        ClassLoader classLoader = ClassLoaderLogManager.getClassLoader();
        if (this.rotatable == null) {
            this.rotatable = Boolean.valueOf(this.getProperty(string3 + ".rotatable", "true"));
        }
        if (this.directory == null) {
            this.directory = this.getProperty(string3 + ".directory", "logs");
        }
        if (this.prefix == null) {
            this.prefix = this.getProperty(string3 + ".prefix", "juli.");
        }
        if (this.suffix == null) {
            this.suffix = this.getProperty(string3 + ".suffix", ".log");
        }
        boolean bl2 = bl = this.rotatable == false && !this.prefix.isEmpty() && !this.suffix.isEmpty();
        if (bl && this.prefix.charAt(this.prefix.length() - 1) == this.suffix.charAt(0)) {
            this.suffix = this.suffix.substring(1);
        }
        this.pattern = Pattern.compile("^(" + Pattern.quote(this.prefix) + ")\\d{4}-\\d{1,2}-\\d{1,2}(" + Pattern.quote(this.suffix) + ")$");
        if (this.maxDays == null) {
            string2 = this.getProperty(string3 + ".maxDays", String.valueOf(-1));
            try {
                this.maxDays = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.maxDays = -1;
            }
        }
        if (this.bufferSize == null) {
            string2 = this.getProperty(string3 + ".bufferSize", String.valueOf(-1));
            try {
                this.bufferSize = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.bufferSize = -1;
            }
        }
        if ((string2 = this.getProperty(string3 + ".encoding", null)) != null && string2.length() > 0) {
            try {
                this.setEncoding(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.setLevel(Level.parse(this.getProperty(string3 + ".level", "" + Level.ALL)));
        String string4 = this.getProperty(string3 + ".filter", null);
        if (string4 != null) {
            try {
                this.setFilter((Filter)classLoader.loadClass(string4).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.getProperty(string3 + ".formatter", null)) != null) {
            try {
                this.setFormatter((Formatter)classLoader.loadClass(string).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                this.setFormatter(new OneLineFormatter());
            }
        } else {
            this.setFormatter(new OneLineFormatter());
        }
        this.setErrorManager(new ErrorManager());
    }

    private String getProperty(String string, String string2) {
        String string3 = LogManager.getLogManager().getProperty(string);
        string3 = string3 == null ? string2 : string3.trim();
        return string3;
    }

    public void open() {
        this.openWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openWriter() {
        File file = new File(this.directory);
        if (!file.mkdirs() && !file.isDirectory()) {
            this.reportError("Unable to create [" + file + "]", null, 4);
            this.writer = null;
            return;
        }
        this.writerLock.writeLock().lock();
        FileOutputStream fileOutputStream = null;
        OutputStream outputStream = null;
        try {
            File file2 = new File(file.getAbsoluteFile(), this.prefix + (this.rotatable != false ? this.date : "") + this.suffix);
            File file3 = file2.getParentFile();
            if (!file3.mkdirs() && !file3.isDirectory()) {
                this.reportError("Unable to create [" + file3 + "]", null, 4);
                this.writer = null;
                return;
            }
            String string = this.getEncoding();
            fileOutputStream = new FileOutputStream(file2, true);
            outputStream = this.bufferSize > 0 ? new BufferedOutputStream(fileOutputStream, this.bufferSize) : fileOutputStream;
            this.writer = new PrintWriter((Writer)(string != null ? new OutputStreamWriter(outputStream, string) : new OutputStreamWriter(outputStream)), false);
            this.writer.write(this.getFormatter().getHead(this));
        }
        catch (Exception exception) {
            this.reportError(null, exception, 4);
            this.writer = null;
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
    }

    private void clean() {
        if (this.maxDays <= 0 || Files.notExists(this.getDirectoryAsPath(), new LinkOption[0])) {
            return;
        }
        DELETE_FILES_SERVICE.submit(() -> {
            try (DirectoryStream<Path> directoryStream = this.streamFilesForDelete();){
                for (Path path : directoryStream) {
                    Files.delete(path);
                }
            }
            catch (IOException iOException) {
                this.reportError("Unable to delete log files older than [" + this.maxDays + "] days", null, 0);
            }
        });
    }

    private DirectoryStream<Path> streamFilesForDelete() throws IOException {
        LocalDate localDate = LocalDate.now().minus(this.maxDays.intValue(), ChronoUnit.DAYS);
        return Files.newDirectoryStream(this.getDirectoryAsPath(), path -> {
            boolean bl = false;
            String string = this.obtainDateFromPath((Path)path);
            if (string != null) {
                try {
                    LocalDate localDate2 = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(string));
                    bl = localDate2.isBefore(localDate);
                }
                catch (DateTimeException dateTimeException) {
                    // empty catch block
                }
            }
            return bl;
        });
    }

    private Path getDirectoryAsPath() {
        return FileSystems.getDefault().getPath(this.directory, new String[0]);
    }

    private String obtainDateFromPath(Path path) {
        Path path2 = path.getFileName();
        if (path2 == null) {
            return null;
        }
        String string = path2.toString();
        if (this.pattern.matcher(string).matches()) {
            string = string.substring(this.prefix.length());
            return string.substring(0, string.length() - this.suffix.length());
        }
        return null;
    }

    protected static final class ThreadFactory
    implements java.util.concurrent.ThreadFactory {
        private final String namePrefix;
        private final boolean isSecurityEnabled;
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public ThreadFactory(String string) {
            this.namePrefix = string;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                this.isSecurityEnabled = false;
                this.group = Thread.currentThread().getThreadGroup();
            } else {
                this.isSecurityEnabled = true;
                this.group = securityManager.getThreadGroup();
            }
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement());
            if (this.isSecurityEnabled) {
                AccessController.doPrivileged(() -> {
                    thread.setContextClassLoader(ThreadFactory.class.getClassLoader());
                    return null;
                });
            } else {
                thread.setContextClassLoader(ThreadFactory.class.getClassLoader());
            }
            thread.setDaemon(true);
            return thread;
        }
    }
}

