/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.tagext.TagInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Set;
import java.util.jar.JarEntry;
import org.apache.jasper.JasperException;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;

public class JspCompilationContext {
    private final Log log = LogFactory.getLog(JspCompilationContext.class);
    private String className;
    private final String jspUri;
    private String basePackageName;
    private String derivedPackageName;
    private String servletJavaFileName;
    private String javaPath;
    private String classFileName;
    private ServletWriter writer;
    private final Options options;
    private final JspServletWrapper jsw;
    private Compiler jspCompiler;
    private String classPath;
    private final String baseURI;
    private String outputDir;
    private final ServletContext context;
    private ClassLoader loader;
    private final JspRuntimeContext rctxt;
    private volatile boolean removed = false;
    private volatile URLClassLoader jspLoader;
    private URL baseUrl;
    private Class<?> servletClass;
    private final boolean isTagFile;
    private boolean protoTypeMode;
    private TagInfo tagInfo;
    private Jar tagJar;
    private static final Object outputDirLock = new Object();

    public JspCompilationContext(String string, Options options, ServletContext servletContext, JspServletWrapper jspServletWrapper, JspRuntimeContext jspRuntimeContext) {
        this(string, null, options, servletContext, jspServletWrapper, jspRuntimeContext, null, false);
    }

    public JspCompilationContext(String string, TagInfo tagInfo, Options options, ServletContext servletContext, JspServletWrapper jspServletWrapper, JspRuntimeContext jspRuntimeContext, Jar jar) {
        this(string, tagInfo, options, servletContext, jspServletWrapper, jspRuntimeContext, jar, true);
    }

    private JspCompilationContext(String string, TagInfo tagInfo, Options options, ServletContext servletContext, JspServletWrapper jspServletWrapper, JspRuntimeContext jspRuntimeContext, Jar jar, boolean bl) {
        this.jspUri = JspCompilationContext.canonicalURI(string);
        this.options = options;
        this.jsw = jspServletWrapper;
        this.context = servletContext;
        String string2 = string.substring(0, string.lastIndexOf(47) + 1);
        if (string2.isEmpty()) {
            string2 = "/";
        } else if (string2.charAt(0) != '/') {
            string2 = "/" + string2;
        }
        if (string2.charAt(string2.length() - 1) != '/') {
            string2 = string2 + '/';
        }
        this.baseURI = string2;
        this.rctxt = jspRuntimeContext;
        this.basePackageName = options.getGeneratedJspPackageName();
        this.tagInfo = tagInfo;
        this.tagJar = jar;
        this.isTagFile = bl;
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return this.rctxt.getClassPath();
    }

    public void setClassPath(String string) {
        this.classPath = string;
    }

    public ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return this.rctxt.getParentClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public ClassLoader getJspLoader() {
        if (this.jspLoader == null) {
            this.jspLoader = new JasperLoader(new URL[]{this.baseUrl}, this.getClassLoader(), this.basePackageName, this.rctxt.getPermissionCollection());
        }
        return this.jspLoader;
    }

    public void clearJspLoader() {
        this.jspLoader = null;
    }

    public String getOutputDir() {
        if (this.outputDir == null) {
            this.createOutputDir();
        }
        return this.outputDir;
    }

    public Compiler createCompiler() {
        if (this.jspCompiler != null) {
            return this.jspCompiler;
        }
        this.jspCompiler = null;
        if (this.options.getCompilerClassName() != null) {
            this.jspCompiler = this.createCompiler(this.options.getCompilerClassName());
        } else if (this.options.getCompiler() == null) {
            this.jspCompiler = this.createCompiler("org.apache.jasper.compiler.JDTCompiler");
            if (this.jspCompiler == null) {
                this.jspCompiler = this.createCompiler("org.apache.jasper.compiler.AntCompiler");
            }
        } else {
            this.jspCompiler = this.createCompiler("org.apache.jasper.compiler.AntCompiler");
            if (this.jspCompiler == null) {
                this.jspCompiler = this.createCompiler("org.apache.jasper.compiler.JDTCompiler");
            }
        }
        if (this.jspCompiler == null) {
            throw new IllegalStateException(Localizer.getMessage("jsp.error.compiler.config", this.options.getCompilerClassName(), this.options.getCompiler()));
        }
        this.jspCompiler.init(this, this.jsw);
        return this.jspCompiler;
    }

    protected Compiler createCompiler(String string) {
        Compiler compiler = null;
        try {
            compiler = (Compiler)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)Localizer.getMessage("jsp.error.compiler"), throwable);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            this.log.warn((Object)Localizer.getMessage("jsp.error.compiler"), (Throwable)reflectiveOperationException);
        }
        return compiler;
    }

    public Compiler getCompiler() {
        return this.jspCompiler;
    }

    public String resolveRelativeUri(String string) {
        if (string.startsWith("/") || string.startsWith(File.separator)) {
            return string;
        }
        return this.baseURI + string;
    }

    public InputStream getResourceAsStream(String string) {
        return this.context.getResourceAsStream(JspCompilationContext.canonicalURI(string));
    }

    public URL getResource(String string) throws MalformedURLException {
        return this.context.getResource(JspCompilationContext.canonicalURI(string));
    }

    public Set<String> getResourcePaths(String string) {
        return this.context.getResourcePaths(JspCompilationContext.canonicalURI(string));
    }

    public String getRealPath(String string) {
        if (this.context != null) {
            return this.context.getRealPath(string);
        }
        return string;
    }

    public Jar getTagFileJar() {
        return this.tagJar;
    }

    public void setTagFileJar(Jar jar) {
        this.tagJar = jar;
    }

    public String getServletClassName() {
        if (this.className != null) {
            return this.className;
        }
        if (this.isTagFile) {
            this.className = this.tagInfo.getTagClassName();
            int n = this.className.lastIndexOf(46);
            if (n != -1) {
                this.className = this.className.substring(n + 1);
            }
        } else {
            int n = this.jspUri.lastIndexOf(47) + 1;
            this.className = JspUtil.makeJavaIdentifier(this.jspUri.substring(n));
        }
        return this.className;
    }

    public void setServletClassName(String string) {
        this.className = string;
    }

    public String getJspFile() {
        return this.jspUri;
    }

    public Long getLastModified(String string) {
        return this.getLastModified(string, this.tagJar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Long getLastModified(String string, Jar jar) {
        URLConnection uRLConnection;
        long l;
        block21: {
            URL uRL;
            block22: {
                l = -1L;
                uRLConnection = null;
                if (jar != null) {
                    if (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    l = jar.getLastModified(string);
                    break block21;
                }
                uRL = this.getResource(string);
                if (uRL != null) break block22;
                this.incrementRemoved();
                Long l2 = l;
                if (uRLConnection == null) return l2;
                try {
                    uRLConnection.getInputStream().close();
                    return l2;
                }
                catch (IOException iOException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)Localizer.getMessage("jsp.error.lastModified", this.getJspFile()), (Throwable)iOException);
                    }
                    l = -1L;
                }
                return l2;
            }
            uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof JarURLConnection) {
                JarEntry jarEntry = ((JarURLConnection)uRLConnection).getJarEntry();
                l = jarEntry != null ? jarEntry.getTime() : uRLConnection.getLastModified();
                break block21;
            }
            l = uRLConnection.getLastModified();
        }
        if (uRLConnection == null) return l;
        try {
            uRLConnection.getInputStream().close();
            return l;
        }
        catch (IOException iOException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)Localizer.getMessage("jsp.error.lastModified", this.getJspFile()), (Throwable)iOException);
            }
            l = -1L;
        }
        return l;
        catch (IOException iOException) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)Localizer.getMessage("jsp.error.lastModified", this.getJspFile()), (Throwable)iOException);
                }
                l = -1L;
                if (uRLConnection == null) return l;
            }
            catch (Throwable throwable) {
                if (uRLConnection == null) throw throwable;
                try {
                    uRLConnection.getInputStream().close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)Localizer.getMessage("jsp.error.lastModified", this.getJspFile()), (Throwable)iOException2);
                    }
                    l = -1L;
                }
                throw throwable;
            }
            try {
                uRLConnection.getInputStream().close();
                return l;
            }
            catch (IOException iOException3) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)Localizer.getMessage("jsp.error.lastModified", this.getJspFile()), (Throwable)iOException3);
                }
                l = -1L;
            }
            return l;
        }
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    public void setTagInfo(TagInfo tagInfo) {
        this.tagInfo = tagInfo;
    }

    public boolean isPrototypeMode() {
        return this.protoTypeMode;
    }

    public void setPrototypeMode(boolean bl) {
        this.protoTypeMode = bl;
    }

    public String getServletPackageName() {
        if (this.isTagFile()) {
            String string = this.tagInfo.getTagClassName();
            int n = string.lastIndexOf(46);
            String string2 = "";
            if (n != -1) {
                string2 = string.substring(0, n);
            }
            return string2;
        }
        String string = this.getDerivedPackageName();
        if (string.length() == 0) {
            return this.basePackageName;
        }
        return this.basePackageName + '.' + this.getDerivedPackageName();
    }

    protected String getDerivedPackageName() {
        if (this.derivedPackageName == null) {
            int n = this.jspUri.lastIndexOf(47);
            this.derivedPackageName = n > 0 ? JspUtil.makeJavaPackage(this.jspUri.substring(1, n)) : "";
        }
        return this.derivedPackageName;
    }

    public String getBasePackageName() {
        return this.basePackageName;
    }

    public void setBasePackageName(String string) {
        this.basePackageName = string;
    }

    public String getServletJavaFileName() {
        if (this.servletJavaFileName == null) {
            this.servletJavaFileName = this.getOutputDir() + this.getServletClassName() + ".java";
        }
        return this.servletJavaFileName;
    }

    public Options getOptions() {
        return this.options;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public JspRuntimeContext getRuntimeContext() {
        return this.rctxt;
    }

    public String getJavaPath() {
        if (this.javaPath != null) {
            return this.javaPath;
        }
        if (this.isTagFile()) {
            String string = this.tagInfo.getTagClassName();
            this.javaPath = string.replace('.', '/') + ".java";
        } else {
            this.javaPath = this.getServletPackageName().replace('.', '/') + '/' + this.getServletClassName() + ".java";
        }
        return this.javaPath;
    }

    public String getClassFileName() {
        if (this.classFileName == null) {
            this.classFileName = this.getOutputDir() + this.getServletClassName() + ".class";
        }
        return this.classFileName;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public void setWriter(ServletWriter servletWriter) {
        this.writer = servletWriter;
    }

    public TldResourcePath getTldResourcePath(String string) {
        return this.getOptions().getTldCache().getTldResourcePath(string);
    }

    public boolean keepGenerated() {
        return this.getOptions().getKeepGenerated();
    }

    public void incrementRemoved() {
        if (!this.removed && this.rctxt != null) {
            this.rctxt.removeWrapper(this.jspUri);
        }
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void compile() throws JasperException, FileNotFoundException {
        this.createCompiler();
        if (this.jspCompiler.isOutDated()) {
            if (this.isRemoved()) {
                throw new FileNotFoundException(this.jspUri);
            }
            try {
                this.jspCompiler.removeGeneratedFiles();
                this.jspLoader = null;
                this.jspCompiler.compile();
                this.jsw.setReload(true);
                this.jsw.setCompilationException(null);
            }
            catch (JasperException jasperException) {
                this.jsw.setCompilationException(jasperException);
                if (this.options.getDevelopment() && this.options.getRecompileOnFail()) {
                    this.jsw.setLastModificationTest(-1L);
                }
                throw jasperException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (Exception exception) {
                JasperException jasperException = new JasperException(Localizer.getMessage("jsp.error.unable.compile"), exception);
                this.jsw.setCompilationException(jasperException);
                throw jasperException;
            }
        }
    }

    public Class<?> load() throws JasperException {
        try {
            this.getJspLoader();
            String string = this.getFQCN();
            this.servletClass = this.jspLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JasperException(Localizer.getMessage("jsp.error.unable.load"), classNotFoundException);
        }
        catch (Exception exception) {
            throw new JasperException(Localizer.getMessage("jsp.error.unable.compile"), exception);
        }
        this.removed = false;
        return this.servletClass;
    }

    public String getFQCN() {
        String string = this.isTagFile() ? this.tagInfo.getTagClassName() : this.getServletPackageName() + "." + this.getServletClassName();
        return string;
    }

    public void checkOutputDir() {
        if (this.outputDir != null) {
            if (!new File(this.outputDir).exists()) {
                this.makeOutputDir();
            }
        } else {
            this.createOutputDir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean makeOutputDir() {
        Object object = outputDirLock;
        synchronized (object) {
            File file = new File(this.outputDir);
            return file.mkdirs() || file.isDirectory();
        }
    }

    protected void createOutputDir() {
        Object object;
        String string = null;
        if (this.isTagFile()) {
            object = this.tagInfo.getTagClassName();
            string = ((String)object).replace('.', File.separatorChar);
            string = string.substring(0, string.lastIndexOf(File.separatorChar));
        } else {
            string = this.getServletPackageName().replace('.', File.separatorChar);
        }
        try {
            object = this.options.getScratchDir();
            this.baseUrl = ((File)object).toURI().toURL();
            this.outputDir = ((File)object).getAbsolutePath() + File.separator + string + File.separator;
            if (!this.makeOutputDir()) {
                this.log.error((Object)Localizer.getMessage("jsp.error.outputfolder.detail", this.outputDir));
                throw new IllegalStateException(Localizer.getMessage("jsp.error.outputfolder"));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(Localizer.getMessage("jsp.error.outputfolder"), malformedURLException);
        }
    }

    protected static final boolean isPathSeparator(char c) {
        return c == '/' || c == '\\';
    }

    protected static final String canonicalURI(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        int n2 = 0;
        block4: while (n2 < n) {
            char c = string.charAt(n2);
            if (JspCompilationContext.isPathSeparator(c)) {
                while (n2 + 1 < n && JspCompilationContext.isPathSeparator(string.charAt(n2 + 1))) {
                    ++n2;
                }
                if (n2 + 1 < n && string.charAt(n2 + 1) == '.') {
                    if (n2 + 2 >= n) break;
                    switch (string.charAt(n2 + 2)) {
                        case '/': 
                        case '\\': {
                            n2 += 2;
                            continue block4;
                        }
                        case '.': {
                            int n3;
                            if (n2 + 3 >= n || !JspCompilationContext.isPathSeparator(string.charAt(n2 + 3))) break;
                            n2 += 3;
                            for (n3 = stringBuilder.length() - 1; n3 >= 0 && !JspCompilationContext.isPathSeparator(stringBuilder.charAt(n3)); --n3) {
                            }
                            if (n3 < 0) continue block4;
                            stringBuilder.setLength(n3);
                            continue block4;
                        }
                    }
                }
            }
            stringBuilder.append(c);
            ++n2;
        }
        return stringBuilder.toString();
    }
}

