/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.presets;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.graalvm.visualvm.profiling.presets.ProfilerMemoryPanel;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;

final class ProfilerMemorySettings
extends JPanel {
    private ProfilerPreset preset;
    private final ProfilerMemoryPanel panel;

    ProfilerMemorySettings(Runnable validator) {
        this.panel = new ProfilerMemoryPanel(validator, true){

            @Override
            public void settingsChanged() {
                ProfilerMemorySettings.this.panel.saveToPreset(ProfilerMemorySettings.this.preset);
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel, "Center");
    }

    void setPreset(ProfilerPreset preset) {
        this.preset = preset;
        this.panel.loadFromPreset(preset);
    }

    boolean valid() {
        return this.panel.settingsValid();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }
}

