/* BackgroundImage.c generated by valac 0.56.2, the Vala compiler
 * generated from BackgroundImage.vala, do not modify */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_TYPE_BACKGROUND_IMAGE (greeter_background_image_get_type ())
#define GREETER_BACKGROUND_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_BACKGROUND_IMAGE, GreeterBackgroundImage))
#define GREETER_BACKGROUND_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_BACKGROUND_IMAGE, GreeterBackgroundImageClass))
#define GREETER_IS_BACKGROUND_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_BACKGROUND_IMAGE))
#define GREETER_IS_BACKGROUND_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_BACKGROUND_IMAGE))
#define GREETER_BACKGROUND_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_BACKGROUND_IMAGE, GreeterBackgroundImageClass))

typedef struct _GreeterBackgroundImage GreeterBackgroundImage;
typedef struct _GreeterBackgroundImageClass GreeterBackgroundImageClass;
typedef struct _GreeterBackgroundImagePrivate GreeterBackgroundImagePrivate;
enum  {
	GREETER_BACKGROUND_IMAGE_0_PROPERTY,
	GREETER_BACKGROUND_IMAGE_NUM_PROPERTIES
};
static GParamSpec* greeter_background_image_properties[GREETER_BACKGROUND_IMAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GreeterBackgroundImage {
	GtkEventBox parent_instance;
	GreeterBackgroundImagePrivate * priv;
};

struct _GreeterBackgroundImageClass {
	GtkEventBoxClass parent_class;
};

struct _GreeterBackgroundImagePrivate {
	guint last_size_hash;
	GdkPixbuf* full_pixbuf;
	GdkPixbuf* fitting_pixbuf;
};

static gint GreeterBackgroundImage_private_offset;
static gpointer greeter_background_image_parent_class = NULL;

VALA_EXTERN GType greeter_background_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterBackgroundImage, g_object_unref)
VALA_EXTERN GreeterBackgroundImage* greeter_background_image_new (const gchar* path);
VALA_EXTERN GreeterBackgroundImage* greeter_background_image_construct (GType object_type,
                                                            const gchar* path);
static gboolean greeter_background_image_real_draw (GtkWidget* base,
                                             cairo_t* cr);
static GObject * greeter_background_image_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void greeter_background_image_finalize (GObject * obj);
static GType greeter_background_image_get_type_once (void);

static inline gpointer
greeter_background_image_get_instance_private (GreeterBackgroundImage* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterBackgroundImage_private_offset);
}

GreeterBackgroundImage*
greeter_background_image_construct (GType object_type,
                                    const gchar* path)
{
	GreeterBackgroundImage * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (GreeterBackgroundImage*) g_object_new (object_type, NULL);
	if (path == NULL) {
		path = "/usr/share/backgrounds/elementaryos-default";
	}
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp1_ = gdk_pixbuf_new_from_file (path, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->full_pixbuf);
		self->priv->full_pixbuf = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("BackgroundImage.vala:18: %s", _tmp4_);
		g_critical ("BackgroundImage.vala:19: Fallback to default wallpaper");
		{
			GdkPixbuf* _tmp5_ = NULL;
			GdkPixbuf* _tmp6_;
			GdkPixbuf* _tmp7_;
			_tmp6_ = gdk_pixbuf_new_from_file ("/usr/share/backgrounds/elementaryos-default", &_inner_error0_);
			_tmp5_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp7_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (self->priv->full_pixbuf);
			self->priv->full_pixbuf = _tmp7_;
			_g_object_unref0 (_tmp5_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_critical ("BackgroundImage.vala:24: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_error_free0 (e);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

GreeterBackgroundImage*
greeter_background_image_new (const gchar* path)
{
	return greeter_background_image_construct (GREETER_TYPE_BACKGROUND_IMAGE, path);
}

static gboolean
greeter_background_image_real_draw (GtkWidget* base,
                                    cairo_t* cr)
{
	GreeterBackgroundImage * self;
	gint scale = 0;
	gint width = 0;
	gint height = 0;
	gint radius = 0;
	guint new_hash = 0U;
	GHashFunc _tmp0_;
	GHashFunc _tmp1_;
	GdkPixbuf* _tmp30_;
	gboolean result;
	self = (GreeterBackgroundImage*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	scale = gtk_widget_get_scale_factor ((GtkWidget*) self);
	width = gtk_widget_get_allocated_width ((GtkWidget*) self) * scale;
	height = gtk_widget_get_allocated_height ((GtkWidget*) self) * scale;
	radius = 5 * scale;
	_tmp0_ = g_int_hash;
	_tmp1_ = g_int_hash;
	new_hash = _tmp0_ (&width) + _tmp1_ (&height);
	if (new_hash != self->priv->last_size_hash) {
		gdouble full_ratio = 0.0;
		GdkPixbuf* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		GdkPixbuf* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GdkPixbuf* _tmp8_;
		GdkColorspace _tmp9_;
		GdkColorspace _tmp10_;
		GdkPixbuf* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		GdkPixbuf* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		GdkPixbuf* _tmp17_;
		GdkPixbuf* scaled_pixbuf = NULL;
		gint y = 0;
		GdkPixbuf* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint x = 0;
		GdkPixbuf* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		GdkPixbuf* _tmp28_;
		GdkPixbuf* _tmp29_;
		self->priv->last_size_hash = new_hash;
		_tmp2_ = self->priv->full_pixbuf;
		_tmp3_ = gdk_pixbuf_get_height (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->full_pixbuf;
		_tmp6_ = gdk_pixbuf_get_width (_tmp5_);
		_tmp7_ = _tmp6_;
		full_ratio = ((gdouble) _tmp4_) / ((gdouble) _tmp7_);
		_tmp8_ = self->priv->full_pixbuf;
		_tmp9_ = gdk_pixbuf_get_colorspace (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->full_pixbuf;
		_tmp12_ = gdk_pixbuf_get_has_alpha (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->full_pixbuf;
		_tmp15_ = gdk_pixbuf_get_bits_per_sample (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gdk_pixbuf_new (_tmp10_, _tmp13_, _tmp16_, width, height);
		_g_object_unref0 (self->priv->fitting_pixbuf);
		self->priv->fitting_pixbuf = _tmp17_;
		if (((gint) (width * full_ratio)) < height) {
			GdkPixbuf* _tmp18_;
			GdkPixbuf* _tmp19_;
			_tmp18_ = self->priv->full_pixbuf;
			_tmp19_ = gdk_pixbuf_scale_simple (_tmp18_, (gint) (width * (1 / full_ratio)), height, GDK_INTERP_BILINEAR);
			_g_object_unref0 (scaled_pixbuf);
			scaled_pixbuf = _tmp19_;
		} else {
			GdkPixbuf* _tmp20_;
			GdkPixbuf* _tmp21_;
			_tmp20_ = self->priv->full_pixbuf;
			_tmp21_ = gdk_pixbuf_scale_simple (_tmp20_, width, (gint) (width * full_ratio), GDK_INTERP_BILINEAR);
			_g_object_unref0 (scaled_pixbuf);
			scaled_pixbuf = _tmp21_;
		}
		_tmp22_ = scaled_pixbuf;
		_tmp23_ = gdk_pixbuf_get_height (_tmp22_);
		_tmp24_ = _tmp23_;
		y = abs ((height - _tmp24_) / 2);
		_tmp25_ = scaled_pixbuf;
		_tmp26_ = gdk_pixbuf_get_width (_tmp25_);
		_tmp27_ = _tmp26_;
		x = abs ((width - _tmp27_) / 2);
		_tmp28_ = scaled_pixbuf;
		_tmp29_ = self->priv->fitting_pixbuf;
		gdk_pixbuf_copy_area (_tmp28_, x, y, width, height, _tmp29_, 0, 0);
		_g_object_unref0 (scaled_pixbuf);
	}
	cairo_save (cr);
	cairo_scale (cr, 1.0 / scale, 1.0 / scale);
	cairo_new_sub_path (cr);
	cairo_arc (cr, (gdouble) (width - radius), (gdouble) radius, (gdouble) radius, -G_PI_2, (gdouble) 0);
	cairo_line_to (cr, (gdouble) width, (gdouble) height);
	cairo_line_to (cr, (gdouble) 0, (gdouble) height);
	cairo_arc (cr, (gdouble) radius, (gdouble) radius, (gdouble) radius, G_PI, G_PI + G_PI_2);
	cairo_close_path (cr);
	_tmp30_ = self->priv->fitting_pixbuf;
	gdk_cairo_set_source_pixbuf (cr, _tmp30_, (gdouble) 0, (gdouble) 0);
	cairo_clip (cr);
	cairo_paint (cr);
	cairo_restore (cr);
	result = TRUE;
	return result;
}

static GObject *
greeter_background_image_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterBackgroundImage * self;
	parent_class = G_OBJECT_CLASS (greeter_background_image_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_BACKGROUND_IMAGE, GreeterBackgroundImage);
	g_object_set ((GtkWidget*) self, "height-request", 150, NULL);
	return obj;
}

static void
greeter_background_image_class_init (GreeterBackgroundImageClass * klass,
                                     gpointer klass_data)
{
	greeter_background_image_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterBackgroundImage_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) greeter_background_image_real_draw;
	G_OBJECT_CLASS (klass)->constructor = greeter_background_image_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_background_image_finalize;
}

static void
greeter_background_image_instance_init (GreeterBackgroundImage * self,
                                        gpointer klass)
{
	self->priv = greeter_background_image_get_instance_private (self);
	self->priv->last_size_hash = (guint) 0;
}

static void
greeter_background_image_finalize (GObject * obj)
{
	GreeterBackgroundImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_BACKGROUND_IMAGE, GreeterBackgroundImage);
	_g_object_unref0 (self->priv->full_pixbuf);
	_g_object_unref0 (self->priv->fitting_pixbuf);
	G_OBJECT_CLASS (greeter_background_image_parent_class)->finalize (obj);
}

static GType
greeter_background_image_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterBackgroundImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_background_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterBackgroundImage), 0, (GInstanceInitFunc) greeter_background_image_instance_init, NULL };
	GType greeter_background_image_type_id;
	greeter_background_image_type_id = g_type_register_static (gtk_event_box_get_type (), "GreeterBackgroundImage", &g_define_type_info, 0);
	GreeterBackgroundImage_private_offset = g_type_add_instance_private (greeter_background_image_type_id, sizeof (GreeterBackgroundImagePrivate));
	return greeter_background_image_type_id;
}

GType
greeter_background_image_get_type (void)
{
	static volatile gsize greeter_background_image_type_id__once = 0;
	if (g_once_init_enter (&greeter_background_image_type_id__once)) {
		GType greeter_background_image_type_id;
		greeter_background_image_type_id = greeter_background_image_get_type_once ();
		g_once_init_leave (&greeter_background_image_type_id__once, greeter_background_image_type_id);
	}
	return greeter_background_image_type_id__once;
}

