/* gcalc-math-constant-complex.c generated by valac 0.56.1, the Vala compiler
 * generated from gcalc-math-constant-complex.vala, do not modify */

/* gcalc-math-constant-complex.vala
 *
 * Copyright (C) 2019  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include "gcalc/gcalc.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include "gcalc.h"

static GType gcalc_math_constant_complex_get_type_once (void);

/**
   * Returns the real part of the complex number
   */
gdouble
gcalc_math_constant_complex_real (GCalcMathConstantComplex* self)
{
	GCalcMathConstantComplexIface* _iface_;
	g_return_val_if_fail (self != NULL, 0.0);
	_iface_ = GCALC_MATH_CONSTANT_COMPLEX_GET_INTERFACE (self);
	if (_iface_->real) {
		return _iface_->real (self);
	}
	return -1.0;
}

/**
   * Returns the imaginary part of the complex number
   */
gdouble
gcalc_math_constant_complex_imag (GCalcMathConstantComplex* self)
{
	GCalcMathConstantComplexIface* _iface_;
	g_return_val_if_fail (self != NULL, 0.0);
	_iface_ = GCALC_MATH_CONSTANT_COMPLEX_GET_INTERFACE (self);
	if (_iface_->imag) {
		return _iface_->imag (self);
	}
	return -1.0;
}

/**
   * Set the complex number to zero
   */
void
gcalc_math_constant_complex_zero (GCalcMathConstantComplex* self)
{
	GCalcMathConstantComplexIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GCALC_MATH_CONSTANT_COMPLEX_GET_INTERFACE (self);
	if (_iface_->zero) {
		_iface_->zero (self);
	}
}

static void
gcalc_math_constant_complex_default_init (GCalcMathConstantComplexIface * iface,
                                          gpointer iface_data)
{
}

/**
 * A constant as a complex number with real and imaginary parts
 */
static GType
gcalc_math_constant_complex_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GCalcMathConstantComplexIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcalc_math_constant_complex_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gcalc_math_constant_complex_type_id;
	gcalc_math_constant_complex_type_id = g_type_register_static (G_TYPE_INTERFACE, "GCalcMathConstantComplex", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gcalc_math_constant_complex_type_id, G_TYPE_OBJECT);
	g_type_interface_add_prerequisite (gcalc_math_constant_complex_type_id, GCALC_TYPE_MATH_EXPRESSION);
	g_type_interface_add_prerequisite (gcalc_math_constant_complex_type_id, GCALC_TYPE_MATH_CONSTANT);
	return gcalc_math_constant_complex_type_id;
}

GType
gcalc_math_constant_complex_get_type (void)
{
	static volatile gsize gcalc_math_constant_complex_type_id__once = 0;
	if (g_once_init_enter (&gcalc_math_constant_complex_type_id__once)) {
		GType gcalc_math_constant_complex_type_id;
		gcalc_math_constant_complex_type_id = gcalc_math_constant_complex_get_type_once ();
		g_once_init_leave (&gcalc_math_constant_complex_type_id__once, gcalc_math_constant_complex_type_id);
	}
	return gcalc_math_constant_complex_type_id__once;
}

