/* math-function.c generated by valac 0.56.1, the Vala compiler
 * generated from math-function.vala, do not modify */

/*
 * Copyright (C) 2013 Garima Joshi
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "calculator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

enum  {
	MATH_FUNCTION_0_PROPERTY,
	MATH_FUNCTION_NAME_PROPERTY,
	MATH_FUNCTION_ARGUMENTS_PROPERTY,
	MATH_FUNCTION_EXPRESSION_PROPERTY,
	MATH_FUNCTION_DESCRIPTION_PROPERTY,
	MATH_FUNCTION_NUM_PROPERTIES
};
static GParamSpec* math_function_properties[MATH_FUNCTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_FUNCTION_PARSER (function_parser_get_type ())
#define FUNCTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_PARSER, FunctionParser))
#define FUNCTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_PARSER, FunctionParserClass))
#define IS_FUNCTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_PARSER))
#define IS_FUNCTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_PARSER))
#define FUNCTION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_PARSER, FunctionParserClass))

typedef struct _FunctionParser FunctionParser;
typedef struct _FunctionParserClass FunctionParserClass;
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FunctionParserPrivate FunctionParserPrivate;
enum  {
	BUILT_IN_MATH_FUNCTION_0_PROPERTY,
	BUILT_IN_MATH_FUNCTION_NUM_PROPERTIES
};
static GParamSpec* built_in_math_function_properties[BUILT_IN_MATH_FUNCTION_NUM_PROPERTIES];

struct _MathFunctionPrivate {
	gchar* _name;
	gchar** _arguments;
	gint _arguments_length1;
	gint __arguments_size_;
	gchar* _expression;
	gchar* _description;
};

struct _ExpressionParserPrivate {
	Parser* _root_parser;
};

struct _FunctionParser {
	ExpressionParser parent_instance;
	FunctionParserPrivate * priv;
};

struct _FunctionParserClass {
	ExpressionParserClass parent_class;
};

struct _FunctionParserPrivate {
	Number** _parameters;
	gint _parameters_length1;
	gint __parameters_size_;
	MathFunction* _function;
};

static gint MathFunction_private_offset;
static gpointer math_function_parent_class = NULL;
static gint ExpressionParser_private_offset;
static gpointer expression_parser_parent_class = NULL;
static gint FunctionParser_private_offset;
static gpointer function_parser_parent_class = NULL;
static gpointer built_in_math_function_parent_class = NULL;

static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static Number* math_function_real_evaluate (MathFunction* self,
                                     Number** args,
                                     gint args_length1,
                                     Parser* root_parser);
VALA_EXTERN GType function_parser_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FunctionParser* function_parser_new (MathFunction* function,
                                     Parser* root_parser,
                                     Number** parameters,
                                     gint parameters_length1);
VALA_EXTERN FunctionParser* function_parser_construct (GType object_type,
                                           MathFunction* function,
                                           Parser* root_parser,
                                           Number** parameters,
                                           gint parameters_length1);
static gboolean math_function_is_name_valid (MathFunction* self,
                                      const gchar* x);
static gboolean math_function_real_is_custom_function (MathFunction* self);
static void math_function_finalize (GObject * obj);
static GType math_function_get_type_once (void);
static void _vala_math_function_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static gboolean expression_parser_real_variable_is_defined (Parser* base,
                                                     const gchar* name);
static Number* expression_parser_real_get_variable (Parser* base,
                                             const gchar* name);
static gboolean expression_parser_real_function_is_defined (Parser* base,
                                                     const gchar* name);
static void expression_parser_finalize (Parser * obj);
static GType expression_parser_get_type_once (void);
static Number** _vala_array_dup6 (Number** self,
                           gssize length);
static gboolean function_parser_real_variable_is_defined (Parser* base,
                                                   const gchar* name);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static Number* function_parser_real_get_variable (Parser* base,
                                           const gchar* name);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
static void function_parser_finalize (Parser * obj);
static GType function_parser_get_type_once (void);
static Number* built_in_math_function_real_evaluate (MathFunction* base,
                                              Number** args,
                                              gint args_length1,
                                              Parser* root_parser);
VALA_EXTERN Number* evaluate_built_in_function (const gchar* name,
                                    Number** args,
                                    gint args_length1,
                                    Parser* root_parser);
static gboolean built_in_math_function_real_is_custom_function (MathFunction* base);
static GType built_in_math_function_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
math_function_get_instance_private (MathFunction* self)
{
	return G_STRUCT_MEMBER_P (self, MathFunction_private_offset);
}

gint
math_function_name_compare_func (MathFunction* function1,
                                 MathFunction* function2)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (function1 != NULL, 0);
	g_return_val_if_fail (function2 != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = math_function_get_name (function1);
	_tmp2_ = _tmp1_;
	_tmp3_ = math_function_get_name (function2);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

gboolean
math_function_name_equal_func (MathFunction* function1,
                               MathFunction* function2)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (function1 != NULL, FALSE);
	g_return_val_if_fail (function2 != NULL, FALSE);
	_tmp0_ = math_function_get_name (function1);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_function_get_name (function2);
	_tmp3_ = _tmp2_;
	result = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	return result;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

MathFunction*
math_function_construct (GType object_type,
                         const gchar* function_name,
                         gchar** arguments,
                         gint arguments_length1,
                         const gchar* expression,
                         const gchar* description)
{
	MathFunction * self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (function_name != NULL, NULL);
	self = (MathFunction*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (function_name);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	_tmp1_ = (arguments != NULL) ? _vala_array_dup5 (arguments, arguments_length1) : arguments;
	_tmp1__length1 = arguments_length1;
	self->priv->_arguments = (_vala_array_free (self->priv->_arguments, self->priv->_arguments_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_arguments = _tmp1_;
	self->priv->_arguments_length1 = _tmp1__length1;
	self->priv->__arguments_size_ = self->priv->_arguments_length1;
	if (expression != NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (expression);
		_g_free0 (self->priv->_expression);
		self->priv->_expression = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (self->priv->_expression);
		self->priv->_expression = _tmp3_;
	}
	if (description != NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (description);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp5_;
	}
	return self;
}

MathFunction*
math_function_new (const gchar* function_name,
                   gchar** arguments,
                   gint arguments_length1,
                   const gchar* expression,
                   const gchar* description)
{
	return math_function_construct (TYPE_MATH_FUNCTION, function_name, arguments, arguments_length1, expression, description);
}

static Number*
math_function_real_evaluate (MathFunction* self,
                             Number** args,
                             gint args_length1,
                             Parser* root_parser)
{
	FunctionParser* parser = NULL;
	FunctionParser* _tmp0_;
	guint representation_base = 0U;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	Number* ans = NULL;
	FunctionParser* _tmp1_;
	guint _tmp2_ = 0U;
	ErrorCode _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	Number* _tmp7_;
	const gchar* _tmp8_;
	Number* result;
	_tmp0_ = function_parser_new (self, root_parser, args, args_length1);
	parser = _tmp0_;
	_tmp1_ = parser;
	_tmp7_ = parser_parse ((Parser*) _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	representation_base = _tmp2_;
	error_code = _tmp3_;
	_g_free0 (error_token);
	error_token = _tmp4_;
	error_start = _tmp5_;
	error_end = _tmp6_;
	ans = _tmp7_;
	if (error_code == ERROR_CODE_NONE) {
		result = ans;
		_g_free0 (error_token);
		_parser_unref0 (parser);
		return result;
	}
	_tmp8_ = error_token;
	parser_set_error (root_parser, error_code, _tmp8_, error_start, error_end);
	result = NULL;
	_g_object_unref0 (ans);
	_g_free0 (error_token);
	_parser_unref0 (parser);
	return result;
}

Number*
math_function_evaluate (MathFunction* self,
                        Number** args,
                        gint args_length1,
                        Parser* root_parser)
{
	MathFunctionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = MATH_FUNCTION_GET_CLASS (self);
	if (_klass_->evaluate) {
		return _klass_->evaluate (self, args, args_length1, root_parser);
	}
	return NULL;
}

gboolean
math_function_validate (MathFunction* self,
                        Parser* root_parser)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	Number** args = NULL;
	Number** _tmp7_;
	gint args_length1;
	gint _args_size_;
	FunctionParser* parser = NULL;
	Number** _tmp8_;
	gint _tmp8__length1;
	FunctionParser* _tmp9_;
	guint representation_base = 0U;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	FunctionParser* _tmp10_;
	guint _tmp11_ = 0U;
	ErrorCode _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	const gchar* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_function_get_name (self);
	_tmp1_ = _tmp0_;
	if (!math_function_is_name_valid (self, _tmp1_)) {
		parser_set_error (root_parser, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
		result = FALSE;
		return result;
	}
	_tmp2_ = math_function_get_arguments (self, &_tmp3_);
	_tmp2__length1 = _tmp3_;
	_tmp4_ = _tmp2_;
	_tmp4__length1 = _tmp2__length1;
	{
		gchar** argument_collection = NULL;
		gint argument_collection_length1 = 0;
		gint _argument_collection_size_ = 0;
		gint argument_it = 0;
		argument_collection = _tmp4_;
		argument_collection_length1 = _tmp4__length1;
		for (argument_it = 0; argument_it < argument_collection_length1; argument_it = argument_it + 1) {
			gchar* _tmp5_;
			gchar* argument = NULL;
			_tmp5_ = g_strdup (argument_collection[argument_it]);
			argument = _tmp5_;
			{
				const gchar* _tmp6_;
				_tmp6_ = argument;
				if (!math_function_is_name_valid (self, _tmp6_)) {
					parser_set_error (root_parser, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
					result = FALSE;
					_g_free0 (argument);
					return result;
				}
				_g_free0 (argument);
			}
		}
	}
	_tmp7_ = g_new0 (Number*, 0 + 1);
	args = _tmp7_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp8_ = args;
	_tmp8__length1 = args_length1;
	_tmp9_ = function_parser_new (self, root_parser, _tmp8_, _tmp8__length1);
	parser = _tmp9_;
	_tmp10_ = parser;
	parser_create_parse_tree ((Parser*) _tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_);
	representation_base = _tmp11_;
	error_code = _tmp12_;
	_g_free0 (error_token);
	error_token = _tmp13_;
	error_start = _tmp14_;
	error_end = _tmp15_;
	if (error_code == ERROR_CODE_NONE) {
		result = TRUE;
		_g_free0 (error_token);
		_parser_unref0 (parser);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	_tmp16_ = error_token;
	parser_set_error (root_parser, error_code, _tmp16_, error_start, error_end);
	result = FALSE;
	_g_free0 (error_token);
	_parser_unref0 (parser);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gboolean
math_function_is_name_valid (MathFunction* self,
                             const gchar* x)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (x != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gunichar current_char = 0U;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = strlen (x);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				current_char = string_get_char (x, (glong) i);
				if (!g_unichar_isalpha (current_char)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
math_function_real_is_custom_function (MathFunction* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

gboolean
math_function_is_custom_function (MathFunction* self)
{
	MathFunctionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = MATH_FUNCTION_GET_CLASS (self);
	if (_klass_->is_custom_function) {
		return _klass_->is_custom_function (self);
	}
	return FALSE;
}

const gchar*
math_function_get_name (MathFunction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

gchar**
math_function_get_arguments (MathFunction* self,
                             gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_arguments;
	_tmp0__length1 = self->priv->_arguments_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

const gchar*
math_function_get_expression (MathFunction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}

const gchar*
math_function_get_description (MathFunction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
math_function_class_init (MathFunctionClass * klass,
                          gpointer klass_data)
{
	math_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathFunction_private_offset);
	((MathFunctionClass *) klass)->evaluate = (Number* (*) (MathFunction*, Number**, gint, Parser*)) math_function_real_evaluate;
	((MathFunctionClass *) klass)->is_custom_function = (gboolean (*) (MathFunction*)) math_function_real_is_custom_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_function_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_function_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_NAME_PROPERTY, math_function_properties[MATH_FUNCTION_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_ARGUMENTS_PROPERTY, math_function_properties[MATH_FUNCTION_ARGUMENTS_PROPERTY] = g_param_spec_boxed ("arguments", "arguments", "arguments", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_EXPRESSION_PROPERTY, math_function_properties[MATH_FUNCTION_EXPRESSION_PROPERTY] = g_param_spec_string ("expression", "expression", "expression", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_DESCRIPTION_PROPERTY, math_function_properties[MATH_FUNCTION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
math_function_instance_init (MathFunction * self,
                             gpointer klass)
{
	self->priv = math_function_get_instance_private (self);
}

static void
math_function_finalize (GObject * obj)
{
	MathFunction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_FUNCTION, MathFunction);
	_g_free0 (self->priv->_name);
	self->priv->_arguments = (_vala_array_free (self->priv->_arguments, self->priv->_arguments_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_expression);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (math_function_parent_class)->finalize (obj);
}

static GType
math_function_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathFunction), 0, (GInstanceInitFunc) math_function_instance_init, NULL };
	GType math_function_type_id;
	math_function_type_id = g_type_register_static (G_TYPE_OBJECT, "MathFunction", &g_define_type_info, 0);
	MathFunction_private_offset = g_type_add_instance_private (math_function_type_id, sizeof (MathFunctionPrivate));
	return math_function_type_id;
}

GType
math_function_get_type (void)
{
	static volatile gsize math_function_type_id__once = 0;
	if (g_once_init_enter (&math_function_type_id__once)) {
		GType math_function_type_id;
		math_function_type_id = math_function_get_type_once ();
		g_once_init_leave (&math_function_type_id__once, math_function_type_id);
	}
	return math_function_type_id__once;
}

static void
_vala_math_function_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	MathFunction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_FUNCTION, MathFunction);
	switch (property_id) {
		case MATH_FUNCTION_NAME_PROPERTY:
		g_value_set_string (value, math_function_get_name (self));
		break;
		case MATH_FUNCTION_ARGUMENTS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, math_function_get_arguments (self, &length));
		}
		break;
		case MATH_FUNCTION_EXPRESSION_PROPERTY:
		g_value_set_string (value, math_function_get_expression (self));
		break;
		case MATH_FUNCTION_DESCRIPTION_PROPERTY:
		g_value_set_string (value, math_function_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
expression_parser_get_instance_private (ExpressionParser* self)
{
	return G_STRUCT_MEMBER_P (self, ExpressionParser_private_offset);
}

static gpointer
_parser_ref0 (gpointer self)
{
	return self ? parser_ref (self) : NULL;
}

ExpressionParser*
expression_parser_construct (GType object_type,
                             const gchar* expression,
                             Parser* root_parser)
{
	ExpressionParser* self = NULL;
	Parser* _tmp0_;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (ExpressionParser*) parser_construct (object_type, expression, root_parser->number_base, root_parser->wordlen, root_parser->angle_units);
	_tmp0_ = _parser_ref0 (root_parser);
	_parser_unref0 (self->priv->_root_parser);
	self->priv->_root_parser = _tmp0_;
	return self;
}

ExpressionParser*
expression_parser_new (const gchar* expression,
                       Parser* root_parser)
{
	return expression_parser_construct (TYPE_EXPRESSION_PARSER, expression, root_parser);
}

static gboolean
expression_parser_real_variable_is_defined (Parser* base,
                                            const gchar* name)
{
	ExpressionParser * self;
	Parser* _tmp0_;
	gboolean result;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	if (PARSER_CLASS (expression_parser_parent_class)->variable_is_defined (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), name)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_root_parser;
	result = parser_variable_is_defined (_tmp0_, name);
	return result;
}

static Number*
expression_parser_real_get_variable (Parser* base,
                                     const gchar* name)
{
	ExpressionParser * self;
	Number* value = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Parser* _tmp2_;
	Number* _tmp3_;
	Number* result;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = PARSER_CLASS (expression_parser_parent_class)->get_variable (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), name);
	value = _tmp0_;
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		result = value;
		return result;
	}
	_tmp2_ = self->priv->_root_parser;
	_tmp3_ = parser_get_variable (_tmp2_, name);
	result = _tmp3_;
	_g_object_unref0 (value);
	return result;
}

static gboolean
expression_parser_real_function_is_defined (Parser* base,
                                            const gchar* name)
{
	ExpressionParser * self;
	Parser* _tmp0_;
	gboolean result;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	if (PARSER_CLASS (expression_parser_parent_class)->function_is_defined (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), name)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_root_parser;
	result = parser_function_is_defined (_tmp0_, name);
	return result;
}

static void
expression_parser_class_init (ExpressionParserClass * klass,
                              gpointer klass_data)
{
	expression_parser_parent_class = g_type_class_peek_parent (klass);
	((ParserClass *) klass)->finalize = expression_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ExpressionParser_private_offset);
	((ParserClass *) klass)->variable_is_defined = (gboolean (*) (Parser*, const gchar*)) expression_parser_real_variable_is_defined;
	((ParserClass *) klass)->get_variable = (Number* (*) (Parser*, const gchar*)) expression_parser_real_get_variable;
	((ParserClass *) klass)->function_is_defined = (gboolean (*) (Parser*, const gchar*)) expression_parser_real_function_is_defined;
}

static void
expression_parser_instance_init (ExpressionParser * self,
                                 gpointer klass)
{
	self->priv = expression_parser_get_instance_private (self);
}

static void
expression_parser_finalize (Parser * obj)
{
	ExpressionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPRESSION_PARSER, ExpressionParser);
	_parser_unref0 (self->priv->_root_parser);
	PARSER_CLASS (expression_parser_parent_class)->finalize (obj);
}

static GType
expression_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExpressionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) expression_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExpressionParser), 0, (GInstanceInitFunc) expression_parser_instance_init, NULL };
	GType expression_parser_type_id;
	expression_parser_type_id = g_type_register_static (TYPE_PARSER, "ExpressionParser", &g_define_type_info, 0);
	ExpressionParser_private_offset = g_type_add_instance_private (expression_parser_type_id, sizeof (ExpressionParserPrivate));
	return expression_parser_type_id;
}

GType
expression_parser_get_type (void)
{
	static volatile gsize expression_parser_type_id__once = 0;
	if (g_once_init_enter (&expression_parser_type_id__once)) {
		GType expression_parser_type_id;
		expression_parser_type_id = expression_parser_get_type_once ();
		g_once_init_leave (&expression_parser_type_id__once, expression_parser_type_id);
	}
	return expression_parser_type_id__once;
}

static inline gpointer
function_parser_get_instance_private (FunctionParser* self)
{
	return G_STRUCT_MEMBER_P (self, FunctionParser_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Number**
_vala_array_dup6 (Number** self,
                  gssize length)
{
	if (length >= 0) {
		Number** result;
		gssize i;
		result = g_new0 (Number*, length + 1);
		for (i = 0; i < length; i++) {
			Number* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

FunctionParser*
function_parser_construct (GType object_type,
                           MathFunction* function,
                           Parser* root_parser,
                           Number** parameters,
                           gint parameters_length1)
{
	FunctionParser* self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	MathFunction* _tmp2_;
	Number** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (function != NULL, NULL);
	_tmp0_ = math_function_get_expression (function);
	_tmp1_ = _tmp0_;
	self = (FunctionParser*) expression_parser_construct (object_type, _tmp1_, root_parser);
	_tmp2_ = _g_object_ref0 (function);
	_g_object_unref0 (self->priv->_function);
	self->priv->_function = _tmp2_;
	_tmp3_ = (parameters != NULL) ? _vala_array_dup6 (parameters, parameters_length1) : parameters;
	_tmp3__length1 = parameters_length1;
	self->priv->_parameters = (_vala_array_free (self->priv->_parameters, self->priv->_parameters_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_parameters = _tmp3_;
	self->priv->_parameters_length1 = _tmp3__length1;
	self->priv->__parameters_size_ = self->priv->_parameters_length1;
	return self;
}

FunctionParser*
function_parser_new (MathFunction* function,
                     Parser* root_parser,
                     Number** parameters,
                     gint parameters_length1)
{
	return function_parser_construct (TYPE_FUNCTION_PARSER, function, root_parser, parameters, parameters_length1);
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
function_parser_real_variable_is_defined (Parser* base,
                                          const gchar* name)
{
	FunctionParser * self;
	gchar** argument_names = NULL;
	MathFunction* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint argument_names_length1;
	gint _argument_names_size_;
	gboolean result;
	self = (FunctionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->_function;
	_tmp1_ = math_function_get_arguments (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup7 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	argument_names = _tmp4_;
	argument_names_length1 = _tmp4__length1;
	_argument_names_size_ = argument_names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = argument_names;
				_tmp7__length1 = argument_names_length1;
				if (!(i < _tmp7__length1)) {
					break;
				}
				_tmp8_ = argument_names;
				_tmp8__length1 = argument_names_length1;
				_tmp9_ = _tmp8_[i];
				if (g_strcmp0 (_tmp9_, name) == 0) {
					result = TRUE;
					argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	result = PARSER_CLASS (function_parser_parent_class)->variable_is_defined ((Parser*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EXPRESSION_PARSER, ExpressionParser), name);
	argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static Number*
function_parser_real_get_variable (Parser* base,
                                   const gchar* name)
{
	FunctionParser * self;
	gchar** argument_names = NULL;
	MathFunction* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint argument_names_length1;
	gint _argument_names_size_;
	Number* _tmp14_;
	Number* result;
	self = (FunctionParser*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->_function;
	_tmp1_ = math_function_get_arguments (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup8 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	argument_names = _tmp4_;
	argument_names_length1 = _tmp4__length1;
	_argument_names_size_ = argument_names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = argument_names;
				_tmp7__length1 = argument_names_length1;
				if (!(i < _tmp7__length1)) {
					break;
				}
				_tmp8_ = argument_names;
				_tmp8__length1 = argument_names_length1;
				_tmp9_ = _tmp8_[i];
				if (g_strcmp0 (_tmp9_, name) == 0) {
					Number** _tmp10_;
					gint _tmp10__length1;
					_tmp10_ = self->priv->_parameters;
					_tmp10__length1 = self->priv->_parameters_length1;
					if (_tmp10__length1 > i) {
						Number** _tmp11_;
						gint _tmp11__length1;
						Number* _tmp12_;
						Number* _tmp13_;
						_tmp11_ = self->priv->_parameters;
						_tmp11__length1 = self->priv->_parameters_length1;
						_tmp12_ = _tmp11_[i];
						_tmp13_ = _g_object_ref0 (_tmp12_);
						result = _tmp13_;
						argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					result = NULL;
					argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	_tmp14_ = PARSER_CLASS (function_parser_parent_class)->get_variable ((Parser*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EXPRESSION_PARSER, ExpressionParser), name);
	result = _tmp14_;
	argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
function_parser_class_init (FunctionParserClass * klass,
                            gpointer klass_data)
{
	function_parser_parent_class = g_type_class_peek_parent (klass);
	((ParserClass *) klass)->finalize = function_parser_finalize;
	g_type_class_adjust_private_offset (klass, &FunctionParser_private_offset);
	((ParserClass *) klass)->variable_is_defined = (gboolean (*) (Parser*, const gchar*)) function_parser_real_variable_is_defined;
	((ParserClass *) klass)->get_variable = (Number* (*) (Parser*, const gchar*)) function_parser_real_get_variable;
}

static void
function_parser_instance_init (FunctionParser * self,
                               gpointer klass)
{
	self->priv = function_parser_get_instance_private (self);
}

static void
function_parser_finalize (Parser * obj)
{
	FunctionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FUNCTION_PARSER, FunctionParser);
	self->priv->_parameters = (_vala_array_free (self->priv->_parameters, self->priv->_parameters_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->_function);
	PARSER_CLASS (function_parser_parent_class)->finalize (obj);
}

static GType
function_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FunctionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionParser), 0, (GInstanceInitFunc) function_parser_instance_init, NULL };
	GType function_parser_type_id;
	function_parser_type_id = g_type_register_static (TYPE_EXPRESSION_PARSER, "FunctionParser", &g_define_type_info, 0);
	FunctionParser_private_offset = g_type_add_instance_private (function_parser_type_id, sizeof (FunctionParserPrivate));
	return function_parser_type_id;
}

GType
function_parser_get_type (void)
{
	static volatile gsize function_parser_type_id__once = 0;
	if (g_once_init_enter (&function_parser_type_id__once)) {
		GType function_parser_type_id;
		function_parser_type_id = function_parser_get_type_once ();
		g_once_init_leave (&function_parser_type_id__once, function_parser_type_id);
	}
	return function_parser_type_id__once;
}

BuiltInMathFunction*
built_in_math_function_construct (GType object_type,
                                  const gchar* function_name,
                                  const gchar* description)
{
	BuiltInMathFunction * self = NULL;
	gchar** arguments = NULL;
	gchar** _tmp0_;
	gint arguments_length1;
	gint _arguments_size_;
	gchar* expression = NULL;
	gchar* _tmp1_;
	g_return_val_if_fail (function_name != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	arguments = _tmp0_;
	arguments_length1 = 0;
	_arguments_size_ = arguments_length1;
	_tmp1_ = g_strdup ("");
	expression = _tmp1_;
	self = (BuiltInMathFunction*) math_function_construct (object_type, function_name, arguments, (gint) arguments_length1, expression, description);
	_g_free0 (expression);
	arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

BuiltInMathFunction*
built_in_math_function_new (const gchar* function_name,
                            const gchar* description)
{
	return built_in_math_function_construct (TYPE_BUILT_IN_MATH_FUNCTION, function_name, description);
}

static Number*
built_in_math_function_real_evaluate (MathFunction* base,
                                      Number** args,
                                      gint args_length1,
                                      Parser* root_parser)
{
	BuiltInMathFunction * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	Number* _tmp2_;
	Number* result;
	self = (BuiltInMathFunction*) base;
	_tmp0_ = math_function_get_name ((MathFunction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = evaluate_built_in_function (_tmp1_, args, (gint) args_length1, root_parser);
	result = _tmp2_;
	return result;
}

static gboolean
built_in_math_function_real_is_custom_function (MathFunction* base)
{
	BuiltInMathFunction * self;
	gboolean result;
	self = (BuiltInMathFunction*) base;
	result = FALSE;
	return result;
}

static void
built_in_math_function_class_init (BuiltInMathFunctionClass * klass,
                                   gpointer klass_data)
{
	built_in_math_function_parent_class = g_type_class_peek_parent (klass);
	((MathFunctionClass *) klass)->evaluate = (Number* (*) (MathFunction*, Number**, gint, Parser*)) built_in_math_function_real_evaluate;
	((MathFunctionClass *) klass)->is_custom_function = (gboolean (*) (MathFunction*)) built_in_math_function_real_is_custom_function;
}

static void
built_in_math_function_instance_init (BuiltInMathFunction * self,
                                      gpointer klass)
{
}

static GType
built_in_math_function_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BuiltInMathFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) built_in_math_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuiltInMathFunction), 0, (GInstanceInitFunc) built_in_math_function_instance_init, NULL };
	GType built_in_math_function_type_id;
	built_in_math_function_type_id = g_type_register_static (TYPE_MATH_FUNCTION, "BuiltInMathFunction", &g_define_type_info, 0);
	return built_in_math_function_type_id;
}

GType
built_in_math_function_get_type (void)
{
	static volatile gsize built_in_math_function_type_id__once = 0;
	if (g_once_init_enter (&built_in_math_function_type_id__once)) {
		GType built_in_math_function_type_id;
		built_in_math_function_type_id = built_in_math_function_get_type_once ();
		g_once_init_leave (&built_in_math_function_type_id__once, built_in_math_function_type_id);
	}
	return built_in_math_function_type_id__once;
}

Number*
evaluate_built_in_function (const gchar* name,
                            Number** args,
                            gint args_length1,
                            Parser* root_parser)
{
	gchar* lower_name = NULL;
	gchar* _tmp0_;
	Number* x = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	const gchar* _tmp3_;
	Number* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_utf8_strdown (name, (gssize) -1);
	lower_name = _tmp0_;
	_tmp1_ = args[0];
	_tmp2_ = _g_object_ref0 (_tmp1_);
	x = _tmp2_;
	_tmp3_ = lower_name;
	if (g_strcmp0 (_tmp3_, "log") == 0) {
		if (args_length1 <= 1) {
			Number* _tmp4_;
			Number* _tmp5_;
			_tmp4_ = x;
			_tmp5_ = number_logarithm (_tmp4_, (gint64) 10);
			result = _tmp5_;
			_g_object_unref0 (x);
			_g_free0 (lower_name);
			return result;
		} else {
			gint64 log_base = 0LL;
			Number* _tmp6_;
			_tmp6_ = args[1];
			log_base = number_to_integer (_tmp6_);
			if (log_base < ((gint64) 0)) {
				result = NULL;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			} else {
				Number* _tmp7_;
				Number* _tmp8_;
				_tmp7_ = x;
				_tmp8_ = number_logarithm (_tmp7_, log_base);
				result = _tmp8_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else {
		const gchar* _tmp9_;
		_tmp9_ = lower_name;
		if (g_strcmp0 (_tmp9_, "ln") == 0) {
			Number* _tmp10_;
			Number* _tmp11_;
			_tmp10_ = x;
			_tmp11_ = number_ln (_tmp10_);
			result = _tmp11_;
			_g_object_unref0 (x);
			_g_free0 (lower_name);
			return result;
		} else {
			const gchar* _tmp12_;
			_tmp12_ = lower_name;
			if (g_strcmp0 (_tmp12_, "sqrt") == 0) {
				Number* _tmp13_;
				Number* _tmp14_;
				_tmp13_ = x;
				_tmp14_ = number_sqrt (_tmp13_);
				result = _tmp14_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = lower_name;
				if (g_strcmp0 (_tmp15_, "abs") == 0) {
					Number* _tmp16_;
					Number* _tmp17_;
					_tmp16_ = x;
					_tmp17_ = number_abs (_tmp16_);
					result = _tmp17_;
					_g_object_unref0 (x);
					_g_free0 (lower_name);
					return result;
				} else {
					const gchar* _tmp18_;
					_tmp18_ = lower_name;
					if (g_strcmp0 (_tmp18_, "sgn") == 0) {
						Number* _tmp19_;
						Number* _tmp20_;
						_tmp19_ = x;
						_tmp20_ = number_sgn (_tmp19_);
						result = _tmp20_;
						_g_object_unref0 (x);
						_g_free0 (lower_name);
						return result;
					} else {
						const gchar* _tmp21_;
						_tmp21_ = lower_name;
						if (g_strcmp0 (_tmp21_, "arg") == 0) {
							Number* _tmp22_;
							Number* _tmp23_;
							_tmp22_ = x;
							_tmp23_ = number_arg (_tmp22_, root_parser->angle_units);
							result = _tmp23_;
							_g_object_unref0 (x);
							_g_free0 (lower_name);
							return result;
						} else {
							const gchar* _tmp24_;
							_tmp24_ = lower_name;
							if (g_strcmp0 (_tmp24_, "conj") == 0) {
								Number* _tmp25_;
								Number* _tmp26_;
								_tmp25_ = x;
								_tmp26_ = number_conjugate (_tmp25_);
								result = _tmp26_;
								_g_object_unref0 (x);
								_g_free0 (lower_name);
								return result;
							} else {
								const gchar* _tmp27_;
								_tmp27_ = lower_name;
								if (g_strcmp0 (_tmp27_, "int") == 0) {
									Number* _tmp28_;
									Number* _tmp29_;
									_tmp28_ = x;
									_tmp29_ = number_integer_component (_tmp28_);
									result = _tmp29_;
									_g_object_unref0 (x);
									_g_free0 (lower_name);
									return result;
								} else {
									const gchar* _tmp30_;
									_tmp30_ = lower_name;
									if (g_strcmp0 (_tmp30_, "frac") == 0) {
										Number* _tmp31_;
										Number* _tmp32_;
										_tmp31_ = x;
										_tmp32_ = number_fractional_component (_tmp31_);
										result = _tmp32_;
										_g_object_unref0 (x);
										_g_free0 (lower_name);
										return result;
									} else {
										const gchar* _tmp33_;
										_tmp33_ = lower_name;
										if (g_strcmp0 (_tmp33_, "floor") == 0) {
											Number* _tmp34_;
											Number* _tmp35_;
											_tmp34_ = x;
											_tmp35_ = number_floor (_tmp34_);
											result = _tmp35_;
											_g_object_unref0 (x);
											_g_free0 (lower_name);
											return result;
										} else {
											const gchar* _tmp36_;
											_tmp36_ = lower_name;
											if (g_strcmp0 (_tmp36_, "ceil") == 0) {
												Number* _tmp37_;
												Number* _tmp38_;
												_tmp37_ = x;
												_tmp38_ = number_ceiling (_tmp37_);
												result = _tmp38_;
												_g_object_unref0 (x);
												_g_free0 (lower_name);
												return result;
											} else {
												const gchar* _tmp39_;
												_tmp39_ = lower_name;
												if (g_strcmp0 (_tmp39_, "round") == 0) {
													Number* _tmp40_;
													Number* _tmp41_;
													_tmp40_ = x;
													_tmp41_ = number_round (_tmp40_);
													result = _tmp41_;
													_g_object_unref0 (x);
													_g_free0 (lower_name);
													return result;
												} else {
													const gchar* _tmp42_;
													_tmp42_ = lower_name;
													if (g_strcmp0 (_tmp42_, "re") == 0) {
														Number* _tmp43_;
														Number* _tmp44_;
														_tmp43_ = x;
														_tmp44_ = number_real_component (_tmp43_);
														result = _tmp44_;
														_g_object_unref0 (x);
														_g_free0 (lower_name);
														return result;
													} else {
														const gchar* _tmp45_;
														_tmp45_ = lower_name;
														if (g_strcmp0 (_tmp45_, "im") == 0) {
															Number* _tmp46_;
															Number* _tmp47_;
															_tmp46_ = x;
															_tmp47_ = number_imaginary_component (_tmp46_);
															result = _tmp47_;
															_g_object_unref0 (x);
															_g_free0 (lower_name);
															return result;
														} else {
															const gchar* _tmp48_;
															_tmp48_ = lower_name;
															if (g_strcmp0 (_tmp48_, "sin") == 0) {
																Number* _tmp49_;
																Number* _tmp50_;
																_tmp49_ = x;
																_tmp50_ = number_sin (_tmp49_, root_parser->angle_units);
																result = _tmp50_;
																_g_object_unref0 (x);
																_g_free0 (lower_name);
																return result;
															} else {
																const gchar* _tmp51_;
																_tmp51_ = lower_name;
																if (g_strcmp0 (_tmp51_, "cos") == 0) {
																	Number* _tmp52_;
																	Number* _tmp53_;
																	_tmp52_ = x;
																	_tmp53_ = number_cos (_tmp52_, root_parser->angle_units);
																	result = _tmp53_;
																	_g_object_unref0 (x);
																	_g_free0 (lower_name);
																	return result;
																} else {
																	const gchar* _tmp54_;
																	_tmp54_ = lower_name;
																	if (g_strcmp0 (_tmp54_, "tan") == 0) {
																		Number* _tmp55_;
																		Number* _tmp56_;
																		_tmp55_ = x;
																		_tmp56_ = number_tan (_tmp55_, root_parser->angle_units);
																		result = _tmp56_;
																		_g_object_unref0 (x);
																		_g_free0 (lower_name);
																		return result;
																	} else {
																		gboolean _tmp57_ = FALSE;
																		const gchar* _tmp58_;
																		_tmp58_ = lower_name;
																		if (g_strcmp0 (_tmp58_, "sin⁻¹") == 0) {
																			_tmp57_ = TRUE;
																		} else {
																			const gchar* _tmp59_;
																			_tmp59_ = lower_name;
																			_tmp57_ = g_strcmp0 (_tmp59_, "asin") == 0;
																		}
																		if (_tmp57_) {
																			Number* _tmp60_;
																			Number* _tmp61_;
																			_tmp60_ = x;
																			_tmp61_ = number_asin (_tmp60_, root_parser->angle_units);
																			result = _tmp61_;
																			_g_object_unref0 (x);
																			_g_free0 (lower_name);
																			return result;
																		} else {
																			gboolean _tmp62_ = FALSE;
																			const gchar* _tmp63_;
																			_tmp63_ = lower_name;
																			if (g_strcmp0 (_tmp63_, "cos⁻¹") == 0) {
																				_tmp62_ = TRUE;
																			} else {
																				const gchar* _tmp64_;
																				_tmp64_ = lower_name;
																				_tmp62_ = g_strcmp0 (_tmp64_, "acos") == 0;
																			}
																			if (_tmp62_) {
																				Number* _tmp65_;
																				Number* _tmp66_;
																				_tmp65_ = x;
																				_tmp66_ = number_acos (_tmp65_, root_parser->angle_units);
																				result = _tmp66_;
																				_g_object_unref0 (x);
																				_g_free0 (lower_name);
																				return result;
																			} else {
																				gboolean _tmp67_ = FALSE;
																				const gchar* _tmp68_;
																				_tmp68_ = lower_name;
																				if (g_strcmp0 (_tmp68_, "tan⁻¹") == 0) {
																					_tmp67_ = TRUE;
																				} else {
																					const gchar* _tmp69_;
																					_tmp69_ = lower_name;
																					_tmp67_ = g_strcmp0 (_tmp69_, "atan") == 0;
																				}
																				if (_tmp67_) {
																					Number* _tmp70_;
																					Number* _tmp71_;
																					_tmp70_ = x;
																					_tmp71_ = number_atan (_tmp70_, root_parser->angle_units);
																					result = _tmp71_;
																					_g_object_unref0 (x);
																					_g_free0 (lower_name);
																					return result;
																				} else {
																					const gchar* _tmp72_;
																					_tmp72_ = lower_name;
																					if (g_strcmp0 (_tmp72_, "sinh") == 0) {
																						Number* _tmp73_;
																						Number* _tmp74_;
																						_tmp73_ = x;
																						_tmp74_ = number_sinh (_tmp73_);
																						result = _tmp74_;
																						_g_object_unref0 (x);
																						_g_free0 (lower_name);
																						return result;
																					} else {
																						const gchar* _tmp75_;
																						_tmp75_ = lower_name;
																						if (g_strcmp0 (_tmp75_, "cosh") == 0) {
																							Number* _tmp76_;
																							Number* _tmp77_;
																							_tmp76_ = x;
																							_tmp77_ = number_cosh (_tmp76_);
																							result = _tmp77_;
																							_g_object_unref0 (x);
																							_g_free0 (lower_name);
																							return result;
																						} else {
																							const gchar* _tmp78_;
																							_tmp78_ = lower_name;
																							if (g_strcmp0 (_tmp78_, "tanh") == 0) {
																								Number* _tmp79_;
																								Number* _tmp80_;
																								_tmp79_ = x;
																								_tmp80_ = number_tanh (_tmp79_);
																								result = _tmp80_;
																								_g_object_unref0 (x);
																								_g_free0 (lower_name);
																								return result;
																							} else {
																								gboolean _tmp81_ = FALSE;
																								const gchar* _tmp82_;
																								_tmp82_ = lower_name;
																								if (g_strcmp0 (_tmp82_, "sinh⁻¹") == 0) {
																									_tmp81_ = TRUE;
																								} else {
																									const gchar* _tmp83_;
																									_tmp83_ = lower_name;
																									_tmp81_ = g_strcmp0 (_tmp83_, "asinh") == 0;
																								}
																								if (_tmp81_) {
																									Number* _tmp84_;
																									Number* _tmp85_;
																									_tmp84_ = x;
																									_tmp85_ = number_asinh (_tmp84_);
																									result = _tmp85_;
																									_g_object_unref0 (x);
																									_g_free0 (lower_name);
																									return result;
																								} else {
																									gboolean _tmp86_ = FALSE;
																									const gchar* _tmp87_;
																									_tmp87_ = lower_name;
																									if (g_strcmp0 (_tmp87_, "cosh⁻¹") == 0) {
																										_tmp86_ = TRUE;
																									} else {
																										const gchar* _tmp88_;
																										_tmp88_ = lower_name;
																										_tmp86_ = g_strcmp0 (_tmp88_, "acosh") == 0;
																									}
																									if (_tmp86_) {
																										Number* _tmp89_;
																										Number* _tmp90_;
																										_tmp89_ = x;
																										_tmp90_ = number_acosh (_tmp89_);
																										result = _tmp90_;
																										_g_object_unref0 (x);
																										_g_free0 (lower_name);
																										return result;
																									} else {
																										gboolean _tmp91_ = FALSE;
																										const gchar* _tmp92_;
																										_tmp92_ = lower_name;
																										if (g_strcmp0 (_tmp92_, "tanh⁻¹") == 0) {
																											_tmp91_ = TRUE;
																										} else {
																											const gchar* _tmp93_;
																											_tmp93_ = lower_name;
																											_tmp91_ = g_strcmp0 (_tmp93_, "atanh") == 0;
																										}
																										if (_tmp91_) {
																											Number* _tmp94_;
																											Number* _tmp95_;
																											_tmp94_ = x;
																											_tmp95_ = number_atanh (_tmp94_);
																											result = _tmp95_;
																											_g_object_unref0 (x);
																											_g_free0 (lower_name);
																											return result;
																										} else {
																											const gchar* _tmp96_;
																											_tmp96_ = lower_name;
																											if (g_strcmp0 (_tmp96_, "ones") == 0) {
																												Number* _tmp97_;
																												Number* _tmp98_;
																												_tmp97_ = x;
																												_tmp98_ = number_ones_complement (_tmp97_, root_parser->wordlen);
																												result = _tmp98_;
																												_g_object_unref0 (x);
																												_g_free0 (lower_name);
																												return result;
																											} else {
																												const gchar* _tmp99_;
																												_tmp99_ = lower_name;
																												if (g_strcmp0 (_tmp99_, "twos") == 0) {
																													Number* _tmp100_;
																													Number* _tmp101_;
																													_tmp100_ = x;
																													_tmp101_ = number_twos_complement (_tmp100_, root_parser->wordlen);
																													result = _tmp101_;
																													_g_object_unref0 (x);
																													_g_free0 (lower_name);
																													return result;
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	_g_object_unref0 (x);
	_g_free0 (lower_name);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

