
#ifndef KDESU_EXPORT_H
#define KDESU_EXPORT_H

#ifdef KDESU_STATIC_DEFINE
#  define KDESU_EXPORT
#  define KDESU_NO_EXPORT
#else
#  ifndef KDESU_EXPORT
#    ifdef KF5Su_EXPORTS
        /* We are building this library */
#      define KDESU_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KDESU_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KDESU_NO_EXPORT
#    define KDESU_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KDESU_DECL_DEPRECATED
#  define KDESU_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KDESU_DECL_DEPRECATED_EXPORT
#  define KDESU_DECL_DEPRECATED_EXPORT KDESU_EXPORT KDESU_DECL_DEPRECATED
#endif

#ifndef KDESU_DECL_DEPRECATED_NO_EXPORT
#  define KDESU_DECL_DEPRECATED_NO_EXPORT KDESU_NO_EXPORT KDESU_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KDESU_NO_DEPRECATED
#    define KDESU_NO_DEPRECATED
#  endif
#endif

#define KDESU_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KDESU_NO_DEPRECATED) && !defined(KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KDESU_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KDESU_NO_DEPRECATED_WARNINGS) && !defined(KDESU_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KDESU_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KDESU_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KDESU_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KDESU_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KDESU_NO_DEPRECATED)
#  undef KDESU_DEPRECATED
#  define KDESU_DEPRECATED_EXPORT KDESU_EXPORT
#  define KDESU_DEPRECATED_NO_EXPORT KDESU_NO_EXPORT
#elif defined(KDESU_NO_DEPRECATED_WARNINGS)
#  define KDESU_DEPRECATED
#  define KDESU_DEPRECATED_EXPORT KDESU_EXPORT
#  define KDESU_DEPRECATED_NO_EXPORT KDESU_NO_EXPORT
#else
#  define KDESU_DEPRECATED KDESU_DECL_DEPRECATED
#  define KDESU_DEPRECATED_EXPORT KDESU_DECL_DEPRECATED_EXPORT
#  define KDESU_DEPRECATED_NO_EXPORT KDESU_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDESU_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDESU_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDESU_NO_DEPRECATED
#  define KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56200
#endif
#ifdef KDESU_NO_DEPRECATED_WARNINGS
#  define KDESU_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDESU_DEPRECATED_WARNINGS_SINCE
#  ifdef KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDESU_DEPRECATED_WARNINGS_SINCE KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDESU_DEPRECATED_WARNINGS_SINCE 0x56200
#  endif
#endif

#ifndef KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KDESU_DEPRECATED
#  define KDESU_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDESU_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KDESU_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KDESU_DEPRECATED_VERSION_5_0(text) KDESU_DECL_DEPRECATED_TEXT(text)
#else
#  define KDESU_DEPRECATED_VERSION_5_0(text)
#endif

#if KDESU_DEPRECATED_WARNINGS_SINCE >= 0x56300
#  define KDESU_DEPRECATED_VERSION_5_99(text) KDESU_DECL_DEPRECATED_TEXT(text)
#else
#  define KDESU_DEPRECATED_VERSION_5_99(text)
#endif
#define KDESU_DEPRECATED_VERSION_5(minor, text)      KDESU_DEPRECATED_VERSION_5_##minor(text)
#define KDESU_DEPRECATED_VERSION(major, minor, text) KDESU_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KDESU_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDESU_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KDESU_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KDESU_DEPRECATED_VERSION(major, minor, text)
#  define KDESU_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDESU_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KDESU_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KDESU_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KDESU_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KDESU_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KDESU_EXPORT_H


#define KDESU_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KDESU_NO_DEPRECATED) && !defined(KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KDESU_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KDESU_NO_DEPRECATED_WARNINGS) && !defined(KDESU_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KDESU_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KDESU_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KDESU_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KDESU_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KDESU_NO_DEPRECATED)
#  undef KDESU_DEPRECATED
#  define KDESU_DEPRECATED_EXPORT KDESU_EXPORT
#  define KDESU_DEPRECATED_NO_EXPORT KDESU_NO_EXPORT
#elif defined(KDESU_NO_DEPRECATED_WARNINGS)
#  define KDESU_DEPRECATED
#  define KDESU_DEPRECATED_EXPORT KDESU_EXPORT
#  define KDESU_DEPRECATED_NO_EXPORT KDESU_NO_EXPORT
#else
#  define KDESU_DEPRECATED KDESU_DECL_DEPRECATED
#  define KDESU_DEPRECATED_EXPORT KDESU_DECL_DEPRECATED_EXPORT
#  define KDESU_DEPRECATED_NO_EXPORT KDESU_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDESU_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDESU_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDESU_NO_DEPRECATED
#  define KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56200
#endif
#ifdef KDESU_NO_DEPRECATED_WARNINGS
#  define KDESU_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDESU_DEPRECATED_WARNINGS_SINCE
#  ifdef KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDESU_DEPRECATED_WARNINGS_SINCE KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDESU_DEPRECATED_WARNINGS_SINCE 0x56200
#  endif
#endif

#ifndef KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KDESU_DEPRECATED
#  define KDESU_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KDESU_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDESU_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KDESU_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KDESU_DEPRECATED_VERSION_5_0(text) KDESU_DECL_DEPRECATED_TEXT(text)
#else
#  define KDESU_DEPRECATED_VERSION_5_0(text)
#endif

#if KDESU_DEPRECATED_WARNINGS_SINCE >= 0x56300
#  define KDESU_DEPRECATED_VERSION_5_99(text) KDESU_DECL_DEPRECATED_TEXT(text)
#else
#  define KDESU_DEPRECATED_VERSION_5_99(text)
#endif
#define KDESU_DEPRECATED_VERSION_5(minor, text)      KDESU_DEPRECATED_VERSION_5_##minor(text)
#define KDESU_DEPRECATED_VERSION(major, minor, text) KDESU_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KDESU_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDESU_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KDESU_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KDESU_DEPRECATED_VERSION(major, minor, text)
#  define KDESU_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDESU_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KDESU_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KDESU_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KDESU_EXPORT_H */
