/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-period.h"
#include "libical-glib-private.h"
#include "i-cal-duration.h"
#include "i-cal-time.h"

G_DEFINE_TYPE (ICalPeriod, i_cal_period, I_CAL_TYPE_OBJECT)

static void i_cal_period_class_init (G_GNUC_UNUSED ICalPeriodClass *klass)
{
}

static void i_cal_period_init (G_GNUC_UNUSED ICalPeriod *self)
{
}

/**
 * i_cal_period_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalPeriod *
i_cal_period_new_full (struct icalperiodtype native)
{
    ICalPeriod *object;
    struct icalperiodtype *clone;
    
    
    clone = g_new (struct icalperiodtype, 1);
    *clone = native;
    object = i_cal_object_construct (I_CAL_TYPE_PERIOD,
                            (gpointer) clone,
                            (GDestroyNotify) g_free,
                            FALSE,
                            NULL);

    return object;
}


/**
 * i_cal_period_get_start:
 * @period: The #ICalPeriod to be queried
 *
 * Gets the start time from an #ICalPeriod.
 *
 * Returns: (transfer full): The start of @period.
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_period_get_start (ICalPeriod *period)
{
	g_return_val_if_fail (period != NULL, NULL);
	g_return_val_if_fail (I_CAL_IS_PERIOD (period), NULL);

	return i_cal_time_new_full ((* (struct icalperiodtype *)i_cal_object_get_native ((ICalObject *)period)).start);
}

/**
 * i_cal_period_set_start:
 * @period: The #ICalPeriod to be set
 * @start: The start of @period
 *
 * Sets the start time of an #ICalPeriod.
 *
 * Since: 1.0
 *
 **/
void
i_cal_period_set_start (ICalPeriod *period, 
                        ICalTime *start)
{
	struct icalperiodtype *periodtype;
	g_return_if_fail (period != NULL);
	g_return_if_fail (I_CAL_IS_PERIOD (period));
	g_return_if_fail (start != NULL);
	g_return_if_fail (I_CAL_IS_TIME(start));

	periodtype = (struct icalperiodtype *)i_cal_object_get_native ((ICalObject *)period);
	periodtype->start = * (struct icaltimetype *)i_cal_object_get_native ((ICalObject *)start);
}

/**
 * i_cal_period_get_end:
 * @period: The #ICalPeriod to be queried
 *
 * Gets the end time from an #ICalPeriod.
 *
 * Returns: (transfer full): The end of @period.
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_period_get_end (ICalPeriod *period)
{
	g_return_val_if_fail (period != NULL, NULL);
	g_return_val_if_fail (I_CAL_IS_PERIOD (period), NULL);

	return i_cal_time_new_full ((* (struct icalperiodtype *)i_cal_object_get_native ((ICalObject *)period)).end);
}

/**
 * i_cal_period_set_end:
 * @period: The #ICalPeriod to be set
 * @end: The end of @period
 *
 * Sets the end time of an #ICalPeriod.
 *
 * Since: 1.0
 *
 **/
void
i_cal_period_set_end (ICalPeriod *period, 
                      ICalTime *end)
{
	struct icalperiodtype *periodtype;
	g_return_if_fail (period != NULL);
	g_return_if_fail (I_CAL_IS_PERIOD (period));
	g_return_if_fail (end != NULL);
	g_return_if_fail (I_CAL_IS_TIME(end));

	periodtype = (struct icalperiodtype *)i_cal_object_get_native ((ICalObject *)period);
	periodtype->end = (* (struct icaltimetype *)i_cal_object_get_native ((ICalObject *)end));
}

/**
 * i_cal_period_get_duration:
 * @period: The #ICalPeriod to be queried
 *
 * Gets the duration from an #ICalPeriod.
 *
 * Returns: (transfer full): The duration of @period.
 *
 * Since: 1.0
 *
 **/
ICalDuration *
i_cal_period_get_duration (ICalPeriod *period)
{
	g_return_val_if_fail (period != NULL, NULL);
	g_return_val_if_fail (I_CAL_IS_PERIOD (period), NULL);

	return i_cal_duration_new_full ((* (struct icalperiodtype *)i_cal_object_get_native ((ICalObject *)period)).duration);
}

/**
 * i_cal_period_set_duration:
 * @period: The #ICalPeriod to be set
 * @duration: The duration of @period
 *
 * Sets the duration of an #ICalPeriod.
 *
 * Since: 1.0
 *
 **/
void
i_cal_period_set_duration (ICalPeriod *period, 
                           ICalDuration *duration)
{
	struct icalperiodtype *periodtype;
	g_return_if_fail (period != NULL);
	g_return_if_fail (I_CAL_IS_PERIOD (period));
	g_return_if_fail (duration != NULL);
	g_return_if_fail (I_CAL_IS_DURATION(duration));

	periodtype = (struct icalperiodtype *)i_cal_object_get_native ((ICalObject *)period);
	periodtype->duration = (* (struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration));
}

/**
 * i_cal_period_new_from_string:
 * @str: The string used to create the #ICalPeriod
 *
 * Creates a #ICalPeriod from a string.
 *
 * Returns: (transfer full): The newly created #ICalPeriod
 *
 * Since: 1.0
 *
 **/
ICalPeriod *
i_cal_period_new_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_period_new_full (icalperiodtype_from_string (str));
}

/**
 * i_cal_period_as_ical_string:
 * @p: The #ICalPeriod to be translated
 *
 * Translates #ICalPeriod to string.
 *
 * Returns: (transfer full): The string representation of #ICalPeriod.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_period_as_ical_string (ICalPeriod *p)
{
	g_return_val_if_fail (I_CAL_IS_PERIOD (p), NULL);

	return icalperiodtype_as_ical_string_r (* (struct icalperiodtype *)i_cal_object_get_native (I_CAL_OBJECT (p)));
}

/**
 * i_cal_period_new_null_period:
 *
 * Creates a default #ICalPeriod.
 *
 * Returns: (transfer full): The newly created default #ICalPeriod
 *
 * Since: 1.0
 *
 **/
ICalPeriod *
i_cal_period_new_null_period (void)
{
	return i_cal_period_new_full (icalperiodtype_null_period ());
}

/**
 * i_cal_period_is_null_period:
 * @p: The #ICalPeriod to be checked
 *
 * Checks the #ICalPeriod is null_period.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_period_is_null_period (ICalPeriod *p)
{
	g_return_val_if_fail (I_CAL_IS_PERIOD (p), FALSE);

	return icalperiodtype_is_null_period (* (struct icalperiodtype *)i_cal_object_get_native (I_CAL_OBJECT (p)));
}

/**
 * i_cal_period_is_valid_period:
 * @p: The #ICalPeriod to be checked
 *
 * Checks the #ICalPeriod is valid_period.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_period_is_valid_period (ICalPeriod *p)
{
	g_return_val_if_fail (I_CAL_IS_PERIOD (p), FALSE);

	return icalperiodtype_is_valid_period (* (struct icalperiodtype *)i_cal_object_get_native (I_CAL_OBJECT (p)));
}
