
#include "valhall.h"
#include "bi_opcodes.h"

const uint32_t valhall_immediates[32] = {
    0x0,
    0xffffffff,
    0x7fffffff,
    0xfafcfdfe,
    0x1000000,
    0x80002000,
    0x70605030,
    0xc0b0a090,
    0x3020100,
    0x7060504,
    0xb0a0908,
    0xf0e0d0c,
    0x13121110,
    0x17161514,
    0x1b1a1918,
    0x1f1e1d1c,
    0x3f800000,
    0x3dcccccd,
    0x3ea2f983,
    0x3f317218,
    0x40490fdb,
    0x0,
    0x477fff00,
    0x5c005bf8,
    0x2e660000,
    0x34000000,
    0x38000000,
    0x3c000000,
    0x40000000,
    0x44000000,
    0x48000000,
    0x42480000,
};


const struct va_opcode_info
valhall_opcodes[BI_NUM_OPCODES] = {

    [BI_OPCODE_NOP] = {
        .exact = 0x0ULL,
        .srcs = {
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 0,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_BRANCHZ_I16] = {
        .exact = 0x1f000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 1,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_DISCARD_F32] = {
        .exact = 0x20000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_BRANCHZI] = {
        .exact = 0x2f000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 1,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_BARRIER] = {
        .exact = 0x45000000000000ULL,
        .srcs = {
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_NONE,
        .nr_srcs = 0,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CSEL_F32] = {
        .exact = 0x154000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 4,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CSEL_V2F16] = {
        .exact = 0x155000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 4,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CSEL_U32] = {
        .exact = 0x150000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 4,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CSEL_V2U16] = {
        .exact = 0x151000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 4,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CSEL_S32] = {
        .exact = 0x158000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 4,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CSEL_V2S16] = {
        .exact = 0x159000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 4,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_LD_VAR_SPECIAL] = {
        .exact = 0x56000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_V,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_VAR_BUF_IMM_F32] = {
        .exact = 0x5c000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_V,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_VAR_BUF_IMM_F16] = {
        .exact = 0x5d000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 0,
        .unit = VA_UNIT_V,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_VAR_BUF_F32] = {
        .exact = 0x6c000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_V,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_VAR_BUF_F16] = {
        .exact = 0x6d000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 0,
        .unit = VA_UNIT_V,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_VAR] = {
        .exact = 0x64000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_V,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_VAR_IMM] = {
        .exact = 0x54000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_V,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_VAR_FLAT] = {
        .exact = 0x55000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_V,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_VAR_FLAT_IMM] = {
        .exact = 0x41000000000000ULL,
        .srcs = {
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_V,
        .nr_srcs = 0,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_ATTR_IMM] = {
        .exact = 0x66000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_ATTR] = {
        .exact = 0x76000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_TEX_IMM] = {
        .exact = 0x66002000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_TEX] = {
        .exact = 0x76002000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LEA_ATTR_IMM] = {
        .exact = 0x67000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LEA_ATTR] = {
        .exact = 0x77000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LEA_TEX_IMM] = {
        .exact = 0x67002000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LEA_TEX] = {
        .exact = 0x77002000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_BUFFER_I8] = {
        .exact = 0x6a000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_BUFFER_I16] = {
        .exact = 0x6a000008000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_BUFFER_I24] = {
        .exact = 0x6a000010000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 24,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_BUFFER_I32] = {
        .exact = 0x6a000018000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_BUFFER_I48] = {
        .exact = 0x6a000020000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 48,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_BUFFER_I64] = {
        .exact = 0x6a000028000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_64,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_64,
            },
        },
        .type_size = 64,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_BUFFER_I96] = {
        .exact = 0x6a000030000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 96,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LD_BUFFER_I128] = {
        .exact = 0x6a000038000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 128,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LEA_BUF_IMM] = {
        .exact = 0x5e000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LOAD_I8] = {
        .exact = 0x60000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LOAD_I16] = {
        .exact = 0x60000008000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LOAD_I24] = {
        .exact = 0x60000010000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 24,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LOAD_I32] = {
        .exact = 0x60000018000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LOAD_I48] = {
        .exact = 0x60000020000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 48,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LOAD_I64] = {
        .exact = 0x60000028000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_64,
            },
        },
        .type_size = 64,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LOAD_I96] = {
        .exact = 0x60000030000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 96,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_LOAD_I128] = {
        .exact = 0x60000038000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 128,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_STORE_I8] = {
        .exact = 0x61000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_STORE_I16] = {
        .exact = 0x61000008000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_STORE_I24] = {
        .exact = 0x61000010000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 24,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_STORE_I32] = {
        .exact = 0x61000018000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_STORE_I48] = {
        .exact = 0x61000020000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 48,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_STORE_I64] = {
        .exact = 0x61000028000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_64,
            },
        },
        .type_size = 64,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_STORE_I96] = {
        .exact = 0x61000030000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 96,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_STORE_I128] = {
        .exact = 0x61000038000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
            },
        },
        .type_size = 128,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_ST_CVT] = {
        .exact = 0x71000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_64,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 2,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_LD_TILE] = {
        .exact = 0x78000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_NONE,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_ST_TILE] = {
        .exact = 0x79000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_NONE,
        .nr_srcs = 3,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_BLEND] = {
        .exact = 0x7f000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_64,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_NONE,
        .nr_srcs = 2,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 1,
        .register_format = 1,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_ATEST] = {
        .exact = 0x7d000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_NONE,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_ZS_EMIT] = {
        .exact = 0x7e000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_NONE,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_V2S16_TO_V2F16] = {
        .exact = 0x90000000070000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_S32_TO_F32] = {
        .exact = 0x90000000090000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_V2U16_TO_V2F16] = {
        .exact = 0x90000000170000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_U32_TO_F32] = {
        .exact = 0x90000000190000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_S16_TO_S32] = {
        .exact = 0x90000000040000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_S16_TO_F32] = {
        .exact = 0x90000000050000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_U16_TO_U32] = {
        .exact = 0x90000000140000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_U16_TO_F32] = {
        .exact = 0x90000000150000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_F32_TO_S32] = {
        .exact = 0x900000000c0000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_F32_TO_U32] = {
        .exact = 0x900000001c0000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_V2F16_TO_V2S16] = {
        .exact = 0x900000000e0000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_V2F16_TO_V2U16] = {
        .exact = 0x900000001e0000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_F16_TO_S32] = {
        .exact = 0x900000000a0000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_F16_TO_U32] = {
        .exact = 0x900000001a0000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_F16_TO_F32] = {
        .exact = 0x900000000b0000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 1,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_S8_TO_S32] = {
        .exact = 0x90000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 1,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_S8_TO_F32] = {
        .exact = 0x90000000010000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 1,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_U8_TO_U32] = {
        .exact = 0x90000000100000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 1,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_U8_TO_F32] = {
        .exact = 0x90000000110000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 1,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_V2S8_TO_V2S16] = {
        .exact = 0x90000000020000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 1,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_V2S8_TO_V2F16] = {
        .exact = 0x90000000030000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 1,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_V2U8_TO_V2U16] = {
        .exact = 0x90000000120000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 1,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_V2U8_TO_V2F16] = {
        .exact = 0x90000000130000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 1,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FROUND_F32] = {
        .exact = 0x900000000d0000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FROUND_V2F16] = {
        .exact = 0x900000000f0000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 1,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_MOV_I32] = {
        .exact = 0x91000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CLZ_U32] = {
        .exact = 0x91000000040000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CLZ_V2U16] = {
        .exact = 0x91000000050000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CLZ_V4U8] = {
        .exact = 0x91000000060000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IABS_S32] = {
        .exact = 0x91000000080000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IABS_V2S16] = {
        .exact = 0x91000000090000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IABS_V4S8] = {
        .exact = 0x910000000a0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_POPCOUNT_I32] = {
        .exact = 0x910000000c0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_BITREV_I32] = {
        .exact = 0x910000000d0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_WMASK] = {
        .exact = 0x95000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FREXPM_F32] = {
        .exact = 0x99000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FREXPM_V2F16] = {
        .exact = 0x99000000010000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FREXPE_F32] = {
        .exact = 0x99000000020000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FREXPE_V2F16] = {
        .exact = 0x99000000030000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FRCP_F32] = {
        .exact = 0x9c000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FRCP_F16] = {
        .exact = 0x9c000000010000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FRSQ_F32] = {
        .exact = 0x9c000000020000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FRSQ_F16] = {
        .exact = 0x9c000000030000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FLOGD_F32] = {
        .exact = 0x9c000000080000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FSIN_TABLE_U6] = {
        .exact = 0x9c000000040000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FCOS_TABLE_U6] = {
        .exact = 0x9c000000050000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FADD_F32] = {
        .exact = 0xa4000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_FMA,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FADD_V2F16] = {
        .exact = 0xa5000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_FMA,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FMIN_F32] = {
        .exact = 0xa4000000020000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FMIN_V2F16] = {
        .exact = 0xa5000000020000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FMAX_F32] = {
        .exact = 0xa4000000030000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FMAX_V2F16] = {
        .exact = 0xa5000000030000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_V2F32_TO_V2F16] = {
        .exact = 0xa5000000040000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FRSCALE_F32] = {
        .exact = 0xa4000000060000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_FMA,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FRSCALE_V2F16] = {
        .exact = 0xa5000000060000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_FMA,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FEXP_F32] = {
        .exact = 0xa4000000080000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FADD_LSCALE_F32] = {
        .exact = 0xa4000000090000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_FMA,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IADD_U32] = {
        .exact = 0xa0000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IADD_V2U16] = {
        .exact = 0xa1000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IADD_V4U8] = {
        .exact = 0xa2000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IADD_S32] = {
        .exact = 0xa8000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IADD_V2S16] = {
        .exact = 0xa9000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IADD_V4S8] = {
        .exact = 0x1a2000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_MKVEC_V2I16] = {
        .exact = 0xa1000000050000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ISUB_U32] = {
        .exact = 0xa0000000010000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ISUB_V2U16] = {
        .exact = 0xa1000000010000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ISUB_V4U8] = {
        .exact = 0xa2000000010000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ISUB_S32] = {
        .exact = 0xa8000000010000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ISUB_V2S16] = {
        .exact = 0xa9000000010000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ISUB_V4S8] = {
        .exact = 0x1a2000000010000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IMUL_I32] = {
        .exact = 0xa00000000a0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IMUL_V2I16] = {
        .exact = 0xa10000000a0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IMUL_V4I8] = {
        .exact = 0xa20000000a0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_HADD_U32] = {
        .exact = 0xa00000000b0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_HADD_V2U16] = {
        .exact = 0xa10000000b0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_HADD_V4U8] = {
        .exact = 0xa20000000b0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_HADD_S32] = {
        .exact = 0xa80000000b0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_HADD_V2S16] = {
        .exact = 0xa90000000b0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_HADD_V4S8] = {
        .exact = 0x1a20000000b0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CLPER_I32] = {
        .exact = 0xa00000000f0000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 2,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FMA_F32] = {
        .exact = 0xb2000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_FMA,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FMA_V2F16] = {
        .exact = 0xb3000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_FMA,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_LSHIFT_AND_I32] = {
        .exact = 0xb4000100000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_LSHIFT_AND_V2I16] = {
        .exact = 0xb5000100000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_LSHIFT_AND_V4I8] = {
        .exact = 0xb6000100000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_RSHIFT_AND_I32] = {
        .exact = 0xb4000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_RSHIFT_AND_V2I16] = {
        .exact = 0xb5000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_RSHIFT_AND_V4I8] = {
        .exact = 0xb6000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_LSHIFT_OR_I32] = {
        .exact = 0xb4000101000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_LSHIFT_OR_V2I16] = {
        .exact = 0xb5000101000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_LSHIFT_OR_V4I8] = {
        .exact = 0xb6000101000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_RSHIFT_OR_I32] = {
        .exact = 0xb4000001000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_RSHIFT_OR_V2I16] = {
        .exact = 0xb5000001000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_RSHIFT_OR_V4I8] = {
        .exact = 0xb6000001000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_LSHIFT_XOR_I32] = {
        .exact = 0xb4000102000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_LSHIFT_XOR_V2I16] = {
        .exact = 0xb5000102000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_LSHIFT_XOR_V4I8] = {
        .exact = 0xb6000102000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_RSHIFT_XOR_I32] = {
        .exact = 0xb4000002000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_RSHIFT_XOR_V2I16] = {
        .exact = 0xb5000002000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_RSHIFT_XOR_V4I8] = {
        .exact = 0xb6000002000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 1,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 1,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_MUX_I32] = {
        .exact = 0xb8000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_MUX_V2I16] = {
        .exact = 0xb9000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_MUX_V4I8] = {
        .exact = 0xba000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CUBE_SSEL] = {
        .exact = 0xbc000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CUBE_TSEL] = {
        .exact = 0xbc000001000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_MKVEC_V4I8] = {
        .exact = 0xbd000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 1,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 1,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CUBEFACE1] = {
        .exact = 0xc0000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_CUBEFACE2_V9] = {
        .exact = 0xc1000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_SFU,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ICMP_U32] = {
        .exact = 0xf0000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 1,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ICMP_V2U16] = {
        .exact = 0xf1000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 1,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ICMP_V4U8] = {
        .exact = 0xf2000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 1,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FCMP_F32] = {
        .exact = 0xf4000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 1,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FCMP_V2F16] = {
        .exact = 0xf5000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 1,
                .swizzle = 1,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 1,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ICMP_S32] = {
        .exact = 0xf8000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 1,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ICMP_V2S16] = {
        .exact = 0xf9000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 1,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ICMP_V4S8] = {
        .exact = 0xfa000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 1,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 3,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 1,
        .result_type = 1,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IADD_IMM_I32] = {
        .exact = 0x110000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IADD_IMM_V2I16] = {
        .exact = 0x111000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_IADD_IMM_V4I8] = {
        .exact = 0x112000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_8,
            },
        },
        .type_size = 8,
        .has_dest = 1,
        .unit = VA_UNIT_CVT,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FADD_IMM_F32] = {
        .exact = 0x114000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_FMA,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_FADD_IMM_V2F16] = {
        .exact = 0x115000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_16,
            },
        },
        .type_size = 16,
        .has_dest = 1,
        .unit = VA_UNIT_FMA,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },

    [BI_OPCODE_ATOM1_RETURN_I32] = {
        .exact = 0x69000018000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_64,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 2,
    },

    [BI_OPCODE_ATOM_I32] = {
        .exact = 0x68000018000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_64,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 0,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 0,
        .sr_control = 1,
    },

    [BI_OPCODE_ATOM_RETURN_I32] = {
        .exact = 0x120000018000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_64,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_LS,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 1,
        .sr_control = 0,
    },

    [BI_OPCODE_TEX_FETCH] = {
        .exact = 0x125000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_T,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 1,
        .sr_control = 0,
    },

    [BI_OPCODE_TEX_SINGLE] = {
        .exact = 0x128000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_T,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 1,
        .sr_control = 0,
    },

    [BI_OPCODE_TEX_GATHER] = {
        .exact = 0x129000000000000ULL,
        .srcs = {
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 0,
        .unit = VA_UNIT_T,
        .nr_srcs = 1,
        .nr_staging_srcs = 1,
        .nr_staging_dests = 1,
        .clamp = 0,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 1,
        .sr_count = 1,
        .sr_write_count = 1,
        .sr_control = 0,
    },

    [BI_OPCODE_FMA_RSCALE_F32] = {
        .exact = 0x160000000000000ULL,
        .srcs = {
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 1,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
            {
                .absneg = 0,
                .swizzle = 0,
                .notted = 0,
                .widen = 0,
                .lanes = 0,
                .halfswizzle = 0,
                .lane = 0,
                .combine = 0,
                .size = VA_SIZE_32,
            },
        },
        .type_size = 32,
        .has_dest = 1,
        .unit = VA_UNIT_FMA,
        .nr_srcs = 4,
        .nr_staging_srcs = 0,
        .nr_staging_dests = 0,
        .clamp = 1,
        .round_mode = 0,
        .condition = 0,
        .result_type = 0,
        .vecsize = 0,
        .register_format = 0,
        .slot = 0,
        .sr_count = 0,
        .sr_write_count = 0,
        .sr_control = 0,
    },
};

