/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.MockMapGenerator;
import org.junit.Assert;

public final class ServerTestHelper {
    private static final String SERVER_NAME = "MyTestServer";
    private static final int SERVER_PORT = -1;
    private static final String TEST_FILE = "test/data/test.fsg";
    private static FreeColServer server = null;
    private static Random random = null;

    public static FreeColServer getServer() {
        return server;
    }

    public static void setServer(FreeColServer newServer) {
        server = newServer;
    }

    public static InGameController getInGameController() {
        return server.getInGameController();
    }

    public static void setRandom(Random newRandom) {
        random = newRandom;
    }

    public static void stopServer() {
        if (server != null) {
            Controller c = server.getController();
            Assert.assertNotNull((Object)c);
            c.shutdown();
            server = null;
        }
    }

    public static FreeColServer startServer(boolean publicServer, boolean singlePlayer) {
        return ServerTestHelper.startServer(publicServer, singlePlayer, FreeColTestCase.spec());
    }

    public static FreeColServer startServer(boolean publicServer, boolean singlePlayer, Specification spec) {
        return ServerTestHelper.startServer(publicServer, singlePlayer, spec, -1, SERVER_NAME);
    }

    public static FreeColServer startServer(boolean publicServer, boolean singlePlayer, Specification spec, int port, String name) {
        ServerTestHelper.stopServer();
        try {
            server = new FreeColServer(publicServer, singlePlayer, spec, null, port, name);
        }
        catch (IOException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((Object)((Object)FreeColServer.ServerState.PRE_GAME), (Object)((Object)server.getServerState()));
        return server;
    }

    public static FreeColServer startServer(File file, boolean publicServer, boolean singlePlayer) {
        return ServerTestHelper.startServer(file, publicServer, singlePlayer, -1, SERVER_NAME);
    }

    public static FreeColServer startServer(File file, boolean publicServer, boolean singlePlayer, int port, String name) {
        ServerTestHelper.stopServer();
        try {
            server = new FreeColServer(new FreeColSavegameFile(file), null, null, port, name);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((Object)((Object)FreeColServer.ServerState.LOAD_GAME), (Object)((Object)server.getServerState()));
        return server;
    }

    public static File createRandomSaveGame() {
        FreeColServer serv = ServerTestHelper.startServer(false, true);
        try {
            serv.startGame();
        }
        catch (FreeColException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)((Object)FreeColServer.ServerState.IN_GAME), (Object)((Object)serv.getServerState()));
        Assert.assertNotNull((Object)serv.getGame());
        Assert.assertNotNull((Object)serv.getGame().getMap());
        File file = new File(TEST_FILE);
        try {
            serv.saveGame(file, null, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
        Assert.assertTrue((boolean)file.exists());
        ServerTestHelper.stopServer();
        return file;
    }

    public static void newTurn() {
        ServerGame game = server.getGame();
        game.csNewTurn(random, new LogBuilder(0), new ChangeSet());
    }

    public static ServerGame startServerGame(Map map) {
        return ServerTestHelper.startServerGame(map, FreeColTestCase.spec());
    }

    public static ServerGame startServerGame(Map map, Specification spec) {
        ServerTestHelper.stopServerGame();
        FreeColServer serv = ServerTestHelper.startServer(false, true, spec);
        serv.setMapGenerator(new MockMapGenerator(map));
        try {
            serv.startGame();
        }
        catch (FreeColException e) {
            Assert.fail((String)("Failed to start game: " + e.getMessage()));
        }
        ServerGame game = serv.getGame();
        FreeColTestCase.setGame(game);
        if (game.getCurrentPlayer() == null) {
            game.setCurrentPlayer(game.getFirstPlayer());
        }
        random = new Random();
        return game;
    }

    public static void stopServerGame() {
        ServerTestHelper.stopServer();
        FreeColTestCase.setGame(null);
    }
}

