/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.FreeColTestUtils;

public class AIColonyTest
extends FreeColTestCase {
    private static final BuildingType blacksmithsHouseType = AIColonyTest.spec().getBuildingType("model.building.blacksmithHouse");
    private static final BuildingType carpentersHouseType = AIColonyTest.spec().getBuildingType("model.building.carpenterHouse");
    private static final BuildingType lumberMillType = AIColonyTest.spec().getBuildingType("model.building.lumberMill");
    private static final BuildingType warehouseType = AIColonyTest.spec().getBuildingType("model.building.warehouse");
    private static final GoodsType foodType = AIColonyTest.spec().getPrimaryFoodType();
    private static final GoodsType grainType = AIColonyTest.spec().getGoodsType("model.goods.grain");
    private static final GoodsType hammersType = AIColonyTest.spec().getGoodsType("model.goods.hammers");
    private static final GoodsType lumberType = AIColonyTest.spec().getGoodsType("model.goods.lumber");
    private static final GoodsType oreType = AIColonyTest.spec().getGoodsType("model.goods.ore");
    private static final GoodsType rumType = AIColonyTest.spec().getGoodsType("model.goods.rum");
    private static final GoodsType sugarType = AIColonyTest.spec().getGoodsType("model.goods.sugar");
    private static final GoodsType toolsType = AIColonyTest.spec().getGoodsType("model.goods.tools");
    private static final TileType forestType = AIColonyTest.spec().getTileType("model.tile.coniferForest");
    private static final TileType savannahType = AIColonyTest.spec().getTileType("model.tile.savannah");
    private static final TileType mountainType = AIColonyTest.spec().getTileType("model.tile.mountains");
    private static final UnitType artilleryType = AIColonyTest.spec().getUnitType("model.unit.artillery");
    private static final UnitType colonistType = AIColonyTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType lumberJackType = AIColonyTest.spec().getUnitType("model.unit.expertLumberJack");
    private LogBuilder lb = new LogBuilder(0);

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    private Colony decorateMap(Game game, boolean full) {
        Map map = game.getMap();
        if (full) {
            map.getTile(4, 8).setType(forestType);
            map.getTile(6, 8).setType(mountainType);
        }
        Colony colony = this.getStandardColony(6);
        game.setCurrentPlayer(colony.getOwner());
        return colony;
    }

    private BuildableType getToolsBuilder(AIColony aiColony) {
        Colony colony = aiColony.getColony();
        for (BuildableType b : aiColony.getPlannedBuildableTypes()) {
            if (colony.canBuild(b) && b.getRequiredAmountOf(toolsType) > 0) {
                return b;
            }
            if (b instanceof BuildingType) {
                colony.addBuilding(new ServerBuilding(colony.getGame(), colony, (BuildingType)b));
                continue;
            }
            if (!(b instanceof UnitType)) continue;
            new ServerUnit(colony.getGame(), colony.getTile(), colony.getOwner(), (UnitType)b);
        }
        return null;
    }

    public void testBuildersAllocation() {
        BuildableType toolsBuild;
        ServerGame game = ServerTestHelper.startServerGame(AIColonyTest.getTestMap(savannahType));
        Colony colony = this.decorateMap(game, true);
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        Building carpenterHouse = colony.getBuilding(carpentersHouseType);
        Building blacksmithHouse = colony.getBuilding(blacksmithsHouseType);
        AIColony aiColony = aiMain.getAIColony(colony);
        ServerPlayer player = (ServerPlayer)colony.getOwner();
        colony.addGoods(foodType, 100);
        aiColony.propertyChange(null);
        aiColony.rearrangeColony(this.lb);
        AIColonyTest.assertEquals((String)"Colony should be building lumber mill", (Object)lumberMillType, (Object)colony.getCurrentlyBuilding());
        AIColonyTest.assertTrue((String)"Colony should be producing lumber", (colony.getNetProductionOf(lumberType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertTrue((String)"Colony should have been assigned a carpenter", (carpenterHouse.getUnitCount() > 0 ? 1 : 0) != 0);
        AIColonyTest.assertTrue((String)"Colony should be producing sugar", (colony.getNetProductionOf(sugarType) > 0 ? 1 : 0) != 0);
        colony.addGoods(hammersType, lumberMillType.getRequiredAmountOf(hammersType));
        aiColony.propertyChange(null);
        aiColony.rearrangeColony(this.lb);
        AIColonyTest.assertEquals((String)"Colony should be building lumber mill", (Object)lumberMillType, (Object)colony.getCurrentlyBuilding());
        AIColonyTest.assertEquals((String)"Colony does not need a carpenter", (int)0, (int)carpenterHouse.getUnitCount());
        AIColonyTest.assertTrue((String)"Colony should be producing sugar", (colony.getNetProductionOf(sugarType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertTrue((String)"Colony should be producing rum", (colony.getNetProductionOf(rumType) > 0 ? 1 : 0) != 0);
        colony.addGoods(sugarType, 100);
        aiColony.propertyChange(null);
        aiColony.rearrangeColony(this.lb);
        AIColonyTest.assertEquals((String)"Colony does not need a carpenter", (int)0, (int)carpenterHouse.getUnitCount());
        TileType tileType = colony.getTile().getType();
        AIColonyTest.assertEquals((String)"Colony should not be producing sugar, except center", (int)tileType.getPotentialProduction(sugarType, colonistType), (int)colony.getTotalProductionOf(sugarType));
        AIColonyTest.assertTrue((String)"Colony should be producing rum", (colony.getNetProductionOf(rumType) > 0 ? 1 : 0) != 0);
        do {
            toolsBuild = this.getToolsBuilder(aiColony);
            AIColonyTest.assertNotNull((Object)toolsBuild);
            aiColony.propertyChange(null);
            aiColony.rearrangeColony(this.lb);
        } while (colony.getCurrentlyBuilding() != toolsBuild);
        AIColonyTest.assertEquals((String)"Colony does not need a carpenter", (int)0, (int)carpenterHouse.getUnitCount());
        AIColonyTest.assertTrue((String)"Colony should be producing ore", (colony.getTotalProductionOf(oreType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertTrue((String)"Colony should be producing tools", (colony.getTotalProductionOf(toolsType) > 0 ? 1 : 0) != 0);
    }

    public void testBuildersAllocNoRawMatTiles() {
        ServerGame game = ServerTestHelper.startServerGame(AIColonyTest.getTestMap(savannahType));
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        Colony colony = this.decorateMap(game, false);
        Building carpenterHouse = colony.getBuilding(carpentersHouseType);
        Building blacksmithHouse = colony.getBuilding(blacksmithsHouseType);
        AIColony aiColony = aiMain.getAIColony(colony);
        ServerPlayer player = (ServerPlayer)colony.getOwner();
        colony.addGoods(foodType, 100);
        for (ColonyTile t : colony.getColonyTiles()) {
            Tile tile = t.getTile();
            AIColonyTest.assertEquals((String)"The colony can not have tiles that produce lumber", (int)0, (int)tile.getPotentialProduction(lumberType, colonistType));
            AIColonyTest.assertEquals((String)"The colony can not have tiles that produce ore", (int)0, (int)tile.getPotentialProduction(oreType, colonistType));
        }
        AIColonyTest.assertEquals((String)"Colony has no lumber", (int)0, (int)colony.getGoodsCount(lumberType));
        AIColonyTest.assertEquals((String)"Colony has no ore", (int)0, (int)colony.getGoodsCount(oreType));
        aiColony.propertyChange(null);
        aiColony.rearrangeColony(this.lb);
        AIColonyTest.assertFalse((String)"Colony can not have a lumberjack, no lumber", (colony.getNetProductionOf(lumberType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertEquals((String)"Colony can not have a carpenter, no lumber", (int)0, (int)carpenterHouse.getUnitCount());
        AIColonyTest.assertFalse((String)"Colony can not have an ore miner, no ore", (colony.getNetProductionOf(oreType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertEquals((String)"Colony can not have a blacksmith, no ore", (int)0, (int)blacksmithHouse.getUnitCount());
        AIColonyTest.assertEquals((String)"Colony should be building lumber mill", (Object)lumberMillType, (Object)colony.getCurrentlyBuilding());
        colony.addGoods(lumberType, 100);
        aiColony.propertyChange(null);
        aiColony.rearrangeColony(this.lb);
        AIColonyTest.assertEquals((String)"Colony should be building lumber mill", (Object)lumberMillType, (Object)colony.getCurrentlyBuilding());
        AIColonyTest.assertFalse((String)"Colony can not have a lumberjack, no lumber", (colony.getNetProductionOf(lumberType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertTrue((String)"Colony should have a carpenter, has lumber in stock", (carpenterHouse.getUnitCount() > 0 ? 1 : 0) != 0);
        AIColonyTest.assertFalse((String)"Colony can not have an ore miner, no ore", (colony.getNetProductionOf(oreType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertEquals((String)"Colony can not have a blacksmith, no ore", (int)0, (int)blacksmithHouse.getUnitCount());
        colony.addGoods(hammersType, lumberMillType.getRequiredAmountOf(hammersType));
        aiColony.propertyChange(null);
        aiColony.rearrangeColony(this.lb);
        AIColonyTest.assertFalse((String)"Colony can not have a lumberjack, no lumber", (colony.getNetProductionOf(lumberType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertEquals((String)"Colony does not need a carpenter", (int)0, (int)carpenterHouse.getUnitCount());
        AIColonyTest.assertFalse((String)"Colony can not have an ore miner, no ore", (colony.getNetProductionOf(oreType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertEquals((String)"Colony can not have a blacksmith, no ore", (int)0, (int)blacksmithHouse.getUnitCount());
        BuildableType toolsBuild = this.getToolsBuilder(aiColony);
        aiColony.propertyChange(null);
        aiColony.rearrangeColony(this.lb);
        AIColonyTest.assertFalse((String)"Colony can not have a lumberjack, no lumber", (colony.getNetProductionOf(lumberType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertEquals((String)"Colony does not need a carpenter", (int)0, (int)carpenterHouse.getUnitCount());
        AIColonyTest.assertFalse((String)"Colony can not have an ore miner, no ore", (colony.getNetProductionOf(oreType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertEquals((String)"Colony can not have a blacksmith, no ore", (int)0, (int)blacksmithHouse.getUnitCount());
        AIColonyTest.assertEquals((String)"Colony should be building tools-requirer", (Object)toolsBuild, (Object)colony.getCurrentlyBuilding());
        colony.addGoods(oreType, 100);
        aiColony.propertyChange(null);
        aiColony.rearrangeColony(this.lb);
        AIColonyTest.assertFalse((String)"Colony can not have a lumberjack, no lumber", (colony.getNetProductionOf(lumberType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertEquals((String)"Colony does not need a carpenter", (int)0, (int)carpenterHouse.getUnitCount());
        AIColonyTest.assertFalse((String)"Colony can not have an ore miner, no ore", (colony.getNetProductionOf(oreType) > 0 ? 1 : 0) != 0);
        AIColonyTest.assertTrue((String)"Colony should have a blacksmith, has ore in stock", (blacksmithHouse.getUnitCount() > 0 ? 1 : 0) != 0);
    }

    public void testExpertAllocColonyHasEnoughRawMat() {
        ServerGame game = ServerTestHelper.startServerGame(AIColonyTest.getTestMap(forestType));
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        FreeColTestUtils.ColonyBuilder builder = FreeColTestUtils.getColonyBuilder();
        Colony colony = builder.addColonist(lumberJackType).build();
        AIColony aiColony = aiMain.getAIColony(colony);
        game.setCurrentPlayer(colony.getOwner());
        ServerPlayer player = (ServerPlayer)colony.getOwner();
        AIColonyTest.assertEquals((String)"Wrong number of units in colony", (int)1, (int)colony.getUnitCount());
        Unit lumberjack = colony.getUnitList().get(0);
        aiColony.propertyChange(null);
        aiColony.rearrangeColony(this.lb);
        AIColonyTest.assertEquals((String)"Lumberjack should have been assigned to collect lumber", (Object)lumberType, (Object)lumberjack.getWorkType());
        colony.addGoods(lumberType, 100);
        aiColony.propertyChange(null);
        aiColony.rearrangeColony(this.lb);
        AIColonyTest.assertTrue((String)"Lumberjack should not collect lumber, in stock", (lumberType != lumberjack.getWorkType() ? 1 : 0) != 0);
    }

    public void testBestDefender() {
        ServerGame game = ServerTestHelper.startServerGame(AIColonyTest.getTestMap(savannahType));
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        Colony colony = this.getStandardColony();
        AIColonyTest.assertEquals((Object)artilleryType, (Object)colony.getBestDefenderType());
    }
}

