/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Selection;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoApplyTimestamps
implements UndoOperation {
    private String[] _timestamps;
    private int _selectionStart;

    public UndoApplyTimestamps(TrackInfo trackInfo) {
        Track track = trackInfo.getTrack();
        Selection selection = trackInfo.getSelection();
        this._selectionStart = selection.getStart();
        int n = selection.getEnd() - selection.getStart() + 1;
        this._timestamps = new String[n];
        int n2 = selection.getStart();
        while (n2 <= selection.getEnd()) {
            DataPoint dataPoint = track.getPoint(n2);
            if (!dataPoint.isWaypoint() && dataPoint.hasTimestamp()) {
                this._timestamps[n2] = dataPoint.getFieldValue(Field.TIMESTAMP);
            }
            ++n2;
        }
    }

    @Override
    public String getDescription() {
        return I18nManager.getText("undo.applytimestamps");
    }

    @Override
    public void performUndo(TrackInfo trackInfo) throws UndoException {
        int n = this._timestamps.length;
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = trackInfo.getTrack().getPoint(this._selectionStart + n2);
            if (dataPoint != null && dataPoint.hasTimestamp()) {
                dataPoint.setFieldValue(Field.TIMESTAMP, this._timestamps[n2], true);
            }
            ++n2;
        }
        UpdateMessageBroker.informSubscribers();
    }
}

