/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolNavigatorInterface;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.c.STER;
import org.jmol.thread.JmolThread;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.util.Vibration;
import org.jmol.viewer.Viewer;

public class TransformManager {
    protected Viewer vwr;
    static final int DEFAULT_SPIN_Y = 30;
    static final int DEFAULT_SPIN_FPS = 30;
    static final int DEFAULT_NAV_FPS = 10;
    public static final float DEFAULT_VISUAL_RANGE = 5.0f;
    public static final int DEFAULT_STEREO_DEGREES = -5;
    public static final int MODE_STANDARD = 0;
    public static final int MODE_NAVIGATION = 1;
    public static final int MODE_PERSPECTIVE_PYMOL = 2;
    static final int DEFAULT_PERSPECTIVE_MODEL = 11;
    static final boolean DEFAULT_PERSPECTIVE_DEPTH = true;
    static final float DEFAULT_CAMERA_DEPTH = 3.0f;
    public JmolThread movetoThread;
    public JmolThread vibrationThread;
    public JmolThread spinThread;
    public static final double degreesPerRadian = 57.29577951308232;
    protected int perspectiveModel = 11;
    protected float cameraScaleFactor;
    public float referencePlaneOffset;
    protected float aperatureAngle;
    protected float cameraDistanceFromCenter;
    public float modelCenterOffset;
    public float modelRadius;
    public float modelRadiusPixels;
    public final P3 navigationCenter = new P3();
    public final P3 navigationOffset = new P3();
    public final P3 navigationShiftXY = new P3();
    public float navigationDepthPercent;
    protected final M4 matrixTemp = new M4();
    protected final V3 vectorTemp = new V3();
    protected boolean haveNotifiedNaN = false;
    public float spinX;
    public float spinY = 30.0f;
    public float spinZ;
    public float spinFps = 30.0f;
    public float navX;
    public float navY;
    public float navZ;
    public float navFps = Float.NaN;
    public boolean isSpinInternal = false;
    public boolean isSpinFixed = false;
    boolean isSpinSelected = false;
    protected boolean doTransform4D;
    public final P3 fixedRotationOffset = new P3();
    public final P3 fixedRotationCenter = new P3();
    protected final P3 perspectiveOffset = new P3();
    protected final P3 perspectiveShiftXY = new P3();
    private final P3 rotationCenterDefault = new P3();
    private float rotationRadiusDefault;
    public final A4 fixedRotationAxis = new A4();
    public final A4 internalRotationAxis = new A4();
    protected V3 internalTranslation;
    final P3 internalRotationCenter = P3.new3(0.0f, 0.0f, 0.0f);
    private float internalRotationAngle = 0.0f;
    public final M3 matrixRotate = new M3();
    protected final M3 matrixTemp3 = new M3();
    private final M4 matrixTemp4 = new M4();
    private final A4 axisangleT = new A4();
    private final V3 vectorT = new V3();
    private final V3 vectorT2 = new V3();
    private final P3 pointT2 = new P3();
    public static final int MAXIMUM_ZOOM_PERCENTAGE = 200000;
    private static final int MAXIMUM_ZOOM_PERSPECTIVE_DEPTH = 10000;
    V3 rotationAxis = new V3();
    float rotationRate = 0.0f;
    public final P3 fixedTranslation = new P3();
    public final P3 camera = new P3();
    public final P3 cameraSetting = new P3();
    float xTranslationFraction = 0.5f;
    float yTranslationFraction = 0.5f;
    protected float prevZoomSetting;
    public float previousX;
    public float previousY;
    public boolean zoomEnabled = true;
    public float zmPct = 100.0f;
    float zmPctSet = 100.0f;
    private float zoomRatio;
    public boolean slabEnabled;
    public boolean zShadeEnabled;
    public boolean internalSlab;
    int slabPercentSetting;
    int depthPercentSetting;
    public int slabValue;
    public int depthValue;
    public int zSlabPercentSetting = 50;
    public int zDepthPercentSetting = 0;
    public P3 zSlabPoint;
    public int zSlabValue;
    public int zDepthValue;
    float slabRange = 0.0f;
    P4 slabPlane = null;
    P4 depthPlane = null;
    public boolean perspectiveDepth = true;
    protected boolean scale3D = false;
    protected float cameraDepth = 3.0f;
    protected float cameraDepthSetting = 3.0f;
    public float visualRangeAngstroms;
    public float cameraDistance = 1000.0f;
    public int width;
    public int height;
    public int screenPixelCount;
    float scalePixelsPerAngstrom;
    public float scaleDefaultPixelsPerAngstrom;
    float scale3DAngstromsPerInch;
    protected boolean antialias;
    private boolean useZoomLarge;
    private boolean zoomHeight;
    int screenWidth;
    int screenHeight;
    public final M4 matrixTransform = new M4();
    public final M4 matrixTransformInv = new M4();
    protected final P3 fScrPt = new P3();
    protected final P3i iScrPt = new P3i();
    final Point3fi ptVibTemp = new Point3fi();
    public boolean navigating = false;
    public int mode = 0;
    public int defaultMode = 0;
    protected final P3 untransformedPoint = new P3();
    protected final P3 ptTest1 = new P3();
    protected final P3 ptTest2 = new P3();
    protected final P3 ptTest3 = new P3();
    protected final A4 aaTest1 = new A4();
    protected final M3 matrixTest = new M3();
    public boolean spinOn;
    public boolean navOn;
    private boolean spinIsGesture;
    public boolean vibrationOn;
    float vibrationPeriod;
    public int vibrationPeriodMs;
    private float vibrationScale;
    private P3 vibrationT = new P3();
    STER stereoMode = STER.NONE;
    int[] stereoColors;
    boolean stereoDoubleDTI;
    boolean stereoDoubleFull;
    float stereoDegrees = Float.NaN;
    float stereoRadians;
    boolean stereoFrame;
    protected final M3 matrixStereo = new M3();
    public boolean windowCentered;
    final P3 frameOffset = new P3();
    P3[] frameOffsets;
    public BS bsFrameOffsets;
    BS bsSelectedAtoms;
    P3 ptOffset = new P3();
    public static final int NAV_MODE_IGNORE = -2;
    public static final int NAV_MODE_ZOOMED = -1;
    public static final int NAV_MODE_NONE = 0;
    public static final int NAV_MODE_RESET = 1;
    public static final int NAV_MODE_NEWXY = 2;
    public static final int NAV_MODE_NEWXYZ = 3;
    public static final int NAV_MODE_NEWZ = 4;
    public int navMode = 1;
    public float zoomFactor = Float.MAX_VALUE;
    public float navigationSlabOffset;
    private JmolNavigatorInterface nav;

    static TransformManager getTransformManager(Viewer vwr, int width, int height, boolean is4D) {
        TransformManager me = is4D ? (TransformManager)Interface.getInterface("org.jmol.viewer.TransformManager4D", vwr, "tm") : new TransformManager();
        me.vwr = vwr;
        me.setScreenParameters(width, height, true, false, true, true);
        return me;
    }

    void setDefaultPerspective() {
        this.setCameraDepthPercent(3.0f, true);
        this.setPerspectiveDepth(true);
        this.setStereoDegrees(-5.0f);
        this.visualRangeAngstroms = 5.0f;
        this.setSpinOff();
        this.setVibrationPeriod(0.0f);
    }

    public void homePosition(boolean resetSpin) {
        if (resetSpin) {
            this.setSpinOff();
        }
        this.setNavOn(false);
        this.navFps = 10.0f;
        this.navZ = 0.0f;
        this.navY = 0.0f;
        this.navX = 0.0f;
        this.rotationCenterDefault.setT(this.vwr.getBoundBoxCenter());
        this.setFixedRotationCenter(this.rotationCenterDefault);
        this.rotationRadiusDefault = this.setRotationRadius(0.0f, true);
        this.windowCentered = true;
        this.setRotationCenterAndRadiusXYZ(null, true);
        this.resetRotation();
        M3 m = (M3)this.vwr.ms.getInfoM("defaultOrientationMatrix");
        if (m != null) {
            this.setRotation(m);
        }
        this.setZoomEnabled(true);
        this.zoomToPercent(this.vwr.g.modelKitMode ? 50.0f : 100.0f);
        this.zmPct = this.zmPctSet;
        this.slabReset();
        this.resetFitToScreen(true);
        if (this.vwr.isJmolDataFrame()) {
            this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
        } else if (this.vwr.g.axesOrientationRasmol) {
            this.matrixRotate.setAsXRotation((float)Math.PI);
        }
        this.vwr.stm.saveOrientation("default", null);
        if (this.mode == 1) {
            this.setNavigationMode(true);
        }
    }

    public void setRotation(M3 m) {
        if (m.isRotation()) {
            this.matrixRotate.setM3(m);
        } else {
            this.resetRotation();
        }
    }

    public void resetRotation() {
        this.matrixRotate.setScale(1.0f);
    }

    void clearThreads() {
        this.clearVibration();
        this.clearSpin();
        this.setNavOn(false);
        this.stopMotion();
    }

    void clear() {
        this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
        this.navigating = false;
        this.slabPlane = null;
        this.depthPlane = null;
        this.zSlabPoint = null;
        this.resetNavigationPoint(true);
    }

    private void setFixedRotationCenter(T3 center) {
        if (center == null) {
            return;
        }
        this.fixedRotationCenter.setT(center);
    }

    void setRotationPointXY(P3 center) {
        P3i newCenterScreen = this.transformPt(center);
        this.fixedTranslation.set(newCenterScreen.x, newCenterScreen.y, 0.0f);
    }

    void spinXYBy(int xDelta, int yDelta, float speed) {
        if (xDelta == 0 && yDelta == 0) {
            if (this.spinThread != null && this.spinIsGesture) {
                this.clearSpin();
            }
            return;
        }
        this.clearSpin();
        P3 pt1 = P3.newP(this.fixedRotationCenter);
        P3 ptScreen = new P3();
        this.transformPt3f(pt1, ptScreen);
        P3 pt2 = P3.new3(-yDelta, xDelta, 0.0f);
        pt2.add(ptScreen);
        this.unTransformPoint(pt2, pt2);
        this.vwr.setInMotion(false);
        this.rotateAboutPointsInternal(null, pt2, pt1, 10.0f * speed, Float.NaN, false, true, null, true, null, null, null, null);
    }

    protected void rotateXYBy(float degX, float degY, BS bsAtoms) {
        this.rotate3DBall(degX, degY, bsAtoms);
    }

    void rotateZBy(int zDelta, int x, int y) {
        if (x != Integer.MAX_VALUE && y != Integer.MAX_VALUE) {
            this.resetXYCenter(x, y);
        }
        this.rotateZRadians((float)((double)zDelta / 57.29577951308232));
    }

    private void applyRotation(M3 mNew, boolean isInternal, BS bsAtoms, V3 translation, boolean translationOnly, M4 m4) {
        if (bsAtoms == null) {
            this.matrixRotate.mul2(mNew, this.matrixRotate);
            return;
        }
        this.vwr.moveAtoms(m4, mNew, this.matrixRotate, translation, this.internalRotationCenter, isInternal, bsAtoms, translationOnly);
        if (translation != null) {
            this.internalRotationCenter.add(translation);
        }
    }

    protected void rotate3DBall(float xDeg, float yDeg, BS bsAtoms) {
        if (this.matrixTemp3.setAsBallRotation((float)Math.PI / 180, -yDeg, -xDeg)) {
            this.applyRotation(this.matrixTemp3, false, bsAtoms, null, false, null);
        }
    }

    public synchronized void rotateXRadians(float angleRadians, BS bsAtoms) {
        this.applyRotation(this.matrixTemp3.setAsXRotation(angleRadians), false, bsAtoms, null, false, null);
    }

    public synchronized void rotateYRadians(float angleRadians, BS bsAtoms) {
        this.applyRotation(this.matrixTemp3.setAsYRotation(angleRadians), false, bsAtoms, null, false, null);
    }

    public synchronized void rotateZRadians(float angleRadians) {
        this.applyRotation(this.matrixTemp3.setAsZRotation(angleRadians), false, null, null, false, null);
    }

    public void rotateAxisAngle(V3 rotAxis, float radians) {
        this.axisangleT.setVA(rotAxis, radians);
        this.rotateAxisAngle2(this.axisangleT, null);
    }

    private synchronized void rotateAxisAngle2(A4 axisAngle, BS bsAtoms) {
        this.applyRotation(this.matrixTemp3.setAA(axisAngle), false, bsAtoms, null, false, null);
    }

    boolean rotateAxisAngleAtCenter(JmolScriptEvaluator eval, P3 rotCenter, V3 rotAxis, float degreesPerSecond, float endDegrees, boolean isSpin, BS bsAtoms) {
        if (rotCenter != null) {
            this.moveRotationCenter(rotCenter, true);
        }
        if (isSpin) {
            this.setSpinOff();
        }
        this.setNavOn(false);
        if (this.vwr.headless) {
            if (isSpin && endDegrees == Float.MAX_VALUE) {
                return false;
            }
            isSpin = false;
        }
        if (Float.isNaN(degreesPerSecond) || degreesPerSecond == 0.0f || endDegrees == 0.0f) {
            return false;
        }
        if (rotCenter != null) {
            this.setRotationPointXY(rotCenter);
        }
        this.setFixedRotationCenter(rotCenter);
        this.rotationAxis.setT(rotAxis);
        this.rotationRate = degreesPerSecond;
        if (isSpin) {
            this.fixedRotationAxis.setVA(rotAxis, degreesPerSecond * ((float)Math.PI / 180));
            this.isSpinInternal = false;
            this.isSpinFixed = true;
            this.isSpinSelected = bsAtoms != null;
            this.setSpin(eval, true, endDegrees, null, null, bsAtoms, false);
            return endDegrees != Float.MAX_VALUE;
        }
        float radians = endDegrees * ((float)Math.PI / 180);
        this.fixedRotationAxis.setVA(rotAxis, endDegrees);
        this.rotateAxisAngleRadiansFixed(radians, bsAtoms);
        return true;
    }

    public synchronized void rotateAxisAngleRadiansFixed(float angleRadians, BS bsAtoms) {
        this.axisangleT.setAA(this.fixedRotationAxis);
        this.axisangleT.angle = angleRadians;
        this.rotateAxisAngle2(this.axisangleT, bsAtoms);
    }

    boolean rotateAboutPointsInternal(JmolScriptEvaluator eval, T3 point1, T3 point2, float degreesPerSecond, float endDegrees, boolean isClockwise, boolean isSpin, BS bsAtoms, boolean isGesture, V3 translation, Lst<P3> finalPoints, float[] dihedralList, M4 m4) {
        boolean isSelected;
        if (isSpin) {
            this.setSpinOff();
        }
        this.setNavOn(false);
        if (dihedralList == null && (translation == null || (double)translation.length() < 0.001) && (isSpin ? Float.isNaN(degreesPerSecond) || degreesPerSecond == 0.0f : endDegrees == 0.0f)) {
            return false;
        }
        V3 axis = null;
        if (dihedralList == null) {
            axis = V3.newVsub(point2, point1);
            if (isClockwise) {
                axis.scale(-1.0f);
            }
            this.internalRotationCenter.setT(point1);
            this.rotationAxis.setT(axis);
            this.internalTranslation = translation == null ? null : V3.newV(translation);
        }
        boolean bl = isSelected = bsAtoms != null;
        if (isSpin) {
            if (dihedralList == null) {
                if (endDegrees == 0.0f) {
                    endDegrees = Float.NaN;
                }
                if (Float.isNaN(endDegrees)) {
                    this.rotationRate = degreesPerSecond;
                } else {
                    int nFrames = (int)((double)(Math.abs(endDegrees) / Math.abs(degreesPerSecond) * this.spinFps) + 0.5);
                    this.rotationRate = degreesPerSecond = endDegrees / (float)nFrames * this.spinFps;
                    if (translation != null) {
                        this.internalTranslation.scale(1.0f / (float)nFrames);
                    }
                }
                this.internalRotationAxis.setVA(axis, (Float.isNaN(this.rotationRate) ? 0.0f : this.rotationRate) * ((float)Math.PI / 180));
                this.isSpinInternal = true;
                this.isSpinFixed = false;
                this.isSpinSelected = isSelected;
            } else {
                endDegrees = degreesPerSecond;
            }
            this.setSpin(eval, true, endDegrees, finalPoints, dihedralList, bsAtoms, isGesture);
            return !Float.isNaN(endDegrees);
        }
        float radians = endDegrees * ((float)Math.PI / 180);
        this.internalRotationAxis.setVA(axis, radians);
        this.rotateAxisAngleRadiansInternal(radians, bsAtoms, m4);
        return false;
    }

    public synchronized void rotateAxisAngleRadiansInternal(float radians, BS bsAtoms, M4 m4) {
        this.internalRotationAngle = radians;
        this.vectorT.set(this.internalRotationAxis.x, this.internalRotationAxis.y, this.internalRotationAxis.z);
        this.matrixRotate.rotate2(this.vectorT, this.vectorT2);
        this.axisangleT.setVA(this.vectorT2, radians);
        this.applyRotation(this.matrixTemp3.setAA(this.axisangleT), true, bsAtoms, this.internalTranslation, radians > 1000000.0f, m4);
        if (bsAtoms == null) {
            this.getNewFixedRotationCenter();
        }
    }

    void getNewFixedRotationCenter() {
        this.axisangleT.setAA(this.internalRotationAxis);
        this.axisangleT.angle = -this.internalRotationAngle;
        this.matrixTemp4.setToAA(this.axisangleT);
        this.vectorT.setT(this.internalRotationCenter);
        this.pointT2.sub2(this.fixedRotationCenter, this.vectorT);
        T3 pt = this.matrixTemp4.rotTrans2(this.pointT2, new P3());
        pt.add(this.vectorT);
        this.setRotationCenterAndRadiusXYZ(pt, false);
    }

    void setTranslationFractions() {
        this.xTranslationFraction = this.fixedTranslation.x / (float)this.width;
        this.yTranslationFraction = this.fixedTranslation.y / (float)this.height;
    }

    public void centerAt(int x, int y, P3 pt) {
        if (pt == null) {
            this.translateXYBy(x, y);
            return;
        }
        if (this.windowCentered) {
            this.vwr.setBooleanProperty("windowCentered", false);
        }
        this.fixedTranslation.x = x;
        this.fixedTranslation.y = y;
        this.setFixedRotationCenter(pt);
    }

    public int percentToPixels(char xyz, float percent) {
        switch (xyz) {
            case 'x': {
                return (int)Math.floor(percent / 100.0f * (float)this.width);
            }
            case 'y': {
                return (int)Math.floor(percent / 100.0f * (float)this.height);
            }
            case 'z': {
                return (int)Math.floor(percent / 100.0f * (float)this.screenPixelCount);
            }
        }
        return 0;
    }

    float angstromsToPixels(float distance) {
        return this.scalePixelsPerAngstrom * distance;
    }

    void translateXYBy(int xDelta, int yDelta) {
        this.fixedTranslation.x += (float)xDelta;
        this.fixedTranslation.y += (float)yDelta;
        this.setTranslationFractions();
    }

    public void setCamera(float x, float y) {
        this.cameraSetting.set(x, y, x != 0.0f || y != 0.0f ? 1 : 0);
    }

    public void translateToPercent(char type, float percent) {
        switch (type) {
            case 'x': {
                this.xTranslationFraction = 0.5f + percent / 100.0f;
                this.fixedTranslation.x = (float)this.width * this.xTranslationFraction;
                return;
            }
            case 'y': {
                this.yTranslationFraction = 0.5f + percent / 100.0f;
                this.fixedTranslation.y = (float)this.height * this.yTranslationFraction;
                return;
            }
            case 'z': {
                if (this.mode == 1) {
                    this.setNavigationDepthPercent(percent);
                }
                return;
            }
        }
    }

    public float getTranslationXPercent() {
        return this.width == 0 ? 0.0f : (this.fixedTranslation.x - (float)this.width / 2.0f) * 100.0f / (float)this.width;
    }

    public float getTranslationYPercent() {
        return this.height == 0 ? 0.0f : (this.fixedTranslation.y - (float)this.height / 2.0f) * 100.0f / (float)this.height;
    }

    public String getTranslationScript() {
        String info = "";
        float f = this.getTranslationXPercent();
        if ((double)f != 0.0) {
            info = info + "translate x " + f + ";";
        }
        if ((double)(f = this.getTranslationYPercent()) != 0.0) {
            info = info + "translate y " + f + ";";
        }
        return info;
    }

    String getOrientationText(int type, boolean isBest) {
        switch (type) {
            case 4129: {
                return this.getMoveToText(1.0f, false);
            }
            case 1073742132: {
                Quat q = this.getRotationQ();
                if (isBest) {
                    q = q.inv();
                }
                return q.toString();
            }
            case 1073742178: {
                SB sb = new SB();
                float d = this.getTranslationXPercent();
                TransformManager.truncate2(sb, isBest ? -d : d);
                d = this.getTranslationYPercent();
                TransformManager.truncate2(sb, isBest ? -d : d);
                return sb.toString();
            }
        }
        return this.getMoveToText(1.0f, true) + "\n#OR\n" + this.getRotateZyzText(true);
    }

    public Quat getRotationQ() {
        return Quat.newM(this.matrixRotate);
    }

    Map<String, Object> getOrientationInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("moveTo", this.getMoveToText(1.0f, false));
        info.put("center", "center " + this.getCenterText());
        info.put("centerPt", this.fixedRotationCenter);
        A4 aa = new A4();
        aa.setM(this.matrixRotate);
        info.put("axisAngle", aa);
        info.put("quaternion", this.getRotationQ().toPoint4f());
        info.put("rotationMatrix", this.matrixRotate);
        info.put("rotateZYZ", this.getRotateZyzText(false));
        info.put("rotateXYZ", this.getRotateXyzText());
        info.put("transXPercent", Float.valueOf(this.getTranslationXPercent()));
        info.put("transYPercent", Float.valueOf(this.getTranslationYPercent()));
        info.put("zoom", Float.valueOf(this.zmPct));
        info.put("modelRadius", Float.valueOf(this.modelRadius));
        if (this.mode == 1) {
            info.put("navigationCenter", "navigate center " + Escape.eP(this.navigationCenter));
            info.put("navigationOffsetXPercent", Float.valueOf(this.getNavigationOffsetPercent('X')));
            info.put("navigationOffsetYPercent", Float.valueOf(this.getNavigationOffsetPercent('Y')));
            info.put("navigationDepthPercent", Float.valueOf(this.navigationDepthPercent));
        }
        return info;
    }

    public void getRotation(M3 m) {
        m.setM3(this.matrixRotate);
    }

    public void setZoomHeight(boolean zoomHeight, boolean zoomLarge) {
        this.zoomHeight = zoomHeight;
        this.scaleFitToScreen(false, zoomLarge, false, true);
    }

    protected void zoomBy(int pixels) {
        if (pixels > 20) {
            pixels = 20;
        } else if (pixels < -20) {
            pixels = -20;
        }
        float deltaPercent = (float)pixels * this.zmPctSet / 50.0f;
        if (deltaPercent == 0.0f) {
            deltaPercent = pixels > 0 ? 1 : (deltaPercent < 0.0f ? -1 : 0);
        }
        this.zoomRatio = (deltaPercent + this.zmPctSet) / this.zmPctSet;
        this.zmPctSet += deltaPercent;
    }

    void zoomByFactor(float factor, int x, int y) {
        if (factor <= 0.0f || !this.zoomEnabled) {
            return;
        }
        if (this.mode != 1) {
            this.zoomRatio = factor;
            this.zmPctSet *= factor;
            this.resetXYCenter(x, y);
        } else if (this.getNav()) {
            this.nav.zoomByFactor(factor, x, y);
        }
    }

    public void zoomToPercent(float percentZoom) {
        this.zmPctSet = percentZoom;
        this.zoomRatio = 0.0f;
    }

    void translateZBy(int pixels) {
        if (pixels >= this.screenPixelCount) {
            return;
        }
        float sppa = this.scalePixelsPerAngstrom / (1.0f - (float)pixels * 1.0f / (float)this.screenPixelCount);
        if (sppa >= (float)this.screenPixelCount) {
            return;
        }
        float newZoomPercent = sppa / this.scaleDefaultPixelsPerAngstrom * 100.0f;
        this.zoomRatio = newZoomPercent / this.zmPctSet;
        this.zmPctSet = newZoomPercent;
    }

    private void resetXYCenter(int x, int y) {
        if (x == Integer.MAX_VALUE || y == Integer.MAX_VALUE) {
            return;
        }
        if (this.windowCentered) {
            this.vwr.setBooleanProperty("windowCentered", false);
        }
        P3 pt = new P3();
        this.transformPt3f(this.fixedRotationCenter, pt);
        pt.set(x, y, pt.z);
        this.unTransformPoint(pt, pt);
        this.fixedTranslation.set(x, y, 0.0f);
        this.setFixedRotationCenter(pt);
    }

    void zoomByPercent(float percentZoom) {
        float deltaPercent = percentZoom * this.zmPctSet / 100.0f;
        if (deltaPercent == 0.0f) {
            deltaPercent = percentZoom < 0.0f ? -1.0f : 1.0f;
        }
        this.zoomRatio = (deltaPercent + this.zmPctSet) / this.zmPctSet;
        this.zmPctSet += deltaPercent;
    }

    void setScaleAngstromsPerInch(float angstromsPerInch) {
        boolean bl = this.scale3D = angstromsPerInch > 0.0f;
        if (this.scale3D) {
            this.scale3DAngstromsPerInch = angstromsPerInch;
        }
        this.perspectiveDepth = !this.scale3D;
    }

    public void setSlabRange(float value) {
        this.slabRange = value;
    }

    void setSlabEnabled(boolean slabEnabled) {
        this.slabEnabled = slabEnabled;
        this.vwr.g.setB("slabEnabled", this.slabEnabled);
    }

    void setZShadeEnabled(boolean zShadeEnabled) {
        this.zShadeEnabled = zShadeEnabled;
        this.vwr.g.setB("zShade", zShadeEnabled);
    }

    void setZoomEnabled(boolean zoomEnabled) {
        this.zoomEnabled = zoomEnabled;
        this.vwr.g.setB("zoomEnabled", zoomEnabled);
    }

    public void slabReset() {
        this.slabToPercent(100);
        this.depthToPercent(0);
        this.depthPlane = null;
        this.slabPlane = null;
        this.setSlabEnabled(false);
        this.setZShadeEnabled(false);
        this.slabDepthChanged();
    }

    public int getSlabPercentSetting() {
        return this.slabPercentSetting;
    }

    private void slabDepthChanged() {
        this.vwr.g.setI("slab", this.slabPercentSetting);
        this.vwr.g.setI("depth", this.depthPercentSetting);
        this.finalizeTransformParameters();
    }

    void slabByPercentagePoints(int percentage) {
        this.slabPlane = null;
        if (percentage < 0 ? this.slabPercentSetting <= Math.max(0, this.depthPercentSetting) : this.slabPercentSetting >= 100) {
            return;
        }
        this.slabPercentSetting += percentage;
        this.slabDepthChanged();
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void depthByPercentagePoints(int percentage) {
        this.depthPlane = null;
        if (percentage < 0 ? this.depthPercentSetting <= 0 : this.depthPercentSetting >= Math.min(100, this.slabPercentSetting)) {
            return;
        }
        this.depthPercentSetting += percentage;
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
        this.slabDepthChanged();
    }

    void slabDepthByPercentagePoints(int percentage) {
        this.slabPlane = null;
        this.depthPlane = null;
        if (percentage < 0 ? this.slabPercentSetting <= Math.max(0, this.depthPercentSetting) : this.depthPercentSetting >= Math.min(100, this.slabPercentSetting)) {
            return;
        }
        this.slabPercentSetting += percentage;
        this.depthPercentSetting += percentage;
        this.slabDepthChanged();
    }

    public void slabToPercent(int percentSlab) {
        this.slabPlane = null;
        this.vwr.setFloatProperty("slabRange", 0.0f);
        this.slabPercentSetting = percentSlab;
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
        this.slabDepthChanged();
    }

    public void depthToPercent(int percentDepth) {
        this.depthPlane = null;
        this.vwr.g.setI("depth", percentDepth);
        this.depthPercentSetting = percentDepth;
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
        this.slabDepthChanged();
    }

    void zSlabToPercent(int percentSlab) {
        this.zSlabPercentSetting = percentSlab;
        if (this.zDepthPercentSetting > this.zSlabPercentSetting) {
            this.zDepthPercentSetting = percentSlab;
        }
    }

    void zDepthToPercent(int percentDepth) {
        this.zDepthPercentSetting = percentDepth;
        if (this.zDepthPercentSetting > this.zSlabPercentSetting) {
            this.zSlabPercentSetting = percentDepth;
        }
    }

    public void slabInternal(P4 plane, boolean isDepth) {
        if (isDepth) {
            this.depthPlane = plane;
            this.depthPercentSetting = 0;
        } else {
            this.slabPlane = plane;
            this.slabPercentSetting = 100;
        }
        this.slabDepthChanged();
    }

    public void setSlabDepthInternal(boolean isDepth) {
        if (isDepth) {
            this.depthPlane = null;
        } else {
            this.slabPlane = null;
        }
        this.finalizeTransformParameters();
        this.slabInternal(this.getSlabDepthPlane(isDepth), isDepth);
    }

    private P4 getSlabDepthPlane(boolean isDepth) {
        if (isDepth) {
            if (this.depthPlane != null) {
                return this.depthPlane;
            }
        } else if (this.slabPlane != null) {
            return this.slabPlane;
        }
        M4 m = this.matrixTransform;
        P4 plane = P4.new4(-m.m20, -m.m21, -m.m22, -m.m23 + (float)(isDepth ? this.depthValue : this.slabValue));
        return plane;
    }

    public P3[] getCameraFactors() {
        this.aperatureAngle = (float)(Math.atan2((float)this.screenPixelCount / 2.0f, this.referencePlaneOffset) * 2.0 * 180.0 / Math.PI);
        this.cameraDistanceFromCenter = this.referencePlaneOffset / this.scalePixelsPerAngstrom;
        P3 ptRef = P3.new3(this.screenWidth / 2, this.screenHeight / 2, this.referencePlaneOffset);
        this.unTransformPoint(ptRef, ptRef);
        P3 ptCamera = P3.new3(this.screenWidth / 2, this.screenHeight / 2, 0.0f);
        this.unTransformPoint(ptCamera, ptCamera);
        ptCamera.sub(this.fixedRotationCenter);
        P3 pt = P3.new3(this.screenWidth / 2, this.screenHeight / 2, this.cameraDistanceFromCenter * this.scalePixelsPerAngstrom);
        this.unTransformPoint(pt, pt);
        pt.sub(this.fixedRotationCenter);
        ptCamera.add(pt);
        return new P3[]{ptRef, ptCamera, this.fixedRotationCenter, P3.new3(this.cameraDistanceFromCenter, this.aperatureAngle, this.scalePixelsPerAngstrom)};
    }

    void setPerspectiveDepth(boolean perspectiveDepth) {
        if (this.perspectiveDepth == perspectiveDepth) {
            return;
        }
        this.perspectiveDepth = perspectiveDepth;
        this.vwr.g.setB("perspectiveDepth", perspectiveDepth);
        this.resetFitToScreen(false);
    }

    public boolean getPerspectiveDepth() {
        return this.perspectiveDepth;
    }

    public void setCameraDepthPercent(float percent, boolean resetSlab) {
        float screenMultiples;
        this.resetNavigationPoint(resetSlab);
        float f = screenMultiples = percent < 0.0f ? -percent / 100.0f : percent;
        if (screenMultiples == 0.0f) {
            return;
        }
        this.cameraDepthSetting = screenMultiples;
        this.vwr.g.setF("cameraDepth", this.cameraDepthSetting);
        this.cameraDepth = Float.NaN;
    }

    public float getCameraDepth() {
        return this.cameraDepthSetting;
    }

    private void setScreenParameters0(int screenWidth, int screenHeight, boolean useZoomLarge, boolean antialias, boolean resetSlab, boolean resetZoom) {
        if (screenWidth == Integer.MAX_VALUE) {
            return;
        }
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.useZoomLarge = useZoomLarge;
        this.antialias = antialias;
        this.width = antialias ? screenWidth * 2 : screenWidth;
        this.height = antialias ? screenHeight * 2 : screenHeight;
        this.scaleFitToScreen(false, useZoomLarge, resetSlab, resetZoom);
    }

    void setAntialias(boolean TF) {
        boolean isNew = this.antialias != TF;
        this.antialias = TF;
        this.width = this.antialias ? this.screenWidth * 2 : this.screenWidth;
        int n = this.height = this.antialias ? this.screenHeight * 2 : this.screenHeight;
        if (isNew) {
            this.scaleFitToScreen(false, this.useZoomLarge, false, false);
        }
    }

    public float defaultScaleToScreen(float radius) {
        return (float)this.screenPixelCount / 2.0f / radius;
    }

    private void resetFitToScreen(boolean andCenter) {
        this.scaleFitToScreen(andCenter, this.vwr.g.zoomLarge, true, true);
    }

    void scaleFitToScreen(boolean andCenter, boolean zoomLarge, boolean resetSlab, boolean resetZoom) {
        if (this.width == 0 || this.height == 0) {
            this.screenPixelCount = 1;
        } else {
            this.fixedTranslation.set((float)this.width * (andCenter ? 0.5f : this.xTranslationFraction), (float)this.height * (andCenter ? 0.5f : this.yTranslationFraction), 0.0f);
            this.setTranslationFractions();
            if (andCenter) {
                this.camera.set(0.0f, 0.0f, 0.0f);
            }
            if (resetZoom) {
                this.resetNavigationPoint(resetSlab);
            }
            if (this.zoomHeight) {
                zoomLarge = this.height > this.width;
            }
            int n = this.screenPixelCount = zoomLarge == this.height > this.width ? this.height : this.width;
        }
        if (this.screenPixelCount > 2) {
            this.screenPixelCount -= 2;
        }
        this.scaleDefaultPixelsPerAngstrom = this.defaultScaleToScreen(this.modelRadius);
    }

    public float scaleToScreen(int z, int milliAngstroms) {
        if (milliAngstroms == 0 || z < 2) {
            return 0.0f;
        }
        float pixelSize = this.scaleToPerspective(z, (float)milliAngstroms * this.scalePixelsPerAngstrom / 1000.0f);
        return pixelSize > 0.0f ? pixelSize : 1.0f;
    }

    public float unscaleToScreen(float z, float screenDistance) {
        float d = screenDistance / this.scalePixelsPerAngstrom;
        return this.perspectiveDepth ? d / this.getPerspectiveFactor(z) : d;
    }

    public float scaleToPerspective(int z, float sizeAngstroms) {
        return this.perspectiveDepth ? sizeAngstroms * this.getPerspectiveFactor(z) : sizeAngstroms;
    }

    void setNavigationMode(boolean TF) {
        this.mode = TF ? 1 : this.defaultMode;
        this.resetNavigationPoint(true);
    }

    public boolean isNavigating() {
        return this.navigating || this.navOn;
    }

    public synchronized void finalizeTransformParameters() {
        this.haveNotifiedNaN = false;
        this.fixedRotationOffset.setT(this.fixedTranslation);
        this.camera.setT(this.cameraSetting);
        this.internalSlab = this.slabEnabled && (this.slabPlane != null || this.depthPlane != null);
        float newZoom = this.getZoomSetting();
        if (this.zmPct != newZoom) {
            this.zmPct = newZoom;
            if (!this.vwr.g.fontCaching) {
                this.vwr.gdata.clearFontCache();
            }
        }
        this.calcCameraFactors();
        this.calcTransformMatrix();
        if (this.mode == 1) {
            this.calcNavigationPoint();
        } else {
            this.calcSlabAndDepthValues();
        }
    }

    public float getZoomSetting() {
        if (this.zmPctSet < 5.0f) {
            this.zmPctSet = 5.0f;
        }
        if (this.zmPctSet > 200000.0f) {
            this.zmPctSet = 200000.0f;
        }
        return this.zoomEnabled || this.mode == 1 ? this.zmPctSet : 100.0f;
    }

    public void calcSlabAndDepthValues() {
        this.slabValue = this.slabRange < 1.0f ? this.zValueFromPercent(this.slabPercentSetting) : (int)Math.floor(this.modelCenterOffset * this.slabRange / (2.0f * this.modelRadius) * (this.zmPctSet / 100.0f));
        this.depthValue = this.zValueFromPercent(this.depthPercentSetting);
        if (this.zSlabPercentSetting == this.zDepthPercentSetting) {
            this.zSlabValue = this.slabValue;
            this.zDepthValue = this.depthValue;
        } else {
            this.zSlabValue = this.zValueFromPercent(this.zSlabPercentSetting);
            this.zDepthValue = this.zValueFromPercent(this.zDepthPercentSetting);
        }
        if (this.zSlabPoint != null) {
            try {
                this.transformPt3f(this.zSlabPoint, this.pointT2);
                this.zSlabValue = (int)this.pointT2.z;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.vwr.g.setO("_slabPlane", Escape.eP4(this.getSlabDepthPlane(false)));
        this.vwr.g.setO("_depthPlane", Escape.eP4(this.getSlabDepthPlane(true)));
        if (this.slabEnabled) {
            return;
        }
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
    }

    public int zValueFromPercent(int zPercent) {
        return (int)Math.floor((1.0f - (float)zPercent / 50.0f) * this.modelRadiusPixels + this.modelCenterOffset);
    }

    public synchronized void calcTransformMatrix() {
        this.matrixTransform.setIdentity();
        this.vectorTemp.sub2(this.frameOffset, this.fixedRotationCenter);
        this.matrixTransform.setTranslation(this.vectorTemp);
        this.matrixTemp.setToM3(this.stereoFrame ? this.matrixStereo : this.matrixRotate);
        this.matrixTransform.mul2(this.matrixTemp, this.matrixTransform);
        this.matrixTemp.setIdentity();
        this.matrixTemp.m11 = this.matrixTemp.m22 = this.scalePixelsPerAngstrom;
        this.matrixTemp.m00 = this.matrixTemp.m22;
        this.matrixTemp.m11 = this.matrixTemp.m22 = -this.scalePixelsPerAngstrom;
        this.matrixTransform.mul2(this.matrixTemp, this.matrixTransform);
        this.matrixTransform.m23 += this.modelCenterOffset;
        try {
            this.matrixTransformInv.setM4(this.matrixTransform).invert();
        }
        catch (Exception e) {
            System.out.println("ERROR INVERTING matrixTransform!");
        }
    }

    public void rotatePoint(T3 pt, T3 ptRot) {
        this.matrixRotate.rotate2(pt, ptRot);
        ptRot.y = -ptRot.y;
    }

    protected void getScreenTemp(T3 ptXYZ) {
        this.matrixTransform.rotTrans2(ptXYZ, this.fScrPt);
    }

    public void transformPtScr(T3 ptXYZ, P3i pointScreen) {
        pointScreen.setT(this.transformPt(ptXYZ));
    }

    public void transformPtScrT3(T3 ptXYZ, T3 pointScreen) {
        this.transformPt(ptXYZ);
        pointScreen.setT(this.fScrPt);
    }

    public void transformPt3f(T3 ptXYZ, P3 screen) {
        this.applyPerspective(ptXYZ, ptXYZ);
        screen.setT(this.fScrPt);
    }

    public void transformPtNoClip(T3 ptXYZ, T3 pointScreen) {
        this.applyPerspective(ptXYZ, null);
        pointScreen.setT(this.fScrPt);
    }

    public synchronized P3i transformPt(T3 ptXYZ) {
        return this.applyPerspective(ptXYZ, this.internalSlab ? ptXYZ : null);
    }

    public P3i transformPtVib(P3 ptXYZ, Vibration v) {
        this.ptVibTemp.setT(ptXYZ);
        return this.applyPerspective(this.getVibrationPoint(v, this.ptVibTemp, Float.NaN), ptXYZ);
    }

    public T3 getVibrationPoint(Vibration v, T3 pt, float scale) {
        return v.setCalcPoint(pt, this.vibrationT, Float.isNaN(scale) ? this.vibrationScale : scale, this.vwr.g.modulationScale);
    }

    public void transformPt2Df(T3 v, P3 pt) {
        if (v.z == -3.4028235E38f || v.z == Float.MAX_VALUE) {
            this.transformPt2D(v);
            pt.set(this.iScrPt.x, this.iScrPt.y, this.iScrPt.z);
        } else {
            this.transformPt3f(v, pt);
        }
    }

    public void transformPtScrT32D(T3 v, P3 pt) {
        if (v.z == -3.4028235E38f || v.z == Float.MAX_VALUE) {
            this.transformPt2D(v);
            pt.set(this.iScrPt.x, this.iScrPt.y, this.iScrPt.z);
        } else {
            this.transformPtScrT3(v, pt);
        }
    }

    public synchronized P3i transformPt2D(T3 ptXyp) {
        if (ptXyp.z == -3.4028235E38f) {
            this.iScrPt.x = (int)Math.floor(ptXyp.x / 100.0f * (float)this.screenWidth);
            this.iScrPt.y = (int)Math.floor((1.0f - ptXyp.y / 100.0f) * (float)this.screenHeight);
        } else {
            this.iScrPt.x = (int)ptXyp.x;
            this.iScrPt.y = this.screenHeight - (int)ptXyp.y;
        }
        if (this.antialias) {
            this.iScrPt.x <<= 1;
            this.iScrPt.y <<= 1;
        }
        this.matrixTransform.rotTrans2(this.fixedRotationCenter, this.fScrPt);
        this.iScrPt.z = (int)this.fScrPt.z;
        return this.iScrPt;
    }

    private P3i applyPerspective(T3 ptXYZ, T3 ptRef) {
        this.getScreenTemp(ptXYZ);
        float z = this.fScrPt.z;
        if (Float.isNaN(z)) {
            if (!this.haveNotifiedNaN && Logger.debugging) {
                Logger.debug("NaN seen in TransformPoint");
            }
            this.haveNotifiedNaN = true;
            this.fScrPt.z = 1.0f;
            z = 1.0f;
        } else if (z <= 0.0f) {
            this.fScrPt.z = 1.0f;
            z = 1.0f;
        }
        switch (this.mode) {
            case 1: {
                this.fScrPt.x -= this.navigationShiftXY.x;
                this.fScrPt.y -= this.navigationShiftXY.y;
                break;
            }
            case 2: {
                this.fScrPt.x += this.perspectiveShiftXY.x;
                this.fScrPt.y += this.perspectiveShiftXY.y;
            }
        }
        if (this.perspectiveDepth) {
            float factor = this.getPerspectiveFactor(z);
            this.fScrPt.x *= factor;
            this.fScrPt.y *= factor;
        }
        switch (this.mode) {
            case 1: {
                this.fScrPt.x += this.navigationOffset.x;
                this.fScrPt.y += this.navigationOffset.y;
                break;
            }
            case 2: {
                this.fScrPt.x -= this.perspectiveShiftXY.x;
                this.fScrPt.y -= this.perspectiveShiftXY.y;
            }
            case 0: {
                this.fScrPt.x += this.fixedRotationOffset.x;
                this.fScrPt.y += this.fixedRotationOffset.y;
            }
        }
        if (Float.isNaN(this.fScrPt.x) && !this.haveNotifiedNaN) {
            if (Logger.debugging) {
                Logger.debug("NaN found in transformPoint ");
            }
            this.haveNotifiedNaN = true;
        }
        this.iScrPt.set((int)this.fScrPt.x, (int)this.fScrPt.y, (int)this.fScrPt.z);
        if (ptRef != null && this.xyzIsSlabbedInternal(ptRef)) {
            this.iScrPt.z = 1;
            this.fScrPt.z = 1;
        }
        return this.iScrPt;
    }

    public boolean xyzIsSlabbedInternal(T3 ptRef) {
        return this.slabPlane != null && ptRef.x * this.slabPlane.x + ptRef.y * this.slabPlane.y + ptRef.z * this.slabPlane.z + this.slabPlane.w > 0.0f || this.depthPlane != null && ptRef.x * this.depthPlane.x + ptRef.y * this.depthPlane.y + ptRef.z * this.depthPlane.z + this.depthPlane.w < 0.0f;
    }

    void move(JmolScriptEvaluator eval, V3 dRot, float dZoom, V3 dTrans, float dSlab, float floatSecondsTotal, int fps) {
        this.movetoThread = (JmolThread)Interface.getOption("thread.MoveToThread", this.vwr, "tm");
        this.movetoThread.setManager(this, this.vwr, new Object[]{dRot, dTrans, new float[]{dZoom, dSlab, floatSecondsTotal, fps}});
        if (floatSecondsTotal > 0.0f) {
            this.movetoThread.setEval(eval);
        }
        this.movetoThread.run();
    }

    public boolean isInPosition(V3 axis, float degrees) {
        if (Float.isNaN(degrees)) {
            return true;
        }
        this.aaTest1.setVA(axis, (float)((double)degrees / 57.29577951308232));
        this.ptTest1.set(4.321f, 1.23456f, 3.14159f);
        this.getRotation(this.matrixTest);
        this.matrixTest.rotate2(this.ptTest1, this.ptTest2);
        this.matrixTest.setAA(this.aaTest1).rotate2(this.ptTest1, this.ptTest3);
        return (double)this.ptTest3.distance(this.ptTest2) < 0.1;
    }

    public boolean moveToPyMOL(JmolScriptEvaluator eval, float floatSecondsTotal, float[] pymolView) {
        M3 m3 = M3.newA9(pymolView);
        m3.invert();
        float cameraX = pymolView[9];
        float cameraY = -pymolView[10];
        float pymolDistanceToCenter = -pymolView[11];
        P3 center = P3.new3(pymolView[12], pymolView[13], pymolView[14]);
        float pymolDistanceToSlab = pymolView[15];
        float pymolDistanceToDepth = pymolView[16];
        float fov = pymolView[17];
        boolean isOrtho = fov >= 0.0f;
        this.setPerspectiveDepth(!isOrtho);
        float theta = Math.abs(fov) / 2.0f;
        float tan = (float)Math.tan((double)theta * Math.PI / 180.0);
        float rotationRadius = pymolDistanceToCenter * tan;
        float jmolCameraToCenter = 0.5f / tan;
        float cameraDepth = jmolCameraToCenter - 0.5f;
        float f = 50.0f / rotationRadius;
        if (pymolDistanceToSlab > 0.0f) {
            int slab = 50 + (int)((pymolDistanceToCenter - pymolDistanceToSlab) * f);
            int depth = 50 + (int)((pymolDistanceToCenter - pymolDistanceToDepth) * f);
            this.setSlabEnabled(true);
            this.slabToPercent(slab);
            this.depthToPercent(depth);
            if (pymolView.length == 21) {
                boolean depthCue = pymolView[18] != 0.0f;
                boolean fog = pymolView[19] != 0.0f;
                float fogStart = pymolView[20];
                this.setZShadeEnabled(depthCue);
                if (depthCue) {
                    if (fog) {
                        this.vwr.setIntProperty("zSlab", (int)Math.min(100.0f, (float)slab + fogStart * (float)(depth - slab)));
                    } else {
                        this.vwr.setIntProperty("zSlab", (int)((float)(slab + depth) / 2.0f));
                    }
                    this.vwr.setIntProperty("zDepth", depth);
                }
            }
        }
        this.moveTo(eval, floatSecondsTotal, center, null, 0.0f, m3, 100.0f, Float.NaN, Float.NaN, rotationRadius, null, Float.NaN, Float.NaN, Float.NaN, cameraDepth, cameraX, cameraY);
        return true;
    }

    void moveTo(JmolScriptEvaluator eval, float floatSecondsTotal, P3 center, T3 rotAxis, float degrees, M3 matrixEnd, float zoom, float xTrans, float yTrans, float newRotationRadius, P3 navCenter, float xNav, float yNav, float navDepth, float cameraDepth, float cameraX, float cameraY) {
        float pixelScale;
        if (matrixEnd == null) {
            matrixEnd = new M3();
            V3 axis = V3.newV(rotAxis);
            if (Float.isNaN(degrees)) {
                matrixEnd.m00 = Float.NaN;
            } else if (degrees < 0.01f && degrees > -0.01f) {
                matrixEnd.setScale(1.0f);
            } else {
                if (axis.x == 0.0f && axis.y == 0.0f && axis.z == 0.0f) {
                    return;
                }
                A4 aaMoveTo = new A4();
                aaMoveTo.setVA(axis, (float)((double)degrees / 57.29577951308232));
                matrixEnd.setAA(aaMoveTo);
            }
        }
        if (cameraX == this.cameraSetting.x) {
            cameraX = Float.NaN;
        }
        if (cameraY == this.cameraSetting.y) {
            cameraY = Float.NaN;
        }
        if (cameraDepth == this.cameraDepth) {
            cameraDepth = Float.NaN;
        }
        if (!Float.isNaN(cameraX)) {
            xTrans = cameraX * 50.0f / newRotationRadius / (float)this.width * (float)this.screenPixelCount;
        }
        if (!Float.isNaN(cameraY)) {
            yTrans = cameraY * 50.0f / newRotationRadius / (float)this.height * (float)this.screenPixelCount;
        }
        float f = pixelScale = center == null ? this.scaleDefaultPixelsPerAngstrom : this.defaultScaleToScreen(newRotationRadius);
        if (floatSecondsTotal <= 0.0f) {
            this.setAll(center, matrixEnd, navCenter, zoom, xTrans, yTrans, newRotationRadius, pixelScale, navDepth, xNav, yNav, cameraDepth, cameraX, cameraY);
            this.vwr.moveUpdate(floatSecondsTotal);
            this.vwr.finalizeTransformParameters();
            return;
        }
        try {
            int nSteps;
            if (this.movetoThread == null) {
                this.movetoThread = (JmolThread)Interface.getOption("thread.MoveToThread", this.vwr, "tm");
            }
            if ((nSteps = this.movetoThread.setManager(this, this.vwr, new Object[]{center, matrixEnd, navCenter, new float[]{floatSecondsTotal, zoom, xTrans, yTrans, newRotationRadius, pixelScale, navDepth, xNav, yNav, cameraDepth, cameraX, cameraY}})) <= 0 || this.vwr.g.waitForMoveTo) {
                if (nSteps > 0) {
                    this.movetoThread.setEval(eval);
                }
                this.movetoThread.run();
                if (!this.vwr.isSingleThreaded) {
                    this.movetoThread = null;
                }
            } else {
                this.movetoThread.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAll(P3 center, M3 m, P3 navCenter, float zoom, float xTrans, float yTrans, float rotationRadius, float pixelScale, float navDepth, float xNav, float yNav, float cameraDepth, float cameraX, float cameraY) {
        if (!Float.isNaN(m.m00)) {
            this.setRotation(m);
        }
        if (center != null) {
            this.moveRotationCenter(center, !this.windowCentered);
        }
        if (navCenter != null && this.mode == 1) {
            this.navigationCenter.setT(navCenter);
        }
        if (!Float.isNaN(cameraDepth)) {
            this.setCameraDepthPercent(cameraDepth, false);
        }
        if (!Float.isNaN(cameraX) && !Float.isNaN(cameraY)) {
            this.setCamera(cameraX, cameraY);
        }
        if (!Float.isNaN(zoom)) {
            this.zoomToPercent(zoom);
        }
        if (!Float.isNaN(rotationRadius)) {
            this.modelRadius = rotationRadius;
        }
        if (!Float.isNaN(pixelScale)) {
            this.scaleDefaultPixelsPerAngstrom = pixelScale;
        }
        if (!Float.isNaN(xTrans) && !Float.isNaN(yTrans)) {
            this.translateToPercent('x', xTrans);
            this.translateToPercent('y', yTrans);
        }
        if (this.mode == 1) {
            if (!Float.isNaN(xNav) && !Float.isNaN(yNav)) {
                this.navTranslatePercentOrTo(0.0f, xNav, yNav);
            }
            if (!Float.isNaN(navDepth)) {
                this.setNavigationDepthPercent(navDepth);
            }
        }
    }

    public void stopMotion() {
        this.movetoThread = null;
    }

    String getRotationText() {
        this.axisangleT.setM(this.matrixRotate);
        float degrees = (float)((double)this.axisangleT.angle * 57.29577951308232);
        SB sb = new SB();
        this.vectorT.set(this.axisangleT.x, this.axisangleT.y, this.axisangleT.z);
        if (degrees < 0.01f) {
            return "{0 0 1 0}";
        }
        this.vectorT.normalize();
        this.vectorT.scale(1000.0f);
        sb.append("{");
        TransformManager.truncate0(sb, this.vectorT.x);
        TransformManager.truncate0(sb, this.vectorT.y);
        TransformManager.truncate0(sb, this.vectorT.z);
        TransformManager.truncate2(sb, degrees);
        sb.append("}");
        return sb.toString();
    }

    public String getMoveToText(float timespan, boolean addComments) {
        this.finalizeTransformParameters();
        SB sb = new SB();
        sb.append("moveto ");
        if (addComments) {
            sb.append("/* time, axisAngle */ ");
        }
        sb.appendF(timespan);
        sb.append(" ").append(this.getRotationText());
        if (addComments) {
            sb.append(" /* zoom, translation */ ");
        }
        TransformManager.truncate2(sb, this.zmPctSet);
        TransformManager.truncate2(sb, this.getTranslationXPercent());
        TransformManager.truncate2(sb, this.getTranslationYPercent());
        sb.append(" ");
        if (addComments) {
            sb.append(" /* center, rotationRadius */ ");
        }
        sb.append(this.getCenterText());
        sb.append(" ").appendF(this.modelRadius);
        sb.append(this.getNavigationText(addComments));
        if (addComments) {
            sb.append(" /* cameraDepth, cameraX, cameraY */ ");
        }
        TransformManager.truncate2(sb, this.cameraDepth);
        TransformManager.truncate2(sb, this.cameraSetting.x);
        TransformManager.truncate2(sb, this.cameraSetting.y);
        sb.append(";");
        return sb.toString();
    }

    private String getCenterText() {
        return Escape.eP(this.fixedRotationCenter);
    }

    private String getRotateXyzText() {
        float rZ;
        float rX;
        SB sb = new SB();
        float m20 = this.matrixRotate.m20;
        float rY = -((float)(Math.asin(m20) * 57.29577951308232));
        if (m20 > 0.999f || m20 < -0.999f) {
            rX = -((float)(Math.atan2(this.matrixRotate.m12, this.matrixRotate.m11) * 57.29577951308232));
            rZ = 0.0f;
        } else {
            rX = (float)(Math.atan2(this.matrixRotate.m21, this.matrixRotate.m22) * 57.29577951308232);
            rZ = (float)(Math.atan2(this.matrixRotate.m10, this.matrixRotate.m00) * 57.29577951308232);
        }
        sb.append("reset");
        sb.append(";center ").append(this.getCenterText());
        if (rX != 0.0f) {
            sb.append("; rotate x");
            TransformManager.truncate2(sb, rX);
        }
        if (rY != 0.0f) {
            sb.append("; rotate y");
            TransformManager.truncate2(sb, rY);
        }
        if (rZ != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate2(sb, rZ);
        }
        sb.append(";");
        this.addZoomTranslationNavigationText(sb);
        return sb.toString();
    }

    private void addZoomTranslationNavigationText(SB sb) {
        float tY;
        float tX;
        if (this.zmPct != 100.0f) {
            sb.append(" zoom");
            TransformManager.truncate2(sb, this.zmPct);
            sb.append(";");
        }
        if ((tX = this.getTranslationXPercent()) != 0.0f) {
            sb.append(" translate x");
            TransformManager.truncate2(sb, tX);
            sb.append(";");
        }
        if ((tY = this.getTranslationYPercent()) != 0.0f) {
            sb.append(" translate y");
            TransformManager.truncate2(sb, tY);
            sb.append(";");
        }
        if (this.modelRadius != this.rotationRadiusDefault || this.modelRadius == 10.0f) {
            sb.append(" set rotationRadius");
            TransformManager.truncate2(sb, this.modelRadius);
            sb.append(";");
        }
        if (this.mode == 1) {
            sb.append("navigate 0 center ").append(Escape.eP(this.navigationCenter));
            sb.append(";navigate 0 translate");
            TransformManager.truncate2(sb, this.getNavigationOffsetPercent('X'));
            TransformManager.truncate2(sb, this.getNavigationOffsetPercent('Y'));
            sb.append(";navigate 0 depth ");
            TransformManager.truncate2(sb, this.navigationDepthPercent);
            sb.append(";");
        }
    }

    private String getRotateZyzText(boolean iAddComment) {
        float rZ2;
        float rZ1;
        SB sb = new SB();
        M3 m = (M3)this.vwr.ms.getInfoM("defaultOrientationMatrix");
        if (m == null) {
            m = this.matrixRotate;
        } else {
            m = M3.newM3(m);
            m.invert();
            m.mul2(this.matrixRotate, m);
        }
        float m22 = m.m22;
        float rY = (float)(Math.acos(m22) * 57.29577951308232);
        if (m22 > 0.999f || m22 < -0.999f) {
            rZ1 = (float)(Math.atan2(m.m10, m.m11) * 57.29577951308232);
            rZ2 = 0.0f;
        } else {
            rZ1 = (float)(Math.atan2(m.m21, -m.m20) * 57.29577951308232);
            rZ2 = (float)(Math.atan2(m.m12, m.m02) * 57.29577951308232);
        }
        if (rZ1 != 0.0f && rY != 0.0f && rZ2 != 0.0f && iAddComment) {
            sb.append("#Follows Z-Y-Z convention for Euler angles\n");
        }
        sb.append("reset");
        sb.append(";center ").append(this.getCenterText());
        if (rZ1 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate2(sb, rZ1);
        }
        if (rY != 0.0f) {
            sb.append("; rotate y");
            TransformManager.truncate2(sb, rY);
        }
        if (rZ2 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate2(sb, rZ2);
        }
        sb.append(";");
        this.addZoomTranslationNavigationText(sb);
        return sb.toString();
    }

    private static void truncate0(SB sb, float val) {
        sb.appendC(' ');
        sb.appendI(Math.round(val));
    }

    private static void truncate2(SB sb, float val) {
        sb.appendC(' ');
        sb.appendF((float)Math.round(val * 100.0f) / 100.0f);
    }

    void setSpinXYZ(float x, float y, float z) {
        if (!Float.isNaN(x)) {
            this.spinX = x;
        }
        if (!Float.isNaN(y)) {
            this.spinY = y;
        }
        if (!Float.isNaN(z)) {
            this.spinZ = z;
        }
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinFps(int value) {
        if (value <= 0) {
            value = 1;
        } else if (value > 50) {
            value = 50;
        }
        this.spinFps = value;
    }

    public void setNavXYZ(float x, float y, float z) {
        if (!Float.isNaN(x)) {
            this.navX = x;
        }
        if (!Float.isNaN(y)) {
            this.navY = y;
        }
        if (!Float.isNaN(z)) {
            this.navZ = z;
        }
    }

    private void clearSpin() {
        this.setSpinOff();
        this.setNavOn(false);
        this.isSpinInternal = false;
        this.isSpinFixed = false;
    }

    public void setSpinOn() {
        this.setSpin(null, true, Float.MAX_VALUE, null, null, null, false);
    }

    public void setSpinOff() {
        this.setSpin(null, false, Float.MAX_VALUE, null, null, null, false);
    }

    private void setSpin(JmolScriptEvaluator eval, boolean spinOn, float endDegrees, Lst<P3> endPositions, float[] dihedralList, BS bsAtoms, boolean isGesture) {
        if (this.navOn && spinOn) {
            this.setNavOn(false);
        }
        if (this.spinOn == spinOn) {
            return;
        }
        this.spinOn = spinOn;
        this.vwr.g.setB("_spinning", spinOn);
        if (spinOn) {
            if (this.spinThread == null) {
                this.spinThread = (JmolThread)Interface.getOption("thread.SpinThread", this.vwr, "tm");
                this.spinThread.setManager(this, this.vwr, new Object[]{Float.valueOf(endDegrees), endPositions, dihedralList, bsAtoms, isGesture ? Boolean.TRUE : null});
                this.spinIsGesture = isGesture;
                if (Float.isNaN(endDegrees) || endDegrees == Float.MAX_VALUE || !this.vwr.g.waitForMoveTo) {
                    this.spinThread.start();
                } else {
                    this.spinThread.setEval(eval);
                    this.spinThread.run();
                }
            }
        } else if (this.spinThread != null) {
            this.spinThread.reset();
            this.spinThread = null;
        }
    }

    public void setNavOn(boolean navOn) {
        if (Float.isNaN(this.navFps)) {
            return;
        }
        boolean wasOn = this.navOn;
        if (navOn && this.spinOn) {
            this.setSpin(null, false, 0.0f, null, null, null, false);
        }
        this.navOn = navOn;
        this.vwr.g.setB("_navigating", navOn);
        if (!navOn) {
            this.navInterrupt();
        }
        if (navOn) {
            if (this.navX == 0.0f && this.navY == 0.0f && this.navZ == 0.0f) {
                this.navZ = 1.0f;
            }
            if (this.navFps == 0.0f) {
                this.navFps = 10.0f;
            }
            if (this.spinThread == null) {
                this.spinThread = (JmolThread)Interface.getOption("thread.SpinThread", this.vwr, "tm");
                this.spinThread.setManager(this, this.vwr, null);
                this.spinThread.start();
            }
        } else if (wasOn && this.spinThread != null) {
            this.spinThread.interrupt();
            this.spinThread = null;
        }
    }

    void setVibrationScale(float scale) {
        this.vibrationScale = scale;
    }

    public void setVibrationPeriod(float period) {
        if (Float.isNaN(period)) {
            period = this.vibrationPeriod;
        } else if (period == 0.0f) {
            this.vibrationPeriod = 0.0f;
            this.vibrationPeriodMs = 0;
        } else {
            this.vibrationPeriod = Math.abs(period);
            this.vibrationPeriodMs = (int)(this.vibrationPeriod * 1000.0f);
            if (period > 0.0f) {
                return;
            }
            period = -period;
        }
        this.setVibrationOn(period > 0.0f && this.vwr.ms.getLastVibrationVector(this.vwr.am.cmi, 0) >= 0);
    }

    public void setVibrationT(float t) {
        this.vibrationT.x = t;
        if (this.vibrationScale == 0.0f) {
            this.vibrationScale = this.vwr.g.vibrationScale;
        }
    }

    boolean isVibrationOn() {
        return this.vibrationOn;
    }

    private void setVibrationOn(boolean vibrationOn) {
        if (!vibrationOn) {
            if (this.vibrationThread != null) {
                this.vibrationThread.interrupt();
                this.vibrationThread = null;
            }
            this.vibrationOn = false;
            this.vibrationT.x = 0.0f;
            return;
        }
        if (this.vwr.ms.mc < 1) {
            this.vibrationOn = false;
            this.vibrationT.x = 0.0f;
            return;
        }
        if (this.vibrationThread == null) {
            this.vibrationThread = (JmolThread)Interface.getOption("thread.VibrationThread", this.vwr, "tm");
            this.vibrationThread.setManager(this, this.vwr, null);
            this.vibrationThread.start();
        }
        this.vibrationOn = true;
    }

    private void clearVibration() {
        this.setVibrationOn(false);
        this.vibrationScale = 0.0f;
    }

    void setStereoMode2(int[] twoColors) {
        this.stereoMode = STER.CUSTOM;
        this.stereoColors = twoColors;
    }

    void setStereoMode(STER stereoMode) {
        this.stereoColors = null;
        this.stereoMode = stereoMode;
        this.stereoDoubleDTI = stereoMode == STER.DTI;
        this.stereoDoubleFull = stereoMode == STER.DOUBLE;
    }

    void setStereoDegrees(float stereoDegrees) {
        this.stereoDegrees = stereoDegrees;
        this.stereoRadians = stereoDegrees * ((float)Math.PI / 180);
    }

    synchronized M3 getStereoRotationMatrix(boolean stereoFrame) {
        this.stereoFrame = stereoFrame;
        if (!stereoFrame) {
            return this.matrixRotate;
        }
        this.matrixTemp3.setAsYRotation(-this.stereoRadians);
        this.matrixStereo.mul2(this.matrixTemp3, this.matrixRotate);
        return this.matrixStereo;
    }

    public boolean isWindowCentered() {
        return this.windowCentered;
    }

    void setWindowCentered(boolean TF) {
        this.windowCentered = TF;
        this.resetNavigationPoint(true);
    }

    public float setRotationRadius(float angstroms, boolean doAll) {
        this.modelRadius = angstroms <= 0.0f ? this.vwr.ms.calcRotationRadius(this.vwr.am.cmi, this.fixedRotationCenter, true) : angstroms;
        angstroms = this.modelRadius;
        if (doAll) {
            this.vwr.setRotationRadius(angstroms, false);
        }
        return angstroms;
    }

    private void setRotationCenterAndRadiusXYZ(T3 newCenterOfRotation, boolean andRadius) {
        this.resetNavigationPoint(false);
        if (newCenterOfRotation == null) {
            this.setFixedRotationCenter(this.rotationCenterDefault);
            this.modelRadius = this.rotationRadiusDefault;
            return;
        }
        this.setFixedRotationCenter(newCenterOfRotation);
        if (andRadius && this.windowCentered) {
            this.modelRadius = this.vwr.ms.calcRotationRadius(this.vwr.am.cmi, this.fixedRotationCenter, true);
        }
    }

    void setNewRotationCenter(P3 center, boolean doScale) {
        if (center == null) {
            center = this.rotationCenterDefault;
        }
        if (this.windowCentered) {
            this.translateToPercent('x', 0.0f);
            this.translateToPercent('y', 0.0f);
            this.setRotationCenterAndRadiusXYZ(center, true);
            if (doScale) {
                this.resetFitToScreen(true);
            }
        } else {
            this.moveRotationCenter(center, true);
        }
    }

    public void moveRotationCenter(P3 center, boolean toXY) {
        this.setRotationCenterAndRadiusXYZ(center, false);
        if (toXY) {
            this.setRotationPointXY(this.fixedRotationCenter);
        }
    }

    void setCenter() {
        this.setRotationCenterAndRadiusXYZ(this.fixedRotationCenter, true);
    }

    public void setCenterAt(int relativeTo, P3 pt) {
        P3 pt1 = P3.newP(pt);
        switch (relativeTo) {
            case 0x40000002: {
                break;
            }
            case 96: {
                pt1.add(this.vwr.ms.getAverageAtomPoint());
                break;
            }
            case 1678381065: {
                pt1.add(this.vwr.getBoundBoxCenter());
                break;
            }
            default: {
                pt1.setT(this.rotationCenterDefault);
            }
        }
        this.setRotationCenterAndRadiusXYZ(pt1, true);
        this.resetFitToScreen(true);
    }

    void setFrameOffset(int modelIndex) {
        if (this.frameOffsets == null || modelIndex < 0 || modelIndex >= this.frameOffsets.length) {
            this.frameOffset.set(0.0f, 0.0f, 0.0f);
        } else {
            this.frameOffset.setT(this.frameOffsets[modelIndex]);
        }
    }

    void setSelectedTranslation(BS bsAtoms, char xyz, float xy, float x) {
        if (!this.perspectiveDepth) {
            V3 v = new V3();
            switch (xyz) {
                case 'X': 
                case 'x': {
                    v.set(x, 0.0f, 0.0f);
                    break;
                }
                case 'Y': 
                case 'y': {
                    v.set(0.0f, x, 0.0f);
                    break;
                }
                case 'Z': 
                case 'z': {
                    v.set(0.0f, 0.0f, x);
                }
            }
            this.vwr.moveAtoms(null, null, this.matrixRotate, v, this.internalRotationCenter, false, bsAtoms, true);
            return;
        }
        this.bsSelectedAtoms = bsAtoms;
        switch (xyz) {
            case 'X': 
            case 'x': {
                this.ptOffset.x += xy;
                break;
            }
            case 'Y': 
            case 'y': {
                this.ptOffset.y += xy;
                break;
            }
            case 'Z': 
            case 'z': {
                this.ptOffset.z += xy;
            }
        }
    }

    protected void setNavFps(int navFps) {
        this.navFps = navFps;
    }

    public void calcCameraFactors() {
        if (Float.isNaN(this.cameraDepth)) {
            this.cameraDepth = this.cameraDepthSetting;
            this.zoomFactor = Float.MAX_VALUE;
        }
        this.cameraDistance = this.cameraDepth * (float)this.screenPixelCount;
        this.referencePlaneOffset = this.cameraDistance + (float)this.screenPixelCount / 2.0f;
        float f = this.scale3D && !this.perspectiveDepth && this.mode != 1 ? 72.0f / this.scale3DAngstromsPerInch * (float)(this.antialias ? 2 : 1) : (this.scalePixelsPerAngstrom = (float)this.screenPixelCount / this.visualRangeAngstroms);
        if (this.mode != 1) {
            this.mode = this.camera.z == 0.0f ? 0 : 2;
        }
        this.perspectiveShiftXY.set(this.camera.z == 0.0f ? 0.0f : this.camera.x * this.scalePixelsPerAngstrom / (float)this.screenWidth * 100.0f, this.camera.z == 0.0f ? 0.0f : this.camera.y * this.scalePixelsPerAngstrom / (float)this.screenHeight * 100.0f, 0.0f);
        this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
        float offset100 = 2.0f * this.modelRadius / this.visualRangeAngstroms * this.referencePlaneOffset;
        if (this.mode == 1) {
            this.calcNavCameraFactors(offset100);
            return;
        }
        this.zoomFactor = Float.MAX_VALUE;
        this.modelCenterOffset = this.referencePlaneOffset;
        if (!this.scale3D || this.perspectiveDepth) {
            this.scalePixelsPerAngstrom *= this.modelCenterOffset / offset100 * this.zmPct / 100.0f;
        }
        this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
    }

    private void calcNavCameraFactors(float offset100) {
        if (this.zoomFactor == Float.MAX_VALUE) {
            if (this.zmPct > 10000.0f) {
                this.zmPct = 10000.0f;
            }
            this.modelCenterOffset = offset100 * 100.0f / this.zmPct;
        } else if (this.prevZoomSetting != this.zmPctSet) {
            this.modelCenterOffset = this.zoomRatio == 0.0f ? offset100 * 100.0f / this.zmPctSet : (this.modelCenterOffset += (1.0f - this.zoomRatio) * this.referencePlaneOffset);
            this.navMode = -1;
        }
        this.prevZoomSetting = this.zmPctSet;
        this.zoomFactor = this.modelCenterOffset / this.referencePlaneOffset;
        this.zmPct = this.zoomFactor == 0.0f ? 10000.0f : offset100 / this.modelCenterOffset * 100.0f;
    }

    public float getPerspectiveFactor(float z) {
        return z <= 0.0f ? this.referencePlaneOffset : this.referencePlaneOffset / z;
    }

    public void unTransformPoint(T3 screenPt, T3 coordPt) {
        this.untransformedPoint.setT(screenPt);
        switch (this.mode) {
            case 1: {
                this.untransformedPoint.x -= this.navigationOffset.x;
                this.untransformedPoint.y -= this.navigationOffset.y;
                break;
            }
            case 2: {
                this.fScrPt.x += this.perspectiveShiftXY.x;
                this.fScrPt.y += this.perspectiveShiftXY.y;
            }
            case 0: {
                this.untransformedPoint.x -= this.fixedRotationOffset.x;
                this.untransformedPoint.y -= this.fixedRotationOffset.y;
            }
        }
        if (this.perspectiveDepth) {
            float factor = this.getPerspectiveFactor(this.untransformedPoint.z);
            this.untransformedPoint.x /= factor;
            this.untransformedPoint.y /= factor;
        }
        switch (this.mode) {
            case 1: {
                this.untransformedPoint.x += this.navigationShiftXY.x;
                this.untransformedPoint.y += this.navigationShiftXY.y;
                break;
            }
            case 2: {
                this.untransformedPoint.x -= this.perspectiveShiftXY.x;
                this.untransformedPoint.y -= this.perspectiveShiftXY.y;
            }
        }
        this.matrixTransformInv.rotTrans2(this.untransformedPoint, coordPt);
    }

    protected void resetNavigationPoint(boolean doResetSlab) {
        if (this.zmPct < 5.0f && this.mode != 1) {
            this.perspectiveDepth = true;
            this.mode = 1;
            return;
        }
        if (this.mode == 1) {
            this.navMode = 1;
            this.slabPercentSetting = 0;
            this.perspectiveDepth = true;
        } else if (doResetSlab) {
            this.slabPercentSetting = 100;
        }
        this.vwr.setFloatProperty("slabRange", 0.0f);
        if (doResetSlab) {
            this.setSlabEnabled(this.mode == 1);
        }
        this.zoomFactor = Float.MAX_VALUE;
        this.zmPctSet = this.zmPct;
    }

    public void setNavigatePt(P3 pt) {
        this.navigationCenter.setT(pt);
        this.navMode = 3;
        this.navigating = true;
        this.finalizeTransformParameters();
        this.navigating = false;
    }

    void setNavigationSlabOffsetPercent(float percent) {
        this.vwr.g.setF("navigationSlab", percent);
        this.calcCameraFactors();
        this.navigationSlabOffset = percent / 50.0f * this.modelRadiusPixels;
    }

    public P3 getNavigationOffset() {
        this.transformPt3f(this.navigationCenter, this.navigationOffset);
        return this.navigationOffset;
    }

    public float getNavPtHeight() {
        return (float)this.height / 2.0f;
    }

    public float getNavigationOffsetPercent(char XorY) {
        this.getNavigationOffset();
        if (this.width == 0 || this.height == 0) {
            return 0.0f;
        }
        return XorY == 'X' ? (this.navigationOffset.x - (float)this.width / 2.0f) * 100.0f / (float)this.width : (this.navigationOffset.y - this.getNavPtHeight()) * 100.0f / (float)this.height;
    }

    protected String getNavigationText(boolean addComments) {
        String s;
        String string = s = addComments ? " /* navigation center, translation, depth */ " : " ";
        if (this.mode != 1) {
            return s + "{0 0 0} 0 0 0";
        }
        this.getNavigationOffset();
        return s + Escape.eP(this.navigationCenter) + " " + this.getNavigationOffsetPercent('X') + " " + this.getNavigationOffsetPercent('Y') + " " + this.navigationDepthPercent;
    }

    void setScreenParameters(int screenWidth, int screenHeight, boolean useZoomLarge, boolean antialias, boolean resetSlab, boolean resetZoom) {
        P3 pt = this.mode == 1 ? P3.newP(this.navigationCenter) : null;
        P3 ptoff = P3.newP(this.navigationOffset);
        ptoff.x /= (float)this.width;
        ptoff.y /= (float)this.height;
        this.setScreenParameters0(screenWidth, screenHeight, useZoomLarge, antialias, resetSlab, resetZoom);
        if (pt != null) {
            this.navigationCenter.setT(pt);
            this.navTranslatePercentOrTo(-1.0f, ptoff.x * (float)this.width, ptoff.y * (float)this.height);
            this.setNavigatePt(pt);
        }
    }

    private void navInterrupt() {
        if (this.nav != null) {
            this.nav.interrupt();
        }
    }

    private boolean getNav() {
        if (this.nav != null) {
            return true;
        }
        this.nav = (JmolNavigatorInterface)Interface.getOption("navigate.Navigator", this.vwr, "tm");
        if (this.nav == null) {
            return false;
        }
        this.nav.set(this, this.vwr);
        return true;
    }

    public void navigateList(JmolScriptEvaluator eval, Lst<Object[]> list) {
        if (this.getNav()) {
            this.nav.navigateList(eval, list);
        }
    }

    public void navigateAxis(V3 rotAxis, float degrees) {
        if (this.getNav()) {
            this.nav.navigateAxis(rotAxis, degrees);
        }
    }

    public void setNavigationOffsetRelative() {
        if (this.getNav()) {
            this.nav.setNavigationOffsetRelative();
        }
    }

    synchronized void navigateKey(int keyCode, int modifiers) {
        if (this.getNav()) {
            this.nav.navigateKey(keyCode, modifiers);
        }
    }

    public void setNavigationDepthPercent(float percent) {
        if (this.getNav()) {
            this.nav.setNavigationDepthPercent(percent);
        }
    }

    public void navTranslatePercentOrTo(float seconds, float x, float y) {
        if (this.getNav()) {
            this.nav.navTranslatePercentOrTo(seconds, x, y);
        }
    }

    protected void calcNavigationPoint() {
        if (this.getNav()) {
            this.nav.calcNavigationPoint();
        }
    }

    protected String getNavigationState() {
        return this.mode == 1 && this.getNav() ? this.nav.getNavigationState() : "";
    }
}

