/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.gui.layer.imagery.ColorfulImageProcessor;
import org.openstreetmap.josm.gui.layer.imagery.GammaImageProcessor;
import org.openstreetmap.josm.gui.layer.imagery.SharpenImageProcessor;
import org.openstreetmap.josm.tools.ImageProcessor;

public class ImageryFilterSettings
implements ImageProcessor {
    protected GammaImageProcessor gammaImageProcessor = new GammaImageProcessor();
    protected SharpenImageProcessor sharpenImageProcessor = new SharpenImageProcessor();
    protected ColorfulImageProcessor colorfulnessImageProcessor = new ColorfulImageProcessor();
    private final List<FilterChangeListener> filterChangeListeners = new CopyOnWriteArrayList<FilterChangeListener>();

    public double getGamma() {
        return this.gammaImageProcessor.getGamma();
    }

    public void setGamma(double gamma) {
        this.gammaImageProcessor.setGamma(gamma);
        this.fireListeners();
    }

    public double getSharpenLevel() {
        return this.sharpenImageProcessor.getSharpenLevel();
    }

    public void setSharpenLevel(double sharpenLevel) {
        this.sharpenImageProcessor.setSharpenLevel((float)sharpenLevel);
        this.fireListeners();
    }

    public double getColorfulness() {
        return this.colorfulnessImageProcessor.getColorfulness();
    }

    public void setColorfulness(double colorfulness) {
        this.colorfulnessImageProcessor.setColorfulness(colorfulness);
        this.fireListeners();
    }

    public List<ImageProcessor> getProcessors() {
        return Arrays.asList(this.colorfulnessImageProcessor, this.gammaImageProcessor, this.sharpenImageProcessor);
    }

    @Override
    public BufferedImage process(BufferedImage image) {
        for (ImageProcessor processor : this.getProcessors()) {
            image = processor.process(image);
        }
        return image;
    }

    public void addFilterChangeListener(FilterChangeListener l) {
        this.filterChangeListeners.add(l);
    }

    public void removeFilterChangeListener(FilterChangeListener l) {
        this.filterChangeListeners.remove(l);
    }

    private void fireListeners() {
        for (FilterChangeListener l : this.filterChangeListeners) {
            l.filterChanged();
        }
    }

    @FunctionalInterface
    public static interface FilterChangeListener {
        public void filterChanged();
    }
}

