/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.TeeInputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ClientHello {
    private final ProtocolVersion version;
    private final byte[] random;
    private final byte[] sessionID;
    private final byte[] cookie;
    private final int[] cipherSuites;
    private final Hashtable extensions;

    public ClientHello(ProtocolVersion protocolVersion, byte[] byArray, byte[] byArray2, byte[] byArray3, int[] nArray, Hashtable hashtable) {
        this.version = protocolVersion;
        this.random = byArray;
        this.sessionID = byArray2;
        this.cookie = byArray3;
        this.cipherSuites = nArray;
        this.extensions = hashtable;
    }

    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    public ProtocolVersion getClientVersion() {
        return this.version;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public Hashtable getExtensions() {
        return this.extensions;
    }

    public byte[] getRandom() {
        return this.random;
    }

    public byte[] getSessionID() {
        return this.sessionID;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public void encode(TlsContext tlsContext, OutputStream outputStream) throws IOException {
        TlsUtils.writeVersion(this.version, outputStream);
        outputStream.write(this.random);
        TlsUtils.writeOpaque8(this.sessionID, outputStream);
        if (null != this.cookie) {
            TlsUtils.writeOpaque8(this.cookie, outputStream);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(this.cipherSuites, outputStream);
        TlsUtils.writeUint8ArrayWithUint8Length(new short[]{0}, outputStream);
        TlsProtocol.writeExtensions(outputStream, this.extensions);
    }

    public static ClientHello parse(ByteArrayInputStream byteArrayInputStream, OutputStream outputStream) throws TlsFatalAlert {
        try {
            return ClientHello.implParse(byteArrayInputStream, outputStream);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            throw new TlsFatalAlert(50, (Throwable)iOException);
        }
    }

    private static ClientHello implParse(ByteArrayInputStream byteArrayInputStream, OutputStream outputStream) throws IOException {
        int n;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        if (null != outputStream) {
            byteArrayInputStream2 = new TeeInputStream((InputStream)byteArrayInputStream2, outputStream);
        }
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream2);
        byte[] byArray = TlsUtils.readFully(32, (InputStream)byteArrayInputStream2);
        byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream2, 0, 32);
        byte[] byArray3 = null;
        if (null != outputStream) {
            n = ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(protocolVersion) ? 255 : 32;
            byArray3 = TlsUtils.readOpaque8(byteArrayInputStream, 0, n);
        }
        if ((n = TlsUtils.readUint16(byteArrayInputStream2)) < 2 || (n & 1) != 0 || byteArrayInputStream.available() < n) {
            throw new TlsFatalAlert(50);
        }
        int[] nArray = TlsUtils.readUint16Array(n / 2, byteArrayInputStream2);
        short[] sArray = TlsUtils.readUint8ArrayWithUint8Length(byteArrayInputStream2, 1);
        if (!Arrays.contains((short[])sArray, (short)0)) {
            throw new TlsFatalAlert(40);
        }
        Hashtable hashtable = null;
        if (byteArrayInputStream.available() > 0) {
            byte[] byArray4 = TlsUtils.readOpaque16(byteArrayInputStream2);
            TlsProtocol.assertEmpty(byteArrayInputStream);
            hashtable = TlsProtocol.readExtensionsDataClientHello(byArray4);
        }
        return new ClientHello(protocolVersion, byArray, byArray2, byArray3, nArray, hashtable);
    }
}

