/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import org.jruby.ir.OpClass;

public enum Operation {
    NOP(0),
    JUMP(8),
    BNE(8),
    B_UNDEF(8),
    B_NIL(8),
    B_TRUE(8),
    B_FALSE(8),
    B_SWITCH(8),
    RECV_SELF(0),
    RECV_PRE_REQD_ARG(1024),
    RECV_POST_REQD_ARG(1024),
    RECV_KW_ARG(1024),
    RECV_KW_REST_ARG(1024),
    RECV_REST_ARG(1024),
    RECV_OPT_ARG(1024),
    RECV_RUBY_EXC(1024),
    RECV_JRUBY_EXC(1024),
    LOAD_IMPLICIT_CLOSURE(1024),
    REIFY_CLOSURE(0),
    LOAD_FRAME_CLOSURE(0),
    LOAD_BLOCK_IMPLICIT_CLOSURE(0),
    CALL(515),
    NORESULT_CALL(515),
    ATTR_ASSIGN(515),
    ARRAY_DEREF(515),
    AS_STRING(515),
    CLASS_SUPER(515),
    INSTANCE_SUPER(515),
    UNRESOLVED_SUPER(515),
    ZSUPER(515),
    CALL_1F(515),
    CALL_1D(515),
    CALL_1O(515),
    CALL_2O(515),
    CALL_1OB(515),
    CALL_0O(515),
    NORESULT_CALL_1O(515),
    EQQ(3),
    LAMBDA(3),
    MATCH(3),
    YIELD(3),
    RETURN(17),
    NONLOCAL_RETURN(19),
    BREAK(19),
    RETURN_OR_RETHROW_SAVED_EXC(17),
    ALIAS(2051),
    DEF_MODULE(6147),
    DEF_CLASS(6147),
    DEF_META_CLASS(6147),
    DEF_INST_METH(6147),
    DEF_CLASS_METH(6147),
    PROCESS_MODULE_BODY(6147),
    UNDEF_METHOD(2051),
    GVAR_ALIAS(2051),
    LABEL(8196),
    EXC_REGION_START(8196),
    EXC_REGION_END(8196),
    LEXICAL_SEARCH_CONST(2),
    INHERITANCE_SEARCH_CONST(2),
    SEARCH_CONST(2),
    SEARCH_MODULE_FOR_CONST(2),
    GET_GLOBAL_VAR(128),
    GET_FIELD(128),
    GET_CVAR(130),
    PUT_GLOBAL_VAR(259),
    PUT_CONST(259),
    PUT_CVAR(259),
    PUT_FIELD(259),
    LINE_NUM(8256),
    TRACE(8257),
    COVERAGE(8257),
    BINDING_LOAD(128),
    BINDING_STORE(257),
    BUILD_BACKREF(2),
    BUILD_COMPOUND_ARRAY(2),
    BUILD_COMPOUND_STRING(2),
    BUILD_DREGEXP(2),
    BUILD_RANGE(2),
    BUILD_SPLAT(2),
    CHECK_ARGS_ARRAY_ARITY(2),
    CHECK_ARITY(8194),
    CHECK_FOR_LJE(3),
    CLASS_VAR_MODULE(0),
    COPY(0),
    GET_ENCODING(0),
    MASGN_OPT(0),
    MASGN_REQD(0),
    MASGN_REST(0),
    RAISE_ARGUMENT_ERROR(2),
    RAISE_REQUIRED_KEYWORD_ARGUMENT_ERROR(2),
    RECORD_END_BLOCK(1),
    RESCUE_EQQ(2),
    RUNTIME_HELPER(3),
    SET_CAPTURED_VAR(2),
    THREAD_POLL(8195),
    THROW(35),
    TO_ARY(3),
    BLOCK_GIVEN(0),
    GET_ERROR_INFO(0),
    RESTORE_ERROR_INFO(1),
    BOX_FIXNUM(0),
    BOX_FLOAT(0),
    BOX_BOOLEAN(0),
    UNBOX_FIXNUM(0),
    UNBOX_FLOAT(0),
    UNBOX_BOOLEAN(0),
    IADD(32768),
    ISUB(32768),
    IMUL(32768),
    IDIV(32768),
    ILT(32768),
    IGT(32768),
    IOR(32768),
    IAND(32768),
    IXOR(32768),
    ISHL(32768),
    ISHR(32768),
    IEQ(32768),
    FADD(16384),
    FSUB(16384),
    FMUL(16384),
    FDIV(16384),
    FLT(16384),
    FGT(16384),
    FEQ(16384),
    MODULE_GUARD(8),
    PUSH_METHOD_FRAME(8193),
    PUSH_BACKREF_FRAME(8193),
    PUSH_METHOD_BINDING(8193),
    POP_METHOD_FRAME(8193),
    POP_BACKREF_FRAME(8193),
    PUSH_BLOCK_FRAME(8193),
    PUSH_BLOCK_BINDING(8193),
    POP_BLOCK_FRAME(8193),
    POP_BINDING(8193),
    SAVE_BINDING_VIZ(8193),
    RESTORE_BINDING_VIZ(8193),
    TOGGLE_BACKTRACE(8193),
    UPDATE_BLOCK_STATE(8193),
    PREPARE_BLOCK_ARGS(8195),
    PREPARE_SINGLE_BLOCK_ARG(8195),
    PREPARE_FIXED_BLOCK_ARGS(8195),
    PREPARE_NO_BLOCK_ARGS(8195);

    public final OpClass opClass;
    private final int flags;
    private static final Operation[] VALUES;

    private Operation(int flags2) {
        this.flags = flags2;
        this.opClass = this.isArgReceive() ? OpClass.ARG_OP : ((flags2 & 0x10) > 0 ? OpClass.RET_OP : (this.isBranch() ? OpClass.BRANCH_OP : (this.isBookKeepingOp() ? OpClass.BOOK_KEEPING_OP : (this.isCall() ? OpClass.CALL_OP : ((flags2 & 0x8000) > 0 ? OpClass.INT_OP : ((flags2 & 0x4000) > 0 ? OpClass.FLOAT_OP : OpClass.OTHER_OP))))));
    }

    public boolean transfersControl() {
        return (this.flags & 0x38) > 0;
    }

    public boolean isLoad() {
        return (this.flags & 0x80) > 0;
    }

    public boolean isStore() {
        return (this.flags & 0x100) > 0;
    }

    public boolean isCall() {
        return (this.flags & 0x200) > 0;
    }

    public boolean isBranch() {
        return (this.flags & 8) > 0;
    }

    public boolean isReturn() {
        return (this.flags & 0x10) > 0;
    }

    public boolean isException() {
        return (this.flags & 0x20) > 0;
    }

    public boolean isArgReceive() {
        return (this.flags & 0x400) > 0;
    }

    public boolean startsBasicBlock() {
        return this == LABEL;
    }

    public boolean endsBasicBlock() {
        return this.transfersControl();
    }

    public boolean hasSideEffects() {
        return (this.flags & 1) > 0;
    }

    public boolean isDebugOp() {
        return (this.flags & 0x40) > 0;
    }

    public boolean isBookKeepingOp() {
        return (this.flags & 0x2000) > 0;
    }

    public boolean canRaiseException() {
        return (this.flags & 2) > 0;
    }

    public boolean modifiesCode() {
        return (this.flags & 0x800) > 0;
    }

    public boolean inlineUnfriendly() {
        return (this.flags & 0x1000) > 0;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static Operation fromOrdinal(int value2) {
        if (value2 < 0 || value2 >= VALUES.length) {
            throw new RuntimeException("invalid ordinal: " + value2);
        }
        return VALUES[value2];
    }

    static {
        VALUES = Operation.values();
    }
}

