/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.bpm;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.bpm.Cell;
import net.sourceforge.plantuml.bpm.Placeable;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class GridArray
implements UDrawable {
    private final int lines;
    private final int cols;
    private final Placeable[][] data;
    private final ISkinParam skinParam;
    private final double margin = 30.0;

    public GridArray(ISkinParam skinParam, int lines, int cols) {
        this.skinParam = skinParam;
        this.lines = lines;
        this.cols = cols;
        this.data = new Placeable[lines][cols];
    }

    public String toString() {
        return "" + this.lines + "x" + this.cols;
    }

    public void setData(int l, int c, Placeable element) {
        this.data[l][c] = element;
    }

    public Placeable getData(int l, int c) {
        return this.data[l][c];
    }

    public final int getRows() {
        return this.cols;
    }

    public final int getLines() {
        return this.lines;
    }

    private double getHeightOfLine(StringBounder stringBounder, int line) {
        double height = 0.0;
        for (int i = 0; i < this.cols; ++i) {
            Placeable cell = this.data[line][i];
            if (cell == null) continue;
            height = Math.max(height, cell.getDimension(stringBounder, this.skinParam).getHeight());
        }
        return height;
    }

    private double getWidthOfCol(StringBounder stringBounder, int col) {
        double width = 0.0;
        for (int i = 0; i < this.lines; ++i) {
            Placeable cell = this.data[i][col];
            if (cell == null) continue;
            width = Math.max(width, cell.getDimension(stringBounder, this.skinParam).getWidth());
        }
        return width;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double dy = 0.0;
        this.drawInternalGrid(ug);
        for (int l = 0; l < this.lines; ++l) {
            double dx = 0.0;
            double heightOfLine = this.getHeightOfLine(stringBounder, l);
            for (int r = 0; r < this.cols; ++r) {
                double widthOfCol = this.getWidthOfCol(stringBounder, r);
                Placeable cell = this.data[l][r];
                if (cell != null) {
                    Dimension2D dim = cell.getDimension(stringBounder, this.skinParam);
                    cell.toTextBlock(this.skinParam).drawU(ug.apply(new UTranslate(dx + (widthOfCol + 30.0 - dim.getWidth()) / 2.0, dy + (heightOfLine + 30.0 - dim.getHeight()) / 2.0)));
                }
                dx += widthOfCol + 30.0;
            }
            dy += heightOfLine + 30.0;
        }
    }

    private void drawInternalGrid(UGraphic ug) {
        double heightMax = 0.0;
        for (int l = 0; l < this.lines; ++l) {
            heightMax += this.getHeightOfLine(ug.getStringBounder(), l) + 30.0;
        }
        double widthMax = 0.0;
        for (int c = 0; c < this.cols; ++c) {
            widthMax += this.getWidthOfCol(ug.getStringBounder(), c) + 30.0;
        }
        ug = ug.apply(HColors.BLACK);
        double y = 0.0;
        for (int l = 0; l < this.lines; ++l) {
            ug.apply(UTranslate.dy(y)).draw(ULine.hline(widthMax));
            y += this.getHeightOfLine(ug.getStringBounder(), l) + 30.0;
        }
        double x = 0.0;
        for (int c = 0; c < this.cols; ++c) {
            ug.apply(UTranslate.dx(x)).draw(ULine.vline(heightMax));
            x += this.getWidthOfCol(ug.getStringBounder(), c) + 30.0;
        }
    }

    private void drawArrow(UGraphic ug, Point2D pt1, Point2D pt2) {
        ug = ug.apply(HColors.BLUE);
        ULine line = new ULine(pt2.getX() - pt1.getX(), pt2.getY() - pt1.getY());
        ug.apply(new UTranslate(pt1)).draw(line);
    }

    private Point2D getCenterOf(StringBounder stringBounder, int c, int l) {
        double x = this.getWidthOfCol(stringBounder, c) / 2.0 + 15.0;
        for (int i = 0; i < c; ++i) {
            double widthOfCol = this.getWidthOfCol(stringBounder, i);
            x += widthOfCol + 30.0;
        }
        double y = this.getHeightOfLine(stringBounder, l) / 2.0 + 15.0;
        for (int i = 0; i < l; ++i) {
            double heightOfLine = this.getHeightOfLine(stringBounder, i);
            y += heightOfLine + 30.0;
        }
        return new Point2D.Double(x, y);
    }

    private int[] getCoord(Cell someCell) {
        for (int l = 0; l < this.lines; ++l) {
            for (int c = 0; c < this.cols; ++c) {
                Placeable cell = this.data[l][c];
                if (cell != someCell.getData()) continue;
                return new int[]{c, l};
            }
        }
        throw new IllegalArgumentException();
    }

    private void printMe() {
        for (int l = 0; l < this.lines; ++l) {
            for (int c = 0; c < this.cols; ++c) {
                Placeable cell = this.data[l][c];
                System.err.print(cell);
                System.err.print("  ;  ");
            }
            System.err.println();
        }
    }
}

