/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sprite;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class SpriteMonochrome
implements Sprite {
    private final int width;
    private final int height;
    private final int grayLevel;
    private final int[][] gray;

    public boolean isSameKind(SpriteMonochrome other) {
        if (this.width != other.width) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        return this.grayLevel == other.grayLevel;
    }

    public boolean isSame(SpriteMonochrome other) {
        if (!this.isSameKind(other)) {
            return false;
        }
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (this.gray[j][i] == other.gray[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public SpriteMonochrome xor(SpriteMonochrome other) {
        if (this.width != other.width) {
            throw new IllegalStateException();
        }
        if (this.height != other.height) {
            throw new IllegalStateException();
        }
        if (this.grayLevel != other.grayLevel) {
            throw new IllegalStateException();
        }
        SpriteMonochrome result = new SpriteMonochrome(this.width, this.height, this.grayLevel);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                result.gray[j][i] = this.gray[j][i] ^ other.gray[j][i];
            }
        }
        return result;
    }

    public SpriteMonochrome(int width, int height, int grayLevel) {
        if (grayLevel != 2 && grayLevel != 4 && grayLevel != 8 && grayLevel != 16) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
        this.grayLevel = grayLevel;
        this.gray = new int[height][width];
    }

    public SpriteMonochrome xSymetric() {
        SpriteMonochrome result = new SpriteMonochrome(this.width, this.height, this.grayLevel);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                result.setGray(i, j, this.getGray(i, j));
            }
        }
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width / 2; ++i) {
                int i2 = this.width - 1 - i;
                int level = result.getGray(i, j) ^ result.getGray(i2, j);
                result.setGray(i2, j, level);
            }
        }
        return result;
    }

    public SpriteMonochrome ySymetric() {
        int j;
        int i;
        SpriteMonochrome result = new SpriteMonochrome(this.width, this.height, this.grayLevel);
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                result.setGray(i, j, this.getGray(i, j));
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height / 2; ++j) {
                int j2 = this.height - 1 - j;
                int level = result.getGray(i, j) ^ result.getGray(i, j2);
                result.setGray(i, j2, level);
            }
        }
        return result;
    }

    public void setGray(int x, int y, int level) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        if (level < 0 || level >= this.grayLevel) {
            throw new IllegalArgumentException("level=" + level + " grayLevel=" + this.grayLevel);
        }
        this.gray[y][x] = level;
    }

    public int getGray(int x, int y) {
        if (x >= this.width) {
            throw new IllegalArgumentException("x=" + x + " width=" + this.width);
        }
        if (y >= this.height) {
            throw new IllegalArgumentException("y=" + y + " height=" + this.height);
        }
        return this.gray[y][x];
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public UImage toUImage(ColorMapper colorMapper, HColor backcolor, HColor color) {
        if (backcolor == null || HColors.isTransparent(backcolor)) {
            backcolor = HColors.WHITE.withDark(HColors.BLACK);
        }
        if (color == null || HColors.isTransparent(color)) {
            color = HColors.BLACK.withDark(HColors.WHITE);
        }
        BufferedImage im = new BufferedImage(this.width, this.height, 1);
        HColorGradient gradient = HColors.gradient(backcolor, color, '\u0000');
        for (int col = 0; col < this.width; ++col) {
            for (int line = 0; line < this.height; ++line) {
                double coef = 1.0 * (double)this.gray[line][col] / (double)(this.grayLevel - 1);
                Color c = gradient.getColor(colorMapper, coef);
                im.setRGB(col, line, c.getRGB());
            }
        }
        return new UImage(new PixelImage(im, AffineTransformType.TYPE_BILINEAR));
    }

    private UImage special(ColorMapper colorMapper, HColorGradient backcolor, HColor color) {
        BufferedImage im = new BufferedImage(this.width, this.height, 1);
        for (int col = 0; col < this.width; ++col) {
            for (int line = 0; line < this.height; ++line) {
                HColor backColorLocal = HColors.simple(backcolor.getColor(colorMapper, 1.0 * (double)line / (double)this.height));
                HColorGradient gradient = HColors.gradient(backColorLocal, color, '\u0000');
                double coef = 1.0 * (double)this.gray[line][col] / (double)(this.grayLevel - 1);
                Color c = gradient.getColor(colorMapper, coef);
                im.setRGB(col, line, c.getRGB());
            }
        }
        return new UImage(new PixelImage(im, AffineTransformType.TYPE_BILINEAR));
    }

    @Override
    public TextBlock asTextBlock(final HColor color, final double scale, ColorMapper colorMapper) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                UImage image = SpriteMonochrome.this.toUImage(ug.getColorMapper(), ug.getParam().getBackcolor(), color);
                ug.draw(image.scale(scale));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble((double)SpriteMonochrome.this.getWidth() * scale, (double)SpriteMonochrome.this.getHeight() * scale);
            }
        };
    }

    public void exportSprite1(OutputStream fos) throws IOException {
        for (int y = 0; y < this.getHeight(); y += 2) {
            for (int x = 0; x < this.getWidth(); ++x) {
                int b1 = this.getGray(x, y);
                int b2 = y + 1 < this.getHeight() ? this.getGray(x, y + 1) : b1;
                fos.write(b1 * 16 + b2);
            }
        }
    }
}

