/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.extern.decimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.firebirdsql.extern.decimal.Decimal;
import org.firebirdsql.extern.decimal.DecimalFactory;
import org.firebirdsql.extern.decimal.DecimalFormat;
import org.firebirdsql.extern.decimal.DecimalType;
import org.firebirdsql.extern.decimal.DenselyPackedDecimalCodec;

final class DecimalCodec<T extends Decimal<T>> {
    private static final int COMBINATION_2 = 96;
    private static final int NEGATIVE_BIT = 128;
    private final DecimalFactory<T> decimalFactory;
    private final DecimalFormat decimalFormat;
    private final DenselyPackedDecimalCodec coefficientCoder;

    DecimalCodec(DecimalFactory<T> decimalFactory) {
        this.decimalFactory = decimalFactory;
        this.decimalFormat = decimalFactory.getDecimalFormat();
        this.coefficientCoder = new DenselyPackedDecimalCodec(this.decimalFormat.coefficientDigits);
    }

    T parseBytes(byte[] decBytes) {
        int firstDigit;
        int exponentMSB;
        this.decimalFormat.validateByteLength(decBytes);
        int firstByte = decBytes[0] & 0xFF;
        int signum = -1 * (firstByte >>> 7) | 1;
        DecimalType decimalType = DecimalType.fromFirstByte(firstByte);
        if (decimalType != DecimalType.FINITE) {
            return (T)((Decimal)this.decimalFactory.getSpecialConstant(signum, decimalType));
        }
        if ((firstByte & 0x60) != 96) {
            exponentMSB = firstByte >>> 3 & 0xC | firstByte & 3;
            firstDigit = firstByte >>> 2 & 7;
        } else {
            exponentMSB = firstByte >>> 1 & 0xC | firstByte & 3;
            firstDigit = 8 | firstByte >>> 2 & 1;
        }
        int exponentBitsRemaining = this.decimalFormat.exponentContinuationBits - 2;
        assert (exponentBitsRemaining == this.decimalFormat.formatBitLength - 8 - this.decimalFormat.coefficientContinuationBits) : "Unexpected exponent remaining length " + exponentBitsRemaining;
        int exponent = this.decimalFormat.unbiasedExponent(DecimalCodec.decodeExponent(decBytes, exponentMSB, exponentBitsRemaining));
        BigInteger coefficient = this.coefficientCoder.decodeValue(signum, firstDigit, decBytes);
        return (T)((Decimal)this.decimalFactory.createDecimal(signum, new BigDecimal(coefficient, -exponent)));
    }

    byte[] encodeDecimal(T decimal) {
        byte[] decBytes = new byte[this.decimalFormat.formatByteLength];
        if (((Decimal)decimal).signum() == -1) {
            decBytes[0] = -128;
        }
        if (((Decimal)decimal).getType() == DecimalType.FINITE) {
            this.encodeFinite(this.decimalFormat.validate(((Decimal)decimal).toBigDecimal()), decBytes);
        } else {
            decBytes[0] = (byte)(decBytes[0] | ((Decimal)decimal).getType().getSpecialBits());
        }
        return decBytes;
    }

    private void encodeFinite(BigDecimal decimal, byte[] decBytes) {
        int biasedExponent = this.decimalFormat.biasedExponent(-decimal.scale());
        BigInteger coefficient = decimal.unscaledValue();
        int mostSignificantDigit = this.coefficientCoder.encodeValue(coefficient, decBytes);
        int expMSB = biasedExponent >>> this.decimalFormat.exponentContinuationBits;
        int expTwoBitCont = biasedExponent >>> this.decimalFormat.exponentContinuationBits - 2 & 3;
        decBytes[0] = mostSignificantDigit <= 7 ? (byte)(decBytes[0] | (expMSB << 5 | mostSignificantDigit << 2 | expTwoBitCont)) : (byte)(decBytes[0] | (0x60 | expMSB << 3 | (mostSignificantDigit & 1) << 2 | expTwoBitCont));
        DecimalCodec.encodeExponentContinuation(decBytes, biasedExponent, this.decimalFormat.exponentContinuationBits - 2);
    }

    private static void encodeExponentContinuation(byte[] decBytes, int expAndBias, int expBitsRemaining) {
        int expByteIndex = 1;
        while (expBitsRemaining > 8) {
            decBytes[expByteIndex++] = (byte)(expAndBias >>> expBitsRemaining - 8);
            expBitsRemaining -= 8;
        }
        if (expBitsRemaining > 0) {
            int n = expByteIndex;
            decBytes[n] = (byte)(decBytes[n] | expAndBias << 8 - expBitsRemaining);
        }
    }

    static int decodeExponent(byte[] decBytes, int exponentMSB, int exponentBitsRemaining) {
        int exponent = exponentMSB;
        int byteIndex = 1;
        while (exponentBitsRemaining > 8) {
            exponent = exponent << 8 | decBytes[byteIndex] & 0xFF;
            exponentBitsRemaining -= 8;
            ++byteIndex;
        }
        if (exponentBitsRemaining > 0) {
            exponent = exponent << exponentBitsRemaining | (decBytes[byteIndex] & 0xFF) >>> 8 - exponentBitsRemaining;
        }
        return exponent;
    }
}

