/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtHelp.h"

#line 38 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.7/build/QtHelp/sipQtHelpQList0100QHelpLink.cpp"

#line 28 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtHelp/qhelplink.sip"
#include <qhelplink.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.7/build/QtHelp/sipQtHelpQList0100QHelpLink.cpp"


extern "C" {static void assign_QList_0100QHelpLink(void *, Py_ssize_t, void *);}
static void assign_QList_0100QHelpLink(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<QList< ::QHelpLink> *>(sipDst)[sipDstIdx] = *reinterpret_cast<QList< ::QHelpLink> *>(sipSrc);
}


extern "C" {static void *array_QList_0100QHelpLink(Py_ssize_t);}
static void *array_QList_0100QHelpLink(Py_ssize_t sipNrElem)
{
    return new QList< ::QHelpLink>[sipNrElem];
}


extern "C" {static void *copy_QList_0100QHelpLink(const void *, Py_ssize_t);}
static void *copy_QList_0100QHelpLink(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new QList< ::QHelpLink>(reinterpret_cast<const QList< ::QHelpLink> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QList_0100QHelpLink(void *, int);}
static void release_QList_0100QHelpLink(void *sipCppV, int)
{
    QList< ::QHelpLink> *sipCpp = reinterpret_cast<QList< ::QHelpLink> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QList_0100QHelpLink(PyObject *, void **, int *, PyObject *);}
static int convertTo_QList_0100QHelpLink(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    QList< ::QHelpLink> **sipCppPtr = reinterpret_cast<QList< ::QHelpLink> **>(sipCppPtrV);

#line 68 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qpycore_qlist.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter
#if PY_MAJOR_VERSION < 3
                && !PyString_Check(sipPy)
#endif
                && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QList<QHelpLink> *ql = new QList<QHelpLink>;
 
    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete ql;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        int state;
        QHelpLink *t = reinterpret_cast<QHelpLink *>(
                sipForceConvertToType(itm, sipType_QHelpLink, sipTransferObj,
                        SIP_NOT_NONE, &state, sipIsErr));

        if (*sipIsErr)
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'QHelpLink' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete ql;
            Py_DECREF(iter);

            return 0;
        }

        ql->append(*t);

        sipReleaseType(t, sipType_QHelpLink, state);
        Py_DECREF(itm);
    }
 
    Py_DECREF(iter);

    *sipCppPtr = ql;
 
    return sipGetState(sipTransferObj);
#line 144 "/build/pyqt5/src/PyQt5-5.15.7/build/QtHelp/sipQtHelpQList0100QHelpLink.cpp"
}


extern "C" {static PyObject *convertFrom_QList_0100QHelpLink(void *, PyObject *);}
static PyObject *convertFrom_QList_0100QHelpLink(void *sipCppV, PyObject *sipTransferObj)
{
   QList< ::QHelpLink> *sipCpp = reinterpret_cast<QList< ::QHelpLink> *>(sipCppV);

#line 42 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qpycore_qlist.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        QHelpLink *t = new QHelpLink(sipCpp->at(i));
        PyObject *tobj = sipConvertFromNewType(t, sipType_QHelpLink,
                sipTransferObj);

        if (!tobj)
        {
            delete t;
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, tobj);
    }

    return l;
#line 177 "/build/pyqt5/src/PyQt5-5.15.7/build/QtHelp/sipQtHelpQList0100QHelpLink.cpp"
}


sipMappedTypeDef sipTypeDef_QtHelp_QList_0100QHelpLink = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_1480,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_QList_0100QHelpLink,
    array_QList_0100QHelpLink,
    copy_QList_0100QHelpLink,
    release_QList_0100QHelpLink,
    convertTo_QList_0100QHelpLink,
    convertFrom_QList_0100QHelpLink
};
