/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.Sorting;

public abstract class MethodVerifier
extends ImplicitNullAnnotationVerifier {
    SourceTypeBinding type = null;
    HashtableOfObject inheritedMethods = null;
    HashtableOfObject currentMethods = null;
    HashtableOfObject inheritedOverriddenMethods = null;

    MethodVerifier(LookupEnvironment lookupEnvironment) {
        super(lookupEnvironment);
    }

    boolean areMethodsCompatible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.areMethodsCompatible(methodBinding, methodBinding2, this.environment);
    }

    static boolean areMethodsCompatible(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        methodBinding2 = (methodBinding = methodBinding.original()).findOriginalInheritedMethod(methodBinding2);
        if (methodBinding2 == null) {
            return false;
        }
        return MethodVerifier.isParameterSubsignature(methodBinding, methodBinding2, lookupEnvironment);
    }

    boolean areReturnTypesCompatible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.areReturnTypesCompatible(methodBinding, methodBinding2, this.type.scope.environment());
    }

    public static boolean areReturnTypesCompatible(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        if (TypeBinding.equalsEquals(methodBinding.returnType, methodBinding2.returnType)) {
            return true;
        }
        if (lookupEnvironment.globalOptions.sourceLevel >= 0x310000L) {
            if (methodBinding.returnType.isBaseType()) {
                return false;
            }
            if (!methodBinding.declaringClass.isInterface() && methodBinding.declaringClass.id == 1) {
                return methodBinding2.returnType.isCompatibleWith(methodBinding.returnType);
            }
            return methodBinding.returnType.isCompatibleWith(methodBinding2.returnType);
        }
        return MethodVerifier.areTypesEqual(methodBinding.returnType.erasure(), methodBinding2.returnType.erasure());
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && this.type.superclass().isAbstract()) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    boolean canSkipInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding2 == null || TypeBinding.equalsEquals(methodBinding.declaringClass, methodBinding2.declaringClass);
    }

    void checkAbstractMethod(MethodBinding methodBinding) {
        if (this.mustImplementAbstractMethod(methodBinding.declaringClass)) {
            TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
            if (typeDeclaration != null) {
                MethodDeclaration methodDeclaration = typeDeclaration.addMissingAbstractMethodFor(methodBinding);
                methodDeclaration.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding);
            } else {
                this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding);
            }
        }
    }

    void checkAgainstInheritedMethods(MethodBinding methodBinding, MethodBinding[] methodBindingArray, int n, MethodBinding[] methodBindingArray2) {
        Binding binding;
        if (this.type.isAnnotationType()) {
            this.problemReporter().annotationCannotOverrideMethod(methodBinding, methodBindingArray[n - 1]);
            return;
        }
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        int[] nArray = n > 1 ? this.findOverriddenInheritedMethods(methodBindingArray, n) : null;
        int n2 = n;
        block0: while (--n2 >= 0) {
            MethodBinding methodBinding2 = methodBindingArray[n2];
            if (nArray == null || nArray[n2] == 0) {
                if (methodBinding.isStatic() != methodBinding2.isStatic()) {
                    this.problemReporter(methodBinding).staticAndInstanceConflict(methodBinding, methodBinding2);
                    continue;
                }
                if (methodBinding2.isAbstract()) {
                    methodBinding.modifiers = methodBinding2.declaringClass.isInterface() ? (methodBinding.modifiers |= 0x20000000) : (methodBinding.modifiers |= 0x30000000);
                } else if (methodBinding2.isPublic() || !this.type.isInterface()) {
                    if (methodBinding.isDefaultMethod() && !methodBinding2.isFinal() && methodBinding2.declaringClass.id == 1) {
                        this.problemReporter(methodBinding).defaultMethodOverridesObjectMethod(methodBinding);
                    } else {
                        methodBinding.modifiers = methodBinding2.isDefaultMethod() ? (methodBinding.modifiers |= 0x20000000) : (methodBinding.modifiers |= 0x10000000);
                    }
                }
                if (!this.areReturnTypesCompatible(methodBinding, methodBinding2) && (methodBinding.returnType.tagBits & 0x80L) == 0L && this.reportIncompatibleReturnTypeError(methodBinding, methodBinding2)) continue;
                this.reportRawReferences(methodBinding, methodBinding2);
                if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
                    this.checkExceptions(methodBinding, methodBinding2);
                }
                if (methodBinding2.isFinal()) {
                    this.problemReporter(methodBinding).finalMethodCannotBeOverridden(methodBinding, methodBinding2);
                }
                if (!this.isAsVisible(methodBinding, methodBinding2)) {
                    this.problemReporter(methodBinding).visibilityConflict(methodBinding, methodBinding2);
                }
                if (methodBinding2.isSynchronized() && !methodBinding.isSynchronized()) {
                    this.problemReporter(methodBinding).missingSynchronizedOnInheritedMethod(methodBinding, methodBinding2);
                }
                if (compilerOptions.reportDeprecationWhenOverridingDeprecatedMethod && methodBinding2.isViewedAsDeprecated() && (!methodBinding.isViewedAsDeprecated() || compilerOptions.reportDeprecationInsideDeprecatedCode)) {
                    binding = methodBinding2.declaringClass;
                    if (((ReferenceBinding)binding).isInterface()) {
                        int n3 = n;
                        while (--n3 >= 0) {
                            if (n2 == n3 || !methodBindingArray[n3].declaringClass.implementsInterface((ReferenceBinding)binding, false)) continue;
                            continue block0;
                        }
                    }
                    this.problemReporter(methodBinding).overridesDeprecatedMethod(methodBinding, methodBinding2);
                }
            }
            if (methodBinding2.isStatic() || methodBinding2.isFinal()) continue;
            this.checkForBridgeMethod(methodBinding, methodBinding2, methodBindingArray2);
        }
        MethodBinding[] methodBindingArray3 = (MethodBinding[])this.inheritedOverriddenMethods.get(methodBinding.selector);
        if (methodBindingArray3 != null) {
            int n4 = methodBindingArray3.length;
            while (--n4 >= 0) {
                binding = methodBindingArray3[n4];
                if (!this.isParameterSubsignature(methodBinding, (MethodBinding)binding) || ((MethodBinding)binding).isStatic() || ((MethodBinding)binding).isFinal()) continue;
                this.checkForBridgeMethod(methodBinding, (MethodBinding)binding, methodBindingArray2);
            }
        }
    }

    void addBridgeMethodCandidate(MethodBinding methodBinding) {
        MethodBinding[] methodBindingArray = (MethodBinding[])this.inheritedOverriddenMethods.get(methodBinding.selector);
        if (methodBindingArray == null) {
            methodBindingArray = new MethodBinding[]{methodBinding};
        } else {
            int n = methodBindingArray.length;
            MethodBinding[] methodBindingArray2 = methodBindingArray;
            methodBindingArray = new MethodBinding[n + 1];
            System.arraycopy(methodBindingArray2, 0, methodBindingArray, 0, n);
            methodBindingArray[n] = methodBinding;
        }
        this.inheritedOverriddenMethods.put(methodBinding.selector, methodBindingArray);
    }

    public void reportRawReferences(MethodBinding methodBinding, MethodBinding methodBinding2) {
    }

    void checkConcreteInheritedMethod(MethodBinding methodBinding, MethodBinding[] methodBindingArray) {
        int n;
        if (methodBinding.isStatic()) {
            this.problemReporter().staticInheritedMethodConflicts(this.type, methodBinding, methodBindingArray);
        }
        if (!methodBinding.isPublic()) {
            int n2 = methodBindingArray.length;
            if (methodBinding.isProtected()) {
                for (n = 0; n < n2 && !methodBindingArray[n].isPublic(); ++n) {
                }
            } else if (methodBinding.isDefault()) {
                while (n < n2 && methodBindingArray[n].isDefault()) {
                    ++n;
                }
            }
            if (n < n2) {
                this.problemReporter().inheritedMethodReducesVisibility(this.type, methodBinding, methodBindingArray);
            }
        }
        if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            n = methodBindingArray.length;
            while (--n >= 0) {
                this.checkExceptions(methodBinding, methodBindingArray[n]);
            }
        }
        if (methodBinding.isOrEnclosedByPrivateType()) {
            methodBinding.original().modifiers |= 0x8000000;
        }
    }

    void checkExceptions(MethodBinding methodBinding, MethodBinding methodBinding2) {
        ReferenceBinding[] referenceBindingArray = this.resolvedExceptionTypesFor(methodBinding);
        ReferenceBinding[] referenceBindingArray2 = this.resolvedExceptionTypesFor(methodBinding2);
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            ReferenceBinding referenceBinding = referenceBindingArray[n];
            int n2 = referenceBindingArray2.length;
            while (--n2 > -1 && !this.isSameClassOrSubclassOf(referenceBinding, referenceBindingArray2[n2])) {
            }
            if (n2 != -1 || referenceBinding.isUncheckedException(false) || (referenceBinding.tagBits & 0x80L) != 0L) continue;
            this.problemReporter(methodBinding).incompatibleExceptionInThrowsClause(this.type, methodBinding, methodBinding2, referenceBinding);
        }
    }

    void checkForBridgeMethod(MethodBinding methodBinding, MethodBinding methodBinding2, MethodBinding[] methodBindingArray) {
    }

    void checkForMissingHashCodeMethod() {
        MethodBinding methodBinding;
        MethodBinding[] methodBindingArray = this.type.getMethods(TypeConstants.EQUALS);
        boolean bl = false;
        int n = methodBindingArray.length;
        while (!bl && --n >= 0) {
            bl = methodBindingArray[n].parameters.length == 1 && methodBindingArray[n].parameters[0].id == 1;
        }
        if (bl && (methodBinding = this.type.getExactMethod(TypeConstants.HASHCODE, Binding.NO_PARAMETERS, null)) != null && methodBinding.declaringClass.id == 1) {
            this.problemReporter().shouldImplementHashcode(this.type);
        }
    }

    /*
     * WARNING - void declaration
     */
    void checkForRedundantSuperinterfaces(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        void var10_18;
        int n;
        int n2;
        Object object;
        if (referenceBindingArray == Binding.NO_SUPERINTERFACES) {
            return;
        }
        SimpleSet simpleSet = new SimpleSet(referenceBindingArray.length);
        SimpleSet simpleSet2 = null;
        int n3 = referenceBindingArray.length;
        for (int i = 0; i < n3; ++i) {
            object = referenceBindingArray[i];
            block1: for (n2 = 0; n2 < n3; ++n2) {
                ReferenceBinding referenceBinding2 = referenceBindingArray[n2];
                if (i == n2 || !((ReferenceBinding)object).implementsInterface(referenceBinding2, true)) continue;
                if (simpleSet2 == null) {
                    simpleSet2 = new SimpleSet(3);
                } else if (simpleSet2.includes(referenceBinding2)) continue;
                simpleSet2.add(referenceBinding2);
                TypeReference[] typeReferenceArray = this.type.scope.referenceContext.superInterfaces;
                n = typeReferenceArray.length;
                for (int n5 = 0; n5 < n; ++n5) {
                    if (!TypeBinding.equalsEquals(typeReferenceArray[n5].resolvedType, (TypeBinding)object)) continue;
                    this.problemReporter().redundantSuperInterface(this.type, typeReferenceArray[n2], referenceBinding2, (ReferenceBinding)object);
                    continue block1;
                }
            }
            simpleSet.add(object);
        }
        ReferenceBinding[] referenceBindingArray2 = null;
        SimpleSet simpleSet3 = new SimpleSet(5);
        for (object = referenceBinding; object != null && ((Binding)object).isValidBinding(); object = ((ReferenceBinding)object).superclass()) {
            referenceBindingArray2 = ((ReferenceBinding)object).superInterfaces();
            if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
            block4: for (ReferenceBinding referenceBinding2 : referenceBindingArray2) {
                if (simpleSet3.includes(referenceBinding2) || !referenceBinding2.isValidBinding()) continue;
                if (simpleSet.includes(referenceBinding2)) {
                    if (simpleSet2 == null) {
                        simpleSet2 = new SimpleSet(3);
                    } else if (simpleSet2.includes(referenceBinding2)) continue;
                    simpleSet2.add(referenceBinding2);
                    TypeReference[] typeReferenceArray = this.type.scope.referenceContext.superInterfaces;
                    int n4 = typeReferenceArray.length;
                    for (n = 0; n < n4; ++n) {
                        if (!TypeBinding.equalsEquals(typeReferenceArray[n].resolvedType, referenceBinding2)) continue;
                        this.problemReporter().redundantSuperInterface(this.type, typeReferenceArray[n], referenceBinding2, (ReferenceBinding)object);
                        continue block4;
                    }
                    continue;
                }
                simpleSet3.add(referenceBinding2);
            }
        }
        n2 = simpleSet3.elementSize;
        if (n2 == 0) {
            return;
        }
        Object[] objectArray = new ReferenceBinding[n2];
        simpleSet3.asArray(objectArray);
        boolean bl = false;
        while (var10_18 < n2) {
            object = objectArray[var10_18];
            referenceBindingArray2 = ((ReferenceBinding)object).superInterfaces();
            if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                int n5 = referenceBindingArray2.length;
                if (n2 + n5 >= objectArray.length) {
                    Object[] objectArray2 = objectArray;
                    objectArray = new ReferenceBinding[n2 + n5 + 5];
                    System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                }
                block7: for (n = 0; n < n5; ++n) {
                    ReferenceBinding referenceBinding3 = referenceBindingArray2[n];
                    if (simpleSet3.includes(referenceBinding3) || !referenceBinding3.isValidBinding()) continue;
                    if (simpleSet.includes(referenceBinding3)) {
                        if (simpleSet2 == null) {
                            simpleSet2 = new SimpleSet(3);
                        } else if (simpleSet2.includes(referenceBinding3)) continue;
                        simpleSet2.add(referenceBinding3);
                        TypeReference[] typeReferenceArray = this.type.scope.referenceContext.superInterfaces;
                        int n6 = typeReferenceArray.length;
                        for (int i = 0; i < n6; ++i) {
                            if (!TypeBinding.equalsEquals(typeReferenceArray[i].resolvedType, referenceBinding3)) continue;
                            this.problemReporter().redundantSuperInterface(this.type, typeReferenceArray[i], referenceBinding3, (ReferenceBinding)object);
                            continue block7;
                        }
                        continue;
                    }
                    simpleSet3.add(referenceBinding3);
                    objectArray[n2++] = referenceBinding3;
                }
            }
            ++var10_18;
        }
    }

    void checkInheritedMethods(MethodBinding[] methodBindingArray, int n, boolean[] blArray, boolean[] blArray2) {
        MethodBinding methodBinding;
        MethodBinding methodBinding2 = methodBinding = this.type.isInterface() || methodBindingArray[0].isAbstract() ? null : methodBindingArray[0];
        if (methodBinding == null) {
            boolean bl;
            MethodBinding methodBinding3 = n == 1 ? methodBindingArray[0] : this.findBestInheritedAbstractOrDefaultMethod(methodBindingArray, n);
            boolean bl2 = bl = methodBinding3 == null;
            if (bl) {
                methodBinding3 = methodBindingArray[0];
            }
            if (this.mustImplementAbstractMethod(methodBinding3.declaringClass)) {
                TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
                MethodBinding methodBinding4 = methodBindingArray[0];
                if (methodBinding4 == methodBinding3 || methodBinding4.declaringClass.isInterface()) {
                    if (typeDeclaration != null) {
                        MethodDeclaration methodDeclaration = typeDeclaration.addMissingAbstractMethodFor(methodBinding3);
                        methodDeclaration.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3);
                    } else {
                        this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3);
                    }
                } else if (typeDeclaration != null) {
                    MethodDeclaration methodDeclaration = typeDeclaration.addMissingAbstractMethodFor(methodBinding3);
                    methodDeclaration.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3, methodBinding4);
                } else {
                    this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3, methodBinding4);
                }
            } else if (bl) {
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methodBindingArray, n, blArray);
            }
            return;
        }
        if (n < 2) {
            return;
        }
        int n2 = n;
        while (--n2 > 0 && this.checkInheritedReturnTypes(methodBinding, methodBindingArray[n2])) {
        }
        if (n2 > 0) {
            MethodBinding methodBinding5 = this.findBestInheritedAbstractOrDefaultMethod(methodBindingArray, n);
            if (methodBinding5 == null) {
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methodBindingArray, n, blArray);
            } else {
                this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding5, methodBinding);
            }
            return;
        }
        MethodBinding[] methodBindingArray2 = new MethodBinding[n - 1];
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!methodBindingArray[i].isAbstract() && (methodBindingArray[i] == methodBinding || !methodBindingArray[i].isDefaultMethod())) continue;
            methodBindingArray2[n2++] = methodBindingArray[i];
        }
        if (n2 == 0) {
            return;
        }
        if (n2 < methodBindingArray2.length) {
            MethodBinding[] methodBindingArray3 = methodBindingArray2;
            methodBindingArray2 = new MethodBinding[n2];
            System.arraycopy(methodBindingArray3, 0, methodBindingArray2, 0, n2);
        }
        this.checkConcreteInheritedMethod(methodBinding, methodBindingArray2);
    }

    boolean checkInheritedReturnTypes(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.areReturnTypesCompatible(methodBinding, methodBinding2)) {
            return true;
        }
        return !(this.type.isInterface() || !methodBinding.declaringClass.isClass() && this.type.implementsInterface(methodBinding.declaringClass, false) || !methodBinding2.declaringClass.isClass() && this.type.implementsInterface(methodBinding2.declaringClass, false));
    }

    abstract void checkMethods();

    void checkPackagePrivateAbstractMethod(MethodBinding methodBinding) {
        PackageBinding packageBinding = methodBinding.declaringClass.fPackage;
        if (packageBinding == this.type.fPackage) {
            return;
        }
        ReferenceBinding referenceBinding = this.type.superclass();
        char[] cArray = methodBinding.selector;
        do {
            if (!referenceBinding.isValidBinding()) {
                return;
            }
            if (!referenceBinding.isAbstract()) {
                return;
            }
            if (packageBinding != referenceBinding.fPackage) continue;
            MethodBinding[] methodBindingArray = referenceBinding.getMethods(cArray);
            int n = methodBindingArray.length;
            while (--n >= 0) {
                MethodBinding methodBinding2 = methodBindingArray[n];
                if (methodBinding2.isPrivate() || methodBinding2.isConstructor() || methodBinding2.isDefaultAbstract() || !this.areMethodsCompatible(methodBinding2, methodBinding)) continue;
                return;
            }
        } while (TypeBinding.notEquals(referenceBinding = referenceBinding.superclass(), methodBinding.declaringClass));
        this.problemReporter().abstractMethodCannotBeOverridden(this.type, methodBinding);
    }

    void computeInheritedMethods() {
        ReferenceBinding referenceBinding = this.type.isInterface() ? this.type.scope.getJavaLangObject() : this.type.superclass();
        this.computeInheritedMethods(referenceBinding, this.type.superInterfaces());
        this.checkForRedundantSuperinterfaces(referenceBinding, this.type.superInterfaces());
    }

    void computeInheritedMethods(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        int n;
        MethodBinding[] methodBindingArray;
        int n2;
        int n3;
        Object object;
        Binding binding;
        MethodBinding[] methodBindingArray2;
        ReferenceBinding referenceBinding2;
        this.inheritedMethods = new HashtableOfObject(51);
        this.inheritedOverriddenMethods = new HashtableOfObject(11);
        HashtableOfObject hashtableOfObject = new HashtableOfObject(3);
        for (referenceBinding2 = referenceBinding; referenceBinding2 != null && referenceBinding2.isValidBinding(); referenceBinding2 = referenceBinding2.superclass()) {
            methodBindingArray2 = referenceBinding2.unResolvedMethods();
            int n4 = methodBindingArray2.length;
            block1: while (--n4 >= 0) {
                MethodBinding[] methodBindingArray3;
                binding = methodBindingArray2[n4];
                if (((MethodBinding)binding).isPrivate() || ((MethodBinding)binding).isConstructor() || ((MethodBinding)binding).isDefaultAbstract()) continue;
                object = (MethodBinding[])this.inheritedMethods.get(((MethodBinding)binding).selector);
                if (object != null) {
                    n3 = ((MethodBinding[])object).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        methodBindingArray = object[n2];
                        if (!TypeBinding.notEquals(methodBindingArray.declaringClass, ((MethodBinding)binding).declaringClass) || !this.areMethodsCompatible((MethodBinding)methodBindingArray, (MethodBinding)binding) || this.canOverridingMethodDifferInErasure((MethodBinding)methodBindingArray, (MethodBinding)binding)) continue;
                        if (((MethodBinding)binding).isDefault()) {
                            if (((MethodBinding)binding).isAbstract()) {
                                this.checkPackagePrivateAbstractMethod((MethodBinding)binding);
                            } else if (methodBindingArray.declaringClass.fPackage != ((MethodBinding)binding).declaringClass.fPackage && this.type.fPackage == ((MethodBinding)binding).declaringClass.fPackage && !this.areReturnTypesCompatible((MethodBinding)binding, (MethodBinding)methodBindingArray)) continue;
                        }
                        if (!TypeBinding.notEquals(((MethodBinding)binding).returnType.erasure(), methodBindingArray.returnType.erasure()) || !this.areReturnTypesCompatible((MethodBinding)methodBindingArray, (MethodBinding)binding)) continue block1;
                        this.addBridgeMethodCandidate((MethodBinding)binding);
                        continue block1;
                    }
                }
                if (!((MethodBinding)binding).isDefault() || ((MethodBinding)binding).declaringClass.fPackage == this.type.fPackage) {
                    if (object == null) {
                        object = new MethodBinding[]{binding};
                    } else {
                        n2 = ((MethodBinding[])object).length;
                        Object object2 = object;
                        object = new MethodBinding[n2 + 1];
                        System.arraycopy(object2, 0, object, 0, n2);
                        object[n2] = binding;
                    }
                    this.inheritedMethods.put(((MethodBinding)binding).selector, object);
                    continue;
                }
                MethodBinding[] methodBindingArray4 = (MethodBinding[])hashtableOfObject.get(((MethodBinding)binding).selector);
                if (methodBindingArray4 != null && ((MethodBinding)binding).isAbstract()) {
                    int n5 = methodBindingArray4.length;
                    for (n3 = 0; n3 < n5; ++n3) {
                        if (this.areMethodsCompatible(methodBindingArray4[n3], (MethodBinding)binding)) continue block1;
                    }
                }
                if (methodBindingArray4 == null) {
                    methodBindingArray4 = new MethodBinding[]{binding};
                } else {
                    n3 = methodBindingArray4.length;
                    MethodBinding[] methodBindingArray5 = methodBindingArray4;
                    methodBindingArray4 = new MethodBinding[n3 + 1];
                    System.arraycopy(methodBindingArray5, 0, methodBindingArray4, 0, n3);
                    methodBindingArray4[n3] = binding;
                }
                hashtableOfObject.put(((MethodBinding)binding).selector, methodBindingArray4);
                if (((MethodBinding)binding).isAbstract() && !this.type.isAbstract()) {
                    this.problemReporter().abstractMethodCannotBeOverridden(this.type, (MethodBinding)binding);
                }
                if ((methodBindingArray3 = (MethodBinding[])this.currentMethods.get(((MethodBinding)binding).selector)) == null || ((MethodBinding)binding).isStatic()) continue;
                n = methodBindingArray3.length;
                for (int i = 0; i < n; ++i) {
                    if (methodBindingArray3[i].isStatic() || !this.areMethodsCompatible(methodBindingArray3[i], (MethodBinding)binding)) continue;
                    this.problemReporter().overridesPackageDefaultMethod(methodBindingArray3[i], (MethodBinding)binding);
                    continue block1;
                }
            }
        }
        methodBindingArray2 = new ArrayList();
        HashSet hashSet = new HashSet();
        this.collectAllDistinctSuperInterfaces(referenceBindingArray, hashSet, (List)methodBindingArray2);
        for (binding = referenceBinding; binding != null && ((ReferenceBinding)binding).id != 1; binding = ((ReferenceBinding)binding).superclass()) {
            this.collectAllDistinctSuperInterfaces(((ReferenceBinding)binding).superInterfaces(), hashSet, (List)methodBindingArray2);
        }
        if (methodBindingArray2.size() == 0) {
            return;
        }
        if (methodBindingArray2.size() == 1) {
            referenceBindingArray = new ReferenceBinding[]{(ReferenceBinding)methodBindingArray2.get(0)};
        } else {
            referenceBindingArray = methodBindingArray2.toArray(new ReferenceBinding[methodBindingArray2.size()]);
            referenceBindingArray = Sorting.sortTypes(referenceBindingArray);
        }
        object = this.findSuperinterfaceCollisions(referenceBinding, referenceBindingArray);
        n2 = referenceBindingArray.length;
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            referenceBinding2 = referenceBindingArray[n3];
            if (!referenceBinding2.isValidBinding() || object != null && ((SimpleSet)object).includes(referenceBinding2)) continue;
            methodBindingArray = referenceBinding2.unResolvedMethods();
            n = methodBindingArray.length;
            block7: while (--n >= 0) {
                MethodBinding methodBinding = methodBindingArray[n];
                if (methodBinding.isStatic() || methodBinding.isPrivate()) continue;
                MethodBinding[] methodBindingArray6 = (MethodBinding[])this.inheritedMethods.get(methodBinding.selector);
                if (methodBindingArray6 == null) {
                    methodBindingArray6 = new MethodBinding[]{methodBinding};
                } else {
                    int n6 = methodBindingArray6.length;
                    for (int i = 0; i < n6; ++i) {
                        if (!this.isInterfaceMethodImplemented(methodBinding, methodBindingArray6[i], referenceBinding2)) continue;
                        if (TypeBinding.notEquals(methodBinding.returnType.erasure(), methodBindingArray6[i].returnType.erasure())) {
                            this.addBridgeMethodCandidate(methodBinding);
                        }
                        if (!this.canOverridingMethodDifferInErasure(methodBindingArray6[i], methodBinding)) continue block7;
                    }
                    MethodBinding[] methodBindingArray7 = methodBindingArray6;
                    methodBindingArray6 = new MethodBinding[n6 + 1];
                    System.arraycopy(methodBindingArray7, 0, methodBindingArray6, 0, n6);
                    methodBindingArray6[n6] = methodBinding;
                }
                this.inheritedMethods.put(methodBinding.selector, methodBindingArray6);
            }
        }
    }

    void collectAllDistinctSuperInterfaces(ReferenceBinding[] referenceBindingArray, Set set, List list) {
        for (ReferenceBinding referenceBinding : referenceBindingArray) {
            if (!set.add(referenceBinding)) continue;
            list.add(referenceBinding);
            this.collectAllDistinctSuperInterfaces(referenceBinding.superInterfaces(), set, list);
        }
    }

    protected boolean canOverridingMethodDifferInErasure(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return false;
    }

    void computeMethods() {
        MethodBinding[] methodBindingArray = this.type.methods();
        int n = methodBindingArray.length;
        this.currentMethods = new HashtableOfObject(n == 0 ? 1 : n);
        int n2 = n;
        while (--n2 >= 0) {
            MethodBinding methodBinding = methodBindingArray[n2];
            if (methodBinding.isConstructor() || methodBinding.isDefaultAbstract()) continue;
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.currentMethods.get(methodBinding.selector);
            if (methodBindingArray2 == null) {
                methodBindingArray2 = new MethodBinding[1];
            } else {
                MethodBinding[] methodBindingArray3 = methodBindingArray2;
                methodBindingArray2 = new MethodBinding[methodBindingArray2.length + 1];
                System.arraycopy(methodBindingArray3, 0, methodBindingArray2, 0, methodBindingArray2.length - 1);
            }
            methodBindingArray2[methodBindingArray2.length - 1] = methodBinding;
            this.currentMethods.put(methodBinding.selector, methodBindingArray2);
        }
    }

    MethodBinding computeSubstituteMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.computeSubstituteMethod(methodBinding, methodBinding2, this.environment);
    }

    public static MethodBinding computeSubstituteMethod(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        TypeVariableBinding[] typeVariableBindingArray;
        int n;
        if (methodBinding == null) {
            return null;
        }
        if (methodBinding2.parameters.length != methodBinding.parameters.length) {
            return null;
        }
        if (methodBinding2.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)methodBinding2.declaringClass).resolveTypesFor(methodBinding2);
        }
        if (methodBinding.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)methodBinding.declaringClass).resolveTypesFor(methodBinding);
        }
        if ((n = (typeVariableBindingArray = methodBinding.typeVariables).length) == 0) {
            return methodBinding;
        }
        TypeVariableBinding[] typeVariableBindingArray2 = methodBinding2.typeVariables;
        int n2 = typeVariableBindingArray2.length;
        if (n2 == 0) {
            return methodBinding.asRawMethod(lookupEnvironment);
        }
        if (n2 != n) {
            return methodBinding;
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n2];
        System.arraycopy(typeVariableBindingArray2, 0, typeBindingArray, 0, n2);
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = lookupEnvironment.createParameterizedGenericMethod(methodBinding, typeBindingArray);
        for (int i = 0; i < n; ++i) {
            TypeVariableBinding typeVariableBinding = typeVariableBindingArray[i];
            TypeVariableBinding typeVariableBinding2 = (TypeVariableBinding)typeBindingArray[i];
            if (TypeBinding.equalsEquals(typeVariableBinding2.firstBound, typeVariableBinding.firstBound)) {
                if (typeVariableBinding2.firstBound == null) {
                    continue;
                }
            } else if (typeVariableBinding2.firstBound != null && typeVariableBinding.firstBound != null && typeVariableBinding2.firstBound.isClass() != typeVariableBinding.firstBound.isClass()) {
                return methodBinding;
            }
            if (TypeBinding.notEquals(Scope.substitute((Substitution)parameterizedGenericMethodBinding, typeVariableBinding.superclass), typeVariableBinding2.superclass)) {
                return methodBinding;
            }
            int n3 = typeVariableBinding.superInterfaces.length;
            ReferenceBinding[] referenceBindingArray = typeVariableBinding2.superInterfaces;
            if (n3 != referenceBindingArray.length) {
                return methodBinding;
            }
            block1: for (int j = 0; j < n3; ++j) {
                TypeBinding typeBinding = Scope.substitute((Substitution)parameterizedGenericMethodBinding, typeVariableBinding.superInterfaces[j]);
                for (int k = 0; k < n3; ++k) {
                    if (TypeBinding.equalsEquals(typeBinding, referenceBindingArray[k])) continue block1;
                }
                return methodBinding;
            }
        }
        return parameterizedGenericMethodBinding;
    }

    static boolean couldMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!CharOperation.equals(methodBinding.selector, methodBinding2.selector)) {
            return false;
        }
        if (methodBinding == methodBinding2 || methodBinding.isStatic() || methodBinding2.isStatic()) {
            return false;
        }
        if (methodBinding2.isPrivate()) {
            return false;
        }
        if (methodBinding2.isDefault() && methodBinding.declaringClass.getPackage() != methodBinding2.declaringClass.getPackage()) {
            return false;
        }
        if (!methodBinding.isPublic()) {
            if (methodBinding2.isPublic()) {
                return false;
            }
            if (methodBinding2.isProtected() && !methodBinding.isProtected()) {
                return false;
            }
        }
        return true;
    }

    public boolean doesMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.doesMethodOverride(methodBinding, methodBinding2, this.environment);
    }

    public static boolean doesMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        return MethodVerifier.couldMethodOverride(methodBinding, methodBinding2) && MethodVerifier.areMethodsCompatible(methodBinding, methodBinding2, lookupEnvironment);
    }

    SimpleSet findSuperinterfaceCollisions(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        return null;
    }

    MethodBinding findBestInheritedAbstractOrDefaultMethod(MethodBinding[] methodBindingArray, int n) {
        block0: for (int i = 0; i < n; ++i) {
            MethodBinding methodBinding = methodBindingArray[i];
            if (!methodBinding.isAbstract() && !methodBinding.isDefaultMethod()) continue;
            for (int j = 0; j < n; ++j) {
                if (i == j || this.checkInheritedReturnTypes(methodBinding, methodBindingArray[j])) continue;
                if (!this.type.isInterface() || methodBindingArray[j].declaringClass.id != 1) continue block0;
                return methodBinding;
            }
            return methodBinding;
        }
        return null;
    }

    int[] findOverriddenInheritedMethods(MethodBinding[] methodBindingArray, int n) {
        int[] nArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding = methodBindingArray[n2].declaringClass;
        if (!referenceBinding.isInterface()) {
            ReferenceBinding referenceBinding2 = methodBindingArray[++n2].declaringClass;
            while (TypeBinding.equalsEquals(referenceBinding, referenceBinding2)) {
                if (++n2 == n) {
                    return null;
                }
                referenceBinding2 = methodBindingArray[n2].declaringClass;
            }
            if (!referenceBinding2.isInterface()) {
                if (referenceBinding.fPackage != referenceBinding2.fPackage && methodBindingArray[n2].isDefault()) {
                    return null;
                }
                nArray = new int[n];
                do {
                    nArray[n2] = -1;
                    if (++n2 != n) continue;
                    return nArray;
                } while (!(referenceBinding2 = methodBindingArray[n2].declaringClass).isInterface());
            }
        }
        while (n2 < n) {
            if (nArray == null || nArray[n2] != -1) {
                referenceBinding = methodBindingArray[n2].declaringClass;
                for (int i = n2 + 1; i < n; ++i) {
                    ReferenceBinding referenceBinding3;
                    if (nArray != null && nArray[i] == -1 || TypeBinding.equalsEquals(referenceBinding, referenceBinding3 = methodBindingArray[i].declaringClass)) continue;
                    if (referenceBinding.implementsInterface(referenceBinding3, true)) {
                        if (nArray == null) {
                            nArray = new int[n];
                        }
                        nArray[i] = -1;
                        continue;
                    }
                    if (!referenceBinding3.implementsInterface(referenceBinding, true)) continue;
                    if (nArray == null) {
                        nArray = new int[n];
                    }
                    nArray[n2] = -1;
                    break;
                }
            }
            ++n2;
        }
        return nArray;
    }

    boolean isAsVisible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding2.modifiers == methodBinding.modifiers) {
            return true;
        }
        if (methodBinding.isPublic()) {
            return true;
        }
        if (methodBinding2.isPublic()) {
            return false;
        }
        if (methodBinding.isProtected()) {
            return true;
        }
        if (methodBinding2.isProtected()) {
            return false;
        }
        return !methodBinding.isPrivate();
    }

    boolean isInterfaceMethodImplemented(MethodBinding methodBinding, MethodBinding methodBinding2, ReferenceBinding referenceBinding) {
        return MethodVerifier.areParametersEqual(methodBinding2, methodBinding) && methodBinding2.declaringClass.implementsInterface(referenceBinding, true);
    }

    public boolean isMethodSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return CharOperation.equals(methodBinding.selector, methodBinding2.selector) && this.isParameterSubsignature(methodBinding, methodBinding2);
    }

    boolean isParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.isParameterSubsignature(methodBinding, methodBinding2, this.environment);
    }

    static boolean isParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        MethodBinding methodBinding3 = MethodVerifier.computeSubstituteMethod(methodBinding2, methodBinding, lookupEnvironment);
        return methodBinding3 != null && MethodVerifier.isSubstituteParameterSubsignature(methodBinding, methodBinding3, lookupEnvironment);
    }

    boolean isSubstituteParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.isSubstituteParameterSubsignature(methodBinding, methodBinding2, this.environment);
    }

    public static boolean isSubstituteParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        if (!MethodVerifier.areParametersEqual(methodBinding, methodBinding2)) {
            if (methodBinding2.hasSubstitutedParameters() && methodBinding.areParameterErasuresEqual(methodBinding2)) {
                return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && !MethodVerifier.hasGenericParameter(methodBinding);
            }
            if (methodBinding.declaringClass.isRawType() && methodBinding2.declaringClass.isRawType() && methodBinding.hasSubstitutedParameters() && methodBinding2.hasSubstitutedParameters()) {
                return MethodVerifier.areMethodsCompatible(methodBinding, methodBinding2, lookupEnvironment);
            }
            return false;
        }
        if (methodBinding2 instanceof ParameterizedGenericMethodBinding) {
            if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
                return !((ParameterizedGenericMethodBinding)methodBinding2).isRaw;
            }
            return !MethodVerifier.hasGenericParameter(methodBinding);
        }
        return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES;
    }

    static boolean hasGenericParameter(MethodBinding methodBinding) {
        if (methodBinding.genericSignature() == null) {
            return false;
        }
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = typeBindingArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            TypeBinding typeBinding = typeBindingArray[i].leafComponentType();
            if (!(typeBinding instanceof ReferenceBinding) || ((n2 = ((ReferenceBinding)typeBinding).modifiers) & 0x40000000) == 0) continue;
            return true;
        }
        return false;
    }

    boolean isSameClassOrSubclassOf(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        do {
            if (!TypeBinding.equalsEquals(referenceBinding, referenceBinding2)) continue;
            return true;
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    boolean mustImplementAbstractMethod(ReferenceBinding referenceBinding) {
        if (!this.mustImplementAbstractMethods()) {
            return false;
        }
        ReferenceBinding referenceBinding2 = this.type.superclass();
        if (referenceBinding.isClass()) {
            while (referenceBinding2.isAbstract() && TypeBinding.notEquals(referenceBinding2, referenceBinding)) {
                referenceBinding2 = referenceBinding2.superclass();
            }
        } else {
            if (this.type.implementsInterface(referenceBinding, false) && !referenceBinding2.implementsInterface(referenceBinding, true)) {
                return true;
            }
            while (referenceBinding2.isAbstract() && !referenceBinding2.implementsInterface(referenceBinding, false)) {
                referenceBinding2 = referenceBinding2.superclass();
            }
        }
        return referenceBinding2.isAbstract();
    }

    boolean mustImplementAbstractMethods() {
        return !this.type.isInterface() && !this.type.isAbstract();
    }

    ProblemReporter problemReporter() {
        return this.type.scope.problemReporter();
    }

    ProblemReporter problemReporter(MethodBinding methodBinding) {
        ProblemReporter problemReporter = this.problemReporter();
        if (TypeBinding.equalsEquals(methodBinding.declaringClass, this.type) && methodBinding.sourceMethod() != null) {
            problemReporter.referenceContext = methodBinding.sourceMethod();
        }
        return problemReporter;
    }

    boolean reportIncompatibleReturnTypeError(MethodBinding methodBinding, MethodBinding methodBinding2) {
        this.problemReporter(methodBinding).incompatibleReturnType(methodBinding, methodBinding2);
        return true;
    }

    ReferenceBinding[] resolvedExceptionTypesFor(MethodBinding methodBinding) {
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        if ((methodBinding.modifiers & 0x2000000) == 0) {
            return referenceBindingArray;
        }
        if (!(methodBinding.declaringClass instanceof BinaryTypeBinding)) {
            return Binding.NO_EXCEPTIONS;
        }
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            referenceBindingArray[n] = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBindingArray[n], this.environment, true);
        }
        return referenceBindingArray;
    }

    void verify() {
        this.computeMethods();
        this.computeInheritedMethods();
        this.checkMethods();
        if (this.type.isClass()) {
            this.checkForMissingHashCodeMethod();
        }
    }

    void verify(SourceTypeBinding sourceTypeBinding) {
        if (this.type == null) {
            try {
                this.type = sourceTypeBinding;
                this.verify();
            }
            finally {
                this.type = null;
            }
        } else {
            this.environment.newMethodVerifier().verify(sourceTypeBinding);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10);
        stringBuilder.append("MethodVerifier for type: ");
        stringBuilder.append(this.type.readableName());
        stringBuilder.append('\n');
        stringBuilder.append("\t-inherited methods: ");
        stringBuilder.append(this.inheritedMethods);
        return stringBuilder.toString();
    }
}

