/* gnome-sudoku.c generated by valac 0.56.0, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_WINDOW (sudoku_window_get_type ())
#define SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_WINDOW, SudokuWindow))
#define SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_WINDOW, SudokuWindowClass))
#define IS_SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_WINDOW))
#define IS_SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_WINDOW))
#define SUDOKU_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_WINDOW, SudokuWindowClass))

typedef struct _SudokuWindow SudokuWindow;
typedef struct _SudokuWindowClass SudokuWindowClass;
enum  {
	SUDOKU_0_PROPERTY,
	SUDOKU_NUM_PROPERTIES
};
static GParamSpec* sudoku_properties[SUDOKU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SUDOKU_MAIN_MENU (sudoku_main_menu_get_type ())
#define SUDOKU_MAIN_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_MAIN_MENU, SudokuMainMenu))
#define SUDOKU_MAIN_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_MAIN_MENU, SudokuMainMenuClass))
#define IS_SUDOKU_MAIN_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_MAIN_MENU))
#define IS_SUDOKU_MAIN_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_MAIN_MENU))
#define SUDOKU_MAIN_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_MAIN_MENU, SudokuMainMenuClass))

typedef struct _SudokuMainMenu SudokuMainMenu;
typedef struct _SudokuMainMenuClass SudokuMainMenuClass;

#define TYPE_SUDOKU_MAIN_MENU_ITEM (sudoku_main_menu_item_get_type ())
#define SUDOKU_MAIN_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_MAIN_MENU_ITEM, SudokuMainMenuItem))
#define SUDOKU_MAIN_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_MAIN_MENU_ITEM, SudokuMainMenuItemClass))
#define IS_SUDOKU_MAIN_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_MAIN_MENU_ITEM))
#define IS_SUDOKU_MAIN_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_MAIN_MENU_ITEM))
#define SUDOKU_MAIN_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_MAIN_MENU_ITEM, SudokuMainMenuItemClass))

typedef struct _SudokuMainMenuItem SudokuMainMenuItem;
typedef struct _SudokuMainMenuItemClass SudokuMainMenuItemClass;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;

struct _Sudoku {
	GtkApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	GtkApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	SudokuWindow* window;
	SudokuGame* game;
	SudokuSaver* saver;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* clear_action;
	GSimpleAction* print_action;
	GSimpleAction* print_multiple_action;
	GSimpleAction* pause_action;
	GSimpleAction* play_custom_game_action;
	GSimpleAction* new_game_action;
	gboolean show_possibilities;
	GameMode current_game_mode;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block4Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

static gint Sudoku_private_offset;
static gpointer sudoku_parent_class = NULL;

VALA_EXTERN GType sudoku_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sudoku, g_object_unref)
VALA_EXTERN GType sudoku_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuWindow, g_object_unref)
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void sudoku_start_game_cb (Sudoku* self,
                           GSimpleAction* action,
                           GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void sudoku_create_game_cb (Sudoku* self);
static void _sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void sudoku_reset_cb (Sudoku* self);
static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void sudoku_undo_cb (Sudoku* self);
static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void sudoku_redo_cb (Sudoku* self);
static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void sudoku_print_cb (Sudoku* self);
static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static void sudoku_play_custom_game_cb (Sudoku* self);
static void _sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void sudoku_toggle_pause_cb (Sudoku* self);
static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN Sudoku* sudoku_new (void);
VALA_EXTERN Sudoku* sudoku_construct (GType object_type);
VALA_EXTERN GType sudoku_main_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuMainMenu, g_object_unref)
VALA_EXTERN GType sudoku_main_menu_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuMainMenuItem, g_object_unref)
static gint sudoku_real_handle_local_options (GApplication* base,
                                       GVariantDict* options);
static void sudoku_real_startup (GApplication* base);
static void __lambda29_ (Sudoku* self);
VALA_EXTERN GType sudoku_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuView, g_object_unref)
static SudokuView* sudoku_get_view (Sudoku* self);
VALA_EXTERN void sudoku_view_set_show_warnings (SudokuView* self,
                                    gboolean value);
static void ___lambda29__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda30_ (Sudoku* self);
VALA_EXTERN void sudoku_view_set_highlighter (SudokuView* self,
                                  gboolean value);
static void ___lambda30__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN SudokuWindow* sudoku_window_new (GSettings* settings);
VALA_EXTERN SudokuWindow* sudoku_window_construct (GType object_type,
                                       GSettings* settings);
static void sudoku_start_game (Sudoku* self,
                        SudokuBoard* board);
static void sudoku_show_new_game_screen (Sudoku* self);
static void sudoku_real_activate (GApplication* base);
static void sudoku_real_shutdown (GApplication* base);
static void sudoku_paused_changed_cb (Sudoku* self);
VALA_EXTERN void sudoku_window_display_pause_button (SudokuWindow* self);
static void sudoku_start_custom_game (Sudoku* self,
                               SudokuBoard* board);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ____lambda21_ (Block1Data* _data1_);
static void _____lambda21__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ____lambda22_ (Block2Data* _data2_,
                    gint response_id);
static void _____lambda22__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
static void sudoku_cell_changed_cb (Sudoku* self);
static void sudoku_board_completed_cb (Sudoku* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN void sudoku_window_board_completed (SudokuWindow* self);
static void __lambda18_ (Block3Data* _data3_,
                  gint response_id);
static void ___lambda18__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender,
                                                           gpointer self);
static void _sudoku_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender,
                                                       gint row,
                                                       gint col,
                                                       gint old_val,
                                                       gint new_val,
                                                       gpointer self);
static void _sudoku_board_completed_cb_sudoku_board_completed (SudokuBoard* _sender,
                                                        gpointer self);
VALA_EXTERN void sudoku_window_start_game (SudokuWindow* self,
                               SudokuGame* game,
                               gboolean show_possibilities);
VALA_EXTERN void sudoku_window_show_new_game_screen (SudokuWindow* self);
static void __lambda19_ (Sudoku* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda19__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void sudoku_window_will_start_game (SudokuWindow* self);
static void __lambda17_ (Sudoku* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda17__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda20_ (Block4Data* _data4_,
                  gint response_id);
VALA_EXTERN void sudoku_view_clear (SudokuView* self);
static void ___lambda20__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
VALA_EXTERN void sudoku_window_show_game_view (SudokuWindow* self);
VALA_EXTERN gboolean sudoku_window_is_board_visible (SudokuWindow* self);
VALA_EXTERN void sudoku_view_hide_popovers (SudokuView* self);
VALA_EXTERN GType sudoku_printer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuPrinter, g_object_unref)
VALA_EXTERN SudokuPrinter* sudoku_printer_new (GeeList* boards,
                                   gint sudokus_per_page,
                                   GtkWindow* window);
VALA_EXTERN SudokuPrinter* sudoku_printer_construct (GType object_type,
                                         GeeList* boards,
                                         gint sudokus_per_page,
                                         GtkWindow* window);
VALA_EXTERN GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
VALA_EXTERN GType print_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PrintDialog, g_object_unref)
VALA_EXTERN PrintDialog* print_dialog_new (SudokuSaver* saver,
                               GtkWindow* window);
VALA_EXTERN PrintDialog* print_dialog_construct (GType object_type,
                                     SudokuSaver* saver,
                                     GtkWindow* window);
static void __lambda27_ (Sudoku* self);
static void ___lambda27__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static gint sudoku_main (gchar** args,
                  gint args_length1);
VALA_EXTERN SudokuView* sudoku_window_get_view (SudokuWindow* self);
static void sudoku_finalize (GObject * obj);
static GType sudoku_get_type_once (void);
static void _vala_sudoku_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry SUDOKU_action_entries[14] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"create-game", _sudoku_create_game_cb_gsimple_action_activate_callback}, {"reset", _sudoku_reset_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"undo", _sudoku_undo_cb_gsimple_action_activate_callback}, {"redo", _sudoku_redo_cb_gsimple_action_activate_callback}, {"print", _sudoku_print_cb_gsimple_action_activate_callback}, {"play-custom-game", _sudoku_play_custom_game_cb_gsimple_action_activate_callback}, {"pause", _sudoku_toggle_pause_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry SUDOKU_option_entries[3] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {"show-possible-values", 's', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Show the possible values for each cell"), NULL}, {NULL}};
static const gchar* SUDOKU_authors[6] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", NULL};

static inline gpointer
sudoku_get_instance_private (Sudoku* self)
{
	return G_STRUCT_MEMBER_P (self, Sudoku_private_offset);
}

static void
_sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	sudoku_new_game_cb ((Sudoku*) self);
}

static void
_sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
}

static void
_sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	sudoku_create_game_cb ((Sudoku*) self);
}

static void
_sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	sudoku_reset_cb ((Sudoku*) self);
}

static void
_sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	sudoku_back_cb ((Sudoku*) self);
}

static void
_sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	sudoku_undo_cb ((Sudoku*) self);
}

static void
_sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	sudoku_redo_cb ((Sudoku*) self);
}

static void
_sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	sudoku_print_cb ((Sudoku*) self);
}

static void
_sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	sudoku_play_custom_game_cb ((Sudoku*) self);
}

static void
_sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	sudoku_toggle_pause_cb ((Sudoku*) self);
}

static void
_sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	sudoku_print_multiple_cb ((Sudoku*) self);
}

static void
_sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	sudoku_help_cb ((Sudoku*) self);
}

static void
_sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	sudoku_about_cb ((Sudoku*) self);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

Sudoku*
sudoku_construct (GType object_type)
{
	Sudoku * self = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	self = (Sudoku*) g_object_new (object_type, "application-id", "org.gnome.Sudoku", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
	g_type_ensure (TYPE_SUDOKU_MAIN_MENU);
	g_type_ensure (TYPE_SUDOKU_MAIN_MENU_ITEM);
	return self;
}

Sudoku*
sudoku_new (void)
{
	return sudoku_construct (TYPE_SUDOKU);
}

static gint
sudoku_real_handle_local_options (GApplication* base,
                                  GVariantDict* options)
{
	Sudoku * self;
	gint result;
	self = (Sudoku*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "gnome-sudoku %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (g_variant_dict_contains (options, "show-possible-values")) {
		self->priv->show_possibilities = TRUE;
	}
	result = -1;
	return result;
}

static void
__lambda29_ (Sudoku* self)
{
	gboolean _tmp0_ = FALSE;
	SudokuView* _tmp1_;
	SudokuView* _tmp2_;
	_tmp1_ = sudoku_get_view (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		_tmp0_ = self->priv->current_game_mode == GAME_MODE_PLAY;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuView* _tmp3_;
		SudokuView* _tmp4_;
		GSettings* _tmp5_;
		_tmp3_ = sudoku_get_view (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->settings;
		sudoku_view_set_show_warnings (_tmp4_, g_settings_get_boolean (_tmp5_, "show-warnings"));
	}
}

static void
___lambda29__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda29_ ((Sudoku*) self);
}

static void
__lambda30_ (Sudoku* self)
{
	SudokuView* _tmp0_;
	SudokuView* _tmp1_;
	_tmp0_ = sudoku_get_view (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		SudokuView* _tmp2_;
		SudokuView* _tmp3_;
		GSettings* _tmp4_;
		_tmp2_ = sudoku_get_view (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->settings;
		sudoku_view_set_highlighter (_tmp3_, g_settings_get_boolean (_tmp4_, "highlighter"));
	}
}

static void
___lambda30__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda30_ ((Sudoku*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sudoku_real_startup (GApplication* base)
{
	Sudoku * self;
	GSettings* _tmp0_;
	GAction* action = NULL;
	GSettings* _tmp1_;
	GAction* _tmp2_;
	GAction* _tmp3_;
	GAction* _tmp4_;
	GAction* highlighter_action = NULL;
	GSettings* _tmp5_;
	GAction* _tmp6_;
	GAction* _tmp7_;
	GAction* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GAction* _tmp30_;
	GSimpleAction* _tmp31_;
	GAction* _tmp32_;
	GSimpleAction* _tmp33_;
	GAction* _tmp34_;
	GSimpleAction* _tmp35_;
	GAction* _tmp36_;
	GSimpleAction* _tmp37_;
	GAction* _tmp38_;
	GSimpleAction* _tmp39_;
	GAction* _tmp40_;
	GSimpleAction* _tmp41_;
	GAction* _tmp42_;
	GSimpleAction* _tmp43_;
	GAction* _tmp44_;
	GSimpleAction* _tmp45_;
	GSettings* _tmp46_;
	SudokuWindow* _tmp47_;
	SudokuWindow* _tmp48_;
	SudokuSaver* _tmp49_;
	SudokuGame* savegame = NULL;
	SudokuSaver* _tmp50_;
	SudokuGame* _tmp51_;
	SudokuGame* _tmp52_;
	self = (Sudoku*) base;
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, (gint) G_N_ELEMENTS (SUDOKU_action_entries), self);
	_tmp0_ = g_settings_new ("org.gnome.Sudoku");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_create_action (_tmp1_, "show-warnings");
	action = _tmp2_;
	_tmp3_ = action;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::state", (GCallback) ___lambda29__g_object_notify, self, 0);
	_tmp4_ = action;
	g_action_map_add_action ((GActionMap*) self, _tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_create_action (_tmp5_, "highlighter");
	highlighter_action = _tmp6_;
	_tmp7_ = highlighter_action;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::state", (GCallback) ___lambda30__g_object_notify, self, 0);
	_tmp8_ = highlighter_action;
	g_action_map_add_action ((GActionMap*) self, _tmp8_);
	_tmp9_ = g_strdup ("<Primary>n");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("<Primary>p");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print", _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("<Primary>q");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = g_strdup ("<Primary>r");
	_tmp19_ = g_new0 (gchar*, 1 + 1);
	_tmp19_[0] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reset", _tmp20_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_tmp21_ = g_strdup ("<Primary>z");
	_tmp22_ = g_new0 (gchar*, 1 + 1);
	_tmp22_[0] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp23_);
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_tmp24_ = g_strdup ("<Primary><Shift>z");
	_tmp25_ = g_new0 (gchar*, 1 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp26_);
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
	_tmp27_ = g_strdup ("F1");
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp29__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp29_);
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
	_tmp30_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp31_;
	_tmp32_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->redo_action);
	self->priv->redo_action = _tmp33_;
	_tmp34_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp35_;
	_tmp36_ = g_action_map_lookup_action ((GActionMap*) self, "reset");
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->clear_action);
	self->priv->clear_action = _tmp37_;
	_tmp38_ = g_action_map_lookup_action ((GActionMap*) self, "print");
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->print_action);
	self->priv->print_action = _tmp39_;
	_tmp40_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->print_multiple_action);
	self->priv->print_multiple_action = _tmp41_;
	_tmp42_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp43_;
	_tmp44_ = g_action_map_lookup_action ((GActionMap*) self, "play-custom-game");
	_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->play_custom_game_action);
	self->priv->play_custom_game_action = _tmp45_;
	gtk_window_set_default_icon_name ("org.gnome.Sudoku");
	_tmp46_ = self->priv->settings;
	_tmp47_ = sudoku_window_new (_tmp46_);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp47_;
	_tmp48_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp48_);
	_tmp49_ = sudoku_saver_new ();
	_g_object_unref0 (self->priv->saver);
	self->priv->saver = _tmp49_;
	_tmp50_ = self->priv->saver;
	_tmp51_ = sudoku_saver_get_savedgame (_tmp50_);
	savegame = _tmp51_;
	_tmp52_ = savegame;
	if (_tmp52_ != NULL) {
		SudokuGame* _tmp53_;
		SudokuBoard* _tmp54_;
		DifficultyCategory _tmp55_;
		DifficultyCategory _tmp56_;
		SudokuGame* _tmp66_;
		SudokuBoard* _tmp67_;
		_tmp53_ = savegame;
		_tmp54_ = _tmp53_->board;
		_tmp55_ = sudoku_board_get_difficulty_category (_tmp54_);
		_tmp56_ = _tmp55_;
		if (_tmp56_ == DIFFICULTY_CATEGORY_CUSTOM) {
			GameMode _tmp57_ = 0;
			SudokuGame* _tmp58_;
			SudokuBoard* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			SudokuGame* _tmp62_;
			SudokuBoard* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			_tmp58_ = savegame;
			_tmp59_ = _tmp58_->board;
			_tmp60_ = sudoku_board_get_filled (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = savegame;
			_tmp63_ = _tmp62_->board;
			_tmp64_ = sudoku_board_get_fixed (_tmp63_);
			_tmp65_ = _tmp64_;
			if (_tmp61_ == _tmp65_) {
				_tmp57_ = GAME_MODE_CREATE;
			} else {
				_tmp57_ = GAME_MODE_PLAY;
			}
			self->priv->current_game_mode = _tmp57_;
		}
		_tmp66_ = savegame;
		_tmp67_ = _tmp66_->board;
		sudoku_start_game (self, _tmp67_);
	} else {
		sudoku_show_new_game_screen (self);
	}
	_g_object_unref0 (savegame);
	_g_object_unref0 (highlighter_action);
	_g_object_unref0 (action);
}

static void
sudoku_real_activate (GApplication* base)
{
	Sudoku * self;
	SudokuWindow* _tmp0_;
	self = (Sudoku*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}

static void
sudoku_real_shutdown (GApplication* base)
{
	Sudoku * self;
	SudokuGame* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (Sudoku*) base;
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		SudokuGame* _tmp2_;
		gboolean _tmp9_ = FALSE;
		SudokuGame* _tmp10_;
		_tmp2_ = self->priv->game;
		if (!sudoku_game_is_empty (_tmp2_)) {
			SudokuGame* _tmp3_;
			SudokuBoard* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp3_ = self->priv->game;
			_tmp4_ = _tmp3_->board;
			_tmp5_ = sudoku_board_get_complete (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp1_ = !_tmp6_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			SudokuSaver* _tmp7_;
			SudokuGame* _tmp8_;
			_tmp7_ = self->priv->saver;
			_tmp8_ = self->priv->game;
			sudoku_saver_save_game (_tmp7_, _tmp8_);
		}
		_tmp10_ = self->priv->game;
		if (sudoku_game_is_empty (_tmp10_)) {
			SudokuSaver* _tmp11_;
			SudokuGame* _tmp12_;
			SudokuGame* _tmp13_;
			_tmp11_ = self->priv->saver;
			_tmp12_ = sudoku_saver_get_savedgame (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp9_ = _tmp13_ != NULL;
			_g_object_unref0 (_tmp13_);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GFile* file = NULL;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			GFile* _tmp16_;
			_tmp14_ = sudoku_saver_get_savegame_file ();
			_tmp15_ = _tmp14_;
			_tmp16_ = g_file_new_for_path (_tmp15_);
			file = _tmp16_;
			{
				GFile* _tmp17_;
				_tmp17_ = file;
				g_file_delete (_tmp17_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp18_;
				const gchar* _tmp19_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp18_ = e;
				_tmp19_ = _tmp18_->message;
				g_warning ("gnome-sudoku.vala:187: Failed to delete saved game: %s", _tmp19_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (file);
		}
	}
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}

static void
sudoku_paused_changed_cb (Sudoku* self)
{
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SudokuWindow* _tmp15_;
	SudokuView* _tmp16_;
	SudokuView* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_;
		GSimpleAction* _tmp4_;
		GSimpleAction* _tmp5_;
		GSimpleAction* _tmp6_;
		_tmp3_ = self->priv->clear_action;
		g_simple_action_set_enabled (_tmp3_, FALSE);
		_tmp4_ = self->priv->undo_action;
		g_simple_action_set_enabled (_tmp4_, FALSE);
		_tmp5_ = self->priv->redo_action;
		g_simple_action_set_enabled (_tmp5_, FALSE);
		_tmp6_ = self->priv->new_game_action;
		g_simple_action_set_enabled (_tmp6_, FALSE);
	} else {
		SudokuGame* _tmp7_;
		_tmp7_ = self->priv->game;
		if (sudoku_game_get_total_time_played (_tmp7_) > ((gdouble) 0)) {
			GSimpleAction* _tmp8_;
			SudokuGame* _tmp9_;
			GSimpleAction* _tmp10_;
			SudokuGame* _tmp11_;
			GSimpleAction* _tmp12_;
			SudokuGame* _tmp13_;
			GSimpleAction* _tmp14_;
			_tmp8_ = self->priv->clear_action;
			_tmp9_ = self->priv->game;
			g_simple_action_set_enabled (_tmp8_, !sudoku_game_is_empty (_tmp9_));
			_tmp10_ = self->priv->undo_action;
			_tmp11_ = self->priv->game;
			g_simple_action_set_enabled (_tmp10_, !sudoku_game_is_undostack_null (_tmp11_));
			_tmp12_ = self->priv->redo_action;
			_tmp13_ = self->priv->game;
			g_simple_action_set_enabled (_tmp12_, !sudoku_game_is_redostack_null (_tmp13_));
			_tmp14_ = self->priv->new_game_action;
			g_simple_action_set_enabled (_tmp14_, TRUE);
		}
	}
	_tmp15_ = self->priv->window;
	sudoku_window_display_pause_button (_tmp15_);
	_tmp16_ = sudoku_get_view (self);
	_tmp17_ = _tmp16_;
	gtk_widget_queue_draw ((GtkWidget*) _tmp17_);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Sudoku* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
____lambda21_ (Block1Data* _data1_)
{
	Sudoku* self;
	GtkMessageDialog* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
_____lambda21__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	____lambda21_ (self);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Sudoku* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
____lambda22_ (Block2Data* _data2_,
               gint response_id)
{
	Sudoku* self;
	GtkMessageDialog* _tmp2_;
	self = _data2_->self;
	if (response_id == ((gint) GTK_RESPONSE_ACCEPT)) {
		SudokuGame* _tmp0_;
		SudokuBoard* _tmp1_;
		_tmp0_ = self->priv->game;
		_tmp1_ = _tmp0_->board;
		sudoku_start_custom_game (self, _tmp1_);
	}
	_tmp2_ = _data2_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
}

static void
_____lambda22__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	____lambda22_ (self, response_id);
}

static void
sudoku_play_custom_game_cb (Sudoku* self)
{
	gint solutions = 0;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	solutions = sudoku_board_count_solutions_limited (_tmp1_);
	if (solutions == 1) {
		SudokuGame* _tmp2_;
		SudokuBoard* _tmp3_;
		_tmp2_ = self->priv->game;
		_tmp3_ = _tmp2_->board;
		sudoku_start_custom_game (self, _tmp3_);
	} else {
		if (solutions == 0) {
			Block1Data* _data1_;
			gchar* error_str = NULL;
			gchar* _tmp4_;
			SudokuWindow* _tmp5_;
			const gchar* _tmp6_;
			GtkMessageDialog* _tmp7_;
			GtkMessageDialog* _tmp8_;
			GtkMessageDialog* _tmp9_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_tmp4_ = g_strdup_printf ("%s\n%s", _ ("The puzzle you have entered is not a valid Sudoku."), _ ("Please enter a valid puzzle."));
			error_str = _tmp4_;
			_tmp5_ = self->priv->window;
			_tmp6_ = error_str;
			_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp5_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp6_);
			g_object_ref_sink (_tmp7_);
			_data1_->dialog = _tmp7_;
			_tmp8_ = _data1_->dialog;
			g_signal_connect_data ((GtkDialog*) _tmp8_, "response", (GCallback) _____lambda21__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
			_tmp9_ = _data1_->dialog;
			gtk_widget_show ((GtkWidget*) _tmp9_);
			_g_free0 (error_str);
			block1_data_unref (_data1_);
			_data1_ = NULL;
		} else {
			Block2Data* _data2_;
			gchar* warning_str = NULL;
			gchar* _tmp10_;
			SudokuWindow* _tmp11_;
			const gchar* _tmp12_;
			GtkMessageDialog* _tmp13_;
			GtkMessageDialog* _tmp14_;
			GtkMessageDialog* _tmp15_;
			GtkMessageDialog* _tmp16_;
			GtkMessageDialog* _tmp17_;
			_data2_ = g_slice_new0 (Block2Data);
			_data2_->_ref_count_ = 1;
			_data2_->self = g_object_ref (self);
			_tmp10_ = g_strdup_printf ("%s\n%s", _ ("The puzzle you have entered has multiple solutions."), _ ("Valid Sudoku puzzles have exactly one solution."));
			warning_str = _tmp10_;
			_tmp11_ = self->priv->window;
			_tmp12_ = warning_str;
			_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp11_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp12_);
			g_object_ref_sink (_tmp13_);
			_data2_->dialog = _tmp13_;
			_tmp14_ = _data2_->dialog;
			gtk_dialog_add_button ((GtkDialog*) _tmp14_, _ ("_Back"), (gint) GTK_RESPONSE_REJECT);
			_tmp15_ = _data2_->dialog;
			gtk_dialog_add_button ((GtkDialog*) _tmp15_, _ ("Play _Anyway"), (gint) GTK_RESPONSE_ACCEPT);
			_tmp16_ = _data2_->dialog;
			g_signal_connect_data ((GtkDialog*) _tmp16_, "response", (GCallback) _____lambda22__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
			_tmp17_ = _data2_->dialog;
			gtk_widget_show ((GtkWidget*) _tmp17_);
			_g_free0 (warning_str);
			block2_data_unref (_data2_);
			_data2_ = NULL;
		}
	}
}

static void
sudoku_toggle_pause_cb (Sudoku* self)
{
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		SudokuGame* _tmp3_;
		_tmp3_ = self->priv->game;
		sudoku_game_resume_clock (_tmp3_);
	} else {
		SudokuGame* _tmp4_;
		_tmp4_ = self->priv->game;
		sudoku_game_stop_clock (_tmp4_);
	}
}

static void
sudoku_cell_changed_cb (Sudoku* self)
{
	GSimpleAction* _tmp0_;
	SudokuGame* _tmp1_;
	GSimpleAction* _tmp2_;
	SudokuGame* _tmp3_;
	GSimpleAction* _tmp4_;
	SudokuGame* _tmp5_;
	gboolean _tmp6_ = FALSE;
	SudokuGame* _tmp7_;
	GSimpleAction* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_action;
	_tmp1_ = self->priv->game;
	g_simple_action_set_enabled (_tmp0_, !sudoku_game_is_undostack_null (_tmp1_));
	_tmp2_ = self->priv->redo_action;
	_tmp3_ = self->priv->game;
	g_simple_action_set_enabled (_tmp2_, !sudoku_game_is_redostack_null (_tmp3_));
	_tmp4_ = self->priv->clear_action;
	_tmp5_ = self->priv->game;
	g_simple_action_set_enabled (_tmp4_, !sudoku_game_is_empty (_tmp5_));
	_tmp7_ = self->priv->game;
	if (!sudoku_game_is_empty (_tmp7_)) {
		SudokuGame* _tmp8_;
		SudokuBoard* _tmp9_;
		_tmp8_ = self->priv->game;
		_tmp9_ = _tmp8_->board;
		_tmp6_ = !sudoku_board_is_fully_filled (_tmp9_);
	} else {
		_tmp6_ = FALSE;
	}
	_tmp10_ = self->priv->play_custom_game_action;
	g_simple_action_set_enabled (_tmp10_, _tmp6_);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Sudoku* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda18_ (Block3Data* _data3_,
             gint response_id)
{
	Sudoku* self;
	self = _data3_->self;
	if (response_id == ((gint) GTK_RESPONSE_ACCEPT)) {
		sudoku_show_new_game_screen (self);
	} else {
		if (response_id == ((gint) GTK_RESPONSE_REJECT)) {
			g_application_quit ((GApplication*) self);
		}
	}
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
}

static void
___lambda18__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda18_ (self, response_id);
}

static void
sudoku_board_completed_cb (Sudoku* self)
{
	Block3Data* _data3_;
	SudokuWindow* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuSaver* _tmp16_;
	SudokuGame* _tmp17_;
	gint minutes = 0;
	SudokuGame* _tmp18_;
	gchar* time_str = NULL;
	gchar* _tmp19_;
	SudokuWindow* _tmp20_;
	GtkMessageDialog* _tmp21_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->window;
	sudoku_window_board_completed (_tmp0_);
	_tmp1_ = self->priv->game;
	sudoku_game_stop_clock (_tmp1_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp4_;
				SudokuBoard* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->game;
				_tmp5_ = _tmp4_->board;
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp10_;
							SudokuBoard* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							SudokuView* _tmp14_;
							SudokuView* _tmp15_;
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = j;
								j = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp10_ = self->priv->game;
							_tmp11_ = _tmp10_->board;
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(j < _tmp13_)) {
								break;
							}
							_tmp14_ = sudoku_get_view (self);
							_tmp15_ = _tmp14_;
							gtk_widget_set_can_focus ((GtkWidget*) _tmp15_, FALSE);
						}
					}
				}
			}
		}
	}
	_tmp16_ = self->priv->saver;
	_tmp17_ = self->priv->game;
	sudoku_saver_add_game_to_finished (_tmp16_, _tmp17_, TRUE);
	_tmp18_ = self->priv->game;
	minutes = MAX (1, ((gint) sudoku_game_get_total_time_played (_tmp18_)) / 60);
	_tmp19_ = g_strdup_printf (ngettext ("Well done, you completed the puzzle in %d minute!", "Well done, you completed the puzzle in %d minutes!", (gulong) minutes), minutes);
	time_str = _tmp19_;
	_tmp20_ = self->priv->window;
	_tmp21_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp20_, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, "%s", time_str);
	g_object_ref_sink (_tmp21_);
	_data3_->dialog = _tmp21_;
	gtk_dialog_add_button ((GtkDialog*) _data3_->dialog, _ ("_Quit"), (gint) GTK_RESPONSE_REJECT);
	gtk_dialog_add_button ((GtkDialog*) _data3_->dialog, _ ("Play _Again"), (gint) GTK_RESPONSE_ACCEPT);
	g_signal_connect_data ((GtkDialog*) _data3_->dialog, "response", (GCallback) ___lambda18__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data3_->dialog);
	_g_free0 (time_str);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
sudoku_start_custom_game (Sudoku* self,
                          SudokuBoard* board)
{
	SudokuGame* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	self->priv->current_game_mode = GAME_MODE_PLAY;
	_tmp0_ = self->priv->game;
	sudoku_game_stop_clock (_tmp0_);
	sudoku_start_game (self, board);
}

static void
_sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender,
                                                      gpointer self)
{
	sudoku_paused_changed_cb ((Sudoku*) self);
}

static void
_sudoku_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender,
                                                  gint row,
                                                  gint col,
                                                  gint old_val,
                                                  gint new_val,
                                                  gpointer self)
{
	sudoku_cell_changed_cb ((Sudoku*) self);
}

static void
_sudoku_board_completed_cb_sudoku_board_completed (SudokuBoard* _sender,
                                                   gpointer self)
{
	sudoku_board_completed_cb ((Sudoku*) self);
}

static void
sudoku_start_game (Sudoku* self,
                   SudokuBoard* board)
{
	SudokuGame* _tmp0_;
	SudokuGame* _tmp8_;
	SudokuGame* _tmp9_;
	SudokuGame* _tmp10_;
	SudokuGame* _tmp11_;
	SudokuWindow* _tmp12_;
	SudokuGame* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GSimpleAction* _tmp18_;
	SudokuGame* _tmp19_;
	GSimpleAction* _tmp20_;
	SudokuGame* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		SudokuGame* _tmp1_;
		guint _tmp2_;
		SudokuGame* _tmp3_;
		guint _tmp4_;
		SudokuGame* _tmp5_;
		SudokuBoard* _tmp6_;
		guint _tmp7_;
		_tmp1_ = self->priv->game;
		g_signal_parse_name ("paused-changed", TYPE_SUDOKU_GAME, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _sudoku_paused_changed_cb_sudoku_game_paused_changed, self);
		_tmp3_ = self->priv->game;
		g_signal_parse_name ("cell-changed", TYPE_SUDOKU_GAME, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _sudoku_cell_changed_cb_sudoku_game_cell_changed, self);
		_tmp5_ = self->priv->game;
		_tmp6_ = _tmp5_->board;
		g_signal_parse_name ("completed", TYPE_SUDOKU_BOARD, &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _sudoku_board_completed_cb_sudoku_board_completed, self);
	}
	_tmp8_ = sudoku_game_new (board);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp8_;
	_tmp9_ = self->priv->game;
	_tmp9_->mode = self->priv->current_game_mode;
	_tmp10_ = self->priv->game;
	g_signal_connect_object (_tmp10_, "paused-changed", (GCallback) _sudoku_paused_changed_cb_sudoku_game_paused_changed, self, 0);
	_tmp11_ = self->priv->game;
	g_signal_connect_object (_tmp11_, "cell-changed", (GCallback) _sudoku_cell_changed_cb_sudoku_game_cell_changed, self, 0);
	_tmp12_ = self->priv->window;
	_tmp13_ = self->priv->game;
	sudoku_window_start_game (_tmp12_, _tmp13_, self->priv->show_possibilities);
	_tmp14_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp14_, TRUE);
	_tmp15_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp15_, FALSE);
	_tmp16_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp16_, FALSE);
	_tmp17_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp17_, TRUE);
	_tmp18_ = self->priv->clear_action;
	_tmp19_ = self->priv->game;
	g_simple_action_set_enabled (_tmp18_, !sudoku_game_is_empty (_tmp19_));
	_tmp20_ = self->priv->play_custom_game_action;
	_tmp21_ = self->priv->game;
	g_simple_action_set_enabled (_tmp20_, !sudoku_game_is_empty (_tmp21_));
	if (self->priv->current_game_mode != GAME_MODE_CREATE) {
		SudokuGame* _tmp22_;
		SudokuBoard* _tmp23_;
		_tmp22_ = self->priv->game;
		_tmp23_ = _tmp22_->board;
		g_signal_connect_object (_tmp23_, "completed", (GCallback) _sudoku_board_completed_cb_sudoku_board_completed, self, 0);
	}
}

static void
sudoku_show_new_game_screen (Sudoku* self)
{
	GSimpleAction* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->game;
	if (_tmp1_ != NULL) {
		SudokuGame* _tmp2_;
		_tmp2_ = self->priv->game;
		sudoku_game_stop_clock (_tmp2_);
	}
	_tmp3_ = self->priv->window;
	sudoku_window_show_new_game_screen (_tmp3_);
}

static void
sudoku_new_game_cb (Sudoku* self)
{
	g_return_if_fail (self != NULL);
	sudoku_show_new_game_screen (self);
}

static void
__lambda19_ (Sudoku* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GeeList* gen_boards = NULL;
		GeeList* _tmp0_;
		gpointer _tmp1_;
		SudokuBoard* _tmp2_;
		_tmp0_ = sudoku_generator_generate_boards_finish (res, &_inner_error0_);
		gen_boards = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = gee_list_get (gen_boards, 0);
		_tmp2_ = (SudokuBoard*) _tmp1_;
		sudoku_start_game (self, _tmp2_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (gen_boards);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e->message;
		g_error ("gnome-sudoku.vala:359: Error: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda19__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda19_ ((Sudoku*) self, source_object, res);
	g_object_unref (self);
}

static void
sudoku_create_game_cb (Sudoku* self)
{
	g_return_if_fail (self != NULL);
	self->priv->current_game_mode = GAME_MODE_CREATE;
	sudoku_generator_generate_boards_async (1, DIFFICULTY_CATEGORY_CUSTOM, NULL, ___lambda19__gasync_ready_callback, g_object_ref (self));
}

static void
__lambda17_ (Sudoku* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GeeList* gen_boards = NULL;
		GeeList* _tmp0_;
		gpointer _tmp1_;
		SudokuBoard* _tmp2_;
		_tmp0_ = sudoku_generator_generate_boards_finish (res, &_inner_error0_);
		gen_boards = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = gee_list_get (gen_boards, 0);
		_tmp2_ = (SudokuBoard*) _tmp1_;
		sudoku_start_game (self, _tmp2_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (gen_boards);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e->message;
		g_error ("gnome-sudoku.vala:383: Error: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda17__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda17_ ((Sudoku*) self, source_object, res);
	g_object_unref (self);
}

static void
sudoku_start_game_cb (Sudoku* self,
                      GSimpleAction* action,
                      GVariant* difficulty)
{
	SudokuWindow* _tmp0_;
	DifficultyCategory selected_difficulty = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->window;
	sudoku_window_will_start_game (_tmp0_);
	self->priv->current_game_mode = GAME_MODE_PLAY;
	selected_difficulty = (DifficultyCategory) g_variant_get_int32 (difficulty);
	sudoku_generator_generate_boards_async (1, selected_difficulty, NULL, ___lambda17__gasync_ready_callback, g_object_ref (self));
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Sudoku* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda20_ (Block4Data* _data4_,
             gint response_id)
{
	Sudoku* self;
	self = _data4_->self;
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
		SudokuGame* _tmp0_;
		SudokuView* _tmp1_;
		SudokuView* _tmp2_;
		GSimpleAction* _tmp3_;
		GSimpleAction* _tmp4_;
		_tmp0_ = self->priv->game;
		sudoku_game_reset (_tmp0_);
		_tmp1_ = sudoku_get_view (self);
		_tmp2_ = _tmp1_;
		sudoku_view_clear (_tmp2_);
		_tmp3_ = self->priv->undo_action;
		g_simple_action_set_enabled (_tmp3_, FALSE);
		_tmp4_ = self->priv->redo_action;
		g_simple_action_set_enabled (_tmp4_, FALSE);
	}
	gtk_widget_destroy ((GtkWidget*) _data4_->dialog);
}

static void
___lambda20__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda20_ (self, response_id);
}

static void
sudoku_reset_cb (Sudoku* self)
{
	Block4Data* _data4_;
	SudokuWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->window;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL, "%s", _ ("Reset the board to its original state?"));
	g_object_ref_sink (_tmp1_);
	_data4_->dialog = _tmp1_;
	g_signal_connect_data ((GtkDialog*) _data4_->dialog, "response", (GCallback) ___lambda20__gtk_dialog_response, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data4_->dialog);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
sudoku_back_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	GSimpleAction* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	sudoku_window_show_game_view (_tmp0_);
	_tmp1_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
}

static void
sudoku_undo_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	SudokuGame* _tmp1_;
	GSimpleAction* _tmp2_;
	SudokuGame* _tmp3_;
	SudokuView* _tmp4_;
	SudokuView* _tmp5_;
	SudokuView* _tmp6_;
	SudokuView* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (!sudoku_window_is_board_visible (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->game;
	sudoku_game_undo (_tmp1_);
	_tmp2_ = self->priv->undo_action;
	_tmp3_ = self->priv->game;
	g_simple_action_set_enabled (_tmp2_, !sudoku_game_is_undostack_null (_tmp3_));
	_tmp4_ = sudoku_get_view (self);
	_tmp5_ = _tmp4_;
	sudoku_view_hide_popovers (_tmp5_);
	_tmp6_ = sudoku_get_view (self);
	_tmp7_ = _tmp6_;
	gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
}

static void
sudoku_redo_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	SudokuGame* _tmp1_;
	GSimpleAction* _tmp2_;
	SudokuGame* _tmp3_;
	SudokuView* _tmp4_;
	SudokuView* _tmp5_;
	SudokuView* _tmp6_;
	SudokuView* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (!sudoku_window_is_board_visible (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->game;
	sudoku_game_redo (_tmp1_);
	_tmp2_ = self->priv->redo_action;
	_tmp3_ = self->priv->game;
	g_simple_action_set_enabled (_tmp2_, !sudoku_game_is_redostack_null (_tmp3_));
	_tmp4_ = sudoku_get_view (self);
	_tmp5_ = _tmp4_;
	sudoku_view_hide_popovers (_tmp5_);
	_tmp6_ = sudoku_get_view (self);
	_tmp7_ = _tmp6_;
	gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
}

static void
sudoku_print_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	SudokuGame* _tmp5_;
	SudokuBoard* _tmp6_;
	SudokuBoard* _tmp7_;
	SudokuBoard* _tmp8_;
	SudokuPrinter* printer = NULL;
	GeeArrayList* _tmp9_;
	SudokuWindow* _tmp10_;
	SudokuPrinter* _tmp11_;
	SudokuPrinter* _tmp12_;
	GSimpleAction* _tmp13_;
	GSimpleAction* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (!sudoku_window_is_board_visible (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp3_;
	_tmp4_ = list;
	_tmp5_ = self->priv->game;
	_tmp6_ = _tmp5_->board;
	_tmp7_ = sudoku_board_clone (_tmp6_);
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = list;
	_tmp10_ = self->priv->window;
	_tmp11_ = sudoku_printer_new ((GeeList*) _tmp9_, 1, (GtkWindow*) _tmp10_);
	printer = _tmp11_;
	_tmp12_ = printer;
	sudoku_printer_print_sudoku (_tmp12_);
	_tmp13_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp13_, TRUE);
	_tmp14_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp14_, TRUE);
	_g_object_unref0 (printer);
	_g_object_unref0 (list);
}

static void
__lambda27_ (Sudoku* self)
{
	GSimpleAction* _tmp0_;
	SudokuWindow* _tmp1_;
	GSimpleAction* _tmp2_;
	_tmp0_ = self->priv->print_action;
	_tmp1_ = self->priv->window;
	g_simple_action_set_enabled (_tmp0_, sudoku_window_is_board_visible (_tmp1_));
	_tmp2_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp2_, TRUE);
}

static void
___lambda27__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda27_ ((Sudoku*) self);
}

static void
sudoku_print_multiple_cb (Sudoku* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	PrintDialog* print_dialog = NULL;
	SudokuSaver* _tmp2_;
	SudokuWindow* _tmp3_;
	PrintDialog* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->saver;
	_tmp3_ = self->priv->window;
	_tmp4_ = print_dialog_new (_tmp2_, (GtkWindow*) _tmp3_);
	g_object_ref_sink (_tmp4_);
	print_dialog = _tmp4_;
	g_signal_connect_object ((GtkDialog*) print_dialog, "response", (GCallback) ___lambda27__gtk_dialog_response, self, 0);
	gtk_widget_show ((GtkWidget*) print_dialog);
	_g_object_unref0 (print_dialog);
}

static void
sudoku_help_cb (Sudoku* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		SudokuWindow* _tmp0_;
		_tmp0_ = self->priv->window;
		gtk_show_uri_on_window ((GtkWindow*) _tmp0_, "help:gnome-sudoku", gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("gnome-sudoku.vala:471: Unable to open help: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
sudoku_about_cb (Sudoku* self)
{
	gchar* localized_comments_format = NULL;
	gchar* _tmp0_;
	SudokuWindow* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("The popular Japanese logic puzzle\n\nPuzzles generated by QQwing %s"));
	localized_comments_format = _tmp0_;
	_tmp1_ = self->priv->window;
	_tmp2_ = sudoku_generator_qqwing_version ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (localized_comments_format, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_show_about_dialog ((GtkWindow*) _tmp1_, "program-name", _ ("Sudoku"), "logo-icon-name", "org.gnome.Sudoku", "version", VERSION, "comments", _tmp5_, "copyright", "Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha", "license-type", GTK_LICENSE_GPL_3_0, "authors", SUDOKU_authors, "artists", NULL, "translator-credits", _ ("translator-credits"), "website", "https://wiki.gnome.org/Apps/Sudoku/", NULL);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (localized_comments_format);
}

static gint
sudoku_main (gchar** args,
             gint args_length1)
{
	Sudoku* _tmp0_;
	Sudoku* _tmp1_;
	gint _tmp2_;
	gint result;
	_tmp0_ = sudoku_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return sudoku_main (argv, argc);
}

static SudokuView*
sudoku_get_view (Sudoku* self)
{
	SudokuView* result;
	SudokuWindow* _tmp0_;
	SudokuView* _tmp1_;
	SudokuView* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = sudoku_window_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
sudoku_class_init (SudokuClass * klass,
                   gpointer klass_data)
{
	sudoku_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Sudoku_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) sudoku_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) sudoku_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) sudoku_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) sudoku_real_shutdown;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_get_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
}

static void
sudoku_instance_init (Sudoku * self,
                      gpointer klass)
{
	self->priv = sudoku_get_instance_private (self);
	self->priv->game = NULL;
	self->priv->show_possibilities = FALSE;
	self->priv->current_game_mode = GAME_MODE_PLAY;
}

static void
sudoku_finalize (GObject * obj)
{
	Sudoku * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->redo_action);
	_g_object_unref0 (self->priv->clear_action);
	_g_object_unref0 (self->priv->print_action);
	_g_object_unref0 (self->priv->print_multiple_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->play_custom_game_action);
	_g_object_unref0 (self->priv->new_game_action);
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
}

static GType
sudoku_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
	GType sudoku_type_id;
	sudoku_type_id = g_type_register_static (gtk_application_get_type (), "Sudoku", &g_define_type_info, 0);
	Sudoku_private_offset = g_type_add_instance_private (sudoku_type_id, sizeof (SudokuPrivate));
	return sudoku_type_id;
}

GType
sudoku_get_type (void)
{
	static volatile gsize sudoku_type_id__once = 0;
	if (g_once_init_enter (&sudoku_type_id__once)) {
		GType sudoku_type_id;
		sudoku_type_id = sudoku_get_type_once ();
		g_once_init_leave (&sudoku_type_id__once, sudoku_type_id);
	}
	return sudoku_type_id__once;
}

static void
_vala_sudoku_get_property (GObject * object,
                           guint property_id,
                           GValue * value,
                           GParamSpec * pspec)
{
	Sudoku * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU, Sudoku);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

