/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import sun.misc.CEFormatException;
import sun.misc.CEStreamExhausted;
import sun.misc.CRC16;
import sun.misc.CharacterDecoder;

public class UCDecoder
extends CharacterDecoder {
    private static final byte[] map_array = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 40, 41};
    private int sequence;
    private byte[] tmp = new byte[2];
    private CRC16 crc = new CRC16();
    private ByteArrayOutputStream lineAndSeq = new ByteArrayOutputStream(2);

    @Override
    protected int bytesPerAtom() {
        return 2;
    }

    @Override
    protected int bytesPerLine() {
        return 48;
    }

    @Override
    protected void decodeAtom(PushbackInputStream inStream, OutputStream outStream, int l) throws IOException {
        int a = -1;
        int b = -1;
        int c = -1;
        byte[] tmp = new byte[3];
        int i = inStream.read(tmp);
        if (i != 3) {
            throw new CEStreamExhausted();
        }
        for (i = 0; i < 64 && (a == -1 || b == -1 || c == -1); ++i) {
            if (tmp[0] == map_array[i]) {
                a = (byte)i;
            }
            if (tmp[1] == map_array[i]) {
                b = (byte)i;
            }
            if (tmp[2] != map_array[i]) continue;
            c = (byte)i;
        }
        byte high_byte = (byte)(((a & 0x38) << 2) + (b & 0x1F));
        byte low_byte = (byte)(((a & 7) << 5) + (c & 0x1F));
        int p1 = 0;
        int p2 = 0;
        for (i = 1; i < 256; i *= 2) {
            if ((high_byte & i) != 0) {
                ++p1;
            }
            if ((low_byte & i) == 0) continue;
            ++p2;
        }
        int np1 = (b & 0x20) / 32;
        int np2 = (c & 0x20) / 32;
        if ((p1 & 1) != np1) {
            throw new CEFormatException("UCDecoder: High byte parity error.");
        }
        if ((p2 & 1) != np2) {
            throw new CEFormatException("UCDecoder: Low byte parity error.");
        }
        outStream.write(high_byte);
        this.crc.update(high_byte);
        if (l == 2) {
            outStream.write(low_byte);
            this.crc.update(low_byte);
        }
    }

    @Override
    protected void decodeBufferPrefix(PushbackInputStream inStream, OutputStream outStream) {
        this.sequence = 0;
    }

    @Override
    protected int decodeLinePrefix(PushbackInputStream inStream, OutputStream outStream) throws IOException {
        this.crc.value = 0;
        do {
            int c;
            if ((c = inStream.read(this.tmp, 0, 1)) != -1) continue;
            throw new CEStreamExhausted();
        } while (this.tmp[0] != 42);
        this.lineAndSeq.reset();
        this.decodeAtom(inStream, this.lineAndSeq, 2);
        byte[] xtmp = this.lineAndSeq.toByteArray();
        int nLen = xtmp[0] & 0xFF;
        int nSeq = xtmp[1] & 0xFF;
        if (nSeq != this.sequence) {
            throw new CEFormatException("UCDecoder: Out of sequence line.");
        }
        this.sequence = this.sequence + 1 & 0xFF;
        return nLen;
    }

    @Override
    protected void decodeLineSuffix(PushbackInputStream inStream, OutputStream outStream) throws IOException {
        int lineCRC = this.crc.value;
        this.lineAndSeq.reset();
        this.decodeAtom(inStream, this.lineAndSeq, 2);
        byte[] tmp = this.lineAndSeq.toByteArray();
        int readCRC = (tmp[0] << 8 & 0xFF00) + (tmp[1] & 0xFF);
        if (readCRC != lineCRC) {
            throw new CEFormatException("UCDecoder: CRC check failed.");
        }
    }
}

