/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * Copyright (C) 2017 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebPreferences.h"

#include "WebPreferencesDefinitions.h"
#include "WebPreferencesKeys.h"
#include <wtf/ExperimentalFeatureNames.h>

namespace WebKit {

const Vector<RefPtr<API::Object>>& WebPreferences::experimentalFeatures()
{
    static NeverDestroyed<Vector<RefPtr<API::Object>>> features(std::initializer_list<RefPtr<API::Object>> {
        API::ExperimentalFeature::create(":dir pseudo-class"""_s, "DirPseudoEnabled"_s, "Enable the directionality pseudo-class :dir"""_s, DEFAULT_VALUE_FOR_DirPseudoEnabled, false),
        API::ExperimentalFeature::create(":focus-visible pseudo-class"""_s, "FocusVisibleEnabled"_s, "Enable the focus-indicated pseudo-class :focus-visible"""_s, DEFAULT_VALUE_FOR_FocusVisibleEnabled, false),
        API::ExperimentalFeature::create(":has() pseudo-class"""_s, "HasPseudoClassEnabled"_s, "Enable :has() pseudo-class"""_s, DEFAULT_VALUE_FOR_HasPseudoClassEnabled, false),
        API::ExperimentalFeature::create("@page CSS at-rule support"""_s, "PageAtRuleSupportEnabled"_s, "Enable @page support"""_s, DEFAULT_VALUE_FOR_PageAtRuleSupportEnabled, false),
        API::ExperimentalFeature::create("ARIA Reflection for Element References"""_s, "AriaReflectionForElementReferencesEnabled"_s, "Enable ARIA reflection for attributes that refer to elements"""_s, DEFAULT_VALUE_FOR_AriaReflectionForElementReferencesEnabled, false),
        API::ExperimentalFeature::create("AccessHandle API"""_s, "AccessHandleEnabled"_s, "Enable AccessHandle API"""_s, DEFAULT_VALUE_FOR_AccessHandleEnabled, false),
        API::ExperimentalFeature::create("Accessibility Object Model"""_s, "AccessibilityObjectModelEnabled"_s, "Accessibility Object Model support"""_s, DEFAULT_VALUE_FOR_AccessibilityObjectModelEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::ExperimentalFeature::create("Allow per media element speaker device selection"""_s, "PerElementSpeakerSelectionEnabled"_s, "Allow per media element speaker device selection"""_s, DEFAULT_VALUE_FOR_PerElementSpeakerSelectionEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::ExperimentalFeature::create("Allow speaker device selection"""_s, "ExposeSpeakersEnabled"_s, "Allow speaker device selection"""_s, DEFAULT_VALUE_FOR_ExposeSpeakersEnabled, false),
#endif
        API::ExperimentalFeature::create("Aspect ratio of <img> from width and height"""_s, "AspectRatioOfImgFromWidthAndHeightEnabled"_s, "Map HTML attributes width/height to the default aspect ratio of <img>"""_s, DEFAULT_VALUE_FOR_AspectRatioOfImgFromWidthAndHeightEnabled, false),
        API::ExperimentalFeature::create("Async clipboard API"""_s, "AsyncClipboardAPIEnabled"_s, "Enable the async clipboard API"""_s, DEFAULT_VALUE_FOR_AsyncClipboardAPIEnabled, false),
        API::ExperimentalFeature::create("Blank anchor target implies rel=noopener"""_s, "BlankAnchorTargetImpliesNoOpenerEnabled"_s, "target=_blank on anchor elements implies rel=noopener"""_s, DEFAULT_VALUE_FOR_BlankAnchorTargetImpliesNoOpenerEnabled, false),
        API::ExperimentalFeature::create("Block top-level redirects by third-party iframes"""_s, "ThirdPartyIframeRedirectBlockingEnabled"_s, "Block top-level redirects by third-party iframes"""_s, DEFAULT_VALUE_FOR_ThirdPartyIframeRedirectBlockingEnabled, false),
        API::ExperimentalFeature::create("BroadcastChannel API"""_s, "BroadcastChannelEnabled"_s, "BroadcastChannel API"""_s, DEFAULT_VALUE_FOR_BroadcastChannelEnabled, false),
        API::ExperimentalFeature::create("BroadcastChannel Origin Partitioning"""_s, "BroadcastChannelOriginPartitioningEnabled"_s, "BroadcastChannel Origin Partitioning"""_s, DEFAULT_VALUE_FOR_BroadcastChannelOriginPartitioningEnabled, false),
#if ENABLE(BUILT_IN_NOTIFICATIONS)
        API::ExperimentalFeature::create("Built-In Web Notifications"""_s, "BuiltInNotificationsEnabled"_s, "Enable built-in WebKit managed notifications"""_s, DEFAULT_VALUE_FOR_BuiltInNotificationsEnabled, false),
#endif
        API::ExperimentalFeature::create("CSS 3D Transform Interoperability"""_s, "CSS3DTransformInteroperabilityEnabled"_s, "Enable 3D transform behavior that is specification-compliant but backwards incompatible"""_s, DEFAULT_VALUE_FOR_CSS3DTransformInteroperabilityEnabled, false),
        API::ExperimentalFeature::create("CSS @counter-style <image> symbols"""_s, "CSSCounterStyleAtRuleImageSymbolsEnabled"_s, "Enable support for <image> symbols in CSS @counter-style rules"""_s, DEFAULT_VALUE_FOR_CSSCounterStyleAtRuleImageSymbolsEnabled, false),
        API::ExperimentalFeature::create("CSS @counter-style"""_s, "CSSCounterStyleAtRulesEnabled"_s, "Enable support for CSS @counter-style rules"""_s, DEFAULT_VALUE_FOR_CSSCounterStyleAtRulesEnabled, false),
        API::ExperimentalFeature::create("CSS Accent Color"""_s, "AccentColorEnabled"_s, "Enable accent-color CSS property"""_s, DEFAULT_VALUE_FOR_AccentColorEnabled, false),
        API::ExperimentalFeature::create("CSS Aspect Ratio"""_s, "AspectRatioEnabled"_s, "Enable aspect-ratio CSS property"""_s, DEFAULT_VALUE_FOR_AspectRatioEnabled, false),
        API::ExperimentalFeature::create("CSS Cascade Layers"""_s, "CSSCascadeLayersEnabled"_s, "Enable CSS Cascade Layers"""_s, DEFAULT_VALUE_FOR_CSSCascadeLayersEnabled, false),
        API::ExperimentalFeature::create("CSS Color 4 Color Types"""_s, "CSSColor4"_s, "Enable support for CSS Color 4 Color Types"""_s, DEFAULT_VALUE_FOR_CSSColor4, false),
        API::ExperimentalFeature::create("CSS Contain Intrinsic Size"""_s, "CSSContainIntrinsicSizeEnabled"_s, "Enable contain-intrinsic-size CSS property"""_s, DEFAULT_VALUE_FOR_CSSContainIntrinsicSizeEnabled, false),
        API::ExperimentalFeature::create("CSS Container Queries"""_s, "CSSContainerQueriesEnabled"_s, "Enable CSS Container Queries"""_s, DEFAULT_VALUE_FOR_CSSContainerQueriesEnabled, false),
        API::ExperimentalFeature::create("CSS Containment"""_s, "CSSContainmentEnabled"_s, "Enable contain CSS property"""_s, DEFAULT_VALUE_FOR_CSSContainmentEnabled, false),
        API::ExperimentalFeature::create("CSS Custom Properties and Values API"""_s, "CSSCustomPropertiesAndValuesEnabled"_s, "Enable CSS Custom Properties and Values API"""_s, DEFAULT_VALUE_FOR_CSSCustomPropertiesAndValuesEnabled, false),
        API::ExperimentalFeature::create("CSS Gradient Interpolation Color Spaces"""_s, "CSSGradientInterpolationColorSpacesEnabled"_s, "Enable custom interpolation in CSS gradients"""_s, DEFAULT_VALUE_FOR_CSSGradientInterpolationColorSpacesEnabled, false),
        API::ExperimentalFeature::create("CSS Gradient Premultiplied Alpha Interpolation"""_s, "CSSGradientPremultipliedAlphaInterpolationEnabled"_s, "Enable premultiplied alpha interpolated CSS gradients"""_s, DEFAULT_VALUE_FOR_CSSGradientPremultipliedAlphaInterpolationEnabled, false),
        API::ExperimentalFeature::create("CSS Individual Transform Properties"""_s, "CSSIndividualTransformPropertiesEnabled"_s, "Support for the translate, scale and rotate CSS properties"""_s, DEFAULT_VALUE_FOR_CSSIndividualTransformPropertiesEnabled, false),
        API::ExperimentalFeature::create("CSS Input Security"""_s, "CSSInputSecurityEnabled"_s, "Enable input-security CSS property"""_s, DEFAULT_VALUE_FOR_CSSInputSecurityEnabled, false),
        API::ExperimentalFeature::create("CSS Motion Path"""_s, "CSSMotionPathEnabled"_s, "Enable CSS Motion Path support"""_s, DEFAULT_VALUE_FOR_CSSMotionPathEnabled, false),
        API::ExperimentalFeature::create("CSS Overscroll Behavior"""_s, "OverscrollBehaviorEnabled"_s, "Enable CSS overscroll-behavior"""_s, DEFAULT_VALUE_FOR_OverscrollBehaviorEnabled, false),
#if ENABLE(CSS_PAINTING_API)
        API::ExperimentalFeature::create("CSS Painting API"""_s, "CSSPaintingAPIEnabled"_s, "Enable the CSS Painting API"""_s, DEFAULT_VALUE_FOR_CSSPaintingAPIEnabled, false),
#endif
        API::ExperimentalFeature::create("CSS Relative Color Syntax"""_s, "CSSRelativeColorSyntaxEnabled"_s, "Enable support for CSS Relative Color Syntax defined in CSS Color 5"""_s, DEFAULT_VALUE_FOR_CSSRelativeColorSyntaxEnabled, false),
        API::ExperimentalFeature::create("CSS Scroll Anchoring"""_s, "CSSScrollAnchoringEnabled"_s, "Enable CSS Scroll Anchoring"""_s, DEFAULT_VALUE_FOR_CSSScrollAnchoringEnabled, false),
        API::ExperimentalFeature::create("CSS Spring Animations"""_s, "SpringTimingFunctionEnabled"_s, "CSS Spring Animation prototype"""_s, DEFAULT_VALUE_FOR_SpringTimingFunctionEnabled, false),
#if ENABLE(CSS_TYPED_OM)
        API::ExperimentalFeature::create("CSS Typed OM"""_s, "CSSTypedOMEnabled"_s, "Enable the CSS Typed OM"""_s, DEFAULT_VALUE_FOR_CSSTypedOMEnabled, false),
#endif
        API::ExperimentalFeature::create("CSS color-contrast()"""_s, "CSSColorContrastEnabled"_s, "Enable support for CSS color-contrast() defined in CSS Color 5"""_s, DEFAULT_VALUE_FOR_CSSColorContrastEnabled, false),
        API::ExperimentalFeature::create("CSS color-mix()"""_s, "CSSColorMixEnabled"_s, "Enable support for CSS color-mix() defined in CSS Color 5"""_s, DEFAULT_VALUE_FOR_CSSColorMixEnabled, false),
        API::ExperimentalFeature::create("CSS overflow: clip support"""_s, "OverflowClipEnabled"_s, "Enable CSS overflow: clip support"""_s, DEFAULT_VALUE_FOR_OverflowClipEnabled, false),
        API::ExperimentalFeature::create("CSS subgrid support"""_s, "SubgridEnabled"_s, "Enable CSS subgrid support"""_s, DEFAULT_VALUE_FOR_SubgridEnabled, false),
        API::ExperimentalFeature::create("CSS text-align-last property"""_s, "CSSTextAlignLastEnabled"_s, "Enable the property text-align-last, defined in CSS Text 3"""_s, DEFAULT_VALUE_FOR_CSSTextAlignLastEnabled, false),
        API::ExperimentalFeature::create("CSS text-justify property"""_s, "CSSTextJustifyEnabled"_s, "Enable the property text-justify, defined in CSS Text 3"""_s, DEFAULT_VALUE_FOR_CSSTextJustifyEnabled, false),
        API::ExperimentalFeature::create("CSSOM View Smooth Scrolling"""_s, "CSSOMViewSmoothScrollingEnabled"_s, "Enable DOM API and CSS property for 'smooth' scroll behavior"""_s, DEFAULT_VALUE_FOR_CSSOMViewSmoothScrollingEnabled, false),
        API::ExperimentalFeature::create("Canvas Color Spaces"""_s, "CanvasColorSpaceEnabled"_s, "Enable use of predefined canvas color spaces"""_s, DEFAULT_VALUE_FOR_CanvasColorSpaceEnabled, false),
        API::ExperimentalFeature::create("Compression Stream API"""_s, "CompressionStreamEnabled"_s, "Enable Compression Stream API"""_s, DEFAULT_VALUE_FOR_CompressionStreamEnabled, false),
        API::ExperimentalFeature::create("Contact Picker API"""_s, "ContactPickerAPIEnabled"_s, "Enable the Contact Picker API"""_s, DEFAULT_VALUE_FOR_ContactPickerAPIEnabled, false),
        API::ExperimentalFeature::create("Cross-Origin-Embedder-Policy (COEP) header"""_s, "CrossOriginEmbedderPolicyEnabled"_s, "Support for Cross-Origin-Embedder-Policy (COEP) header"""_s, DEFAULT_VALUE_FOR_CrossOriginEmbedderPolicyEnabled, false),
        API::ExperimentalFeature::create("Cross-Origin-Opener-Policy (COOP) header"""_s, "CrossOriginOpenerPolicyEnabled"_s, "Support for Cross-Origin-Opener-Policy (COOP) header"""_s, DEFAULT_VALUE_FOR_CrossOriginOpenerPolicyEnabled, false),
        API::ExperimentalFeature::create("Defer async scripts until DOMContentLoaded or first-paint"""_s, "ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint"_s, "Defer async scripts until DOMContentLoaded or first-paint"""_s, DEFAULT_VALUE_FOR_ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint, false),
        API::ExperimentalFeature::create("Dialog Element"""_s, "DialogElementEnabled"_s, "Enable the Dialog Element"""_s, DEFAULT_VALUE_FOR_DialogElementEnabled, false),
        API::ExperimentalFeature::create("Disable Full 3rd-Party Cookie Blocking (ITP)"""_s, "IsThirdPartyCookieBlockingDisabled"_s, "Disable full third-party cookie blocking when Intelligent Tracking Prevention is enabled"""_s, DEFAULT_VALUE_FOR_IsThirdPartyCookieBlockingDisabled, false),
#if HAVE(CELESTIAL)
        API::ExperimentalFeature::create("Disable Media Experience PID Inheritance"""_s, "DisableMediaExperiencePIDInheritance"_s, "Disable Media Experience PID Inheritance"""_s, DEFAULT_VALUE_FOR_DisableMediaExperiencePIDInheritance, false),
#endif
        API::ExperimentalFeature::create("Disable Removal of Non-Cookie Data After 7 Days of No User Interaction (ITP)"""_s, "IsFirstPartyWebsiteDataRemovalDisabled"_s, "Disable removal of all non-cookie website data after seven days of no user interaction when Intelligent Tracking Prevention is enabled"""_s, DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalDisabled, false),
        API::ExperimentalFeature::create("Disallow sync XHR during page dismissal"""_s, "DisallowSyncXHRDuringPageDismissalEnabled"_s, "Disallow synchronous XMLHttpRequest during page dismissal"""_s, DEFAULT_VALUE_FOR_DisallowSyncXHRDuringPageDismissalEnabled, false),
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        API::ExperimentalFeature::create("Experimental MediaSession coordinator API"""_s, "MediaSessionCoordinatorEnabled"_s, "Enable experimental MediaSession coordinator API"""_s, DEFAULT_VALUE_FOR_MediaSessionCoordinatorEnabled, false),
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
        API::ExperimentalFeature::create("Experimental MediaSession playlist API"""_s, "MediaSessionPlaylistEnabled"_s, "Enable experimental MediaSession playlist API"""_s, DEFAULT_VALUE_FOR_MediaSessionPlaylistEnabled, false),
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
        API::ExperimentalFeature::create("Experimental MediaSource Inline Painting"""_s, "MediaSourceInlinePaintingEnabled"_s, "Experimental MediaSource Inline Painting"""_s, DEFAULT_VALUE_FOR_MediaSourceInlinePaintingEnabled, false),
#endif
#if HAVE(NETWORK_LOADER)
        API::ExperimentalFeature::create("Experimental network loader"""_s, "CFNetworkNetworkLoaderEnabled"_s, "Enable experimental network loader"""_s, DEFAULT_VALUE_FOR_CFNetworkNetworkLoaderEnabled, false),
#endif
        API::ExperimentalFeature::create("FTP support enabled"""_s, "FTPEnabled"_s, "FTP support enabled"""_s, DEFAULT_VALUE_FOR_FTPEnabled, false),
        API::ExperimentalFeature::create("Fetch API Request KeepAlive"""_s, "FetchAPIKeepAliveEnabled"_s, "Enable Fetch API Request KeepAlive"""_s, DEFAULT_VALUE_FOR_FetchAPIKeepAliveEnabled, false),
        API::ExperimentalFeature::create("Fetch Metadata"""_s, "FetchMetadataEnabled"_s, "Enable Fetch Metadata headers"""_s, DEFAULT_VALUE_FOR_FetchMetadataEnabled, false),
        API::ExperimentalFeature::create("File System Access API"""_s, "FileSystemAccessEnabled"_s, "Enable File System Access API"""_s, DEFAULT_VALUE_FOR_FileSystemAccessEnabled, false),
        API::ExperimentalFeature::create("Form requestSubmit"""_s, "RequestSubmitEnabled"_s, "Form requestSubmit method"""_s, DEFAULT_VALUE_FOR_RequestSubmitEnabled, false),
#if ENABLE(GPU_PROCESS)
        API::ExperimentalFeature::create("GPU Process: DOM Rendering"""_s, "UseGPUProcessForDOMRenderingEnabled"_s, "Enable DOM rendering in GPU Process"""_s, DEFAULT_VALUE_FOR_UseGPUProcessForDOMRenderingEnabled, false),
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
        API::ExperimentalFeature::create("GPU Process: Screen and Window capture"""_s, "UseGPUProcessForDisplayCapture"_s, "Display capture in GPU Process"""_s, DEFAULT_VALUE_FOR_UseGPUProcessForDisplayCapture, false),
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        API::ExperimentalFeature::create("GPU Process: WebGL"""_s, "UseGPUProcessForWebGLEnabled"_s, "Process all WebGL operations in GPU Process"""_s, DEFAULT_VALUE_FOR_UseGPUProcessForWebGLEnabled, false),
#endif
#if ENABLE(VIDEO)
        API::ExperimentalFeature::create("Generic Text Track Cue API"""_s, "GenericCueAPIEnabled"_s, "Enable Generic Text Track Cue API"""_s, DEFAULT_VALUE_FOR_GenericCueAPIEnabled, false),
#endif
        API::ExperimentalFeature::create("HDR Media Capabilities"""_s, "HDRMediaCapabilitiesEnabled"_s, "HDR Media Capabilities"""_s, DEFAULT_VALUE_FOR_HDRMediaCapabilitiesEnabled, false),
#if ENABLE(MODEL_ELEMENT)
        API::ExperimentalFeature::create("HTML <model> element"""_s, "ModelElementEnabled"_s, "HTML <model> element"""_s, DEFAULT_VALUE_FOR_ModelElementEnabled, false),
#endif
#if ENABLE(MODEL_ELEMENT)
        API::ExperimentalFeature::create("HTML <model> elements for stand-alone document"""_s, "ModelDocumentEnabled"_s, "HTML <model> element for model documents"""_s, DEFAULT_VALUE_FOR_ModelDocumentEnabled, false),
#endif
        API::ExperimentalFeature::create("Highlight API"""_s, "HighlightAPIEnabled"_s, "Highlight API support"""_s, DEFAULT_VALUE_FOR_HighlightAPIEnabled, false),
        API::ExperimentalFeature::create("ImageBitmap"""_s, "ImageBitmapEnabled"_s, "Support for the ImageBitmap APIs"""_s, DEFAULT_VALUE_FOR_ImageBitmapEnabled, false),
        API::ExperimentalFeature::create("In-Process Cookie Cache"""_s, "InProcessCookieCacheEnabled"_s, "In-Process DOM Cookie Cache"""_s, DEFAULT_VALUE_FOR_InProcessCookieCacheEnabled, false),
        API::ExperimentalFeature::create("Intersection Observer"""_s, "IntersectionObserverEnabled"_s, "Enable Intersection Observer support"""_s, DEFAULT_VALUE_FOR_IntersectionObserverEnabled, false),
        API::ExperimentalFeature::create("IsLoggedIn web API"""_s, "IsLoggedInAPIEnabled"_s, "Enable the proposed IsLoggedIn web API"""_s, DEFAULT_VALUE_FOR_IsLoggedInAPIEnabled, false),
        API::ExperimentalFeature::create("Lazy iframe loading"""_s, "LazyIframeLoadingEnabled"_s, "Enable lazy iframe loading support"""_s, DEFAULT_VALUE_FOR_LazyIframeLoadingEnabled, false),
        API::ExperimentalFeature::create("Lazy image loading"""_s, "LazyImageLoadingEnabled"_s, "Enable lazy image loading support"""_s, DEFAULT_VALUE_FOR_LazyImageLoadingEnabled, false),
        API::ExperimentalFeature::create("Link Sanitizer"""_s, "LinkSanitizerEnabled"_s, "Enable link sanitizer"""_s, DEFAULT_VALUE_FOR_LinkSanitizerEnabled, false),
        API::ExperimentalFeature::create("Link preload responsive images"""_s, "LinkPreloadResponsiveImagesEnabled"_s, "Enable link preload responsive images"""_s, DEFAULT_VALUE_FOR_LinkPreloadResponsiveImagesEnabled, false),
        API::ExperimentalFeature::create("LinkPrefetch"""_s, "LinkPrefetchEnabled"_s, "Enable LinkedPrefetch"""_s, DEFAULT_VALUE_FOR_LinkPrefetchEnabled, false),
#if ENABLE(WEBGL) || ENABLE(WEBGL2)
        API::ExperimentalFeature::create("Mask WebGL Strings"""_s, "MaskWebGLStringsEnabled"_s, "Mask WebGL Vendor, Renderer, Shader Language Strings"""_s, DEFAULT_VALUE_FOR_MaskWebGLStringsEnabled, false),
#endif
        API::ExperimentalFeature::create("MathML Core"""_s, "CoreMathMLEnabled"_s, "Disable features removed from the MathML Core spec."""_s, DEFAULT_VALUE_FOR_CoreMathMLEnabled, false),
        API::ExperimentalFeature::create("Media Capabilities Extensions"""_s, "MediaCapabilitiesExtensionsEnabled"_s, "Media Capabilities Extensions"""_s, DEFAULT_VALUE_FOR_MediaCapabilitiesExtensionsEnabled, false),
#if ENABLE(MEDIA_SESSION)
        API::ExperimentalFeature::create("Media Session API"""_s, "MediaSessionEnabled"_s, "Media Session API"""_s, DEFAULT_VALUE_FOR_MediaSessionEnabled, false),
#endif
#if ENABLE(MEDIA_RECORDER)
        API::ExperimentalFeature::create("MediaRecorder"""_s, "MediaRecorderEnabled"_s, "MediaRecorder"""_s, DEFAULT_VALUE_FOR_MediaRecorderEnabled, false),
#endif
#if HAVE(NSURLSESSION_WEBSOCKET)
        API::ExperimentalFeature::create("NSURLSession WebSocket"""_s, "IsNSURLSessionWebSocketEnabled"_s, "Use NSURLSession WebSocket API"""_s, DEFAULT_VALUE_FOR_IsNSURLSessionWebSocketEnabled, false),
#endif
#if ENABLE(OPUS)
        API::ExperimentalFeature::create("Opus audio decoder"""_s, "OpusDecoderEnabled"_s, "Enable Opus audio decoder"""_s, DEFAULT_VALUE_FOR_OpusDecoderEnabled, false),
#endif
        API::ExperimentalFeature::create("Paint Timing"""_s, "PaintTimingEnabled"_s, "Enable PaintTiming API"""_s, DEFAULT_VALUE_FOR_PaintTimingEnabled, false),
        API::ExperimentalFeature::create("PerformanceNavigationTiming"""_s, "PerformanceNavigationTimingAPIEnabled"_s, "Enable PerformanceNavigationTiming API"""_s, DEFAULT_VALUE_FOR_PerformanceNavigationTimingAPIEnabled, false),
        API::ExperimentalFeature::create("PerformanceResourceTiming.transferSize, encodedBodySize, and decodedBodySize"""_s, "PerformanceResourceTimingSensitivePropertiesEnabled"_s, "Enable all properties of PerformanceResourceTiming API"""_s, DEFAULT_VALUE_FOR_PerformanceResourceTimingSensitivePropertiesEnabled, false),
        API::ExperimentalFeature::create("Permissions API"""_s, "PermissionsAPIEnabled"_s, "Enable Permissions API"""_s, DEFAULT_VALUE_FOR_PermissionsAPIEnabled, false),
        API::ExperimentalFeature::create("Prefer Page Rendering Updates near 60fps"""_s, "PreferPageRenderingUpdatesNear60FPSEnabled"_s, "Prefer page rendering updates near 60 frames per second rather than using the display's refresh rate"""_s, DEFAULT_VALUE_FOR_PreferPageRenderingUpdatesNear60FPSEnabled, false),
        API::ExperimentalFeature::create("Private Click Measurement Debug Mode"""_s, "PrivateClickMeasurementDebugModeEnabled"_s, "Enable Private Click Measurement Debug Mode"""_s, DEFAULT_VALUE_FOR_PrivateClickMeasurementDebugModeEnabled, false),
        API::ExperimentalFeature::create("Private Click Measurement Fraud Prevention"""_s, "PrivateClickMeasurementFraudPreventionEnabled"_s, "Enable Private Click Measurement Fraud Prevention"""_s, DEFAULT_VALUE_FOR_PrivateClickMeasurementFraudPreventionEnabled, false),
#if ENABLE(SERVICE_WORKER)
        API::ExperimentalFeature::create("Push API"""_s, "PushAPIEnabled"_s, "Enable Push API"""_s, DEFAULT_VALUE_FOR_PushAPIEnabled, false),
#endif
        API::ExperimentalFeature::create("Quirk to prevent delayed initial painting on sites using Google's Anti-Flicker optimization"""_s, "GoogleAntiFlickerOptimizationQuirkEnabled"_s, "Quirk to prevent delayed initial painting on sites using Google's Anti-Flicker optimization"""_s, DEFAULT_VALUE_FOR_GoogleAntiFlickerOptimizationQuirkEnabled, false),
        API::ExperimentalFeature::create("ReadableByteStream"""_s, "ReadableByteStreamAPIEnabled"_s, "Enable Readable Byte Streams"""_s, DEFAULT_VALUE_FOR_ReadableByteStreamAPIEnabled, false),
        API::ExperimentalFeature::create("Referrer Policy attribute"""_s, "ReferrerPolicyAttributeEnabled"_s, "Enable Referrer Policy attribute"""_s, DEFAULT_VALUE_FOR_ReferrerPolicyAttributeEnabled, false),
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        API::ExperimentalFeature::create("Remote Playback API"""_s, "RemotePlaybackEnabled"_s, "Enable Remote Playback API"""_s, DEFAULT_VALUE_FOR_RemotePlaybackEnabled, false),
#endif
        API::ExperimentalFeature::create("RequestVideoFrameCallback"""_s, "RequestVideoFrameCallbackEnabled"_s, "Enable RequestVideoFrameCallback API"""_s, DEFAULT_VALUE_FOR_RequestVideoFrameCallbackEnabled, false),
        API::ExperimentalFeature::create("Resize Observer"""_s, "ResizeObserverEnabled"_s, "Enable Resize Observer support"""_s, DEFAULT_VALUE_FOR_ResizeObserverEnabled, false),
        API::ExperimentalFeature::create("Resolution media feature"""_s, "ResolutionMediaFeatureEnabled"_s, "Enable resolution media feature support"""_s, DEFAULT_VALUE_FOR_ResolutionMediaFeatureEnabled, false),
        API::ExperimentalFeature::create("SKAttribution"""_s, "SKAttributionEnabled"_s, "SKAttribution"""_s, DEFAULT_VALUE_FOR_SKAttributionEnabled, false),
        API::ExperimentalFeature::create("SameSite strict enforcement (ITP)"""_s, "IsSameSiteStrictEnforcementEnabled"_s, "Enable SameSite strict enforcement to mitigate bounce tracking"""_s, DEFAULT_VALUE_FOR_IsSameSiteStrictEnforcementEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::ExperimentalFeature::create("ScreenCapture"""_s, "ScreenCaptureEnabled"_s, "Enable ScreenCapture"""_s, DEFAULT_VALUE_FOR_ScreenCaptureEnabled, false),
#endif
        API::ExperimentalFeature::create("Scroll To Text Fragment"""_s, "ScrollToTextFragmentEnabled"_s, "Enable Scroll To Text Fragment"""_s, DEFAULT_VALUE_FOR_ScrollToTextFragmentEnabled, false),
        API::ExperimentalFeature::create("Server Timing"""_s, "ServerTimingEnabled"_s, "Enable Server Timing API"""_s, DEFAULT_VALUE_FOR_ServerTimingEnabled, false),
#if ENABLE(SERVICE_WORKER)
        API::ExperimentalFeature::create("Service Worker Navigation Preload"""_s, "ServiceWorkerNavigationPreloadEnabled"_s, "Enable Service Worker Navigation Preload API"""_s, DEFAULT_VALUE_FOR_ServiceWorkerNavigationPreloadEnabled, false),
#endif
        API::ExperimentalFeature::create("SharedWorker"""_s, "SharedWorkerEnabled"_s, "Enabled SharedWorker API"""_s, DEFAULT_VALUE_FOR_SharedWorkerEnabled, false),
        API::ExperimentalFeature::create("SpeechRecognition API"""_s, "SpeechRecognitionEnabled"_s, "Enable SpeechRecognition of WebSpeech API"""_s, DEFAULT_VALUE_FOR_SpeechRecognitionEnabled, false),
        API::ExperimentalFeature::create("Storage API"""_s, "StorageAPIEnabled"_s, "Enable Storage API"""_s, DEFAULT_VALUE_FOR_StorageAPIEnabled, false),
        API::ExperimentalFeature::create("Swap Processes on Cross-Site Navigation"""_s, "ProcessSwapOnCrossSiteNavigationEnabled"_s, "Swap WebContent Processes on cross-site navigations"""_s, DEFAULT_VALUE_FOR_ProcessSwapOnCrossSiteNavigationEnabled, false),
        API::ExperimentalFeature::create("Synthetic Editing Commands"""_s, "SyntheticEditingCommandsEnabled"_s, "Enable Synthetic Editing Commands"""_s, DEFAULT_VALUE_FOR_SyntheticEditingCommandsEnabled, false),
        API::ExperimentalFeature::create("Track Configuration API"""_s, "TrackConfigurationEnabled"_s, "Track Configuration API"""_s, DEFAULT_VALUE_FOR_TrackConfigurationEnabled, false),
        API::ExperimentalFeature::create("TransformStream API"""_s, "TransformStreamAPIEnabled"_s, "Enable Transform Stream API"""_s, DEFAULT_VALUE_FOR_TransformStreamAPIEnabled, false),
        API::ExperimentalFeature::create("UserGesture Promise Propagation"""_s, "UserGesturePromisePropagationEnabled"_s, "UserGesture Promise Propagation"""_s, DEFAULT_VALUE_FOR_UserGesturePromisePropagationEnabled, false),
#if ENABLE(VP9)
        API::ExperimentalFeature::create("VP9 SW decoder on battery"""_s, "VP9SWDecoderEnabledOnBattery"_s, "Enable VP9 SW decoder on battery"""_s, DEFAULT_VALUE_FOR_VP9SWDecoderEnabledOnBattery, false),
#endif
        API::ExperimentalFeature::create("Visual Viewport API"""_s, "VisualViewportAPIEnabled"_s, "Enable Visual Viewport API"""_s, DEFAULT_VALUE_FOR_VisualViewportAPIEnabled, false),
#if ENABLE(VORBIS)
        API::ExperimentalFeature::create("Vorbis audio decoder"""_s, "VorbisDecoderEnabled"_s, "Enable Vorbis audio decoder"""_s, DEFAULT_VALUE_FOR_VorbisDecoderEnabled, false),
#endif
        API::ExperimentalFeature::create("Web APIs in ShadowRealm"""_s, "WebAPIsInShadowRealmEnabled"_s, "Enable Web APIs to be exposed in ShadowRealm"""_s, DEFAULT_VALUE_FOR_WebAPIsInShadowRealmEnabled, false),
        API::ExperimentalFeature::create("Web Animations composite operations"""_s, "WebAnimationsCompositeOperationsEnabled"_s, "Support for the CompositeOperation enum and properties consuming it"""_s, DEFAULT_VALUE_FOR_WebAnimationsCompositeOperationsEnabled, false),
        API::ExperimentalFeature::create("Web Animations custom effects"""_s, "WebAnimationsCustomEffectsEnabled"_s, "Support for the CustomEffect interface"""_s, DEFAULT_VALUE_FOR_WebAnimationsCustomEffectsEnabled, false),
        API::ExperimentalFeature::create("Web Animations custom frame rate"""_s, "WebAnimationsCustomFrameRateEnabled"_s, "Support for specifying a custom frame rate for Web Animations"""_s, DEFAULT_VALUE_FOR_WebAnimationsCustomFrameRateEnabled, false),
        API::ExperimentalFeature::create("Web Animations iteration composite"""_s, "WebAnimationsIterationCompositeEnabled"_s, "Support for the KeyframeEffect.iterationComposite property"""_s, DEFAULT_VALUE_FOR_WebAnimationsIterationCompositeEnabled, false),
        API::ExperimentalFeature::create("Web Animations mutable timelines"""_s, "WebAnimationsMutableTimelinesEnabled"_s, "Support for setting the timeline property of an Animation object"""_s, DEFAULT_VALUE_FOR_WebAnimationsMutableTimelinesEnabled, false),
#if ENABLE(WEB_AUTHN)
        API::ExperimentalFeature::create("Web Authentication"""_s, "WebAuthenticationEnabled"_s, "Enable Web Authentication support"""_s, DEFAULT_VALUE_FOR_WebAuthenticationEnabled, false),
#endif
        API::ExperimentalFeature::create("Web Locks API"""_s, "WebLocksAPIEnabled"_s, "Web Locks API"""_s, DEFAULT_VALUE_FOR_WebLocksAPIEnabled, false),
        API::ExperimentalFeature::create("Web Share API Level 2"""_s, "WebShareFileAPIEnabled"_s, "Enable level 2 of Web Share API"""_s, DEFAULT_VALUE_FOR_WebShareFileAPIEnabled, false),
#if ENABLE(WEBASSEMBLY)
        API::ExperimentalFeature::create("WebAssembly ES module integration support"""_s, "WebAssemblyESMIntegrationEnabled"_s, "Support for allowing WebAssembly modules to integrate as ES modules"""_s, DEFAULT_VALUE_FOR_WebAssemblyESMIntegrationEnabled, false),
#endif
#if ENABLE(WEBGL2)
        API::ExperimentalFeature::create("WebGL 2.0"""_s, "WebGL2Enabled"_s, "WebGL 2 prototype"""_s, DEFAULT_VALUE_FOR_WebGL2Enabled, false),
#endif
        API::ExperimentalFeature::create("WebGL Draft Extensions"""_s, "WebGLDraftExtensionsEnabled"_s, "Enable WebGL extensions that are still in draft status"""_s, DEFAULT_VALUE_FOR_WebGLDraftExtensionsEnabled, false),
#if ENABLE(WEBGL) && PLATFORM(COCOA)
        API::ExperimentalFeature::create("WebGL via Metal"""_s, "WebGLUsingMetal"_s, "Use the Metal backend for ANGLE"""_s, DEFAULT_VALUE_FOR_WebGLUsingMetal, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC Encoded Transform API"""_s, "WebRTCEncodedTransformEnabled"_s, "Enable WebRTC Encoded Transform API"""_s, DEFAULT_VALUE_FOR_WebRTCEncodedTransformEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC H264 LowLatency encoder"""_s, "WebRTCH264LowLatencyEncoderEnabled"_s, "Enable H264 LowLatency encoder"""_s, DEFAULT_VALUE_FOR_WebRTCH264LowLatencyEncoderEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC H265 codec"""_s, "WebRTCH265CodecEnabled"_s, "Enable WebRTC H265 codec"""_s, DEFAULT_VALUE_FOR_WebRTCH265CodecEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC Platform TCP Sockets"""_s, "WebRTCPlatformTCPSocketsEnabled"_s, "Enable WebRTC Platform TCP Sockets"""_s, DEFAULT_VALUE_FOR_WebRTCPlatformTCPSocketsEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC Platform UDP Sockets"""_s, "WebRTCPlatformUDPSocketsEnabled"_s, "Enable WebRTC Platform UDP Sockets"""_s, DEFAULT_VALUE_FOR_WebRTCPlatformUDPSocketsEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC SFrame Transform API"""_s, "WebRTCSFrameTransformEnabled"_s, "Enable WebRTC SFrame Transform API"""_s, DEFAULT_VALUE_FOR_WebRTCSFrameTransformEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC Sockets Proxying"""_s, "WebRTCSocketsProxyingEnabled"_s, "Enable WebRTC Sockets Proxying"""_s, DEFAULT_VALUE_FOR_WebRTCSocketsProxyingEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC VP9 profile 0 codec"""_s, "WebRTCVP9Profile0CodecEnabled"_s, "Enable WebRTC VP9 profile 0 codec"""_s, DEFAULT_VALUE_FOR_WebRTCVP9Profile0CodecEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC VP9 profile 2 codec"""_s, "WebRTCVP9Profile2CodecEnabled"_s, "Enable WebRTC VP9 profile 2 codec"""_s, DEFAULT_VALUE_FOR_WebRTCVP9Profile2CodecEnabled, false),
#endif
#if ENABLE(WEBXR)
        API::ExperimentalFeature::create("WebXR Augmented Reality Module"""_s, "WebXRAugmentedRealityModuleEnabled"_s, "Adds support for the WebXR Augmented Reality Module"""_s, DEFAULT_VALUE_FOR_WebXRAugmentedRealityModuleEnabled, false),
#endif
#if ENABLE(WEBXR)
        API::ExperimentalFeature::create("WebXR Device API"""_s, "WebXREnabled"_s, "Adds support for accessing virtual reality (VR) and augmented reality (AR) devices, including sensors and head-mounted displays, on the Web"""_s, DEFAULT_VALUE_FOR_WebXREnabled, false),
#endif
#if ENABLE(WEBXR)
        API::ExperimentalFeature::create("WebXR Gamepads Module"""_s, "WebXRGamepadsModuleEnabled"_s, "Adds support for the WebXR Gamepads Module"""_s, DEFAULT_VALUE_FOR_WebXRGamepadsModuleEnabled, false),
#endif
#if ENABLE(WEBXR_HANDS)
        API::ExperimentalFeature::create("WebXR Hand Input Module"""_s, "WebXRHandInputModuleEnabled"_s, "Adds support for the Hands Input Module for WebXR"""_s, DEFAULT_VALUE_FOR_WebXRHandInputModuleEnabled, false),
#endif
        API::ExperimentalFeature::create("Wheel Event gestures become non-blocking"""_s, "WheelEventGesturesBecomeNonBlocking"_s, "preventDefault() is only allowed on the first wheel event in a gesture"""_s, DEFAULT_VALUE_FOR_WheelEventGesturesBecomeNonBlocking, false),
        API::ExperimentalFeature::create("Wheel Event listeners on the root made passive"""_s, "PassiveWheelListenersAsDefaultOnDocument"_s, "Force wheel event listeners registered on the window, document or body to be passive"""_s, DEFAULT_VALUE_FOR_PassiveWheelListenersAsDefaultOnDocument, false),
        API::ExperimentalFeature::create("inert attribute"""_s, "InertAttributeEnabled"_s, "Enable inert attribute support"""_s, DEFAULT_VALUE_FOR_InertAttributeEnabled, false),
        API::ExperimentalFeature::create("requestIdleCallback"""_s, "RequestIdleCallbackEnabled"_s, "Enable requestIdleCallback support"""_s, DEFAULT_VALUE_FOR_RequestIdleCallbackEnabled, false),
    });

    return features;
}

bool WebPreferences::isFeatureEnabled(const API::ExperimentalFeature& feature) const
{
    struct FeatureGetterMapping {
        ASCIILiteral name;
        bool (WebPreferences::*function) () const;
    };

    static FeatureGetterMapping getters[] = {
        { "DirPseudoEnabled"_s, &WebPreferences::dirPseudoEnabled },
        { "FocusVisibleEnabled"_s, &WebPreferences::focusVisibleEnabled },
        { "HasPseudoClassEnabled"_s, &WebPreferences::hasPseudoClassEnabled },
        { "PageAtRuleSupportEnabled"_s, &WebPreferences::pageAtRuleSupportEnabled },
        { "AriaReflectionForElementReferencesEnabled"_s, &WebPreferences::ariaReflectionForElementReferencesEnabled },
        { "AccessHandleEnabled"_s, &WebPreferences::accessHandleEnabled },
        { "AccessibilityObjectModelEnabled"_s, &WebPreferences::accessibilityObjectModelEnabled },
#if ENABLE(MEDIA_STREAM)
        { "PerElementSpeakerSelectionEnabled"_s, &WebPreferences::perElementSpeakerSelectionEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "ExposeSpeakersEnabled"_s, &WebPreferences::exposeSpeakersEnabled },
#endif
        { "AspectRatioOfImgFromWidthAndHeightEnabled"_s, &WebPreferences::aspectRatioOfImgFromWidthAndHeightEnabled },
        { "AsyncClipboardAPIEnabled"_s, &WebPreferences::asyncClipboardAPIEnabled },
        { "BlankAnchorTargetImpliesNoOpenerEnabled"_s, &WebPreferences::blankAnchorTargetImpliesNoOpenerEnabled },
        { "ThirdPartyIframeRedirectBlockingEnabled"_s, &WebPreferences::thirdPartyIframeRedirectBlockingEnabled },
        { "BroadcastChannelEnabled"_s, &WebPreferences::broadcastChannelEnabled },
        { "BroadcastChannelOriginPartitioningEnabled"_s, &WebPreferences::broadcastChannelOriginPartitioningEnabled },
#if ENABLE(BUILT_IN_NOTIFICATIONS)
        { "BuiltInNotificationsEnabled"_s, &WebPreferences::builtInNotificationsEnabled },
#endif
        { "CSS3DTransformInteroperabilityEnabled"_s, &WebPreferences::css3DTransformInteroperabilityEnabled },
        { "CSSCounterStyleAtRuleImageSymbolsEnabled"_s, &WebPreferences::cssCounterStyleAtRuleImageSymbolsEnabled },
        { "CSSCounterStyleAtRulesEnabled"_s, &WebPreferences::cssCounterStyleAtRulesEnabled },
        { "AccentColorEnabled"_s, &WebPreferences::accentColorEnabled },
        { "AspectRatioEnabled"_s, &WebPreferences::aspectRatioEnabled },
        { "CSSCascadeLayersEnabled"_s, &WebPreferences::cssCascadeLayersEnabled },
        { "CSSColor4"_s, &WebPreferences::cssColor4 },
        { "CSSContainIntrinsicSizeEnabled"_s, &WebPreferences::cssContainIntrinsicSizeEnabled },
        { "CSSContainerQueriesEnabled"_s, &WebPreferences::cssContainerQueriesEnabled },
        { "CSSContainmentEnabled"_s, &WebPreferences::cssContainmentEnabled },
        { "CSSCustomPropertiesAndValuesEnabled"_s, &WebPreferences::cssCustomPropertiesAndValuesEnabled },
        { "CSSGradientInterpolationColorSpacesEnabled"_s, &WebPreferences::cssGradientInterpolationColorSpacesEnabled },
        { "CSSGradientPremultipliedAlphaInterpolationEnabled"_s, &WebPreferences::cssGradientPremultipliedAlphaInterpolationEnabled },
        { "CSSIndividualTransformPropertiesEnabled"_s, &WebPreferences::cssIndividualTransformPropertiesEnabled },
        { "CSSInputSecurityEnabled"_s, &WebPreferences::cssInputSecurityEnabled },
        { "CSSMotionPathEnabled"_s, &WebPreferences::cssMotionPathEnabled },
        { "OverscrollBehaviorEnabled"_s, &WebPreferences::overscrollBehaviorEnabled },
#if ENABLE(CSS_PAINTING_API)
        { "CSSPaintingAPIEnabled"_s, &WebPreferences::cssPaintingAPIEnabled },
#endif
        { "CSSRelativeColorSyntaxEnabled"_s, &WebPreferences::cssRelativeColorSyntaxEnabled },
        { "CSSScrollAnchoringEnabled"_s, &WebPreferences::cssScrollAnchoringEnabled },
        { "SpringTimingFunctionEnabled"_s, &WebPreferences::springTimingFunctionEnabled },
#if ENABLE(CSS_TYPED_OM)
        { "CSSTypedOMEnabled"_s, &WebPreferences::cssTypedOMEnabled },
#endif
        { "CSSColorContrastEnabled"_s, &WebPreferences::cssColorContrastEnabled },
        { "CSSColorMixEnabled"_s, &WebPreferences::cssColorMixEnabled },
        { "OverflowClipEnabled"_s, &WebPreferences::overflowClipEnabled },
        { "SubgridEnabled"_s, &WebPreferences::subgridEnabled },
        { "CSSTextAlignLastEnabled"_s, &WebPreferences::cssTextAlignLastEnabled },
        { "CSSTextJustifyEnabled"_s, &WebPreferences::cssTextJustifyEnabled },
        { "CSSOMViewSmoothScrollingEnabled"_s, &WebPreferences::cssOMViewSmoothScrollingEnabled },
        { "CanvasColorSpaceEnabled"_s, &WebPreferences::canvasColorSpaceEnabled },
        { "CompressionStreamEnabled"_s, &WebPreferences::compressionStreamEnabled },
        { "ContactPickerAPIEnabled"_s, &WebPreferences::contactPickerAPIEnabled },
        { "CrossOriginEmbedderPolicyEnabled"_s, &WebPreferences::crossOriginEmbedderPolicyEnabled },
        { "CrossOriginOpenerPolicyEnabled"_s, &WebPreferences::crossOriginOpenerPolicyEnabled },
        { "ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint"_s, &WebPreferences::shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint },
        { "DialogElementEnabled"_s, &WebPreferences::dialogElementEnabled },
        { "IsThirdPartyCookieBlockingDisabled"_s, &WebPreferences::isThirdPartyCookieBlockingDisabled },
#if HAVE(CELESTIAL)
        { "DisableMediaExperiencePIDInheritance"_s, &WebPreferences::disableMediaExperiencePIDInheritance },
#endif
        { "IsFirstPartyWebsiteDataRemovalDisabled"_s, &WebPreferences::isFirstPartyWebsiteDataRemovalDisabled },
        { "DisallowSyncXHRDuringPageDismissalEnabled"_s, &WebPreferences::disallowSyncXHRDuringPageDismissalEnabled },
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        { "MediaSessionCoordinatorEnabled"_s, &WebPreferences::mediaSessionCoordinatorEnabled },
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
        { "MediaSessionPlaylistEnabled"_s, &WebPreferences::mediaSessionPlaylistEnabled },
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
        { "MediaSourceInlinePaintingEnabled"_s, &WebPreferences::mediaSourceInlinePaintingEnabled },
#endif
#if HAVE(NETWORK_LOADER)
        { "CFNetworkNetworkLoaderEnabled"_s, &WebPreferences::cFNetworkNetworkLoaderEnabled },
#endif
        { "FTPEnabled"_s, &WebPreferences::ftpEnabled },
        { "FetchAPIKeepAliveEnabled"_s, &WebPreferences::fetchAPIKeepAliveEnabled },
        { "FetchMetadataEnabled"_s, &WebPreferences::fetchMetadataEnabled },
        { "FileSystemAccessEnabled"_s, &WebPreferences::fileSystemAccessEnabled },
        { "RequestSubmitEnabled"_s, &WebPreferences::requestSubmitEnabled },
#if ENABLE(GPU_PROCESS)
        { "UseGPUProcessForDOMRenderingEnabled"_s, &WebPreferences::useGPUProcessForDOMRenderingEnabled },
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
        { "UseGPUProcessForDisplayCapture"_s, &WebPreferences::useGPUProcessForDisplayCapture },
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "UseGPUProcessForWebGLEnabled"_s, &WebPreferences::useGPUProcessForWebGLEnabled },
#endif
#if ENABLE(VIDEO)
        { "GenericCueAPIEnabled"_s, &WebPreferences::genericCueAPIEnabled },
#endif
        { "HDRMediaCapabilitiesEnabled"_s, &WebPreferences::hDRMediaCapabilitiesEnabled },
#if ENABLE(MODEL_ELEMENT)
        { "ModelElementEnabled"_s, &WebPreferences::modelElementEnabled },
#endif
#if ENABLE(MODEL_ELEMENT)
        { "ModelDocumentEnabled"_s, &WebPreferences::modelDocumentEnabled },
#endif
        { "HighlightAPIEnabled"_s, &WebPreferences::highlightAPIEnabled },
        { "ImageBitmapEnabled"_s, &WebPreferences::imageBitmapEnabled },
        { "InProcessCookieCacheEnabled"_s, &WebPreferences::inProcessCookieCacheEnabled },
        { "IntersectionObserverEnabled"_s, &WebPreferences::intersectionObserverEnabled },
        { "IsLoggedInAPIEnabled"_s, &WebPreferences::isLoggedInAPIEnabled },
        { "LazyIframeLoadingEnabled"_s, &WebPreferences::lazyIframeLoadingEnabled },
        { "LazyImageLoadingEnabled"_s, &WebPreferences::lazyImageLoadingEnabled },
        { "LinkSanitizerEnabled"_s, &WebPreferences::linkSanitizerEnabled },
        { "LinkPreloadResponsiveImagesEnabled"_s, &WebPreferences::linkPreloadResponsiveImagesEnabled },
        { "LinkPrefetchEnabled"_s, &WebPreferences::linkPrefetchEnabled },
#if ENABLE(WEBGL) || ENABLE(WEBGL2)
        { "MaskWebGLStringsEnabled"_s, &WebPreferences::maskWebGLStringsEnabled },
#endif
        { "CoreMathMLEnabled"_s, &WebPreferences::coreMathMLEnabled },
        { "MediaCapabilitiesExtensionsEnabled"_s, &WebPreferences::mediaCapabilitiesExtensionsEnabled },
#if ENABLE(MEDIA_SESSION)
        { "MediaSessionEnabled"_s, &WebPreferences::mediaSessionEnabled },
#endif
#if ENABLE(MEDIA_RECORDER)
        { "MediaRecorderEnabled"_s, &WebPreferences::mediaRecorderEnabled },
#endif
#if HAVE(NSURLSESSION_WEBSOCKET)
        { "IsNSURLSessionWebSocketEnabled"_s, &WebPreferences::isNSURLSessionWebSocketEnabled },
#endif
#if ENABLE(OPUS)
        { "OpusDecoderEnabled"_s, &WebPreferences::opusDecoderEnabled },
#endif
        { "PaintTimingEnabled"_s, &WebPreferences::paintTimingEnabled },
        { "PerformanceNavigationTimingAPIEnabled"_s, &WebPreferences::performanceNavigationTimingAPIEnabled },
        { "PerformanceResourceTimingSensitivePropertiesEnabled"_s, &WebPreferences::performanceResourceTimingSensitivePropertiesEnabled },
        { "PermissionsAPIEnabled"_s, &WebPreferences::permissionsAPIEnabled },
        { "PreferPageRenderingUpdatesNear60FPSEnabled"_s, &WebPreferences::preferPageRenderingUpdatesNear60FPSEnabled },
        { "PrivateClickMeasurementDebugModeEnabled"_s, &WebPreferences::privateClickMeasurementDebugModeEnabled },
        { "PrivateClickMeasurementFraudPreventionEnabled"_s, &WebPreferences::privateClickMeasurementFraudPreventionEnabled },
#if ENABLE(SERVICE_WORKER)
        { "PushAPIEnabled"_s, &WebPreferences::pushAPIEnabled },
#endif
        { "GoogleAntiFlickerOptimizationQuirkEnabled"_s, &WebPreferences::googleAntiFlickerOptimizationQuirkEnabled },
        { "ReadableByteStreamAPIEnabled"_s, &WebPreferences::readableByteStreamAPIEnabled },
        { "ReferrerPolicyAttributeEnabled"_s, &WebPreferences::referrerPolicyAttributeEnabled },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "RemotePlaybackEnabled"_s, &WebPreferences::remotePlaybackEnabled },
#endif
        { "RequestVideoFrameCallbackEnabled"_s, &WebPreferences::requestVideoFrameCallbackEnabled },
        { "ResizeObserverEnabled"_s, &WebPreferences::resizeObserverEnabled },
        { "ResolutionMediaFeatureEnabled"_s, &WebPreferences::resolutionMediaFeatureEnabled },
        { "SKAttributionEnabled"_s, &WebPreferences::sKAttributionEnabled },
        { "IsSameSiteStrictEnforcementEnabled"_s, &WebPreferences::isSameSiteStrictEnforcementEnabled },
#if ENABLE(MEDIA_STREAM)
        { "ScreenCaptureEnabled"_s, &WebPreferences::screenCaptureEnabled },
#endif
        { "ScrollToTextFragmentEnabled"_s, &WebPreferences::scrollToTextFragmentEnabled },
        { "ServerTimingEnabled"_s, &WebPreferences::serverTimingEnabled },
#if ENABLE(SERVICE_WORKER)
        { "ServiceWorkerNavigationPreloadEnabled"_s, &WebPreferences::serviceWorkerNavigationPreloadEnabled },
#endif
        { "SharedWorkerEnabled"_s, &WebPreferences::sharedWorkerEnabled },
        { "SpeechRecognitionEnabled"_s, &WebPreferences::speechRecognitionEnabled },
        { "StorageAPIEnabled"_s, &WebPreferences::storageAPIEnabled },
        { "ProcessSwapOnCrossSiteNavigationEnabled"_s, &WebPreferences::processSwapOnCrossSiteNavigationEnabled },
        { "SyntheticEditingCommandsEnabled"_s, &WebPreferences::syntheticEditingCommandsEnabled },
        { "TrackConfigurationEnabled"_s, &WebPreferences::trackConfigurationEnabled },
        { "TransformStreamAPIEnabled"_s, &WebPreferences::transformStreamAPIEnabled },
        { "UserGesturePromisePropagationEnabled"_s, &WebPreferences::userGesturePromisePropagationEnabled },
#if ENABLE(VP9)
        { "VP9SWDecoderEnabledOnBattery"_s, &WebPreferences::vp9SWDecoderEnabledOnBattery },
#endif
        { "VisualViewportAPIEnabled"_s, &WebPreferences::visualViewportAPIEnabled },
#if ENABLE(VORBIS)
        { "VorbisDecoderEnabled"_s, &WebPreferences::vorbisDecoderEnabled },
#endif
        { "WebAPIsInShadowRealmEnabled"_s, &WebPreferences::webAPIsInShadowRealmEnabled },
        { "WebAnimationsCompositeOperationsEnabled"_s, &WebPreferences::webAnimationsCompositeOperationsEnabled },
        { "WebAnimationsCustomEffectsEnabled"_s, &WebPreferences::webAnimationsCustomEffectsEnabled },
        { "WebAnimationsCustomFrameRateEnabled"_s, &WebPreferences::webAnimationsCustomFrameRateEnabled },
        { "WebAnimationsIterationCompositeEnabled"_s, &WebPreferences::webAnimationsIterationCompositeEnabled },
        { "WebAnimationsMutableTimelinesEnabled"_s, &WebPreferences::webAnimationsMutableTimelinesEnabled },
#if ENABLE(WEB_AUTHN)
        { "WebAuthenticationEnabled"_s, &WebPreferences::webAuthenticationEnabled },
#endif
        { "WebLocksAPIEnabled"_s, &WebPreferences::webLocksAPIEnabled },
        { "WebShareFileAPIEnabled"_s, &WebPreferences::webShareFileAPIEnabled },
#if ENABLE(WEBASSEMBLY)
        { "WebAssemblyESMIntegrationEnabled"_s, &WebPreferences::webAssemblyESMIntegrationEnabled },
#endif
#if ENABLE(WEBGL2)
        { "WebGL2Enabled"_s, &WebPreferences::webGL2Enabled },
#endif
        { "WebGLDraftExtensionsEnabled"_s, &WebPreferences::webGLDraftExtensionsEnabled },
#if ENABLE(WEBGL) && PLATFORM(COCOA)
        { "WebGLUsingMetal"_s, &WebPreferences::webGLUsingMetal },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCEncodedTransformEnabled"_s, &WebPreferences::webRTCEncodedTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264LowLatencyEncoderEnabled"_s, &WebPreferences::webRTCH264LowLatencyEncoderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH265CodecEnabled"_s, &WebPreferences::webRTCH265CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformTCPSocketsEnabled"_s, &WebPreferences::webRTCPlatformTCPSocketsEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformUDPSocketsEnabled"_s, &WebPreferences::webRTCPlatformUDPSocketsEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSFrameTransformEnabled"_s, &WebPreferences::webRTCSFrameTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSocketsProxyingEnabled"_s, &WebPreferences::webRTCSocketsProxyingEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile0CodecEnabled"_s, &WebPreferences::webRTCVP9Profile0CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile2CodecEnabled"_s, &WebPreferences::webRTCVP9Profile2CodecEnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXRAugmentedRealityModuleEnabled"_s, &WebPreferences::webXRAugmentedRealityModuleEnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXREnabled"_s, &WebPreferences::webXREnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXRGamepadsModuleEnabled"_s, &WebPreferences::webXRGamepadsModuleEnabled },
#endif
#if ENABLE(WEBXR_HANDS)
        { "WebXRHandInputModuleEnabled"_s, &WebPreferences::webXRHandInputModuleEnabled },
#endif
        { "WheelEventGesturesBecomeNonBlocking"_s, &WebPreferences::wheelEventGesturesBecomeNonBlocking },
        { "PassiveWheelListenersAsDefaultOnDocument"_s, &WebPreferences::passiveWheelListenersAsDefaultOnDocument },
        { "InertAttributeEnabled"_s, &WebPreferences::inertAttributeEnabled },
        { "RequestIdleCallbackEnabled"_s, &WebPreferences::requestIdleCallbackEnabled },
    };

    const String& key = feature.key();

    for (auto& getter : getters) {
        if (key == getter.name)
            return (this->*getter.function)();
    }

    return false;
}

void WebPreferences::setFeatureEnabled(const API::ExperimentalFeature& feature, bool value)
{
    setExperimentalFeatureEnabledForKey(feature.key(), value);
}

void WebPreferences::setExperimentalFeatureEnabledForKey(const String& key, bool value)
{
    struct FeatureSetterMapping {
        ASCIILiteral name;
        void (WebPreferences::*function) (const bool&);
    };

    static FeatureSetterMapping setters[] = {
        { "DirPseudoEnabled"_s, &WebPreferences::setDirPseudoEnabled },
        { "FocusVisibleEnabled"_s, &WebPreferences::setFocusVisibleEnabled },
        { "HasPseudoClassEnabled"_s, &WebPreferences::setHasPseudoClassEnabled },
        { "PageAtRuleSupportEnabled"_s, &WebPreferences::setPageAtRuleSupportEnabled },
        { "AriaReflectionForElementReferencesEnabled"_s, &WebPreferences::setAriaReflectionForElementReferencesEnabled },
        { "AccessHandleEnabled"_s, &WebPreferences::setAccessHandleEnabled },
        { "AccessibilityObjectModelEnabled"_s, &WebPreferences::setAccessibilityObjectModelEnabled },
#if ENABLE(MEDIA_STREAM)
        { "PerElementSpeakerSelectionEnabled"_s, &WebPreferences::setPerElementSpeakerSelectionEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "ExposeSpeakersEnabled"_s, &WebPreferences::setExposeSpeakersEnabled },
#endif
        { "AspectRatioOfImgFromWidthAndHeightEnabled"_s, &WebPreferences::setAspectRatioOfImgFromWidthAndHeightEnabled },
        { "AsyncClipboardAPIEnabled"_s, &WebPreferences::setAsyncClipboardAPIEnabled },
        { "BlankAnchorTargetImpliesNoOpenerEnabled"_s, &WebPreferences::setBlankAnchorTargetImpliesNoOpenerEnabled },
        { "ThirdPartyIframeRedirectBlockingEnabled"_s, &WebPreferences::setThirdPartyIframeRedirectBlockingEnabled },
        { "BroadcastChannelEnabled"_s, &WebPreferences::setBroadcastChannelEnabled },
        { "BroadcastChannelOriginPartitioningEnabled"_s, &WebPreferences::setBroadcastChannelOriginPartitioningEnabled },
#if ENABLE(BUILT_IN_NOTIFICATIONS)
        { "BuiltInNotificationsEnabled"_s, &WebPreferences::setBuiltInNotificationsEnabled },
#endif
        { "CSS3DTransformInteroperabilityEnabled"_s, &WebPreferences::setCSS3DTransformInteroperabilityEnabled },
        { "CSSCounterStyleAtRuleImageSymbolsEnabled"_s, &WebPreferences::setCSSCounterStyleAtRuleImageSymbolsEnabled },
        { "CSSCounterStyleAtRulesEnabled"_s, &WebPreferences::setCSSCounterStyleAtRulesEnabled },
        { "AccentColorEnabled"_s, &WebPreferences::setAccentColorEnabled },
        { "AspectRatioEnabled"_s, &WebPreferences::setAspectRatioEnabled },
        { "CSSCascadeLayersEnabled"_s, &WebPreferences::setCSSCascadeLayersEnabled },
        { "CSSColor4"_s, &WebPreferences::setCSSColor4 },
        { "CSSContainIntrinsicSizeEnabled"_s, &WebPreferences::setCSSContainIntrinsicSizeEnabled },
        { "CSSContainerQueriesEnabled"_s, &WebPreferences::setCSSContainerQueriesEnabled },
        { "CSSContainmentEnabled"_s, &WebPreferences::setCSSContainmentEnabled },
        { "CSSCustomPropertiesAndValuesEnabled"_s, &WebPreferences::setCSSCustomPropertiesAndValuesEnabled },
        { "CSSGradientInterpolationColorSpacesEnabled"_s, &WebPreferences::setCSSGradientInterpolationColorSpacesEnabled },
        { "CSSGradientPremultipliedAlphaInterpolationEnabled"_s, &WebPreferences::setCSSGradientPremultipliedAlphaInterpolationEnabled },
        { "CSSIndividualTransformPropertiesEnabled"_s, &WebPreferences::setCSSIndividualTransformPropertiesEnabled },
        { "CSSInputSecurityEnabled"_s, &WebPreferences::setCSSInputSecurityEnabled },
        { "CSSMotionPathEnabled"_s, &WebPreferences::setCSSMotionPathEnabled },
        { "OverscrollBehaviorEnabled"_s, &WebPreferences::setOverscrollBehaviorEnabled },
#if ENABLE(CSS_PAINTING_API)
        { "CSSPaintingAPIEnabled"_s, &WebPreferences::setCSSPaintingAPIEnabled },
#endif
        { "CSSRelativeColorSyntaxEnabled"_s, &WebPreferences::setCSSRelativeColorSyntaxEnabled },
        { "CSSScrollAnchoringEnabled"_s, &WebPreferences::setCSSScrollAnchoringEnabled },
        { "SpringTimingFunctionEnabled"_s, &WebPreferences::setSpringTimingFunctionEnabled },
#if ENABLE(CSS_TYPED_OM)
        { "CSSTypedOMEnabled"_s, &WebPreferences::setCSSTypedOMEnabled },
#endif
        { "CSSColorContrastEnabled"_s, &WebPreferences::setCSSColorContrastEnabled },
        { "CSSColorMixEnabled"_s, &WebPreferences::setCSSColorMixEnabled },
        { "OverflowClipEnabled"_s, &WebPreferences::setOverflowClipEnabled },
        { "SubgridEnabled"_s, &WebPreferences::setSubgridEnabled },
        { "CSSTextAlignLastEnabled"_s, &WebPreferences::setCSSTextAlignLastEnabled },
        { "CSSTextJustifyEnabled"_s, &WebPreferences::setCSSTextJustifyEnabled },
        { "CSSOMViewSmoothScrollingEnabled"_s, &WebPreferences::setCSSOMViewSmoothScrollingEnabled },
        { "CanvasColorSpaceEnabled"_s, &WebPreferences::setCanvasColorSpaceEnabled },
        { "CompressionStreamEnabled"_s, &WebPreferences::setCompressionStreamEnabled },
        { "ContactPickerAPIEnabled"_s, &WebPreferences::setContactPickerAPIEnabled },
        { "CrossOriginEmbedderPolicyEnabled"_s, &WebPreferences::setCrossOriginEmbedderPolicyEnabled },
        { "CrossOriginOpenerPolicyEnabled"_s, &WebPreferences::setCrossOriginOpenerPolicyEnabled },
        { "ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint"_s, &WebPreferences::setShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint },
        { "DialogElementEnabled"_s, &WebPreferences::setDialogElementEnabled },
        { "IsThirdPartyCookieBlockingDisabled"_s, &WebPreferences::setIsThirdPartyCookieBlockingDisabled },
#if HAVE(CELESTIAL)
        { "DisableMediaExperiencePIDInheritance"_s, &WebPreferences::setDisableMediaExperiencePIDInheritance },
#endif
        { "IsFirstPartyWebsiteDataRemovalDisabled"_s, &WebPreferences::setIsFirstPartyWebsiteDataRemovalDisabled },
        { "DisallowSyncXHRDuringPageDismissalEnabled"_s, &WebPreferences::setDisallowSyncXHRDuringPageDismissalEnabled },
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        { "MediaSessionCoordinatorEnabled"_s, &WebPreferences::setMediaSessionCoordinatorEnabled },
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
        { "MediaSessionPlaylistEnabled"_s, &WebPreferences::setMediaSessionPlaylistEnabled },
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
        { "MediaSourceInlinePaintingEnabled"_s, &WebPreferences::setMediaSourceInlinePaintingEnabled },
#endif
#if HAVE(NETWORK_LOADER)
        { "CFNetworkNetworkLoaderEnabled"_s, &WebPreferences::setCFNetworkNetworkLoaderEnabled },
#endif
        { "FTPEnabled"_s, &WebPreferences::setFTPEnabled },
        { "FetchAPIKeepAliveEnabled"_s, &WebPreferences::setFetchAPIKeepAliveEnabled },
        { "FetchMetadataEnabled"_s, &WebPreferences::setFetchMetadataEnabled },
        { "FileSystemAccessEnabled"_s, &WebPreferences::setFileSystemAccessEnabled },
        { "RequestSubmitEnabled"_s, &WebPreferences::setRequestSubmitEnabled },
#if ENABLE(GPU_PROCESS)
        { "UseGPUProcessForDOMRenderingEnabled"_s, &WebPreferences::setUseGPUProcessForDOMRenderingEnabled },
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
        { "UseGPUProcessForDisplayCapture"_s, &WebPreferences::setUseGPUProcessForDisplayCapture },
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "UseGPUProcessForWebGLEnabled"_s, &WebPreferences::setUseGPUProcessForWebGLEnabled },
#endif
#if ENABLE(VIDEO)
        { "GenericCueAPIEnabled"_s, &WebPreferences::setGenericCueAPIEnabled },
#endif
        { "HDRMediaCapabilitiesEnabled"_s, &WebPreferences::setHDRMediaCapabilitiesEnabled },
#if ENABLE(MODEL_ELEMENT)
        { "ModelElementEnabled"_s, &WebPreferences::setModelElementEnabled },
#endif
#if ENABLE(MODEL_ELEMENT)
        { "ModelDocumentEnabled"_s, &WebPreferences::setModelDocumentEnabled },
#endif
        { "HighlightAPIEnabled"_s, &WebPreferences::setHighlightAPIEnabled },
        { "ImageBitmapEnabled"_s, &WebPreferences::setImageBitmapEnabled },
        { "InProcessCookieCacheEnabled"_s, &WebPreferences::setInProcessCookieCacheEnabled },
        { "IntersectionObserverEnabled"_s, &WebPreferences::setIntersectionObserverEnabled },
        { "IsLoggedInAPIEnabled"_s, &WebPreferences::setIsLoggedInAPIEnabled },
        { "LazyIframeLoadingEnabled"_s, &WebPreferences::setLazyIframeLoadingEnabled },
        { "LazyImageLoadingEnabled"_s, &WebPreferences::setLazyImageLoadingEnabled },
        { "LinkSanitizerEnabled"_s, &WebPreferences::setLinkSanitizerEnabled },
        { "LinkPreloadResponsiveImagesEnabled"_s, &WebPreferences::setLinkPreloadResponsiveImagesEnabled },
        { "LinkPrefetchEnabled"_s, &WebPreferences::setLinkPrefetchEnabled },
#if ENABLE(WEBGL) || ENABLE(WEBGL2)
        { "MaskWebGLStringsEnabled"_s, &WebPreferences::setMaskWebGLStringsEnabled },
#endif
        { "CoreMathMLEnabled"_s, &WebPreferences::setCoreMathMLEnabled },
        { "MediaCapabilitiesExtensionsEnabled"_s, &WebPreferences::setMediaCapabilitiesExtensionsEnabled },
#if ENABLE(MEDIA_SESSION)
        { "MediaSessionEnabled"_s, &WebPreferences::setMediaSessionEnabled },
#endif
#if ENABLE(MEDIA_RECORDER)
        { "MediaRecorderEnabled"_s, &WebPreferences::setMediaRecorderEnabled },
#endif
#if HAVE(NSURLSESSION_WEBSOCKET)
        { "IsNSURLSessionWebSocketEnabled"_s, &WebPreferences::setIsNSURLSessionWebSocketEnabled },
#endif
#if ENABLE(OPUS)
        { "OpusDecoderEnabled"_s, &WebPreferences::setOpusDecoderEnabled },
#endif
        { "PaintTimingEnabled"_s, &WebPreferences::setPaintTimingEnabled },
        { "PerformanceNavigationTimingAPIEnabled"_s, &WebPreferences::setPerformanceNavigationTimingAPIEnabled },
        { "PerformanceResourceTimingSensitivePropertiesEnabled"_s, &WebPreferences::setPerformanceResourceTimingSensitivePropertiesEnabled },
        { "PermissionsAPIEnabled"_s, &WebPreferences::setPermissionsAPIEnabled },
        { "PreferPageRenderingUpdatesNear60FPSEnabled"_s, &WebPreferences::setPreferPageRenderingUpdatesNear60FPSEnabled },
        { "PrivateClickMeasurementDebugModeEnabled"_s, &WebPreferences::setPrivateClickMeasurementDebugModeEnabled },
        { "PrivateClickMeasurementFraudPreventionEnabled"_s, &WebPreferences::setPrivateClickMeasurementFraudPreventionEnabled },
#if ENABLE(SERVICE_WORKER)
        { "PushAPIEnabled"_s, &WebPreferences::setPushAPIEnabled },
#endif
        { "GoogleAntiFlickerOptimizationQuirkEnabled"_s, &WebPreferences::setGoogleAntiFlickerOptimizationQuirkEnabled },
        { "ReadableByteStreamAPIEnabled"_s, &WebPreferences::setReadableByteStreamAPIEnabled },
        { "ReferrerPolicyAttributeEnabled"_s, &WebPreferences::setReferrerPolicyAttributeEnabled },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "RemotePlaybackEnabled"_s, &WebPreferences::setRemotePlaybackEnabled },
#endif
        { "RequestVideoFrameCallbackEnabled"_s, &WebPreferences::setRequestVideoFrameCallbackEnabled },
        { "ResizeObserverEnabled"_s, &WebPreferences::setResizeObserverEnabled },
        { "ResolutionMediaFeatureEnabled"_s, &WebPreferences::setResolutionMediaFeatureEnabled },
        { "SKAttributionEnabled"_s, &WebPreferences::setSKAttributionEnabled },
        { "IsSameSiteStrictEnforcementEnabled"_s, &WebPreferences::setIsSameSiteStrictEnforcementEnabled },
#if ENABLE(MEDIA_STREAM)
        { "ScreenCaptureEnabled"_s, &WebPreferences::setScreenCaptureEnabled },
#endif
        { "ScrollToTextFragmentEnabled"_s, &WebPreferences::setScrollToTextFragmentEnabled },
        { "ServerTimingEnabled"_s, &WebPreferences::setServerTimingEnabled },
#if ENABLE(SERVICE_WORKER)
        { "ServiceWorkerNavigationPreloadEnabled"_s, &WebPreferences::setServiceWorkerNavigationPreloadEnabled },
#endif
        { "SharedWorkerEnabled"_s, &WebPreferences::setSharedWorkerEnabled },
        { "SpeechRecognitionEnabled"_s, &WebPreferences::setSpeechRecognitionEnabled },
        { "StorageAPIEnabled"_s, &WebPreferences::setStorageAPIEnabled },
        { "ProcessSwapOnCrossSiteNavigationEnabled"_s, &WebPreferences::setProcessSwapOnCrossSiteNavigationEnabled },
        { "SyntheticEditingCommandsEnabled"_s, &WebPreferences::setSyntheticEditingCommandsEnabled },
        { "TrackConfigurationEnabled"_s, &WebPreferences::setTrackConfigurationEnabled },
        { "TransformStreamAPIEnabled"_s, &WebPreferences::setTransformStreamAPIEnabled },
        { "UserGesturePromisePropagationEnabled"_s, &WebPreferences::setUserGesturePromisePropagationEnabled },
#if ENABLE(VP9)
        { "VP9SWDecoderEnabledOnBattery"_s, &WebPreferences::setVP9SWDecoderEnabledOnBattery },
#endif
        { "VisualViewportAPIEnabled"_s, &WebPreferences::setVisualViewportAPIEnabled },
#if ENABLE(VORBIS)
        { "VorbisDecoderEnabled"_s, &WebPreferences::setVorbisDecoderEnabled },
#endif
        { "WebAPIsInShadowRealmEnabled"_s, &WebPreferences::setWebAPIsInShadowRealmEnabled },
        { "WebAnimationsCompositeOperationsEnabled"_s, &WebPreferences::setWebAnimationsCompositeOperationsEnabled },
        { "WebAnimationsCustomEffectsEnabled"_s, &WebPreferences::setWebAnimationsCustomEffectsEnabled },
        { "WebAnimationsCustomFrameRateEnabled"_s, &WebPreferences::setWebAnimationsCustomFrameRateEnabled },
        { "WebAnimationsIterationCompositeEnabled"_s, &WebPreferences::setWebAnimationsIterationCompositeEnabled },
        { "WebAnimationsMutableTimelinesEnabled"_s, &WebPreferences::setWebAnimationsMutableTimelinesEnabled },
#if ENABLE(WEB_AUTHN)
        { "WebAuthenticationEnabled"_s, &WebPreferences::setWebAuthenticationEnabled },
#endif
        { "WebLocksAPIEnabled"_s, &WebPreferences::setWebLocksAPIEnabled },
        { "WebShareFileAPIEnabled"_s, &WebPreferences::setWebShareFileAPIEnabled },
#if ENABLE(WEBASSEMBLY)
        { "WebAssemblyESMIntegrationEnabled"_s, &WebPreferences::setWebAssemblyESMIntegrationEnabled },
#endif
#if ENABLE(WEBGL2)
        { "WebGL2Enabled"_s, &WebPreferences::setWebGL2Enabled },
#endif
        { "WebGLDraftExtensionsEnabled"_s, &WebPreferences::setWebGLDraftExtensionsEnabled },
#if ENABLE(WEBGL) && PLATFORM(COCOA)
        { "WebGLUsingMetal"_s, &WebPreferences::setWebGLUsingMetal },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCEncodedTransformEnabled"_s, &WebPreferences::setWebRTCEncodedTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264LowLatencyEncoderEnabled"_s, &WebPreferences::setWebRTCH264LowLatencyEncoderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH265CodecEnabled"_s, &WebPreferences::setWebRTCH265CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformTCPSocketsEnabled"_s, &WebPreferences::setWebRTCPlatformTCPSocketsEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformUDPSocketsEnabled"_s, &WebPreferences::setWebRTCPlatformUDPSocketsEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSFrameTransformEnabled"_s, &WebPreferences::setWebRTCSFrameTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSocketsProxyingEnabled"_s, &WebPreferences::setWebRTCSocketsProxyingEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile0CodecEnabled"_s, &WebPreferences::setWebRTCVP9Profile0CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile2CodecEnabled"_s, &WebPreferences::setWebRTCVP9Profile2CodecEnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXRAugmentedRealityModuleEnabled"_s, &WebPreferences::setWebXRAugmentedRealityModuleEnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXREnabled"_s, &WebPreferences::setWebXREnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXRGamepadsModuleEnabled"_s, &WebPreferences::setWebXRGamepadsModuleEnabled },
#endif
#if ENABLE(WEBXR_HANDS)
        { "WebXRHandInputModuleEnabled"_s, &WebPreferences::setWebXRHandInputModuleEnabled },
#endif
        { "WheelEventGesturesBecomeNonBlocking"_s, &WebPreferences::setWheelEventGesturesBecomeNonBlocking },
        { "PassiveWheelListenersAsDefaultOnDocument"_s, &WebPreferences::setPassiveWheelListenersAsDefaultOnDocument },
        { "InertAttributeEnabled"_s, &WebPreferences::setInertAttributeEnabled },
        { "RequestIdleCallbackEnabled"_s, &WebPreferences::setRequestIdleCallbackEnabled },
    };

    for (auto& setter : setters) {
        if (key == setter.name) {
            (this->*setter.function)(value);
            return;
        }
    }
}

void WebPreferences::enableAllExperimentalFeatures()
{
    UpdateBatch batch(*this);
    setDirPseudoEnabled(true);
    setFocusVisibleEnabled(true);
    setHasPseudoClassEnabled(true);
    setPageAtRuleSupportEnabled(true);
    setAriaReflectionForElementReferencesEnabled(true);
    setAccessHandleEnabled(true);
    setAccessibilityObjectModelEnabled(true);
#if ENABLE(MEDIA_STREAM)
    setPerElementSpeakerSelectionEnabled(true);
#endif
#if ENABLE(MEDIA_STREAM)
    setExposeSpeakersEnabled(true);
#endif
    setAspectRatioOfImgFromWidthAndHeightEnabled(true);
    setAsyncClipboardAPIEnabled(true);
    setBlankAnchorTargetImpliesNoOpenerEnabled(true);
    setThirdPartyIframeRedirectBlockingEnabled(true);
    setBroadcastChannelEnabled(true);
    setBroadcastChannelOriginPartitioningEnabled(true);
#if ENABLE(BUILT_IN_NOTIFICATIONS)
    setBuiltInNotificationsEnabled(true);
#endif
    setCSS3DTransformInteroperabilityEnabled(true);
    setCSSCounterStyleAtRuleImageSymbolsEnabled(true);
    setCSSCounterStyleAtRulesEnabled(true);
    setAccentColorEnabled(true);
    setAspectRatioEnabled(true);
    setCSSCascadeLayersEnabled(true);
    setCSSColor4(true);
    setCSSContainIntrinsicSizeEnabled(true);
    setCSSContainerQueriesEnabled(true);
    setCSSContainmentEnabled(true);
    setCSSCustomPropertiesAndValuesEnabled(true);
    setCSSGradientInterpolationColorSpacesEnabled(true);
    setCSSGradientPremultipliedAlphaInterpolationEnabled(true);
    setCSSIndividualTransformPropertiesEnabled(true);
    setCSSInputSecurityEnabled(true);
    setCSSMotionPathEnabled(true);
    setOverscrollBehaviorEnabled(true);
#if ENABLE(CSS_PAINTING_API)
    setCSSPaintingAPIEnabled(true);
#endif
    setCSSRelativeColorSyntaxEnabled(true);
    setCSSScrollAnchoringEnabled(true);
    setSpringTimingFunctionEnabled(true);
#if ENABLE(CSS_TYPED_OM)
    setCSSTypedOMEnabled(true);
#endif
    setCSSColorContrastEnabled(true);
    setCSSColorMixEnabled(true);
    setOverflowClipEnabled(true);
    setSubgridEnabled(true);
    setCSSTextAlignLastEnabled(true);
    setCSSTextJustifyEnabled(true);
    setCSSOMViewSmoothScrollingEnabled(true);
    setCanvasColorSpaceEnabled(true);
    setCompressionStreamEnabled(true);
    setContactPickerAPIEnabled(true);
    setCrossOriginEmbedderPolicyEnabled(true);
    setCrossOriginOpenerPolicyEnabled(true);
    setShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint(true);
    setDialogElementEnabled(true);
    setIsThirdPartyCookieBlockingDisabled(true);
#if HAVE(CELESTIAL)
    setDisableMediaExperiencePIDInheritance(true);
#endif
    setIsFirstPartyWebsiteDataRemovalDisabled(true);
    setDisallowSyncXHRDuringPageDismissalEnabled(true);
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    setMediaSessionCoordinatorEnabled(true);
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
    setMediaSessionPlaylistEnabled(true);
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
    setMediaSourceInlinePaintingEnabled(true);
#endif
#if HAVE(NETWORK_LOADER)
    setCFNetworkNetworkLoaderEnabled(true);
#endif
    setFTPEnabled(true);
    setFetchAPIKeepAliveEnabled(true);
    setFetchMetadataEnabled(true);
    setFileSystemAccessEnabled(true);
    setRequestSubmitEnabled(true);
#if ENABLE(GPU_PROCESS)
    setUseGPUProcessForDOMRenderingEnabled(true);
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
    setUseGPUProcessForDisplayCapture(true);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
    setUseGPUProcessForWebGLEnabled(true);
#endif
#if ENABLE(VIDEO)
    setGenericCueAPIEnabled(true);
#endif
    setHDRMediaCapabilitiesEnabled(true);
#if ENABLE(MODEL_ELEMENT)
    setModelElementEnabled(true);
#endif
#if ENABLE(MODEL_ELEMENT)
    setModelDocumentEnabled(true);
#endif
    setHighlightAPIEnabled(true);
    setImageBitmapEnabled(true);
    setInProcessCookieCacheEnabled(true);
    setIntersectionObserverEnabled(true);
    setIsLoggedInAPIEnabled(true);
    setLazyIframeLoadingEnabled(true);
    setLazyImageLoadingEnabled(true);
    setLinkSanitizerEnabled(true);
    setLinkPreloadResponsiveImagesEnabled(true);
    setLinkPrefetchEnabled(true);
#if ENABLE(WEBGL) || ENABLE(WEBGL2)
    setMaskWebGLStringsEnabled(true);
#endif
    setCoreMathMLEnabled(true);
    setMediaCapabilitiesExtensionsEnabled(true);
#if ENABLE(MEDIA_SESSION)
    setMediaSessionEnabled(true);
#endif
#if ENABLE(MEDIA_RECORDER)
    setMediaRecorderEnabled(true);
#endif
#if HAVE(NSURLSESSION_WEBSOCKET)
    setIsNSURLSessionWebSocketEnabled(true);
#endif
#if ENABLE(OPUS)
    setOpusDecoderEnabled(true);
#endif
    setPaintTimingEnabled(true);
    setPerformanceNavigationTimingAPIEnabled(true);
    setPerformanceResourceTimingSensitivePropertiesEnabled(true);
    setPermissionsAPIEnabled(true);
    setPreferPageRenderingUpdatesNear60FPSEnabled(true);
    setPrivateClickMeasurementDebugModeEnabled(true);
    setPrivateClickMeasurementFraudPreventionEnabled(true);
#if ENABLE(SERVICE_WORKER)
    setPushAPIEnabled(true);
#endif
    setGoogleAntiFlickerOptimizationQuirkEnabled(true);
    setReadableByteStreamAPIEnabled(true);
    setReferrerPolicyAttributeEnabled(true);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    setRemotePlaybackEnabled(true);
#endif
    setRequestVideoFrameCallbackEnabled(true);
    setResizeObserverEnabled(true);
    setResolutionMediaFeatureEnabled(true);
    setSKAttributionEnabled(true);
    setIsSameSiteStrictEnforcementEnabled(true);
#if ENABLE(MEDIA_STREAM)
    setScreenCaptureEnabled(true);
#endif
    setScrollToTextFragmentEnabled(true);
    setServerTimingEnabled(true);
#if ENABLE(SERVICE_WORKER)
    setServiceWorkerNavigationPreloadEnabled(true);
#endif
    setSharedWorkerEnabled(true);
    setSpeechRecognitionEnabled(true);
    setStorageAPIEnabled(true);
    setProcessSwapOnCrossSiteNavigationEnabled(true);
    setSyntheticEditingCommandsEnabled(true);
    setTrackConfigurationEnabled(true);
    setTransformStreamAPIEnabled(true);
    setUserGesturePromisePropagationEnabled(true);
#if ENABLE(VP9)
    setVP9SWDecoderEnabledOnBattery(true);
#endif
    setVisualViewportAPIEnabled(true);
#if ENABLE(VORBIS)
    setVorbisDecoderEnabled(true);
#endif
    setWebAPIsInShadowRealmEnabled(true);
    setWebAnimationsCompositeOperationsEnabled(true);
    setWebAnimationsCustomEffectsEnabled(true);
    setWebAnimationsCustomFrameRateEnabled(true);
    setWebAnimationsIterationCompositeEnabled(true);
    setWebAnimationsMutableTimelinesEnabled(true);
#if ENABLE(WEB_AUTHN)
    setWebAuthenticationEnabled(true);
#endif
    setWebLocksAPIEnabled(true);
    setWebShareFileAPIEnabled(true);
#if ENABLE(WEBASSEMBLY)
    setWebAssemblyESMIntegrationEnabled(true);
#endif
#if ENABLE(WEBGL2)
    setWebGL2Enabled(true);
#endif
    setWebGLDraftExtensionsEnabled(true);
#if ENABLE(WEBGL) && PLATFORM(COCOA)
    setWebGLUsingMetal(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCEncodedTransformEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCH264LowLatencyEncoderEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCH265CodecEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCPlatformTCPSocketsEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCPlatformUDPSocketsEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCSFrameTransformEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCSocketsProxyingEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCVP9Profile0CodecEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCVP9Profile2CodecEnabled(true);
#endif
#if ENABLE(WEBXR)
    setWebXRAugmentedRealityModuleEnabled(true);
#endif
#if ENABLE(WEBXR)
    setWebXREnabled(true);
#endif
#if ENABLE(WEBXR)
    setWebXRGamepadsModuleEnabled(true);
#endif
#if ENABLE(WEBXR_HANDS)
    setWebXRHandInputModuleEnabled(true);
#endif
    setWheelEventGesturesBecomeNonBlocking(true);
    setPassiveWheelListenersAsDefaultOnDocument(true);
    setInertAttributeEnabled(true);
    setRequestIdleCallbackEnabled(true);
}

}
