/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings, _) {
  Drupal.behaviors.ckeditorStylesComboSettings = {
    attach: function attach(context) {
      var $context = $(context);
      var $ckeditorActiveToolbar = $context.find('.ckeditor-toolbar-configuration').find('.ckeditor-toolbar-active');
      var previousStylesSet = drupalSettings.ckeditor.hiddenCKEditorConfig.stylesSet;
      var that = this;
      $context.find('[name="editor[settings][plugins][stylescombo][styles]"]').on('blur.ckeditorStylesComboSettings', function () {
        var styles = this.value.trim();

        var stylesSet = that._generateStylesSetSetting(styles);

        if (!_.isEqual(previousStylesSet, stylesSet)) {
          previousStylesSet = stylesSet;
          $ckeditorActiveToolbar.trigger('CKEditorPluginSettingsChanged', [{
            stylesSet: stylesSet
          }]);
        }
      });
    },
    _generateStylesSetSetting: function _generateStylesSetSetting(styles) {
      var stylesSet = [];
      styles = styles.replace(/\r/g, '\n');
      var lines = styles.split('\n');

      for (var i = 0; i < lines.length; i++) {
        var style = lines[i].trim();

        if (style.length === 0) {
          continue;
        }

        if (style.match(/^ *[a-zA-Z0-9]+ *(\.[a-zA-Z0-9_-]+ *)*\| *.+ *$/) === null) {
          continue;
        }

        var parts = style.split('|');
        var selector = parts[0];
        var label = parts[1];
        var classes = selector.split('.');
        var element = classes.shift();
        stylesSet.push({
          attributes: {
            class: classes.join(' ')
          },
          element: element,
          name: label
        });
      }

      return stylesSet;
    }
  };
  Drupal.behaviors.ckeditorStylesComboSettingsSummary = {
    attach: function attach() {
      $('[data-ckeditor-plugin-id="stylescombo"]').drupalSetSummary(function (context) {
        var stylesElement = document.querySelector('[data-drupal-selector="edit-editor-settings-plugins-stylescombo-styles"]');
        var styles = stylesElement ? stylesElement.value.trim() : '';

        if (styles.length === 0) {
          return Drupal.t('No styles configured');
        }

        var count = styles.split('\n').length;
        return Drupal.t('@count styles configured', {
          '@count': count
        });
      });
    }
  };
})(jQuery, Drupal, drupalSettings, _);