"use strict";

var _events = require("events");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/* eslint-disable */
// transpiled typescript->javascript from
// https://github.com/aurelia/pal-nodejs/blob/master/src/polyfills/mutation-observer.ts

/*
 * Based on Shim for MutationObserver interface
 * Author: Graeme Yeates (github.com/megawac)
 * Repository: https://github.com/megawac/MutationObserver.js
 */
var __extends = void 0 && (void 0).__extends || function () {
  var extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };

  return function (d, b) {
    extendStatics(d, b);

    function __() {
      this.constructor = d;
    }

    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
}();

module.exports = {};
Object.defineProperty(module.exports, "__esModule", {
  value: true
});

var Util =
/** @class */
function () {
  function Util() {}

  Util.clone = function ($target, config) {
    var recurse = true; // set true so childList we'll always check the first level

    return function copy($target) {
      var elestruct = {
        /** @type {Node} */
        node: $target,
        charData: null,
        attr: null,
        kids: null
      }; // Store current character data of target text or comment node if the config requests
      // those properties to be observed.

      if (config.charData && ($target.nodeType === 3 || $target.nodeType === 8)) {
        elestruct.charData = $target.nodeValue;
      } else {
        // Add attr only if subtree is specified or top level and avoid if
        // attributes is a document object (#13).
        if (config.attr && recurse && $target.nodeType === 1) {
          /**
           * clone live attribute list to an object structure {name: val}
           * @type {Object.<string, string>}
           */
          elestruct.attr = Util.reduce($target.attributes, function (memo, attr) {
            if (!config.afilter || config.afilter[attr.name]) {
              memo[attr.name] = attr.value;
            }

            return memo;
          }, {});
        } // whether we should iterate the children of $target node


        if (recurse && (config.kids || config.charData || config.attr && config.descendents)) {
          /** @type {Array.<!Object>} : Array of custom clone */
          elestruct.kids = Util.map($target.childNodes, copy);
        }

        recurse = config.descendents;
      }

      return elestruct;
    }($target);
  };
  /**
   * indexOf an element in a collection of custom nodes
   *
   * @param {NodeList} set
   * @param {!Object} $node : A custom cloned nodeg333
   * @param {number} idx : index to start the loop
   * @return {number}
   */


  Util.indexOfCustomNode = function (set, $node, idx) {
    var JSCompiler_renameProperty = function (a) {
      return a;
    };

    return this.indexOf(set, $node, idx, JSCompiler_renameProperty("node"));
  };
  /**
   * Attempt to uniquely id an element for hashing. We could optimize this for legacy browsers but it hopefully wont be called enough to be a concern
   *
   * @param {Node} $ele
   * @return {(string|number)}
   */


  Util.getElementId = function ($ele) {
    try {
      return $ele.id || ($ele[this.expando] = $ele[this.expando] || this.counter++);
    } catch (e) {
      // ie <8 will throw if you set an unknown property on a text node
      try {
        return $ele.nodeValue; // naive
      } catch (shitie) {
        // when text node is removed: https://gist.github.com/megawac/8355978 :(
        return this.counter++;
      }
    }
  };
  /**
   * **map** Apply a mapping function to each item of a set
   * @param {Array|NodeList} set
   * @param {Function} iterator
   */


  Util.map = function (set, iterator) {
    var results = [];

    for (var index = 0; index < set.length; index++) {
      results[index] = iterator(set[index], index, set);
    }

    return results;
  };
  /**
   * **Reduce** builds up a single result from a list of values
   * @param {Array|NodeList|NamedNodeMap} set
   * @param {Function} iterator
   * @param {*} [memo] Initial value of the memo.
   */


  Util.reduce = function (set, iterator, memo) {
    for (var index = 0; index < set.length; index++) {
      memo = iterator(memo, set[index], index, set);
    }

    return memo;
  };
  /**
   * **indexOf** find index of item in collection.
   * @param {Array|NodeList} set
   * @param {Object} item
   * @param {number} idx
   * @param {string} [prop] Property on set item to compare to item
   */


  Util.indexOf = function (set, item, idx, prop) {
    for (;
    /*idx = ~~idx*/
    idx < set.length; idx++) {
      // start idx is always given as this is internal
      if ((prop ? set[idx][prop] : set[idx]) === item) return idx;
    }

    return -1;
  };
  /**
   * @param {Object} obj
   * @param {(string|number)} prop
   * @return {boolean}
   */


  Util.has = function (obj, prop) {
    return obj[prop] !== undefined; // will be nicely inlined by gcc
  };

  Util.counter = 1;
  Util.expando = "mo_id";
  return Util;
}();

module.exports.Util = Util;

var MutationObserver =
/** @class */
function () {
  function MutationObserver(listener) {
    var _this = this;

    this._watched = [];
    this._listener = null;
    this._period = 30;
    this._timeout = null;
    this._disposed = false;
    this._notifyListener = null;
    this._watched = [];
    this._listener = listener;
    this._period = 30;

    this._notifyListener = function () {
      _this.scheduleMutationCheck(_this);
    };
  }

  MutationObserver.prototype.observe = function ($target, config) {
    var settings = {
      attr: !!(config.attributes || config.attributeFilter || config.attributeOldValue),
      // some browsers enforce that subtree must be set with childList, attributes or characterData.
      // We don't care as spec doesn't specify this rule.
      kids: !!config.childList,
      descendents: !!config.subtree,
      charData: !!(config.characterData || config.characterDataOldValue),
      afilter: null
    };
    MutationNotifier.getInstance().on("changed", this._notifyListener);
    var watched = this._watched; // remove already observed target element from pool

    for (var i = 0; i < watched.length; i++) {
      if (watched[i].tar === $target) watched.splice(i, 1);
    }

    if (config.attributeFilter) {
      /**
       * converts to a {key: true} dict for faster lookup
       * @type {Object.<String,Boolean>}
       */
      settings.afilter = Util.reduce(config.attributeFilter, function (a, b) {
        a[b] = true;
        return a;
      }, {});
    }

    watched.push({
      tar: $target,
      fn: this.createMutationSearcher($target, settings)
    });
  };

  MutationObserver.prototype.takeRecords = function () {
    var mutations = [];
    var watched = this._watched;

    for (var i = 0; i < watched.length; i++) {
      watched[i].fn(mutations);
    }

    return mutations;
  };

  MutationObserver.prototype.disconnect = function () {
    this._watched = []; // clear the stuff being observed

    MutationNotifier.getInstance().removeListener("changed", this._notifyListener);
    this._disposed = true;
    clearTimeout(this._timeout); // ready for garbage collection

    this._timeout = null;
  };

  MutationObserver.prototype.createMutationSearcher = function ($target, config) {
    var _this = this;
    /** type {Elestuct} */


    var $oldstate = Util.clone($target, config); // create the cloned datastructure

    /**
     * consumes array of mutations we can push to
     *
     * @param {Array.<MutationRecord>} mutations
     */

    return function (mutations) {
      var olen = mutations.length;
      var dirty;

      if (config.charData && $target.nodeType === 3 && $target.nodeValue !== $oldstate.charData) {
        mutations.push(new MutationRecord({
          type: "characterData",
          target: $target,
          oldValue: $oldstate.charData
        }));
      } // Alright we check base level changes in attributes... easy


      if (config.attr && $oldstate.attr) {
        _this.findAttributeMutations(mutations, $target, $oldstate.attr, config.afilter);
      } // check childlist or subtree for mutations


      if (config.kids || config.descendents) {
        dirty = _this.searchSubtree(mutations, $target, $oldstate, config);
      } // reclone data structure if theres changes


      if (dirty || mutations.length !== olen) {
        /** type {Elestuct} */
        $oldstate = Util.clone($target, config);
      }
    };
  };

  MutationObserver.prototype.scheduleMutationCheck = function (observer) {
    var _this = this; // Only schedule if there isn't already a timer.


    if (!observer._timeout) {
      observer._timeout = setTimeout(function () {
        return _this.mutationChecker(observer);
      }, this._period);
    }
  };

  MutationObserver.prototype.mutationChecker = function (observer) {
    // allow scheduling a new timer.
    observer._timeout = null;
    var mutations = observer.takeRecords();

    if (mutations.length) {
      // fire away
      // calling the listener with context is not spec but currently consistent with FF and WebKit
      observer._listener(mutations, observer);
    }
  };

  MutationObserver.prototype.searchSubtree = function (mutations, $target, $oldstate, config) {
    var _this = this; // Track if the tree is dirty and has to be recomputed (#14).


    var dirty;
    /*
     * Helper to identify node rearrangment and stuff...
     * There is no gaurentee that the same node will be identified for both added and removed nodes
     * if the positions have been shuffled.
     * conflicts array will be emptied by end of operation
     */

    var _resolveConflicts = function (conflicts, node, $kids, $oldkids, numAddedNodes) {
      // the distance between the first conflicting node and the last
      var distance = conflicts.length - 1; // prevents same conflict being resolved twice consider when two nodes switch places.
      // only one should be given a mutation event (note -~ is used as a math.ceil shorthand)

      var counter = -~((distance - numAddedNodes) / 2);
      var $cur;
      var oldstruct;
      var conflict;

      while (conflict = conflicts.pop()) {
        $cur = $kids[conflict.i];
        oldstruct = $oldkids[conflict.j]; // attempt to determine if there was node rearrangement... won't gaurentee all matches
        // also handles case where added/removed nodes cause nodes to be identified as conflicts

        if (config.kids && counter && Math.abs(conflict.i - conflict.j) >= distance) {
          mutations.push(new MutationRecord({
            type: "childList",
            target: node,
            addedNodes: [$cur],
            removedNodes: [$cur],
            // haha don't rely on this please
            nextSibling: $cur.nextSibling,
            previousSibling: $cur.previousSibling
          }));
          counter--; // found conflict
        } // Alright we found the resorted nodes now check for other types of mutations


        if (config.attr && oldstruct.attr) _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);

        if (config.charData && $cur.nodeType === 3 && $cur.nodeValue !== oldstruct.charData) {
          mutations.push(new MutationRecord({
            type: "characterData",
            target: $cur,
            oldValue: oldstruct.charData
          }));
        } // now look @ subtree


        if (config.descendents) _findMutations($cur, oldstruct);
      }
    };
    /**
     * Main worker. Finds and adds mutations if there are any
     * @param {Node} node
     * @param {!Object} old : A cloned data structure using internal clone
     */


    var _findMutations = function (node, old) {
      var $kids = node.childNodes;
      var $oldkids = old.kids;
      var klen = $kids.length; // $oldkids will be undefined for text and comment nodes

      var olen = $oldkids ? $oldkids.length : 0; // if (!olen && !klen) return; // both empty; clearly no changes
      // we delay the intialization of these for marginal performance in the expected case (actually quite signficant on large subtrees when these would be otherwise unused)
      // map of checked element of ids to prevent registering the same conflict twice

      var map; // array of potential conflicts (ie nodes that may have been re arranged)

      var conflicts;
      var id; // element id from getElementId helper

      var idx; // index of a moved or inserted element

      var oldstruct; // current and old nodes

      var $cur;
      var $old; // track the number of added nodes so we can resolve conflicts more accurately

      var numAddedNodes = 0; // iterate over both old and current child nodes at the same time

      var i = 0;
      var j = 0; // while there is still anything left in $kids or $oldkids (same as i < $kids.length || j < $oldkids.length;)

      while (i < klen || j < olen) {
        // current and old nodes at the indexs
        $cur = $kids[i];
        oldstruct = $oldkids[j];
        $old = oldstruct && oldstruct.node;

        if ($cur === $old) {
          // expected case - optimized for this case
          // check attributes as specified by config
          if (config.attr && oldstruct.attr) {
            /* oldstruct.attr instead of textnode check */
            _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
          } // check character data if node is a comment or textNode and it's being observed


          if (config.charData && oldstruct.charData !== undefined && $cur.nodeValue !== oldstruct.charData) {
            mutations.push(new MutationRecord({
              type: "characterData",
              target: $cur
            }));
          } // resolve conflicts; it will be undefined if there are no conflicts - otherwise an array


          if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes); // recurse on next level of children. Avoids the recursive call when there are no children left to iterate

          if (config.descendents && ($cur.childNodes.length || oldstruct.kids && oldstruct.kids.length)) _findMutations($cur, oldstruct);
          i++;
          j++;
        } else {
          // (uncommon case) lookahead until they are the same again or the end of children
          dirty = true;

          if (!map) {
            // delayed initalization (big perf benefit)
            map = {};
            conflicts = [];
          }

          if ($cur) {
            // check id is in the location map otherwise do a indexOf search
            if (!map[id = Util.getElementId($cur)]) {
              // to prevent double checking
              // mark id as found
              map[id] = true; // custom indexOf using comparitor checking oldkids[i].node === $cur

              if ((idx = Util.indexOfCustomNode($oldkids, $cur, j)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: "childList",
                    target: node,
                    addedNodes: [$cur],
                    nextSibling: $cur.nextSibling,
                    previousSibling: $cur.previousSibling
                  }));
                  numAddedNodes++;
                }
              } else {
                conflicts.push({
                  i: i,
                  j: idx
                });
              }
            }

            i++;
          }

          if ($old && // special case: the changes may have been resolved: i and j appear congurent so we can continue using the expected case
          $old !== $kids[i]) {
            if (!map[id = Util.getElementId($old)]) {
              map[id] = true;

              if ((idx = Util.indexOf($kids, $old, i)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: "childList",
                    target: old.node,
                    removedNodes: [$old],
                    nextSibling: $oldkids[j + 1],
                    previousSibling: $oldkids[j - 1]
                  }));
                  numAddedNodes--;
                }
              } else {
                conflicts.push({
                  i: idx,
                  j: j
                });
              }
            }

            j++;
          }
        } // end uncommon case

      } // end loop
      // resolve any remaining conflicts


      if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
    };

    _findMutations($target, $oldstate);

    return dirty;
  };

  MutationObserver.prototype.findAttributeMutations = function (mutations, $target, $oldstate, filter) {
    var checked = {};
    var attributes = $target.attributes;
    var attr;
    var name;
    var i = attributes.length;

    while (i--) {
      attr = attributes[i];
      name = attr.name;

      if (!filter || Util.has(filter, name)) {
        if (attr.value !== $oldstate[name]) {
          // The pushing is redundant but gzips very nicely
          mutations.push(new MutationRecord({
            type: "attributes",
            target: $target,
            attributeName: name,
            oldValue: $oldstate[name],
            attributeNamespace: attr.namespaceURI // in ie<8 it incorrectly will return undefined

          }));
        }

        checked[name] = true;
      }
    }

    for (name in $oldstate) {
      if (!checked[name]) {
        mutations.push(new MutationRecord({
          target: $target,
          type: "attributes",
          attributeName: name,
          oldValue: $oldstate[name]
        }));
      }
    }
  };

  return MutationObserver;
}();

module.exports.MutationObserver = MutationObserver;

var MutationRecord =
/** @class */
function () {
  function MutationRecord(data) {
    var settings = {
      type: null,
      target: null,
      addedNodes: [],
      removedNodes: [],
      previousSibling: null,
      nextSibling: null,
      attributeName: null,
      attributeNamespace: null,
      oldValue: null
    };

    for (var prop in data) {
      if (Util.has(settings, prop) && data[prop] !== undefined) settings[prop] = data[prop];
    }

    return settings;
  }

  return MutationRecord;
}();

module.exports.MutationRecord = MutationRecord;

var MutationNotifier =
/** @class */
function (_super) {
  __extends(MutationNotifier, _super);

  function MutationNotifier() {
    var _this = _super.call(this) || this;

    _this.setMaxListeners(100);

    return _this;
  }

  MutationNotifier.getInstance = function () {
    if (!MutationNotifier._instance) {
      MutationNotifier._instance = new MutationNotifier();
    }

    return MutationNotifier._instance;
  };

  MutationNotifier.prototype.destruct = function () {
    this.removeAllListeners("changed");
  };

  MutationNotifier.prototype.notifyChanged = function (node) {
    this.emit("changed", node);
  };

  MutationNotifier._instance = null;
  return MutationNotifier;
}(_events.EventEmitter);

module.exports.MutationNotifier = MutationNotifier;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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