// Generated from libavfilter/opencl/deshake.cl
const char *ff_opencl_source_deshake =
"#line 1 \"libavfilter/opencl/deshake.cl\"\n"
"/*\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" *\n"
" * Copyright (C) 2000, Intel Corporation, all rights reserved.\n"
" * Copyright (C) 2013, OpenCV Foundation, all rights reserved.\n"
" * Third party copyrights are property of their respective owners.\n"
" *\n"
" * Redistribution and use in source and binary forms, with or without modification,\n"
" * are permitted provided that the following conditions are met:\n"
" *\n"
" *   * Redistribution's of source code must retain the above copyright notice,\n"
" *     this list of conditions and the following disclaimer.\n"
" *\n"
" *   * Redistribution's in binary form must reproduce the above copyright notice,\n"
" *     this list of conditions and the following disclaimer in the documentation\n"
" *     and/or other materials provided with the distribution.\n"
" *\n"
" *   * The name of the copyright holders may not be used to endorse or promote products\n"
" *     derived from this software without specific prior written permission.\n"
" *\n"
" * This software is provided by the copyright holders and contributors \"as is\" and\n"
" * any express or implied warranties, including, but not limited to, the implied\n"
" * warranties of merchantability and fitness for a particular purpose are disclaimed.\n"
" * In no event shall the Intel Corporation or contributors be liable for any direct,\n"
" * indirect, incidental, special, exemplary, or consequential damages\n"
" * (including, but not limited to, procurement of substitute goods or services;\n"
" * loss of use, data, or profits; or business interruption) however caused\n"
" * and on any theory of liability, whether in contract, strict liability,\n"
" * or tort (including negligence or otherwise) arising in any way out of\n"
" * the use of this software, even if advised of the possibility of such damage.\n"
" */\n"
"\n"
"#define HARRIS_THRESHOLD 3.0f\n"
"// Block size over which to compute harris response\n"
"//\n"
"// Note that changing this will require fiddling with the local array sizes in\n"
"// harris_response\n"
"#define HARRIS_RADIUS 2\n"
"#define DISTANCE_THRESHOLD 80\n"
"\n"
"// Sub-pixel refinement window for feature points\n"
"#define REFINE_WIN_HALF_W 5\n"
"#define REFINE_WIN_HALF_H 5\n"
"#define REFINE_WIN_W 11 // REFINE_WIN_HALF_W * 2 + 1\n"
"#define REFINE_WIN_H 11\n"
"\n"
"// Non-maximum suppression window size\n"
"#define NONMAX_WIN 30\n"
"#define NONMAX_WIN_HALF 15 // NONMAX_WIN / 2\n"
"\n"
"typedef struct PointPair {\n"
"    // Previous frame\n"
"    float2 p1;\n"
"    // Current frame\n"
"    float2 p2;\n"
"} PointPair;\n"
"\n"
"typedef struct SmoothedPointPair {\n"
"    // Non-smoothed point in current frame\n"
"    int2 p1;\n"
"    // Smoothed point in current frame\n"
"    float2 p2;\n"
"} SmoothedPointPair;\n"
"\n"
"typedef struct MotionVector {\n"
"    PointPair p;\n"
"    // Used to mark vectors as potential outliers\n"
"    int should_consider;\n"
"} MotionVector;\n"
"\n"
"const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE |\n"
"                          CLK_ADDRESS_CLAMP_TO_EDGE |\n"
"                          CLK_FILTER_NEAREST;\n"
"\n"
"const sampler_t sampler_linear = CLK_NORMALIZED_COORDS_FALSE |\n"
"                          CLK_ADDRESS_CLAMP_TO_EDGE |\n"
"                          CLK_FILTER_LINEAR;\n"
"\n"
"const sampler_t sampler_linear_mirror = CLK_NORMALIZED_COORDS_TRUE |\n"
"                          CLK_ADDRESS_MIRRORED_REPEAT |\n"
"                          CLK_FILTER_LINEAR;\n"
"\n"
"// Writes to a 1D array at loc, treating it as a 2D array with the same\n"
"// dimensions as the global work size.\n"
"static void write_to_1d_arrf(__global float *buf, int2 loc, float val) {\n"
"    buf[loc.x + loc.y * get_global_size(0)] = val;\n"
"}\n"
"\n"
"static void write_to_1d_arrul8(__global ulong8 *buf, int2 loc, ulong8 val) {\n"
"    buf[loc.x + loc.y * get_global_size(0)] = val;\n"
"}\n"
"\n"
"static void write_to_1d_arrvec(__global MotionVector *buf, int2 loc, MotionVector val) {\n"
"    buf[loc.x + loc.y * get_global_size(0)] = val;\n"
"}\n"
"\n"
"static void write_to_1d_arrf2(__global float2 *buf, int2 loc, float2 val) {\n"
"    buf[loc.x + loc.y * get_global_size(0)] = val;\n"
"}\n"
"\n"
"static ulong8 read_from_1d_arrul8(__global const ulong8 *buf, int2 loc) {\n"
"    return buf[loc.x + loc.y * get_global_size(0)];\n"
"}\n"
"\n"
"static float2 read_from_1d_arrf2(__global const float2 *buf, int2 loc) {\n"
"    return buf[loc.x + loc.y * get_global_size(0)];\n"
"}\n"
"\n"
"// Returns the grayscale value at the given point.\n"
"static float pixel_grayscale(__read_only image2d_t src, int2 loc) {\n"
"    float4 pixel = read_imagef(src, sampler, loc);\n"
"    return (pixel.x + pixel.y + pixel.z) / 3.0f;\n"
"}\n"
"\n"
"static float convolve(\n"
"    __local const float *grayscale,\n"
"    int local_idx_x,\n"
"    int local_idx_y,\n"
"    float mask[3][3]\n"
") {\n"
"    float ret = 0;\n"
"\n"
"    // These loops touch each pixel surrounding loc as well as loc itself\n"
"    for (int i = 1, i2 = 0; i >= -1; --i, ++i2) {\n"
"        for (int j = -1, j2 = 0; j <= 1; ++j, ++j2) {\n"
"            ret += mask[i2][j2] * grayscale[(local_idx_x + 3 + j) + (local_idx_y + 3 + i) * 14];\n"
"        }\n"
"    }\n"
"\n"
"    return ret;\n"
"}\n"
"\n"
"// Sums dx * dy for all pixels within radius of loc\n"
"static float sum_deriv_prod(\n"
"    __local const float *grayscale,\n"
"    float mask_x[3][3],\n"
"    float mask_y[3][3]\n"
") {\n"
"    float ret = 0;\n"
"\n"
"    for (int i = HARRIS_RADIUS; i >= -HARRIS_RADIUS; --i) {\n"
"        for (int j = -HARRIS_RADIUS; j <= HARRIS_RADIUS; ++j) {\n"
"            ret += convolve(grayscale, get_local_id(0) + j, get_local_id(1) + i, mask_x) *\n"
"                   convolve(grayscale, get_local_id(0) + j, get_local_id(1) + i, mask_y);\n"
"        }\n"
"    }\n"
"\n"
"    return ret;\n"
"}\n"
"\n"
"// Sums d<>^2 (determined by mask) for all pixels within radius of loc\n"
"static float sum_deriv_pow(__local const float *grayscale, float mask[3][3])\n"
"{\n"
"    float ret = 0;\n"
"\n"
"    for (int i = HARRIS_RADIUS; i >= -HARRIS_RADIUS; --i) {\n"
"        for (int j = -HARRIS_RADIUS; j <= HARRIS_RADIUS; ++j) {\n"
"            float deriv = convolve(grayscale, get_local_id(0) + j, get_local_id(1) + i, mask);\n"
"            ret += deriv * deriv;\n"
"        }\n"
"    }\n"
"\n"
"    return ret;\n"
"}\n"
"\n"
"// Fills a box with the given radius and pixel around loc\n"
"static void draw_box(__write_only image2d_t dst, int2 loc, float4 pixel, int radius)\n"
"{\n"
"    for (int i = -radius; i <= radius; ++i) {\n"
"        for (int j = -radius; j <= radius; ++j) {\n"
"            write_imagef(\n"
"                dst,\n"
"                (int2)(\n"
"                    // Clamp to avoid writing outside image bounds\n"
"                    clamp(loc.x + i, 0, get_image_dim(dst).x - 1),\n"
"                    clamp(loc.y + j, 0, get_image_dim(dst).y - 1)\n"
"                ),\n"
"                pixel\n"
"            );\n"
"        }\n"
"    }\n"
"}\n"
"\n"
"// Converts the src image to grayscale\n"
"__kernel void grayscale(\n"
"    __read_only image2d_t src,\n"
"    __write_only image2d_t grayscale\n"
") {\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"    write_imagef(grayscale, loc, (float4)(pixel_grayscale(src, loc), 0.0f, 0.0f, 1.0f));\n"
"}\n"
"\n"
"// This kernel computes the harris response for the given grayscale src image\n"
"// within the given radius and writes it to harris_buf\n"
"__kernel void harris_response(\n"
"    __read_only image2d_t grayscale,\n"
"    __global float *harris_buf\n"
") {\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    if (loc.x > get_image_width(grayscale) - 1 || loc.y > get_image_height(grayscale) - 1) {\n"
"        write_to_1d_arrf(harris_buf, loc, 0);\n"
"        return;\n"
"    }\n"
"\n"
"    float scale = 1.0f / ((1 << 2) * HARRIS_RADIUS * 255.0f);\n"
"\n"
"    float sobel_mask_x[3][3] = {\n"
"        {-1, 0, 1},\n"
"        {-2, 0, 2},\n"
"        {-1, 0, 1}\n"
"    };\n"
"\n"
"    float sobel_mask_y[3][3] = {\n"
"        { 1,  2,  1},\n"
"        { 0,  0,  0},\n"
"        {-1, -2, -1}\n"
"    };\n"
"\n"
"    // 8 x 8 local work + 3 pixels around each side (needed to accomodate for the\n"
"    // block size radius of 2)\n"
"    __local float grayscale_data[196];\n"
"\n"
"    int idx = get_group_id(0) * get_local_size(0);\n"
"    int idy = get_group_id(1) * get_local_size(1);\n"
"\n"
"    for (int i = idy - 3, it = 0; i < idy + (int)get_local_size(1) + 3; i++, it++) {\n"
"        for (int j = idx - 3, jt = 0; j < idx + (int)get_local_size(0) + 3; j++, jt++) {\n"
"            grayscale_data[jt + it * 14] = read_imagef(grayscale, sampler, (int2)(j, i)).x;\n"
"        }\n"
"    }\n"
"\n"
"    barrier(CLK_LOCAL_MEM_FENCE);\n"
"\n"
"    float sumdxdy = sum_deriv_prod(grayscale_data, sobel_mask_x, sobel_mask_y);\n"
"    float sumdx2 = sum_deriv_pow(grayscale_data, sobel_mask_x);\n"
"    float sumdy2 = sum_deriv_pow(grayscale_data, sobel_mask_y);\n"
"\n"
"    float trace = sumdx2 + sumdy2;\n"
"    // r = det(M) - k(trace(M))^2\n"
"    // k usually between 0.04 to 0.06\n"
"    float r = (sumdx2 * sumdy2 - sumdxdy * sumdxdy) - 0.04f * (trace * trace) * pown(scale, 4);\n"
"\n"
"    // Threshold the r value\n"
"    harris_buf[loc.x + loc.y * get_image_width(grayscale)] = r * step(HARRIS_THRESHOLD, r);\n"
"}\n"
"\n"
"// Gets a patch centered around a float coordinate from a grayscale image using\n"
"// bilinear interpolation\n"
"static void get_rect_sub_pix(\n"
"    __read_only image2d_t grayscale,\n"
"    float *buffer,\n"
"    int size_x,\n"
"    int size_y,\n"
"    float2 center\n"
") {\n"
"    float2 offset = ((float2)(size_x, size_y) - 1.0f) * 0.5f;\n"
"\n"
"    for (int i = 0; i < size_y; i++) {\n"
"        for (int j = 0; j < size_x; j++) {\n"
"            buffer[i * size_x + j] = read_imagef(\n"
"                grayscale,\n"
"                sampler_linear,\n"
"                (float2)(j, i) + center - offset\n"
"            ).x * 255.0f;\n"
"        }\n"
"    }\n"
"}\n"
"\n"
"// Refines detected features at a sub-pixel level\n"
"//\n"
"// This function is ported from OpenCV\n"
"static float2 corner_sub_pix(\n"
"    __read_only image2d_t grayscale,\n"
"    float2 feature,\n"
"    float *mask\n"
") {\n"
"    float2 init = feature;\n"
"    int src_width = get_global_size(0);\n"
"    int src_height = get_global_size(1);\n"
"\n"
"    const int max_iters = 40;\n"
"    const float eps = 0.001f * 0.001f;\n"
"    int i, j, k;\n"
"\n"
"    int iter = 0;\n"
"    float err = 0;\n"
"    float subpix[(REFINE_WIN_W + 2) * (REFINE_WIN_H + 2)];\n"
"    const float flt_epsilon = 0x1.0p-23f;\n"
"\n"
"    do {\n"
"        float2 feature_tmp;\n"
"        float a = 0, b = 0, c = 0, bb1 = 0, bb2 = 0;\n"
"\n"
"        get_rect_sub_pix(grayscale, subpix, REFINE_WIN_W + 2, REFINE_WIN_H + 2, feature);\n"
"        float *subpix_ptr = subpix;\n"
"        subpix_ptr += REFINE_WIN_W + 2 + 1;\n"
"\n"
"        // process gradient\n"
"        for (i = 0, k = 0; i < REFINE_WIN_H; i++, subpix_ptr += REFINE_WIN_W + 2) {\n"
"            float py = i - REFINE_WIN_HALF_H;\n"
"\n"
"            for (j = 0; j < REFINE_WIN_W; j++, k++) {\n"
"                float m = mask[k];\n"
"                float tgx = subpix_ptr[j + 1] - subpix_ptr[j - 1];\n"
"                float tgy = subpix_ptr[j + REFINE_WIN_W + 2] - subpix_ptr[j - REFINE_WIN_W - 2];\n"
"                float gxx = tgx * tgx * m;\n"
"                float gxy = tgx * tgy * m;\n"
"                float gyy = tgy * tgy * m;\n"
"                float px = j - REFINE_WIN_HALF_W;\n"
"\n"
"                a += gxx;\n"
"                b += gxy;\n"
"                c += gyy;\n"
"\n"
"                bb1 += gxx * px + gxy * py;\n"
"                bb2 += gxy * px + gyy * py;\n"
"            }\n"
"        }\n"
"\n"
"        float det = a * c - b * b;\n"
"        if (fabs(det) <= flt_epsilon * flt_epsilon) {\n"
"            break;\n"
"        }\n"
"\n"
"        // 2x2 matrix inversion\n"
"        float scale = 1.0f / det;\n"
"        feature_tmp.x = (float)(feature.x + (c * scale * bb1) - (b * scale * bb2));\n"
"        feature_tmp.y = (float)(feature.y - (b * scale * bb1) + (a * scale * bb2));\n"
"        err = dot(feature_tmp - feature, feature_tmp - feature);\n"
"\n"
"        feature = feature_tmp;\n"
"        if (feature.x < 0 || feature.x >= src_width || feature.y < 0 || feature.y >= src_height) {\n"
"            break;\n"
"        }\n"
"    } while (++iter < max_iters && err > eps);\n"
"\n"
"    // Make sure new point isn't too far from the initial point (indicates poor convergence)\n"
"    if (fabs(feature.x - init.x) > REFINE_WIN_HALF_W || fabs(feature.y - init.y) > REFINE_WIN_HALF_H) {\n"
"        feature = init;\n"
"    }\n"
"\n"
"    return feature;\n"
"}\n"
"\n"
"// Performs non-maximum suppression on the harris response and writes the resulting\n"
"// feature locations to refined_features.\n"
"//\n"
"// Assumes that refined_features and the global work sizes are set up such that the image\n"
"// is split up into a grid of 32x32 blocks where each block has a single slot in the\n"
"// refined_features buffer. This kernel finds the best corner in each block (if the\n"
"// block has any) and writes it to the corresponding slot in the buffer.\n"
"//\n"
"// If subpixel_refine is true, the features are additionally refined at a sub-pixel\n"
"// level for increased precision.\n"
"__kernel void refine_features(\n"
"    __read_only image2d_t grayscale,\n"
"    __global const float *harris_buf,\n"
"    __global float2 *refined_features,\n"
"    int subpixel_refine\n"
") {\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"    // The location in the grayscale buffer rather than the compacted grid\n"
"    int2 loc_i = (int2)(loc.x * 32, loc.y * 32);\n"
"\n"
"    float new_val;\n"
"    float max_val = 0;\n"
"    float2 loc_max = (float2)(-1, -1);\n"
"\n"
"    int end_x = min(loc_i.x + 32, (int)get_image_dim(grayscale).x - 1);\n"
"    int end_y = min(loc_i.y + 32, (int)get_image_dim(grayscale).y - 1);\n"
"\n"
"    for (int i = loc_i.x; i < end_x; ++i) {\n"
"        for (int j = loc_i.y; j < end_y; ++j) {\n"
"            new_val = harris_buf[i + j * get_image_dim(grayscale).x];\n"
"\n"
"            if (new_val > max_val) {\n"
"                max_val = new_val;\n"
"                loc_max = (float2)(i, j);\n"
"            }\n"
"        }\n"
"    }\n"
"\n"
"    if (max_val == 0) {\n"
"        // There are no features in this part of the frame\n"
"        write_to_1d_arrf2(refined_features, loc, loc_max);\n"
"        return;\n"
"    }\n"
"\n"
"    if (subpixel_refine) {\n"
"        float mask[REFINE_WIN_H * REFINE_WIN_W];\n"
"        for (int i = 0; i < REFINE_WIN_H; i++) {\n"
"            float y = (float)(i - REFINE_WIN_HALF_H) / REFINE_WIN_HALF_H;\n"
"            float vy = exp(-y * y);\n"
"\n"
"            for (int j = 0; j < REFINE_WIN_W; j++) {\n"
"                float x = (float)(j - REFINE_WIN_HALF_W) / REFINE_WIN_HALF_W;\n"
"                mask[i * REFINE_WIN_W + j] = (float)(vy * exp(-x * x));\n"
"            }\n"
"        }\n"
"\n"
"        loc_max = corner_sub_pix(grayscale, loc_max, mask);\n"
"    }\n"
"\n"
"    write_to_1d_arrf2(refined_features, loc, loc_max);\n"
"}\n"
"\n"
"// Extracts BRIEF descriptors from the grayscale src image for the given features\n"
"// using the provided sampler.\n"
"__kernel void brief_descriptors(\n"
"    __read_only image2d_t grayscale,\n"
"    __global const float2 *refined_features,\n"
"    // for 512 bit descriptors\n"
"    __global ulong8 *desc_buf,\n"
"    __global const PointPair *brief_pattern\n"
") {\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"    float2 feature = read_from_1d_arrf2(refined_features, loc);\n"
"\n"
"    // There was no feature in this part of the frame\n"
"    if (feature.x == -1) {\n"
"        write_to_1d_arrul8(desc_buf, loc, (ulong8)(0));\n"
"        return;\n"
"    }\n"
"\n"
"    ulong8 desc = 0;\n"
"    ulong *p = &desc;\n"
"\n"
"    for (int i = 0; i < 8; ++i) {\n"
"        for (int j = 0; j < 64; ++j) {\n"
"            PointPair pair = brief_pattern[j * (i + 1)];\n"
"            float l1 = read_imagef(grayscale, sampler_linear, feature + pair.p1).x;\n"
"            float l2 = read_imagef(grayscale, sampler_linear, feature + pair.p2).x;\n"
"\n"
"            if (l1 < l2) {\n"
"                p[i] |= 1UL << j;\n"
"            }\n"
"        }\n"
"    }\n"
"\n"
"    write_to_1d_arrul8(desc_buf, loc, desc);\n"
"}\n"
"\n"
"// Given buffers with descriptors for the current and previous frame, determines\n"
"// which ones match, writing correspondences to matches_buf.\n"
"//\n"
"// Feature and descriptor buffers are assumed to be compacted (each element sourced\n"
"// from a 32x32 block in the frame being processed).\n"
"__kernel void match_descriptors(\n"
"    __global const float2 *prev_refined_features,\n"
"    __global const float2 *refined_features,\n"
"    __global const ulong8 *desc_buf,\n"
"    __global const ulong8 *prev_desc_buf,\n"
"    __global MotionVector *matches_buf\n"
") {\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"    ulong8 desc = read_from_1d_arrul8(desc_buf, loc);\n"
"    const int search_radius = 3;\n"
"\n"
"    MotionVector invalid_vector = (MotionVector) {\n"
"        (PointPair) {\n"
"            (float2)(-1, -1),\n"
"            (float2)(-1, -1)\n"
"        },\n"
"        0\n"
"    };\n"
"\n"
"    if (desc.s0 == 0 && desc.s1 == 0) {\n"
"        // There was no feature in this part of the frame\n"
"        write_to_1d_arrvec(\n"
"            matches_buf,\n"
"            loc,\n"
"            invalid_vector\n"
"        );\n"
"        return;\n"
"    }\n"
"\n"
"    int2 start = max(loc - search_radius, 0);\n"
"    int2 end = min(loc + search_radius, (int2)(get_global_size(0) - 1, get_global_size(1) - 1));\n"
"\n"
"    for (int i = start.x; i < end.x; ++i) {\n"
"        for (int j = start.y; j < end.y; ++j) {\n"
"            int2 prev_point = (int2)(i, j);\n"
"            int total_dist = 0;\n"
"\n"
"            ulong8 prev_desc = read_from_1d_arrul8(prev_desc_buf, prev_point);\n"
"\n"
"            if (prev_desc.s0 == 0 && prev_desc.s1 == 0) {\n"
"                continue;\n"
"            }\n"
"\n"
"            ulong *prev_desc_p = &prev_desc;\n"
"            ulong *desc_p = &desc;\n"
"\n"
"            for (int i = 0; i < 8; i++) {\n"
"                total_dist += popcount(desc_p[i] ^ prev_desc_p[i]);\n"
"            }\n"
"\n"
"            if (total_dist < DISTANCE_THRESHOLD) {\n"
"                write_to_1d_arrvec(\n"
"                    matches_buf,\n"
"                    loc,\n"
"                    (MotionVector) {\n"
"                        (PointPair) {\n"
"                            read_from_1d_arrf2(prev_refined_features, prev_point),\n"
"                            read_from_1d_arrf2(refined_features, loc)\n"
"                        },\n"
"                        1\n"
"                    }\n"
"                );\n"
"\n"
"                return;\n"
"            }\n"
"        }\n"
"    }\n"
"\n"
"    // There is no found match for this point\n"
"    write_to_1d_arrvec(\n"
"        matches_buf,\n"
"        loc,\n"
"        invalid_vector\n"
"    );\n"
"}\n"
"\n"
"// Returns the position of the given point after the transform is applied\n"
"static float2 transformed_point(float2 p, __global const float *transform) {\n"
"    float2 ret;\n"
"\n"
"    ret.x = p.x * transform[0] + p.y * transform[1] + transform[2];\n"
"    ret.y = p.x * transform[3] + p.y * transform[4] + transform[5];\n"
"\n"
"    return ret;\n"
"}\n"
"\n"
"\n"
"// Performs the given transform on the src image\n"
"__kernel void transform(\n"
"    __read_only image2d_t src,\n"
"    __write_only image2d_t dst,\n"
"    __global const float *transform\n"
") {\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"    float2 norm = convert_float2(get_image_dim(src));\n"
"\n"
"    write_imagef(\n"
"        dst,\n"
"        loc,\n"
"        read_imagef(\n"
"            src,\n"
"            sampler_linear_mirror,\n"
"            transformed_point((float2)(loc.x, loc.y), transform) / norm\n"
"        )\n"
"    );\n"
"}\n"
"\n"
"// Returns the new location of the given point using the given crop bounding box\n"
"// and the width and height of the original frame.\n"
"static float2 cropped_point(\n"
"    float2 p,\n"
"    float2 top_left,\n"
"    float2 bottom_right,\n"
"    int2 orig_dim\n"
") {\n"
"    float2 ret;\n"
"\n"
"    float crop_width  = bottom_right.x - top_left.x;\n"
"    float crop_height = bottom_right.y - top_left.y;\n"
"\n"
"    float width_norm = p.x / (float)orig_dim.x;\n"
"    float height_norm = p.y / (float)orig_dim.y;\n"
"\n"
"    ret.x = (width_norm * crop_width) + top_left.x;\n"
"    ret.y = (height_norm * crop_height) + ((float)orig_dim.y - bottom_right.y);\n"
"\n"
"    return ret;\n"
"}\n"
"\n"
"// Upscales the given cropped region to the size of the original frame\n"
"__kernel void crop_upscale(\n"
"    __read_only image2d_t src,\n"
"    __write_only image2d_t dst,\n"
"    float2 top_left,\n"
"    float2 bottom_right\n"
") {\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    write_imagef(\n"
"        dst,\n"
"        loc,\n"
"        read_imagef(\n"
"            src,\n"
"            sampler_linear,\n"
"            cropped_point((float2)(loc.x, loc.y), top_left, bottom_right, get_image_dim(dst))\n"
"        )\n"
"    );\n"
"}\n"
"\n"
"// Draws boxes to represent the given point matches and uses the given transform\n"
"// and crop info to make sure their positions are accurate on the transformed frame.\n"
"//\n"
"// model_matches is an array of three points that were used by the RANSAC process\n"
"// to generate the given transform\n"
"__kernel void draw_debug_info(\n"
"    __write_only image2d_t dst,\n"
"    __global const MotionVector *matches,\n"
"    __global const MotionVector *model_matches,\n"
"    int num_model_matches,\n"
"    __global const float *transform\n"
") {\n"
"    int loc = get_global_id(0);\n"
"    MotionVector vec = matches[loc];\n"
"    // Black box: matched point that RANSAC considered an outlier\n"
"    float4 big_rect_color = (float4)(0.1f, 0.1f, 0.1f, 1.0f);\n"
"\n"
"    if (vec.should_consider) {\n"
"        // Green box: matched point that RANSAC considered an inlier\n"
"        big_rect_color = (float4)(0.0f, 1.0f, 0.0f, 1.0f);\n"
"    }\n"
"\n"
"    for (int i = 0; i < num_model_matches; i++) {\n"
"        if (vec.p.p2.x == model_matches[i].p.p2.x && vec.p.p2.y == model_matches[i].p.p2.y) {\n"
"            // Orange box: point used to calculate model\n"
"            big_rect_color = (float4)(1.0f, 0.5f, 0.0f, 1.0f);\n"
"        }\n"
"    }\n"
"\n"
"    float2 transformed_p1 = transformed_point(vec.p.p1, transform);\n"
"    float2 transformed_p2 = transformed_point(vec.p.p2, transform);\n"
"\n"
"    draw_box(dst, (int2)(transformed_p2.x, transformed_p2.y), big_rect_color, 5);\n"
"    // Small light blue box: the point in the previous frame\n"
"    draw_box(dst, (int2)(transformed_p1.x, transformed_p1.y), (float4)(0.0f, 0.3f, 0.7f, 1.0f), 3);\n"
"}\n"
;
