/* tracker-remote.c generated by valac 0.56.1, the Vala compiler
 * generated from tracker-remote.vala, do not modify */

/*
 * Copyright (C) 2016 Carlos Garnacho <carlosg@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Carlos Garnacho <carlosg@gnome.org>
 */

#include "tracker-remote.h"
#include "libtracker-sparql/tracker-generated-no-checks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <libsoup/soup.h>

#define TRACKER_REMOTE_CONNECTION_XML_TYPE "application/sparql-results+xml"
#define TRACKER_REMOTE_CONNECTION_JSON_TYPE "application/sparql-results+json"

enum  {
	TRACKER_REMOTE_CONNECTION_0_PROPERTY,
	TRACKER_REMOTE_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* tracker_remote_connection_properties[TRACKER_REMOTE_CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
typedef struct _TrackerRemoteConnectionQueryAsyncData TrackerRemoteConnectionQueryAsyncData;

struct _TrackerRemoteConnectionQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerRemoteConnection* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	SoupMessage* message;
	SoupMessage* _tmp0_;
	SoupSession* _tmp1_;
	SoupMessage* _tmp2_;
	GInputStream* _tmp3_;
	GInputStream* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	SoupMessage* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	TrackerSparqlCursor* _tmp8_;
	GError* _inner_error0_;
};

static gpointer tracker_remote_connection_parent_class = NULL;

static SoupMessage* tracker_remote_connection_create_request (TrackerRemoteConnection* self,
                                                       const gchar* sparql);
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
static TrackerSparqlCursor* tracker_remote_connection_create_cursor (TrackerRemoteConnection* self,
                                                              SoupMessage* message,
                                                              GError** error);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static TrackerSparqlCursor* tracker_remote_connection_real_query (TrackerSparqlConnection* base,
                                                           const gchar* sparql,
                                                           GCancellable* cancellable,
                                                           GError** error);
static void tracker_remote_connection_real_query_async_data_free (gpointer _data);
static void tracker_remote_connection_real_query_async (TrackerSparqlConnection* base,
                                                 const gchar* sparql,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean tracker_remote_connection_real_query_async_co (TrackerRemoteConnectionQueryAsyncData* _data_);
static void tracker_remote_connection_query_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void tracker_remote_connection_finalize (GObject * obj);
static GType tracker_remote_connection_get_type_once (void);

TrackerRemoteConnection*
tracker_remote_connection_construct (GType object_type,
                                     const gchar* base_uri)
{
	TrackerRemoteConnection * self = NULL;
	gchar* _tmp0_;
	SoupSession* _tmp1_;
#line 29 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (base_uri != NULL, NULL);
#line 29 "../tracker/src/libtracker-remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) tracker_sparql_connection_construct (object_type);
#line 30 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp0_ = g_strdup (base_uri);
#line 30 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (self->_base_uri);
#line 30 "../tracker/src/libtracker-remote/tracker-remote.vala"
	self->_base_uri = _tmp0_;
#line 31 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp1_ = soup_session_new ();
#line 31 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (self->_session);
#line 31 "../tracker/src/libtracker-remote/tracker-remote.vala"
	self->_session = _tmp1_;
#line 29 "../tracker/src/libtracker-remote/tracker-remote.vala"
	return self;
#line 122 "tracker-remote.c"
}

TrackerRemoteConnection*
tracker_remote_connection_new (const gchar* base_uri)
{
#line 29 "../tracker/src/libtracker-remote/tracker-remote.vala"
	return tracker_remote_connection_construct (TRACKER_REMOTE_TYPE_CONNECTION, base_uri);
#line 130 "tracker-remote.c"
}

static SoupMessageHeaders*
_vala_SoupMessageHeaders_copy (SoupMessageHeaders* self)
{
#line 37 "../tracker/src/libtracker-remote/tracker-remote.vala"
	return g_boxed_copy (soup_message_headers_get_type (), self);
#line 138 "tracker-remote.c"
}

static gpointer
__vala_SoupMessageHeaders_copy0 (gpointer self)
{
#line 37 "../tracker/src/libtracker-remote/tracker-remote.vala"
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
#line 146 "tracker-remote.c"
}

static void
_vala_SoupMessageHeaders_free (SoupMessageHeaders* self)
{
#line 42 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_boxed_free (soup_message_headers_get_type (), self);
#line 154 "tracker-remote.c"
}

static SoupMessage*
tracker_remote_connection_create_request (TrackerRemoteConnection* self,
                                          const gchar* sparql)
{
	gchar* uri = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	SoupMessage* message = NULL;
	SoupMessage* _tmp2_;
	SoupMessageHeaders* headers = NULL;
	SoupMessageHeaders* _tmp3_;
	SoupMessageHeaders* _tmp4_;
	SoupMessage* result;
#line 34 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 35 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp0_ = self->_base_uri;
#line 35 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp1_ = g_strconcat (_tmp0_, sparql, NULL);
#line 35 "../tracker/src/libtracker-remote/tracker-remote.vala"
	uri = _tmp1_;
#line 36 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp2_ = soup_message_new ("GET", uri);
#line 36 "../tracker/src/libtracker-remote/tracker-remote.vala"
	message = _tmp2_;
#line 37 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp3_ = message->request_headers;
#line 37 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp4_ = __vala_SoupMessageHeaders_copy0 (_tmp3_);
#line 37 "../tracker/src/libtracker-remote/tracker-remote.vala"
	headers = _tmp4_;
#line 39 "../tracker/src/libtracker-remote/tracker-remote.vala"
	soup_message_headers_append (headers, "Accept", TRACKER_REMOTE_CONNECTION_JSON_TYPE);
#line 40 "../tracker/src/libtracker-remote/tracker-remote.vala"
	soup_message_headers_append (headers, "Accept", TRACKER_REMOTE_CONNECTION_XML_TYPE);
#line 42 "../tracker/src/libtracker-remote/tracker-remote.vala"
	result = message;
#line 42 "../tracker/src/libtracker-remote/tracker-remote.vala"
	__vala_SoupMessageHeaders_free0 (headers);
#line 42 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (uri);
#line 42 "../tracker/src/libtracker-remote/tracker-remote.vala"
	return result;
#line 202 "tracker-remote.c"
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
#line 46 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_boxed_free (soup_buffer_get_type (), self);
#line 210 "tracker-remote.c"
}

static TrackerSparqlCursor*
tracker_remote_connection_create_cursor (TrackerRemoteConnection* self,
                                         SoupMessage* message,
                                         GError** error)
{
	gchar* document = NULL;
	SoupMessageBody* _tmp0_;
	SoupBuffer* _tmp1_;
	SoupBuffer* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	SoupMessageHeaders* headers = NULL;
	SoupMessageHeaders* _tmp12_;
	SoupMessageHeaders* _tmp13_;
	gchar* content_type = NULL;
	SoupMessageHeaders* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	glong length = 0L;
	const gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	const gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlCursor* result;
#line 45 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 46 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp0_ = message->response_body;
#line 46 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp1_ = soup_message_body_flatten (_tmp0_);
#line 46 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp2_ = _tmp1_;
#line 46 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp3_ = _tmp2_->data;
#line 46 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp3__length1 = _tmp2_->length;
#line 46 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 46 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp5_ = _tmp4_;
#line 46 "../tracker/src/libtracker-remote/tracker-remote.vala"
	__vala_SoupBuffer_free0 (_tmp2_);
#line 46 "../tracker/src/libtracker-remote/tracker-remote.vala"
	document = _tmp5_;
#line 48 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_object_get (message, "status-code", &_tmp6_, NULL);
#line 48 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp7_ = _tmp6_;
#line 48 "../tracker/src/libtracker-remote/tracker-remote.vala"
	if (_tmp7_ != ((guint) SOUP_STATUS_OK)) {
#line 270 "tracker-remote.c"
		guint _tmp8_;
		guint _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
#line 49 "../tracker/src/libtracker-remote/tracker-remote.vala"
		g_object_get (message, "status-code", &_tmp8_, NULL);
#line 49 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp9_ = _tmp8_;
#line 49 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp10_ = document;
#line 49 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp11_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Unhandled status code %u, document is: %s", _tmp9_, _tmp10_);
#line 49 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_inner_error0_ = _tmp11_;
#line 49 "../tracker/src/libtracker-remote/tracker-remote.vala"
		g_propagate_error (error, _inner_error0_);
#line 49 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_g_free0 (document);
#line 49 "../tracker/src/libtracker-remote/tracker-remote.vala"
		return NULL;
#line 291 "tracker-remote.c"
	}
#line 53 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp12_ = message->response_headers;
#line 53 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp13_ = __vala_SoupMessageHeaders_copy0 (_tmp12_);
#line 53 "../tracker/src/libtracker-remote/tracker-remote.vala"
	headers = _tmp13_;
#line 54 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp14_ = headers;
#line 54 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp15_ = soup_message_headers_get_content_type (_tmp14_, NULL);
#line 54 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 54 "../tracker/src/libtracker-remote/tracker-remote.vala"
	content_type = _tmp16_;
#line 55 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp17_ = document;
#line 55 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp18_ = strlen (_tmp17_);
#line 55 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp19_ = _tmp18_;
#line 55 "../tracker/src/libtracker-remote/tracker-remote.vala"
	length = (glong) _tmp19_;
#line 57 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp20_ = content_type;
#line 57 "../tracker/src/libtracker-remote/tracker-remote.vala"
	if (g_strcmp0 (_tmp20_, TRACKER_REMOTE_CONNECTION_JSON_TYPE) == 0) {
#line 319 "tracker-remote.c"
		TrackerRemoteJsonCursor* _tmp21_ = NULL;
		const gchar* _tmp22_;
		TrackerRemoteJsonCursor* _tmp23_;
		TrackerRemoteJsonCursor* _tmp24_;
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp22_ = document;
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp23_ = tracker_remote_json_cursor_new (_tmp22_, length, &_inner_error0_);
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp21_ = _tmp23_;
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
			g_propagate_error (error, _inner_error0_);
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (content_type);
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
			__vala_SoupMessageHeaders_free0 (headers);
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (document);
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
			return NULL;
#line 342 "tracker-remote.c"
		}
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp24_ = _tmp21_;
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp21_ = NULL;
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		result = (TrackerSparqlCursor*) _tmp24_;
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_g_object_unref0 (_tmp21_);
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_g_free0 (content_type);
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		__vala_SoupMessageHeaders_free0 (headers);
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_g_free0 (document);
#line 58 "../tracker/src/libtracker-remote/tracker-remote.vala"
		return result;
#line 360 "tracker-remote.c"
	} else {
		const gchar* _tmp25_;
#line 59 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp25_ = content_type;
#line 59 "../tracker/src/libtracker-remote/tracker-remote.vala"
		if (g_strcmp0 (_tmp25_, TRACKER_REMOTE_CONNECTION_XML_TYPE) == 0) {
#line 367 "tracker-remote.c"
			TrackerRemoteXmlCursor* _tmp26_ = NULL;
			const gchar* _tmp27_;
			TrackerRemoteXmlCursor* _tmp28_;
			TrackerRemoteXmlCursor* _tmp29_;
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp27_ = document;
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp28_ = tracker_remote_xml_cursor_new (_tmp27_, length, &_inner_error0_);
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp26_ = _tmp28_;
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
				g_propagate_error (error, _inner_error0_);
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
				_g_free0 (content_type);
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
				__vala_SoupMessageHeaders_free0 (headers);
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
				_g_free0 (document);
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
				return NULL;
#line 390 "tracker-remote.c"
			}
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp29_ = _tmp26_;
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp26_ = NULL;
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			result = (TrackerSparqlCursor*) _tmp29_;
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_g_object_unref0 (_tmp26_);
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (content_type);
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			__vala_SoupMessageHeaders_free0 (headers);
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (document);
#line 60 "../tracker/src/libtracker-remote/tracker-remote.vala"
			return result;
#line 408 "tracker-remote.c"
		} else {
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			GError* _tmp32_;
#line 62 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp30_ = content_type;
#line 62 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp31_ = document;
#line 62 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp32_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Unknown content type '%s', document is: %s", _tmp30_, _tmp31_);
#line 62 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_inner_error0_ = _tmp32_;
#line 62 "../tracker/src/libtracker-remote/tracker-remote.vala"
			g_propagate_error (error, _inner_error0_);
#line 62 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (content_type);
#line 62 "../tracker/src/libtracker-remote/tracker-remote.vala"
			__vala_SoupMessageHeaders_free0 (headers);
#line 62 "../tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (document);
#line 62 "../tracker/src/libtracker-remote/tracker-remote.vala"
			return NULL;
#line 431 "tracker-remote.c"
		}
	}
}

static TrackerSparqlCursor*
tracker_remote_connection_real_query (TrackerSparqlConnection* base,
                                      const gchar* sparql,
                                      GCancellable* cancellable,
                                      GError** error)
{
	TrackerRemoteConnection * self;
	SoupMessage* message = NULL;
	SoupMessage* _tmp0_;
	SoupSession* _tmp1_;
	SoupMessage* _tmp2_;
	gboolean _tmp3_ = FALSE;
	TrackerSparqlCursor* _tmp5_ = NULL;
	SoupMessage* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	TrackerSparqlCursor* _tmp8_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlCursor* result;
#line 66 "../tracker/src/libtracker-remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) base;
#line 66 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 67 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp0_ = tracker_remote_connection_create_request (self, sparql);
#line 67 "../tracker/src/libtracker-remote/tracker-remote.vala"
	message = _tmp0_;
#line 69 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp1_ = self->_session;
#line 69 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp2_ = message;
#line 69 "../tracker/src/libtracker-remote/tracker-remote.vala"
	soup_session_send_message (_tmp1_, _tmp2_);
#line 71 "../tracker/src/libtracker-remote/tracker-remote.vala"
	if (cancellable != NULL) {
#line 71 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp3_ = g_cancellable_is_cancelled (cancellable);
#line 472 "tracker-remote.c"
	} else {
#line 71 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp3_ = FALSE;
#line 476 "tracker-remote.c"
	}
#line 71 "../tracker/src/libtracker-remote/tracker-remote.vala"
	if (_tmp3_) {
#line 480 "tracker-remote.c"
		GError* _tmp4_;
#line 72 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp4_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 72 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_inner_error0_ = _tmp4_;
#line 72 "../tracker/src/libtracker-remote/tracker-remote.vala"
		g_propagate_error (error, _inner_error0_);
#line 72 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_g_object_unref0 (message);
#line 72 "../tracker/src/libtracker-remote/tracker-remote.vala"
		return NULL;
#line 492 "tracker-remote.c"
	}
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp6_ = message;
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp7_ = tracker_remote_connection_create_cursor (self, _tmp6_, &_inner_error0_);
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp5_ = _tmp7_;
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
		g_propagate_error (error, _inner_error0_);
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_g_object_unref0 (message);
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
		return NULL;
#line 508 "tracker-remote.c"
	}
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp8_ = _tmp5_;
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp5_ = NULL;
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
	result = _tmp8_;
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_tmp5_);
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (message);
#line 74 "../tracker/src/libtracker-remote/tracker-remote.vala"
	return result;
#line 522 "tracker-remote.c"
}

static void
tracker_remote_connection_real_query_async_data_free (gpointer _data)
{
	TrackerRemoteConnectionQueryAsyncData* _data_;
	_data_ = _data;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (_data_->sparql);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->result);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->self);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_slice_free (TrackerRemoteConnectionQueryAsyncData, _data_);
#line 540 "tracker-remote.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	return self ? g_object_ref (self) : NULL;
#line 548 "tracker-remote.c"
}

static void
tracker_remote_connection_real_query_async (TrackerSparqlConnection* base,
                                            const gchar* sparql,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	TrackerRemoteConnection * self;
	TrackerRemoteConnectionQueryAsyncData* _data_;
	TrackerRemoteConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_if_fail (sparql != NULL);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) base;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_ = g_slice_new0 (TrackerRemoteConnectionQueryAsyncData);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_remote_connection_real_query_async_data_free);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->self = _tmp0_;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp1_ = g_strdup (sparql);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (_data_->sparql);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->sparql = _tmp1_;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->cancellable = _tmp2_;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	tracker_remote_connection_real_query_async_co (_data_);
#line 591 "tracker-remote.c"
}

static TrackerSparqlCursor*
tracker_remote_connection_query_finish (TrackerSparqlConnection* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	TrackerSparqlCursor* result;
	TrackerRemoteConnectionQueryAsyncData* _data_;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	if (NULL == _data_) {
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
		return NULL;
#line 607 "tracker-remote.c"
	}
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	result = _data_->result;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->result = NULL;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	return result;
#line 615 "tracker-remote.c"
}

static void
tracker_remote_connection_query_async_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	TrackerRemoteConnectionQueryAsyncData* _data_;
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_ = _user_data_;
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_source_object_ = source_object;
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_res_ = _res_;
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	tracker_remote_connection_real_query_async_co (_data_);
#line 632 "tracker-remote.c"
}

static gboolean
tracker_remote_connection_real_query_async_co (TrackerRemoteConnectionQueryAsyncData* _data_)
{
#line 77 "../tracker/src/libtracker-remote/tracker-remote.vala"
	switch (_data_->_state_) {
#line 77 "../tracker/src/libtracker-remote/tracker-remote.vala"
		case 0:
#line 642 "tracker-remote.c"
		goto _state_0;
#line 77 "../tracker/src/libtracker-remote/tracker-remote.vala"
		case 1:
#line 646 "tracker-remote.c"
		goto _state_1;
		default:
#line 77 "../tracker/src/libtracker-remote/tracker-remote.vala"
		g_assert_not_reached ();
#line 651 "tracker-remote.c"
	}
	_state_0:
#line 78 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp0_ = tracker_remote_connection_create_request (_data_->self, _data_->sparql);
#line 78 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->message = _data_->_tmp0_;
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp1_ = _data_->self->_session;
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp2_ = _data_->message;
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_state_ = 1;
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	soup_session_send_async (_data_->_tmp1_, _data_->_tmp2_, _data_->cancellable, tracker_remote_connection_query_async_ready, _data_);
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	return FALSE;
#line 668 "tracker-remote.c"
	_state_1:
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp3_ = soup_session_send_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->_tmp4_);
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_g_object_unref0 (_data_->message);
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
		g_object_unref (_data_->_async_result);
#line 80 "../tracker/src/libtracker-remote/tracker-remote.vala"
		return FALSE;
#line 686 "tracker-remote.c"
	}
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp6_ = _data_->message;
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp7_ = tracker_remote_connection_create_cursor (_data_->self, _data_->_tmp6_, &_data_->_inner_error0_);
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp5_ = _data_->_tmp7_;
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
		_g_object_unref0 (_data_->message);
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
		g_object_unref (_data_->_async_result);
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
		return FALSE;
#line 704 "tracker-remote.c"
	}
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp8_ = _data_->_tmp5_;
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp5_ = NULL;
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->result = _data_->_tmp8_;
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->_tmp5_);
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->message);
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	if (_data_->_state_ != 0) {
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 724 "tracker-remote.c"
		}
	}
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	g_object_unref (_data_->_async_result);
#line 82 "../tracker/src/libtracker-remote/tracker-remote.vala"
	return FALSE;
#line 731 "tracker-remote.c"
}

static void
tracker_remote_connection_class_init (TrackerRemoteConnectionClass * klass,
                                      gpointer klass_data)
{
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	tracker_remote_connection_parent_class = g_type_class_peek_parent (klass);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_remote_connection_real_query;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->query_async = (void (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_remote_connection_real_query_async;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->query_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_remote_connection_query_finish;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_remote_connection_finalize;
#line 748 "tracker-remote.c"
}

static void
tracker_remote_connection_instance_init (TrackerRemoteConnection * self,
                                         gpointer klass)
{
}

static void
tracker_remote_connection_finalize (GObject * obj)
{
	TrackerRemoteConnection * self;
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_REMOTE_TYPE_CONNECTION, TrackerRemoteConnection);
#line 23 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (self->_session);
#line 24 "../tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (self->_base_uri);
#line 22 "../tracker/src/libtracker-remote/tracker-remote.vala"
	G_OBJECT_CLASS (tracker_remote_connection_parent_class)->finalize (obj);
#line 769 "tracker-remote.c"
}

static GType
tracker_remote_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerRemoteConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_remote_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerRemoteConnection), 0, (GInstanceInitFunc) tracker_remote_connection_instance_init, NULL };
	GType tracker_remote_connection_type_id;
	tracker_remote_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerRemoteConnection", &g_define_type_info, 0);
	return tracker_remote_connection_type_id;
}

GType
tracker_remote_connection_get_type (void)
{
	static volatile gsize tracker_remote_connection_type_id__once = 0;
	if (g_once_init_enter (&tracker_remote_connection_type_id__once)) {
		GType tracker_remote_connection_type_id;
		tracker_remote_connection_type_id = tracker_remote_connection_get_type_once ();
		g_once_init_leave (&tracker_remote_connection_type_id__once, tracker_remote_connection_type_id);
	}
	return tracker_remote_connection_type_id__once;
}

